#!/bin/bash

SCRIPT_REPO="https://gitlab.freedesktop.org/xorg/proto/xorgproto.git"
SCRIPT_COMMIT="d7ea44d5f04cc476dee83ef439a847172f7a6bd1"

ffbuild_enabled() {
    [[ $TARGET != linux* ]] && return -1
    return 0
}

ffbuild_dockerbuild() {
    autoreconf -i

    local myconf=(
        --prefix="$FFBUILD_PREFIX"
    )

    if [[ $TARGET == linux* ]]; then
        myconf+=(
            --host="$FFBUILD_TOOLCHAIN"
        )
    else
        echo "Unknown target"
        return -1
    fi

    ./configure "${myconf[@]}"
    make -j$(nproc)
    make install
}
