# Contributing & Support

We are happy to accept contributions that make `Kashgari` better and more awesome! You could contribute in various ways:

## Bug Reports

1. Please **read the documentation** and **search the issue tracker** to try and find the answer to your question **before** posting an issue.

2. When creating an issue on the repository, please provide as much info as possible:

    - Version being used.
    - Operating system.
    - Version of Python.
    - Errors in console.
    - Detailed description of the problem.
    - Examples for reproducing the error.  You can post pictures, but if specific text or code is required to reproduce the issue, please provide the text in a plain text format for easy copy/paste.

    The more info provided the greater the chance someone will take the time to answer, implement, or fix the issue.

3. Be prepared to answer questions and provide additional information if required.  Issues in which the creator refuses to respond to follow up questions will be marked as stale and closed.

## Reviewing Code

Take part in reviewing pull requests and/or reviewing direct commits.  Make suggestions to improve the code and discuss solutions to overcome weakness in the algorithm.

## Answer Questions in Issues

Take time and answer questions and offer suggestions to people who've created issues in the issue tracker. Often people will have questions that you might have an answer for.  Or maybe you know how to help them accomplish a specific task they are asking about. Feel free to share your experience with others to help them out.

## Pull Requests

Pull requests are welcome, and a great way to help fix bugs and add new features.

### Accuracy Benchmarks

Use Kashgari your own data, and report the F-1 score.

### Adding New Models

New models can be of two basic types:

### Adding New Tasks

Currently, Kashgari can handle text-classification and sequence-labeling tasks. If you want to apply Kashgari for a new task, please submit a request issue and explain why we would consider adding the new task to Kashgari

## Documentation Improvements

A ton of time has been spent not only creating and supporting this tool, but also spent making this documentation. If you feel it is still lacking, show your appreciation for the tool by helping to improve/translate the documentation.

You can build the docs by running this commands in project root folder. Source files are in the `docs` folder.

```bash
pip install -r docs/requirements.txt
python setup.py install
sh ./scripts/docs-live.sh
```
