# [Binari](https://binari.dev) v0.9.0

[![Open Source Helpers](https://www.codetriage.com/brandonarmand/binari/badges/users.svg)](https://www.codetriage.com/brandonarmand/binari)
[![first-timers-only](https://img.shields.io/badge/first--timers--only-friendly-blue.svg?style=flat-square)](https://www.firsttimersonly.com/)
[![Netlify Status](https://api.netlify.com/api/v1/badges/bc927965-8d4c-490b-b2cf-44d05c36b24e/deploy-status)](https://app.netlify.com/sites/binari/deploys)
[![DeepScan grade](https://deepscan.io/api/teams/7989/projects/10120/branches/136074/badge/grade.svg)](https://deepscan.io/dashboard#view=project&tid=7989&pid=10120&bid=136074)

Interactive code editor with a live binary tree visual designed to teach new developers the fundamentals of data structures and algorithms.

### Site Navigation

* [Home](https://binari.dev) - Basic introduction to the application.
* [Playground](https://binari.dev/playground) - The primary learning route. Includes the code editor and canvas.
* [About](https://binari.dev/about) - Application description w/ github API integration for contributor info.

[![Home](https://user-images.githubusercontent.com/27185256/205257676-b8e4eea5-f5a3-414f-b200-942d1ee53a30.png)](https://binari.dev/)
[![Binari](https://user-images.githubusercontent.com/27185256/205258584-61bcd4a3-e025-4338-bcc2-fcad0fcfd4af.png)](https://binari.dev/playground)
[![About](https://user-images.githubusercontent.com/27185256/205262044-a001f03a-3284-4ef0-9689-6d118e5b0e1f.png)](https://binari.dev/playground)

## Built With

* [React](https://reactjs.org) - Front-End Framework.
* [P5](https://p5js.org) - Canvas editor.
* [Material UI Pro](https://demos.creative-tim.com/material-dashboard-pro-react/#/documentation/tutorial) - Design System.

## Contributing
[![Issues](https://img.shields.io/github/issues-raw/brandonarmand/binari?maxAge=25000)](https://github.com/brandonarmand/binari/issues)  
Anyone can help. We welcome first-time contributors, as well as experienced contributors.

There is plenty to do for both developers and designers of every skill level. Check out the issues, or pitch your own ideas.

### Starting points.
- New to open-source? I suggest fixing a spelling error or try doing a [first-timers-only](https://github.com/BrandonArmand/Binari/issues?q=is%3Aissue+is%3Aopen+label%3Afirst-timers-only) issue.
- Expert on all things binary tree? Try [building a lesson](https://github.com/BrandonArmand/Binari/issues/8).
- Designer? Don't be shy, we could use some work with our [designs](https://github.com/BrandonArmand/Binari/issues/7).

### Rules
1. Read the rules!
2. Issues tagged with `first-timers-only` are reserved for new contributors. Let them have a chance.
3. Each pull request should only introduce a single update at a time. Do not reference multiple issues that are unrelated to one-another.
4. Attempt to match the coding style of the project.
5. Adhere to the Code of Conduct, outlined below.

### Setup and Contributing Changes
1) Fork the repo into your GitHub account (available in the top right corner).

2) Clone the forked repo.
```
git clone https://github.com/<yourgithubaccount>/Binari.git
```

3) Navigate to the Binari directory and create/switch to a new branch.
```
cd Binari
git checkout -b <branch-name>
```

4) Make changes to files. To see the changes you are making reflected in the application, run
```
npm install
npm start
```
Build the project.

5) Add the edited files and commit your changes.
```
git add <files>
git commit -m "<add message describing your changes>"
```

6) Push the changes to the remote repo.
```
git push -u origin <branch-name>
```
In the future, you can simply push to this branch by running `git push`.

7) Navigate back to your forked version of the project, where GitHub will ask if you would like to open a Pull Request. Create a PR, adding a description of your changes, the purpose of the changes, and a link to the issue you are solving.

8) Your PR will be reviewed by other members, who will either approve the merge or request changes.

### Contributors

<a href="https://github.com/BrandonArmand/Binari/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=BrandonArmand/Binari" />
</a>

Made with [contrib.rocks](https://contrib.rocks).
              
### Stargazers
[![Stargazers over time](https://starchart.cc/BrandonArmand/Binari.svg?variant=adaptive)](https://starchart.cc/BrandonArmand/Binari)

## Code of Conduct

[CODE_OF_CONDUCT.md](CODE_OF_CONDUCT.md)

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to making participation in our project and
our community a harassment-free experience for everyone, regardless of age, body
size, disability, ethnicity, sex characteristics, gender identity and expression,
level of experience, education, socio-economic status, nationality, personal
appearance, race, religion, or sexual identity and orientation.

## License

This project is licensed under the MIT License - see the [LICENSE.md](LICENSE.md) file for details
