# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))
import os
import shutil
if os.path.exists("_tutorials"):
    shutil.rmtree("_tutorials")
os.makedirs("_tutorials")
os.symlink(
    "../../advertorch_examples/tutorial_attack_defense_bpda_mnist.ipynb",
    "_tutorials/tutorial_attack_defense_bpda_mnist.ipynb")
import sys  # noqa: F401, E402
sys.path.insert(0, os.path.abspath('..'))


# autodoc_mock_imports = [
# 'numpy',
# 'numpy.linalg',
# 'scipy',
# 'scipy.optimize',
# 'scipy.interpolate',
# 'scipy.ndimage',
# 'scipy.ndimage.filters',
# 'tensorflow',
# 'theano',
# 'theano.tensor',
# # 'torch',
# 'torch.nn',
# 'torch.nn.functional',
# 'torch.optim',
# 'torch.nn.modules',
# 'torch.nn.modules.utils',
# 'torch.utils',
# 'torch.utils.model_zoo',
# 'torch.nn.init',
# 'torch.utils.data',
# 'randomstate',
# 'scipy._lib',
# ]

from unittest.mock import Mock  # noqa: F401, E402
# from sphinx.ext.autodoc.importer import _MockObject as Mock
Mock.Module = object
sys.modules['torch'] = Mock()
sys.modules['numpy'] = Mock()
sys.modules['numpy.linalg'] = Mock()
sys.modules['scipy'] = Mock()
sys.modules['scipy.optimize'] = Mock()
sys.modules['scipy.interpolate'] = Mock()
sys.modules['scipy.ndimage'] = Mock()
sys.modules['scipy.ndimage.filters'] = Mock()
sys.modules['tensorflow'] = Mock()
sys.modules['theano'] = Mock()
sys.modules['theano.tensor'] = Mock()
sys.modules['torch'] = Mock()
sys.modules['torch.autograd'] = Mock()
sys.modules['torch.autograd.gradcheck'] = Mock()
sys.modules['torch.distributions'] = Mock()
sys.modules['torch.nn'] = Mock()
sys.modules['torch.nn.functional'] = Mock()
sys.modules['torch.optim'] = Mock()
sys.modules['torch.nn.modules'] = Mock()
sys.modules['torch.nn.modules.utils'] = Mock()
sys.modules['torch.nn.modules.loss'] = Mock()
sys.modules['torch.utils'] = Mock()
sys.modules['torch.utils.model_zoo'] = Mock()
sys.modules['torch.nn.init'] = Mock()
sys.modules['torch.utils.data'] = Mock()
sys.modules['torchvision'] = Mock()
sys.modules['randomstate'] = Mock()
sys.modules['scipy._lib'] = Mock()

# XXX: This import has to be after mock
import advertorch  # noqa: F401, E402


# -- Project information -----------------------------------------------------

project = 'advertorch'
copyright = '2018-present, Royal Bank of Canada.'
author = ''

# The short X.Y version
version = ''
# The full version, including alpha/beta/rc tags
release = ''


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.autosummary',
    'sphinx.ext.doctest',
    'sphinx.ext.coverage',
    'sphinx.ext.mathjax',
    'sphinx.ext.linkcode',
    'nbsphinx',
    'numpydoc',
]

# Add any paths that contain templates here, relative to this directory.
numpydoc_show_class_members = False
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

todo_include_todos = False


# Resolve function for the linkcode extension.
def linkcode_resolve(domain, info):
    def find_source():
        # try to find the file and line number, based on code from numpy:
        # https://github.com/numpy/numpy/blob/master/doc/source/conf.py#L286
        obj = sys.modules[info['module']]
        for part in info['fullname'].split('.'):
            obj = getattr(obj, part)
        import inspect
        import os
        fn = inspect.getsourcefile(obj)
        fn = os.path.relpath(fn, start=os.path.dirname(advertorch.__file__))
        source, lineno = inspect.getsourcelines(obj)
        return fn, lineno, lineno + len(source) - 1

    if domain != 'py' or not info['module']:
        return None
    try:
        filename = 'advertorch/%s#L%d-L%d' % find_source()
    except Exception:
        filename = info['module'].replace('.', '/') + '.py'
    tag = 'master'
    url = "https://github.com/BorealisAI/advertorch/blob/%s/%s"
    return url % (tag, filename)


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
# html_theme = 'alabaster'

if os.environ.get('READTHEDOCS') != 'True':
    try:
        import sphinx_rtd_theme
    except ImportError:
        pass  # assume we have sphinx >= 1.3
    else:
        html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]
    html_theme = 'sphinx_rtd_theme'



# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
# html_theme = 'alabaster'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
# html_static_path = ['_static']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}


# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'advertorch_testdoc'


# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    'preamble': '',

    # Latex figure (float) alignment
    #
    'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
# latex_documents = [
#     (master_doc, 'advertorch_test.tex', 'advertorch\\_test Documentation',
#      'tracy', 'manual'),
# ]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
# man_pages = [
#     (master_doc, 'advertorch_test', 'advertorch_test Documentation',
#      [author], 1)
# ]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
# texinfo_documents = [
#     (master_doc, 'advertorch_test', 'advertorch_test Documentation',
#      author, 'advertorch_test', 'One line description of project.',
#      'Miscellaneous'),
# ]


# -- Options for Epub output -------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ['search.html']


# -- Extension configuration -------------------------------------------------

# -- Options for intersphinx extension ---------------------------------------

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {'https://docs.python.org/': None}

# -- Options for todo extension ----------------------------------------------

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True
