/** @jsx h */
import { h } from "preact";

export function ThumbsUpIcon(props: {
    class?: string | h.JSX.SignalLike<string | undefined> | undefined;
    style?:
        | string
        | h.JSX.CSSProperties
        | h.JSX.SignalLike<string | h.JSX.CSSProperties>
        | undefined;
}) {
    return (
        <svg
            class={props.class}
            style={props.style}
            viewBox="0 0 32 32"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <path
                d="M29.25 10.015C28.9684 9.69591 28.6222 9.44037 28.2342 9.26537C27.8463 9.09037 27.4256 8.99991 27 9H20V7C20 5.67392 19.4732 4.40215 18.5355 3.46447C17.5979 2.52678 16.3261 2 15 2C14.8142 1.99987 14.6321 2.05149 14.474 2.14908C14.3159 2.24667 14.1881 2.38636 14.105 2.5525L9.3825 12H4C3.46957 12 2.96086 12.2107 2.58579 12.5858C2.21071 12.9609 2 13.4696 2 14V25C2 25.5304 2.21071 26.0391 2.58579 26.4142C2.96086 26.7893 3.46957 27 4 27H25.5C26.2309 27.0003 26.9367 26.7337 27.485 26.2503C28.0332 25.767 28.3861 25.1001 28.4775 24.375L29.9775 12.375C30.0307 11.9525 29.9933 11.5236 29.8679 11.1167C29.7424 10.7098 29.5318 10.3342 29.25 10.015ZM4 14H9V25H4V14ZM27.9925 12.125L26.4925 24.125C26.462 24.3667 26.3444 24.589 26.1617 24.7501C25.9789 24.9112 25.7436 25.0001 25.5 25H11V13.2362L15.5887 4.0575C16.2689 4.19362 16.8808 4.5612 17.3204 5.09768C17.76 5.63416 18.0002 6.3064 18 7V10C18 10.2652 18.1054 10.5196 18.2929 10.7071C18.4804 10.8946 18.7348 11 19 11H27C27.1419 11 27.2822 11.0301 27.4115 11.0885C27.5409 11.1468 27.6563 11.232 27.7502 11.3384C27.8441 11.4448 27.9143 11.57 27.956 11.7056C27.9978 11.8413 28.0102 11.9842 27.9925 12.125Z"
                fill="currentColor"
            />
        </svg>
    );
}
