/** @jsx h */
import { h } from "preact";

export function SocialIcon(props: {
    class?: string | h.JSX.SignalLike<string | undefined> | undefined;
    style?:
        | string
        | h.JSX.CSSProperties
        | h.JSX.SignalLike<string | h.JSX.CSSProperties>
        | undefined;
}) {
    return (
        <svg
            class={props.class}
            style={props.style}
            viewBox="0 0 32 32"
            xmlns="http://www.w3.org/2000/svg"
        >
            <g id="globe-04">
                <path
                    d="M4.10127 9.9771L9.81866 14.0609C10.1162 14.2734 10.2649 14.3796 10.4206 14.4041C10.5576 14.4256 10.6979 14.4039 10.8219 14.342C10.9629 14.2716 11.0726 14.1254 11.292 13.8329L12.5001 12.222C12.5621 12.1393 12.5932 12.098 12.6296 12.0623C12.662 12.0306 12.6975 12.0023 12.7356 11.9778C12.7785 11.9503 12.8258 11.9293 12.9202 11.8873L18.0784 9.59479C18.2922 9.49976 18.3991 9.45224 18.4797 9.37803C18.551 9.3124 18.6071 9.23201 18.6442 9.14246C18.6861 9.04121 18.6939 8.92448 18.7094 8.69101L19.0871 3.02588M18 18L21.488 19.4949C21.8927 19.6683 22.095 19.755 22.2022 19.8991C22.2962 20.0254 22.3425 20.181 22.3327 20.3382C22.3216 20.5175 22.1995 20.7006 21.9553 21.067L20.3166 23.525C20.2008 23.6987 20.1429 23.7855 20.0665 23.8484C19.9988 23.904 19.9207 23.9458 19.8369 23.9713C19.7422 24 19.6378 24 19.4291 24H16.7688C16.4923 24 16.3541 24 16.2365 23.9538C16.1326 23.9129 16.0406 23.8466 15.969 23.761C15.888 23.6641 15.8443 23.5329 15.7568 23.2707L14.8063 20.4192C14.7548 20.2645 14.729 20.1871 14.7222 20.1085C14.7162 20.0388 14.7212 19.9686 14.737 19.9004C14.7548 19.8236 14.7913 19.7507 14.8642 19.6048L15.5862 18.1608C15.7329 17.8674 15.8063 17.7207 15.9193 17.6296C16.0188 17.5493 16.1394 17.4994 16.2665 17.4858C16.4108 17.4703 16.5664 17.5221 16.8776 17.6259L18 18ZM29.3333 16C29.3333 23.3638 23.3637 29.3333 16 29.3333C8.63616 29.3333 2.66663 23.3638 2.66663 16C2.66663 8.63621 8.63616 2.66667 16 2.66667C23.3637 2.66667 29.3333 8.63621 29.3333 16Z"
                    stroke-width="2.67"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                />
            </g>
        </svg>
    );
}
