/** @jsx h */
import { h } from "preact";

export function InviteIcon(props: {
    class?: string | h.JSX.SignalLike<string | undefined> | undefined;
    style?:
        | string
        | h.JSX.CSSProperties
        | h.JSX.SignalLike<string | h.JSX.CSSProperties>
        | undefined;
}) {
    return (
        <svg
            class={props.class}
            style={props.style}
            viewBox="0 0 1000 1000"
            version="1.1"
            xmlns="http://www.w3.org/2000/svg"
            enable-background="new 0 0 1000 1000"
        >
            <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
            <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
            <g id="SVGRepo_iconCarrier">
                <g>
                    <g transform="translate(0.000000,511.000000) scale(0.100000,-0.100000)">
                        <path d="M1443.7,4326.7c-11.5-21.1-9.6-243.1,1.9-555.1c19.1-553.2,17.2-580-67-580c-19.1,0-88,26.8-149.3,57.4c-128.2,65.1-191.4,55.5-191.4-24.9c0-23,51.7-281.4,114.8-574.2l114.8-534v-499.6v-501.5l76.6-225.9C1518.3,370.2,1792.1-6.8,2171-251.8l124.4-80.4l-15.3-80.4c-7.7-44-15.3-86.1-17.2-93.8c0-9.6-91.9-15.3-204.8-15.3c-114.8,0-264.1-13.4-336.9-28.7c-170.4-36.4-379-147.4-499.6-268c-134-130.2-924.5-1177.2-1003-1324.6c-34.5-65.1-74.7-178-90-248.8c-38.3-176.1-38.3-754.1,0-930.2c61.3-294.8,279.5-574.2,549.3-708.2c78.5-38.3,153.1-70.8,164.6-70.8c17.2,0,23,93.8,23,350.3c0,191.4,9.6,380.9,19.1,419.2c28.7,103.3,116.8,168.4,227.8,168.4c49.8,0,107.2-13.4,132.1-30.6c90-63.2,99.5-111,99.5-543.6v-402h1636.5h1636.5v382.8c0,419.2,11.5,478.5,105.3,551.3c63.2,49.8,176.1,55.5,258.4,13.4c105.3-53.6,114.8-101.4,114.8-545.5c0-457.5-17.2-423,178-371.3c168.4,44,319.6,126.3,449.8,246.9l114.8,105.3h911.1h911.1v285.2c0,155,9.6,310.1,21,342.6c42.1,122.5,193.3,158.9,289,67l53.6-51.7v-313.9v-315.8l84.2,9.6c216.3,24.9,465.1,214.4,570.4,434.5c55.5,114.9,61.3,147.4,68.9,348.4l7.7,222l-132.1,11.5c-599.1,55.5-1186.7,446-1493,989.6c-352.2,624-323.5,1406.9,72.7,2007.9C7341,488.9,7542,697.6,7723.8,818.1l130.1,86.1l-7.6,315.8c-5.7,269.9-13.4,331.1-49.8,426.8c-80.4,204.8-229.7,354.1-444.1,440.2c-95.7,38.3-143.6,42.1-631.7,47.9l-528.3,7.7l-120.6,151.2c-128.3,160.8-178,183.8-214.4,103.4c-42.1-93.8-80.4-80.4-302.4,105.3c-151.2,124.4-223.9,172.3-254.6,168.4l-42.1-5.7l7.7-424.9c7.6-486.2,9.6-484.3-143.6-409.6c-185.7,90-193.3,65.1-99.5-352.2c74.6-333.1,78.5-359.8,91.9-813.5c13.4-465.1,13.4-470.9,74.7-641.2c145.5-400,338.8-654.6,669.9-870.9c36.4-24.9,42.1-40.2,30.6-97.6l-13.4-70.8l-216.3-7.7c-204.8-7.7-225.9-11.5-363.7-80.4c-80.4-40.2-149.3-68.9-151.2-65.1c-45.9,67-285.2,340.7-350.3,398.1c-179.9,157-446,246.9-735,248.8h-147.4l-21.1,84.2c-32.5,128.3-28.7,137.8,67,193.3c114.9,67,352.2,294.8,469,446C4554.1,370.2,4680.4,621,4770.4,889l76.6,225.9v861.3v861.3l-47.9,132.1c-103.4,294.8-319.6,511.1-620.2,616.3c-122.5,44-143.6,45.9-807.8,45.9h-681.4l-168.4,210.5c-139.7,176.1-178,210.6-220.1,210.6c-40.2,0-57.4-13.4-76.6-57.4c-32.5-80.4-86.1-107.2-139.7-70.8c-23,15.3-153.1,118.7-289,231.6C1547.1,4363,1478.1,4395.6,1443.7,4326.7z">
                        </path>{" "}
                        <path d="M8232.9,52.5C8053-68.1,7365.9-609.8,7329.5-657.6c-19.1-28.7-40.2-90-45.9-135.9c-17.2-153.1,15.3-189.5,535.9-587.6c260.3-199.1,499.6-367.5,530.2-375.2c78.5-17.2,174.2,17.2,241.2,88c51.7,55.5,55.5,68.9,65.1,262.2l9.6,204.8l516.8,9.6c461.3,7.6,522.5,13.4,568.5,45.9c164.6,111,201,426.9,68.9,578c-32.5,36.4-76.6,76.6-99.5,90c-26.8,15.3-201,26.8-547.4,32.5l-507.2,9.6l-9.6,191.4c-5.7,105.3-21,210.5-32.5,233.5C8544.9,123.3,8378.4,150.1,8232.9,52.5z">
                        </path>
                    </g>
                </g>
            </g>
        </svg>
    );
}
