/** @jsx h */
import { h } from "preact";

export function CopyIcon(props: {
    class?: string | h.JSX.SignalLike<string | undefined> | undefined;
    style?:
        | string
        | h.JSX.CSSProperties
        | h.JSX.SignalLike<string | h.JSX.CSSProperties>
        | undefined;
}) {
    return (
        <svg
            class={props.class}
            style={props.style}
            viewBox="0 0 16 16"
            xmlns="http://www.w3.org/2000/svg"
        >
            <g clip-path="url(#clip0_190_1001)">
                <path
                    d="M5.33331 5.3335V3.46683C5.33331 2.72009 5.33331 2.34672 5.47864 2.06151C5.60647 1.81063 5.81044 1.60665 6.06133 1.47882C6.34654 1.3335 6.71991 1.3335 7.46665 1.3335H12.5333C13.28 1.3335 13.6534 1.3335 13.9386 1.47882C14.1895 1.60665 14.3935 1.81063 14.5213 2.06151C14.6666 2.34672 14.6666 2.72009 14.6666 3.46683V8.5335C14.6666 9.28023 14.6666 9.6536 14.5213 9.93882C14.3935 10.1897 14.1895 10.3937 13.9386 10.5215C13.6534 10.6668 13.28 10.6668 12.5333 10.6668H10.6666M3.46665 14.6668H8.53331C9.28005 14.6668 9.65342 14.6668 9.93863 14.5215C10.1895 14.3937 10.3935 14.1897 10.5213 13.9388C10.6666 13.6536 10.6666 13.2802 10.6666 12.5335V7.46683C10.6666 6.72009 10.6666 6.34672 10.5213 6.06151C10.3935 5.81063 10.1895 5.60665 9.93863 5.47882C9.65342 5.3335 9.28005 5.3335 8.53331 5.3335H3.46665C2.71991 5.3335 2.34654 5.3335 2.06133 5.47882C1.81044 5.60665 1.60647 5.81063 1.47864 6.06151C1.33331 6.34672 1.33331 6.72009 1.33331 7.46683V12.5335C1.33331 13.2802 1.33331 13.6536 1.47864 13.9388C1.60647 14.1897 1.81044 14.3937 2.06133 14.5215C2.34654 14.6668 2.71991 14.6668 3.46665 14.6668Z"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                />
            </g>
            <defs>
                <clipPath id="clip0_190_1001">
                    <rect width="16" height="16" />
                </clipPath>
            </defs>
        </svg>
    );
}
