/** @jsx h */
import { h } from "preact";

export function CameraPlusIcon(props: {
    class?: string | h.JSX.SignalLike<string | undefined> | undefined;
    style?:
        | string
        | h.JSX.CSSProperties
        | h.JSX.SignalLike<string | h.JSX.CSSProperties>
        | undefined;
}) {
    return (
        <svg
            class={props.class}
            style={props.style}
            viewBox="0 0 32 32"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <path
                d="M21 17C21 17.2652 20.8946 17.5196 20.7071 17.7071C20.5196 17.8946 20.2652 18 20 18H17V21C17 21.2652 16.8946 21.5196 16.7071 21.7071C16.5196 21.8946 16.2652 22 16 22C15.7348 22 15.4804 21.8946 15.2929 21.7071C15.1054 21.5196 15 21.2652 15 21V18H12C11.7348 18 11.4804 17.8946 11.2929 17.7071C11.1054 17.5196 11 17.2652 11 17C11 16.7348 11.1054 16.4804 11.2929 16.2929C11.4804 16.1054 11.7348 16 12 16H15V13C15 12.7348 15.1054 12.4804 15.2929 12.2929C15.4804 12.1054 15.7348 12 16 12C16.2652 12 16.5196 12.1054 16.7071 12.2929C16.8946 12.4804 17 12.7348 17 13V16H20C20.2652 16 20.5196 16.1054 20.7071 16.2929C20.8946 16.4804 21 16.7348 21 17ZM29 10V24C29 24.7956 28.6839 25.5587 28.1213 26.1213C27.5587 26.6839 26.7956 27 26 27H6C5.20435 27 4.44129 26.6839 3.87868 26.1213C3.31607 25.5587 3 24.7956 3 24V10C3 9.20435 3.31607 8.44129 3.87868 7.87868C4.44129 7.31607 5.20435 7 6 7H9.465L10.875 4.89C11.0573 4.61673 11.3041 4.39258 11.5937 4.23735C11.8832 4.08213 12.2065 4.00061 12.535 4H19.465C19.7935 4.00061 20.1168 4.08213 20.4063 4.23735C20.6959 4.39258 20.9427 4.61673 21.125 4.89L22.535 7H26C26.7956 7 27.5587 7.31607 28.1213 7.87868C28.6839 8.44129 29 9.20435 29 10ZM27 10C27 9.73478 26.8946 9.48043 26.7071 9.29289C26.5196 9.10536 26.2652 9 26 9H22C21.8353 9.00011 21.6732 8.95954 21.5279 8.88191C21.3827 8.80428 21.2589 8.69199 21.1675 8.555L19.465 6H12.535L10.8325 8.555C10.7411 8.69199 10.6173 8.80428 10.4721 8.88191C10.3268 8.95954 10.1647 9.00011 10 9H6C5.73478 9 5.48043 9.10536 5.29289 9.29289C5.10536 9.48043 5 9.73478 5 10V24C5 24.2652 5.10536 24.5196 5.29289 24.7071C5.48043 24.8946 5.73478 25 6 25H26C26.2652 25 26.5196 24.8946 26.7071 24.7071C26.8946 24.5196 27 24.2652 27 24V10Z"
                fill="currentColor"
            />
        </svg>
    );
}
