/** @jsx h */
import { h } from "preact";

export function AppListIcon(props: {
    class?: string | h.JSX.SignalLike<string | undefined> | undefined;
    style?:
        | string
        | h.JSX.CSSProperties
        | h.JSX.SignalLike<string | h.JSX.CSSProperties>
        | undefined;
}) {
    return (
        <svg
            class={props.class}
            style={props.style}
            viewBox="0 0 28 28"
            xmlns="http://www.w3.org/2000/svg"
        >
            <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
            <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
            <g id="SVGRepo_iconCarrier">
                <path d="M20.841 2.65519C19.9623 1.77651 18.5377 1.77652 17.659 2.6552L13.5 6.8142V6.25402C13.5 5.01138 12.4926 4.00402 11.25 4.00402H4.25C3.00736 4.00402 2 5.01138 2 6.25402V24.254C2 25.2205 2.7835 26.004 3.75 26.004H21.75C22.9926 26.004 24 24.9967 24 23.754V16.7499C24 15.5073 22.9926 14.4999 21.75 14.4999H21.1942L25.349 10.3452C26.2277 9.46648 26.2277 8.04186 25.349 7.16318L20.841 2.65519ZM17.3058 14.4999H13.5V10.6941L17.3058 14.4999ZM18.7197 3.71586C19.0126 3.42296 19.4874 3.42296 19.7803 3.71585L24.2883 8.22384C24.5812 8.51673 24.5812 8.99161 24.2883 9.2845L19.7803 13.7925C19.4874 14.0854 19.0126 14.0854 18.7197 13.7925L14.2117 9.2845C13.9188 8.99161 13.9188 8.51673 14.2117 8.22384L18.7197 3.71586ZM12 6.25402V14.4999H3.5V6.25402C3.5 5.83981 3.83579 5.50402 4.25 5.50402H11.25C11.6642 5.50402 12 5.83981 12 6.25402ZM3.5 23.754L3.5 15.9999H12V24.504H4.25C3.83579 24.504 3.5 24.1682 3.5 23.754ZM13.5 15.9999H21.75C22.1642 15.9999 22.5 16.3357 22.5 16.7499V23.754C22.5 24.1682 22.1642 24.504 21.75 24.504H13.5V15.9999Z">
                </path>
            </g>
        </svg>
    );
}
