"""This holds all of the functions"""

from __future__ import print_function

import os
import shutil
from shutil import copyfile
import sys
import urllib
import zipfile
from distutils.dir_util import copy_tree
import untangle

# Very important, get the directory that the user wants to run commands in
cwd = os.getcwd()


def create_folder(path):
    """Creates the specified folder if it dosen't already exist"""
    if not os.path.exists(path):
        os.makedirs(path)


def replace_folder(path):
    """If the specified folder exists, it is deleted and recreated"""
    if os.path.exists(path):
        shutil.rmtree(path)
        os.makedirs(path)
    else:
        os.makedirs(path)


def get_html_filename(filename):
    """Converts the filename to a .html extension"""
    if ".html" in filename:
        newFilename = filename
    elif ".md" in filename:
        newFilename = filename.replace(".md", ".html")
    elif ".tile" in filename:
        newFilename = filename.replace(".tile", ".html")
    elif ".jade" in filename:
        newFilename = filename.replace(".jade", ".html")
    elif ".txt" in filename:
        newFilename = filename.replace(".txt", ".html")
    elif ".rst" in filename:
        newFilename = filename.replace(".rst", ".html")
    elif ".docx" in filename:
        newFilename = filename.replace(".docx", ".html")
    else:
        print(filename + " is not a valid file type!")

    return newFilename


def get_html_clear_filename(filename):
    """Clears the file extension from the filename and makes it nice looking"""
    newFilename = filename.replace(".html", "")
    newFilename = newFilename.replace(".md", "")
    newFilename = newFilename.replace(".txt", "")
    newFilename = newFilename.replace(".tile", "")
    newFilename = newFilename.replace(".jade", "")
    newFilename = newFilename.replace(".rst", "")
    newFilename = newFilename.replace(".docx", "")
    newFilename = newFilename.replace("index", "home")
    newFilename = newFilename.replace("-", " ")
    newFilename = newFilename.replace("_", " ")
    newFilename = newFilename.title()

    return newFilename


def getunzipped(username, repo, thedir):
    """Downloads and unzips a zip file"""
    theurl = "https://github.com/" + username + "/" + repo + "/archive/master.zip"
    name = os.path.join(thedir, 'temp.zip')
    try:
        name = urllib.urlretrieve(theurl, name)
        name = os.path.join(thedir, 'temp.zip')
    except IOError as e:
        print("Can't retrieve %r to %r: %s" % (theurl, thedir, e))
        return
    try:
        z = zipfile.ZipFile(name)
    except zipfile.error as e:
        print("Bad zipfile (from %r): %s" % (theurl, e))
        return
    z.extractall(thedir)
    z.close()
    os.remove(name)

    copy_tree(os.path.join(thedir, repo + "-master"), thedir)
    shutil.rmtree(os.path.join(thedir, repo + "-master"))


def checkConfig():
    """If the config.py file exists, back it up"""
    config_file_dir = os.path.join(cwd, "config.py")
    if os.path.exists(config_file_dir):
        print("Making a backup of your config file!")
        config_file_dir2 = os.path.join(cwd, "config.py.oldbak")
        copyfile(config_file_dir, config_file_dir2)


def createConfig(app_version=5.0, wname="", wdesc="", wdescl="", wlic="", wlan="", wurl="", aname="", abio=""):
    """Generates a config file from the information"""
    config_file_dir = os.path.join(cwd, "config.py")

    config_file = open(config_file_dir, "w")
    config_file.write('blended_version = ' + app_version + '\n')
    config_file.write('\n')
    config_file.write(
        '# Configuration is automatically generated by Blended (http://jmroper.com/blended), feel free to edit any values below')
    config_file.write('\n')
    config_file.write('website_name = "' + wname + '"\n')
    config_file.write('website_description = "' + wdesc + '"\n')
    config_file.write(
        'website_description_long = "' + wdescl + '"\n')
    config_file.write('website_license = "' + wlic + '"\n')
    config_file.write('website_language = "' + wlan + '"\n')
    config_file.write('website_url = "' + wurl + '"\n')
    config_file.write('\n')
    config_file.write('author_name = "' + aname + '"\n')
    config_file.write('author_bio = "' + abio + '"\n')
    config_file.write('\n')
    config_file.write('home_page_list = True\n')
    config_file.write('\n')
    config_file.write('plugins = [] # Place all needed plugins in here\n')
    config_file.write(
        'custom_variables = {} # Place all custom variables in here\n')
    config_file.write('\n')
    config_file.write('minify_css = False\n')
    config_file.write('minify_js = False\n')
    config_file.write('\n')
    config_file.write('# The following values are used for FTP uploads')
    config_file.write('\n')
    config_file.write('ftp_server = "localhost"\n')
    config_file.write('ftp_username = "user"\n')
    config_file.write('ftp_password = "pass"\n')
    config_file.write('ftp_port = 21\n')
    config_file.write('ftp_upload_path = "public_html/myWebsite"\n')
    config_file.close()


def createBlendedFolders():
    """Creates the standard folders for a Blended website"""
    # Create the templates folder
    create_folder(os.path.join(cwd, "templates"))

    # Create the templates/assets folder
    create_folder(os.path.join(cwd, "templates", "assets"))

    # Create the templates/assets/css folder
    create_folder(os.path.join(cwd, "templates", "assets", "css"))

    # Create the templates/assets/js folder
    create_folder(os.path.join(cwd, "templates", "assets", "js"))

    # Create the templates/assets/img folder
    create_folder(os.path.join(cwd, "templates", "assets", "img"))

    # Create the content folder
    create_folder(os.path.join(cwd, "content"))


def parseXML(filepath):
    """Parses an XML file using untangle"""
    try:
        output = untangle.parse(filepath)
    except:
        sys.exit("The export file could not be found or read!")

    return output
