package android.support.v4.os;

import android.os.Build.VERSION;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.IOException;

public class EnvironmentCompat {
	public static final String MEDIA_UNKNOWN = "unknown";
	private static final String TAG = "EnvironmentCompat";

	public EnvironmentCompat() {
		super();
	}

	public static String getStorageState(File path) {
		if (VERSION.SDK_INT >= 19) {
			return EnvironmentCompatKitKat.getStorageState(path);
		} else {
			try {
				if (path.getCanonicalPath().startsWith(Environment.getExternalStorageDirectory().getCanonicalPath())) {
					return Environment.getExternalStorageState();
				}
			} catch (IOException e) {
				Log.w(TAG, "Failed to resolve canonical path: " + e);
			}
			return MEDIA_UNKNOWN;
		}
	}
}
