---
title: Keyboard shortcuts
---


!!! note

    Shortcuts marked with `*` might change depending on your platform.

## Mnemonics

Also called "Access keys", those are the underlined characters you can find in menu titles or buttons around the user interface. The underlined character correspond to the key to open the menu / click the button when in conjunction with the <kbd>Alt</kbd> key.

Sometimes, the underline only appears when pressing the <kbd>Alt</kbd> key.

### Example
![example](img/mnemonics.png)

In this example, there are two shortcuts available:
* <kbd>Alt+O</kbd> to open the sources window
* <kbd>Alt+M</kbd> to toggle the "merge results" feature

## Main window

| Action                              | Default shortcut         | Qt Shortcut                  |
|-------------------------------------|--------------------------|------------------------------|
| Quit the application                | <kbd>Ctrl+Q</kbd>`*`     |
| Focus search field                  | <kbd>Ctrl+L</kbd>        |
| Close tab                           | <kbd>Ctrl+W</kbd>`*`     |
| Re-open closed tab                  |                          | <kbd>Ctrl+Shift+Tab</kbd>`*` |
| New tab                             | <kbd>Ctrl+T</kbd>`*`     |
| Go to the previous tab              | <kbd>Ctrl+PageUp</kbd>   | <kbd>Ctrl+Shift+Tab</kbd>`*` |
| Go to the next tab                  | <kbd>Ctrl+PageDown</kbd> | <kbd>Ctrl+Tab</kbd>`*`       |
| Open save directory in file browser | <kbd>Ctrl+O</kbd>`*`     |

## Downloads tab

| Action                    | Default shortcut  |
|---------------------------|-------------------|
| Remove selected downloads | <kbd>Delete</kbd> |

## Viewer window

### Normal mode

| Action                                     | Default shortcut           |
|--------------------------------------------|----------------------------|
| Close the window                           | <kbd>Escape</kbd>          |
| Show previous search result                | <kbd>Left arrow</kbd>      |
| Show next search result                    | <kbd>Right arrow</kbd>     |
| Open media details                         | <kbd>D</kbd>               |
| Save media as...                           | <kbd>Ctrl+Shift+S</kbd>`*` |
| Save media                                 | <kbd>Ctrl+S</kbd>`*`       |
| Save media and close window                | <kbd>Ctrl+W</kbd>`*`       |
| Open save path in file browser             | <kbd>Ctrl+O</kbd>          |
| Favourite media                            | <kbd>Ctrl+Alt+S</kbd>`*`   |
| Favourite media and close window           | <kbd>Ctrl+Alt+W</kbd>`*`   |
| Open favourite path in file browser        | <kbd>Ctrl+Alt+O</kbd>      |
| Toggle full-screen mode                    | <kbd>F11</kbd>`*`          |
| Toggle slideshow mode                      | <kbd>Space</kbd>`*`        |
| Copy the image's raw data to the clipboard | <kbd>Ctrl+C</kbd>`*`       |

### Full-screen mode

| Action                 | Default shortcut       |
|------------------------|------------------------|
| Leave full-screen mode | <kbd>Escape</kbd>      |
| Leave full-screen mode | <kbd>F11</kbd>`*`      |
| Show next media        | <kbd>Right arrow</kbd> |
| Show previous media    | <kbd>Left arrow</kbd>  |
| Toggle slideshow       | <kbd>Space</kbd>       |
