# Exercism-Rust-Track

[![Progress](https://img.shields.io/badge/Progress-85%25-brightgreen)](https://exercism.org/profiles/Binlogo)

Exercism practice in Rust trace

## About Exercism

[Exercism](https://exercism.io/about) is a an online platform designed to help you improve your coding skills through practice and mentorship.

- Numerous language tracks 🎯
- Awesome mentorship 🗝
- Handy CLI tooling 🧰
- Fun & friendly 🥰
- Entirely open source 💕
- Surprisingly, 100% free 😮

## Rust Track

[Rust Track](https://exercism.org/tracks/rust) includes 90 exercises. 🦀

### Main Exercises with mentorship

Title                                                                                                                 | Tags                                          | Descrption                                                                                              |           Code
--------------------------------------------------------------------------------------------------------------------- | --------------------------------------------- | ------------------------------------------------------------------------------------------------------- | :----------------------:
[Reverse String](https://exercism.io/tracks/rust/exercises/reverse-string/solutions/32cf4f36f765465e810dabc561173453) | `iterator` `str` `string`                     | Reverse a string                                                                                        | [Rust](./reverse-string)
[Gigasecond](https://exercism.io/tracks/rust/exercises/gigasecond/solutions/eb926376f6214aeabb708834046d3392)         | `crates`                                      | Given a moment, determine the moment that would be after a gigasecond has passed.                       |   [Rust](./gigasecond)
[Bob](https://exercism.io/tracks/rust/exercises/bob/solutions/3d87678b6f7e4496b39d3befb37e1d36)                       | `chars` `string functions`                    | Bob is a lackadaisical teenager. In conversation, his responses are very limited.                       |      [Rust](./bob)
[Clock](https://exercism.io/tracks/rust/exercises/clock/solutions/8f2b3603f1e14b1db50ca9ed43ea4bae)                   | `derive` `struct` `traits`                    | Implement a clock that handles times without dates.                                                     |     [Rust](./clock)
[Atbash Cipher](https://exercism.io/tracks/rust/exercises/atbash-cipher/solutions/885d1e04bd644c56bab41e3dbc804278)   | `ascii` `chars` `iterators` `primitive types` | Create an implementation of the atbash cipher, an ancient encryption system created in the Middle East. | [Rust](./atbash-cipher)
[Sublist](https://exercism.io/tracks/rust/exercises/sublist/solutions/cbb828f199ff453192d0396789d76d09)               | `generic over type` `enums`                   | Write a function to determine if a list is a sublist of another list                                    |    [Rust](./sublist)
[Minesweeper](https://exercism.io/my/solutions/d60a502b6e0241a5898d45f06006612f)                                      | `board state`                                 | Add the numbers to minesweeper board                                                                    |  [Rust](./minesweeper)
[Luhn](https://exercism.io/tracks/rust/exercises/luhn/solutions/56df560fbbfc460d95e6f9a15b45e44f)                     | `higher order functions` `iterators`          | Given a number determine whether or not it is valid per the Luhn formula.                               |      [Rust](./luhn)
[Parallel Letter Frequency](https://exercism.io/tracks/rust/exercises/parallel-letter-frequency/solutions/99756fb4e91e4d3484a698f0784afc6e) | `multi threading` | Count the frequency of letters in texts using parallel computation. | [Rust](parallel-letter-frequency) 

### Extra Exercises

Title                                                                                                                               | Tags                                                   | Descrption                                                                                                                                                               | Code
----------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | -------------------------------
[Leap](https://exercism.io/tracks/rust/exercises/leap/solutions/4151df17bcf340039f76e976e29a331f)                                   | `booleans` `conditionals`                              | Given a year, report if it is a leap year.                                                                                                                               | [Rust](./leap)
[Raindrops](https://exercism.io/tracks/rust/exercises/raindrops/solutions/4261ea6274bd40879c136b9839c5b681)                         | `case or format` `mutable string`                      | Convert a number to a string, the contents of which depend on the number's factors.                                                                                      | [Rust](./raindrops)
[Beer Song](https://exercism.io/tracks/rust/exercises/beer-song/solutions/74677aa07a8548bca8bebcb39df98caa)                         | `case` `loop` `string concatenation` `vector optional` | Recite the lyrics to that beloved classic, that field-trip favorite: 99 Bottles of Beer on the Wall.                                                                     | [Rust](./beer-song)
[Nth Prime](https://exercism.io/tracks/rust/exercises/nth-prime/solutions/5bf23c3d35d14c189a933e8c6e9a5d99)                         | `loops` `primes` `math`                                | Given a number n, determine what the nth prime is.                                                                                                                       | [Rust](./nth-prime)
[Proverb](https://exercism.io/tracks/rust/exercises/proverb/solutions/72174c85de0648d194a03a715f7cec57)                             | `format` `iterator`                                    | For want of a horseshoe nail, a kingdom was lost, or so the saying goes.                                                                                                 | [Rust](./proverb)
[Difference of Squares](https://exercism.io/tracks/rust/exercises/difference-of-squares/solutions/2948322895e94aefa128995455886f7b) | `sum` `fold` `map` `math`                              | Find the difference between the square of the sum and the sum of the squares of the first N natural numbers.                                                             | [Rust](./difference-of-squares)
[Sum Of Multiples](https://exercism.io/tracks/rust/exercises/sum-of-multiples/solutions/f16ee7aa22e24d54a08c4910dd177134)           | `algorithm` `borrowing` `math`                         | Given a number, find the sum of all the unique multiples of particular numbers up to but not including that number.                                                      | [Rust](./sum-of-multiples)
[Grains](https://exercism.io/tracks/rust/exercises/grains/solutions/c37110ad75014a8db55cbe8bd5620c43)                               | `panic`                                                | Calculate the number of grains of wheat on a chessboard given that the number on each square doubles.                                                                    | [Rust](./grains)
[Armstrong Numbers](https://exercism.io/tracks/rust/exercises/armstrong-numbers/solutions/7fc73d04797c42a09f1588095c6e6b19)         | `math`                                                 | An [Armstrong number](https://en.wikipedia.org/wiki/Narcissistic_number) is a number that is the sum of its own digits each raised to the power of the number of digits. | [Rust](./armstrong-numbers)
[Matching Brackets](https://exercism.io/tracks/rust/exercises/matching-brackets/solutions/cf8e683778f74137b0cb4f08a622ae2f)         | `stack`                                                | Given a string containing brackets `[]`, braces `{}`, parentheses `()`, or any combination thereof, verify that any and all pairs are matched and nested correctly.      | [Rust](./matching-brackets)
[Saddle Points](https://exercism.io/tracks/rust/exercises/saddle-points/solutions/337fd3e68a6c4f04a75eda7ce8fbeae5)                 | `vectors` `iterator`                                   | Detect saddle points in a matrix.                                                                                                                                        | [Rust](./saddle-points)
[Isogram](https://exercism.io/tracks/rust/exercises/isogram/solutions/e59aca55149a4fc4a2ab8b4d1c9abd2f)                             | `chars` `iterator` `strings` `set`                     | Determine if a word or phrase is an isogram.                                                                                                                             | [Rust](./isogram)
[High Scores](https://exercism.io/tracks/rust/exercises/high-scores/solutions/03c3d15bb4784a65ad92b56913de7656)                     | `iterators` `lifetimes` `vectors`                      | Manage a game player's High Score list.                                                                                                                                  | [Rust](./high-scores)
[Say](https://exercism.io/tracks/rust/exercises/say/solutions/01122d0f87dd4485ac38f91963bb01c4)                                     | `modulus` `strings`                                    | Given a number from 0 to 999,999,999,999, spell out that number in English.                                                                                              | [Rust](./say)
[Run Length Encoding](https://exercism.io/tracks/rust/exercises/run-length-encoding/solutions/c381bfd9af34426ab6dad507ea1b7513)     | `strings`                                              | Implement run-length encoding and decoding.                                                                                                                              | [Rust](./run-length-encoding)

## Copyright

All materials from [Exercism Rust Trace](https://exercism.org/tracks/rust) are Copyright **Exercism**.
