import {
  AlertTriangle,
  Bell,
  Clock,
  Info,
  LucideProps,
  Hexagon,
  TextCursorInput,
} from "lucide-react";

type IconProps = React.SVGProps<SVGSVGElement>;

export const Icons = {
  logo: (props: IconProps) => (
    <svg
      {...props}
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path d="M8 4C8 2.34315 9.34315 1 11 1C12.6569 1 14 2.34315 14 4C14 4.35064 13.9398 4.68722 13.8293 5H18C18.5523 5 19 5.44772 19 6V10.1707C19.3128 10.0602 19.6494 10 20 10C21.6569 10 23 11.3431 23 13C23 14.6569 21.6569 16 20 16C19.6494 16 19.3128 15.9398 19 15.8293V20C19 20.5523 18.5523 21 18 21H4C3.44772 21 3 20.5523 3 20V6C3 5.44772 3.44772 5 4 5H8.17071C8.06015 4.68722 8 4.35064 8 4Z" />
    </svg>
  ),
  twitter: (props: IconProps) => (
    <svg
      {...props}
      height="23"
      viewBox="0 0 1200 1227"
      width="23"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path d="M714.163 519.284L1160.89 0H1055.03L667.137 450.887L357.328 0H0L468.492 681.821L0 1226.37H105.866L515.491 750.218L842.672 1226.37H1200L714.137 519.284H714.163ZM569.165 687.828L521.697 619.934L144.011 79.6944H306.615L611.412 515.685L658.88 583.579L1055.08 1150.3H892.476L569.165 687.854V687.828Z" />
    </svg>
  ),
  discord: (props: LucideProps) => (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512" {...props}>
      <path
        fill="currentColor"
        d="M524.531,69.836a1.5,1.5,0,0,0-.764-.7A485.065,485.065,0,0,0,404.081,32.03a1.816,1.816,0,0,0-1.923.91,337.461,337.461,0,0,0-14.9,30.6,447.848,447.848,0,0,0-134.426,0,309.541,309.541,0,0,0-15.135-30.6,1.89,1.89,0,0,0-1.924-.91A483.689,483.689,0,0,0,116.085,69.137a1.712,1.712,0,0,0-.788.676C39.068,183.651,18.186,294.69,28.43,404.354a2.016,2.016,0,0,0,.765,1.375A487.666,487.666,0,0,0,176.02,479.918a1.9,1.9,0,0,0,2.063-.676A348.2,348.2,0,0,0,208.12,430.4a1.86,1.86,0,0,0-1.019-2.588,321.173,321.173,0,0,1-45.868-21.853,1.885,1.885,0,0,1-.185-3.126c3.082-2.309,6.166-4.711,9.109-7.137a1.819,1.819,0,0,1,1.9-.256c96.229,43.917,200.41,43.917,295.5,0a1.812,1.812,0,0,1,1.924.233c2.944,2.426,6.027,4.851,9.132,7.16a1.884,1.884,0,0,1-.162,3.126,301.407,301.407,0,0,1-45.89,21.83,1.875,1.875,0,0,0-1,2.611,391.055,391.055,0,0,0,30.014,48.815,1.864,1.864,0,0,0,2.063.7A486.048,486.048,0,0,0,610.7,405.729a1.882,1.882,0,0,0,.765-1.352C623.729,277.594,590.933,167.465,524.531,69.836ZM222.491,337.58c-28.972,0-52.844-26.587-52.844-59.239S193.056,219.1,222.491,219.1c29.665,0,53.306,26.82,52.843,59.239C275.334,310.993,251.924,337.58,222.491,337.58Zm195.38,0c-28.971,0-52.843-26.587-52.843-59.239S388.437,219.1,417.871,219.1c29.667,0,53.307,26.82,52.844,59.239C470.715,310.993,447.538,337.58,417.871,337.58Z"
      />
    </svg>
  ),
  gitHub: (props: IconProps) => (
    <svg viewBox="0 0 438.549 438.549" {...props}>
      <path
        fill="currentColor"
        d="M409.132 114.573c-19.608-33.596-46.205-60.194-79.798-79.8-33.598-19.607-70.277-29.408-110.063-29.408-39.781 0-76.472 9.804-110.063 29.408-33.596 19.605-60.192 46.204-79.8 79.8C9.803 148.168 0 184.854 0 224.63c0 47.78 13.94 90.745 41.827 128.906 27.884 38.164 63.906 64.572 108.063 79.227 5.14.954 8.945.283 11.419-1.996 2.475-2.282 3.711-5.14 3.711-8.562 0-.571-.049-5.708-.144-15.417a2549.81 2549.81 0 01-.144-25.406l-6.567 1.136c-4.187.767-9.469 1.092-15.846 1-6.374-.089-12.991-.757-19.842-1.999-6.854-1.231-13.229-4.086-19.13-8.559-5.898-4.473-10.085-10.328-12.56-17.556l-2.855-6.57c-1.903-4.374-4.899-9.233-8.992-14.559-4.093-5.331-8.232-8.945-12.419-10.848l-1.999-1.431c-1.332-.951-2.568-2.098-3.711-3.429-1.142-1.331-1.997-2.663-2.568-3.997-.572-1.335-.098-2.43 1.427-3.289 1.525-.859 4.281-1.276 8.28-1.276l5.708.853c3.807.763 8.516 3.042 14.133 6.851 5.614 3.806 10.229 8.754 13.846 14.842 4.38 7.806 9.657 13.754 15.846 17.847 6.184 4.093 12.419 6.136 18.699 6.136 6.28 0 11.704-.476 16.274-1.423 4.565-.952 8.848-2.383 12.847-4.285 1.713-12.758 6.377-22.559 13.988-29.41-10.848-1.14-20.601-2.857-29.264-5.14-8.658-2.286-17.605-5.996-26.835-11.14-9.235-5.137-16.896-11.516-22.985-19.126-6.09-7.614-11.088-17.61-14.987-29.979-3.901-12.374-5.852-26.648-5.852-42.826 0-23.035 7.52-42.637 22.557-58.817-7.044-17.318-6.379-36.732 1.997-58.24 5.52-1.715 13.706-.428 24.554 3.853 10.85 4.283 18.794 7.952 23.84 10.994 5.046 3.041 9.089 5.618 12.135 7.708 17.705-4.947 35.976-7.421 54.818-7.421s37.117 2.474 54.823 7.421l10.849-6.849c7.419-4.57 16.18-8.758 26.262-12.565 10.088-3.805 17.802-4.853 23.134-3.138 8.562 21.509 9.325 40.922 2.279 58.24 15.036 16.18 22.559 35.787 22.559 58.817 0 16.178-1.958 30.497-5.853 42.966-3.9 12.471-8.941 22.457-15.125 29.979-6.191 7.521-13.901 13.85-23.131 18.986-9.232 5.14-18.182 8.85-26.84 11.136-8.662 2.286-18.415 4.004-29.263 5.146 9.894 8.562 14.842 22.077 14.842 40.539v60.237c0 3.422 1.19 6.279 3.572 8.562 2.379 2.279 6.136 2.95 11.276 1.995 44.163-14.653 80.185-41.062 108.068-79.226 27.88-38.161 41.825-81.126 41.825-128.906-.01-39.771-9.818-76.454-29.414-110.049z"
      ></path>
    </svg>
  ),
  Ui: (props: IconProps) => (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/svg"
      viewBox="0 0 256 256"
      {...props}
    >
      <rect width="256" height="256" fill="none" />
      <line
        x1="208"
        y1="128"
        x2="128"
        y2="208"
        fill="none"
        stroke="currentColor"
        strokeLinecap="round"
        strokeLinejoin="round"
        strokeWidth="16"
      />
      <line
        x1="192"
        y1="40"
        x2="40"
        y2="192"
        fill="none"
        stroke="currentColor"
        strokeLinecap="round"
        strokeLinejoin="round"
        strokeWidth="16"
      />
    </svg>
  ),
  RadixUi: (props: IconProps) => (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="25"
      height="25"
      viewBox="0 0 25 25"
      fill="none"
      {...props}
    >
      <path
        d="M12 25C7.58173 25 4 21.4183 4 17C4 12.5817 7.58173 9 12 9V25Z"
        fill="currentcolor"
      />
      <path d="M12 0H4V8H12V0Z" fill="currentcolor" />
      <path
        d="M17 8C19.2091 8 21 6.20914 21 4C21 1.79086 19.2091 0 17 0C14.7909 0 13 1.79086 13 4C13 6.20914 14.7909 8 17 8Z"
        fill="currentcolor"
      />
    </svg>
  ),
  EmblaCarousel: (props: IconProps) => (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="160"
      height="160"
      viewBox="-5 -5 160 160"
      {...props}
    >
      <defs>
        <linearGradient
          id="dark-theme-blur-gradient"
          x1="0%"
          y1="0%"
          x2="100%"
          y2="0%"
        >
          <stop offset="0%" stopColor="#8ab4f8" />
          <stop offset="100%" stopColor="#c1a8e2" />
        </linearGradient>
        <filter id="dark-theme-blur-filter">
          <feGaussianBlur in="SourceGraphic" stdDeviation="3.5" />
        </filter>
        <path
          id="dark-theme-blur-logo"
          d="M93 .03l.46.06.47.08.24.05.23.05.23.07.24.07.47.16.23.1.24.1.45.2.23.1.44.24.44.26L98 2l.6.48.38.34.36.36.17.2.1.12.1.13.1.12.1.14.1.12.2.26.1.14.1.13.17.27.18.3.16.3.16.32.08.17.15.36.07.2.1.2.07.2.08.2.07.23.08.23.07.23.16.5.08.26.08.28.1.3.63 2.35.1.4.14.54.13.55.24 1.13.1.58.12.57.1.6.18 1.2.1.6.08.63.07.62.07.64.06.64.06.65.05.65.04.67.05.67.1 2.06.04 2.87-.03 2.23-.06 1.53-.02.78-.05.78-.04.8-.1 1.6-.07.82-.06.82-.26 2.8-.02.26-.03.26-.02.27-.04.52-.04.5-.02.24-.03.48-.02.22-.01.23v.23l-.02.2-.01.22v.4l-.03.37v.17l-.01.18-.02.32v.3.13.25l-.01.2.01.1V46v.08.06.05.05l.01.03.01.02h.01.02l.03.01h.67l.13-.01h.14.15.16l.34-.02.37-.02.2-.01h.42l.46-.04h.24l.23-.02.25-.02.26-.02.27-.02h.27l.26-.02.28-.02.3-.03.3-.02h.28l.6-.04.3-.03.62-.05.3-.03 1.4-.1 1.37-.1 1.36-.08 2.64-.1 1.3-.03 1.26-.02h1.25 1.22l1.2.02 1.17.03 2.27.1 1.1.08 1.07.08 1.05.1 1.03.1 1 .12.97.13.94.15.93.16.88.17.87.2.83.2.8.2.78.22.75.24.72.24.7.26.67.27.63.28.6.3.58.3.54.32.5.33.5.35.45.35.42.36.38.38.36.4.14.17.27.33.12.16.12.17.1.17.1.16.2.3.1.17.25.47.08.16.07.15.06.17.16.47.1.33.06.33.03.16.02.18.02.16v.17l.02.36v.18l-.02.36-.01.2-.02.2-.01.2-.06.4-.04.2-.04.22-.03.2-.08.35-.1.35-.12.36-.13.36-.15.37-.17.38-.18.37-.2.4-.22.38-.24.4-.25.4-.26.4-.6.8-.64.82-.36.4-.35.42-1.18 1.24-.42.43-.88.84-.46.43-.96.84-.5.43-1.03.84-.53.43-.55.4-1.7 1.25-.6.4-1.22.8-.62.4-.63.4-.38.24-.4.24-.42.25-.42.26-.45.26-.46.26-.96.54-.5.3-.5.27-.5.28-.5.3-1.03.56-.52.27-.5.28-.52.27-1 .53-.5.26-.5.25-.48.25-.92.46-.86.42-.42.2-.38.2-.37.17-.35.17-.32.15-.3.13-.27.1-.26.1-.2.1-.2.06-.17.06-.12.03-.1.02-.05-.02-.04-.04-.04-.06-.03-.08-.03-.1-.02-.1-.01-.13-.02-.14v-.15l.01-.17v-.2l.01-.18.02-.2.01-.2.05-.44.03-.22.1-.7.04-.24.1-.47.05-.24.1-.45.06-.22.05-.22.07-.2.05-.2.07-.2.07-.18.12-.32.06-.15.07-.13.07-.12.06-.1.07-.1.06-.06.06-.05.1-.04.1-.05.05-.04.07-.04.06-.03.07-.03.08-.04.16-.1.18-.08.1-.06.1-.04.2-.12.32-.16.22-.12.23-.13.24-.12.37-.2.12-.07.25-.13.13-.07.25-.13.14-.06.12-.07.13-.06.13-.07.13-.06 1.37-.7.67-.36.67-.38.66-.36.65-.36.64-.37 1.26-.75.6-.36 1.2-.75.58-.38.57-.36.57-.38.55-.37.54-.38.53-.36.52-.37 1-.74.47-.35.46-.37.45-.36.44-.36.84-.7.4-.35.74-.68.67-.67.6-.65.28-.32.27-.3.24-.3.23-.3.2-.3.36-.58.14-.28.14-.3.12-.27.1-.27.08-.27.06-.26.04-.26.02-.26v-.5l-.03-.25-.05-.24-.07-.22-.08-.23-.1-.23-.12-.22-.14-.2-.32-.42-.4-.4-.48-.38-.26-.18-.28-.18-.6-.34-.68-.33-.37-.15-.4-.15-.4-.14-.42-.14-.43-.14-.46-.14-.47-.13-.5-.12-.5-.1-.52-.1-.47-.1-.5-.1-.53-.08-.58-.06-.6-.08-.63-.06-.65-.06-.67-.05-.7-.05-.72-.05-.74-.04-1.52-.06-.8-.03-.8-.02h-.8l-1.67-.02-.83.01h-.85l-2.57.03-.85.03-.86.03-.86.02-.84.05-.85.03-.84.06-.82.05-.83.06-.8.05-1.57.14-.76.07-.75.08-.72.08-1.4.2-.65.1-3.42.52-1.4 7.83-1.46 7.83 6.8 7.94 1.04 1.25 1.03 1.23 1 1.2.98 1.2.95 1.2.93 1.18.9 1.16.88 1.15.87 1.13.84 1.13.82 1.1.8 1.1.78 1.1.75 1.07.73 1.07 1.4 2.1.67 1.03.65 1.02.62 1 .6 1 .58.98.56.98.54.95.52.96.5.95.48.93.45.92.43.9.42.9.4.9.37.88.36.9.33.86.32.86.3.86.28.84.25.83.23.83.15.52.12.5.14.5.1.48.1.46.1.45.1.44.08.44.08.4.06.4.07.4.04.4.04.37.03.37.02.36.02.34v.67l-.03.64-.03.3-.04.3-.05.3-.12.58-.08.27-.1.28-.2.52-.12.26-.12.25-.13.26-.14.25-.3.5-.17.24-.18.24-.2.24-.2.23-.2.24-.3.33-.3.3-.32.3-.34.26-.35.24-.36.23-.38.2-.4.2-.4.17-.42.14-.43.13-.92.2-.5.07-.5.05h-.5-1.08l-.56-.04-.57-.04-.6-.08-.6-.1-.62-.1-.66-.13-.65-.15-.68-.16-1.4-.4-.73-.22-.75-.25-.77-.26-.78-.3-.8-.3-.82-.32-.84-.34-.86-.37-1.8-.8-.92-.43-.93-.45-.33-.15-.34-.17-.37-.2-.4-.2-.42-.22-.43-.25-.45-.25-.46-.26-.48-.28-1.5-.9-.5-.32-.53-.3-1.04-.65-.53-.32-.53-.33-.5-.34-.52-.32-1-.64-.5-.33-.47-.3-.46-.3-.45-.3-.42-.3-.4-.28-.4-.27-.36-.24-.34-.25-.3-.23-.3-.2-.25-.2-.22-.17-.18-.17-.16-.13-.1-.12-.08-.1-.04-.07h0l.01-.04.02-.06.05-.05v-.04l.06-.06.1-.07.2-.16.06-.04.07-.05.06-.04.07-.04.07-.05.08-.05.08-.04.07-.05.16-.1.1-.05.1-.04.08-.06.4-.2.1-.06.1-.05.1-.04.22-.1.2-.1 2.62-1.1 9.13 5.35.92.52.9.5.88.5.87.47.84.44.83.43 1.6.8.78.37.74.34.74.33.72.3.7.28.68.27.66.24.63.22.63.2.6.18.58.16.56.14.54.12.52.1.5.08.48.07.46.03h.43.43l.4-.03.38-.04.35-.06.34-.1.32-.1.3-.13.27-.15.25-.17.23-.18.2-.22.18-.23.16-.26.22-.44.16-.5.1-.53.06-.6.02-.63-.03-.7-.08-.72-.12-.78-.18-.8-.2-.86-.26-.9-.3-.93-.35-.97-.38-1-.43-1.04-.47-1.07-.5-1.1-.55-1.14-.6-1.17-.63-1.18-.66-1.23-.7-1.24-.74-1.27-.77-1.3-1.64-2.65-.87-1.35-.9-1.37-.93-1.4-.97-1.4-2.03-2.84-1.05-1.43-1.1-1.46-1.1-1.45-1.15-1.48-1.16-1.47-1.2-1.48-1.22-1.48-1.23-1.5-4.17-4.9-2.05 7.54-.74 2.67-.76 2.65-.78 2.62-.8 2.57-.8 2.55-.84 2.5-.84 2.46-.87 2.43-.88 2.38-.88 2.35-.9 2.3-.9 2.25-.92 2.2-.94 2.14-.93 2.1-.95 2.05-.96 1.98-.96 1.93-.98 1.88-.96 1.82-.98 1.74-.98 1.7-.98 1.63-.98 1.56-1 1.5-.97 1.42-.98 1.35-.97 1.28-.98 1.2-.97 1.13-.96 1.05-.95.97-.96.88-.94.8-.93.73-.92.64-.92.55-.9.46-.88.37-.88.28-.2.05-.42.08-.22.02-.43.04h-.68l-.23-.02-.24-.02-.23-.03-.23-.04-.47-.1-.23-.06-.24-.06-.23-.08-.23-.07-.47-.18-.7-.3-.44-.22-.23-.12-.65-.4-.2-.14-.6-.45-.57-.5-.18-.17-.34-.38-.18-.2-.2-.25-.18-.26-.17-.28-.2-.3-.17-.32-.18-.33-.18-.36-.34-.76-.34-.82-.16-.43-.32-.9-.32-.94-.14-.5-.15-.5-.28-1.02-.26-1.06-.13-.54-.23-1.1-.22-1.12-.1-.56-.18-1.12-.08-.57-.14-1.12-.05-.56-.1-1.13-.08-1.1-.01-.54-.02-.4-.02-.44v-4.98l.03-1.26.01-.64.02-.64.01-.65.06-1.92.05-1.25.03-.6.02-.6.03-.58.02-.56.04-.54.06-1 .03-.47.03-.43.03-.4.03-.37.04-.34.03-.3.03-.26.04-.22.03-.18.03-.13.03-.08.03-.04.02.01.02-.01.03.02h.03l.03.02.03.01.1.05.03.03.16.1.05.03.12.08.07.04.07.05.3.2.1.06.07.05.1.06.1.07.08.05.2.14.1.06.3.2.3.22.2.14.2.16 2.5 1.85-.24 5.9-.03.64-.01.66v.65l-.02 1.3v1.3l.03 1.93.04 1.28.03.63.02.62.04.6.04.62.12 1.8.1 1.14.06.56.05.55.13 1.06.14 1.02.08.48.07.47.08.46.08.43.1.44.1.4.08.4.1.37.1.36.1.34.2.6.2.55.22.52.2.5.22.45.23.42.24.38.24.36.24.32.26.3.26.26.28.22.27.2.28.15.3.13.3.08.3.06.3.02h.33l.33-.05.34-.08.36-.12.35-.14.38-.18.38-.22.4-.24.4-.3.42-.32.42-.35.44-.4.44-.42.45-.46.47-.5.48-.53.5-.56.5-.6.5-.63.53-.67.55-.7.55-.73.57-.77.6-.87.63-.9.62-.95.63-.97.62-1.02.63-1.05.64-1.1.63-1.13.64-1.15.63-1.2.63-1.23.64-1.26 1.25-2.6.63-1.35.63-1.37.63-1.4.63-1.42.62-1.46.62-1.47.6-1.5.6-1.52.6-1.54.6-1.56 1.2-3.2.6-1.62.57-1.64.58-1.64.57-1.67.56-1.67.55-1.7.54-1.7.53-1.7.52-1.73.52-1.74.5-1.74.5-1.75.96-3.52 2.2-8.17-5.1-5.15-2.6-2.6-.4-.38-.18-.2-.2-.18-.2-.2-.18-.17-.18-.2-.36-.35-.16-.17-.66-.62-.14-.14-.14-.15-.28-.26-.12-.13-.12-.12-.12-.1-.3-.3-.1-.08-2.14-1.95-18.45 5.42-1.48.46-1.46.44-1.43.46-1.4.44-1.38.45-1.36.44-1.34.45-1.32.45-1.3.45-2.52.88-1.23.46-1.2.44-1.2.45-1.18.46-1.15.45-1.14.46-1.13.47-2.2.92-1.08.47-1.06.47-1.05.47-2.06.96-2 1-1.96 1-1.92 1.02-.95.52-.93.5-.93.54-1.97.98-.9.55-.9.56-.86.53-.82.53-.8.53-.76.52-.72.5-.7.5-.68.5-.63.5-.6.48-.58.5-.54.48-.5.46-.48.47-.45.45-.4.45-.4.44-.35.43-.32.43-.3.42-.26.4-.22.4-.2.4-.16.4-.13.38-.1.36-.07.36-.04.35v.35l.03.33.07.33.1.3.13.3.17.3.2.3.23.28.26.26.3.25.33.25.36.24.4.22.3.16.32.15.35.15.36.15.37.13.4.14.42.13.42.12.45.13.47.12.48.1 1 .2.52.1.54.1.56.1.57.08.58.08.6.08.6.07 1.25.13.64.05 1.32.1.67.04.68.03.7.04.7.02.72.02 1.44.02h2.22l.75-.02.76-.01.76-.02.77-.03.78-.04.14-.01.15-.01h.14l.15-.01.28-.02.28-.01h.15.56.13l.14-.01.52-.01.12-.01h.26l.1-.01h.24l.1-.01h.1l.2-.01.1-.01.1.01h.08l.08-.01h.5l.1.03.1.04.1.06.1.07.12.08.12.1.14.1.15.1.14.12.15.14.16.15.63.63.16.17.48.54.16.2.3.37.14.18.28.35.12.18.12.17.22.32.1.16.1.14.13.26.05.12.04.1.03.1.01.1v.07l-.02.06-.03.03-.25.07h-.08l-.2.02-.3.06h-.13l-.28.03-.14.02-.16.01-.16.02h-.17l-.35.03-.37.04-.2.01-.2.03-.62.04-.22.02-.45.04h-.23l-.23.02-.72.04h-.25l-.23.01-.25.02-1.03.05-1 .06-1 .03-.98.04-.97.03-1.9.02H26.3l-.9-.02h-.9l-.87-.04-.87-.03-1.67-.1-.82-.07-.8-.06-.8-.08-1.54-.18-1.48-.2-.7-.1-1.4-.26-.67-.14-.66-.15-.63-.15-.63-.17-1.2-.34-.58-.2-.55-.2-.54-.2-.53-.2-.52-.22-.5-.23-.48-.22-.46-.24-.45-.26-.4-.23-.4-.25-.38-.25-.35-.25-.34-.25-.33-.27-.6-.52-.28-.27-.25-.27-.24-.28-.23-.28-.4-.6-.18-.3-.16-.3-.14-.3-.13-.3-.1-.3-.17-.63-.05-.32-.05-.33-.03-.34-.01-.33.01-.35.02-.35.04-.34.05-.36.07-.36.08-.37.1-.37.12-.37.13-.38.15-.4.17-.4.18-.4.4-.8.22-.4.74-1.17.4-.57.44-.6.47-.58.5-.6.53-.6 1.14-1.18.62-.6.64-.6.68-.6.7-.6.73-.6.76-.6 1.6-1.2.84-.6.9-.6 1.83-1.2.96-.6 1-.6 1.02-.6 1.04-.6 1.08-.6 1.1-.6 1.13-.6 1.15-.6 1.2-.6 1.22-.6 1.23-.6 1.27-.6 1.3-.6 1.32-.6 1.35-.6 1.38-.6 1.4-.6 1.43-.6 1.46-.6.65-.27.7-.28.77-.3 1.67-.62.9-.34 1.9-.7 1-.35 1.03-.37 1.07-.37 1.07-.38 1.1-.37 1.1-.38 1.12-.38 1.14-.38 1.13-.38 2.26-.75 5.45-1.76 1.04-.32 1-.3.96-.3 1.83-.55.85-.25.8-.23.75-.2.7-.2.63-.17.58-.14.5-.13.44-.1.37-.08.3-.05.22-.01 1.55-.03-1.57-1.52-.26-.24-.3-.28-.32-.28-.36-.3-.38-.34-.4-.35-.45-.38-.46-.4-.5-.4-.5-.42-.54-.43-.54-.45-.58-.46-1.2-.94-.6-.48-1.28-1-.65-.5-1.32-1.02-1.34-1.02-.7-.5-.67-.5-.68-.5-1.34-1-.66-.5-.66-.48-.65-.47-.64-.46-.63-.46-.6-.43-.6-.42-.58-.42-.56-.4-.56-.38-.52-.36-.52-.34-1.54-1-.78-.5-.76-.48-1.54-.92-.77-.45-.76-.43-1.52-.84-.75-.4-.74-.4-.74-.38-.72-.36-1.44-.68-.7-.32-1.38-.6-.67-.27-.66-.27-.65-.25-.64-.23-.6-.22-1.2-.4-.58-.17-.55-.15-.54-.14-.53-.12-.5-.1-.48-.08-.48-.07-.44-.05-.43-.03h-.78l-.36.03-.34.04-.3.07-.35.1-.33.14-.3.2-.27.22-.23.25-.2.28-.18.32-.15.35-.13.38-.1.42-.06.44-.04.48-.01.5.02.53.05.56.06.6.1.62.12.63.15.67.18.7.2.73.22.73.55 1.57.3.8.33.83.36.86.4.88.4.9.43.9.47.94.48.94.5.97.53.98.56 1 .58 1.02.6 1.03.64 1.04.65 1.06.67 1.07 2.8 4.43-1.25 2.86-.05.12-.1.22-.05.13-.1.23-.06.1-.05.12-.05.1-.05.12-.04.1-.1.2-.04.1-.1.2-.03.1-.05.1-.1.24-.05.08-.03.07-.13.26-.1.16-.02.04-.03.04-.05.1-.07.07h-.05l-.16-.16-.12-.13-.13-.18-.16-.2-.18-.24-.2-.28-.22-.3-.23-.33-.5-.75-.27-.4-.28-.43-.3-.45L30 56l-.63-1-.66-1.03-1-1.6-.34-.56-.33-.55-.34-.54-.65-1.1-.33-.54-.3-.53-.32-.53-.58-1-.28-.5-.27-.47-.25-.46-.25-.43-.22-.4-.4-.76-.26-.48-.25-.5-.24-.5-.48-1.02-.22-.52-.45-1.05-.6-1.6-.2-.54-.18-.53-.2-.53-.34-1.06-.16-.54-.3-1.04-.28-1.03-.24-1-.1-.5-.2-.96-.08-.47-.14-.9-.06-.43-.04-.42-.04-.4-.02-.4v-.38l-.01-.36.01-.36v-.33l.06-.62.05-.27.1-.5.07-.24.08-.24.08-.25.08-.23.2-.48.2-.46.24-.46.12-.2.27-.44.14-.2.44-.6.16-.2.32-.37.17-.17.17-.18.17-.16.18-.17.37-.3.18-.14.2-.14L22 19l.38-.24.6-.3.4-.16.4-.13.73-.15.77-.1.8-.07.86-.01.9.03.94.1.96.13 1 .2 1.04.22 1.07.27 1.12.33 1.14.36 1.17.42 1.2.44 1.24.5 1.26.54 1.3.6 1.3.63 1.34.66 1.37.7 1.38.74 1.4.78 1.43.83 1.45.86 1.46.9 1.48.94 1.5.98 1.5 1 1.53 1.05 1.54 1.08 1.55 1.12 1.56 1.15 1.58 1.17 1.58 1.22 1.6 1.25 1.6 1.28 1.6 1.3 1.6 1.34 1.6 1.37 1.6 1.4 5.42 4.82L88.7 49l1.12-.2 1.07-.2.52-.1.75-.15.24-.03.46-.1.22-.04.43-.07.4-.07.2-.03.18-.03.35-.05.16-.02.15-.03.15-.02.27-.04.12-.01h.1.56l.08-.02.1-.04.08-.04.1-.06.16-.16.07-.1.08-.1.07-.13.07-.15.06-.16.08-.18.07-.2.06-.22.06-.23.06-.25.06-.27.07-.28.05-.3.06-.32.05-.34.06-.36.05-.4.06-.4.05-.43.05-.44.06-.47.05-.5.04-.5.05-.53.05-.56.05-.58.05-.6.05-.63.04-.65.05-.68.05-.7.05-.73.04-.75.06-1.1.05-1.1.04-1.06.06-2.1v-3l-.02-.97-.02-.96-.08-1.85-.05-.9-.07-.88-.07-.86-.08-.84-.1-.82-.1-.8-.1-.77-.1-.75-.13-.72-.12-.7-.14-.67-.15-.65-.15-.62-.16-.6-.17-.57-.17-.54-.2-.52-.2-.48-.2-.47-.2-.42-.22-.4-.22-.37-.23-.34-.23-.3-.24-.27-.25-.24-.25-.2-.27-.17-.26-.13-.3-.1-.3-.11-.3-.05-.3-.02-.3.01L92 6l-.33.05-.34.1-.34.12-.35.14-.72.4-.37.24-.38.26-.38.3-.4.32-.4.35-.4.38-.4.4-.4.44-.44.46-.43.48-.44.5-.45.55-.46.56-.45.6-.47.62-.48.64-.47.7-.5.7-.5.72-.5.77-.5.78-.5.8-.5.84-.53.86-1.06 1.8-.54.95-4.72 8.25-3.1.4-.1.01-.12.01h-.1-.12-.1-.1-.1-.8-.08-.07l-.1-.01h-.07l-.07-.01-.2-.04h-.1l-.1-.04h-.04l-.1-.06-.03-.02-.01-.03-.02-.02-.01-.04v-.03l.02-.12.03-.15.06-.2.07-.22.1-.24.1-.28.12-.3.15-.32L68 29l.17-.37.18-.4.2-.4.2-.43.2-.44.22-.45.24-.47.47-.98.5-1 .26-.5.26-.52.8-1.52.28-.5.27-.5.26-.5.28-.5.52-.94.26-.45.25-.44.25-.42.25-.4.23-.4.22-.36.22-.34.2-.33.2-.3.44-.65.88-1.27.43-.6.86-1.18.83-1.1.42-.54 1.22-1.53.4-.48.4-.46.4-.45.4-.43.78-.82.4-.4.76-.74.38-.34.74-.66.74-.6.37-.28.36-.27L87 2l.7-.45.36-.2.35-.2.35-.18.34-.16.36-.15.33-.15.34-.12.34-.1.33-.1.42-.1.22-.04.2-.02.22-.02.44-.02h.23l.23.01.22.02zM93.4 54l-1.16.23-1.25.3-1.2.35-1 .34-.76.3-.45.26-.08.2 1.14 1.27 1.7 1.75 1.82 1.78 1.48 1.37.7.54.16-.26.22-.63.26-.95.3-1.2.28-1.37.28-1.57.15-1.23v-.87l-.13-.56-.27-.24-.44-.04-.75.06-1 .15zm-48.7-.1l-4.34 1.68 1.3-2.42c1.68-3.17 5.8-7.83 9.24-10.44.18-.15 1.08-.86 2.72-2.15l2.32 1.64c1.27.9 2.35 1.77 2.4 2 .05.18-.83 1-1.94 1.7-1.16.76-3.28 2.5-4.73 3.86-1.84 1.8-3.86 2.98-6.97 4.14zm24.9 58.64c-10.8-1.44-21.16-8-27.37-17.4-2.63-4.02-5.8-12.95-6-16.85-.12-2.35.07-2.6 2.43-3.7 1.4-.63 2.62-1.1 2.76-1.06.1.1.5 2.38.8 5.16 1.1 8.96 6.72 17.88 14.56 22.95 4.32 2.86 10.6 5 15.18 5.26 1.78.1 3.3.4 3.33.6.07.25-.43 1.54-1.1 2.95l-1.18 2.6-3.43-.5zm4.3-76.72c-1.95-1.94 9.3-.5 15.27 2 3.42 1.4 3.68 1.6 3.44 3.15-.18 1.3-5.97 1.87-9.46.92-2.5-.68-6.43-3.26-9.25-6.06zm24.78 60.43c1.57-1.66 3.27-3.8 3.7-4.6 1.06-2.1 1.5-2.1 2.76-.36.56.88 1.35 1.9 1.74 2.45.5.64.01 1.67-1.63 3.8-3.97 5.2-13.04 12.18-12.28 9.44 1.38-4.5 3.2-8.05 5.72-10.72zm11.5-24.45c-1.94-2.4-2.9-4.28-3.57-6.82-1.68-6.27.9-12.08 3.24-7.47 1.32 2.5 3.28 10.33 3.57 14.07.17 1.83.08 3.4-.1 3.46-.24.06-1.6-1.45-3.13-3.24z"
        />
      </defs>
      <g fill="url(#dark-theme-blur-gradient)">
        <use
          xlinkHref="#dark-theme-blur-logo"
          filter="url(#dark-theme-blur-filter)"
        />
        <use xlinkHref="#dark-theme-blur-logo" />
      </g>
    </svg>
  ),
  ReactDropzone: (props: LucideProps) => (
    <svg
      width="143"
      height="143"
      viewBox="0 0 143 143"
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      {...props}
    >
      <title>logo</title>
      <defs>
        <path
          d="M31.404.88C12.504 6.148 0 15.503 0 28.068 0 48.24 32.221 60.137 71.393 60.137c39.171 0 71.393-11.898 71.393-32.069 0-12.68-12.735-22.091-31.925-27.332L95.617 15.98c6.261 1.046 11.951 2.493 16.78 4.276 4.737 1.749 8.354 3.726 10.568 5.659.845.737 1.394 1.389 1.677 1.899.118.214.133.268.133.254 0-.013-.015.041-.133.255-.283.51-.832 1.162-1.677 1.899-2.214 1.933-5.831 3.91-10.569 5.66-10.558 3.898-25.236 6.19-41.003 6.19-15.768 0-30.445-2.292-41.004-6.19-4.737-1.75-8.355-3.727-10.569-5.66-.845-.737-1.393-1.389-1.676-1.9-.119-.213-.134-.267-.134-.254 0 .014.015-.04.134-.254.283-.51.831-1.162 1.676-1.9 2.214-1.932 5.832-3.91 10.57-5.658 4.681-1.73 10.173-3.142 16.211-4.18L31.404.88z"
          id="a"
        />
      </defs>
      <g fill="none" fillRule="evenodd">
        <g transform="translate(0 81.355)">
          <mask id="b" fill="#fff">
            <use xlinkHref="#a" />
          </mask>
          <use fill="#D0021B" fillRule="nonzero" xlinkHref="#a" />
          <path
            d="M71.141 41.968c37.301 0 67.54-14.771 67.54-34.226s-30.239-35.226-67.54-35.226c-37.3 0-67.539 15.771-67.539 35.226s30.238 34.226 67.54 34.226z"
            fillOpacity=".186"
            fill="#000"
            mask="url(#b)"
          />
        </g>
        <path
          d="M29.732 44.663L70.46 85.514l41.436-41.56 10.835 10.802-52.271 52.428-51.564-51.719 10.835-10.802zm0-43.355L70.46 42.16 111.897.599 122.732 11.4 70.461 63.83 18.897 12.11 29.732 1.308z"
          fill="#D0021B"
          fillRule="nonzero"
        />
      </g>
    </svg>
  ),
  Sonner: (props: LucideProps) => <Bell {...props} />,
  Devfolioco: (props: LucideProps) => <TextCursorInput {...props} />,
  Npmjs: (props: LucideProps) => <Hexagon {...props} />,
};

export const MdxIcons = {
  Info: (props: LucideProps) => <Info {...props} />,
  AlertTriangle: (props: LucideProps) => <AlertTriangle {...props} />,
};
