#!/usr/bin/python
# -*- coding: utf-8 -*-
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>
#
# @author : beaengine@gmail.com

from headers.BeaEnginePython import *
from nose.tools import *

class TestSuite:
    def test(self):



        # NP 0F D7 /r1
        # PMOVMSKB reg, mm

        Buffer = bytes.fromhex('0fd7c0')
        myDisasm = Disasm(Buffer)
        myDisasm.read()
        assert_equal(myDisasm.infos.Instruction.Opcode, 0xfd7)
        assert_equal(myDisasm.infos.Instruction.Mnemonic, b'pmovmskb')
        assert_equal(myDisasm.repr(), 'pmovmskb rax, mm0')

        # 66 0F D7 /r
        # PMOVMSKB reg, xmm

        Buffer = bytes.fromhex('660fd7c0')
        myDisasm = Disasm(Buffer)
        myDisasm.read()
        assert_equal(myDisasm.infos.Instruction.Opcode, 0xfd7)
        assert_equal(myDisasm.infos.Instruction.Mnemonic, b'pmovmskb')
        assert_equal(myDisasm.repr(), 'pmovmskb rax, xmm0')

        # VEX.128.66.0F.WIG D7 /r
        # VPMOVMSKB reg, xmm1

        myVEX = VEX('VEX.128.66.0F.WIG')
        myVEX.vvvv = 0b1111
        Buffer = bytes.fromhex('{}d7c0'.format(myVEX.c4()))
        myDisasm = Disasm(Buffer)
        myDisasm.read()
        assert_equal(myDisasm.infos.Instruction.Opcode, 0xd7)
        assert_equal(myDisasm.infos.Instruction.Mnemonic, b'vpmovmskb')
        assert_equal(myDisasm.repr(), 'vpmovmskb r8, xmm8')

        # VEX.256.66.0F.WIG D7 /r
        # VPMOVMSKB reg, ymm1

        myVEX = VEX('VEX.256.66.0F.WIG')
        myVEX.vvvv = 0b1111
        Buffer = bytes.fromhex('{}d7c0'.format(myVEX.c4()))
        myDisasm = Disasm(Buffer)
        myDisasm.read()
        assert_equal(myDisasm.infos.Instruction.Opcode, 0xd7)
        assert_equal(myDisasm.infos.Instruction.Mnemonic, b'vpmovmskb')
        assert_equal(myDisasm.repr(), 'vpmovmskb r8, ymm8')


        myVEX = VEX('VEX.256.66.0F.WIG')
        myVEX.vvvv = 0b1110
        Buffer = bytes.fromhex('{}d7c0'.format(myVEX.c4()))
        myDisasm = Disasm(Buffer)
        myDisasm.read()
        assert_equal(myDisasm.infos.Instruction.Opcode, 0xd7)
        assert_equal(myDisasm.infos.Instruction.Mnemonic, b'vpmovmskb')
        assert_equal(myDisasm.infos.Reserved_.ERROR_OPCODE, UD_)
