# Project - Art Gallery Management System

### Full Stack Development with C#, ASP.NET, Entity Framework, SQL Server

---

- Bu proje, Üniversite sırasında geliştirdiğim bir `Tam Yığın (Full Stack)` Sanat Galerisi Yönetim Sistemi'ne aittir. Backend kısmı `C#` ve `ASP.NET` ile geliştirilmiş, `Entity Framework` ile veritabanı işlemleri yapılmıştır. `SQL Server` veritabanı yönetimi kullanılmıştır. Proje, kullanıcıların sanat galerisi üzerindeki tüm işlemleri gerçekleştirmesine olanak tanır.

---

## 1. Proje Hakkında (Overview)

- **Kullanılan Teknolojiler**:
   - Backend: C#, ASP.NET, Entity Framework
   - Frontend: HTML, CSS, JavaScript
   - Veritabanı: SQL Server    

- **Kullanılan Programlar**:
   - Backend Geliştirme: Visual Studio
   - Veritabanı Yönetimi: SQL Server Management Studio (SSMS)

- **Veritabanı Yapısı**:
   - User Table: Çalışan adı, soyadı, e-posta bilgilerini içerir.
   - Artwork Table: Sanat eserlerinin bilgilerini içerir, sanatçı ve tür bilgilerini de tutar.

- **Temel Özellikler**:
   - CRUD işlemleri
   - Kullanıcı dostu arayüz
   - Oturum açma ve yetkilendirme
   - Kullanıcı yönetimi

---

## 2. Teknik Bilgiler (Technical Details)

- **Backend**:
   - Mimari: Model-View-Controller (MVC)
   - ASP.NET Core kullanılarak geliştirilmiş ve SQL Server veritabanına bağlanmıştır.

- **Frontend**:
   - HTML/CSS/JS kullanılarak geliştirilen dinamik ve kullanıcı dostu bir arayüz.
   - Formlar ve Veritabanı Entegrasyonu: CRUD işlemleri yapılabilen formlar bulunmaktadır.

- **Öne Çıkan Özellikler**:
   - CRUD İşlemleri: Sanat eserleri ve çalışanlar üzerinde ekleme, silme, güncelleme ve listeleme işlemleri yapılabilir.
   - Entity Framework ile veritabanı yönetimi.
   - ASP.NET ile güvenli ve verimli backend geliştirme.
   - Kullanıcı Yetkilendirme: Yönetici ve kullanıcı rollerine dayalı erişim kontrolü.

---

## 3. Öne Çıkan Özellikler (Key Features)

   - Tam Yığın Geliştirme (Full Stack Development): Backend ve frontend entegrasyonu.
   - SQL Server ile Veritabanı Yönetimi: Güvenli ve verimli veri depolama.
   - RESTful API: API üzerinden veritabanı işlemleri gerçekleştirilmiştir.
   - Entity Framework: Veritabanı erişim katmanı.
   - Authentication & Authorization: Kullanıcıların sisteme giriş yapabilmesi için kullanıcı doğrulama.

---

## 4. Demo ve Ekran Görüntüleri (Demo & Screenshots)

- Proje, terminal üzerinden veya Microsoft Visual Studio'da çalıştırılabilir.

---

## 5. Katkıda Bulunanlar ve Kaynaklar (Contributors & Resources)

- **Proje Sahibi**: [Batuhan Baysal](https://www.linkedin.com/in/batuhan-baysal-502656170/)

- **Kaynaklar**:
   - ASP.NET Resmi Dokümantasyonu
   - SQL Server Yönetimi

---

## 6. İletişim ve Destek (Contact & Support)

- **LinkedIn**: [Batuhan Baysal LinkedIn Profilim](https://www.linkedin.com/in/batuhan-baysal-502656170/)

- **Github**: [Batuhan Baysal GitHub Profilim](https://github.com/BatuhanBaysal)
