import 'package:data_connection_checker/data_connection_checker.dart';

abstract class NetworkInfo {
  Future<bool> get isConnected;
}

class NetworkInfoImpl implements NetworkInfo {
  final DataConnectionChecker connectionChecker;
  NetworkInfoImpl({this.connectionChecker});
  @override
  Future<bool> get isConnected {
    if (connectionChecker != null) {
      return connectionChecker.hasConnection;
    } else {
      return Future.value(true);
    }
  }
}
