window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"sqlite_integrated": {"fullname": "sqlite_integrated", "modulename": "sqlite_integrated", "kind": "module", "doc": "<p></p>\n"}, "sqlite_integrated.ForeignKey": {"fullname": "sqlite_integrated.ForeignKey", "modulename": "sqlite_integrated", "qualname": "ForeignKey", "kind": "class", "doc": "<p>Class representing an sql foreign key</p>\n"}, "sqlite_integrated.ForeignKey.__init__": {"fullname": "sqlite_integrated.ForeignKey.__init__", "modulename": "sqlite_integrated", "qualname": "ForeignKey.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">to_col</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">from_col</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">seq</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">on_update</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">on_delete</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">match</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "sqlite_integrated.ForeignKey.table": {"fullname": "sqlite_integrated.ForeignKey.table", "modulename": "sqlite_integrated", "qualname": "ForeignKey.table", "kind": "variable", "doc": "<p>The table the foreign key points to</p>\n", "annotation": ": str"}, "sqlite_integrated.ForeignKey.to_col": {"fullname": "sqlite_integrated.ForeignKey.to_col", "modulename": "sqlite_integrated", "qualname": "ForeignKey.to_col", "kind": "variable", "doc": "<p>Column the foreign key points to</p>\n", "annotation": ": str"}, "sqlite_integrated.ForeignKey.from_col": {"fullname": "sqlite_integrated.ForeignKey.from_col", "modulename": "sqlite_integrated", "qualname": "ForeignKey.from_col", "kind": "variable", "doc": "<p>Column in current table, containing the key value</p>\n", "annotation": ": str", "default_value": "None"}, "sqlite_integrated.ForeignKey.id": {"fullname": "sqlite_integrated.ForeignKey.id", "modulename": "sqlite_integrated", "qualname": "ForeignKey.id", "kind": "variable", "doc": "<p>The foreign key id</p>\n", "annotation": ": int", "default_value": "None"}, "sqlite_integrated.ForeignKey.seq": {"fullname": "sqlite_integrated.ForeignKey.seq", "modulename": "sqlite_integrated", "qualname": "ForeignKey.seq", "kind": "variable", "doc": "<p>The foreign key sequence attribute</p>\n", "annotation": ": int", "default_value": "None"}, "sqlite_integrated.ForeignKey.on_update": {"fullname": "sqlite_integrated.ForeignKey.on_update", "modulename": "sqlite_integrated", "qualname": "ForeignKey.on_update", "kind": "variable", "doc": "<p>The action the column will do if the data the key is pointing to changes. (Provide sql action).</p>\n", "annotation": ": str", "default_value": "None"}, "sqlite_integrated.ForeignKey.on_delete": {"fullname": "sqlite_integrated.ForeignKey.on_delete", "modulename": "sqlite_integrated", "qualname": "ForeignKey.on_delete", "kind": "variable", "doc": "<p>The action the column will do if the data the key is pointing to changes. (Provide sql action).</p>\n", "annotation": ": str", "default_value": "None"}, "sqlite_integrated.ForeignKey.to_sql": {"fullname": "sqlite_integrated.ForeignKey.to_sql", "modulename": "sqlite_integrated", "qualname": "ForeignKey.to_sql", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Column": {"fullname": "sqlite_integrated.Column", "modulename": "sqlite_integrated", "qualname": "Column", "kind": "class", "doc": "<p>Class representing en sql column.</p>\n"}, "sqlite_integrated.Column.__init__": {"fullname": "sqlite_integrated.Column.__init__", "modulename": "sqlite_integrated", "qualname": "Column.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"nb\">type</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">not_null</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">default_value</span><span class=\"p\">:</span> <span class=\"o\">&lt;</span><span class=\"n\">built</span><span class=\"o\">-</span><span class=\"ow\">in</span> <span class=\"n\">function</span> <span class=\"nb\">any</span><span class=\"o\">&gt;</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">primary_key</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">col_id</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">foreign_key</span><span class=\"p\">:</span> <span class=\"n\">sqlite_integrated</span><span class=\"o\">.</span><span class=\"n\">ForeignKey</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, "sqlite_integrated.Column.name": {"fullname": "sqlite_integrated.Column.name", "modulename": "sqlite_integrated", "qualname": "Column.name", "kind": "variable", "doc": "<p>Name of the column.</p>\n"}, "sqlite_integrated.Column.type": {"fullname": "sqlite_integrated.Column.type", "modulename": "sqlite_integrated", "qualname": "Column.type", "kind": "variable", "doc": "<p>Type of the data in the column.</p>\n"}, "sqlite_integrated.Column.not_null": {"fullname": "sqlite_integrated.Column.not_null", "modulename": "sqlite_integrated", "qualname": "Column.not_null", "kind": "variable", "doc": "<p>Sql NOT NULL constraint.</p>\n"}, "sqlite_integrated.Column.default_value": {"fullname": "sqlite_integrated.Column.default_value", "modulename": "sqlite_integrated", "qualname": "Column.default_value", "kind": "variable", "doc": "<p>Sql DEFAULT. Default value for the column.</p>\n"}, "sqlite_integrated.Column.primary_key": {"fullname": "sqlite_integrated.Column.primary_key", "modulename": "sqlite_integrated", "qualname": "Column.primary_key", "kind": "variable", "doc": "<p>Sql PRIMARY KEY. Automatic column that ensures that every entry has a unique.</p>\n"}, "sqlite_integrated.Column.col_id": {"fullname": "sqlite_integrated.Column.col_id", "modulename": "sqlite_integrated", "qualname": "Column.col_id", "kind": "variable", "doc": "<p>Id if the column in the table.</p>\n"}, "sqlite_integrated.Column.foreign_key": {"fullname": "sqlite_integrated.Column.foreign_key", "modulename": "sqlite_integrated", "qualname": "Column.foreign_key", "kind": "variable", "doc": "<p>ForeignKey object, that representing an sql foreign key.</p>\n"}, "sqlite_integrated.DatabaseEntry": {"fullname": "sqlite_integrated.DatabaseEntry", "modulename": "sqlite_integrated", "qualname": "DatabaseEntry", "kind": "class", "doc": "<p>A python dictionary that keeps track of the table it belongs to. This class is not meant to be created manually.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>entry_dict : dict\n    A dictionary containing all the information. This information can be accesed just like any other python dict with <code>my_entry[my_key]</code>.\ntable : str\n    The name of the table the entry is a part of</p>\n", "bases": "builtins.dict"}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"fullname": "sqlite_integrated.DatabaseEntry.from_raw_entry", "modulename": "sqlite_integrated", "qualname": "DatabaseEntry.from_raw_entry", "kind": "function", "doc": "<p>Alternative constructor for converting a raw entry to a DatabaseEntry.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>raw_entry : tuple\n    A tuple with the data for the entry. Ex: <code>(2, \"Tom\", \"Builder\", 33)</code>\ntable_fields : list\n    A list of column names for the data. Ex: <code>[\"id\", \"FirstName\", \"LastName\", \"Age\"]</code>\ntable_name : str\n    The name of the table (in the database) that the data belongs to. Ex: \"people\"</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">raw_entry</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span>, </span><span class=\"param\"><span class=\"n\">table_fields</span><span class=\"p\">:</span> <span class=\"nb\">list</span>, </span><span class=\"param\"><span class=\"n\">table_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.raw_table_to_table": {"fullname": "sqlite_integrated.raw_table_to_table", "modulename": "sqlite_integrated", "qualname": "raw_table_to_table", "kind": "function", "doc": "<p>Convert a raw table (list of tuples) to a table (generator of DatabaseEntry).</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>raw_table : list\n    A list of tuples with the data for the entries.\nfields : list\n    A list of column names for the data. Ex: <code>[\"id\", \"FirstName\", \"LastName\", \"Age\"]</code>\ntable_name: str\n    The name of the table (in the database) that the data belongs to. Ex: \"people\".</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">raw_table</span><span class=\"p\">:</span> <span class=\"nb\">list</span>,</span><span class=\"param\">\t<span class=\"n\">fields</span><span class=\"p\">:</span> <span class=\"nb\">list</span>,</span><span class=\"param\">\t<span class=\"n\">table_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">sqlite_integrated</span><span class=\"o\">.</span><span class=\"n\">DatabaseEntry</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.string_to_list": {"fullname": "sqlite_integrated.string_to_list", "modulename": "sqlite_integrated", "qualname": "string_to_list", "kind": "function", "doc": "<p>Takes a string with comma seperated values, returns a list of the values. (spaces are ignored)</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">string</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.value_to_sql_value": {"fullname": "sqlite_integrated.value_to_sql_value", "modulename": "sqlite_integrated", "qualname": "value_to_sql_value", "kind": "function", "doc": "<p>Converts python values to sql values. Basically just puts quotes around strings and not ints or floats. Also converts None to null</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">value</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.dict_to_sql": {"fullname": "sqlite_integrated.dict_to_sql", "modulename": "sqlite_integrated", "qualname": "dict_to_sql", "kind": "function", "doc": "<p>Converts a dict into sql key value pairs. Ex: \"key1 = value1, key2 = value2...\"</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.DatabaseError": {"fullname": "sqlite_integrated.DatabaseError", "modulename": "sqlite_integrated", "qualname": "DatabaseError", "kind": "class", "doc": "<p>Raised when the database fails to execute command</p>\n", "bases": "builtins.Exception"}, "sqlite_integrated.QueryError": {"fullname": "sqlite_integrated.QueryError", "modulename": "sqlite_integrated", "qualname": "QueryError", "kind": "class", "doc": "<p>Raised when trying to create an invalid or unsupperted query</p>\n", "bases": "builtins.Exception"}, "sqlite_integrated.Query": {"fullname": "sqlite_integrated.Query", "modulename": "sqlite_integrated", "qualname": "Query", "kind": "class", "doc": "<p>A class for writing sql queries. Queries can be run on the attached database or a seperate one with the <code>run</code> method.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>db : Database, optional\n    The attached Database. This is the default database to run queries on.\nverbose : bool, optional\n    Print what is going on in the <code>Query</code></p>\n"}, "sqlite_integrated.Query.__init__": {"fullname": "sqlite_integrated.Query.__init__", "modulename": "sqlite_integrated", "qualname": "Query.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">db</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span></span>)</span>"}, "sqlite_integrated.Query.sql": {"fullname": "sqlite_integrated.Query.sql", "modulename": "sqlite_integrated", "qualname": "Query.sql", "kind": "variable", "doc": "<p>The current raw sql command</p>\n"}, "sqlite_integrated.Query.history": {"fullname": "sqlite_integrated.Query.history", "modulename": "sqlite_integrated", "qualname": "Query.history", "kind": "variable", "doc": "<p>The history of commandmethods run on this object</p>\n"}, "sqlite_integrated.Query.fields": {"fullname": "sqlite_integrated.Query.fields", "modulename": "sqlite_integrated", "qualname": "Query.fields", "kind": "variable", "doc": "<p>The selected fields</p>\n"}, "sqlite_integrated.Query.table": {"fullname": "sqlite_integrated.Query.table", "modulename": "sqlite_integrated", "qualname": "Query.table", "kind": "variable", "doc": "<p>The table the sql query is interacting with</p>\n"}, "sqlite_integrated.Query.verbose": {"fullname": "sqlite_integrated.Query.verbose", "modulename": "sqlite_integrated", "qualname": "Query.verbose", "kind": "variable", "doc": "<p>Print what is going on in the <code>Query</code></p>\n"}, "sqlite_integrated.Query.valid_prefixes": {"fullname": "sqlite_integrated.Query.valid_prefixes", "modulename": "sqlite_integrated", "qualname": "Query.valid_prefixes", "kind": "function", "doc": "<p>Check if a statement is valid given its prefix</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">prefixes</span><span class=\"p\">:</span> <span class=\"nb\">list</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Query.SELECT": {"fullname": "sqlite_integrated.Query.SELECT", "modulename": "sqlite_integrated", "qualname": "Query.SELECT", "kind": "function", "doc": "<p>Sql <code>SELECT</code> statement. Must be followed by <code>FROM</code> statement.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>selection : str/list, optional\n    Either a python list or sql list of table names. Selects all columns if not set.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">selection</span><span class=\"o\">=</span><span class=\"s1\">&#39;*&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Query.FROM": {"fullname": "sqlite_integrated.Query.FROM", "modulename": "sqlite_integrated", "qualname": "Query.FROM", "kind": "function", "doc": "<p>Sql <code>FROM</code> statement. Has to be preceded by a SELECT statement. Can be followed by <code>WHERE</code> statement.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table_name : str\n    Name of the table you are selecting from.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table_name</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Query.WHERE": {"fullname": "sqlite_integrated.Query.WHERE", "modulename": "sqlite_integrated", "qualname": "Query.WHERE", "kind": "function", "doc": "<p>Sql <code>WHERE</code> statement. Can be followed by <code>LIKE</code> statement.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>col_name : str\n    The name of the column. You can also just pass it a statement like: <code>\"id\" = 4</code> instead of providing a value.\nvalue : optional\n    The value of the column.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">col_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">value</span><span class=\"o\">=</span><span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Query.LIKE": {"fullname": "sqlite_integrated.Query.LIKE", "modulename": "sqlite_integrated", "qualname": "Query.LIKE", "kind": "function", "doc": "<p>Sql LIKE statement. Has to be preceded by a WHERE statement.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>pattern : str\n    A typical sql LIKE pattern with % and _.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">pattern</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Query.UPDATE": {"fullname": "sqlite_integrated.Query.UPDATE", "modulename": "sqlite_integrated", "qualname": "Query.UPDATE", "kind": "function", "doc": "<p>Sql UPDATE statement. Must be followed by <code>SET</code> statement.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table_name : str\n    Name of the table you are updating.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Query.SET": {"fullname": "sqlite_integrated.Query.SET", "modulename": "sqlite_integrated", "qualname": "Query.SET", "kind": "function", "doc": "<p>Sql SET statement. Must be preceded by an UPDATE statement. Must be followed by <code>WHERE</code> statement.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>data : dict\n    A dictionaty with key and value pairs.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Query.INSERT_INTO": {"fullname": "sqlite_integrated.Query.INSERT_INTO", "modulename": "sqlite_integrated", "qualname": "Query.INSERT_INTO", "kind": "function", "doc": "<p>Sql <code>INSERT INTO</code> statement. Must be followed by <code>VALUES</code> statement.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table_name : str\n    Name of the table you want to insert into.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Query.VALUES": {"fullname": "sqlite_integrated.Query.VALUES", "modulename": "sqlite_integrated", "qualname": "Query.VALUES", "kind": "function", "doc": "<p>Sql <code>VALUES</code> statement. Must be preceded by INSERT_INTO statement.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>data : dict\n    Dictionary with key value pairs.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">dict</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Query.DELETE_FROM": {"fullname": "sqlite_integrated.Query.DELETE_FROM", "modulename": "sqlite_integrated", "qualname": "Query.DELETE_FROM", "kind": "function", "doc": "<p>Sql <code>DELETE FROM</code> statement. Must be followed by <code>WHERE</code> statement.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>data : dict\n    Dictionary with key value pairs.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Query.run": {"fullname": "sqlite_integrated.Query.run", "modulename": "sqlite_integrated", "qualname": "Query.run", "kind": "function", "doc": "<p>Execute the query in the attached database or in a seperate one. Returns the results in a table (generator of DatabaseEntry) or <code>None</code> if no results.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>db : Database, optional\n    The database to execute to query on.\nraw : bool, optional\n    If True: returns the raw table (list of tuples) instead of the normal table.\nverbose : bool, optional\n    Be verbose about it.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">db</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">raw</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">sqlite_integrated</span><span class=\"o\">.</span><span class=\"n\">DatabaseEntry</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database": {"fullname": "sqlite_integrated.Database", "modulename": "sqlite_integrated", "qualname": "Database", "kind": "class", "doc": "<p>Main database class for manipulating sqlite3 databases.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>path : str\n    Path to the database file.\nnew : bool, optional\n    A new blank database will be created where the <code>self.path</code> is pointing.\nverbose : bool, optional\n    Enables feedback in the form of prints.</p>\n"}, "sqlite_integrated.Database.__init__": {"fullname": "sqlite_integrated.Database.__init__", "modulename": "sqlite_integrated", "qualname": "Database.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">new</span><span class=\"o\">=</span><span class=\"kc\">False</span>, </span><span class=\"param\"><span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span>, </span><span class=\"param\"><span class=\"n\">silent</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "sqlite_integrated.Database.path": {"fullname": "sqlite_integrated.Database.path", "modulename": "sqlite_integrated", "qualname": "Database.path", "kind": "variable", "doc": "<p>Path to the database file.</p>\n"}, "sqlite_integrated.Database.conn": {"fullname": "sqlite_integrated.Database.conn", "modulename": "sqlite_integrated", "qualname": "Database.conn", "kind": "variable", "doc": "<p>The sqlite3 connection.</p>\n"}, "sqlite_integrated.Database.cursor": {"fullname": "sqlite_integrated.Database.cursor", "modulename": "sqlite_integrated", "qualname": "Database.cursor", "kind": "variable", "doc": "<p>The sqlite3 cursor. Use <code>cursor.execute(cmd)</code> to execute raw sql.</p>\n"}, "sqlite_integrated.Database.connected": {"fullname": "sqlite_integrated.Database.connected", "modulename": "sqlite_integrated", "qualname": "Database.connected", "kind": "variable", "doc": "<p>Is true if the <code>Database</code> instance is connected to a database.</p>\n", "annotation": ": bool"}, "sqlite_integrated.Database.verbose": {"fullname": "sqlite_integrated.Database.verbose", "modulename": "sqlite_integrated", "qualname": "Database.verbose", "kind": "variable", "doc": "<p>Enables feedback in the form of prints.</p>\n"}, "sqlite_integrated.Database.in_memory": {"fullname": "sqlite_integrated.Database.in_memory", "modulename": "sqlite_integrated", "qualname": "Database.in_memory", "kind": "function", "doc": "<p>Create a database in memory. Returns the <code>Database</code> instance.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>verbose : bool, optional\n    Enables feedback in the form of prints.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.create_table": {"fullname": "sqlite_integrated.Database.create_table", "modulename": "sqlite_integrated", "qualname": "Database.create_table", "kind": "function", "doc": "<p>Creates a table in the Database.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    Name of the new table.\ncols : list[Column]\n    List of columns in the new table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">cols</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">sqlite_integrated</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.rename_table": {"fullname": "sqlite_integrated.Database.rename_table", "modulename": "sqlite_integrated", "qualname": "Database.rename_table", "kind": "function", "doc": "<p>Renames a table in the database.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>current_name : str\n    Current name of a table.\nnew_name : str\n    New name of the table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">current_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">new_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.delete_table": {"fullname": "sqlite_integrated.Database.delete_table", "modulename": "sqlite_integrated", "qualname": "Database.delete_table", "kind": "function", "doc": "<p>Takes a table name and deletes the table from the database.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table_name : str\n    Name of the table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table_name</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.add_column": {"fullname": "sqlite_integrated.Database.add_column", "modulename": "sqlite_integrated", "qualname": "Database.add_column", "kind": "function", "doc": "<p>Add column to a table in the database.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table_name : str\n    Name of the table.\ncol : Column\n    The column to add to table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">col</span><span class=\"p\">:</span> <span class=\"n\">sqlite_integrated</span><span class=\"o\">.</span><span class=\"n\">Column</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.rename_column": {"fullname": "sqlite_integrated.Database.rename_column", "modulename": "sqlite_integrated", "qualname": "Database.rename_column", "kind": "function", "doc": "<p>Renames a column in the database.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table_name : str\n    Name of the table.\ncurrent_column_name : str\n    Current name of a column.\nnew_column_name : str\n    New name of the column.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">table_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">current_column_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">new_column_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.delete_column": {"fullname": "sqlite_integrated.Database.delete_column", "modulename": "sqlite_integrated", "qualname": "Database.delete_column", "kind": "function", "doc": "<p>Deletes a column in a table.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table_name : str\n    Name of the table the column is in.\ncol : str/Column\n    Column, or column name, of the column that should be deleted.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">col</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.get_table_names": {"fullname": "sqlite_integrated.Database.get_table_names", "modulename": "sqlite_integrated", "qualname": "Database.get_table_names", "kind": "function", "doc": "<p>Returns the names of all tables in the database.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.is_table": {"fullname": "sqlite_integrated.Database.is_table", "modulename": "sqlite_integrated", "qualname": "Database.is_table", "kind": "function", "doc": "<p>Check if database has a table with a certain name.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table_name : str\n    Name to check.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.get_table_raw": {"fullname": "sqlite_integrated.Database.get_table_raw", "modulename": "sqlite_integrated", "qualname": "Database.get_table_raw", "kind": "function", "doc": "<p>Returns all entries in a table as a list of tuples.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    Name of the table.\nget_only : list, optional\n    Can be set to a list of column/field names, to only retrieve those columns/fields.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">get_only</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.get_table": {"fullname": "sqlite_integrated.Database.get_table", "modulename": "sqlite_integrated", "qualname": "Database.get_table", "kind": "function", "doc": "<p>Returns all entries in a table as a table (generator of DatabaseEntry). This function loops over all entries in the table, so it is not the best in very big databases.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    Name of the table.\nget_only : list/None, optional\n    Can be set to a list of column/field names, to only retrieve those columns/fields.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">get_only</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.get_table_cols": {"fullname": "sqlite_integrated.Database.get_table_cols", "modulename": "sqlite_integrated", "qualname": "Database.get_table_cols", "kind": "function", "doc": "<p>Returns a list of Column objects, that contain information about the table columns.</p>\n\n<h2 id=\"parameters\">Parameters </h2>\n\n<p>name : str\n    Name of the table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">sqlite_integrated</span><span class=\"o\">.</span><span class=\"n\">Column</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.get_table_id_field": {"fullname": "sqlite_integrated.Database.get_table_id_field", "modulename": "sqlite_integrated", "qualname": "Database.get_table_id_field", "kind": "function", "doc": "<p>Takes a table and returns the name of the field/column marked as a <code>PRIMARY KEY</code>. (This function assumes that there is only ONE field marked as a <code>PRIMARY KEY</code>).</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table : str\n    Name of the table.\ndo_error : bool, optional\n    If True: Raises error if the table does not contain a field marked as <code>PRIMARY KEY</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">do_error</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.table_overview": {"fullname": "sqlite_integrated.Database.table_overview", "modulename": "sqlite_integrated", "qualname": "Database.table_overview", "kind": "function", "doc": "<p>Prints a pretty table (with a name).</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>name : str\n    Name of the table.\nmax_len : int, optional\n    The max number of rows shown.\nget_only : list, optional\n    If given a list of column/field names: only shows those.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">max_len</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">40</span>, </span><span class=\"param\"><span class=\"n\">get_only</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.overview": {"fullname": "sqlite_integrated.Database.overview", "modulename": "sqlite_integrated", "qualname": "Database.overview", "kind": "function", "doc": "<p>Prints an overview of all the tables in the database with their fields.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>more : optional\n    If true: Prints more information on the columns in each table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">more</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.get_column_names": {"fullname": "sqlite_integrated.Database.get_column_names", "modulename": "sqlite_integrated", "qualname": "Database.get_column_names", "kind": "function", "doc": "<p>Returns the field/column names for a given table.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table_name : str\n    Name of the table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.is_column": {"fullname": "sqlite_integrated.Database.is_column", "modulename": "sqlite_integrated", "qualname": "Database.is_column", "kind": "function", "doc": "<p>Returns True if the given column name exists in the given table. Else returns False.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table_name : str\n    Name of a table.\ncol_name : str\n    Name of a column that may be in the table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">col_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.fill_null": {"fullname": "sqlite_integrated.Database.fill_null", "modulename": "sqlite_integrated", "qualname": "Database.fill_null", "kind": "function", "doc": "<p>Fills out any unpopulated fields in a DatabaseEntry (fields that exist in the database table but not in the entry) and returns it.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>entry : DatabaseEntry\n    The DatabaseEntry.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">entry</span><span class=\"p\">:</span> <span class=\"n\">sqlite_integrated</span><span class=\"o\">.</span><span class=\"n\">DatabaseEntry</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlite_integrated</span><span class=\"o\">.</span><span class=\"n\">DatabaseEntry</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.get_entry_by_id": {"fullname": "sqlite_integrated.Database.get_entry_by_id", "modulename": "sqlite_integrated", "qualname": "Database.get_entry_by_id", "kind": "function", "doc": "<p>Get table entry by id.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table : str\n    Name of the table.\nID : <br />\n    The entry id.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table</span>, </span><span class=\"param\"><span class=\"n\">ID</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlite_integrated</span><span class=\"o\">.</span><span class=\"n\">DatabaseEntry</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.add_entry": {"fullname": "sqlite_integrated.Database.add_entry", "modulename": "sqlite_integrated", "qualname": "Database.add_entry", "kind": "function", "doc": "<p>Add an entry to the database by passing a DatabaseEntry, or with a dictionary and specifying a table name. </p>\n\n<p>Returns the id of the added DatabaseEntry in the table, or <code>None</code> if table does not contain a primary key.</p>\n\n<p>The entry must have values for all fields in the table. You can pass <code>fill_null=True</code> to fill any remaining fields with <code>None</code>/<code>null</code>.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>entry : DatabaseEntry/dict\n    The entry.\ntable : str, optional\n    Name of the table the entry belongs to. <strong>Needed if adding an entry with a dictionary</strong>.\nfill_null : bool, optional\n    Fill in unpopulated fields with null values.\nverbose : bool, optional\n    Enable prints.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">entry</span>, </span><span class=\"param\"><span class=\"n\">table</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">fill_null</span><span class=\"o\">=</span><span class=\"kc\">False</span>, </span><span class=\"param\"><span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.update_entry": {"fullname": "sqlite_integrated.Database.update_entry", "modulename": "sqlite_integrated", "qualname": "Database.update_entry", "kind": "function", "doc": "<p>Update entry in database with a DatabaseEntry, or with a dictionary + the name of the table you want to update.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>entry : DatabaseEntry/dict\n    DatabaseEntry or dictionary, if dictionary you also need to provide table and id_field.\ntable : str, optional\n    The table name. <strong>Needed if updating an entry with a dictionary</strong>.\npart : bool, optional\n    If True: Only updates the provided fields.\nfill_null : bool, optional\n    Fill in unpopulated fields with null values.\nverbose : bool, optional\n    Enable prints.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">entry</span><span class=\"p\">:</span> <span class=\"nb\">dict</span>,</span><span class=\"param\">\t<span class=\"n\">table</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">part</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">fill_null</span><span class=\"o\">=</span><span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.delete_entry": {"fullname": "sqlite_integrated.Database.delete_entry", "modulename": "sqlite_integrated", "qualname": "Database.delete_entry", "kind": "function", "doc": "<p>Delete an entry from the database.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>entry : DatabaseEntry\n    The entry that is to be deleted.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">entry</span><span class=\"p\">:</span> <span class=\"n\">sqlite_integrated</span><span class=\"o\">.</span><span class=\"n\">DatabaseEntry</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.delete_entry_by_id": {"fullname": "sqlite_integrated.Database.delete_entry_by_id", "modulename": "sqlite_integrated", "qualname": "Database.delete_entry_by_id", "kind": "function", "doc": "<p>Deletes an entry with a certain id. (Note: the table must have a primary key column, as that is what is meant by id. It is assumed that there is only one primary key column in the table.}</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table : str\n    The table to delete the entry from.\nid : int</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"nb\">id</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.save": {"fullname": "sqlite_integrated.Database.save", "modulename": "sqlite_integrated", "qualname": "Database.save", "kind": "function", "doc": "<p>Writes any changes to the database file</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.close": {"fullname": "sqlite_integrated.Database.close", "modulename": "sqlite_integrated", "qualname": "Database.close", "kind": "function", "doc": "<p>Saves and closes the database. If you want to explicitly close without saving use: <code>self.conn.close()</code></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.reconnect": {"fullname": "sqlite_integrated.Database.reconnect", "modulename": "sqlite_integrated", "qualname": "Database.reconnect", "kind": "function", "doc": "<p>Reopen database after closing it</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.table_to_dataframe": {"fullname": "sqlite_integrated.Database.table_to_dataframe", "modulename": "sqlite_integrated", "qualname": "Database.table_to_dataframe", "kind": "function", "doc": "<p>Converts a table to a pandas.Dataframe.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table : str\n    Name of the table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table</span></span><span class=\"return-annotation\">) -> <span class=\"n\">pandas</span><span class=\"o\">.</span><span class=\"n\">core</span><span class=\"o\">.</span><span class=\"n\">frame</span><span class=\"o\">.</span><span class=\"n\">DataFrame</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.export_to_csv": {"fullname": "sqlite_integrated.Database.export_to_csv", "modulename": "sqlite_integrated", "qualname": "Database.export_to_csv", "kind": "function", "doc": "<p>Export all or some tables in the database to csv files</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>out_dir : str\n    Path to the output directory.\ntables : list[str]/None, optional\n    Can be set to only export certain tables.\nsep : str, optional\n    Seperator to use when writing csv-file.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">out_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">tables</span><span class=\"p\">:</span> <span class=\"nb\">list</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">sep</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;</span><span class=\"se\">\\t</span><span class=\"s1\">&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.run_raw_sql": {"fullname": "sqlite_integrated.Database.run_raw_sql", "modulename": "sqlite_integrated", "qualname": "Database.run_raw_sql", "kind": "function", "doc": "<p>Run SQL-string on the database. This returns a raw table as list of tuples.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>sql : str\n    SQL-string to be execured as an SQL command.\nverbose : bool, optional\n    Prints the SQL-query if true</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sql</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">verbose</span><span class=\"o\">=</span><span class=\"kc\">False</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.SELECT": {"fullname": "sqlite_integrated.Database.SELECT", "modulename": "sqlite_integrated", "qualname": "Database.SELECT", "kind": "function", "doc": "<p>Start sql SELECT query from the database. Returns a Query to build from.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>pattern : str, optional\n    Either a python list or sql list of table names.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">pattern</span><span class=\"o\">=</span><span class=\"s1\">&#39;*&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlite_integrated</span><span class=\"o\">.</span><span class=\"n\">Query</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.UPDATE": {"fullname": "sqlite_integrated.Database.UPDATE", "modulename": "sqlite_integrated", "qualname": "Database.UPDATE", "kind": "function", "doc": "<p>Start sql UPDATE query from the database. Returns a Query to build from.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table_name : str\n    Name of the table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table_name</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlite_integrated</span><span class=\"o\">.</span><span class=\"n\">Query</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.INSERT_INTO": {"fullname": "sqlite_integrated.Database.INSERT_INTO", "modulename": "sqlite_integrated", "qualname": "Database.INSERT_INTO", "kind": "function", "doc": "<p>Start sql INSERT INTO query from the database. Returns a Query to build from.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table_name : str\n    Name of the table to insert into.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table_name</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlite_integrated</span><span class=\"o\">.</span><span class=\"n\">Query</span>:</span></span>", "funcdef": "def"}, "sqlite_integrated.Database.DELETE_FROM": {"fullname": "sqlite_integrated.Database.DELETE_FROM", "modulename": "sqlite_integrated", "qualname": "Database.DELETE_FROM", "kind": "function", "doc": "<p>Start sql DELETE FROM query from the database. Returns a Query to build from.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>table_name : str\n    Name of the table to delete from.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">sqlite_integrated</span><span class=\"o\">.</span><span class=\"n\">Query</span>:</span></span>", "funcdef": "def"}}, "docInfo": {"sqlite_integrated": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "sqlite_integrated.ForeignKey": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 8}, "sqlite_integrated.ForeignKey.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 138, "bases": 0, "doc": 3}, "sqlite_integrated.ForeignKey.table": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 9}, "sqlite_integrated.ForeignKey.to_col": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 8}, "sqlite_integrated.ForeignKey.from_col": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 10}, "sqlite_integrated.ForeignKey.id": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 6}, "sqlite_integrated.ForeignKey.seq": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 7}, "sqlite_integrated.ForeignKey.on_update": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 21}, "sqlite_integrated.ForeignKey.on_delete": {"qualname": 3, "fullname": 5, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 21}, "sqlite_integrated.ForeignKey.to_sql": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 3}, "sqlite_integrated.Column": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 8}, "sqlite_integrated.Column.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 146, "bases": 0, "doc": 3}, "sqlite_integrated.Column.name": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "sqlite_integrated.Column.type": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "sqlite_integrated.Column.not_null": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "sqlite_integrated.Column.default_value": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "sqlite_integrated.Column.primary_key": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 16}, "sqlite_integrated.Column.col_id": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "sqlite_integrated.Column.foreign_key": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 11}, "sqlite_integrated.DatabaseEntry": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 70}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 80}, "sqlite_integrated.raw_table_to_table": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 56, "bases": 0, "doc": 74}, "sqlite_integrated.string_to_list": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 19}, "sqlite_integrated.value_to_sql_value": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 24}, "sqlite_integrated.dict_to_sql": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 16}, "sqlite_integrated.DatabaseError": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 10}, "sqlite_integrated.QueryError": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 2, "doc": 12}, "sqlite_integrated.Query": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 62}, "sqlite_integrated.Query.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 3}, "sqlite_integrated.Query.sql": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 7}, "sqlite_integrated.Query.history": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "sqlite_integrated.Query.fields": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 5}, "sqlite_integrated.Query.table": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "sqlite_integrated.Query.verbose": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 12}, "sqlite_integrated.Query.valid_prefixes": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 11}, "sqlite_integrated.Query.SELECT": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 42}, "sqlite_integrated.Query.FROM": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 42}, "sqlite_integrated.Query.WHERE": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 58}, "sqlite_integrated.Query.LIKE": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 31}, "sqlite_integrated.Query.UPDATE": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 31}, "sqlite_integrated.Query.SET": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 37}, "sqlite_integrated.Query.INSERT_INTO": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 36}, "sqlite_integrated.Query.VALUES": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 29}, "sqlite_integrated.Query.DELETE_FROM": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 31}, "sqlite_integrated.Query.run": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 60, "bases": 0, "doc": 74}, "sqlite_integrated.Database": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 54}, "sqlite_integrated.Database.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 44, "bases": 0, "doc": 3}, "sqlite_integrated.Database.path": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 8}, "sqlite_integrated.Database.conn": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 6}, "sqlite_integrated.Database.cursor": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 17}, "sqlite_integrated.Database.connected": {"qualname": 2, "fullname": 4, "annotation": 2, "default_value": 0, "signature": 0, "bases": 0, "doc": 16}, "sqlite_integrated.Database.verbose": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 10}, "sqlite_integrated.Database.in_memory": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 31}, "sqlite_integrated.Database.create_table": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 43, "bases": 0, "doc": 33}, "sqlite_integrated.Database.rename_table": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 33, "bases": 0, "doc": 33}, "sqlite_integrated.Database.delete_table": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 20, "bases": 0, "doc": 28}, "sqlite_integrated.Database.add_column": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 38, "bases": 0, "doc": 34}, "sqlite_integrated.Database.rename_column": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 50, "bases": 0, "doc": 43}, "sqlite_integrated.Database.delete_column": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 27, "bases": 0, "doc": 41}, "sqlite_integrated.Database.get_table_names": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 12}, "sqlite_integrated.Database.is_table": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 25, "bases": 0, "doc": 26}, "sqlite_integrated.Database.get_table_raw": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 46}, "sqlite_integrated.Database.get_table": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 66}, "sqlite_integrated.Database.get_table_cols": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 30}, "sqlite_integrated.Database.get_table_id_field": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 72}, "sqlite_integrated.Database.table_overview": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 53, "bases": 0, "doc": 49}, "sqlite_integrated.Database.overview": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 24, "bases": 0, "doc": 36}, "sqlite_integrated.Database.get_column_names": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 25}, "sqlite_integrated.Database.is_column": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 46}, "sqlite_integrated.Database.fill_null": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 38, "bases": 0, "doc": 37}, "sqlite_integrated.Database.get_entry_by_id": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 30, "bases": 0, "doc": 28}, "sqlite_integrated.Database.add_entry": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 50, "bases": 0, "doc": 131}, "sqlite_integrated.Database.update_entry": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 71, "bases": 0, "doc": 93}, "sqlite_integrated.Database.delete_entry": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 27, "bases": 0, "doc": 25}, "sqlite_integrated.Database.delete_entry_by_id": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 59}, "sqlite_integrated.Database.save": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 9}, "sqlite_integrated.Database.close": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 22}, "sqlite_integrated.Database.reconnect": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 7}, "sqlite_integrated.Database.table_to_dataframe": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 23}, "sqlite_integrated.Database.export_to_csv": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 67, "bases": 0, "doc": 51}, "sqlite_integrated.Database.run_raw_sql": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 45}, "sqlite_integrated.Database.SELECT": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 36}, "sqlite_integrated.Database.UPDATE": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 30}, "sqlite_integrated.Database.INSERT_INTO": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 34}, "sqlite_integrated.Database.DELETE_FROM": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 34}}, "length": 86, "save": true}, "index": {"qualname": {"root": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 1}, "sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.Query.__init__": {"tf": 1}, "sqlite_integrated.Database.__init__": {"tf": 1}}, "df": 4, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Column.foreign_key": {"tf": 1}}, "df": 1, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.ForeignKey": {"tf": 1}, "sqlite_integrated.ForeignKey.__init__": {"tf": 1}, "sqlite_integrated.ForeignKey.table": {"tf": 1}, "sqlite_integrated.ForeignKey.to_col": {"tf": 1}, "sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.ForeignKey.id": {"tf": 1}, "sqlite_integrated.ForeignKey.seq": {"tf": 1}, "sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.ForeignKey.to_sql": {"tf": 1}}, "df": 10}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 5}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.get_table_id_field": {"tf": 1}}, "df": 1, "s": {"docs": {"sqlite_integrated.Query.fields": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.Database.fill_null": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database.in_memory": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 1}, "sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.Query.__init__": {"tf": 1}, "sqlite_integrated.Database.__init__": {"tf": 1}}, "df": 4}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {"sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}}, "df": 2}}}, "d": {"docs": {"sqlite_integrated.ForeignKey.id": {"tf": 1}, "sqlite_integrated.Column.col_id": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 5}, "s": {"docs": {"sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.ForeignKey.table": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.table": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.rename_table": {"tf": 1}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}}, "df": 14}}}}, "o": {"docs": {"sqlite_integrated.ForeignKey.to_col": {"tf": 1}, "sqlite_integrated.ForeignKey.to_sql": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.string_to_list": {"tf": 1}, "sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 8}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Column.type": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.ForeignKey.to_col": {"tf": 1}, "sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.Column.col_id": {"tf": 1}}, "df": 3, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Column": {"tf": 1}, "sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.Column.name": {"tf": 1}, "sqlite_integrated.Column.type": {"tf": 1}, "sqlite_integrated.Column.not_null": {"tf": 1}, "sqlite_integrated.Column.default_value": {"tf": 1}, "sqlite_integrated.Column.primary_key": {"tf": 1}, "sqlite_integrated.Column.col_id": {"tf": 1}, "sqlite_integrated.Column.foreign_key": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}}, "df": 14}}}, "s": {"docs": {"sqlite_integrated.Database.get_table_cols": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database.conn": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.connected": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.Database.cursor": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.create_table": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.close": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "v": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "q": {"docs": {"sqlite_integrated.ForeignKey.seq": {"tf": 1}}, "df": 1}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {"sqlite_integrated.Query.SET": {"tf": 1}}, "df": 1}}, "q": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.ForeignKey.to_sql": {"tf": 1}, "sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.Query.sql": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 5}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.string_to_list": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.save": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}}, "df": 2}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {"sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}}, "df": 2}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}}, "df": 4}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 7}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Column.default_value": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.__init__": {"tf": 1}, "sqlite_integrated.Database.path": {"tf": 1}, "sqlite_integrated.Database.conn": {"tf": 1}, "sqlite_integrated.Database.cursor": {"tf": 1}, "sqlite_integrated.Database.connected": {"tf": 1}, "sqlite_integrated.Database.verbose": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.rename_table": {"tf": 1}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.save": {"tf": 1}, "sqlite_integrated.Database.close": {"tf": 1}, "sqlite_integrated.Database.reconnect": {"tf": 1}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 40, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.DatabaseError": {"tf": 1}}, "df": 1}}}}}}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.table_to_dataframe": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.dict_to_sql": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Column.name": {"tf": 1}}, "df": 1, "s": {"docs": {"sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Column.not_null": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.Column.not_null": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1}}, "df": 2}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Column.default_value": {"tf": 1}, "sqlite_integrated.value_to_sql_value": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"sqlite_integrated.Query.VALUES": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Query.valid_prefixes": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Query.verbose": {"tf": 1}, "sqlite_integrated.Database.verbose": {"tf": 1}}, "df": 2}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Column.primary_key": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Query.valid_prefixes": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"sqlite_integrated.Database.path": {"tf": 1}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Column.primary_key": {"tf": 1}, "sqlite_integrated.Column.foreign_key": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "w": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 4}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.rename_table": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.reconnect": {"tf": 1}}, "df": 1}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 6}}}}, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.string_to_list": {"tf": 1}}, "df": 1}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Query.LIKE": {"tf": 1}}, "df": 1}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.__init__": {"tf": 1}, "sqlite_integrated.Query.sql": {"tf": 1}, "sqlite_integrated.Query.history": {"tf": 1}, "sqlite_integrated.Query.fields": {"tf": 1}, "sqlite_integrated.Query.table": {"tf": 1}, "sqlite_integrated.Query.verbose": {"tf": 1}, "sqlite_integrated.Query.valid_prefixes": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}}, "df": 18, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.QueryError": {"tf": 1}}, "df": 1}}}}}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Query.history": {"tf": 1}}, "df": 1}}}}}}}, "w": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Query.WHERE": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Database.in_memory": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}}, "df": 2}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}}, "df": 7}}}, "b": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 2}}}}, "fullname": {"root": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 1}, "sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.Query.__init__": {"tf": 1}, "sqlite_integrated.Database.__init__": {"tf": 1}}, "df": 4, "s": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.ForeignKey.to_sql": {"tf": 1}, "sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.Query.sql": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 5, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated": {"tf": 1}, "sqlite_integrated.ForeignKey": {"tf": 1}, "sqlite_integrated.ForeignKey.__init__": {"tf": 1}, "sqlite_integrated.ForeignKey.table": {"tf": 1}, "sqlite_integrated.ForeignKey.to_col": {"tf": 1}, "sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.ForeignKey.id": {"tf": 1}, "sqlite_integrated.ForeignKey.seq": {"tf": 1}, "sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.ForeignKey.to_sql": {"tf": 1}, "sqlite_integrated.Column": {"tf": 1}, "sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.Column.name": {"tf": 1}, "sqlite_integrated.Column.type": {"tf": 1}, "sqlite_integrated.Column.not_null": {"tf": 1}, "sqlite_integrated.Column.default_value": {"tf": 1}, "sqlite_integrated.Column.primary_key": {"tf": 1}, "sqlite_integrated.Column.col_id": {"tf": 1}, "sqlite_integrated.Column.foreign_key": {"tf": 1}, "sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.string_to_list": {"tf": 1}, "sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.DatabaseError": {"tf": 1}, "sqlite_integrated.QueryError": {"tf": 1}, "sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.__init__": {"tf": 1}, "sqlite_integrated.Query.sql": {"tf": 1}, "sqlite_integrated.Query.history": {"tf": 1}, "sqlite_integrated.Query.fields": {"tf": 1}, "sqlite_integrated.Query.table": {"tf": 1}, "sqlite_integrated.Query.verbose": {"tf": 1}, "sqlite_integrated.Query.valid_prefixes": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.__init__": {"tf": 1}, "sqlite_integrated.Database.path": {"tf": 1}, "sqlite_integrated.Database.conn": {"tf": 1}, "sqlite_integrated.Database.cursor": {"tf": 1}, "sqlite_integrated.Database.connected": {"tf": 1}, "sqlite_integrated.Database.verbose": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.rename_table": {"tf": 1}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.save": {"tf": 1}, "sqlite_integrated.Database.close": {"tf": 1}, "sqlite_integrated.Database.reconnect": {"tf": 1}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 86}}}}}, "e": {"docs": {}, "df": 0, "q": {"docs": {"sqlite_integrated.ForeignKey.seq": {"tf": 1}}, "df": 1}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {"sqlite_integrated.Query.SET": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.string_to_list": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.save": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database.in_memory": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated": {"tf": 1}, "sqlite_integrated.ForeignKey": {"tf": 1}, "sqlite_integrated.ForeignKey.__init__": {"tf": 1}, "sqlite_integrated.ForeignKey.table": {"tf": 1}, "sqlite_integrated.ForeignKey.to_col": {"tf": 1}, "sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.ForeignKey.id": {"tf": 1}, "sqlite_integrated.ForeignKey.seq": {"tf": 1}, "sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.ForeignKey.to_sql": {"tf": 1}, "sqlite_integrated.Column": {"tf": 1}, "sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.Column.name": {"tf": 1}, "sqlite_integrated.Column.type": {"tf": 1}, "sqlite_integrated.Column.not_null": {"tf": 1}, "sqlite_integrated.Column.default_value": {"tf": 1}, "sqlite_integrated.Column.primary_key": {"tf": 1}, "sqlite_integrated.Column.col_id": {"tf": 1}, "sqlite_integrated.Column.foreign_key": {"tf": 1}, "sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.string_to_list": {"tf": 1}, "sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.DatabaseError": {"tf": 1}, "sqlite_integrated.QueryError": {"tf": 1}, "sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.__init__": {"tf": 1}, "sqlite_integrated.Query.sql": {"tf": 1}, "sqlite_integrated.Query.history": {"tf": 1}, "sqlite_integrated.Query.fields": {"tf": 1}, "sqlite_integrated.Query.table": {"tf": 1}, "sqlite_integrated.Query.verbose": {"tf": 1}, "sqlite_integrated.Query.valid_prefixes": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.__init__": {"tf": 1}, "sqlite_integrated.Database.path": {"tf": 1}, "sqlite_integrated.Database.conn": {"tf": 1}, "sqlite_integrated.Database.cursor": {"tf": 1}, "sqlite_integrated.Database.connected": {"tf": 1}, "sqlite_integrated.Database.verbose": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.rename_table": {"tf": 1}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.save": {"tf": 1}, "sqlite_integrated.Database.close": {"tf": 1}, "sqlite_integrated.Database.reconnect": {"tf": 1}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 86}}}}}}}, "o": {"docs": {"sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 1}, "sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.Query.__init__": {"tf": 1}, "sqlite_integrated.Database.__init__": {"tf": 1}}, "df": 4}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}}, "df": 2}}}}}, "d": {"docs": {"sqlite_integrated.ForeignKey.id": {"tf": 1}, "sqlite_integrated.Column.col_id": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 5}, "s": {"docs": {"sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}}, "df": 2}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Column.foreign_key": {"tf": 1}}, "df": 1, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.ForeignKey": {"tf": 1}, "sqlite_integrated.ForeignKey.__init__": {"tf": 1}, "sqlite_integrated.ForeignKey.table": {"tf": 1}, "sqlite_integrated.ForeignKey.to_col": {"tf": 1}, "sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.ForeignKey.id": {"tf": 1}, "sqlite_integrated.ForeignKey.seq": {"tf": 1}, "sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.ForeignKey.to_sql": {"tf": 1}}, "df": 10}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 5}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.get_table_id_field": {"tf": 1}}, "df": 1, "s": {"docs": {"sqlite_integrated.Query.fields": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.Database.fill_null": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.ForeignKey.table": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.table": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.rename_table": {"tf": 1}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}}, "df": 14}}}}, "o": {"docs": {"sqlite_integrated.ForeignKey.to_col": {"tf": 1}, "sqlite_integrated.ForeignKey.to_sql": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.string_to_list": {"tf": 1}, "sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 8}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Column.type": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.ForeignKey.to_col": {"tf": 1}, "sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.Column.col_id": {"tf": 1}}, "df": 3, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Column": {"tf": 1}, "sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.Column.name": {"tf": 1}, "sqlite_integrated.Column.type": {"tf": 1}, "sqlite_integrated.Column.not_null": {"tf": 1}, "sqlite_integrated.Column.default_value": {"tf": 1}, "sqlite_integrated.Column.primary_key": {"tf": 1}, "sqlite_integrated.Column.col_id": {"tf": 1}, "sqlite_integrated.Column.foreign_key": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}}, "df": 14}}}, "s": {"docs": {"sqlite_integrated.Database.get_table_cols": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database.conn": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.connected": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.Database.cursor": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.create_table": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.close": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "v": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}}, "df": 2}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {"sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}}, "df": 2}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}}, "df": 4}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 7}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Column.default_value": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.__init__": {"tf": 1}, "sqlite_integrated.Database.path": {"tf": 1}, "sqlite_integrated.Database.conn": {"tf": 1}, "sqlite_integrated.Database.cursor": {"tf": 1}, "sqlite_integrated.Database.connected": {"tf": 1}, "sqlite_integrated.Database.verbose": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.rename_table": {"tf": 1}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.save": {"tf": 1}, "sqlite_integrated.Database.close": {"tf": 1}, "sqlite_integrated.Database.reconnect": {"tf": 1}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 40, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.DatabaseError": {"tf": 1}}, "df": 1}}}}}}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.table_to_dataframe": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.dict_to_sql": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Column.name": {"tf": 1}}, "df": 1, "s": {"docs": {"sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Column.not_null": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.Column.not_null": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1}}, "df": 2}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Column.default_value": {"tf": 1}, "sqlite_integrated.value_to_sql_value": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"sqlite_integrated.Query.VALUES": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Query.valid_prefixes": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Query.verbose": {"tf": 1}, "sqlite_integrated.Database.verbose": {"tf": 1}}, "df": 2}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Column.primary_key": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Query.valid_prefixes": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"sqlite_integrated.Database.path": {"tf": 1}}, "df": 1}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Column.primary_key": {"tf": 1}, "sqlite_integrated.Column.foreign_key": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "w": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 4}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.rename_table": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.reconnect": {"tf": 1}}, "df": 1}}}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 6}}}}, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.string_to_list": {"tf": 1}}, "df": 1}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Query.LIKE": {"tf": 1}}, "df": 1}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.__init__": {"tf": 1}, "sqlite_integrated.Query.sql": {"tf": 1}, "sqlite_integrated.Query.history": {"tf": 1}, "sqlite_integrated.Query.fields": {"tf": 1}, "sqlite_integrated.Query.table": {"tf": 1}, "sqlite_integrated.Query.verbose": {"tf": 1}, "sqlite_integrated.Query.valid_prefixes": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}}, "df": 18, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.QueryError": {"tf": 1}}, "df": 1}}}}}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Query.history": {"tf": 1}}, "df": 1}}}}}}}, "w": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Query.WHERE": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Database.in_memory": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}}, "df": 2}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}}, "df": 7}}}, "b": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 2}}}}, "annotation": {"root": {"docs": {"sqlite_integrated.ForeignKey.table": {"tf": 1}, "sqlite_integrated.ForeignKey.to_col": {"tf": 1}, "sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.ForeignKey.id": {"tf": 1}, "sqlite_integrated.ForeignKey.seq": {"tf": 1}, "sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.Database.connected": {"tf": 1}}, "df": 8, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.ForeignKey.table": {"tf": 1}, "sqlite_integrated.ForeignKey.to_col": {"tf": 1}, "sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}}, "df": 5}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.ForeignKey.id": {"tf": 1}, "sqlite_integrated.ForeignKey.seq": {"tf": 1}}, "df": 2}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.Database.connected": {"tf": 1}}, "df": 1}}}}}}, "default_value": {"root": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.ForeignKey.id": {"tf": 1}, "sqlite_integrated.ForeignKey.seq": {"tf": 1}, "sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}}, "df": 5}}}}}}, "signature": {"root": {"3": {"9": {"docs": {"sqlite_integrated.Query.SELECT": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.WHERE": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.export_to_csv": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.SELECT": {"tf": 1.4142135623730951}}, "df": 4}, "docs": {}, "df": 0}, "4": {"0": {"docs": {"sqlite_integrated.Database.table_overview": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 10.583005244258363}, "sqlite_integrated.ForeignKey.to_sql": {"tf": 3.1622776601683795}, "sqlite_integrated.Column.__init__": {"tf": 10.723805294763608}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 5.830951894845301}, "sqlite_integrated.raw_table_to_table": {"tf": 6.6332495807108}, "sqlite_integrated.string_to_list": {"tf": 4}, "sqlite_integrated.value_to_sql_value": {"tf": 3.4641016151377544}, "sqlite_integrated.dict_to_sql": {"tf": 4}, "sqlite_integrated.Query.__init__": {"tf": 4.47213595499958}, "sqlite_integrated.Query.valid_prefixes": {"tf": 4.47213595499958}, "sqlite_integrated.Query.SELECT": {"tf": 4.58257569495584}, "sqlite_integrated.Query.FROM": {"tf": 3.7416573867739413}, "sqlite_integrated.Query.WHERE": {"tf": 5.291502622129181}, "sqlite_integrated.Query.LIKE": {"tf": 4.242640687119285}, "sqlite_integrated.Query.UPDATE": {"tf": 4.242640687119285}, "sqlite_integrated.Query.SET": {"tf": 4.242640687119285}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 4.242640687119285}, "sqlite_integrated.Query.VALUES": {"tf": 4.242640687119285}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 4.242640687119285}, "sqlite_integrated.Query.run": {"tf": 7}, "sqlite_integrated.Database.__init__": {"tf": 6}, "sqlite_integrated.Database.in_memory": {"tf": 4.242640687119285}, "sqlite_integrated.Database.create_table": {"tf": 5.916079783099616}, "sqlite_integrated.Database.rename_table": {"tf": 5.0990195135927845}, "sqlite_integrated.Database.delete_table": {"tf": 4}, "sqlite_integrated.Database.add_column": {"tf": 5.477225575051661}, "sqlite_integrated.Database.rename_column": {"tf": 6.164414002968976}, "sqlite_integrated.Database.delete_column": {"tf": 4.69041575982343}, "sqlite_integrated.Database.get_table_names": {"tf": 3.4641016151377544}, "sqlite_integrated.Database.is_table": {"tf": 4.47213595499958}, "sqlite_integrated.Database.get_table_raw": {"tf": 5.291502622129181}, "sqlite_integrated.Database.get_table": {"tf": 5.291502622129181}, "sqlite_integrated.Database.get_table_cols": {"tf": 5.385164807134504}, "sqlite_integrated.Database.get_table_id_field": {"tf": 5.291502622129181}, "sqlite_integrated.Database.table_overview": {"tf": 6.48074069840786}, "sqlite_integrated.Database.overview": {"tf": 4.47213595499958}, "sqlite_integrated.Database.get_column_names": {"tf": 5}, "sqlite_integrated.Database.is_column": {"tf": 5.291502622129181}, "sqlite_integrated.Database.fill_null": {"tf": 5.477225575051661}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 4.898979485566356}, "sqlite_integrated.Database.add_entry": {"tf": 6.324555320336759}, "sqlite_integrated.Database.update_entry": {"tf": 7.615773105863909}, "sqlite_integrated.Database.delete_entry": {"tf": 4.69041575982343}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 5.0990195135927845}, "sqlite_integrated.Database.save": {"tf": 3.4641016151377544}, "sqlite_integrated.Database.close": {"tf": 3.4641016151377544}, "sqlite_integrated.Database.reconnect": {"tf": 3.4641016151377544}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 5.291502622129181}, "sqlite_integrated.Database.export_to_csv": {"tf": 7.3484692283495345}, "sqlite_integrated.Database.run_raw_sql": {"tf": 5.0990195135927845}, "sqlite_integrated.Database.SELECT": {"tf": 5.196152422706632}, "sqlite_integrated.Database.UPDATE": {"tf": 4.47213595499958}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 4.47213595499958}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 4.898979485566356}}, "df": 54, "t": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.raw_table_to_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 23, "s": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 1}}, "df": 1}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 2.449489742783178}, "sqlite_integrated.Column.__init__": {"tf": 1.4142135623730951}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.string_to_list": {"tf": 1}, "sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Database.__init__": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.rename_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.is_column": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 30, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.string_to_list": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "q": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 1}}, "df": 1}, "l": {"docs": {}, "df": 0, "f": {"docs": {"sqlite_integrated.ForeignKey.to_sql": {"tf": 1}, "sqlite_integrated.Query.valid_prefixes": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.rename_table": {"tf": 1}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.save": {"tf": 1}, "sqlite_integrated.Database.close": {"tf": 1}, "sqlite_integrated.Database.reconnect": {"tf": 1}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 44}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Query.SELECT": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1}}, "q": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 13}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.__init__": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 1.4142135623730951}, "sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}}, "df": 6, "s": {"docs": {"sqlite_integrated.Database.create_table": {"tf": 1}}, "df": 1}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}}, "df": 4}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.table_to_dataframe": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1}}, "df": 2}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.rename_table": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1}}, "df": 2}}}}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.table_to_dataframe": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.Query.__init__": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.__init__": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.in_memory": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.update_entry": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 10}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}}, "df": 1, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 2}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 2.449489742783178}, "sqlite_integrated.Column.__init__": {"tf": 2}, "sqlite_integrated.Query.__init__": {"tf": 1}, "sqlite_integrated.Query.valid_prefixes": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.__init__": {"tf": 1}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.update_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.save": {"tf": 1}, "sqlite_integrated.Database.close": {"tf": 1}, "sqlite_integrated.Database.reconnect": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1.4142135623730951}}, "df": 17}}, "t": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.rename_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 24}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {"sqlite_integrated.Database.__init__": {"tf": 1}, "sqlite_integrated.Database.rename_table": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 1}, "sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 4}, "n": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}}, "df": 1, "t": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 1.4142135623730951}, "sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 13}}}}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 1.4142135623730951}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}}, "df": 3}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}}, "df": 3, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}}, "df": 5}}}}}}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.table_to_dataframe": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 4}}, "r": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1}}, "b": {"docs": {"sqlite_integrated.Query.__init__": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}}, "df": 2}, "o": {"docs": {"sqlite_integrated.Database.get_table_id_field": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"sqlite_integrated.ForeignKey.__init__": {"tf": 1}}, "df": 1}}}, "x": {"docs": {"sqlite_integrated.Database.table_overview": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.overview": {"tf": 1}}, "df": 1}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}}, "df": 3}}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}, "sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}}, "df": 3}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Query.__init__": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.__init__": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 7}}}}}}}, "l": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1.7320508075688772}, "sqlite_integrated.string_to_list": {"tf": 1}, "sqlite_integrated.Query.valid_prefixes": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 12}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database.table_overview": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}}, "df": 3}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Query.valid_prefixes": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}}, "df": 2}}}}, "h": {"docs": {"sqlite_integrated.Database.__init__": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Database.table_to_dataframe": {"tf": 1}}, "df": 1}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Column.__init__": {"tf": 1.4142135623730951}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "w": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}}, "df": 5}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.Database.get_table_id_field": {"tf": 1}}, "df": 1}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 4}}}}}}}, "bases": {"root": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.DatabaseError": {"tf": 1}, "sqlite_integrated.QueryError": {"tf": 1}}, "df": 3}}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.DatabaseError": {"tf": 1}, "sqlite_integrated.QueryError": {"tf": 1}}, "df": 2}}}}}}}}}}}, "doc": {"root": {"2": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}}, "df": 1}, "3": {"3": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "4": {"docs": {"sqlite_integrated.Query.WHERE": {"tf": 1}}, "df": 1}, "docs": {"sqlite_integrated": {"tf": 1.7320508075688772}, "sqlite_integrated.ForeignKey": {"tf": 1.4142135623730951}, "sqlite_integrated.ForeignKey.__init__": {"tf": 1.7320508075688772}, "sqlite_integrated.ForeignKey.table": {"tf": 1.4142135623730951}, "sqlite_integrated.ForeignKey.to_col": {"tf": 1.4142135623730951}, "sqlite_integrated.ForeignKey.from_col": {"tf": 1.4142135623730951}, "sqlite_integrated.ForeignKey.id": {"tf": 1.4142135623730951}, "sqlite_integrated.ForeignKey.seq": {"tf": 1.4142135623730951}, "sqlite_integrated.ForeignKey.on_update": {"tf": 1.7320508075688772}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1.7320508075688772}, "sqlite_integrated.ForeignKey.to_sql": {"tf": 1.7320508075688772}, "sqlite_integrated.Column": {"tf": 1.7320508075688772}, "sqlite_integrated.Column.__init__": {"tf": 1.7320508075688772}, "sqlite_integrated.Column.name": {"tf": 1.7320508075688772}, "sqlite_integrated.Column.type": {"tf": 1.7320508075688772}, "sqlite_integrated.Column.not_null": {"tf": 1.7320508075688772}, "sqlite_integrated.Column.default_value": {"tf": 1.7320508075688772}, "sqlite_integrated.Column.primary_key": {"tf": 1.7320508075688772}, "sqlite_integrated.Column.col_id": {"tf": 1.7320508075688772}, "sqlite_integrated.Column.foreign_key": {"tf": 1.7320508075688772}, "sqlite_integrated.DatabaseEntry": {"tf": 3.3166247903554}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 4.358898943540674}, "sqlite_integrated.raw_table_to_table": {"tf": 3.7416573867739413}, "sqlite_integrated.string_to_list": {"tf": 1.7320508075688772}, "sqlite_integrated.value_to_sql_value": {"tf": 1.4142135623730951}, "sqlite_integrated.dict_to_sql": {"tf": 1.7320508075688772}, "sqlite_integrated.DatabaseError": {"tf": 1.4142135623730951}, "sqlite_integrated.QueryError": {"tf": 1.4142135623730951}, "sqlite_integrated.Query": {"tf": 3.605551275463989}, "sqlite_integrated.Query.__init__": {"tf": 1.7320508075688772}, "sqlite_integrated.Query.sql": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.history": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.fields": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.table": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.verbose": {"tf": 2}, "sqlite_integrated.Query.valid_prefixes": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.SELECT": {"tf": 3.605551275463989}, "sqlite_integrated.Query.FROM": {"tf": 3.605551275463989}, "sqlite_integrated.Query.WHERE": {"tf": 4.123105625617661}, "sqlite_integrated.Query.LIKE": {"tf": 3.1622776601683795}, "sqlite_integrated.Query.UPDATE": {"tf": 3.3166247903554}, "sqlite_integrated.Query.SET": {"tf": 3.3166247903554}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 3.605551275463989}, "sqlite_integrated.Query.VALUES": {"tf": 3.3166247903554}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 3.605551275463989}, "sqlite_integrated.Query.run": {"tf": 3.605551275463989}, "sqlite_integrated.Database": {"tf": 3.605551275463989}, "sqlite_integrated.Database.__init__": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.path": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.conn": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.cursor": {"tf": 2.449489742783178}, "sqlite_integrated.Database.connected": {"tf": 2.23606797749979}, "sqlite_integrated.Database.verbose": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.in_memory": {"tf": 3.3166247903554}, "sqlite_integrated.Database.create_table": {"tf": 3.1622776601683795}, "sqlite_integrated.Database.rename_table": {"tf": 3.1622776601683795}, "sqlite_integrated.Database.delete_table": {"tf": 3}, "sqlite_integrated.Database.add_column": {"tf": 3.1622776601683795}, "sqlite_integrated.Database.rename_column": {"tf": 3.3166247903554}, "sqlite_integrated.Database.delete_column": {"tf": 3.1622776601683795}, "sqlite_integrated.Database.get_table_names": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.is_table": {"tf": 3}, "sqlite_integrated.Database.get_table_raw": {"tf": 3.1622776601683795}, "sqlite_integrated.Database.get_table": {"tf": 3.1622776601683795}, "sqlite_integrated.Database.get_table_cols": {"tf": 3.1622776601683795}, "sqlite_integrated.Database.get_table_id_field": {"tf": 4}, "sqlite_integrated.Database.table_overview": {"tf": 3.3166247903554}, "sqlite_integrated.Database.overview": {"tf": 3}, "sqlite_integrated.Database.get_column_names": {"tf": 3}, "sqlite_integrated.Database.is_column": {"tf": 3.1622776601683795}, "sqlite_integrated.Database.fill_null": {"tf": 3}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 3.4641016151377544}, "sqlite_integrated.Database.add_entry": {"tf": 5.196152422706632}, "sqlite_integrated.Database.update_entry": {"tf": 4}, "sqlite_integrated.Database.delete_entry": {"tf": 3}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 3}, "sqlite_integrated.Database.save": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.close": {"tf": 2.23606797749979}, "sqlite_integrated.Database.reconnect": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 3}, "sqlite_integrated.Database.export_to_csv": {"tf": 3.1622776601683795}, "sqlite_integrated.Database.run_raw_sql": {"tf": 3}, "sqlite_integrated.Database.SELECT": {"tf": 3}, "sqlite_integrated.Database.UPDATE": {"tf": 3}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 3}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 3}}, "df": 86, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.ForeignKey": {"tf": 1}, "sqlite_integrated.Column": {"tf": 1}, "sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Database": {"tf": 1}}, "df": 5}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.close": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"sqlite_integrated.Database.close": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.Database.reconnect": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}}, "df": 4, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.ForeignKey.to_col": {"tf": 1}, "sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.Column": {"tf": 1}, "sqlite_integrated.Column.name": {"tf": 1}, "sqlite_integrated.Column.type": {"tf": 1}, "sqlite_integrated.Column.default_value": {"tf": 1}, "sqlite_integrated.Column.primary_key": {"tf": 1}, "sqlite_integrated.Column.col_id": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.add_column": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.rename_column": {"tf": 2.23606797749979}, "sqlite_integrated.Database.delete_column": {"tf": 2.23606797749979}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1.4142135623730951}}, "df": 19, "s": {"docs": {"sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}}, "df": 4, "/": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}}, "df": 2}}}}}}}}, "/": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}}, "df": 3}}}}}}}}}, "s": {"docs": {"sqlite_integrated.Database.create_table": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.DatabaseEntry": {"tf": 1}}, "df": 2}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Column.not_null": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": null}}, "df": 1}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.raw_table_to_table": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"sqlite_integrated.value_to_sql_value": {"tf": 1.4142135623730951}, "sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}}, "df": 3}}}}}, "n": {"docs": {"sqlite_integrated.Database.close": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database.conn": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.connected": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"sqlite_integrated.string_to_list": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.DatabaseError": {"tf": 1}, "sqlite_integrated.Query.sql": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 3, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Query.history": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.Query.sql": {"tf": 1}, "sqlite_integrated.Database.rename_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.rename_column": {"tf": 1.4142135623730951}}, "df": 4}}}}, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.Database.cursor": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.Database.save": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"sqlite_integrated.Query.valid_prefixes": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1.4142135623730951}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.QueryError": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1}}, "df": 2, "d": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.Database": {"tf": 1}}, "df": 2}, "s": {"docs": {"sqlite_integrated.Database.create_table": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 8}}, "m": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.cursor": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 3}}}}}}, "s": {"docs": {}, "df": 0, "v": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1.4142135623730951}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.ForeignKey": {"tf": 1}, "sqlite_integrated.Column": {"tf": 1}, "sqlite_integrated.Column.foreign_key": {"tf": 1}}, "df": 3}}}}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.string_to_list": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.in_memory": {"tf": 1}, "sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 17}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}}, "df": 2}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Query.run": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Database.rename_table": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1}}, "df": 2}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.Database.add_entry": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database.reconnect": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "w": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.raw_table_to_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.sql": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.cursor": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 6}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.DatabaseError": {"tf": 1}, "sqlite_integrated.QueryError": {"tf": 1}}, "df": 2}, "s": {"docs": {"sqlite_integrated.Database.get_table_id_field": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Query": {"tf": 1.7320508075688772}, "sqlite_integrated.Query.history": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 3}}, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Database.table_overview": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {"sqlite_integrated.Column.primary_key": {"tf": 1}, "sqlite_integrated.DatabaseEntry": {"tf": 1.7320508075688772}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 2}, "sqlite_integrated.raw_table_to_table": {"tf": 2}, "sqlite_integrated.string_to_list": {"tf": 1.4142135623730951}, "sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.Query": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.valid_prefixes": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.LIKE": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1.4142135623730951}, "sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.connected": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.rename_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.delete_column": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.is_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table_raw": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.get_table": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 2}, "sqlite_integrated.Database.table_overview": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 2.23606797749979}, "sqlite_integrated.Database.update_entry": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 41, "n": {"docs": {"sqlite_integrated.ForeignKey": {"tf": 1}, "sqlite_integrated.Column.foreign_key": {"tf": 1}, "sqlite_integrated.QueryError": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 10, "y": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.save": {"tf": 1}}, "df": 4}, "d": {"docs": {"sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.close": {"tf": 1}}, "df": 9}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.ForeignKey.seq": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Query": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.run": {"tf": 1}}, "df": 2}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.ForeignKey.on_update": {"tf": 1.4142135623730951}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1.4142135623730951}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"sqlite_integrated.Column.primary_key": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 8}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "o": {"docs": {"sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 3}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.string_to_list": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}}, "df": 3}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.value_to_sql_value": {"tf": 1}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.add_column": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.add_entry": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.add_entry": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.Database.add_entry": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1.4142135623730951}}, "df": 5, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Database.get_table_id_field": {"tf": 1}}, "df": 1}, "d": {"docs": {"sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.Database.reconnect": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.ForeignKey": {"tf": 1}, "sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.Column": {"tf": 1}, "sqlite_integrated.Column.not_null": {"tf": 1}, "sqlite_integrated.Column.default_value": {"tf": 1}, "sqlite_integrated.Column.primary_key": {"tf": 1}, "sqlite_integrated.Column.foreign_key": {"tf": 1}, "sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.sql": {"tf": 1}, "sqlite_integrated.Query.table": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Database.cursor": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 2.23606797749979}, "sqlite_integrated.Database.SELECT": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 28, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"3": {"docs": {"sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.conn": {"tf": 1}, "sqlite_integrated.Database.cursor": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}}}}}, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.ForeignKey.seq": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}}, "df": 2, "d": {"docs": {"sqlite_integrated.string_to_list": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Query.fields": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Query.SELECT": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.Query.FROM": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"sqlite_integrated.Query.SELECT": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {"sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.close": {"tf": 1}}, "df": 2}}, "t": {"docs": {"sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 6}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.rename_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 34, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.string_to_list": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"sqlite_integrated.value_to_sql_value": {"tf": 1}}, "df": 1}}}}, "/": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Query.SELECT": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database.delete_column": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Query.valid_prefixes": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.FROM": {"tf": 1.7320508075688772}, "sqlite_integrated.Query.WHERE": {"tf": 1.7320508075688772}, "sqlite_integrated.Query.LIKE": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.UPDATE": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.SET": {"tf": 1.7320508075688772}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.VALUES": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1.4142135623730951}}, "df": 10}}}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 4}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.string_to_list": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.Database.add_entry": {"tf": 1}}, "df": 1}}}}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.delete_column": {"tf": 1}}, "df": 1}}}, "w": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database.table_overview": {"tf": 1}}, "df": 1}, "s": {"docs": {"sqlite_integrated.Database.table_overview": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {"sqlite_integrated.Database.get_table": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Database.close": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.Database.close": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.Column.default_value": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1.7320508075688772}, "sqlite_integrated.raw_table_to_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}}, "df": 7, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.ForeignKey": {"tf": 1}, "sqlite_integrated.ForeignKey.table": {"tf": 1}, "sqlite_integrated.ForeignKey.to_col": {"tf": 1}, "sqlite_integrated.ForeignKey.id": {"tf": 1}, "sqlite_integrated.ForeignKey.seq": {"tf": 1}, "sqlite_integrated.Column.foreign_key": {"tf": 1}}, "df": 6, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Column.foreign_key": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {"sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.verbose": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1}}, "df": 3}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}}, "df": 7}}}}}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.get_table_id_field": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 2, "s": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Query.fields": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.add_entry": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.update_entry": {"tf": 1.4142135623730951}}, "df": 7}, "/": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}}, "df": 2}}}}}}}}}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}}, "df": 2}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.path": {"tf": 1}, "sqlite_integrated.Database.save": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 4, "s": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1}}, "l": {"docs": {"sqlite_integrated.Database.add_entry": {"tf": 2}, "sqlite_integrated.Database.update_entry": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"sqlite_integrated.Database.fill_null": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.value_to_sql_value": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.DatabaseError": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.is_column": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.UPDATE": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 2}}, "df": 10}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.verbose": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1}}, "df": 3}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}}, "df": 2}}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"1": {"docs": {"sqlite_integrated.dict_to_sql": {"tf": 1}}, "df": 1}, "2": {"docs": {"sqlite_integrated.dict_to_sql": {"tf": 1}}, "df": 1}, "docs": {"sqlite_integrated.ForeignKey": {"tf": 1}, "sqlite_integrated.ForeignKey.table": {"tf": 1}, "sqlite_integrated.ForeignKey.to_col": {"tf": 1}, "sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.ForeignKey.id": {"tf": 1}, "sqlite_integrated.ForeignKey.seq": {"tf": 1}, "sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.Column.primary_key": {"tf": 1}, "sqlite_integrated.Column.foreign_key": {"tf": 1}, "sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1.4142135623730951}}, "df": 18}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.ForeignKey.table": {"tf": 1.4142135623730951}, "sqlite_integrated.ForeignKey.to_col": {"tf": 1}, "sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.ForeignKey.id": {"tf": 1}, "sqlite_integrated.ForeignKey.seq": {"tf": 1}, "sqlite_integrated.ForeignKey.on_update": {"tf": 2}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 2}, "sqlite_integrated.Column.name": {"tf": 1}, "sqlite_integrated.Column.type": {"tf": 1.4142135623730951}, "sqlite_integrated.Column.default_value": {"tf": 1}, "sqlite_integrated.Column.col_id": {"tf": 1.4142135623730951}, "sqlite_integrated.DatabaseEntry": {"tf": 2.23606797749979}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 2.6457513110645907}, "sqlite_integrated.raw_table_to_table": {"tf": 2.6457513110645907}, "sqlite_integrated.string_to_list": {"tf": 1}, "sqlite_integrated.DatabaseError": {"tf": 1}, "sqlite_integrated.Query": {"tf": 2.23606797749979}, "sqlite_integrated.Query.sql": {"tf": 1}, "sqlite_integrated.Query.history": {"tf": 1}, "sqlite_integrated.Query.fields": {"tf": 1}, "sqlite_integrated.Query.table": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.verbose": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 2}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 2.449489742783178}, "sqlite_integrated.Database": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.path": {"tf": 1}, "sqlite_integrated.Database.conn": {"tf": 1}, "sqlite_integrated.Database.cursor": {"tf": 1}, "sqlite_integrated.Database.connected": {"tf": 1}, "sqlite_integrated.Database.verbose": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.create_table": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.rename_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.delete_table": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.add_column": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.rename_column": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.delete_column": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.get_table_names": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.get_table_cols": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table_id_field": {"tf": 2}, "sqlite_integrated.Database.table_overview": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.overview": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.get_column_names": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.is_column": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.fill_null": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.add_entry": {"tf": 3}, "sqlite_integrated.Database.update_entry": {"tf": 2}, "sqlite_integrated.Database.delete_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 2}, "sqlite_integrated.Database.save": {"tf": 1}, "sqlite_integrated.Database.close": {"tf": 1}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1.4142135623730951}}, "df": 64, "r": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.Database.overview": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Column.primary_key": {"tf": 1.4142135623730951}, "sqlite_integrated.Column.foreign_key": {"tf": 1}, "sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1.4142135623730951}}, "df": 12}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1.4142135623730951}, "sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.history": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 6}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.ForeignKey.table": {"tf": 1}, "sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.Column.col_id": {"tf": 1}, "sqlite_integrated.DatabaseEntry": {"tf": 1.7320508075688772}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1.7320508075688772}, "sqlite_integrated.raw_table_to_table": {"tf": 2.23606797749979}, "sqlite_integrated.Query.table": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.UPDATE": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.run": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.create_table": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.rename_table": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.delete_table": {"tf": 2}, "sqlite_integrated.Database.add_column": {"tf": 2}, "sqlite_integrated.Database.rename_column": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.delete_column": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.is_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table_raw": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table": {"tf": 2}, "sqlite_integrated.Database.get_table_cols": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table_id_field": {"tf": 2}, "sqlite_integrated.Database.table_overview": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.is_column": {"tf": 2}, "sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.add_entry": {"tf": 2.449489742783178}, "sqlite_integrated.Database.update_entry": {"tf": 2}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 2}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1.4142135623730951}}, "df": 38, "s": {"docs": {"sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1.7320508075688772}}, "df": 3}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.string_to_list": {"tf": 1}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}}, "df": 3}}}}, "o": {"docs": {"sqlite_integrated.ForeignKey.table": {"tf": 1}, "sqlite_integrated.ForeignKey.to_col": {"tf": 1}, "sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.DatabaseEntry": {"tf": 1.4142135623730951}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.raw_table_to_table": {"tf": 1.4142135623730951}, "sqlite_integrated.value_to_sql_value": {"tf": 1.4142135623730951}, "sqlite_integrated.DatabaseError": {"tf": 1}, "sqlite_integrated.QueryError": {"tf": 1}, "sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1.4142135623730951}, "sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.path": {"tf": 1}, "sqlite_integrated.Database.cursor": {"tf": 1}, "sqlite_integrated.Database.connected": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.add_entry": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.update_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.save": {"tf": 1}, "sqlite_integrated.Database.close": {"tf": 1}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 2}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1.4142135623730951}}, "df": 36, "m": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}}, "df": 1}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Column.type": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.Query.LIKE": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.QueryError": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.connected": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 8}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"sqlite_integrated.raw_table_to_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 4}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.ForeignKey.table": {"tf": 1}, "sqlite_integrated.ForeignKey.to_col": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.Database": {"tf": 1}}, "df": 3}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 3, "d": {"docs": {"sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.Query.WHERE": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Column.primary_key": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1.4142135623730951}}, "df": 4}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.verbose": {"tf": 1}}, "df": 2, "s": {"docs": {"sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.verbose": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 8}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"sqlite_integrated.Query.valid_prefixes": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}}, "df": 4}}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Database.table_overview": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1.4142135623730951}, "sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}}, "df": 4}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.rename_table": {"tf": 1}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 44}}}}}}}, "t": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}}, "df": 4}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.Database.add_entry": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Query.LIKE": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.SELECT": {"tf": 1}}, "df": 2}}}}, "h": {"docs": {"sqlite_integrated.Database": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.path": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 3}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Database.table_to_dataframe": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}}, "df": 2}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.value_to_sql_value": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.Column.type": {"tf": 1}, "sqlite_integrated.Column.col_id": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.verbose": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1.7320508075688772}, "sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.verbose": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.create_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.rename_table": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.overview": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.is_column": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.fill_null": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.add_entry": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.update_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 26, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}}, "df": 3}}}}}}}}}, "t": {"docs": {"sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 2, "s": {"docs": {"sqlite_integrated.value_to_sql_value": {"tf": 1}}, "df": 1}, "o": {"docs": {"sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1.4142135623730951}}, "df": 4}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.Query.table": {"tf": 1}}, "df": 1}}}}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.QueryError": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.connected": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Query.INSERT_INTO": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "d": {"docs": {"sqlite_integrated.ForeignKey.id": {"tf": 1}, "sqlite_integrated.Column.col_id": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1.7320508075688772}}, "df": 9}, "f": {"docs": {"sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.Column.col_id": {"tf": 1}, "sqlite_integrated.Query.valid_prefixes": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.connected": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.update_entry": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.close": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 16}, "s": {"docs": {"sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.DatabaseEntry": {"tf": 1.4142135623730951}, "sqlite_integrated.Query": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.table": {"tf": 1}, "sqlite_integrated.Query.verbose": {"tf": 1}, "sqlite_integrated.Query.valid_prefixes": {"tf": 1}, "sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.connected": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 2}}, "df": 14}, "t": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.reconnect": {"tf": 1}}, "df": 7, "s": {"docs": {"sqlite_integrated.Query.valid_prefixes": {"tf": 1}}, "df": 1}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.string_to_list": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"1": {"docs": {"sqlite_integrated.dict_to_sql": {"tf": 1}}, "df": 1}, "2": {"docs": {"sqlite_integrated.dict_to_sql": {"tf": 1}}, "df": 1}, "docs": {"sqlite_integrated.ForeignKey.from_col": {"tf": 1}, "sqlite_integrated.Column.default_value": {"tf": 1}, "sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1.7320508075688772}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}}, "df": 7, "s": {"docs": {"sqlite_integrated.string_to_list": {"tf": 1.4142135623730951}, "sqlite_integrated.value_to_sql_value": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 6}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Query.valid_prefixes": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1.4142135623730951}, "sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 7}}}}, "y": {"docs": {"sqlite_integrated.Database.get_table": {"tf": 1}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.Database": {"tf": 1}}, "df": 3}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.string_to_list": {"tf": 1}, "sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.table": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 2}, "sqlite_integrated.Database.update_entry": {"tf": 2}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 16, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.close": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.DatabaseError": {"tf": 1}, "sqlite_integrated.QueryError": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 3}, "r": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Database": {"tf": 1}}, "df": 6}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.verbose": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 3}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Database.save": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.close": {"tf": 1}}, "df": 3}}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {"sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"sqlite_integrated.ForeignKey.on_update": {"tf": 1}, "sqlite_integrated.ForeignKey.on_delete": {"tf": 1}, "sqlite_integrated.Column.type": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1.7320508075688772}, "sqlite_integrated.raw_table_to_table": {"tf": 1.7320508075688772}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}}, "df": 8, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.DatabaseError": {"tf": 1}, "sqlite_integrated.Query": {"tf": 2}, "sqlite_integrated.Query.run": {"tf": 1.7320508075688772}, "sqlite_integrated.Database": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.path": {"tf": 1}, "sqlite_integrated.Database.connected": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.in_memory": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.rename_table": {"tf": 1}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1}, "sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.save": {"tf": 1}, "sqlite_integrated.Database.close": {"tf": 1}, "sqlite_integrated.Database.reconnect": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 30, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.add_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.update_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.delete_entry": {"tf": 1}}, "df": 8, "/": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 2}}}}}}}}}}, "s": {"docs": {"sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}}, "df": 2}}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.table_to_dataframe": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Column.default_value": {"tf": 1.4142135623730951}, "sqlite_integrated.Query": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1.4142135623730951}}, "df": 4, "s": {"docs": {"sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 3}, "d": {"docs": {"sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1.7320508075688772}, "sqlite_integrated.dict_to_sql": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}}, "df": 5, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.update_entry": {"tf": 2}}, "df": 5}}, "t": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Query.SET": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1}}}}}}}}, "b": {"docs": {"sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Column": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Column.primary_key": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Column.primary_key": {"tf": 1}, "sqlite_integrated.DatabaseEntry": {"tf": 1.4142135623730951}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.fill_null": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.add_entry": {"tf": 2.449489742783178}, "sqlite_integrated.Database.update_entry": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.delete_entry": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1.4142135623730951}}, "df": 9, "[": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 2, "s": {"docs": {"sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.verbose": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1}}, "df": 3}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Column.primary_key": {"tf": 1}}, "df": 1}}}}, "x": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1.7320508075688772}, "sqlite_integrated.raw_table_to_table": {"tf": 1.4142135623730951}, "sqlite_integrated.dict_to_sql": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.DatabaseError": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.cursor": {"tf": 1.4142135623730951}}, "df": 3}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.fill_null": {"tf": 1}}, "df": 1, "s": {"docs": {"sqlite_integrated.Database.is_column": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Database.close": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}}, "df": 2}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.Database.get_table_id_field": {"tf": 1.4142135623730951}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"sqlite_integrated.Database.overview": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.is_column": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Column.name": {"tf": 1}, "sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.raw_table_to_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.FROM": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.WHERE": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.UPDATE": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.create_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.rename_table": {"tf": 2}, "sqlite_integrated.Database.delete_table": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.add_column": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.rename_column": {"tf": 2.449489742783178}, "sqlite_integrated.Database.delete_column": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.is_table": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.get_table_raw": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table_cols": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.table_overview": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.get_column_names": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.is_column": {"tf": 2.23606797749979}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.update_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1.4142135623730951}}, "df": 29, "s": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}}, "df": 9}}}}, "o": {"docs": {"sqlite_integrated.Query.run": {"tf": 1}}, "df": 1, "t": {"docs": {"sqlite_integrated.Column.not_null": {"tf": 1}, "sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}}, "df": 8, "e": {"docs": {"sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1.4142135623730951}}, "df": 3}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.Query.run": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.Column.not_null": {"tf": 1}, "sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 2}, "sqlite_integrated.Database.update_entry": {"tf": 1.4142135623730951}}, "df": 4}}, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.Database.table_overview": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {"sqlite_integrated.Database": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.create_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.rename_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.rename_column": {"tf": 1.4142135623730951}}, "df": 4}, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "f": {"docs": {"sqlite_integrated.Column.name": {"tf": 1}, "sqlite_integrated.Column.type": {"tf": 1}, "sqlite_integrated.DatabaseEntry": {"tf": 1.7320508075688772}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.raw_table_to_table": {"tf": 2.23606797749979}, "sqlite_integrated.string_to_list": {"tf": 1}, "sqlite_integrated.Query.history": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1.7320508075688772}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1.7320508075688772}, "sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.verbose": {"tf": 1}, "sqlite_integrated.Database.in_memory": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.rename_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.delete_table": {"tf": 1}, "sqlite_integrated.Database.add_column": {"tf": 1}, "sqlite_integrated.Database.rename_column": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.delete_column": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table_names": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.get_table": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.get_table_cols": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.table_overview": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.table_to_dataframe": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 40}, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Column.foreign_key": {"tf": 1}, "sqlite_integrated.Query.history": {"tf": 1}}, "df": 2, "s": {"docs": {"sqlite_integrated.Database.get_table_cols": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {"sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.QueryError": {"tf": 1}, "sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.update_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}}, "df": 10}, "n": {"docs": {"sqlite_integrated.Query": {"tf": 1.7320508075688772}, "sqlite_integrated.Query.history": {"tf": 1}, "sqlite_integrated.Query.verbose": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 6, "e": {"docs": {"sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 4}, "l": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Database.get_table_raw": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.update_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 7}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.Query": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1.7320508075688772}, "sqlite_integrated.Database": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.in_memory": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.overview": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.update_entry": {"tf": 2}, "sqlite_integrated.Database.export_to_csv": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1}}, "df": 16}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.Database.get_table": {"tf": 1}}, "df": 1, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {"sqlite_integrated.Database.overview": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 2, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Column.primary_key": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Database.is_table": {"tf": 1}}, "df": 4}, "v": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Query.history": {"tf": 1}}, "df": 1}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Column.primary_key": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.QueryError": {"tf": 1}}, "df": 1}}}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.fill_null": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 3}}}}}}}}}}, "p": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.UPDATE": {"tf": 1}}, "df": 4, "s": {"docs": {"sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1}}, "df": 2}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.cursor": {"tf": 1}, "sqlite_integrated.Database.close": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 3}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1.4142135623730951}, "sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database": {"tf": 1}, "sqlite_integrated.Database.delete_column": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1}, "sqlite_integrated.Database.delete_entry": {"tf": 1}, "sqlite_integrated.Database.export_to_csv": {"tf": 1}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 20, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}}, "df": 4}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Database.get_table": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.SELECT": {"tf": 1}, "sqlite_integrated.Database.UPDATE": {"tf": 1}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"sqlite_integrated.Database.fill_null": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.value_to_sql_value": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1.4142135623730951}, "sqlite_integrated.Database": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.in_memory": {"tf": 1}, "sqlite_integrated.Database.get_table_id_field": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.update_entry": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}}, "df": 8}}}, "y": {"docs": {"sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.FROM": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.LIKE": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 12}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "k": {"docs": {"sqlite_integrated.Database": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.Database.get_table": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Query": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.Database.in_memory": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.Database": {"tf": 1}}, "df": 1}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"sqlite_integrated.Database.get_table_id_field": {"tf": 1.7320508075688772}}, "df": 1}}}}, "x": {"docs": {"sqlite_integrated.Database.table_overview": {"tf": 1.4142135623730951}}, "df": 1}, "y": {"docs": {"sqlite_integrated.Database.is_column": {"tf": 1}}, "df": 1}}, "y": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}}, "df": 1}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.Query.SELECT": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.SET": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Query.VALUES": {"tf": 1}, "sqlite_integrated.Query.DELETE_FROM": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.delete_entry_by_id": {"tf": 1}}, "df": 8}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.overview": {"tf": 1.4142135623730951}}, "df": 1}}}}, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.value_to_sql_value": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}}, "df": 3}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.DatabaseEntry": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.LIKE": {"tf": 1.4142135623730951}}, "df": 3}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.raw_table_to_table": {"tf": 2.23606797749979}, "sqlite_integrated.string_to_list": {"tf": 1}, "sqlite_integrated.Query.SELECT": {"tf": 1.4142135623730951}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.create_table": {"tf": 1}, "sqlite_integrated.Database.get_table_raw": {"tf": 1.7320508075688772}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.get_table_cols": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1.4142135623730951}}, "df": 12, "[": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database.create_table": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "]": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.export_to_csv": {"tf": 1}}, "df": 1}}}}}}}}}}, "/": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.Database.get_table": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"sqlite_integrated.DatabaseEntry.from_raw_entry": {"tf": 1}, "sqlite_integrated.raw_table_to_table": {"tf": 1}}, "df": 2}}}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Database.get_table": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Database.table_overview": {"tf": 1}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"sqlite_integrated.raw_table_to_table": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}}, "df": 3}}}}}}}, "t": {"docs": {"sqlite_integrated.Database.get_table_raw": {"tf": 1}, "sqlite_integrated.Database.get_table": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.get_entry_by_id": {"tf": 1}}, "df": 4}}, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.verbose": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"sqlite_integrated.Query.valid_prefixes": {"tf": 1}, "sqlite_integrated.Database.table_overview": {"tf": 1}, "sqlite_integrated.Database.get_column_names": {"tf": 1}, "sqlite_integrated.Database.is_column": {"tf": 1.4142135623730951}}, "df": 4}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.value_to_sql_value": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"sqlite_integrated.QueryError": {"tf": 1}, "sqlite_integrated.Query": {"tf": 1}, "sqlite_integrated.Query.table": {"tf": 1}, "sqlite_integrated.Query.verbose": {"tf": 1}, "sqlite_integrated.Query.run": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.run_raw_sql": {"tf": 1}, "sqlite_integrated.Database.SELECT": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.UPDATE": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.INSERT_INTO": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.DELETE_FROM": {"tf": 1.4142135623730951}}, "df": 10}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"sqlite_integrated.Query": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}, "y": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {"sqlite_integrated.Query.FROM": {"tf": 1}, "sqlite_integrated.Query.WHERE": {"tf": 1}, "sqlite_integrated.Query.UPDATE": {"tf": 1}, "sqlite_integrated.Query.INSERT_INTO": {"tf": 1}, "sqlite_integrated.Database.add_entry": {"tf": 1}, "sqlite_integrated.Database.update_entry": {"tf": 1.4142135623730951}, "sqlite_integrated.Database.close": {"tf": 1}}, "df": 7}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();