#include <stdio.h>
#include <string.h>
#include <sys/uio.h>

#define WASM_EXPORT __attribute__((visibility("default")))

typedef struct _person {
  char name[15];
  int age;
} PERSON, *PPERSON;
PERSON p1;

WASM_EXPORT
int main(void) {
  const int len = 3;
  PERSON ps[len];
  strcpy(p1.name, "Name1");
  p1.age = 20;
  PERSON p2;
  strcpy(p2.name, "Name2");
  p2.age = 23;
  PERSON p3;
  strcpy(p3.name, "Name3");
  p3.age = 25;
  ps[0] = p1;
  ps[1] = p2;
  ps[2] = p3;
  printf("Size of PERSON = %d\n", sizeof(PERSON));
  for (int i = 0; i < len; i++)
    printf("Name: %s, Age: %d\n", ps[i].name, ps[i].age);
}

/* External function that is implemented in JavaScript. */
extern void putc_js(char c);

/* Basic implementation of the writev sys call. */ 
WASM_EXPORT
size_t writev_c(int fd, const struct iovec *iov, int iovcnt) {
  size_t cnt = 0;
  for (int i = 0; i < iovcnt; i++) {
    for (int j = 0; j < iov[i].iov_len; j++) {
      putc_js(((char *)iov[i].iov_base)[j]);
    }
    cnt += iov[i].iov_len;
  }
  return cnt;
}
