(*
  B2R2 - the Next-Generation Reversing Platform

  Copyright (c) SoftSec Lab. @ KAIST, since 2016

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all
  copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*)

module B2R2.RearEnd.FileViewer.Helper

open B2R2
open B2R2.FrontEnd.BinFile

/// The console printer.
let internal out = ConsolePrinter () :> Printer

let normalizeEmpty s =
  if System.String.IsNullOrEmpty s then "(n/a)" else s

let toNBytes (v: uint64) =
  v.ToString () + " bytes"

let columnWidthOfAddr (file: IBinFile) =
  WordSize.toByteWidth file.ISA.WordSize * 2

let visibilityString s =
  match s.Visibility with
  | SymbolVisibility.StaticSymbol -> "(s)"
  | SymbolVisibility.DynamicSymbol -> "(d)"
  | _ -> Utils.impossible ()

let symbolKindString (s: Symbol) =
  match s.Kind with
  | SymNoType -> "unknown"
  | SymObjectType -> "object"
  | SymFunctionType -> "function"
  | SymExternFunctionType -> "extfunc"
  | SymTrampolineType -> "trampoline"
  | SymSectionType -> "section"
  | SymFileType -> "file"
  | SymForwardType (bin, func) -> $"{func}@{bin}"

let toLibString s =
  if System.String.IsNullOrEmpty s then s else "@" + s
