(*
  B2R2 - the Next-Generation Reversing Platform

  Copyright (c) SoftSec Lab. @ KAIST, since 2016

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all
  copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*)

module internal B2R2.FrontEnd.BinLifter.ARM64.Disasm

open B2R2
open B2R2.FrontEnd.BinLifter

let condToString = function
  | Some EQ -> "eq"
  | Some NE -> "ne"
  | Some CS -> "cs"
  | Some HS -> "hs"
  | Some CC -> "cc"
  | Some LO -> "lo"
  | Some MI -> "mi"
  | Some PL -> "pl"
  | Some VS -> "vs"
  | Some VC -> "vc"
  | Some HI -> "hi"
  | Some LS -> "ls"
  | Some GE -> "ge"
  | Some LT -> "lt"
  | Some GT -> "gt"
  | Some LE -> "le"
  | Some AL -> ""
  | Some NV -> "nv"
  | None -> ""

let opCodeToString = function
  | Opcode.ABS -> "abs"
  | Opcode.ADC -> "adc"
  | Opcode.ADCLB -> "adclb"
  | Opcode.ADCLT -> "adclt"
  | Opcode.ADCS -> "adcs"
  | Opcode.ADD -> "add"
  | Opcode.ADDG -> "addg"
  | Opcode.ADDHA -> "addha"
  | Opcode.ADDHN -> "addhn"
  | Opcode.ADDHN2 -> "addhn2"
  | Opcode.ADDHNB -> "addhnb"
  | Opcode.ADDHNT -> "addhnt"
  | Opcode.ADDP -> "addp"
  | Opcode.ADDPL -> "addpl"
  | Opcode.ADDQV -> "addqv"
  | Opcode.ADDS -> "adds"
  | Opcode.ADDSPL -> "addspl"
  | Opcode.ADDSVL -> "addsvl"
  | Opcode.ADDV -> "addv"
  | Opcode.ADDVA -> "addva"
  | Opcode.ADDVL -> "addvl"
  | Opcode.ADR -> "adr"
  | Opcode.ADRP -> "adrp"
  | Opcode.AESD -> "aesd"
  | Opcode.AESE -> "aese"
  | Opcode.AESIMC -> "aesimc"
  | Opcode.AESMC -> "aesmc"
  | Opcode.AND -> "and"
  | Opcode.ANDQV -> "andqv"
  | Opcode.ANDS -> "ands"
  | Opcode.ANDV -> "andv"
  | Opcode.ASR -> "asr"
  | Opcode.ASRD -> "asrd"
  | Opcode.ASRR -> "asrr"
  | Opcode.ASRV -> "asrv"
  | Opcode.AT -> "at"
  | Opcode.AUTDA -> "autda"
  | Opcode.AUTDB -> "autdb"
  | Opcode.AUTDZA -> "autdza"
  | Opcode.AUTDZB -> "autdzb"
  | Opcode.AUTIA -> "autia"
  | Opcode.AUTIA1716 -> "autia1716"
  | Opcode.AUTIASP -> "autiasp"
  | Opcode.AUTIAZ -> "autiaz"
  | Opcode.AUTIB -> "autib"
  | Opcode.AUTIB1716 -> "autib1716"
  | Opcode.AUTIBSP -> "autibsp"
  | Opcode.AUTIBZ -> "autibz"
  | Opcode.AUTIZA -> "autiza"
  | Opcode.AUTIZB -> "autizb"
  | Opcode.AXFLAG -> "axflag"
  | Opcode.B -> "b"
  | Opcode.BAL -> "bal"
  | Opcode.BC -> "bc"
  | Opcode.BCAX -> "bcax"
  | Opcode.BCC -> "bcc"
  | Opcode.BCS -> "bcs"
  | Opcode.BDEP -> "bdep"
  | Opcode.BEQ -> "beq"
  | Opcode.BEXT -> "bext"
  | Opcode.BFADD -> "bfadd"
  | Opcode.BFC -> "bfc"
  | Opcode.BFCLAMP -> "bfclamp"
  | Opcode.BFCVT -> "bfcvt"
  | Opcode.BFCVTN -> "bfcvtn"
  | Opcode.BFCVTN2 -> "bfcvtn2"
  | Opcode.BFCVTNT -> "bfcvtnt"
  | Opcode.BFDOT -> "bfdot"
  | Opcode.BFI -> "bfi"
  | Opcode.BFM -> "bfm"
  | Opcode.BFMAX -> "bfmax"
  | Opcode.BFMAXNM -> "bfmaxnm"
  | Opcode.BFMIN -> "bfmin"
  | Opcode.BFMINNM -> "bfminnm"
  | Opcode.BFMLA -> "bfmla"
  | Opcode.BFMLAL -> "bfmlal"
  | Opcode.BFMLALB -> "bfmlalb"
  | Opcode.BFMLALT -> "bfmlalt"
  | Opcode.BFMLS -> "bfmls"
  | Opcode.BFMLSL -> "bfmlsl"
  | Opcode.BFMLSLB -> "bfmlslb"
  | Opcode.BFMLSLT -> "bfmlslt"
  | Opcode.BFMMLA -> "bfmmla"
  | Opcode.BFMOPA -> "bfmopa"
  | Opcode.BFMOPS -> "bfmops"
  | Opcode.BFMUL -> "bfmul"
  | Opcode.BFSUB -> "bfsub"
  | Opcode.BFVDOT -> "bfvdot"
  | Opcode.BFXIL -> "bfxil"
  | Opcode.BGE -> "bge"
  | Opcode.BGRP -> "bgrp"
  | Opcode.BGT -> "bgt"
  | Opcode.BHI -> "bhi"
  | Opcode.BHS -> "bhs"
  | Opcode.BIC -> "bic"
  | Opcode.BICS -> "bics"
  | Opcode.BIF -> "bif"
  | Opcode.BIT -> "bit"
  | Opcode.BL -> "bl"
  | Opcode.BLE -> "ble"
  | Opcode.BLO -> "blo"
  | Opcode.BLR -> "blr"
  | Opcode.BLRAA -> "blraa"
  | Opcode.BLRAAZ -> "blraaz"
  | Opcode.BLRAB -> "blrab"
  | Opcode.BLRABZ -> "blrabz"
  | Opcode.BLS -> "bls"
  | Opcode.BLT -> "blt"
  | Opcode.BMI -> "bmi"
  | Opcode.BMOPA -> "bmopa"
  | Opcode.BMOPS -> "bmops"
  | Opcode.BNE -> "bne"
  | Opcode.BNV -> "bnv"
  | Opcode.BPL -> "bpl"
  | Opcode.BR -> "br"
  | Opcode.BRAA -> "braa"
  | Opcode.BRAAZ -> "braaz"
  | Opcode.BRAB -> "brab"
  | Opcode.BRABZ -> "brabz"
  | Opcode.BRB -> "brb"
  | Opcode.BRK -> "brk"
  | Opcode.BRKA -> "brka"
  | Opcode.BRKAS -> "brkas"
  | Opcode.BRKB -> "brkb"
  | Opcode.BRKBS -> "brkbs"
  | Opcode.BRKN -> "brkn"
  | Opcode.BRKNS -> "brkns"
  | Opcode.BRKPA -> "brkpa"
  | Opcode.BRKPAS -> "brkpas"
  | Opcode.BRKPB -> "brkpb"
  | Opcode.BRKPBS -> "brkpbs"
  | Opcode.BSL -> "bsl"
  | Opcode.BSL1N -> "bsl1n"
  | Opcode.BSL2N -> "bsl2n"
  | Opcode.BTI -> "bti"
  | Opcode.BVC -> "bvc"
  | Opcode.BVS -> "bvs"
  | Opcode.CADD -> "cadd"
  | Opcode.CAS -> "cas"
  | Opcode.CASA -> "casa"
  | Opcode.CASAB -> "casab"
  | Opcode.CASAH -> "casah"
  | Opcode.CASAL -> "casal"
  | Opcode.CASALB -> "casalb"
  | Opcode.CASALH -> "casalh"
  | Opcode.CASB -> "casb"
  | Opcode.CASH -> "cash"
  | Opcode.CASL -> "casl"
  | Opcode.CASLB -> "caslb"
  | Opcode.CASLH -> "caslh"
  | Opcode.CASP -> "casp"
  | Opcode.CASPA -> "caspa"
  | Opcode.CASPAL -> "caspal"
  | Opcode.CASPL -> "caspl"
  | Opcode.CBNZ -> "cbnz"
  | Opcode.CBZ -> "cbz"
  | Opcode.CCMN -> "ccmn"
  | Opcode.CCMP -> "ccmp"
  | Opcode.CDOT -> "cdot"
  | Opcode.CFINV -> "cfinv"
  | Opcode.CFP -> "cfp"
  | Opcode.CINC -> "cinc"
  | Opcode.CINV -> "cinv"
  | Opcode.CLASTA -> "clasta"
  | Opcode.CLASTB -> "clastb"
  | Opcode.CLRBHB -> "clrbhb"
  | Opcode.CLREX -> "clrex"
  | Opcode.CLS -> "cls"
  | Opcode.CLZ -> "clz"
  | Opcode.CMEQ -> "cmeq"
  | Opcode.CMGE -> "cmge"
  | Opcode.CMGT -> "cmgt"
  | Opcode.CMHI -> "cmhi"
  | Opcode.CMHS -> "cmhs"
  | Opcode.CMLA -> "cmla"
  | Opcode.CMLE -> "cmle"
  | Opcode.CMLT -> "cmlt"
  | Opcode.CMN -> "cmn"
  | Opcode.CMP -> "cmp"
  | Opcode.CMPLE -> "cmple"
  | Opcode.CMPLO -> "cmplo"
  | Opcode.CMPLS -> "cmpls"
  | Opcode.CMPLT -> "cmplt"
  | Opcode.CMPP -> "cmpp"
  | Opcode.CMTST -> "cmtst"
  | Opcode.CNEG -> "cneg"
  | Opcode.CNOT -> "cnot"
  | Opcode.CNT -> "cnt"
  | Opcode.CNTB -> "cntb"
  | Opcode.CNTD -> "cntd"
  | Opcode.CNTH -> "cnth"
  | Opcode.CNTP -> "cntp"
  | Opcode.CNTW -> "cntw"
  | Opcode.COMPACT -> "compact"
  | Opcode.COSP -> "cosp"
  | Opcode.CPP -> "cpp"
  | Opcode.CPY -> "cpy"
  | Opcode.CPYE -> "cpye"
  | Opcode.CPYEN -> "cpyen"
  | Opcode.CPYERN -> "cpyern"
  | Opcode.CPYERT -> "cpyert"
  | Opcode.CPYERTN -> "cpyertn"
  | Opcode.CPYERTRN -> "cpyertrn"
  | Opcode.CPYERTWN -> "cpyertwn"
  | Opcode.CPYET -> "cpyet"
  | Opcode.CPYETN -> "cpyetn"
  | Opcode.CPYETRN -> "cpyetrn"
  | Opcode.CPYETWN -> "cpyetwn"
  | Opcode.CPYEWN -> "cpyewn"
  | Opcode.CPYEWT -> "cpyewt"
  | Opcode.CPYEWTN -> "cpyewtn"
  | Opcode.CPYEWTRN -> "cpyewtrn"
  | Opcode.CPYEWTWN -> "cpyewtwn"
  | Opcode.CPYFE -> "cpyfe"
  | Opcode.CPYFEN -> "cpyfen"
  | Opcode.CPYFERN -> "cpyfern"
  | Opcode.CPYFERT -> "cpyfert"
  | Opcode.CPYFERTN -> "cpyfertn"
  | Opcode.CPYFERTRN -> "cpyfertrn"
  | Opcode.CPYFERTWN -> "cpyfertwn"
  | Opcode.CPYFET -> "cpyfet"
  | Opcode.CPYFETN -> "cpyfetn"
  | Opcode.CPYFETRN -> "cpyfetrn"
  | Opcode.CPYFETWN -> "cpyfetwn"
  | Opcode.CPYFEWN -> "cpyfewn"
  | Opcode.CPYFEWT -> "cpyfewt"
  | Opcode.CPYFEWTN -> "cpyfewtn"
  | Opcode.CPYFEWTRN -> "cpyfewtrn"
  | Opcode.CPYFEWTWN -> "cpyfewtwn"
  | Opcode.CPYFM -> "cpyfm"
  | Opcode.CPYFMN -> "cpyfmn"
  | Opcode.CPYFMRN -> "cpyfmrn"
  | Opcode.CPYFMRT -> "cpyfmrt"
  | Opcode.CPYFMRTN -> "cpyfmrtn"
  | Opcode.CPYFMRTRN -> "cpyfmrtrn"
  | Opcode.CPYFMRTWN -> "cpyfmrtwn"
  | Opcode.CPYFMT -> "cpyfmt"
  | Opcode.CPYFMTN -> "cpyfmtn"
  | Opcode.CPYFMTRN -> "cpyfmtrn"
  | Opcode.CPYFMTWN -> "cpyfmtwn"
  | Opcode.CPYFMWN -> "cpyfmwn"
  | Opcode.CPYFMWT -> "cpyfmwt"
  | Opcode.CPYFMWTN -> "cpyfmwtn"
  | Opcode.CPYFMWTRN -> "cpyfmwtrn"
  | Opcode.CPYFMWTWN -> "cpyfmwtwn"
  | Opcode.CPYFP -> "cpyfp"
  | Opcode.CPYFPN -> "cpyfpn"
  | Opcode.CPYFPRN -> "cpyfprn"
  | Opcode.CPYFPRT -> "cpyfprt"
  | Opcode.CPYFPRTN -> "cpyfprtn"
  | Opcode.CPYFPRTRN -> "cpyfprtrn"
  | Opcode.CPYFPRTWN -> "cpyfprtwn"
  | Opcode.CPYFPT -> "cpyfpt"
  | Opcode.CPYFPTN -> "cpyfptn"
  | Opcode.CPYFPTRN -> "cpyfptrn"
  | Opcode.CPYFPTWN -> "cpyfptwn"
  | Opcode.CPYFPWN -> "cpyfpwn"
  | Opcode.CPYFPWT -> "cpyfpwt"
  | Opcode.CPYFPWTN -> "cpyfpwtn"
  | Opcode.CPYFPWTRN -> "cpyfpwtrn"
  | Opcode.CPYFPWTWN -> "cpyfpwtwn"
  | Opcode.CPYM -> "cpym"
  | Opcode.CPYMN -> "cpymn"
  | Opcode.CPYMRN -> "cpymrn"
  | Opcode.CPYMRT -> "cpymrt"
  | Opcode.CPYMRTN -> "cpymrtn"
  | Opcode.CPYMRTRN -> "cpymrtrn"
  | Opcode.CPYMRTWN -> "cpymrtwn"
  | Opcode.CPYMT -> "cpymt"
  | Opcode.CPYMTN -> "cpymtn"
  | Opcode.CPYMTRN -> "cpymtrn"
  | Opcode.CPYMTWN -> "cpymtwn"
  | Opcode.CPYMWN -> "cpymwn"
  | Opcode.CPYMWT -> "cpymwt"
  | Opcode.CPYMWTN -> "cpymwtn"
  | Opcode.CPYMWTRN -> "cpymwtrn"
  | Opcode.CPYMWTWN -> "cpymwtwn"
  | Opcode.CPYP -> "cpyp"
  | Opcode.CPYPN -> "cpypn"
  | Opcode.CPYPRN -> "cpyprn"
  | Opcode.CPYPRT -> "cpyprt"
  | Opcode.CPYPRTN -> "cpyprtn"
  | Opcode.CPYPRTRN -> "cpyprtrn"
  | Opcode.CPYPRTWN -> "cpyprtwn"
  | Opcode.CPYPT -> "cpypt"
  | Opcode.CPYPTN -> "cpyptn"
  | Opcode.CPYPTRN -> "cpyptrn"
  | Opcode.CPYPTWN -> "cpyptwn"
  | Opcode.CPYPWN -> "cpypwn"
  | Opcode.CPYPWT -> "cpypwt"
  | Opcode.CPYPWTN -> "cpypwtn"
  | Opcode.CPYPWTRN -> "cpypwtrn"
  | Opcode.CPYPWTWN -> "cpypwtwn"
  | Opcode.CRC32B -> "crc32b"
  | Opcode.CRC32CB -> "crc32cb"
  | Opcode.CRC32CH -> "crc32ch"
  | Opcode.CRC32CW -> "crc32cw"
  | Opcode.CRC32CX -> "crc32cx"
  | Opcode.CRC32H -> "crc32h"
  | Opcode.CRC32W -> "crc32w"
  | Opcode.CRC32X -> "crc32x"
  | Opcode.CSDB -> "csdb"
  | Opcode.CSEL -> "csel"
  | Opcode.CSET -> "cset"
  | Opcode.CSETM -> "csetm"
  | Opcode.CSINC -> "csinc"
  | Opcode.CSINV -> "csinv"
  | Opcode.CSNEG -> "csneg"
  | Opcode.CTERMEQ -> "ctermeq"
  | Opcode.CTERMNE -> "ctermne"
  | Opcode.CTZ -> "ctz"
  | Opcode.DC -> "dc"
  | Opcode.DCCGDSW -> "dccgdsw"
  | Opcode.DCCGDVAC -> "dccgdvac"
  | Opcode.DCCGDVADP -> "dccgdvadp"
  | Opcode.DCCGDVAP -> "dccgdvap"
  | Opcode.DCCGSW -> "dccgsw"
  | Opcode.DCCGVAC -> "dccgvac"
  | Opcode.DCCGVADP -> "dccgvadp"
  | Opcode.DCCGVAP -> "dccgvap"
  | Opcode.DCCIGDSW -> "dccigdsw"
  | Opcode.DCCIGDVAC -> "dccigdvac"
  | Opcode.DCCIGSW -> "dccigsw"
  | Opcode.DCCIGVAC -> "dccigvac"
  | Opcode.DCCISW -> "dccisw"
  | Opcode.DCCIVAC -> "dccivac"
  | Opcode.DCCSW -> "dccsw"
  | Opcode.DCCVAC -> "dccvac"
  | Opcode.DCCVADP -> "dccvadp"
  | Opcode.DCCVAP -> "dccvap"
  | Opcode.DCCVAU -> "dccvau"
  | Opcode.DCGVA -> "dcgva"
  | Opcode.DCGZVA -> "dcgzva"
  | Opcode.DCIGDSW -> "dcigdsw"
  | Opcode.DCIGDVAC -> "dcigdvac"
  | Opcode.DCIGSW -> "dcigsw"
  | Opcode.DCIGVAC -> "dcigvac"
  | Opcode.DCISW -> "dcisw"
  | Opcode.DCIVAC -> "dcivac"
  | Opcode.DCPS1 -> "dcps1"
  | Opcode.DCPS2 -> "dcps2"
  | Opcode.DCPS3 -> "dcps3"
  | Opcode.DCZVA -> "dczva"
  | Opcode.DECB -> "decb"
  | Opcode.DECD -> "decd"
  | Opcode.DECH -> "dech"
  | Opcode.DECP -> "decp"
  | Opcode.DECW -> "decw"
  | Opcode.DGH -> "dgh"
  | Opcode.DMB -> "dmb"
  | Opcode.DRPS -> "drps"
  | Opcode.DSB -> "dsb"
  | Opcode.DUP -> "dup"
  | Opcode.DUPM -> "dupm"
  | Opcode.DUPQ -> "dupq"
  | Opcode.DVP -> "dvp"
  | Opcode.EON -> "eon"
  | Opcode.EOR -> "eor"
  | Opcode.EOR3 -> "eor3"
  | Opcode.EORBT -> "eorbt"
  | Opcode.EORQV -> "eorqv"
  | Opcode.EORS -> "eors"
  | Opcode.EORTB -> "eortb"
  | Opcode.EORV -> "eorv"
  | Opcode.ERET -> "eret"
  | Opcode.ERETAA -> "eretaa"
  | Opcode.ERETAB -> "eretab"
  | Opcode.ESB -> "esb"
  | Opcode.EXT -> "ext"
  | Opcode.EXTQ -> "extq"
  | Opcode.EXTR -> "extr"
  | Opcode.FABD -> "fabd"
  | Opcode.FABS -> "fabs"
  | Opcode.FAC -> "fac"
  | Opcode.FACGE -> "facge"
  | Opcode.FACGT -> "facgt"
  | Opcode.FACLE -> "facle"
  | Opcode.FACLT -> "faclt"
  | Opcode.FADD -> "fadd"
  | Opcode.FADDA -> "fadda"
  | Opcode.FADDP -> "faddp"
  | Opcode.FADDQV -> "faddqv"
  | Opcode.FADDV -> "faddv"
  | Opcode.FCADD -> "fcadd"
  | Opcode.FCCMP -> "fccmp"
  | Opcode.FCCMPE -> "fccmpe"
  | Opcode.FCLAMP -> "fclamp"
  | Opcode.FCM -> "fcm"
  | Opcode.FCMEQ -> "fcmeq"
  | Opcode.FCMGE -> "fcmge"
  | Opcode.FCMGT -> "fcmgt"
  | Opcode.FCMLA -> "fcmla"
  | Opcode.FCMLE -> "fcmle"
  | Opcode.FCMLT -> "fcmlt"
  | Opcode.FCMP -> "fcmp"
  | Opcode.FCMPE -> "fcmpe"
  | Opcode.FCPY -> "fcpy"
  | Opcode.FCSEL -> "fcsel"
  | Opcode.FCVT -> "fcvt"
  | Opcode.FCVTAS -> "fcvtas"
  | Opcode.FCVTAU -> "fcvtau"
  | Opcode.FCVTL -> "fcvtl"
  | Opcode.FCVTL2 -> "fcvtl2"
  | Opcode.FCVTLT -> "fcvtlt"
  | Opcode.FCVTMS -> "fcvtms"
  | Opcode.FCVTMU -> "fcvtmu"
  | Opcode.FCVTN -> "fcvtn"
  | Opcode.FCVTN2 -> "fcvtn2"
  | Opcode.FCVTNS -> "fcvtns"
  | Opcode.FCVTNT -> "fcvtnt"
  | Opcode.FCVTNU -> "fcvtnu"
  | Opcode.FCVTPS -> "fcvtps"
  | Opcode.FCVTPU -> "fcvtpu"
  | Opcode.FCVTX -> "fcvtx"
  | Opcode.FCVTXN -> "fcvtxn"
  | Opcode.FCVTXN2 -> "fcvtxn2"
  | Opcode.FCVTXNT -> "fcvtxnt"
  | Opcode.FCVTZS -> "fcvtzs"
  | Opcode.FCVTZU -> "fcvtzu"
  | Opcode.FDIV -> "fdiv"
  | Opcode.FDIVR -> "fdivr"
  | Opcode.FDOT -> "fdot"
  | Opcode.FDUP -> "fdup"
  | Opcode.FEXPA -> "fexpa"
  | Opcode.FJCVTZS -> "fjcvtzs"
  | Opcode.FLOGB -> "flogb"
  | Opcode.FMAD -> "fmad"
  | Opcode.FMADD -> "fmadd"
  | Opcode.FMAX -> "fmax"
  | Opcode.FMAXNM -> "fmaxnm"
  | Opcode.FMAXNMP -> "fmaxnmp"
  | Opcode.FMAXNMQV -> "fmaxnmqv"
  | Opcode.FMAXNMV -> "fmaxnmv"
  | Opcode.FMAXP -> "fmaxp"
  | Opcode.FMAXQV -> "fmaxqv"
  | Opcode.FMAXV -> "fmaxv"
  | Opcode.FMIN -> "fmin"
  | Opcode.FMINNM -> "fminnm"
  | Opcode.FMINNMP -> "fminnmp"
  | Opcode.FMINNMQV -> "fminnmqv"
  | Opcode.FMINNMV -> "fminnmv"
  | Opcode.FMINP -> "fminp"
  | Opcode.FMINQV -> "fminqv"
  | Opcode.FMINV -> "fminv"
  | Opcode.FMLA -> "fmla"
  | Opcode.FMLAL -> "fmlal"
  | Opcode.FMLAL2 -> "fmlal2"
  | Opcode.FMLALB -> "fmlalb"
  | Opcode.FMLALT -> "fmlalt"
  | Opcode.FMLS -> "fmls"
  | Opcode.FMLSL -> "fmlsl"
  | Opcode.FMLSL2 -> "fmlsl2"
  | Opcode.FMLSLB -> "fmlslb"
  | Opcode.FMLSLT -> "fmlslt"
  | Opcode.FMMLA -> "fmmla"
  | Opcode.FMOPA -> "fmopa"
  | Opcode.FMOPS -> "fmops"
  | Opcode.FMOV -> "fmov"
  | Opcode.FMSB -> "fmsb"
  | Opcode.FMSUB -> "fmsub"
  | Opcode.FMUL -> "fmul"
  | Opcode.FMULX -> "fmulx"
  | Opcode.FNEG -> "fneg"
  | Opcode.FNMAD -> "fnmad"
  | Opcode.FNMADD -> "fnmadd"
  | Opcode.FNMLA -> "fnmla"
  | Opcode.FNMLS -> "fnmls"
  | Opcode.FNMSB -> "fnmsb"
  | Opcode.FNMSUB -> "fnmsub"
  | Opcode.FNMUL -> "fnmul"
  | Opcode.FRECPE -> "frecpe"
  | Opcode.FRECPS -> "frecps"
  | Opcode.FRECPX -> "frecpx"
  | Opcode.FRINT -> "frint"
  | Opcode.FRINT32X -> "frint32x"
  | Opcode.FRINT32Z -> "frint32z"
  | Opcode.FRINT64X -> "frint64x"
  | Opcode.FRINT64Z -> "frint64z"
  | Opcode.FRINTA -> "frinta"
  | Opcode.FRINTI -> "frinti"
  | Opcode.FRINTM -> "frintm"
  | Opcode.FRINTN -> "frintn"
  | Opcode.FRINTP -> "frintp"
  | Opcode.FRINTX -> "frintx"
  | Opcode.FRINTZ -> "frintz"
  | Opcode.FRSQRTE -> "frsqrte"
  | Opcode.FRSQRTS -> "frsqrts"
  | Opcode.FSCALE -> "fscale"
  | Opcode.FSQRT -> "fsqrt"
  | Opcode.FSUB -> "fsub"
  | Opcode.FSUBR -> "fsubr"
  | Opcode.FTMAD -> "ftmad"
  | Opcode.FTSMUL -> "ftsmul"
  | Opcode.FTSSEL -> "ftssel"
  | Opcode.FVDOT -> "fvdot"
  | Opcode.GMI -> "gmi"
  | Opcode.HINT -> "hint"
  | Opcode.HISTCNT -> "histcnt"
  | Opcode.HISTSEG -> "histseg"
  | Opcode.HLT -> "hlt"
  | Opcode.HVC -> "hvc"
  | Opcode.IC -> "ic"
  | Opcode.INCB -> "incb"
  | Opcode.INCD -> "incd"
  | Opcode.INCH -> "inch"
  | Opcode.INCP -> "incp"
  | Opcode.INCW -> "incw"
  | Opcode.INDEX -> "index"
  | Opcode.INS -> "ins"
  | Opcode.INSR -> "insr"
  | Opcode.IRG -> "irg"
  | Opcode.ISB -> "isb"
  | Opcode.LASTA -> "lasta"
  | Opcode.LASTB -> "lastb"
  | Opcode.LD1 -> "ld1"
  | Opcode.LD1B -> "ld1b"
  | Opcode.LD1D -> "ld1d"
  | Opcode.LD1H -> "ld1h"
  | Opcode.LD1Q -> "ld1q"
  | Opcode.LD1R -> "ld1r"
  | Opcode.LD1RB -> "ld1rb"
  | Opcode.LD1RD -> "ld1rd"
  | Opcode.LD1RH -> "ld1rh"
  | Opcode.LD1ROB -> "ld1rob"
  | Opcode.LD1ROD -> "ld1rod"
  | Opcode.LD1ROH -> "ld1roh"
  | Opcode.LD1ROW -> "ld1row"
  | Opcode.LD1RQB -> "ld1rqb"
  | Opcode.LD1RQD -> "ld1rqd"
  | Opcode.LD1RQH -> "ld1rqh"
  | Opcode.LD1RQW -> "ld1rqw"
  | Opcode.LD1RSB -> "ld1rsb"
  | Opcode.LD1RSH -> "ld1rsh"
  | Opcode.LD1RSW -> "ld1rsw"
  | Opcode.LD1RW -> "ld1rw"
  | Opcode.LD1SB -> "ld1sb"
  | Opcode.LD1SH -> "ld1sh"
  | Opcode.LD1SW -> "ld1sw"
  | Opcode.LD1W -> "ld1w"
  | Opcode.LD2 -> "ld2"
  | Opcode.LD2B -> "ld2b"
  | Opcode.LD2D -> "ld2d"
  | Opcode.LD2H -> "ld2h"
  | Opcode.LD2Q -> "ld2q"
  | Opcode.LD2R -> "ld2r"
  | Opcode.LD2W -> "ld2w"
  | Opcode.LD3 -> "ld3"
  | Opcode.LD3B -> "ld3b"
  | Opcode.LD3D -> "ld3d"
  | Opcode.LD3H -> "ld3h"
  | Opcode.LD3Q -> "ld3q"
  | Opcode.LD3R -> "ld3r"
  | Opcode.LD3W -> "ld3w"
  | Opcode.LD4 -> "ld4"
  | Opcode.LD4B -> "ld4b"
  | Opcode.LD4D -> "ld4d"
  | Opcode.LD4H -> "ld4h"
  | Opcode.LD4Q -> "ld4q"
  | Opcode.LD4R -> "ld4r"
  | Opcode.LD4W -> "ld4w"
  | Opcode.LD64B -> "ld64b"
  | Opcode.LDADD -> "ldadd"
  | Opcode.LDADDA -> "ldadda"
  | Opcode.LDADDAB -> "ldaddab"
  | Opcode.LDADDAH -> "ldaddah"
  | Opcode.LDADDAL -> "ldaddal"
  | Opcode.LDADDALB -> "ldaddalb"
  | Opcode.LDADDALH -> "ldaddalh"
  | Opcode.LDADDB -> "ldaddb"
  | Opcode.LDADDH -> "ldaddh"
  | Opcode.LDADDL -> "ldaddl"
  | Opcode.LDADDLB -> "ldaddlb"
  | Opcode.LDADDLH -> "ldaddlh"
  | Opcode.LDAP1 -> "ldap1"
  | Opcode.LDAPR -> "ldapr"
  | Opcode.LDAPRB -> "ldaprb"
  | Opcode.LDAPRH -> "ldaprh"
  | Opcode.LDAPUR -> "ldapur"
  | Opcode.LDAPURB -> "ldapurb"
  | Opcode.LDAPURH -> "ldapurh"
  | Opcode.LDAPURSB -> "ldapursb"
  | Opcode.LDAPURSH -> "ldapursh"
  | Opcode.LDAPURSW -> "ldapursw"
  | Opcode.LDAR -> "ldar"
  | Opcode.LDARB -> "ldarb"
  | Opcode.LDARH -> "ldarh"
  | Opcode.LDAXP -> "ldaxp"
  | Opcode.LDAXR -> "ldaxr"
  | Opcode.LDAXRB -> "ldaxrb"
  | Opcode.LDAXRH -> "ldaxrh"
  | Opcode.LDCLR -> "ldclr"
  | Opcode.LDCLRA -> "ldclra"
  | Opcode.LDCLRAB -> "ldclrab"
  | Opcode.LDCLRAH -> "ldclrah"
  | Opcode.LDCLRAL -> "ldclral"
  | Opcode.LDCLRALB -> "ldclralb"
  | Opcode.LDCLRALH -> "ldclralh"
  | Opcode.LDCLRB -> "ldclrb"
  | Opcode.LDCLRH -> "ldclrh"
  | Opcode.LDCLRL -> "ldclrl"
  | Opcode.LDCLRLB -> "ldclrlb"
  | Opcode.LDCLRLH -> "ldclrlh"
  | Opcode.LDCLRP -> "ldclrp"
  | Opcode.LDCLRPA -> "ldclrpa"
  | Opcode.LDCLRPAL -> "ldclrpal"
  | Opcode.LDCLRPL -> "ldclrpl"
  | Opcode.LDEOR -> "ldeor"
  | Opcode.LDEORA -> "ldeora"
  | Opcode.LDEORAB -> "ldeorab"
  | Opcode.LDEORAH -> "ldeorah"
  | Opcode.LDEORAL -> "ldeoral"
  | Opcode.LDEORALB -> "ldeoralb"
  | Opcode.LDEORALH -> "ldeoralh"
  | Opcode.LDEORB -> "ldeorb"
  | Opcode.LDEORH -> "ldeorh"
  | Opcode.LDEORL -> "ldeorl"
  | Opcode.LDEORLB -> "ldeorlb"
  | Opcode.LDEORLH -> "ldeorlh"
  | Opcode.LDFF1B -> "ldff1b"
  | Opcode.LDFF1D -> "ldff1d"
  | Opcode.LDFF1H -> "ldff1h"
  | Opcode.LDFF1SB -> "ldff1sb"
  | Opcode.LDFF1SH -> "ldff1sh"
  | Opcode.LDFF1SW -> "ldff1sw"
  | Opcode.LDFF1W -> "ldff1w"
  | Opcode.LDG -> "ldg"
  | Opcode.LDGM -> "ldgm"
  | Opcode.LDIAPP -> "ldiapp"
  | Opcode.LDLAR -> "ldlar"
  | Opcode.LDLARB -> "ldlarb"
  | Opcode.LDLARH -> "ldlarh"
  | Opcode.LDNF1B -> "ldnf1b"
  | Opcode.LDNF1D -> "ldnf1d"
  | Opcode.LDNF1H -> "ldnf1h"
  | Opcode.LDNF1SB -> "ldnf1sb"
  | Opcode.LDNF1SH -> "ldnf1sh"
  | Opcode.LDNF1SW -> "ldnf1sw"
  | Opcode.LDNF1W -> "ldnf1w"
  | Opcode.LDNP -> "ldnp"
  | Opcode.LDNT1B -> "ldnt1b"
  | Opcode.LDNT1D -> "ldnt1d"
  | Opcode.LDNT1H -> "ldnt1h"
  | Opcode.LDNT1SB -> "ldnt1sb"
  | Opcode.LDNT1SH -> "ldnt1sh"
  | Opcode.LDNT1SW -> "ldnt1sw"
  | Opcode.LDNT1W -> "ldnt1w"
  | Opcode.LDP -> "ldp"
  | Opcode.LDPSW -> "ldpsw"
  | Opcode.LDR -> "ldr"
  | Opcode.LDRAA -> "ldraa"
  | Opcode.LDRAB -> "ldrab"
  | Opcode.LDRB -> "ldrb"
  | Opcode.LDRH -> "ldrh"
  | Opcode.LDRSB -> "ldrsb"
  | Opcode.LDRSH -> "ldrsh"
  | Opcode.LDRSW -> "ldrsw"
  | Opcode.LDSET -> "ldset"
  | Opcode.LDSETA -> "ldseta"
  | Opcode.LDSETAB -> "ldsetab"
  | Opcode.LDSETAH -> "ldsetah"
  | Opcode.LDSETAL -> "ldsetal"
  | Opcode.LDSETALB -> "ldsetalb"
  | Opcode.LDSETALH -> "ldsetalh"
  | Opcode.LDSETB -> "ldsetb"
  | Opcode.LDSETH -> "ldseth"
  | Opcode.LDSETL -> "ldsetl"
  | Opcode.LDSETLB -> "ldsetlb"
  | Opcode.LDSETLH -> "ldsetlh"
  | Opcode.LDSETP -> "ldsetp"
  | Opcode.LDSETPA -> "ldsetpa"
  | Opcode.LDSETPAL -> "ldsetpal"
  | Opcode.LDSETPL -> "ldsetpl"
  | Opcode.LDSMAX -> "ldsmax"
  | Opcode.LDSMAXA -> "ldsmaxa"
  | Opcode.LDSMAXAB -> "ldsmaxab"
  | Opcode.LDSMAXAH -> "ldsmaxah"
  | Opcode.LDSMAXAL -> "ldsmaxal"
  | Opcode.LDSMAXALB -> "ldsmaxalb"
  | Opcode.LDSMAXALH -> "ldsmaxalh"
  | Opcode.LDSMAXB -> "ldsmaxb"
  | Opcode.LDSMAXH -> "ldsmaxh"
  | Opcode.LDSMAXL -> "ldsmaxl"
  | Opcode.LDSMAXLB -> "ldsmaxlb"
  | Opcode.LDSMAXLH -> "ldsmaxlh"
  | Opcode.LDSMIN -> "ldsmin"
  | Opcode.LDSMINA -> "ldsmina"
  | Opcode.LDSMINAB -> "ldsminab"
  | Opcode.LDSMINAH -> "ldsminah"
  | Opcode.LDSMINAL -> "ldsminal"
  | Opcode.LDSMINALB -> "ldsminalb"
  | Opcode.LDSMINALH -> "ldsminalh"
  | Opcode.LDSMINB -> "ldsminb"
  | Opcode.LDSMINH -> "ldsminh"
  | Opcode.LDSMINL -> "ldsminl"
  | Opcode.LDSMINLB -> "ldsminlb"
  | Opcode.LDSMINLH -> "ldsminlh"
  | Opcode.LDTR -> "ldtr"
  | Opcode.LDTRB -> "ldtrb"
  | Opcode.LDTRH -> "ldtrh"
  | Opcode.LDTRSB -> "ldtrsb"
  | Opcode.LDTRSH -> "ldtrsh"
  | Opcode.LDTRSW -> "ldtrsw"
  | Opcode.LDUMAX -> "ldumax"
  | Opcode.LDUMAXA -> "ldumaxa"
  | Opcode.LDUMAXAB -> "ldumaxab"
  | Opcode.LDUMAXAH -> "ldumaxah"
  | Opcode.LDUMAXAL -> "ldumaxal"
  | Opcode.LDUMAXALB -> "ldumaxalb"
  | Opcode.LDUMAXALH -> "ldumaxalh"
  | Opcode.LDUMAXB -> "ldumaxb"
  | Opcode.LDUMAXH -> "ldumaxh"
  | Opcode.LDUMAXL -> "ldumaxl"
  | Opcode.LDUMAXLB -> "ldumaxlb"
  | Opcode.LDUMAXLH -> "ldumaxlh"
  | Opcode.LDUMIN -> "ldumin"
  | Opcode.LDUMINA -> "ldumina"
  | Opcode.LDUMINAB -> "lduminab"
  | Opcode.LDUMINAH -> "lduminah"
  | Opcode.LDUMINAL -> "lduminal"
  | Opcode.LDUMINALB -> "lduminalb"
  | Opcode.LDUMINALH -> "lduminalh"
  | Opcode.LDUMINB -> "lduminb"
  | Opcode.LDUMINH -> "lduminh"
  | Opcode.LDUMINL -> "lduminl"
  | Opcode.LDUMINLB -> "lduminlb"
  | Opcode.LDUMINLH -> "lduminlh"
  | Opcode.LDUR -> "ldur"
  | Opcode.LDURB -> "ldurb"
  | Opcode.LDURH -> "ldurh"
  | Opcode.LDURSB -> "ldursb"
  | Opcode.LDURSH -> "ldursh"
  | Opcode.LDURSW -> "ldursw"
  | Opcode.LDXP -> "ldxp"
  | Opcode.LDXR -> "ldxr"
  | Opcode.LDXRB -> "ldxrb"
  | Opcode.LDXRH -> "ldxrh"
  | Opcode.LSL -> "lsl"
  | Opcode.LSLR -> "lslr"
  | Opcode.LSLV -> "lslv"
  | Opcode.LSR -> "lsr"
  | Opcode.LSRR -> "lsrr"
  | Opcode.LSRV -> "lsrv"
  | Opcode.LUTI2 -> "luti2"
  | Opcode.LUTI4 -> "luti4"
  | Opcode.MAD -> "mad"
  | Opcode.MADD -> "madd"
  | Opcode.MATCH -> "match"
  | Opcode.MLA -> "mla"
  | Opcode.MLS -> "mls"
  | Opcode.MNEG -> "mneg"
  | Opcode.MOV -> "mov"
  | Opcode.MOVA -> "mova"
  | Opcode.MOVAZ -> "movaz"
  | Opcode.MOVI -> "movi"
  | Opcode.MOVK -> "movk"
  | Opcode.MOVN -> "movn"
  | Opcode.MOVPRFX -> "movprfx"
  | Opcode.MOVS -> "movs"
  | Opcode.MOVT -> "movt"
  | Opcode.MOVZ -> "movz"
  | Opcode.MRRS -> "mrrs"
  | Opcode.MRS -> "mrs"
  | Opcode.MSB -> "msb"
  | Opcode.MSR -> "msr"
  | Opcode.MSRR -> "msrr"
  | Opcode.MSUB -> "msub"
  | Opcode.MUL -> "mul"
  | Opcode.MVN -> "mvn"
  | Opcode.MVNI -> "mvni"
  | Opcode.NAND -> "nand"
  | Opcode.NANDS -> "nands"
  | Opcode.NBSL -> "nbsl"
  | Opcode.NEG -> "neg"
  | Opcode.NEGS -> "negs"
  | Opcode.NGC -> "ngc"
  | Opcode.NGCS -> "ngcs"
  | Opcode.NMATCH -> "nmatch"
  | Opcode.NOP -> "nop"
  | Opcode.NOR -> "nor"
  | Opcode.NORS -> "nors"
  | Opcode.NOT -> "not"
  | Opcode.NOTS -> "nots"
  | Opcode.ORN -> "orn"
  | Opcode.ORNS -> "orns"
  | Opcode.ORQV -> "orqv"
  | Opcode.ORR -> "orr"
  | Opcode.ORRS -> "orrs"
  | Opcode.ORV -> "orv"
  | Opcode.PACDA -> "pacda"
  | Opcode.PACDB -> "pacdb"
  | Opcode.PACDZA -> "pacdza"
  | Opcode.PACDZB -> "pacdzb"
  | Opcode.PACGA -> "pacga"
  | Opcode.PACIA -> "pacia"
  | Opcode.PACIA1716 -> "pacia1716"
  | Opcode.PACIASP -> "paciasp"
  | Opcode.PACIAZ -> "paciaz"
  | Opcode.PACIB -> "pacib"
  | Opcode.PACIB1716 -> "pacib1716"
  | Opcode.PACIBSP -> "pacibsp"
  | Opcode.PACIBZ -> "pacibz"
  | Opcode.PACIZA -> "paciza"
  | Opcode.PACIZB -> "pacizb"
  | Opcode.PEXT -> "pext"
  | Opcode.PFALSE -> "pfalse"
  | Opcode.PFIRST -> "pfirst"
  | Opcode.PMOV -> "pmov"
  | Opcode.PMUL -> "pmul"
  | Opcode.PMULL -> "pmull"
  | Opcode.PMULL2 -> "pmull2"
  | Opcode.PMULLB -> "pmullb"
  | Opcode.PMULLT -> "pmullt"
  | Opcode.PNEXT -> "pnext"
  | Opcode.PRFB -> "prfb"
  | Opcode.PRFD -> "prfd"
  | Opcode.PRFH -> "prfh"
  | Opcode.PRFM -> "prfm"
  | Opcode.PRFUM -> "prfum"
  | Opcode.PRFW -> "prfw"
  | Opcode.PSB -> "psb"
  | Opcode.PSEL -> "psel"
  | Opcode.PSSBB -> "pssbb"
  | Opcode.PTEST -> "ptest"
  | Opcode.PTRUE -> "ptrue"
  | Opcode.PTRUES -> "ptrues"
  | Opcode.PUNPKHI -> "punpkhi"
  | Opcode.PUNPKLO -> "punpklo"
  | Opcode.RADDHN -> "raddhn"
  | Opcode.RADDHN2 -> "raddhn2"
  | Opcode.RADDHNB -> "raddhnb"
  | Opcode.RADDHNT -> "raddhnt"
  | Opcode.RAX1 -> "rax1"
  | Opcode.RBIT -> "rbit"
  | Opcode.RCWCAS -> "rcwcas"
  | Opcode.RCWCASA -> "rcwcasa"
  | Opcode.RCWCASAL -> "rcwcasal"
  | Opcode.RCWCASL -> "rcwcasl"
  | Opcode.RCWCASP -> "rcwcasp"
  | Opcode.RCWCASPA -> "rcwcaspa"
  | Opcode.RCWCASPAL -> "rcwcaspal"
  | Opcode.RCWCASPL -> "rcwcaspl"
  | Opcode.RCWCLR -> "rcwclr"
  | Opcode.RCWCLRA -> "rcwclra"
  | Opcode.RCWCLRAL -> "rcwclral"
  | Opcode.RCWCLRL -> "rcwclrl"
  | Opcode.RCWCLRP -> "rcwclrp"
  | Opcode.RCWCLRPA -> "rcwclrpa"
  | Opcode.RCWCLRPAL -> "rcwclrpal"
  | Opcode.RCWCLRPL -> "rcwclrpl"
  | Opcode.RCWSCAS -> "rcwscas"
  | Opcode.RCWSCASA -> "rcwscasa"
  | Opcode.RCWSCASAL -> "rcwscasal"
  | Opcode.RCWSCASL -> "rcwscasl"
  | Opcode.RCWSCASP -> "rcwscasp"
  | Opcode.RCWSCASPA -> "rcwscaspa"
  | Opcode.RCWSCASPAL -> "rcwscaspal"
  | Opcode.RCWSCASPL -> "rcwscaspl"
  | Opcode.RCWSCLR -> "rcwsclr"
  | Opcode.RCWSCLRA -> "rcwsclra"
  | Opcode.RCWSCLRAL -> "rcwsclral"
  | Opcode.RCWSCLRL -> "rcwsclrl"
  | Opcode.RCWSCLRP -> "rcwsclrp"
  | Opcode.RCWSCLRPA -> "rcwsclrpa"
  | Opcode.RCWSCLRPAL -> "rcwsclrpal"
  | Opcode.RCWSCLRPL -> "rcwsclrpl"
  | Opcode.RCWSET -> "rcwset"
  | Opcode.RCWSETA -> "rcwseta"
  | Opcode.RCWSETAL -> "rcwsetal"
  | Opcode.RCWSETL -> "rcwsetl"
  | Opcode.RCWSETP -> "rcwsetp"
  | Opcode.RCWSETPA -> "rcwsetpa"
  | Opcode.RCWSETPAL -> "rcwsetpal"
  | Opcode.RCWSETPL -> "rcwsetpl"
  | Opcode.RCWSSET -> "rcwsset"
  | Opcode.RCWSSETA -> "rcwsseta"
  | Opcode.RCWSSETAL -> "rcwssetal"
  | Opcode.RCWSSETL -> "rcwssetl"
  | Opcode.RCWSSETP -> "rcwssetp"
  | Opcode.RCWSSETPA -> "rcwssetpa"
  | Opcode.RCWSSETPAL -> "rcwssetpal"
  | Opcode.RCWSSETPL -> "rcwssetpl"
  | Opcode.RCWSSWP -> "rcwsswp"
  | Opcode.RCWSSWPA -> "rcwsswpa"
  | Opcode.RCWSSWPAL -> "rcwsswpal"
  | Opcode.RCWSSWPL -> "rcwsswpl"
  | Opcode.RCWSSWPP -> "rcwsswpp"
  | Opcode.RCWSSWPPA -> "rcwsswppa"
  | Opcode.RCWSSWPPAL -> "rcwsswppal"
  | Opcode.RCWSSWPPL -> "rcwsswppl"
  | Opcode.RCWSWP -> "rcwswp"
  | Opcode.RCWSWPA -> "rcwswpa"
  | Opcode.RCWSWPAL -> "rcwswpal"
  | Opcode.RCWSWPL -> "rcwswpl"
  | Opcode.RCWSWPP -> "rcwswpp"
  | Opcode.RCWSWPPA -> "rcwswppa"
  | Opcode.RCWSWPPAL -> "rcwswppal"
  | Opcode.RCWSWPPL -> "rcwswppl"
  | Opcode.RDFFR -> "rdffr"
  | Opcode.RDFFRS -> "rdffrs"
  | Opcode.RDSVL -> "rdsvl"
  | Opcode.RDVL -> "rdvl"
  | Opcode.RET -> "ret"
  | Opcode.RETAA -> "retaa"
  | Opcode.RETAB -> "retab"
  | Opcode.REV -> "rev"
  | Opcode.REV16 -> "rev16"
  | Opcode.REV32 -> "rev32"
  | Opcode.REV64 -> "rev64"
  | Opcode.REVB -> "revb"
  | Opcode.REVD -> "revd"
  | Opcode.REVH -> "revh"
  | Opcode.REVW -> "revw"
  | Opcode.RMIF -> "rmif"
  | Opcode.ROR -> "ror"
  | Opcode.RORV -> "rorv"
  | Opcode.RPRFM -> "rprfm"
  | Opcode.RSHRN -> "rshrn"
  | Opcode.RSHRN2 -> "rshrn2"
  | Opcode.RSHRNB -> "rshrnb"
  | Opcode.RSHRNT -> "rshrnt"
  | Opcode.RSUBHN -> "rsubhn"
  | Opcode.RSUBHN2 -> "rsubhn2"
  | Opcode.RSUBHNB -> "rsubhnb"
  | Opcode.RSUBHNT -> "rsubhnt"
  | Opcode.SABA -> "saba"
  | Opcode.SABAL -> "sabal"
  | Opcode.SABAL2 -> "sabal2"
  | Opcode.SABALB -> "sabalb"
  | Opcode.SABALT -> "sabalt"
  | Opcode.SABD -> "sabd"
  | Opcode.SABDL -> "sabdl"
  | Opcode.SABDL2 -> "sabdl2"
  | Opcode.SABDLB -> "sabdlb"
  | Opcode.SABDLT -> "sabdlt"
  | Opcode.SADALP -> "sadalp"
  | Opcode.SADDL -> "saddl"
  | Opcode.SADDL2 -> "saddl2"
  | Opcode.SADDLB -> "saddlb"
  | Opcode.SADDLBT -> "saddlbt"
  | Opcode.SADDLP -> "saddlp"
  | Opcode.SADDLT -> "saddlt"
  | Opcode.SADDLV -> "saddlv"
  | Opcode.SADDV -> "saddv"
  | Opcode.SADDW -> "saddw"
  | Opcode.SADDW2 -> "saddw2"
  | Opcode.SADDWB -> "saddwb"
  | Opcode.SADDWT -> "saddwt"
  | Opcode.SB -> "sb"
  | Opcode.SBC -> "sbc"
  | Opcode.SBCLB -> "sbclb"
  | Opcode.SBCLT -> "sbclt"
  | Opcode.SBCS -> "sbcs"
  | Opcode.SBFIZ -> "sbfiz"
  | Opcode.SBFM -> "sbfm"
  | Opcode.SBFX -> "sbfx"
  | Opcode.SCLAMP -> "sclamp"
  | Opcode.SCVTF -> "scvtf"
  | Opcode.SDIV -> "sdiv"
  | Opcode.SDIVR -> "sdivr"
  | Opcode.SDOT -> "sdot"
  | Opcode.SEL -> "sel"
  | Opcode.SETE -> "sete"
  | Opcode.SETEN -> "seten"
  | Opcode.SETET -> "setet"
  | Opcode.SETETN -> "setetn"
  | Opcode.SETF16 -> "setf16"
  | Opcode.SETF8 -> "setf8"
  | Opcode.SETFFR -> "setffr"
  | Opcode.SETGE -> "setge"
  | Opcode.SETGEN -> "setgen"
  | Opcode.SETGET -> "setget"
  | Opcode.SETGETN -> "setgetn"
  | Opcode.SETGM -> "setgm"
  | Opcode.SETGMN -> "setgmn"
  | Opcode.SETGMT -> "setgmt"
  | Opcode.SETGMTN -> "setgmtn"
  | Opcode.SETGP -> "setgp"
  | Opcode.SETGPN -> "setgpn"
  | Opcode.SETGPT -> "setgpt"
  | Opcode.SETGPTN -> "setgptn"
  | Opcode.SETM -> "setm"
  | Opcode.SETMN -> "setmn"
  | Opcode.SETMT -> "setmt"
  | Opcode.SETMTN -> "setmtn"
  | Opcode.SETP -> "setp"
  | Opcode.SETPN -> "setpn"
  | Opcode.SETPT -> "setpt"
  | Opcode.SETPTN -> "setptn"
  | Opcode.SEV -> "sev"
  | Opcode.SEVL -> "sevl"
  | Opcode.SHA1C -> "sha1c"
  | Opcode.SHA1H -> "sha1h"
  | Opcode.SHA1M -> "sha1m"
  | Opcode.SHA1P -> "sha1p"
  | Opcode.SHA1SU0 -> "sha1su0"
  | Opcode.SHA1SU1 -> "sha1su1"
  | Opcode.SHA256H -> "sha256h"
  | Opcode.SHA256H2 -> "sha256h2"
  | Opcode.SHA256SU0 -> "sha256su0"
  | Opcode.SHA256SU1 -> "sha256su1"
  | Opcode.SHA512H -> "sha512h"
  | Opcode.SHA512H2 -> "sha512h2"
  | Opcode.SHA512SU0 -> "sha512su0"
  | Opcode.SHA512SU1 -> "sha512su1"
  | Opcode.SHADD -> "shadd"
  | Opcode.SHL -> "shl"
  | Opcode.SHLL -> "shll"
  | Opcode.SHLL2 -> "shll2"
  | Opcode.SHRN -> "shrn"
  | Opcode.SHRN2 -> "shrn2"
  | Opcode.SHRNB -> "shrnb"
  | Opcode.SHRNT -> "shrnt"
  | Opcode.SHSUB -> "shsub"
  | Opcode.SHSUBR -> "shsubr"
  | Opcode.SLI -> "sli"
  | Opcode.SM3PARTW1 -> "sm3partw1"
  | Opcode.SM3PARTW2 -> "sm3partw2"
  | Opcode.SM3SS1 -> "sm3ss1"
  | Opcode.SM3TT1A -> "sm3tt1a"
  | Opcode.SM3TT1B -> "sm3tt1b"
  | Opcode.SM3TT2A -> "sm3tt2a"
  | Opcode.SM3TT2B -> "sm3tt2b"
  | Opcode.SM4E -> "sm4e"
  | Opcode.SM4EKEY -> "sm4ekey"
  | Opcode.SMADDL -> "smaddl"
  | Opcode.SMAX -> "smax"
  | Opcode.SMAXP -> "smaxp"
  | Opcode.SMAXQV -> "smaxqv"
  | Opcode.SMAXV -> "smaxv"
  | Opcode.SMC -> "smc"
  | Opcode.SMIN -> "smin"
  | Opcode.SMINP -> "sminp"
  | Opcode.SMINQV -> "sminqv"
  | Opcode.SMINV -> "sminv"
  | Opcode.SMLAL -> "smlal"
  | Opcode.SMLAL2 -> "smlal2"
  | Opcode.SMLALB -> "smlalb"
  | Opcode.SMLALL -> "smlall"
  | Opcode.SMLALT -> "smlalt"
  | Opcode.SMLSL -> "smlsl"
  | Opcode.SMLSL2 -> "smlsl2"
  | Opcode.SMLSLB -> "smlslb"
  | Opcode.SMLSLL -> "smlsll"
  | Opcode.SMLSLT -> "smlslt"
  | Opcode.SMMLA -> "smmla"
  | Opcode.SMNEGL -> "smnegl"
  | Opcode.SMOPA -> "smopa"
  | Opcode.SMOPS -> "smops"
  | Opcode.SMOV -> "smov"
  | Opcode.SMSTART -> "smstart"
  | Opcode.SMSTOP -> "smstop"
  | Opcode.SMSUBL -> "smsubl"
  | Opcode.SMULH -> "smulh"
  | Opcode.SMULL -> "smull"
  | Opcode.SMULL2 -> "smull2"
  | Opcode.SMULLB -> "smullb"
  | Opcode.SMULLT -> "smullt"
  | Opcode.SPLICE -> "splice"
  | Opcode.SQABS -> "sqabs"
  | Opcode.SQADD -> "sqadd"
  | Opcode.SQCADD -> "sqcadd"
  | Opcode.SQCVT -> "sqcvt"
  | Opcode.SQCVTN -> "sqcvtn"
  | Opcode.SQCVTU -> "sqcvtu"
  | Opcode.SQCVTUN -> "sqcvtun"
  | Opcode.SQDECB -> "sqdecb"
  | Opcode.SQDECD -> "sqdecd"
  | Opcode.SQDECH -> "sqdech"
  | Opcode.SQDECP -> "sqdecp"
  | Opcode.SQDECW -> "sqdecw"
  | Opcode.SQDMLAL -> "sqdmlal"
  | Opcode.SQDMLAL2 -> "sqdmlal2"
  | Opcode.SQDMLALB -> "sqdmlalb"
  | Opcode.SQDMLALBT -> "sqdmlalbt"
  | Opcode.SQDMLALT -> "sqdmlalt"
  | Opcode.SQDMLSL -> "sqdmlsl"
  | Opcode.SQDMLSL2 -> "sqdmlsl2"
  | Opcode.SQDMLSLB -> "sqdmlslb"
  | Opcode.SQDMLSLBT -> "sqdmlslbt"
  | Opcode.SQDMLSLT -> "sqdmlslt"
  | Opcode.SQDMULH -> "sqdmulh"
  | Opcode.SQDMULL -> "sqdmull"
  | Opcode.SQDMULL2 -> "sqdmull2"
  | Opcode.SQDMULLB -> "sqdmullb"
  | Opcode.SQDMULLT -> "sqdmullt"
  | Opcode.SQINCB -> "sqincb"
  | Opcode.SQINCD -> "sqincd"
  | Opcode.SQINCH -> "sqinch"
  | Opcode.SQINCP -> "sqincp"
  | Opcode.SQINCW -> "sqincw"
  | Opcode.SQNEG -> "sqneg"
  | Opcode.SQRDCMLAH -> "sqrdcmlah"
  | Opcode.SQRDMLAH -> "sqrdmlah"
  | Opcode.SQRDMLSH -> "sqrdmlsh"
  | Opcode.SQRDMULH -> "sqrdmulh"
  | Opcode.SQRSHL -> "sqrshl"
  | Opcode.SQRSHLR -> "sqrshlr"
  | Opcode.SQRSHR -> "sqrshr"
  | Opcode.SQRSHRN -> "sqrshrn"
  | Opcode.SQRSHRN2 -> "sqrshrn2"
  | Opcode.SQRSHRNB -> "sqrshrnb"
  | Opcode.SQRSHRNT -> "sqrshrnt"
  | Opcode.SQRSHRU -> "sqrshru"
  | Opcode.SQRSHRUN -> "sqrshrun"
  | Opcode.SQRSHRUN2 -> "sqrshrun2"
  | Opcode.SQRSHRUNB -> "sqrshrunb"
  | Opcode.SQRSHRUNT -> "sqrshrunt"
  | Opcode.SQSHL -> "sqshl"
  | Opcode.SQSHLR -> "sqshlr"
  | Opcode.SQSHLU -> "sqshlu"
  | Opcode.SQSHRN -> "sqshrn"
  | Opcode.SQSHRN2 -> "sqshrn2"
  | Opcode.SQSHRNB -> "sqshrnb"
  | Opcode.SQSHRNT -> "sqshrnt"
  | Opcode.SQSHRUN -> "sqshrun"
  | Opcode.SQSHRUN2 -> "sqshrun2"
  | Opcode.SQSHRUNB -> "sqshrunb"
  | Opcode.SQSHRUNT -> "sqshrunt"
  | Opcode.SQSUB -> "sqsub"
  | Opcode.SQSUBR -> "sqsubr"
  | Opcode.SQXTN -> "sqxtn"
  | Opcode.SQXTN2 -> "sqxtn2"
  | Opcode.SQXTNB -> "sqxtnb"
  | Opcode.SQXTNT -> "sqxtnt"
  | Opcode.SQXTUN -> "sqxtun"
  | Opcode.SQXTUN2 -> "sqxtun2"
  | Opcode.SQXTUNB -> "sqxtunb"
  | Opcode.SQXTUNT -> "sqxtunt"
  | Opcode.SRHADD -> "srhadd"
  | Opcode.SRI -> "sri"
  | Opcode.SRSHL -> "srshl"
  | Opcode.SRSHLR -> "srshlr"
  | Opcode.SRSHR -> "srshr"
  | Opcode.SRSRA -> "srsra"
  | Opcode.SSBB -> "ssbb"
  | Opcode.SSHL -> "sshl"
  | Opcode.SSHLL -> "sshll"
  | Opcode.SSHLL2 -> "sshll2"
  | Opcode.SSHLLB -> "sshllb"
  | Opcode.SSHLLT -> "sshllt"
  | Opcode.SSHR -> "sshr"
  | Opcode.SSRA -> "ssra"
  | Opcode.SSUBL -> "ssubl"
  | Opcode.SSUBL2 -> "ssubl2"
  | Opcode.SSUBLB -> "ssublb"
  | Opcode.SSUBLBT -> "ssublbt"
  | Opcode.SSUBLT -> "ssublt"
  | Opcode.SSUBLTB -> "ssubltb"
  | Opcode.SSUBW -> "ssubw"
  | Opcode.SSUBW2 -> "ssubw2"
  | Opcode.SSUBWB -> "ssubwb"
  | Opcode.SSUBWT -> "ssubwt"
  | Opcode.ST1 -> "st1"
  | Opcode.ST1B -> "st1b"
  | Opcode.ST1D -> "st1d"
  | Opcode.ST1H -> "st1h"
  | Opcode.ST1Q -> "st1q"
  | Opcode.ST1W -> "st1w"
  | Opcode.ST2 -> "st2"
  | Opcode.ST2B -> "st2b"
  | Opcode.ST2D -> "st2d"
  | Opcode.ST2G -> "st2g"
  | Opcode.ST2H -> "st2h"
  | Opcode.ST2Q -> "st2q"
  | Opcode.ST2W -> "st2w"
  | Opcode.ST3 -> "st3"
  | Opcode.ST3B -> "st3b"
  | Opcode.ST3D -> "st3d"
  | Opcode.ST3H -> "st3h"
  | Opcode.ST3Q -> "st3q"
  | Opcode.ST3W -> "st3w"
  | Opcode.ST4 -> "st4"
  | Opcode.ST4B -> "st4b"
  | Opcode.ST4D -> "st4d"
  | Opcode.ST4H -> "st4h"
  | Opcode.ST4Q -> "st4q"
  | Opcode.ST4W -> "st4w"
  | Opcode.ST64B -> "st64b"
  | Opcode.ST64BV -> "st64bv"
  | Opcode.ST64BV0 -> "st64bv0"
  | Opcode.STADD -> "stadd"
  | Opcode.STADDB -> "staddb"
  | Opcode.STADDH -> "staddh"
  | Opcode.STADDL -> "staddl"
  | Opcode.STADDLB -> "staddlb"
  | Opcode.STADDLH -> "staddlh"
  | Opcode.STCLR -> "stclr"
  | Opcode.STCLRB -> "stclrb"
  | Opcode.STCLRH -> "stclrh"
  | Opcode.STCLRL -> "stclrl"
  | Opcode.STCLRLB -> "stclrlb"
  | Opcode.STCLRLH -> "stclrlh"
  | Opcode.STEOR -> "steor"
  | Opcode.STEORB -> "steorb"
  | Opcode.STEORH -> "steorh"
  | Opcode.STEORL -> "steorl"
  | Opcode.STEORLB -> "steorlb"
  | Opcode.STEORLH -> "steorlh"
  | Opcode.STG -> "stg"
  | Opcode.STGM -> "stgm"
  | Opcode.STGP -> "stgp"
  | Opcode.STILP -> "stilp"
  | Opcode.STL1 -> "stl1"
  | Opcode.STLLR -> "stllr"
  | Opcode.STLLRB -> "stllrb"
  | Opcode.STLLRH -> "stllrh"
  | Opcode.STLR -> "stlr"
  | Opcode.STLRB -> "stlrb"
  | Opcode.STLRH -> "stlrh"
  | Opcode.STLUR -> "stlur"
  | Opcode.STLURB -> "stlurb"
  | Opcode.STLURH -> "stlurh"
  | Opcode.STLXP -> "stlxp"
  | Opcode.STLXR -> "stlxr"
  | Opcode.STLXRB -> "stlxrb"
  | Opcode.STLXRH -> "stlxrh"
  | Opcode.STNP -> "stnp"
  | Opcode.STNT1B -> "stnt1b"
  | Opcode.STNT1D -> "stnt1d"
  | Opcode.STNT1H -> "stnt1h"
  | Opcode.STNT1W -> "stnt1w"
  | Opcode.STP -> "stp"
  | Opcode.STR -> "str"
  | Opcode.STRB -> "strb"
  | Opcode.STRH -> "strh"
  | Opcode.STSET -> "stset"
  | Opcode.STSETB -> "stsetb"
  | Opcode.STSETH -> "stseth"
  | Opcode.STSETL -> "stsetl"
  | Opcode.STSETLB -> "stsetlb"
  | Opcode.STSETLH -> "stsetlh"
  | Opcode.STSMAX -> "stsmax"
  | Opcode.STSMAXB -> "stsmaxb"
  | Opcode.STSMAXH -> "stsmaxh"
  | Opcode.STSMAXL -> "stsmaxl"
  | Opcode.STSMAXLB -> "stsmaxlb"
  | Opcode.STSMAXLH -> "stsmaxlh"
  | Opcode.STSMIN -> "stsmin"
  | Opcode.STSMINB -> "stsminb"
  | Opcode.STSMINH -> "stsminh"
  | Opcode.STSMINL -> "stsminl"
  | Opcode.STSMINLB -> "stsminlb"
  | Opcode.STSMINLH -> "stsminlh"
  | Opcode.STTR -> "sttr"
  | Opcode.STTRB -> "sttrb"
  | Opcode.STTRH -> "sttrh"
  | Opcode.STUMAX -> "stumax"
  | Opcode.STUMAXB -> "stumaxb"
  | Opcode.STUMAXH -> "stumaxh"
  | Opcode.STUMAXL -> "stumaxl"
  | Opcode.STUMAXLB -> "stumaxlb"
  | Opcode.STUMAXLH -> "stumaxlh"
  | Opcode.STUMIN -> "stumin"
  | Opcode.STUMINB -> "stuminb"
  | Opcode.STUMINH -> "stuminh"
  | Opcode.STUMINL -> "stuminl"
  | Opcode.STUMINLB -> "stuminlb"
  | Opcode.STUMINLH -> "stuminlh"
  | Opcode.STUR -> "stur"
  | Opcode.STURB -> "sturb"
  | Opcode.STURH -> "sturh"
  | Opcode.STXP -> "stxp"
  | Opcode.STXR -> "stxr"
  | Opcode.STXRB -> "stxrb"
  | Opcode.STXRH -> "stxrh"
  | Opcode.STZ2G -> "stz2g"
  | Opcode.STZG -> "stzg"
  | Opcode.STZGM -> "stzgm"
  | Opcode.SUB -> "sub"
  | Opcode.SUBG -> "subg"
  | Opcode.SUBHN -> "subhn"
  | Opcode.SUBHN2 -> "subhn2"
  | Opcode.SUBHNB -> "subhnb"
  | Opcode.SUBHNT -> "subhnt"
  | Opcode.SUBP -> "subp"
  | Opcode.SUBPS -> "subps"
  | Opcode.SUBR -> "subr"
  | Opcode.SUBS -> "subs"
  | Opcode.SUDOT -> "sudot"
  | Opcode.SUMLALL -> "sumlall"
  | Opcode.SUMOPA -> "sumopa"
  | Opcode.SUMOPS -> "sumops"
  | Opcode.SUNPK -> "sunpk"
  | Opcode.SUNPKHI -> "sunpkhi"
  | Opcode.SUNPKLO -> "sunpklo"
  | Opcode.SUQADD -> "suqadd"
  | Opcode.SUVDOT -> "suvdot"
  | Opcode.SVC -> "svc"
  | Opcode.SVDOT -> "svdot"
  | Opcode.SWP -> "swp"
  | Opcode.SWPA -> "swpa"
  | Opcode.SWPAB -> "swpab"
  | Opcode.SWPAH -> "swpah"
  | Opcode.SWPAL -> "swpal"
  | Opcode.SWPALB -> "swpalb"
  | Opcode.SWPALH -> "swpalh"
  | Opcode.SWPB -> "swpb"
  | Opcode.SWPH -> "swph"
  | Opcode.SWPL -> "swpl"
  | Opcode.SWPLB -> "swplb"
  | Opcode.SWPLH -> "swplh"
  | Opcode.SWPP -> "swpp"
  | Opcode.SWPPA -> "swppa"
  | Opcode.SWPPAL -> "swppal"
  | Opcode.SWPPL -> "swppl"
  | Opcode.SXTB -> "sxtb"
  | Opcode.SXTH -> "sxth"
  | Opcode.SXTL -> "sxtl"
  | Opcode.SXTL2 -> "sxtl2"
  | Opcode.SXTW -> "sxtw"
  | Opcode.SYS -> "sys"
  | Opcode.SYSL -> "sysl"
  | Opcode.SYSP -> "sysp"
  | Opcode.TBL -> "tbl"
  | Opcode.TBLQ -> "tblq"
  | Opcode.TBNZ -> "tbnz"
  | Opcode.TBX -> "tbx"
  | Opcode.TBXQ -> "tbxq"
  | Opcode.TBZ -> "tbz"
  | Opcode.TCANCEL -> "tcancel"
  | Opcode.TCOMMIT -> "tcommit"
  | Opcode.TLBI -> "tlbi"
  | Opcode.TLBIP -> "tlbip"
  | Opcode.TRCIT -> "trcit"
  | Opcode.TRN1 -> "trn1"
  | Opcode.TRN2 -> "trn2"
  | Opcode.TSB -> "tsb"
  | Opcode.TST -> "tst"
  | Opcode.TSTART -> "tstart"
  | Opcode.TTEST -> "ttest"
  | Opcode.UABA -> "uaba"
  | Opcode.UABAL -> "uabal"
  | Opcode.UABAL2 -> "uabal2"
  | Opcode.UABALB -> "uabalb"
  | Opcode.UABALT -> "uabalt"
  | Opcode.UABD -> "uabd"
  | Opcode.UABDL -> "uabdl"
  | Opcode.UABDL2 -> "uabdl2"
  | Opcode.UABDLB -> "uabdlb"
  | Opcode.UABDLT -> "uabdlt"
  | Opcode.UADALP -> "uadalp"
  | Opcode.UADDL -> "uaddl"
  | Opcode.UADDL2 -> "uaddl2"
  | Opcode.UADDLB -> "uaddlb"
  | Opcode.UADDLP -> "uaddlp"
  | Opcode.UADDLT -> "uaddlt"
  | Opcode.UADDLV -> "uaddlv"
  | Opcode.UADDV -> "uaddv"
  | Opcode.UADDW -> "uaddw"
  | Opcode.UADDW2 -> "uaddw2"
  | Opcode.UADDWB -> "uaddwb"
  | Opcode.UADDWT -> "uaddwt"
  | Opcode.UBFIZ -> "ubfiz"
  | Opcode.UBFM -> "ubfm"
  | Opcode.UBFX -> "ubfx"
  | Opcode.UCLAMP -> "uclamp"
  | Opcode.UCVTF -> "ucvtf"
  | Opcode.UDF -> "udf"
  | Opcode.UDIV -> "udiv"
  | Opcode.UDIVR -> "udivr"
  | Opcode.UDOT -> "udot"
  | Opcode.UHADD -> "uhadd"
  | Opcode.UHSUB -> "uhsub"
  | Opcode.UHSUBR -> "uhsubr"
  | Opcode.UMADDL -> "umaddl"
  | Opcode.UMAX -> "umax"
  | Opcode.UMAXP -> "umaxp"
  | Opcode.UMAXQV -> "umaxqv"
  | Opcode.UMAXV -> "umaxv"
  | Opcode.UMIN -> "umin"
  | Opcode.UMINP -> "uminp"
  | Opcode.UMINQV -> "uminqv"
  | Opcode.UMINV -> "uminv"
  | Opcode.UMLAL -> "umlal"
  | Opcode.UMLAL2 -> "umlal2"
  | Opcode.UMLALB -> "umlalb"
  | Opcode.UMLALL -> "umlall"
  | Opcode.UMLALT -> "umlalt"
  | Opcode.UMLSL -> "umlsl"
  | Opcode.UMLSL2 -> "umlsl2"
  | Opcode.UMLSLB -> "umlslb"
  | Opcode.UMLSLL -> "umlsll"
  | Opcode.UMLSLT -> "umlslt"
  | Opcode.UMMLA -> "ummla"
  | Opcode.UMNEGL -> "umnegl"
  | Opcode.UMOPA -> "umopa"
  | Opcode.UMOPS -> "umops"
  | Opcode.UMOV -> "umov"
  | Opcode.UMSUBL -> "umsubl"
  | Opcode.UMULH -> "umulh"
  | Opcode.UMULL -> "umull"
  | Opcode.UMULL2 -> "umull2"
  | Opcode.UMULLB -> "umullb"
  | Opcode.UMULLT -> "umullt"
  | Opcode.UQADD -> "uqadd"
  | Opcode.UQCVT -> "uqcvt"
  | Opcode.UQCVTN -> "uqcvtn"
  | Opcode.UQDECB -> "uqdecb"
  | Opcode.UQDECD -> "uqdecd"
  | Opcode.UQDECH -> "uqdech"
  | Opcode.UQDECP -> "uqdecp"
  | Opcode.UQDECW -> "uqdecw"
  | Opcode.UQINCB -> "uqincb"
  | Opcode.UQINCD -> "uqincd"
  | Opcode.UQINCH -> "uqinch"
  | Opcode.UQINCP -> "uqincp"
  | Opcode.UQINCW -> "uqincw"
  | Opcode.UQRSHL -> "uqrshl"
  | Opcode.UQRSHLR -> "uqrshlr"
  | Opcode.UQRSHR -> "uqrshr"
  | Opcode.UQRSHRN -> "uqrshrn"
  | Opcode.UQRSHRN2 -> "uqrshrn2"
  | Opcode.UQRSHRNB -> "uqrshrnb"
  | Opcode.UQRSHRNT -> "uqrshrnt"
  | Opcode.UQSHL -> "uqshl"
  | Opcode.UQSHLR -> "uqshlr"
  | Opcode.UQSHRN -> "uqshrn"
  | Opcode.UQSHRN2 -> "uqshrn2"
  | Opcode.UQSHRNB -> "uqshrnb"
  | Opcode.UQSHRNT -> "uqshrnt"
  | Opcode.UQSUB -> "uqsub"
  | Opcode.UQSUBR -> "uqsubr"
  | Opcode.UQXTN -> "uqxtn"
  | Opcode.UQXTN2 -> "uqxtn2"
  | Opcode.UQXTNB -> "uqxtnb"
  | Opcode.UQXTNT -> "uqxtnt"
  | Opcode.URECPE -> "urecpe"
  | Opcode.URHADD -> "urhadd"
  | Opcode.URSHL -> "urshl"
  | Opcode.URSHLR -> "urshlr"
  | Opcode.URSHR -> "urshr"
  | Opcode.URSQRTE -> "ursqrte"
  | Opcode.URSRA -> "ursra"
  | Opcode.USDOT -> "usdot"
  | Opcode.USHL -> "ushl"
  | Opcode.USHLL -> "ushll"
  | Opcode.USHLL2 -> "ushll2"
  | Opcode.USHLLB -> "ushllb"
  | Opcode.USHLLT -> "ushllt"
  | Opcode.USHR -> "ushr"
  | Opcode.USMLALL -> "usmlall"
  | Opcode.USMMLA -> "usmmla"
  | Opcode.USMOPA -> "usmopa"
  | Opcode.USMOPS -> "usmops"
  | Opcode.USQADD -> "usqadd"
  | Opcode.USRA -> "usra"
  | Opcode.USUBL -> "usubl"
  | Opcode.USUBL2 -> "usubl2"
  | Opcode.USUBLB -> "usublb"
  | Opcode.USUBLT -> "usublt"
  | Opcode.USUBW -> "usubw"
  | Opcode.USUBW2 -> "usubw2"
  | Opcode.USUBWB -> "usubwb"
  | Opcode.USUBWT -> "usubwt"
  | Opcode.USVDOT -> "usvdot"
  | Opcode.UUNPK -> "uunpk"
  | Opcode.UUNPKHI -> "uunpkhi"
  | Opcode.UUNPKLO -> "uunpklo"
  | Opcode.UVDOT -> "uvdot"
  | Opcode.UXTB -> "uxtb"
  | Opcode.UXTH -> "uxth"
  | Opcode.UXTL -> "uxtl"
  | Opcode.UXTL2 -> "uxtl2"
  | Opcode.UXTW -> "uxtw"
  | Opcode.UZP -> "uzp"
  | Opcode.UZP1 -> "uzp1"
  | Opcode.UZP2 -> "uzp2"
  | Opcode.UZPQ1 -> "uzpq1"
  | Opcode.UZPQ2 -> "uzpq2"
  | Opcode.WFE -> "wfe"
  | Opcode.WFET -> "wfet"
  | Opcode.WFI -> "wfi"
  | Opcode.WFIT -> "wfit"
  | Opcode.WHILEGE -> "whilege"
  | Opcode.WHILEGT -> "whilegt"
  | Opcode.WHILEHI -> "whilehi"
  | Opcode.WHILEHS -> "whilehs"
  | Opcode.WHILELE -> "whilele"
  | Opcode.WHILELO -> "whilelo"
  | Opcode.WHILELS -> "whilels"
  | Opcode.WHILELT -> "whilelt"
  | Opcode.WHILERW -> "whilerw"
  | Opcode.WHILEWR -> "whilewr"
  | Opcode.WRFFR -> "wrffr"
  | Opcode.XAFLAG -> "xaflag"
  | Opcode.XAR -> "xar"
  | Opcode.XPACD -> "xpacd"
  | Opcode.XPACI -> "xpaci"
  | Opcode.XPACLRI -> "xpaclri"
  | Opcode.XTN -> "xtn"
  | Opcode.XTN2 -> "xtn2"
  | Opcode.YIELD -> "yield"
  | Opcode.ZERO -> "zero"
  | Opcode.ZIP -> "zip"
  | Opcode.ZIP1 -> "zip1"
  | Opcode.ZIP2 -> "zip2"
  | Opcode.ZIPQ1 -> "zipq1"
  | Opcode.ZIPQ2 -> "zipq2"
  | _ -> failwith "Unknown opcode encountered."

let srtypeToString = function
  | SRTypeLSL -> "lsl"
  | SRTypeLSR -> "lsr"
  | SRTypeASR -> "asr"
  | SRTypeROR -> "ror"
  | SRTypeRRX -> "rrx"
  | SRTypeMSL -> "msl"

let simdVectorToString = function
  | VecB -> "b"
  | VecH -> "h"
  | VecS -> "s"
  | VecD -> "d"
  | EightB -> "8b"
  | SixteenB -> "16b"
  | FourH -> "4h"
  | EightH -> "8h"
  | TwoS -> "2s"
  | FourS -> "4s"
  | OneD -> "1d"
  | TwoD -> "2d"
  | OneQ -> "1q"

let simdFPRegToString simdOpr (builder: DisasmBuilder) =
  match simdOpr with
  | SIMDFPScalarReg sReg ->
    builder.Accumulate AsmWordKind.Variable (Register.toString sReg)
  | SIMDVecReg (reg, vec) ->
    builder.Accumulate AsmWordKind.Variable (Register.toString reg)
    builder.Accumulate AsmWordKind.String ("." + simdVectorToString vec)
  | SIMDVecRegWithIdx (reg, vec, _) ->
    builder.Accumulate AsmWordKind.Variable (Register.toString reg)
    builder.Accumulate AsmWordKind.String ("." + simdVectorToString vec)

let finalOprSIMD s (builder: DisasmBuilder) =
  match s with
  | SIMDVecRegWithIdx (_, _, idx) ->
    builder.Accumulate AsmWordKind.String "["
    builder.Accumulate AsmWordKind.String (string idx)
    builder.Accumulate AsmWordKind.String "]"
  | _ -> ()

(* SIMD & FP register *)
let simdToString simd builder =
  simdFPRegToString simd builder
  finalOprSIMD simd builder

(* SIMD vector register list or SIMD vector element list *)
let simdListToString simd (builder: DisasmBuilder) =
  match simd with
  | [ s ] ->
    builder.Accumulate AsmWordKind.String "{ "
    simdFPRegToString s builder
    builder.Accumulate AsmWordKind.String " }"
    finalOprSIMD s builder
  | [ s1; s2 ] ->
    builder.Accumulate AsmWordKind.String "{ "
    simdFPRegToString s1 builder
    builder.Accumulate AsmWordKind.String ", "
    simdFPRegToString s2 builder
    builder.Accumulate AsmWordKind.String " }"
    finalOprSIMD s1 builder
  | [ s1; s2; s3] ->
    builder.Accumulate AsmWordKind.String "{ "
    simdFPRegToString s1 builder
    builder.Accumulate AsmWordKind.String ", "
    simdFPRegToString s2 builder
    builder.Accumulate AsmWordKind.String ", "
    simdFPRegToString s3 builder
    builder.Accumulate AsmWordKind.String " }"
    finalOprSIMD s1 builder
  | [ s1; _; _; s4 ] ->
    builder.Accumulate AsmWordKind.String "{ "
    simdFPRegToString s1 builder
    builder.Accumulate AsmWordKind.String " - "
    simdFPRegToString s4 builder
    builder.Accumulate AsmWordKind.String " }"
    finalOprSIMD s1 builder
  | _ -> ()

let immToString imm (builder: DisasmBuilder) =
  builder.Accumulate AsmWordKind.String "#"
  builder.Accumulate AsmWordKind.String (HexString.ofInt64 imm)

let fpImmToString (fp: float) (builder: DisasmBuilder) =
  builder.Accumulate AsmWordKind.String "#"
  builder.Accumulate AsmWordKind.String (fp.ToString ("N8"))

let nzcvToString (imm: uint8) (builder: DisasmBuilder) =
  builder.Accumulate AsmWordKind.String "#"
  builder.Accumulate AsmWordKind.String ("0x" + imm.ToString "x")

let amountToString amount builder =
  match amount with
  | Imm i -> immToString i builder
  | Reg r -> builder.Accumulate AsmWordKind.Variable (Register.toString r)

let prependDelimiter delimiter (builder: DisasmBuilder) =
  match delimiter with
  | None -> ()
  | Some delim -> builder.Accumulate AsmWordKind.String delim

let shiftToString shift delim builder =
  match shift with
  | _, Imm 0L -> ()
  | s, amount ->
    prependDelimiter delim builder
    builder.Accumulate AsmWordKind.String (srtypeToString s)
    builder.Accumulate AsmWordKind.String " "
    amountToString amount builder

let extToString = function
  | ExtUXTB -> "uxtb"
  | ExtUXTH -> "uxth"
  | ExtUXTW -> "uxtw"
  | ExtUXTX -> "uxtx"
  | ExtSXTB -> "sxtb"
  | ExtSXTH -> "sxth"
  | ExtSXTW -> "sxtw"
  | ExtSXTX -> "sxtx"

let extRegToString regOff delim builder =
  match regOff with
  | (ext, None)
  | (ext, Some 0L) ->
    prependDelimiter delim builder
    builder.Accumulate AsmWordKind.String (extToString ext)
  | (ext, Some i) ->
    prependDelimiter delim builder
    builder.Accumulate AsmWordKind.String (extToString ext)
    builder.Accumulate AsmWordKind.String " #"
    builder.Accumulate AsmWordKind.Value (i.ToString ("x"))

let regOffString regOff delim builder =
  match regOff with
  | ShiftOffset regOff -> shiftToString regOff delim builder
  | ExtRegOffset regOff -> extRegToString regOff delim builder

let delimPostIdx = function
  | PostIdxMode _ -> "], "
  | _ -> ", "

let processAddrExn64 ins addr =
  match ins.Opcode with
  | Opcode.ADRP -> addr &&& 0xFFFFFFFFFFFFF000UL
  | _ -> addr

let immOffsetToString i addr mode offset (builder: DisasmBuilder) =
  match offset with
  | BaseOffset (reg, None) | BaseOffset (reg, Some 0L) ->
    builder.Accumulate AsmWordKind.Variable (Register.toString reg)
  | BaseOffset (reg, Some imm) ->
    builder.Accumulate AsmWordKind.Variable (Register.toString reg)
    builder.Accumulate AsmWordKind.String (delimPostIdx mode)
    immToString imm builder
  | Lbl imm ->
    let addr = processAddrExn64 i addr
    builder.Accumulate AsmWordKind.Value (HexString.ofInt64 (int64 addr + imm))

let regOffsetToString mode offset (builder: DisasmBuilder) =
  match offset with
  | r1, r2, Some regOff ->
    builder.Accumulate AsmWordKind.Variable (Register.toString r1)
    builder.Accumulate AsmWordKind.String ", "
    builder.Accumulate AsmWordKind.Variable (Register.toString r2)
    regOffString regOff (Some ", ") builder
  | r1, r2, None ->
    builder.Accumulate AsmWordKind.Variable (Register.toString r1)
    builder.Accumulate AsmWordKind.String (delimPostIdx mode)
    builder.Accumulate AsmWordKind.Variable (Register.toString r2)

let postBracket mode (builder: DisasmBuilder) =
  match mode with
  | BaseMode _ -> builder.Accumulate AsmWordKind.String "]"
  | PreIdxMode _ -> builder.Accumulate AsmWordKind.String "]!"
  | _ -> ()

let offsetToString i addr mode offset builder =
  match offset with
  | ImmOffset offset ->
    immOffsetToString i addr mode offset builder
    postBracket mode builder
  | RegOffset (r1, r2, offset) ->
    regOffsetToString mode (r1, r2, offset) builder
    postBracket mode builder

let memToString insInfo addr mode builder =
  match mode with
  | LiteralMode offset ->
    offsetToString insInfo addr mode offset builder
  | BaseMode off | PreIdxMode off | PostIdxMode off ->
    builder.Accumulate AsmWordKind.String "["
    offsetToString insInfo addr mode off builder

let optToString = function
  | SY -> "sy"
  | ST -> "st"
  | LD -> "ld"
  | ISH -> "ish"
  | ISHST -> "ishst"
  | ISHLD -> "ishld"
  | NSH -> "nsh"
  | NSHST -> "nshst"
  | NSHLD -> "nshld"
  | OSH -> "osh"
  | OSHST -> "oshst"
  | OSHLD -> "oshld"

let pStToString = function
  | SPSEL -> "spsel"
  | DAIFSET -> "daifset"
  | DAIFCLR -> "daifclr"

let prfOpToString = function
  | PLDL1KEEP -> "pldl1keep"
  | PLDL1STRM -> "pldl1strm"
  | PLDL2KEEP -> "pldl2keep"
  | PLDL2STRM -> "pldl2strm"
  | PLDL3KEEP -> "pldl3keep"
  | PLDL3STRM -> "pldl3strm"
  | PSTL1KEEP -> "pstl1keep"
  | PSTL1STRM -> "pstl1strm"
  | PSTL2KEEP -> "pstl2keep"
  | PSTL2STRM -> "pstl2strm"
  | PSTL3KEEP -> "pstl3keep"
  | PSTL3STRM -> "pstl3strm"
  | PLIL1KEEP -> "plil1keep"
  | PLIL1STRM -> "plil1strm"
  | PLIL2KEEP -> "plil2keep"
  | PLIL2STRM -> "plil2strm"
  | PLIL3KEEP -> "plil3keep"
  | PLIL3STRM -> "plil3strm"

let fBitsToString = function
  | f -> "#" + string f

let idxToString = function
  | i -> string i

let lsbToString = function
  | l -> "#" + string l

let isRET ins = ins.Opcode = Opcode.RET

let oprToString i addr opr delim builder =
  match opr with
  | OprRegister reg when isRET i && reg = R.X30 -> ()
  | OprRegister reg ->
    prependDelimiter delim builder
    builder.Accumulate AsmWordKind.Variable (Register.toString reg)
  | OprSIMD simd ->
    prependDelimiter delim builder
    simdToString simd builder
  | OprSIMDList simds ->
    prependDelimiter delim builder
    simdListToString simds builder
  | OprImm imm ->
    prependDelimiter delim builder
    immToString imm builder
  | OprFPImm fp ->
    prependDelimiter delim builder
    fpImmToString fp builder
  | OprNZCV ui8 ->
    prependDelimiter delim builder
    nzcvToString ui8 builder
  | OprShift s -> shiftToString s delim builder
  | OprExtReg None -> ()
  | OprExtReg (Some regOffset) -> regOffString regOffset delim builder
  | OprMemory mode ->
    prependDelimiter delim builder
    memToString i addr mode builder
  | OprOption opt ->
    prependDelimiter delim builder
    builder.Accumulate AsmWordKind.Variable (optToString opt)
  | OprPstate p ->
    prependDelimiter delim builder
    builder.Accumulate AsmWordKind.Variable (pStToString p)
  | OprPrfOp e1 ->
    prependDelimiter delim builder
    builder.Accumulate AsmWordKind.Variable (prfOpToString e1)
  | OprCond c ->
    prependDelimiter delim builder
    builder.Accumulate AsmWordKind.Variable (condToString (Some c))
  | OprFbits ui8 ->
    prependDelimiter delim builder
    builder.Accumulate AsmWordKind.Variable (fBitsToString ui8)
  | OprLSB ui8 ->
    prependDelimiter delim builder
    builder.Accumulate AsmWordKind.Variable (lsbToString ui8)

let inline buildOpcode ins (builder: DisasmBuilder) =
  let opcode = opCodeToString ins.Opcode + condToString ins.Condition
  builder.Accumulate AsmWordKind.Mnemonic opcode

let buildOprs insInfo pc builder =
  match insInfo.Operands with
  | NoOperand -> ()
  | OneOperand opr ->
    oprToString insInfo pc opr (Some " ") builder
  | TwoOperands (opr1, opr2) ->
    oprToString insInfo pc opr1 (Some " ") builder
    oprToString insInfo pc opr2 (Some ", ") builder
  | ThreeOperands (opr1, opr2, opr3) ->
    oprToString insInfo pc opr1 (Some " ") builder
    oprToString insInfo pc opr2 (Some ", ") builder
    oprToString insInfo pc opr3 (Some ", ") builder
  | FourOperands (opr1, opr2, opr3, opr4) ->
    oprToString insInfo pc opr1 (Some " ") builder
    oprToString insInfo pc opr2 (Some ", ") builder
    oprToString insInfo pc opr3 (Some ", ") builder
    oprToString insInfo pc opr4 (Some ", ") builder
  | FiveOperands (opr1, opr2, opr3, opr4, opr5) ->
    oprToString insInfo pc opr1 (Some " ") builder
    oprToString insInfo pc opr2 (Some ", ") builder
    oprToString insInfo pc opr3 (Some ", ") builder
    oprToString insInfo pc opr4 (Some ", ") builder
    oprToString insInfo pc opr5 (Some ", ") builder

let disasm ins (builder: DisasmBuilder) =
  let pc = ins.Address
  if builder.ShowAddr then builder.AccumulateAddr () else ()
  buildOpcode ins builder
  buildOprs ins pc builder
