(*
  B2R2 - the Next-Generation Reversing Platform

  Copyright (c) SoftSec Lab. @ KAIST, since 2016

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all
  copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*)

namespace B2R2

/// Raised when unhandled syscall is encountered.
exception UnhandledSyscallException

/// Linux syscall type.
type LinuxSyscall =
  | Accept = 0
  | Accept4 = 1
  | Access = 2
  | Acct = 3
  | AddKey = 4
  | AdjTimex = 5
  | Alarm = 6
  | AllocHugePages = 7
  | ArcGetTLS = 8
  | ArchPrctl = 9
  | ArcSetTLS = 10
  | ArcUsrCmpxchg = 11
  | ArmFadvise64 = 12
  | ArmSyncFileRange = 13
  | AtomicBarrier = 14
  | AtomicCmpxchg32 = 15
  | Bdflush = 16
  | BfinSpinlock = 17
  | Bind = 18
  | Bpf = 19
  | Breakpoint = 20
  | Brk = 21
  | CacheCtl = 22
  | CacheFlush = 23
  | CapGet = 24
  | CapSet = 25
  | Chdir = 26
  | Chmod = 27
  | Chown = 28
  | Chown32 = 29
  | Chroot = 30
  | ClockAdjtime = 31
  | ClockAdjtime64 = 32
  | ClockGetres = 33
  | ClockGetres64 = 34
  | ClockGettime = 35
  | ClockGettime64 = 36
  | ClockNanosleep = 37
  | ClockNanosleep64 = 38
  | ClockSettime = 39
  | ClockSettime64 = 40
  | Clone = 41
  | Clone2 = 42
  | Clone3 = 43
  | Close = 44
  | CloseRange = 45
  | CmpxchgBadaddr = 46
  | Connect = 47
  | CopyFileRange = 48
  | Creat = 49
  | CreateModule = 50
  | DeleteModule = 51
  | DmaMemcpy = 52
  | Dup = 53
  | Dup2 = 54
  | Dup3 = 55
  | EpollCreate = 56
  | EpollCreate1 = 57
  | EpollCtl = 58
  | EpollPwait = 59
  | EpollWait = 60
  | Eventfd = 61
  | Eventfd2 = 62
  | Execv = 63
  | Execve = 64
  | Execveat = 65
  | Exit = 66
  | ExitGroup = 67
  | Faccessat = 68
  | Faccessat2 = 69
  | Fadvise64 = 70
  | Fadvise64_64 = 71
  | Fallocate = 72
  | FanotifyInit = 73
  | FanotifyMark = 74
  | Fchdir = 75
  | Fchmod = 76
  | Fchmodat = 77
  | Fchown = 78
  | Fchown32 = 79
  | Fchownat = 80
  | Fcntl = 81
  | Fcntl64 = 82
  | Fdatasync = 83
  | Fgetxattr = 84
  | FinitModule = 85
  | Flistxattr = 86
  | Flock = 87
  | Fork = 88
  | FreeHugepages = 89
  | Fremovexattr = 90
  | Fsconfig = 91
  | Fsetxattr = 92
  | Fsmount = 93
  | Fsopen = 94
  | Fspick = 95
  | Fstat = 96
  | Fstat64 = 97
  | Fstatat64 = 98
  | Fstatfs = 99
  | Fstatfs64 = 100
  | Fsync = 101
  | Ftruncate = 102
  | Ftruncate64 = 103
  | Futex = 104
  | Futex64 = 105
  | Futimesat = 106
  | Getcpu = 107
  | Getcwd = 108
  | Getdents = 109
  | Getdents64 = 110
  | Getdomainname = 111
  | Getdtablesize = 112
  | Getegid = 113
  | Getegid32 = 114
  | Geteuid = 115
  | Geteuid32 = 116
  | Getgid = 117
  | Getgid32 = 118
  | Getgroups = 119
  | Getgroups32 = 120
  | Gethostname = 121
  | Getitimer = 122
  | GetKernelSyms = 123
  | GetMempolicy = 124
  | Getpagesize = 125
  | Getpeername = 126
  | Getpgid = 127
  | Getpgrp = 128
  | Getpid = 129
  | Getppid = 130
  | Getpriority = 131
  | Getrandom = 132
  | Getresgid = 133
  | Getresgid32 = 134
  | Getresuid = 135
  | Getresuid32 = 136
  | Getrlimit = 137
  | GetRobustList = 138
  | Getrusage = 139
  | Getsid = 140
  | Getsockname = 141
  | Getsockopt = 142
  | GetThreadArea = 143
  | Gettid = 144
  | Gettimeofday = 145
  | GetTLS = 146
  | Getuid = 147
  | Getuid32 = 148
  | Getunwind = 149
  | Getxattr = 150
  | Getxgid = 151
  | Getxpid = 152
  | Getxuid = 153
  | InitModule = 154
  | InotifyAddWatch = 155
  | InotifyInit = 156
  | InotifyInit1 = 157
  | InotifyRmWatch = 158
  | IoCancel = 159
  | Ioctl = 160
  | IoDestroy = 161
  | IoGetevents = 162
  | Ioperm = 163
  | IoPgetevents = 164
  | IoPgetevents64 = 165
  | Iopl = 166
  | IoprioGet = 167
  | IoprioSet = 168
  | IoSetup = 169
  | IoSubmit = 170
  | IoUringEnter = 171
  | IoUringRegister = 172
  | IoUringSetup = 173
  | Ipc = 174
  | Kcmp = 175
  | KernFeatures = 176
  | KexecFileLoad = 177
  | KexecLoad = 178
  | Keyctl = 179
  | Kill = 180
  | Lchown = 181
  | Lchown32 = 182
  | Lgetxattr = 183
  | Link = 184
  | Linkat = 185
  | Listen = 186
  | Listxattr = 187
  | Llistxattr = 188
  | LLseek = 189
  | LookupDcookie = 190
  | Lremovexattr = 191
  | Lseek = 192
  | Lsetxattr = 193
  | Lstat = 194
  | Lstat64 = 195
  | Madvise = 196
  | Mbind = 197
  | Membarrier = 198
  | MemfdCreate = 199
  | MemoryOrdering = 200
  | MetagGetTLS = 201
  | MetagSetFpuFlags = 202
  | MetagSetglobalbit = 203
  | MetagSetTLS = 204
  | MigratePages = 205
  | Mincore = 206
  | Mkdir = 207
  | Mkdirat = 208
  | Mknod = 209
  | Mknodat = 210
  | Mlock = 211
  | Mlock2 = 212
  | Mlockall = 213
  | Mmap = 214
  | Mmap2 = 215
  | ModifyLdt = 216
  | Mount = 217
  | MoveMount = 218
  | MovePages = 219
  | Mprotect = 220
  | MqGetsetattr = 221
  | MqNotify = 222
  | MqOpen = 223
  | MqTimedreceive = 224
  | MqTimedreceive64 = 225
  | MqTimedsend = 226
  | MqTimedsend64 = 227
  | MqUnlink = 228
  | Mremap = 229
  | Msgctl = 230
  | Msgget = 231
  | Msgrcv = 232
  | Msgsnd = 233
  | Msync = 234
  | Munlock = 235
  | Munlockall = 236
  | Munmap = 237
  | NameToHandleAt = 238
  | Nanosleep = 239
  | Newfstatat = 240
  | NewSelect = 241
  | Nfsservctl = 242
  | Nice = 243
  | OldAdjtimex = 244
  | Oldfstat = 245
  | OldGetrlimit = 246
  | Oldlstat = 247
  | Oldolduname = 248
  | Oldstat = 249
  | Oldumount = 250
  | Olduname = 251
  | Open = 252
  | Openat = 253
  | Openat2 = 254
  | OpenByHandleAt = 255
  | OpenTree = 256
  | Or1kAtomic = 257
  | Pause = 258
  | PciconfigIobase = 259
  | PciconfigRead = 260
  | PciconfigWrite = 261
  | Perfctr = 262
  | PerfEventOpen = 263
  | Perfmonctl = 264
  | Personality = 265
  | PidfdGetfd = 266
  | PidfdOpen = 267
  | PidfdSendSignal = 268
  | Pipe = 269
  | Pipe2 = 270
  | PivotRoot = 271
  | PkeyAlloc = 272
  | PkeyFree = 273
  | PkeyMprotect = 274
  | Poll = 275
  | Ppoll = 276
  | Ppoll64 = 277
  | Prctl = 278
  | Pread = 279
  | Pread64 = 280
  | Preadv = 281
  | Preadv2 = 282
  | Prlimit64 = 283
  | ProcessVmReadv = 284
  | ProcessVmWritev = 285
  | Pselect6 = 286
  | Pselect6_64 = 287
  | Ptrace = 288
  | Pwrite = 289
  | Pwrite64 = 290
  | Pwritev = 291
  | Pwritev2 = 292
  | QueryModule = 293
  | Quotactl = 294
  | Read = 295
  | Readahead = 296
  | Readdir = 297
  | Readlink = 298
  | Readlinkat = 299
  | Readv = 300
  | Reboot = 301
  | Recv = 302
  | Recvfrom = 303
  | Recvmmsg = 304
  | Recvmmsg64 = 305
  | Recvmsg = 306
  | RemapFilePages = 307
  | Removexattr = 308
  | Rename = 309
  | Renameat = 310
  | Renameat2 = 311
  | RequestKey = 312
  | RestartSyscall = 313
  | RiscvFlushIcache = 314
  | Rmdir = 315
  | Rseq = 316
  | Rtas = 317
  | RtSigaction = 318
  | RtSigpending = 319
  | RtSigprocmask = 320
  | RtSigqueueinfo = 321
  | RtSigreturn = 322
  | RtSigsuspend = 323
  | RtSigtimedwait = 324
  | RtSigtimedwait64 = 325
  | RtTgsigqueueinfo = 326
  | S390GuardedStorage = 327
  | S390PciMmioRead = 328
  | S390PciMmioWrite = 329
  | S390RuntimeInstr = 330
  | S390Sthyi = 331
  | SchedGetaffinity = 332
  | SchedGetAffinity = 333
  | SchedGetattr = 334
  | SchedGetparam = 335
  | SchedGetPriorityMax = 336
  | SchedGetPriorityMin = 337
  | SchedGetscheduler = 338
  | SchedRrGetInterval = 339
  | SchedRrGetInterval64 = 340
  | SchedSetaffinity = 341
  | SchedSetAffinity = 342
  | SchedSetattr = 343
  | SchedSetparam = 344
  | SchedSetscheduler = 345
  | SchedYield = 346
  | Seccomp = 347
  | Select = 348
  | Semctl = 349
  | Semget = 350
  | Semop = 351
  | Semtimedop = 352
  | Semtimedop64 = 353
  | Send = 354
  | Sendfile = 355
  | Sendfile64 = 356
  | Sendmmsg = 357
  | Sendmsg = 358
  | Sendto = 359
  | Setdomainname = 360
  | Setfsgid = 361
  | Setfsgid32 = 362
  | Setfsuid = 363
  | Setfsuid32 = 364
  | Setgid = 365
  | Setgid32 = 366
  | Setgroups = 367
  | Setgroups32 = 368
  | Sethae = 369
  | Sethostname = 370
  | Setitimer = 371
  | SetMempolicy = 372
  | Setns = 373
  | Setpgid = 374
  | Setpgrp = 375
  | Setpriority = 376
  | Setregid = 377
  | Setregid32 = 378
  | Setresgid = 379
  | Setresgid32 = 380
  | Setresuid = 381
  | Setresuid32 = 382
  | Setreuid = 383
  | Setreuid32 = 384
  | Setrlimit = 385
  | SetRobustList = 386
  | Setsid = 387
  | Setsockopt = 388
  | SetThreadArea = 389
  | SetTidAddress = 390
  | Settimeofday = 391
  | SetTLS = 392
  | Setuid = 393
  | Setuid32 = 394
  | Setup = 395
  | Setxattr = 396
  | Sgetmask = 397
  | Shmat = 398
  | Shmctl = 399
  | Shmdt = 400
  | Shmget = 401
  | Shutdown = 402
  | Sigaction = 403
  | Sigaltstack = 404
  | Signal = 405
  | Signalfd = 406
  | Signalfd4 = 407
  | Sigpending = 408
  | Sigprocmask = 409
  | Sigreturn = 410
  | Sigsuspend = 411
  | Socket = 412
  | Socketcall = 413
  | Socketpair = 414
  | Spill = 415
  | Splice = 416
  | SpuCreate = 417
  | SpuRun = 418
  | SramAlloc = 419
  | SramFree = 420
  | Ssetmask = 421
  | Stat = 422
  | Stat64 = 423
  | Statfs = 424
  | Statfs64 = 425
  | Statx = 426
  | Stime = 427
  | SubpageProt = 428
  | Swapcontext = 429
  | Swapoff = 430
  | Swapon = 431
  | SwitchEndian = 432
  | Symlink = 433
  | Symlinkat = 434
  | Sync = 435
  | SyncFileRange = 436
  | SyncFileRange2 = 437
  | Syncfs = 438
  | Syscall = 439
  | Sysctl = 440
  | SysDebugSetcontext = 441
  | Sysfs = 442
  | Sysinfo = 443
  | Syslog = 444
  | Sysmips = 445
  | Tee = 446
  | Tgkill = 447
  | Time = 448
  | TimerCreate = 449
  | TimerDelete = 450
  | Timerfd = 451
  | TimerfdCreate = 452
  | TimerfdGettime = 453
  | TimerfdGettime64 = 454
  | TimerfdSettime = 455
  | TimerfdSettime64 = 456
  | TimerGetoverrun = 457
  | TimerGettime = 458
  | TimerGettime64 = 459
  | TimerSettime = 460
  | TimerSettime64 = 461
  | Times = 462
  | Tkill = 463
  | Truncate = 464
  | Truncate64 = 465
  | Ugetrlimit = 466
  | Umask = 467
  | Umount = 468
  | Umount2 = 469
  | Uname = 470
  | Unlink = 471
  | Unlinkat = 472
  | Unshare = 473
  | Uselib = 474
  | Userfaultfd = 475
  | Usr26 = 476
  | Usr32 = 477
  | Ustat = 478
  | Utime = 479
  | Utimensat = 480
  | Utimensat64 = 481
  | Utimes = 482
  | UtrapInstall = 483
  | Vfork = 484
  | Vhangup = 485
  | Vm86 = 486
  | Vm86old = 487
  | Vmsplice = 488
  | Vserver = 489
  | Wait4 = 490
  | Waitid = 491
  | Waitpid = 492
  | Write = 493
  | Writev = 494
  | Xtensa = 495

[<RequireQualifiedAccess>]
module LinuxSyscall =
  let private getX86Number = function
    | LinuxSyscall.RestartSyscall -> 0
    | LinuxSyscall.Exit -> 1
    | LinuxSyscall.Fork -> 2
    | LinuxSyscall.Read -> 3
    | LinuxSyscall.Write -> 4
    | LinuxSyscall.Open -> 5
    | LinuxSyscall.Close -> 6
    | LinuxSyscall.Waitpid -> 7
    | LinuxSyscall.Creat -> 8
    | LinuxSyscall.Link -> 9
    | LinuxSyscall.Unlink -> 10
    | LinuxSyscall.Execve -> 11
    | LinuxSyscall.Chdir -> 12
    | LinuxSyscall.Time -> 13
    | LinuxSyscall.Mknod -> 14
    | LinuxSyscall.Chmod -> 15
    | LinuxSyscall.Lchown -> 16
    | LinuxSyscall.Oldstat -> 18
    | LinuxSyscall.Lseek -> 19
    | LinuxSyscall.Getpid -> 20
    | LinuxSyscall.Mount -> 21
    | LinuxSyscall.Umount -> 22
    | LinuxSyscall.Setuid -> 23
    | LinuxSyscall.Getuid -> 24
    | LinuxSyscall.Stime -> 25
    | LinuxSyscall.Ptrace -> 26
    | LinuxSyscall.Alarm -> 27
    | LinuxSyscall.Oldfstat -> 28
    | LinuxSyscall.Pause -> 29
    | LinuxSyscall.Utime -> 30
    | LinuxSyscall.Access -> 33
    | LinuxSyscall.Nice -> 34
    | LinuxSyscall.Sync -> 36
    | LinuxSyscall.Kill -> 37
    | LinuxSyscall.Rename -> 38
    | LinuxSyscall.Mkdir -> 39
    | LinuxSyscall.Rmdir -> 40
    | LinuxSyscall.Dup -> 41
    | LinuxSyscall.Pipe -> 42
    | LinuxSyscall.Times -> 43
    | LinuxSyscall.Brk -> 45
    | LinuxSyscall.Setgid -> 46
    | LinuxSyscall.Getgid -> 47
    | LinuxSyscall.Signal -> 48
    | LinuxSyscall.Geteuid -> 49
    | LinuxSyscall.Getegid -> 50
    | LinuxSyscall.Acct -> 51
    | LinuxSyscall.Umount2 -> 52
    | LinuxSyscall.Ioctl -> 54
    | LinuxSyscall.Fcntl -> 55
    | LinuxSyscall.Setpgid -> 57
    | LinuxSyscall.Oldolduname -> 59
    | LinuxSyscall.Umask -> 60
    | LinuxSyscall.Chroot -> 61
    | LinuxSyscall.Ustat -> 62
    | LinuxSyscall.Dup2 -> 63
    | LinuxSyscall.Getppid -> 64
    | LinuxSyscall.Getpgrp -> 65
    | LinuxSyscall.Setsid -> 66
    | LinuxSyscall.Sigaction -> 67
    | LinuxSyscall.Sgetmask -> 68
    | LinuxSyscall.Ssetmask -> 69
    | LinuxSyscall.Setreuid -> 70
    | LinuxSyscall.Setregid -> 71
    | LinuxSyscall.Sigsuspend -> 72
    | LinuxSyscall.Sigpending -> 73
    | LinuxSyscall.Sethostname -> 74
    | LinuxSyscall.Setrlimit -> 75
    | LinuxSyscall.Getrlimit -> 76
    | LinuxSyscall.Getrusage -> 77
    | LinuxSyscall.Gettimeofday -> 78
    | LinuxSyscall.Settimeofday -> 79
    | LinuxSyscall.Getgroups -> 80
    | LinuxSyscall.Setgroups -> 81
    | LinuxSyscall.Select -> 82
    | LinuxSyscall.Symlink -> 83
    | LinuxSyscall.Oldlstat -> 84
    | LinuxSyscall.Readlink -> 85
    | LinuxSyscall.Uselib -> 86
    | LinuxSyscall.Swapon -> 87
    | LinuxSyscall.Reboot -> 88
    | LinuxSyscall.Readdir -> 89
    | LinuxSyscall.Mmap -> 90
    | LinuxSyscall.Munmap -> 91
    | LinuxSyscall.Truncate -> 92
    | LinuxSyscall.Ftruncate -> 93
    | LinuxSyscall.Fchmod -> 94
    | LinuxSyscall.Fchown -> 95
    | LinuxSyscall.Getpriority -> 96
    | LinuxSyscall.Setpriority -> 97
    | LinuxSyscall.Statfs -> 99
    | LinuxSyscall.Fstatfs -> 100
    | LinuxSyscall.Ioperm -> 101
    | LinuxSyscall.Socketcall -> 102
    | LinuxSyscall.Syslog -> 103
    | LinuxSyscall.Setitimer -> 104
    | LinuxSyscall.Getitimer -> 105
    | LinuxSyscall.Stat -> 106
    | LinuxSyscall.Lstat -> 107
    | LinuxSyscall.Fstat -> 108
    | LinuxSyscall.Olduname -> 109
    | LinuxSyscall.Iopl -> 110
    | LinuxSyscall.Vhangup -> 111
    | LinuxSyscall.Vm86old -> 113
    | LinuxSyscall.Wait4 -> 114
    | LinuxSyscall.Swapoff -> 115
    | LinuxSyscall.Sysinfo -> 116
    | LinuxSyscall.Ipc -> 117
    | LinuxSyscall.Fsync -> 118
    | LinuxSyscall.Sigreturn -> 119
    | LinuxSyscall.Clone -> 120
    | LinuxSyscall.Setdomainname -> 121
    | LinuxSyscall.Uname -> 122
    | LinuxSyscall.ModifyLdt -> 123
    | LinuxSyscall.AdjTimex -> 124
    | LinuxSyscall.Mprotect -> 125
    | LinuxSyscall.Sigprocmask -> 126
    | LinuxSyscall.CreateModule -> 127
    | LinuxSyscall.InitModule -> 128
    | LinuxSyscall.DeleteModule -> 129
    | LinuxSyscall.GetKernelSyms -> 130
    | LinuxSyscall.Quotactl -> 131
    | LinuxSyscall.Getpgid -> 132
    | LinuxSyscall.Fchdir -> 133
    | LinuxSyscall.Bdflush -> 134
    | LinuxSyscall.Sysfs -> 135
    | LinuxSyscall.Personality -> 136
    | LinuxSyscall.Setfsuid -> 138
    | LinuxSyscall.Setfsgid -> 139
    | LinuxSyscall.LLseek -> 140
    | LinuxSyscall.Getdents -> 141
    | LinuxSyscall.NewSelect -> 142
    | LinuxSyscall.Flock -> 143
    | LinuxSyscall.Msync -> 144
    | LinuxSyscall.Readv -> 145
    | LinuxSyscall.Writev -> 146
    | LinuxSyscall.Getsid -> 147
    | LinuxSyscall.Fdatasync -> 148
    | LinuxSyscall.Sysctl -> 149
    | LinuxSyscall.Mlock -> 150
    | LinuxSyscall.Munlock -> 151
    | LinuxSyscall.Mlockall -> 152
    | LinuxSyscall.Munlockall -> 153
    | LinuxSyscall.SchedSetparam -> 154
    | LinuxSyscall.SchedGetparam -> 155
    | LinuxSyscall.SchedSetscheduler -> 156
    | LinuxSyscall.SchedGetscheduler -> 157
    | LinuxSyscall.SchedYield -> 158
    | LinuxSyscall.SchedGetPriorityMax -> 159
    | LinuxSyscall.SchedGetPriorityMin -> 160
    | LinuxSyscall.SchedRrGetInterval -> 161
    | LinuxSyscall.Nanosleep -> 162
    | LinuxSyscall.Mremap -> 163
    | LinuxSyscall.Setresuid -> 164
    | LinuxSyscall.Getresuid -> 165
    | LinuxSyscall.Vm86 -> 166
    | LinuxSyscall.QueryModule -> 167
    | LinuxSyscall.Poll -> 168
    | LinuxSyscall.Nfsservctl -> 169
    | LinuxSyscall.Setresgid -> 170
    | LinuxSyscall.Getresgid -> 171
    | LinuxSyscall.Prctl -> 172
    | LinuxSyscall.RtSigreturn -> 173
    | LinuxSyscall.RtSigaction -> 174
    | LinuxSyscall.RtSigprocmask -> 175
    | LinuxSyscall.RtSigpending -> 176
    | LinuxSyscall.RtSigtimedwait -> 177
    | LinuxSyscall.RtSigqueueinfo -> 178
    | LinuxSyscall.RtSigsuspend -> 179
    | LinuxSyscall.Pread64 -> 180
    | LinuxSyscall.Pwrite64 -> 181
    | LinuxSyscall.Chown -> 182
    | LinuxSyscall.Getcwd -> 183
    | LinuxSyscall.CapGet -> 184
    | LinuxSyscall.CapSet -> 185
    | LinuxSyscall.Sigaltstack -> 186
    | LinuxSyscall.Sendfile -> 187
    | LinuxSyscall.Vfork -> 190
    | LinuxSyscall.Ugetrlimit -> 191
    | LinuxSyscall.Mmap2 -> 192
    | LinuxSyscall.Truncate64 -> 193
    | LinuxSyscall.Ftruncate64 -> 194
    | LinuxSyscall.Stat64 -> 195
    | LinuxSyscall.Lstat64 -> 196
    | LinuxSyscall.Fstat64 -> 197
    | LinuxSyscall.Lchown32 -> 198
    | LinuxSyscall.Getuid32 -> 199
    | LinuxSyscall.Getgid32 -> 200
    | LinuxSyscall.Geteuid32 -> 201
    | LinuxSyscall.Getegid32 -> 202
    | LinuxSyscall.Setreuid32 -> 203
    | LinuxSyscall.Setregid32 -> 204
    | LinuxSyscall.Getgroups32 -> 205
    | LinuxSyscall.Setgroups32 -> 206
    | LinuxSyscall.Fchown32 -> 207
    | LinuxSyscall.Setresuid32 -> 208
    | LinuxSyscall.Getresuid32 -> 209
    | LinuxSyscall.Setresgid32 -> 210
    | LinuxSyscall.Getresgid32 -> 211
    | LinuxSyscall.Chown32 -> 212
    | LinuxSyscall.Setuid32 -> 213
    | LinuxSyscall.Setgid32 -> 214
    | LinuxSyscall.Setfsuid32 -> 215
    | LinuxSyscall.Setfsgid32 -> 216
    | LinuxSyscall.PivotRoot -> 217
    | LinuxSyscall.Mincore -> 218
    | LinuxSyscall.Madvise -> 219
    | LinuxSyscall.Getdents64 -> 220
    | LinuxSyscall.Fcntl64 -> 221
    | LinuxSyscall.Gettid -> 224
    | LinuxSyscall.Readahead -> 225
    | LinuxSyscall.Setxattr -> 226
    | LinuxSyscall.Lsetxattr -> 227
    | LinuxSyscall.Fsetxattr -> 228
    | LinuxSyscall.Getxattr -> 229
    | LinuxSyscall.Lgetxattr -> 230
    | LinuxSyscall.Fgetxattr -> 231
    | LinuxSyscall.Listxattr -> 232
    | LinuxSyscall.Llistxattr -> 233
    | LinuxSyscall.Flistxattr -> 234
    | LinuxSyscall.Removexattr -> 235
    | LinuxSyscall.Lremovexattr -> 236
    | LinuxSyscall.Fremovexattr -> 237
    | LinuxSyscall.Tkill -> 238
    | LinuxSyscall.Sendfile64 -> 239
    | LinuxSyscall.Futex -> 240
    | LinuxSyscall.SchedSetaffinity -> 241
    | LinuxSyscall.SchedGetaffinity -> 242
    | LinuxSyscall.SetThreadArea -> 243
    | LinuxSyscall.GetThreadArea -> 244
    | LinuxSyscall.IoSetup -> 245
    | LinuxSyscall.IoDestroy -> 246
    | LinuxSyscall.IoGetevents -> 247
    | LinuxSyscall.IoSubmit -> 248
    | LinuxSyscall.IoCancel -> 249
    | LinuxSyscall.Fadvise64 -> 250
    | LinuxSyscall.ExitGroup -> 252
    | LinuxSyscall.LookupDcookie -> 253
    | LinuxSyscall.EpollCreate -> 254
    | LinuxSyscall.EpollCtl -> 255
    | LinuxSyscall.EpollWait -> 256
    | LinuxSyscall.RemapFilePages -> 257
    | LinuxSyscall.SetTidAddress -> 258
    | LinuxSyscall.TimerCreate -> 259
    | LinuxSyscall.TimerSettime -> 260
    | LinuxSyscall.TimerGettime -> 261
    | LinuxSyscall.TimerGetoverrun -> 262
    | LinuxSyscall.TimerDelete -> 263
    | LinuxSyscall.ClockSettime -> 264
    | LinuxSyscall.ClockGettime -> 265
    | LinuxSyscall.ClockGetres -> 266
    | LinuxSyscall.ClockNanosleep -> 267
    | LinuxSyscall.Statfs64 -> 268
    | LinuxSyscall.Fstatfs64 -> 269
    | LinuxSyscall.Tgkill -> 270
    | LinuxSyscall.Utimes -> 271
    | LinuxSyscall.Fadvise64_64 -> 272
    | LinuxSyscall.Vserver -> 273
    | LinuxSyscall.Mbind -> 274
    | LinuxSyscall.GetMempolicy -> 275
    | LinuxSyscall.SetMempolicy -> 276
    | LinuxSyscall.MqOpen -> 277
    | LinuxSyscall.MqUnlink -> 278
    | LinuxSyscall.MqTimedsend -> 279
    | LinuxSyscall.MqTimedreceive -> 280
    | LinuxSyscall.MqNotify -> 281
    | LinuxSyscall.MqGetsetattr -> 282
    | LinuxSyscall.KexecLoad -> 283
    | LinuxSyscall.Waitid -> 284
    | LinuxSyscall.AddKey -> 286
    | LinuxSyscall.RequestKey -> 287
    | LinuxSyscall.Keyctl -> 288
    | LinuxSyscall.IoprioSet -> 289
    | LinuxSyscall.IoprioGet -> 290
    | LinuxSyscall.InotifyInit -> 291
    | LinuxSyscall.InotifyAddWatch -> 292
    | LinuxSyscall.InotifyRmWatch -> 293
    | LinuxSyscall.MigratePages -> 294
    | LinuxSyscall.Openat -> 295
    | LinuxSyscall.Mkdirat -> 296
    | LinuxSyscall.Mknodat -> 297
    | LinuxSyscall.Fchownat -> 298
    | LinuxSyscall.Futimesat -> 299
    | LinuxSyscall.Fstatat64 -> 300
    | LinuxSyscall.Unlinkat -> 301
    | LinuxSyscall.Renameat -> 302
    | LinuxSyscall.Linkat -> 303
    | LinuxSyscall.Symlinkat -> 304
    | LinuxSyscall.Readlinkat -> 305
    | LinuxSyscall.Fchmodat -> 306
    | LinuxSyscall.Faccessat -> 307
    | LinuxSyscall.Pselect6 -> 308
    | LinuxSyscall.Ppoll -> 309
    | LinuxSyscall.Unshare -> 310
    | LinuxSyscall.SetRobustList -> 311
    | LinuxSyscall.GetRobustList -> 312
    | LinuxSyscall.Splice -> 313
    | LinuxSyscall.SyncFileRange -> 314
    | LinuxSyscall.Tee -> 315
    | LinuxSyscall.Vmsplice -> 316
    | LinuxSyscall.MovePages -> 317
    | LinuxSyscall.Getcpu -> 318
    | LinuxSyscall.EpollPwait -> 319
    | LinuxSyscall.Utimensat -> 320
    | LinuxSyscall.Signalfd -> 321
    | LinuxSyscall.TimerfdCreate -> 322
    | LinuxSyscall.Eventfd -> 323
    | LinuxSyscall.Fallocate -> 324
    | LinuxSyscall.TimerfdSettime -> 325
    | LinuxSyscall.TimerfdGettime -> 326
    | LinuxSyscall.Signalfd4 -> 327
    | LinuxSyscall.Eventfd2 -> 328
    | LinuxSyscall.EpollCreate1 -> 329
    | LinuxSyscall.Dup3 -> 330
    | LinuxSyscall.Pipe2 -> 331
    | LinuxSyscall.InotifyInit1 -> 332
    | LinuxSyscall.Preadv -> 333
    | LinuxSyscall.Pwritev -> 334
    | LinuxSyscall.RtTgsigqueueinfo -> 335
    | LinuxSyscall.PerfEventOpen -> 336
    | LinuxSyscall.Recvmmsg -> 337
    | LinuxSyscall.FanotifyInit -> 338
    | LinuxSyscall.FanotifyMark -> 339
    | LinuxSyscall.Prlimit64 -> 340
    | LinuxSyscall.NameToHandleAt -> 341
    | LinuxSyscall.OpenByHandleAt -> 342
    | LinuxSyscall.ClockAdjtime -> 343
    | LinuxSyscall.Syncfs -> 344
    | LinuxSyscall.Sendmmsg -> 345
    | LinuxSyscall.Setns -> 346
    | LinuxSyscall.ProcessVmReadv -> 347
    | LinuxSyscall.ProcessVmWritev -> 348
    | LinuxSyscall.Kcmp -> 349
    | LinuxSyscall.FinitModule -> 350
    | LinuxSyscall.SchedSetattr -> 351
    | LinuxSyscall.SchedGetattr -> 352
    | LinuxSyscall.Renameat2 -> 353
    | LinuxSyscall.Seccomp -> 354
    | LinuxSyscall.Getrandom -> 355
    | LinuxSyscall.MemfdCreate -> 356
    | LinuxSyscall.Bpf -> 357
    | LinuxSyscall.Execveat -> 358
    | LinuxSyscall.Socket -> 359
    | LinuxSyscall.Socketpair -> 360
    | LinuxSyscall.Bind -> 361
    | LinuxSyscall.Connect -> 362
    | LinuxSyscall.Listen -> 363
    | LinuxSyscall.Accept4 -> 364
    | LinuxSyscall.Getsockopt -> 365
    | LinuxSyscall.Setsockopt -> 366
    | LinuxSyscall.Getsockname -> 367
    | LinuxSyscall.Getpeername -> 368
    | LinuxSyscall.Sendto -> 369
    | LinuxSyscall.Sendmsg -> 370
    | LinuxSyscall.Recvfrom -> 371
    | LinuxSyscall.Recvmsg -> 372
    | LinuxSyscall.Shutdown -> 373
    | LinuxSyscall.Userfaultfd -> 374
    | LinuxSyscall.Membarrier -> 375
    | LinuxSyscall.Mlock2 -> 376
    | LinuxSyscall.CopyFileRange -> 377
    | LinuxSyscall.Preadv2 -> 378
    | LinuxSyscall.Pwritev2 -> 379
    | LinuxSyscall.PkeyMprotect -> 380
    | LinuxSyscall.PkeyAlloc -> 381
    | LinuxSyscall.PkeyFree -> 382
    | LinuxSyscall.Statx -> 383
    | LinuxSyscall.ArchPrctl -> 384
    | _ -> raise UnhandledSyscallException

  let private getX64Number = function
    | LinuxSyscall.Read -> 0
    | LinuxSyscall.Write -> 1
    | LinuxSyscall.Open -> 2
    | LinuxSyscall.Close -> 3
    | LinuxSyscall.Stat -> 4
    | LinuxSyscall.Fstat -> 5
    | LinuxSyscall.Lstat -> 6
    | LinuxSyscall.Poll -> 7
    | LinuxSyscall.Lseek -> 8
    | LinuxSyscall.Mmap -> 9
    | LinuxSyscall.Mprotect -> 10
    | LinuxSyscall.Munmap -> 11
    | LinuxSyscall.Brk -> 12
    | LinuxSyscall.RtSigaction -> 13
    | LinuxSyscall.RtSigprocmask -> 14
    | LinuxSyscall.RtSigreturn -> 15
    | LinuxSyscall.Ioctl -> 16
    | LinuxSyscall.Pread64 -> 17
    | LinuxSyscall.Pwrite64 -> 18
    | LinuxSyscall.Readv -> 19
    | LinuxSyscall.Writev -> 20
    | LinuxSyscall.Access -> 21
    | LinuxSyscall.Pipe -> 22
    | LinuxSyscall.Select -> 23
    | LinuxSyscall.SchedYield -> 24
    | LinuxSyscall.Mremap -> 25
    | LinuxSyscall.Msync -> 26
    | LinuxSyscall.Mincore -> 27
    | LinuxSyscall.Madvise -> 28
    | LinuxSyscall.Shmget -> 29
    | LinuxSyscall.Shmat -> 30
    | LinuxSyscall.Shmctl -> 31
    | LinuxSyscall.Dup -> 32
    | LinuxSyscall.Dup2 -> 33
    | LinuxSyscall.Pause -> 34
    | LinuxSyscall.Nanosleep -> 35
    | LinuxSyscall.Getitimer -> 36
    | LinuxSyscall.Alarm -> 37
    | LinuxSyscall.Setitimer -> 38
    | LinuxSyscall.Getpid -> 39
    | LinuxSyscall.Sendfile -> 40
    | LinuxSyscall.Socket -> 41
    | LinuxSyscall.Connect -> 42
    | LinuxSyscall.Accept -> 43
    | LinuxSyscall.Sendto -> 44
    | LinuxSyscall.Recvfrom -> 45
    | LinuxSyscall.Sendmsg -> 46
    | LinuxSyscall.Recvmsg -> 47
    | LinuxSyscall.Shutdown -> 48
    | LinuxSyscall.Bind -> 49
    | LinuxSyscall.Listen -> 50
    | LinuxSyscall.Getsockname -> 51
    | LinuxSyscall.Getpeername -> 52
    | LinuxSyscall.Socketpair -> 53
    | LinuxSyscall.Setsockopt -> 54
    | LinuxSyscall.Getsockopt -> 55
    | LinuxSyscall.Clone -> 56
    | LinuxSyscall.Fork -> 57
    | LinuxSyscall.Vfork -> 58
    | LinuxSyscall.Execve -> 59
    | LinuxSyscall.Exit -> 60
    | LinuxSyscall.Wait4 -> 61
    | LinuxSyscall.Kill -> 62
    | LinuxSyscall.Uname -> 63
    | LinuxSyscall.Semget -> 64
    | LinuxSyscall.Semop -> 65
    | LinuxSyscall.Semctl -> 66
    | LinuxSyscall.Shmdt -> 67
    | LinuxSyscall.Msgget -> 68
    | LinuxSyscall.Msgsnd -> 69
    | LinuxSyscall.Msgrcv -> 70
    | LinuxSyscall.Msgctl -> 71
    | LinuxSyscall.Fcntl -> 72
    | LinuxSyscall.Flock -> 73
    | LinuxSyscall.Fsync -> 74
    | LinuxSyscall.Fdatasync -> 75
    | LinuxSyscall.Truncate -> 76
    | LinuxSyscall.Ftruncate -> 77
    | LinuxSyscall.Getdents -> 78
    | LinuxSyscall.Getcwd -> 79
    | LinuxSyscall.Chdir -> 80
    | LinuxSyscall.Fchdir -> 81
    | LinuxSyscall.Rename -> 82
    | LinuxSyscall.Mkdir -> 83
    | LinuxSyscall.Rmdir -> 84
    | LinuxSyscall.Creat -> 85
    | LinuxSyscall.Link -> 86
    | LinuxSyscall.Unlink -> 87
    | LinuxSyscall.Symlink -> 88
    | LinuxSyscall.Readlink -> 89
    | LinuxSyscall.Chmod -> 90
    | LinuxSyscall.Fchmod -> 91
    | LinuxSyscall.Chown -> 92
    | LinuxSyscall.Fchown -> 93
    | LinuxSyscall.Lchown -> 94
    | LinuxSyscall.Umask -> 95
    | LinuxSyscall.Gettimeofday -> 96
    | LinuxSyscall.Getrlimit -> 97
    | LinuxSyscall.Getrusage -> 98
    | LinuxSyscall.Sysinfo -> 99
    | LinuxSyscall.Times -> 100
    | LinuxSyscall.Ptrace -> 101
    | LinuxSyscall.Getuid -> 102
    | LinuxSyscall.Syslog -> 103
    | LinuxSyscall.Getgid -> 104
    | LinuxSyscall.Setuid -> 105
    | LinuxSyscall.Setgid -> 106
    | LinuxSyscall.Geteuid -> 107
    | LinuxSyscall.Getegid -> 108
    | LinuxSyscall.Setpgid -> 109
    | LinuxSyscall.Getppid -> 110
    | LinuxSyscall.Getpgrp -> 111
    | LinuxSyscall.Setsid -> 112
    | LinuxSyscall.Setreuid -> 113
    | LinuxSyscall.Setregid -> 114
    | LinuxSyscall.Getgroups -> 115
    | LinuxSyscall.Setgroups -> 116
    | LinuxSyscall.Setresuid -> 117
    | LinuxSyscall.Getresuid -> 118
    | LinuxSyscall.Setresgid -> 119
    | LinuxSyscall.Getresgid -> 120
    | LinuxSyscall.Getpgid -> 121
    | LinuxSyscall.Setfsuid -> 122
    | LinuxSyscall.Setfsgid -> 123
    | LinuxSyscall.Getsid -> 124
    | LinuxSyscall.CapGet -> 125
    | LinuxSyscall.CapSet -> 126
    | LinuxSyscall.RtSigpending -> 127
    | LinuxSyscall.RtSigtimedwait -> 128
    | LinuxSyscall.RtSigqueueinfo -> 129
    | LinuxSyscall.RtSigsuspend -> 130
    | LinuxSyscall.Sigaltstack -> 131
    | LinuxSyscall.Utime -> 132
    | LinuxSyscall.Mknod -> 133
    | LinuxSyscall.Uselib -> 134
    | LinuxSyscall.Personality -> 135
    | LinuxSyscall.Ustat -> 136
    | LinuxSyscall.Statfs -> 137
    | LinuxSyscall.Fstatfs -> 138
    | LinuxSyscall.Sysfs -> 139
    | LinuxSyscall.Getpriority -> 140
    | LinuxSyscall.Setpriority -> 141
    | LinuxSyscall.SchedSetparam -> 142
    | LinuxSyscall.SchedGetparam -> 143
    | LinuxSyscall.SchedSetscheduler -> 144
    | LinuxSyscall.SchedGetscheduler -> 145
    | LinuxSyscall.SchedGetPriorityMax -> 146
    | LinuxSyscall.SchedGetPriorityMin -> 147
    | LinuxSyscall.SchedRrGetInterval -> 148
    | LinuxSyscall.Mlock -> 149
    | LinuxSyscall.Munlock -> 150
    | LinuxSyscall.Mlockall -> 151
    | LinuxSyscall.Munlockall -> 152
    | LinuxSyscall.Vhangup -> 153
    | LinuxSyscall.ModifyLdt -> 154
    | LinuxSyscall.PivotRoot -> 155
    | LinuxSyscall.Sysctl -> 156
    | LinuxSyscall.Prctl -> 157
    | LinuxSyscall.ArchPrctl -> 158
    | LinuxSyscall.AdjTimex -> 159
    | LinuxSyscall.Setrlimit -> 160
    | LinuxSyscall.Chroot -> 161
    | LinuxSyscall.Sync -> 162
    | LinuxSyscall.Acct -> 163
    | LinuxSyscall.Settimeofday -> 164
    | LinuxSyscall.Mount -> 165
    | LinuxSyscall.Umount2 -> 166
    | LinuxSyscall.Swapon -> 167
    | LinuxSyscall.Swapoff -> 168
    | LinuxSyscall.Reboot -> 169
    | LinuxSyscall.Sethostname -> 170
    | LinuxSyscall.Setdomainname -> 171
    | LinuxSyscall.Iopl -> 172
    | LinuxSyscall.Ioperm -> 173
    | LinuxSyscall.CreateModule -> 174
    | LinuxSyscall.InitModule -> 175
    | LinuxSyscall.DeleteModule -> 176
    | LinuxSyscall.GetKernelSyms -> 177
    | LinuxSyscall.QueryModule -> 178
    | LinuxSyscall.Quotactl -> 179
    | LinuxSyscall.Nfsservctl -> 180
    | LinuxSyscall.Gettid -> 186
    | LinuxSyscall.Readahead -> 187
    | LinuxSyscall.Setxattr -> 188
    | LinuxSyscall.Lsetxattr -> 189
    | LinuxSyscall.Fsetxattr -> 190
    | LinuxSyscall.Getxattr -> 191
    | LinuxSyscall.Lgetxattr -> 192
    | LinuxSyscall.Fgetxattr -> 193
    | LinuxSyscall.Listxattr -> 194
    | LinuxSyscall.Llistxattr -> 195
    | LinuxSyscall.Flistxattr -> 196
    | LinuxSyscall.Removexattr -> 197
    | LinuxSyscall.Lremovexattr -> 198
    | LinuxSyscall.Fremovexattr -> 199
    | LinuxSyscall.Tkill -> 200
    | LinuxSyscall.Time -> 201
    | LinuxSyscall.Futex -> 202
    | LinuxSyscall.SchedSetaffinity -> 203
    | LinuxSyscall.SchedGetaffinity -> 204
    | LinuxSyscall.SetThreadArea -> 205
    | LinuxSyscall.IoSetup -> 206
    | LinuxSyscall.IoDestroy -> 207
    | LinuxSyscall.IoGetevents -> 208
    | LinuxSyscall.IoSubmit -> 209
    | LinuxSyscall.IoCancel -> 210
    | LinuxSyscall.GetThreadArea -> 211
    | LinuxSyscall.LookupDcookie -> 212
    | LinuxSyscall.EpollCreate -> 213
    | LinuxSyscall.RemapFilePages -> 216
    | LinuxSyscall.Getdents64 -> 217
    | LinuxSyscall.SetTidAddress -> 218
    | LinuxSyscall.RestartSyscall -> 219
    | LinuxSyscall.Semtimedop -> 220
    | LinuxSyscall.Fadvise64 -> 221
    | LinuxSyscall.TimerCreate -> 222
    | LinuxSyscall.TimerSettime -> 223
    | LinuxSyscall.TimerGettime -> 224
    | LinuxSyscall.TimerGetoverrun -> 225
    | LinuxSyscall.TimerDelete -> 226
    | LinuxSyscall.ClockSettime -> 227
    | LinuxSyscall.ClockGettime -> 228
    | LinuxSyscall.ClockGetres -> 229
    | LinuxSyscall.ClockNanosleep -> 230
    | LinuxSyscall.ExitGroup -> 231
    | LinuxSyscall.EpollWait -> 232
    | LinuxSyscall.EpollCtl -> 233
    | LinuxSyscall.Tgkill -> 234
    | LinuxSyscall.Utimes -> 235
    | LinuxSyscall.Mbind -> 237
    | LinuxSyscall.SetMempolicy -> 238
    | LinuxSyscall.GetMempolicy -> 239
    | LinuxSyscall.MqOpen -> 240
    | LinuxSyscall.MqUnlink -> 241
    | LinuxSyscall.MqTimedsend -> 242
    | LinuxSyscall.MqTimedreceive -> 243
    | LinuxSyscall.MqNotify -> 244
    | LinuxSyscall.MqGetsetattr -> 245
    | LinuxSyscall.KexecLoad -> 246
    | LinuxSyscall.Waitid -> 247
    | LinuxSyscall.AddKey -> 248
    | LinuxSyscall.RequestKey -> 249
    | LinuxSyscall.Keyctl -> 250
    | LinuxSyscall.IoprioSet -> 251
    | LinuxSyscall.IoprioGet -> 252
    | LinuxSyscall.InotifyInit -> 253
    | LinuxSyscall.InotifyAddWatch -> 254
    | LinuxSyscall.InotifyRmWatch -> 255
    | LinuxSyscall.MigratePages -> 256
    | LinuxSyscall.Openat -> 257
    | LinuxSyscall.Mkdirat -> 258
    | LinuxSyscall.Mknodat -> 259
    | LinuxSyscall.Fchownat -> 260
    | LinuxSyscall.Futimesat -> 261
    | LinuxSyscall.Newfstatat -> 262
    | LinuxSyscall.Unlinkat -> 263
    | LinuxSyscall.Renameat -> 264
    | LinuxSyscall.Linkat -> 265
    | LinuxSyscall.Symlinkat -> 266
    | LinuxSyscall.Readlinkat -> 267
    | LinuxSyscall.Fchmodat -> 268
    | LinuxSyscall.Faccessat -> 269
    | LinuxSyscall.Pselect6 -> 270
    | LinuxSyscall.Ppoll -> 271
    | LinuxSyscall.Unshare -> 272
    | LinuxSyscall.SetRobustList -> 273
    | LinuxSyscall.GetRobustList -> 274
    | LinuxSyscall.Splice -> 275
    | LinuxSyscall.Tee -> 276
    | LinuxSyscall.SyncFileRange -> 277
    | LinuxSyscall.Vmsplice -> 278
    | LinuxSyscall.MovePages -> 279
    | LinuxSyscall.Utimensat -> 280
    | LinuxSyscall.EpollPwait -> 281
    | LinuxSyscall.Signalfd -> 282
    | LinuxSyscall.TimerfdCreate -> 283
    | LinuxSyscall.Eventfd -> 284
    | LinuxSyscall.Fallocate -> 285
    | LinuxSyscall.TimerfdSettime -> 286
    | LinuxSyscall.TimerfdGettime -> 287
    | LinuxSyscall.Accept4 -> 288
    | LinuxSyscall.Signalfd4 -> 289
    | LinuxSyscall.Eventfd2 -> 290
    | LinuxSyscall.EpollCreate1 -> 291
    | LinuxSyscall.Dup3 -> 292
    | LinuxSyscall.Pipe2 -> 293
    | LinuxSyscall.InotifyInit1 -> 294
    | LinuxSyscall.Preadv -> 295
    | LinuxSyscall.Pwritev -> 296
    | LinuxSyscall.RtTgsigqueueinfo -> 297
    | LinuxSyscall.PerfEventOpen -> 298
    | LinuxSyscall.Recvmmsg -> 299
    | LinuxSyscall.FanotifyInit -> 300
    | LinuxSyscall.FanotifyMark -> 301
    | LinuxSyscall.Prlimit64 -> 302
    | LinuxSyscall.NameToHandleAt -> 303
    | LinuxSyscall.OpenByHandleAt -> 304
    | LinuxSyscall.ClockAdjtime -> 305
    | LinuxSyscall.Syncfs -> 306
    | LinuxSyscall.Sendmmsg -> 307
    | LinuxSyscall.Setns -> 308
    | LinuxSyscall.Getcpu -> 309
    | LinuxSyscall.ProcessVmReadv -> 310
    | LinuxSyscall.ProcessVmWritev -> 311
    | LinuxSyscall.Kcmp -> 312
    | LinuxSyscall.FinitModule -> 313
    | LinuxSyscall.SchedSetattr -> 314
    | LinuxSyscall.SchedGetattr -> 315
    | LinuxSyscall.Renameat2 -> 316
    | LinuxSyscall.Seccomp -> 317
    | LinuxSyscall.Getrandom -> 318
    | LinuxSyscall.MemfdCreate -> 319
    | LinuxSyscall.KexecFileLoad -> 320
    | LinuxSyscall.Bpf -> 321
    | LinuxSyscall.Execveat -> 322
    | LinuxSyscall.Userfaultfd -> 323
    | LinuxSyscall.Membarrier -> 324
    | LinuxSyscall.Mlock2 -> 325
    | LinuxSyscall.CopyFileRange -> 326
    | LinuxSyscall.Preadv2 -> 327
    | LinuxSyscall.Pwritev2 -> 328
    | LinuxSyscall.PkeyMprotect -> 329
    | LinuxSyscall.PkeyAlloc -> 330
    | LinuxSyscall.PkeyFree -> 331
    | LinuxSyscall.Statx -> 332
    | LinuxSyscall.IoPgetevents -> 333
    | LinuxSyscall.Rseq -> 334
    | _ -> raise UnhandledSyscallException

  let private getARMEABINumber = function
    | LinuxSyscall.RestartSyscall -> 0
    | LinuxSyscall.Exit -> 1
    | LinuxSyscall.Fork -> 2
    | LinuxSyscall.Read -> 3
    | LinuxSyscall.Write -> 4
    | LinuxSyscall.Open -> 5
    | LinuxSyscall.Close -> 6
    | LinuxSyscall.Creat -> 8
    | LinuxSyscall.Link -> 9
    | LinuxSyscall.Unlink -> 10
    | LinuxSyscall.Execve -> 11
    | LinuxSyscall.Chdir -> 12
    | LinuxSyscall.Mknod -> 14
    | LinuxSyscall.Chmod -> 15
    | LinuxSyscall.Lchown -> 16
    | LinuxSyscall.Lseek -> 19
    | LinuxSyscall.Getpid -> 20
    | LinuxSyscall.Mount -> 21
    | LinuxSyscall.Setuid -> 23
    | LinuxSyscall.Getuid -> 24
    | LinuxSyscall.Ptrace -> 26
    | LinuxSyscall.Pause -> 29
    | LinuxSyscall.Access -> 33
    | LinuxSyscall.Nice -> 34
    | LinuxSyscall.Sync -> 36
    | LinuxSyscall.Kill -> 37
    | LinuxSyscall.Rename -> 38
    | LinuxSyscall.Mkdir -> 39
    | LinuxSyscall.Rmdir -> 40
    | LinuxSyscall.Dup -> 41
    | LinuxSyscall.Pipe -> 42
    | LinuxSyscall.Times -> 43
    | LinuxSyscall.Brk -> 45
    | LinuxSyscall.Setgid -> 46
    | LinuxSyscall.Getgid -> 47
    | LinuxSyscall.Geteuid -> 49
    | LinuxSyscall.Getegid -> 50
    | LinuxSyscall.Acct -> 51
    | LinuxSyscall.Umount2 -> 52
    | LinuxSyscall.Ioctl -> 54
    | LinuxSyscall.Fcntl -> 55
    | LinuxSyscall.Setpgid -> 57
    | LinuxSyscall.Umask -> 60
    | LinuxSyscall.Chroot -> 61
    | LinuxSyscall.Ustat -> 62
    | LinuxSyscall.Dup2 -> 63
    | LinuxSyscall.Getppid -> 64
    | LinuxSyscall.Getpgrp -> 65
    | LinuxSyscall.Setsid -> 66
    | LinuxSyscall.Sigaction -> 67
    | LinuxSyscall.Setreuid -> 70
    | LinuxSyscall.Setregid -> 71
    | LinuxSyscall.Sigsuspend -> 72
    | LinuxSyscall.Sigpending -> 73
    | LinuxSyscall.Sethostname -> 74
    | LinuxSyscall.Setrlimit -> 75
    | LinuxSyscall.Getrusage -> 77
    | LinuxSyscall.Gettimeofday -> 78
    | LinuxSyscall.Settimeofday -> 79
    | LinuxSyscall.Getgroups -> 80
    | LinuxSyscall.Setgroups -> 81
    | LinuxSyscall.Symlink -> 83
    | LinuxSyscall.Readlink -> 85
    | LinuxSyscall.Uselib -> 86
    | LinuxSyscall.Swapon -> 87
    | LinuxSyscall.Reboot -> 88
    | LinuxSyscall.Munmap -> 91
    | LinuxSyscall.Truncate -> 92
    | LinuxSyscall.Ftruncate -> 93
    | LinuxSyscall.Fchmod -> 94
    | LinuxSyscall.Fchown -> 95
    | LinuxSyscall.Getpriority -> 96
    | LinuxSyscall.Setpriority -> 97
    | LinuxSyscall.Statfs -> 99
    | LinuxSyscall.Fstatfs -> 100
    | LinuxSyscall.Syslog -> 103
    | LinuxSyscall.Setitimer -> 104
    | LinuxSyscall.Getitimer -> 105
    | LinuxSyscall.Stat -> 106
    | LinuxSyscall.Lstat -> 107
    | LinuxSyscall.Fstat -> 108
    | LinuxSyscall.Vhangup -> 111
    | LinuxSyscall.Wait4 -> 114
    | LinuxSyscall.Swapoff -> 115
    | LinuxSyscall.Sysinfo -> 116
    | LinuxSyscall.Fsync -> 118
    | LinuxSyscall.Sigreturn -> 119
    | LinuxSyscall.Clone -> 120
    | LinuxSyscall.Setdomainname -> 121
    | LinuxSyscall.Uname -> 122
    | LinuxSyscall.AdjTimex -> 124
    | LinuxSyscall.Mprotect -> 125
    | LinuxSyscall.Sigprocmask -> 126
    | LinuxSyscall.InitModule -> 128
    | LinuxSyscall.DeleteModule -> 129
    | LinuxSyscall.Quotactl -> 131
    | LinuxSyscall.Getpgid -> 132
    | LinuxSyscall.Fchdir -> 133
    | LinuxSyscall.Bdflush -> 134
    | LinuxSyscall.Sysfs -> 135
    | LinuxSyscall.Personality -> 136
    | LinuxSyscall.Setfsuid -> 138
    | LinuxSyscall.Setfsgid -> 139
    | LinuxSyscall.LLseek -> 140
    | LinuxSyscall.Getdents -> 141
    | LinuxSyscall.NewSelect -> 142
    | LinuxSyscall.Flock -> 143
    | LinuxSyscall.Msync -> 144
    | LinuxSyscall.Readv -> 145
    | LinuxSyscall.Writev -> 146
    | LinuxSyscall.Getsid -> 147
    | LinuxSyscall.Fdatasync -> 148
    | LinuxSyscall.Sysctl -> 149
    | LinuxSyscall.Mlock -> 150
    | LinuxSyscall.Munlock -> 151
    | LinuxSyscall.Mlockall -> 152
    | LinuxSyscall.Munlockall -> 153
    | LinuxSyscall.SchedSetparam -> 154
    | LinuxSyscall.SchedGetparam -> 155
    | LinuxSyscall.SchedSetscheduler -> 156
    | LinuxSyscall.SchedGetscheduler -> 157
    | LinuxSyscall.SchedYield -> 158
    | LinuxSyscall.SchedGetPriorityMax -> 159
    | LinuxSyscall.SchedGetPriorityMin -> 160
    | LinuxSyscall.SchedRrGetInterval -> 161
    | LinuxSyscall.Nanosleep -> 162
    | LinuxSyscall.Mremap -> 163
    | LinuxSyscall.Setresuid -> 164
    | LinuxSyscall.Getresuid -> 165
    | LinuxSyscall.Poll -> 168
    | LinuxSyscall.Nfsservctl -> 169
    | LinuxSyscall.Setresgid -> 170
    | LinuxSyscall.Getresgid -> 171
    | LinuxSyscall.Prctl -> 172
    | LinuxSyscall.RtSigreturn -> 173
    | LinuxSyscall.RtSigaction -> 174
    | LinuxSyscall.RtSigprocmask -> 175
    | LinuxSyscall.RtSigpending -> 176
    | LinuxSyscall.RtSigtimedwait -> 177
    | LinuxSyscall.RtSigqueueinfo -> 178
    | LinuxSyscall.RtSigsuspend -> 179
    | LinuxSyscall.Pread64 -> 180
    | LinuxSyscall.Pwrite64 -> 181
    | LinuxSyscall.Chown -> 182
    | LinuxSyscall.Getcwd -> 183
    | LinuxSyscall.CapGet -> 184
    | LinuxSyscall.CapSet -> 185
    | LinuxSyscall.Sigaltstack -> 186
    | LinuxSyscall.Sendfile -> 187
    | LinuxSyscall.Vfork -> 190
    | LinuxSyscall.Ugetrlimit -> 191
    | LinuxSyscall.Mmap2 -> 192
    | LinuxSyscall.Truncate64 -> 193
    | LinuxSyscall.Ftruncate64 -> 194
    | LinuxSyscall.Stat64 -> 195
    | LinuxSyscall.Lstat64 -> 196
    | LinuxSyscall.Fstat64 -> 197
    | LinuxSyscall.Lchown32 -> 198
    | LinuxSyscall.Getuid32 -> 199
    | LinuxSyscall.Getgid32 -> 200
    | LinuxSyscall.Geteuid32 -> 201
    | LinuxSyscall.Getegid32 -> 202
    | LinuxSyscall.Setreuid32 -> 203
    | LinuxSyscall.Setregid32 -> 204
    | LinuxSyscall.Getgroups32 -> 205
    | LinuxSyscall.Setgroups32 -> 206
    | LinuxSyscall.Fchown32 -> 207
    | LinuxSyscall.Setresuid32 -> 208
    | LinuxSyscall.Getresuid32 -> 209
    | LinuxSyscall.Setresgid32 -> 210
    | LinuxSyscall.Getresgid32 -> 211
    | LinuxSyscall.Chown32 -> 212
    | LinuxSyscall.Setuid32 -> 213
    | LinuxSyscall.Setgid32 -> 214
    | LinuxSyscall.Setfsuid32 -> 215
    | LinuxSyscall.Setfsgid32 -> 216
    | LinuxSyscall.Getdents64 -> 217
    | LinuxSyscall.PivotRoot -> 218
    | LinuxSyscall.Mincore -> 219
    | LinuxSyscall.Madvise -> 220
    | LinuxSyscall.Fcntl64 -> 221
    | LinuxSyscall.Gettid -> 224
    | LinuxSyscall.Readahead -> 225
    | LinuxSyscall.Setxattr -> 226
    | LinuxSyscall.Lsetxattr -> 227
    | LinuxSyscall.Fsetxattr -> 228
    | LinuxSyscall.Getxattr -> 229
    | LinuxSyscall.Lgetxattr -> 230
    | LinuxSyscall.Fgetxattr -> 231
    | LinuxSyscall.Listxattr -> 232
    | LinuxSyscall.Llistxattr -> 233
    | LinuxSyscall.Flistxattr -> 234
    | LinuxSyscall.Removexattr -> 235
    | LinuxSyscall.Lremovexattr -> 236
    | LinuxSyscall.Fremovexattr -> 237
    | LinuxSyscall.Tkill -> 238
    | LinuxSyscall.Sendfile64 -> 239
    | LinuxSyscall.Futex -> 240
    | LinuxSyscall.SchedSetaffinity -> 241
    | LinuxSyscall.SchedGetaffinity -> 242
    | LinuxSyscall.IoSetup -> 243
    | LinuxSyscall.IoDestroy -> 244
    | LinuxSyscall.IoGetevents -> 245
    | LinuxSyscall.IoSubmit -> 246
    | LinuxSyscall.IoCancel -> 247
    | LinuxSyscall.ExitGroup -> 248
    | LinuxSyscall.LookupDcookie -> 249
    | LinuxSyscall.EpollCreate -> 250
    | LinuxSyscall.EpollCtl -> 251
    | LinuxSyscall.EpollWait -> 252
    | LinuxSyscall.RemapFilePages -> 253
    | LinuxSyscall.SetTidAddress -> 256
    | LinuxSyscall.TimerCreate -> 257
    | LinuxSyscall.TimerSettime -> 258
    | LinuxSyscall.TimerGettime -> 259
    | LinuxSyscall.TimerGetoverrun -> 260
    | LinuxSyscall.TimerDelete -> 261
    | LinuxSyscall.ClockSettime -> 262
    | LinuxSyscall.ClockGettime -> 263
    | LinuxSyscall.ClockGetres -> 264
    | LinuxSyscall.ClockNanosleep -> 265
    | LinuxSyscall.Statfs64 -> 266
    | LinuxSyscall.Fstatfs64 -> 267
    | LinuxSyscall.Tgkill -> 268
    | LinuxSyscall.Utimes -> 269
    | LinuxSyscall.ArmFadvise64 -> 270
    | LinuxSyscall.PciconfigIobase -> 271
    | LinuxSyscall.PciconfigRead -> 272
    | LinuxSyscall.PciconfigWrite -> 273
    | LinuxSyscall.MqOpen -> 274
    | LinuxSyscall.MqUnlink -> 275
    | LinuxSyscall.MqTimedsend -> 276
    | LinuxSyscall.MqTimedreceive -> 277
    | LinuxSyscall.MqNotify -> 278
    | LinuxSyscall.MqGetsetattr -> 279
    | LinuxSyscall.Waitid -> 280
    | LinuxSyscall.Socket -> 281
    | LinuxSyscall.Bind -> 282
    | LinuxSyscall.Connect -> 283
    | LinuxSyscall.Listen -> 284
    | LinuxSyscall.Accept -> 285
    | LinuxSyscall.Getsockname -> 286
    | LinuxSyscall.Getpeername -> 287
    | LinuxSyscall.Socketpair -> 288
    | LinuxSyscall.Send -> 289
    | LinuxSyscall.Sendto -> 290
    | LinuxSyscall.Recv -> 291
    | LinuxSyscall.Recvfrom -> 292
    | LinuxSyscall.Shutdown -> 293
    | LinuxSyscall.Setsockopt -> 294
    | LinuxSyscall.Getsockopt -> 295
    | LinuxSyscall.Sendmsg -> 296
    | LinuxSyscall.Recvmsg -> 297
    | LinuxSyscall.Semop -> 298
    | LinuxSyscall.Semget -> 299
    | LinuxSyscall.Semctl -> 300
    | LinuxSyscall.Msgsnd -> 301
    | LinuxSyscall.Msgrcv -> 302
    | LinuxSyscall.Msgget -> 303
    | LinuxSyscall.Msgctl -> 304
    | LinuxSyscall.Shmat -> 305
    | LinuxSyscall.Shmdt -> 306
    | LinuxSyscall.Shmget -> 307
    | LinuxSyscall.Shmctl -> 308
    | LinuxSyscall.AddKey -> 309
    | LinuxSyscall.RequestKey -> 310
    | LinuxSyscall.Keyctl -> 311
    | LinuxSyscall.Semtimedop -> 312
    | LinuxSyscall.Vserver -> 313
    | LinuxSyscall.IoprioSet -> 314
    | LinuxSyscall.IoprioGet -> 315
    | LinuxSyscall.InotifyInit -> 316
    | LinuxSyscall.InotifyAddWatch -> 317
    | LinuxSyscall.InotifyRmWatch -> 318
    | LinuxSyscall.Mbind -> 319
    | LinuxSyscall.GetMempolicy -> 320
    | LinuxSyscall.SetMempolicy -> 321
    | LinuxSyscall.Openat -> 322
    | LinuxSyscall.Mkdirat -> 323
    | LinuxSyscall.Mknodat -> 324
    | LinuxSyscall.Fchownat -> 325
    | LinuxSyscall.Futimesat -> 326
    | LinuxSyscall.Fstatat64 -> 327
    | LinuxSyscall.Unlinkat -> 328
    | LinuxSyscall.Renameat -> 329
    | LinuxSyscall.Linkat -> 330
    | LinuxSyscall.Symlinkat -> 331
    | LinuxSyscall.Readlinkat -> 332
    | LinuxSyscall.Fchmodat -> 333
    | LinuxSyscall.Faccessat -> 334
    | LinuxSyscall.Pselect6 -> 335
    | LinuxSyscall.Ppoll -> 336
    | LinuxSyscall.Unshare -> 337
    | LinuxSyscall.SetRobustList -> 338
    | LinuxSyscall.GetRobustList -> 339
    | LinuxSyscall.Splice -> 340
    | LinuxSyscall.ArmSyncFileRange -> 341
    | LinuxSyscall.Tee -> 342
    | LinuxSyscall.Vmsplice -> 343
    | LinuxSyscall.MovePages -> 344
    | LinuxSyscall.Getcpu -> 345
    | LinuxSyscall.EpollPwait -> 346
    | LinuxSyscall.KexecLoad -> 347
    | LinuxSyscall.Utimensat -> 348
    | LinuxSyscall.Signalfd -> 349
    | LinuxSyscall.TimerfdCreate -> 350
    | LinuxSyscall.Eventfd -> 351
    | LinuxSyscall.Fallocate -> 352
    | LinuxSyscall.TimerfdSettime -> 353
    | LinuxSyscall.TimerfdGettime -> 354
    | LinuxSyscall.Signalfd4 -> 355
    | LinuxSyscall.Eventfd2 -> 356
    | LinuxSyscall.EpollCreate1 -> 357
    | LinuxSyscall.Dup3 -> 358
    | LinuxSyscall.Pipe2 -> 359
    | LinuxSyscall.InotifyInit1 -> 360
    | LinuxSyscall.Preadv -> 361
    | LinuxSyscall.Pwritev -> 362
    | LinuxSyscall.RtTgsigqueueinfo -> 363
    | LinuxSyscall.PerfEventOpen -> 364
    | LinuxSyscall.Recvmmsg -> 365
    | LinuxSyscall.Accept4 -> 366
    | LinuxSyscall.FanotifyInit -> 367
    | LinuxSyscall.FanotifyMark -> 368
    | LinuxSyscall.Prlimit64 -> 369
    | LinuxSyscall.NameToHandleAt -> 370
    | LinuxSyscall.OpenByHandleAt -> 371
    | LinuxSyscall.ClockAdjtime -> 372
    | LinuxSyscall.Syncfs -> 373
    | LinuxSyscall.Sendmmsg -> 374
    | LinuxSyscall.Setns -> 375
    | LinuxSyscall.ProcessVmReadv -> 376
    | LinuxSyscall.ProcessVmWritev -> 377
    | LinuxSyscall.Kcmp -> 378
    | LinuxSyscall.FinitModule -> 379
    | LinuxSyscall.SchedSetattr -> 380
    | LinuxSyscall.SchedGetattr -> 381
    | LinuxSyscall.Renameat2 -> 382
    | LinuxSyscall.Seccomp -> 383
    | LinuxSyscall.Getrandom -> 384
    | LinuxSyscall.MemfdCreate -> 385
    | LinuxSyscall.Bpf -> 386
    | LinuxSyscall.Execveat -> 387
    | LinuxSyscall.Userfaultfd -> 388
    | LinuxSyscall.Membarrier -> 389
    | LinuxSyscall.Mlock2 -> 390
    | LinuxSyscall.CopyFileRange -> 391
    | LinuxSyscall.Preadv2 -> 392
    | LinuxSyscall.Pwritev2 -> 393
    | LinuxSyscall.PkeyMprotect -> 394
    | LinuxSyscall.PkeyAlloc -> 395
    | LinuxSyscall.PkeyFree -> 396
    | LinuxSyscall.Statx -> 397
    | LinuxSyscall.Rseq -> 398
    | LinuxSyscall.IoPgetevents -> 399
    | LinuxSyscall.MigratePages -> 400
    | LinuxSyscall.KexecFileLoad -> 401
    | LinuxSyscall.ClockGettime64 -> 403
    | LinuxSyscall.ClockSettime64 -> 404
    | LinuxSyscall.ClockAdjtime64 -> 405
    | LinuxSyscall.TimerGettime64 -> 408
    | LinuxSyscall.TimerSettime64 -> 409
    | LinuxSyscall.TimerfdGettime64 -> 410
    | LinuxSyscall.TimerfdSettime64 -> 411
    | LinuxSyscall.SchedRrGetInterval64 -> 423
    | LinuxSyscall.PidfdSendSignal -> 424
    | LinuxSyscall.IoUringSetup -> 425
    | LinuxSyscall.IoUringEnter -> 426
    | LinuxSyscall.IoUringRegister -> 427
    | LinuxSyscall.OpenTree -> 428
    | LinuxSyscall.MoveMount -> 429
    | LinuxSyscall.Fsopen -> 430
    | LinuxSyscall.Fsconfig -> 431
    | LinuxSyscall.Fsmount -> 432
    | LinuxSyscall.Fspick -> 433
    | LinuxSyscall.PidfdOpen -> 434
    | LinuxSyscall.Clone3 -> 435
    | LinuxSyscall.Openat2 -> 437
    | LinuxSyscall.PidfdGetfd -> 438
    | LinuxSyscall.Breakpoint -> 0x0f0001 (* __ARM_NR_breakpoint *)
    | LinuxSyscall.CacheFlush -> 0x0f0002 (* __ARM_NR_cacheflush *)
    | LinuxSyscall.Usr26 -> 0x0f0003 (* __ARM_NR_usr26 *)
    | LinuxSyscall.Usr32 -> 0x0f0004 (* __ARM_NR_usr32 *)
    | LinuxSyscall.SetTLS -> 0x0f0005 (* __ARM_NR_set_tls *)
    | LinuxSyscall.GetTLS -> 0x0f0006 (* __ARM_NR_get_tls *)
    | _ -> raise UnhandledSyscallException

  let private getAARCH64Number = function
    | LinuxSyscall.IoSetup -> 0
    | LinuxSyscall.IoDestroy -> 1
    | LinuxSyscall.IoSubmit -> 2
    | LinuxSyscall.IoCancel -> 3
    | LinuxSyscall.IoGetevents -> 4
    | LinuxSyscall.Setxattr -> 5
    | LinuxSyscall.Lsetxattr -> 6
    | LinuxSyscall.Fsetxattr -> 7
    | LinuxSyscall.Getxattr -> 8
    | LinuxSyscall.Lgetxattr -> 9
    | LinuxSyscall.Fgetxattr -> 10
    | LinuxSyscall.Listxattr -> 11
    | LinuxSyscall.Llistxattr -> 12
    | LinuxSyscall.Flistxattr -> 13
    | LinuxSyscall.Removexattr -> 14
    | LinuxSyscall.Lremovexattr -> 15
    | LinuxSyscall.Fremovexattr -> 16
    | LinuxSyscall.Getcwd -> 17
    | LinuxSyscall.LookupDcookie -> 18
    | LinuxSyscall.Eventfd2 -> 19
    | LinuxSyscall.EpollCreate1 -> 20
    | LinuxSyscall.EpollCtl -> 21
    | LinuxSyscall.EpollPwait -> 22
    | LinuxSyscall.Dup -> 23
    | LinuxSyscall.Dup3 -> 24
    | LinuxSyscall.Fcntl -> 25
    | LinuxSyscall.InotifyInit1 -> 26
    | LinuxSyscall.InotifyAddWatch -> 27
    | LinuxSyscall.InotifyRmWatch -> 28
    | LinuxSyscall.Ioctl -> 29
    | LinuxSyscall.IoprioSet -> 30
    | LinuxSyscall.IoprioGet -> 31
    | LinuxSyscall.Flock -> 32
    | LinuxSyscall.Mknodat -> 33
    | LinuxSyscall.Mkdirat -> 34
    | LinuxSyscall.Unlinkat -> 35
    | LinuxSyscall.Symlinkat -> 36
    | LinuxSyscall.Linkat -> 37
    | LinuxSyscall.Renameat -> 38
    | LinuxSyscall.Umount2 -> 39
    | LinuxSyscall.Mount -> 40
    | LinuxSyscall.PivotRoot -> 41
    | LinuxSyscall.Nfsservctl -> 42
    | LinuxSyscall.Statfs -> 43
    | LinuxSyscall.Fstatfs -> 44
    | LinuxSyscall.Truncate -> 45
    | LinuxSyscall.Ftruncate -> 46
    | LinuxSyscall.Fallocate -> 47
    | LinuxSyscall.Faccessat -> 48
    | LinuxSyscall.Chdir -> 49
    | LinuxSyscall.Fchdir -> 50
    | LinuxSyscall.Chroot -> 51
    | LinuxSyscall.Fchmod -> 52
    | LinuxSyscall.Fchmodat -> 53
    | LinuxSyscall.Fchownat -> 54
    | LinuxSyscall.Fchown -> 55
    | LinuxSyscall.Openat -> 56
    | LinuxSyscall.Close -> 57
    | LinuxSyscall.Vhangup -> 58
    | LinuxSyscall.Pipe2 -> 59
    | LinuxSyscall.Quotactl -> 60
    | LinuxSyscall.Getdents64 -> 61
    | LinuxSyscall.Lseek -> 62
    | LinuxSyscall.Read -> 63
    | LinuxSyscall.Write -> 64
    | LinuxSyscall.Readv -> 65
    | LinuxSyscall.Writev -> 66
    | LinuxSyscall.Pread64 -> 67
    | LinuxSyscall.Pwrite64 -> 68
    | LinuxSyscall.Preadv -> 69
    | LinuxSyscall.Pwritev -> 70
    | LinuxSyscall.Sendfile -> 71
    | LinuxSyscall.Pselect6 -> 72
    | LinuxSyscall.Ppoll -> 73
    | LinuxSyscall.Signalfd4 -> 74
    | LinuxSyscall.Vmsplice -> 75
    | LinuxSyscall.Splice -> 76
    | LinuxSyscall.Tee -> 77
    | LinuxSyscall.Readlinkat -> 78
    | LinuxSyscall.Newfstatat -> 79
    | LinuxSyscall.Fstat -> 80
    | LinuxSyscall.Sync -> 81
    | LinuxSyscall.Fsync -> 82
    | LinuxSyscall.Fdatasync -> 83
    | LinuxSyscall.SyncFileRange -> 84
    | LinuxSyscall.TimerfdCreate -> 85
    | LinuxSyscall.TimerfdSettime -> 86
    | LinuxSyscall.TimerfdGettime -> 87
    | LinuxSyscall.Utimensat -> 88
    | LinuxSyscall.Acct -> 89
    | LinuxSyscall.CapGet -> 90
    | LinuxSyscall.CapSet -> 91
    | LinuxSyscall.Personality -> 92
    | LinuxSyscall.Exit -> 93
    | LinuxSyscall.ExitGroup -> 94
    | LinuxSyscall.Waitid -> 95
    | LinuxSyscall.SetTidAddress -> 96
    | LinuxSyscall.Unshare -> 97
    | LinuxSyscall.Futex -> 98
    | LinuxSyscall.SetRobustList -> 99
    | LinuxSyscall.GetRobustList -> 100
    | LinuxSyscall.Nanosleep -> 101
    | LinuxSyscall.Getitimer -> 102
    | LinuxSyscall.Setitimer -> 103
    | LinuxSyscall.KexecLoad -> 104
    | LinuxSyscall.InitModule -> 105
    | LinuxSyscall.DeleteModule -> 106
    | LinuxSyscall.TimerCreate -> 107
    | LinuxSyscall.TimerGettime -> 108
    | LinuxSyscall.TimerGetoverrun -> 109
    | LinuxSyscall.TimerSettime -> 110
    | LinuxSyscall.TimerDelete -> 111
    | LinuxSyscall.ClockSettime -> 112
    | LinuxSyscall.ClockGettime -> 113
    | LinuxSyscall.ClockGetres -> 114
    | LinuxSyscall.ClockNanosleep -> 115
    | LinuxSyscall.Syslog -> 116
    | LinuxSyscall.Ptrace -> 117
    | LinuxSyscall.SchedSetparam -> 118
    | LinuxSyscall.SchedSetscheduler -> 119
    | LinuxSyscall.SchedGetscheduler -> 120
    | LinuxSyscall.SchedGetparam -> 121
    | LinuxSyscall.SchedSetaffinity -> 122
    | LinuxSyscall.SchedGetaffinity -> 123
    | LinuxSyscall.SchedYield -> 124
    | LinuxSyscall.SchedGetPriorityMax -> 125
    | LinuxSyscall.SchedGetPriorityMin -> 126
    | LinuxSyscall.SchedRrGetInterval -> 127
    | LinuxSyscall.RestartSyscall -> 128
    | LinuxSyscall.Kill -> 129
    | LinuxSyscall.Tkill -> 130
    | LinuxSyscall.Tgkill -> 131
    | LinuxSyscall.Sigaltstack -> 132
    | LinuxSyscall.RtSigsuspend -> 133
    | LinuxSyscall.RtSigaction -> 134
    | LinuxSyscall.RtSigprocmask -> 135
    | LinuxSyscall.RtSigpending -> 136
    | LinuxSyscall.RtSigtimedwait -> 137
    | LinuxSyscall.RtSigqueueinfo -> 138
    | LinuxSyscall.RtSigreturn -> 139
    | LinuxSyscall.Setpriority -> 140
    | LinuxSyscall.Getpriority -> 141
    | LinuxSyscall.Reboot -> 142
    | LinuxSyscall.Setregid -> 143
    | LinuxSyscall.Setgid -> 144
    | LinuxSyscall.Setreuid -> 145
    | LinuxSyscall.Setuid -> 146
    | LinuxSyscall.Setresuid -> 147
    | LinuxSyscall.Getresuid -> 148
    | LinuxSyscall.Setresgid -> 149
    | LinuxSyscall.Getresgid -> 150
    | LinuxSyscall.Setfsuid -> 151
    | LinuxSyscall.Setfsgid -> 152
    | LinuxSyscall.Times -> 153
    | LinuxSyscall.Setpgid -> 154
    | LinuxSyscall.Getpgid -> 155
    | LinuxSyscall.Getsid -> 156
    | LinuxSyscall.Setsid -> 157
    | LinuxSyscall.Getgroups -> 158
    | LinuxSyscall.Setgroups -> 159
    | LinuxSyscall.Uname -> 160
    | LinuxSyscall.Sethostname -> 161
    | LinuxSyscall.Setdomainname -> 162
    | LinuxSyscall.Getrlimit -> 163
    | LinuxSyscall.Setrlimit -> 164
    | LinuxSyscall.Getrusage -> 165
    | LinuxSyscall.Umask -> 166
    | LinuxSyscall.Prctl -> 167
    | LinuxSyscall.Getcpu -> 168
    | LinuxSyscall.Gettimeofday -> 169
    | LinuxSyscall.Settimeofday -> 170
    | LinuxSyscall.AdjTimex -> 171
    | LinuxSyscall.Getpid -> 172
    | LinuxSyscall.Getppid -> 173
    | LinuxSyscall.Getuid -> 174
    | LinuxSyscall.Geteuid -> 175
    | LinuxSyscall.Getgid -> 176
    | LinuxSyscall.Getegid -> 177
    | LinuxSyscall.Gettid -> 178
    | LinuxSyscall.Sysinfo -> 179
    | LinuxSyscall.MqOpen -> 180
    | LinuxSyscall.MqUnlink -> 181
    | LinuxSyscall.MqTimedsend -> 182
    | LinuxSyscall.MqTimedreceive -> 183
    | LinuxSyscall.MqNotify -> 184
    | LinuxSyscall.MqGetsetattr -> 185
    | LinuxSyscall.Msgget -> 186
    | LinuxSyscall.Msgctl -> 187
    | LinuxSyscall.Msgrcv -> 188
    | LinuxSyscall.Msgsnd -> 189
    | LinuxSyscall.Semget -> 190
    | LinuxSyscall.Semctl -> 191
    | LinuxSyscall.Semtimedop -> 192
    | LinuxSyscall.Semop -> 193
    | LinuxSyscall.Shmget -> 194
    | LinuxSyscall.Shmctl -> 195
    | LinuxSyscall.Shmat -> 196
    | LinuxSyscall.Shmdt -> 197
    | LinuxSyscall.Socket -> 198
    | LinuxSyscall.Socketpair -> 199
    | LinuxSyscall.Bind -> 200
    | LinuxSyscall.Listen -> 201
    | LinuxSyscall.Accept -> 202
    | LinuxSyscall.Connect -> 203
    | LinuxSyscall.Getsockname -> 204
    | LinuxSyscall.Getpeername -> 205
    | LinuxSyscall.Sendto -> 206
    | LinuxSyscall.Recvfrom -> 207
    | LinuxSyscall.Setsockopt -> 208
    | LinuxSyscall.Getsockopt -> 209
    | LinuxSyscall.Shutdown -> 210
    | LinuxSyscall.Sendmsg -> 211
    | LinuxSyscall.Recvmsg -> 212
    | LinuxSyscall.Readahead -> 213
    | LinuxSyscall.Brk -> 214
    | LinuxSyscall.Munmap -> 215
    | LinuxSyscall.Mremap -> 216
    | LinuxSyscall.AddKey -> 217
    | LinuxSyscall.RequestKey -> 218
    | LinuxSyscall.Keyctl -> 219
    | LinuxSyscall.Clone -> 220
    | LinuxSyscall.Execve -> 221
    | LinuxSyscall.Mmap -> 222
    | LinuxSyscall.Fadvise64 -> 223
    | LinuxSyscall.Swapon -> 224
    | LinuxSyscall.Swapoff -> 225
    | LinuxSyscall.Mprotect -> 226
    | LinuxSyscall.Msync -> 227
    | LinuxSyscall.Mlock -> 228
    | LinuxSyscall.Munlock -> 229
    | LinuxSyscall.Mlockall -> 230
    | LinuxSyscall.Munlockall -> 231
    | LinuxSyscall.Mincore -> 232
    | LinuxSyscall.Madvise -> 233
    | LinuxSyscall.RemapFilePages -> 234
    | LinuxSyscall.Mbind -> 235
    | LinuxSyscall.GetMempolicy -> 236
    | LinuxSyscall.SetMempolicy -> 237
    | LinuxSyscall.MigratePages -> 238
    | LinuxSyscall.MovePages -> 239
    | LinuxSyscall.RtTgsigqueueinfo -> 240
    | LinuxSyscall.PerfEventOpen -> 241
    | LinuxSyscall.Accept4 -> 242
    | LinuxSyscall.Recvmmsg -> 243
    | LinuxSyscall.Wait4 -> 260
    | LinuxSyscall.Prlimit64 -> 261
    | LinuxSyscall.FanotifyInit -> 262
    | LinuxSyscall.FanotifyMark -> 263
    | LinuxSyscall.NameToHandleAt -> 264
    | LinuxSyscall.OpenByHandleAt -> 265
    | LinuxSyscall.ClockAdjtime -> 266
    | LinuxSyscall.Syncfs -> 267
    | LinuxSyscall.Setns -> 268
    | LinuxSyscall.Sendmmsg -> 269
    | LinuxSyscall.ProcessVmReadv -> 270
    | LinuxSyscall.ProcessVmWritev -> 271
    | LinuxSyscall.Kcmp -> 272
    | LinuxSyscall.FinitModule -> 273
    | LinuxSyscall.SchedSetattr -> 274
    | LinuxSyscall.SchedGetattr -> 275
    | LinuxSyscall.Renameat2 -> 276
    | LinuxSyscall.Seccomp -> 277
    | LinuxSyscall.Getrandom -> 278
    | LinuxSyscall.MemfdCreate -> 279
    | LinuxSyscall.Bpf -> 280
    | LinuxSyscall.Execveat -> 281
    | LinuxSyscall.Userfaultfd -> 282
    | LinuxSyscall.Membarrier -> 283
    | LinuxSyscall.Mlock2 -> 284
    | LinuxSyscall.CopyFileRange -> 285
    | LinuxSyscall.Preadv2 -> 286
    | LinuxSyscall.Pwritev2 -> 287
    | LinuxSyscall.PkeyMprotect -> 288
    | LinuxSyscall.PkeyAlloc -> 289
    | LinuxSyscall.PkeyFree -> 290
    | LinuxSyscall.Statx -> 291
    | LinuxSyscall.IoPgetevents -> 292
    | LinuxSyscall.Rseq -> 293
    | LinuxSyscall.KexecFileLoad -> 294
    | LinuxSyscall.ClockGettime64 -> 403
    | LinuxSyscall.ClockSettime64 -> 404
    | LinuxSyscall.ClockAdjtime64 -> 405
    | LinuxSyscall.ClockGetres64 -> 406
    | LinuxSyscall.ClockNanosleep64 -> 407
    | LinuxSyscall.TimerGettime64 -> 408
    | LinuxSyscall.TimerSettime64 -> 409
    | LinuxSyscall.TimerfdGettime64 -> 410
    | LinuxSyscall.TimerfdSettime64 -> 411
    | LinuxSyscall.Utimensat64 -> 412
    | LinuxSyscall.Pselect6_64 -> 413
    | LinuxSyscall.Ppoll64 -> 414
    | LinuxSyscall.IoPgetevents64 -> 416
    | LinuxSyscall.Recvmmsg64 -> 417
    | LinuxSyscall.MqTimedsend64 -> 418
    | LinuxSyscall.MqTimedreceive64 -> 419
    | LinuxSyscall.Semtimedop64 -> 420
    | LinuxSyscall.RtSigtimedwait64 -> 421
    | LinuxSyscall.Futex64 -> 422
    | LinuxSyscall.SchedRrGetInterval64 -> 423
    | LinuxSyscall.PidfdSendSignal -> 424
    | LinuxSyscall.IoUringSetup -> 425
    | LinuxSyscall.IoUringEnter -> 426
    | LinuxSyscall.IoUringRegister -> 427
    | LinuxSyscall.OpenTree -> 428
    | LinuxSyscall.MoveMount -> 429
    | LinuxSyscall.Fsopen -> 430
    | LinuxSyscall.Fsconfig -> 431
    | LinuxSyscall.Fsmount -> 432
    | LinuxSyscall.Fspick -> 433
    | LinuxSyscall.PidfdOpen -> 434
    | LinuxSyscall.Clone3 -> 435
    | LinuxSyscall.Openat2 -> 437
    | LinuxSyscall.PidfdGetfd -> 438
    | _ -> raise UnhandledSyscallException

  let private getMIPSO32Number = function
    | LinuxSyscall.Exit -> 4001
    | LinuxSyscall.Fork -> 4002
    | LinuxSyscall.Read -> 4003
    | LinuxSyscall.Write -> 4004
    | LinuxSyscall.Open -> 4005
    | LinuxSyscall.Close -> 4006
    | LinuxSyscall.Waitpid -> 4007
    | LinuxSyscall.Creat -> 4008
    | LinuxSyscall.Link -> 4009
    | LinuxSyscall.Unlink -> 4010
    | LinuxSyscall.Execve -> 4011
    | LinuxSyscall.Chdir -> 4012
    | LinuxSyscall.Time -> 4013
    | LinuxSyscall.Mknod -> 4014
    | LinuxSyscall.Chmod -> 4015
    | LinuxSyscall.Lchown -> 4016
    | LinuxSyscall.Breakpoint -> 4017
    | LinuxSyscall.Lseek -> 4019
    | LinuxSyscall.Getpid -> 4020
    | LinuxSyscall.Mount -> 4021
    | LinuxSyscall.Umount -> 4022
    | LinuxSyscall.Setuid -> 4023
    | LinuxSyscall.Getuid -> 4024
    | LinuxSyscall.Stime -> 4025
    | LinuxSyscall.Ptrace -> 4026
    | LinuxSyscall.Alarm -> 4027
    | LinuxSyscall.Pause -> 4029
    | LinuxSyscall.Utime -> 4030
    | LinuxSyscall.Access -> 4033
    | LinuxSyscall.Nice -> 4034
    | LinuxSyscall.Sync -> 4036
    | LinuxSyscall.Kill -> 4037
    | LinuxSyscall.Rename -> 4038
    | LinuxSyscall.Mkdir -> 4039
    | LinuxSyscall.Rmdir -> 4040
    | LinuxSyscall.Dup -> 4041
    | LinuxSyscall.Pipe -> 4042
    | LinuxSyscall.Times -> 4043
    | LinuxSyscall.Brk -> 4045
    | LinuxSyscall.Setgid -> 4046
    | LinuxSyscall.Getgid -> 4047
    | LinuxSyscall.Signal -> 4048
    | LinuxSyscall.Geteuid -> 4049
    | LinuxSyscall.Getegid -> 4050
    | LinuxSyscall.Acct -> 4051
    | LinuxSyscall.Umount2 -> 4052
    | LinuxSyscall.Ioctl -> 4054
    | LinuxSyscall.Fcntl -> 4055
    | LinuxSyscall.Setpgid -> 4057
    | LinuxSyscall.Umask -> 4060
    | LinuxSyscall.Chroot -> 4061
    | LinuxSyscall.Ustat -> 4062
    | LinuxSyscall.Dup2 -> 4063
    | LinuxSyscall.Getppid -> 4064
    | LinuxSyscall.Getpgrp -> 4065
    | LinuxSyscall.Setsid -> 4066
    | LinuxSyscall.Sigaction -> 4067
    | LinuxSyscall.Sgetmask -> 4068
    | LinuxSyscall.Ssetmask -> 4069
    | LinuxSyscall.Setreuid -> 4070
    | LinuxSyscall.Setregid -> 4071
    | LinuxSyscall.Sigsuspend -> 4072
    | LinuxSyscall.Sigpending -> 4073
    | LinuxSyscall.Sethostname -> 4074
    | LinuxSyscall.Setrlimit -> 4075
    | LinuxSyscall.Getrlimit -> 4076
    | LinuxSyscall.Getrusage -> 4077
    | LinuxSyscall.Gettimeofday -> 4078
    | LinuxSyscall.Settimeofday -> 4079
    | LinuxSyscall.Getgroups -> 4080
    | LinuxSyscall.Setgroups -> 4081
    | LinuxSyscall.Symlink -> 4083
    | LinuxSyscall.Readlink -> 4085
    | LinuxSyscall.Uselib -> 4086
    | LinuxSyscall.Swapon -> 4087
    | LinuxSyscall.Reboot -> 4088
    | LinuxSyscall.Readdir -> 4089
    | LinuxSyscall.Mmap -> 4090
    | LinuxSyscall.Munmap -> 4091
    | LinuxSyscall.Truncate -> 4092
    | LinuxSyscall.Ftruncate -> 4093
    | LinuxSyscall.Fchmod -> 4094
    | LinuxSyscall.Fchown -> 4095
    | LinuxSyscall.Getpriority -> 4096
    | LinuxSyscall.Setpriority -> 4097
    | LinuxSyscall.Statfs -> 4099
    | LinuxSyscall.Fstatfs -> 4100
    | LinuxSyscall.Ioperm -> 4101
    | LinuxSyscall.Socketcall -> 4102
    | LinuxSyscall.Syslog -> 4103
    | LinuxSyscall.Setitimer -> 4104
    | LinuxSyscall.Getitimer -> 4105
    | LinuxSyscall.Stat -> 4106
    | LinuxSyscall.Lstat -> 4107
    | LinuxSyscall.Fstat -> 4108
    | LinuxSyscall.Iopl -> 4110
    | LinuxSyscall.Vhangup -> 4111
    | LinuxSyscall.Vm86 -> 4113
    | LinuxSyscall.Wait4 -> 4114
    | LinuxSyscall.Swapoff -> 4115
    | LinuxSyscall.Sysinfo -> 4116
    | LinuxSyscall.Ipc -> 4117
    | LinuxSyscall.Fsync -> 4118
    | LinuxSyscall.Sigreturn -> 4119
    | LinuxSyscall.Clone -> 4120
    | LinuxSyscall.Setdomainname -> 4121
    | LinuxSyscall.Uname -> 4122
    | LinuxSyscall.ModifyLdt -> 4123
    | LinuxSyscall.OldAdjtimex -> 4124
    | LinuxSyscall.Mprotect -> 4125
    | LinuxSyscall.Sigprocmask -> 4126
    | LinuxSyscall.CreateModule -> 4127
    | LinuxSyscall.InitModule -> 4128
    | LinuxSyscall.DeleteModule -> 4129
    | LinuxSyscall.GetKernelSyms -> 4130
    | LinuxSyscall.Quotactl -> 4131
    | LinuxSyscall.Getpgid -> 4132
    | LinuxSyscall.Fchdir -> 4133
    | LinuxSyscall.Bdflush -> 4134
    | LinuxSyscall.Sysfs -> 4135
    | LinuxSyscall.Personality -> 4136
    | LinuxSyscall.Setfsuid -> 4138
    | LinuxSyscall.Setfsgid -> 4139
    | LinuxSyscall.LLseek -> 4140
    | LinuxSyscall.Getdents -> 4141
    | LinuxSyscall.NewSelect -> 4142
    | LinuxSyscall.Flock -> 4143
    | LinuxSyscall.Msync -> 4144
    | LinuxSyscall.Readv -> 4145
    | LinuxSyscall.Writev -> 4146
    | LinuxSyscall.CacheFlush -> 4147
    | LinuxSyscall.Sysmips -> 4149
    | LinuxSyscall.Getsid -> 4151
    | LinuxSyscall.Fdatasync -> 4152
    | LinuxSyscall.Mlock -> 4154
    | LinuxSyscall.Munlock -> 4155
    | LinuxSyscall.Mlockall -> 4156
    | LinuxSyscall.Munlockall -> 4157
    | LinuxSyscall.SchedSetparam -> 4158
    | LinuxSyscall.SchedGetparam -> 4159
    | LinuxSyscall.SchedSetscheduler -> 4160
    | LinuxSyscall.SchedGetscheduler -> 4161
    | LinuxSyscall.SchedYield -> 4162
    | LinuxSyscall.SchedGetPriorityMax -> 4163
    | LinuxSyscall.SchedGetPriorityMin -> 4164
    | LinuxSyscall.SchedRrGetInterval -> 4165
    | LinuxSyscall.Nanosleep -> 4166
    | LinuxSyscall.Mremap -> 4167
    | LinuxSyscall.Accept -> 4168
    | LinuxSyscall.Bind -> 4169
    | LinuxSyscall.Connect -> 4170
    | LinuxSyscall.Getpeername -> 4171
    | LinuxSyscall.Getsockname -> 4172
    | LinuxSyscall.Getsockopt -> 4173
    | LinuxSyscall.Listen -> 4174
    | LinuxSyscall.Recv -> 4175
    | LinuxSyscall.Recvfrom -> 4176
    | LinuxSyscall.Recvmsg -> 4177
    | LinuxSyscall.Send -> 4178
    | LinuxSyscall.Sendmsg -> 4179
    | LinuxSyscall.Sendto -> 4180
    | LinuxSyscall.Setsockopt -> 4181
    | LinuxSyscall.Shutdown -> 4182
    | LinuxSyscall.Socket -> 4183
    | LinuxSyscall.Socketpair -> 4184
    | LinuxSyscall.Setresuid -> 4185
    | LinuxSyscall.Getresuid -> 4186
    | LinuxSyscall.QueryModule -> 4187
    | LinuxSyscall.Poll -> 4188
    | LinuxSyscall.Nfsservctl -> 4189
    | LinuxSyscall.Setresgid -> 4190
    | LinuxSyscall.Getresgid -> 4191
    | LinuxSyscall.Prctl -> 4192
    | LinuxSyscall.RtSigreturn -> 4193
    | LinuxSyscall.RtSigaction -> 4194
    | LinuxSyscall.RtSigprocmask -> 4195
    | LinuxSyscall.RtSigpending -> 4196
    | LinuxSyscall.RtSigtimedwait -> 4197
    | LinuxSyscall.RtSigqueueinfo -> 4198
    | LinuxSyscall.RtSigsuspend -> 4199
    | LinuxSyscall.Pread64 -> 4200
    | LinuxSyscall.Pwrite64 -> 4201
    | LinuxSyscall.Chown -> 4202
    | LinuxSyscall.Getcwd -> 4203
    | LinuxSyscall.CapGet -> 4204
    | LinuxSyscall.CapSet -> 4205
    | LinuxSyscall.Sigaltstack -> 4206
    | LinuxSyscall.Sendfile -> 4207
    | LinuxSyscall.Mmap2 -> 4210
    | LinuxSyscall.Truncate64 -> 4211
    | LinuxSyscall.Ftruncate64 -> 4212
    | LinuxSyscall.Stat64 -> 4213
    | LinuxSyscall.Lstat64 -> 4214
    | LinuxSyscall.Fstat64 -> 4215
    | LinuxSyscall.PivotRoot -> 4216
    | LinuxSyscall.Mincore -> 4217
    | LinuxSyscall.Madvise -> 4218
    | LinuxSyscall.Getdents64 -> 4219
    | LinuxSyscall.Fcntl64 -> 4220
    | LinuxSyscall.Gettid -> 4222
    | LinuxSyscall.Readahead -> 4223
    | LinuxSyscall.Setxattr -> 4224
    | LinuxSyscall.Lsetxattr -> 4225
    | LinuxSyscall.Fsetxattr -> 4226
    | LinuxSyscall.Getxattr -> 4227
    | LinuxSyscall.Lgetxattr -> 4228
    | LinuxSyscall.Fgetxattr -> 4229
    | LinuxSyscall.Listxattr -> 4230
    | LinuxSyscall.Llistxattr -> 4231
    | LinuxSyscall.Flistxattr -> 4232
    | LinuxSyscall.Removexattr -> 4233
    | LinuxSyscall.Lremovexattr -> 4234
    | LinuxSyscall.Fremovexattr -> 4235
    | LinuxSyscall.Tkill -> 4236
    | LinuxSyscall.Sendfile64 -> 4237
    | LinuxSyscall.Futex -> 4238
    | LinuxSyscall.SchedSetaffinity -> 4239
    | LinuxSyscall.SchedGetaffinity -> 4240
    | LinuxSyscall.IoSetup -> 4241
    | LinuxSyscall.IoDestroy -> 4242
    | LinuxSyscall.IoGetevents -> 4243
    | LinuxSyscall.IoSubmit -> 4244
    | LinuxSyscall.IoCancel -> 4245
    | LinuxSyscall.ExitGroup -> 4246
    | LinuxSyscall.LookupDcookie -> 4247
    | LinuxSyscall.EpollCreate -> 4248
    | LinuxSyscall.EpollCtl -> 4249
    | LinuxSyscall.EpollWait -> 4250
    | LinuxSyscall.RemapFilePages -> 4251
    | LinuxSyscall.SetTidAddress -> 4252
    | LinuxSyscall.RestartSyscall -> 4253
    | LinuxSyscall.Fadvise64 -> 4254
    | LinuxSyscall.Statfs64 -> 4255
    | LinuxSyscall.Fstatfs64 -> 4256
    | LinuxSyscall.TimerCreate -> 4257
    | LinuxSyscall.TimerSettime -> 4258
    | LinuxSyscall.TimerGettime -> 4259
    | LinuxSyscall.TimerGetoverrun -> 4260
    | LinuxSyscall.TimerDelete -> 4261
    | LinuxSyscall.ClockSettime -> 4262
    | LinuxSyscall.ClockGettime -> 4263
    | LinuxSyscall.ClockGetres -> 4264
    | LinuxSyscall.ClockNanosleep -> 4265
    | LinuxSyscall.Tgkill -> 4266
    | LinuxSyscall.Utimes -> 4267
    | LinuxSyscall.Mbind -> 4268
    | LinuxSyscall.GetMempolicy -> 4269
    | LinuxSyscall.SetMempolicy -> 4270
    | LinuxSyscall.MqOpen -> 4271
    | LinuxSyscall.MqUnlink -> 4272
    | LinuxSyscall.MqTimedsend -> 4273
    | LinuxSyscall.MqTimedreceive -> 4274
    | LinuxSyscall.MqNotify -> 4275
    | LinuxSyscall.MqGetsetattr -> 4276
    | LinuxSyscall.Vserver -> 4277
    | LinuxSyscall.Waitid -> 4278
    | LinuxSyscall.AddKey -> 4280
    | LinuxSyscall.RequestKey -> 4281
    | LinuxSyscall.Keyctl -> 4282
    | LinuxSyscall.SetThreadArea -> 4283
    | LinuxSyscall.InotifyInit -> 4284
    | LinuxSyscall.InotifyAddWatch -> 4285
    | LinuxSyscall.InotifyRmWatch -> 4286
    | LinuxSyscall.MigratePages -> 4287
    | LinuxSyscall.Openat -> 4288
    | LinuxSyscall.Mkdirat -> 4289
    | LinuxSyscall.Mknodat -> 4290
    | LinuxSyscall.Fchownat -> 4291
    | LinuxSyscall.Futimesat -> 4292
    | LinuxSyscall.Fstatat64 -> 4293
    | LinuxSyscall.Unlinkat -> 4294
    | LinuxSyscall.Renameat -> 4295
    | LinuxSyscall.Linkat -> 4296
    | LinuxSyscall.Symlinkat -> 4297
    | LinuxSyscall.Readlinkat -> 4298
    | LinuxSyscall.Fchmodat -> 4299
    | LinuxSyscall.Faccessat -> 4300
    | LinuxSyscall.Pselect6 -> 4301
    | LinuxSyscall.Ppoll -> 4302
    | LinuxSyscall.Unshare -> 4303
    | LinuxSyscall.Splice -> 4304
    | LinuxSyscall.SyncFileRange -> 4305
    | LinuxSyscall.Tee -> 4306
    | LinuxSyscall.Vmsplice -> 4307
    | LinuxSyscall.MovePages -> 4308
    | LinuxSyscall.SetRobustList -> 4309
    | LinuxSyscall.GetRobustList -> 4310
    | LinuxSyscall.KexecLoad -> 4311
    | LinuxSyscall.Getcpu -> 4312
    | LinuxSyscall.EpollPwait -> 4313
    | LinuxSyscall.IoprioSet -> 4314
    | LinuxSyscall.IoprioGet -> 4315
    | LinuxSyscall.Utimensat -> 4316
    | LinuxSyscall.Signalfd -> 4317
    | LinuxSyscall.Eventfd -> 4319
    | LinuxSyscall.Fallocate -> 4320
    | LinuxSyscall.TimerfdCreate -> 4321
    | LinuxSyscall.TimerfdGettime -> 4322
    | LinuxSyscall.TimerfdSettime -> 4323
    | LinuxSyscall.Signalfd4 -> 4324
    | LinuxSyscall.Eventfd2 -> 4325
    | LinuxSyscall.EpollCreate1 -> 4326
    | LinuxSyscall.Dup3 -> 4327
    | LinuxSyscall.Pipe2 -> 4328
    | LinuxSyscall.InotifyInit1 -> 4329
    | LinuxSyscall.Preadv -> 4330
    | LinuxSyscall.Pwritev -> 4331
    | LinuxSyscall.RtTgsigqueueinfo -> 4332
    | LinuxSyscall.PerfEventOpen -> 4333
    | LinuxSyscall.Accept4 -> 4334
    | LinuxSyscall.Recvmmsg -> 4335
    | LinuxSyscall.FanotifyInit -> 4336
    | LinuxSyscall.FanotifyMark -> 4337
    | LinuxSyscall.Prlimit64 -> 4338
    | LinuxSyscall.NameToHandleAt -> 4339
    | LinuxSyscall.OpenByHandleAt -> 4340
    | LinuxSyscall.ClockAdjtime -> 4341
    | LinuxSyscall.Syncfs -> 4342
    | LinuxSyscall.Sendmmsg -> 4343
    | LinuxSyscall.Setns -> 4344
    | LinuxSyscall.ProcessVmReadv -> 4345
    | LinuxSyscall.ProcessVmWritev -> 4346
    | LinuxSyscall.Kcmp -> 4347
    | LinuxSyscall.FinitModule -> 4348
    | LinuxSyscall.SchedSetattr -> 4349
    | LinuxSyscall.SchedGetattr -> 4350
    | LinuxSyscall.Renameat2 -> 4351
    | LinuxSyscall.Seccomp -> 4352
    | LinuxSyscall.Getrandom -> 4353
    | LinuxSyscall.MemfdCreate -> 4354
    | LinuxSyscall.Bpf -> 4355
    | LinuxSyscall.Execveat -> 4356
    | LinuxSyscall.Userfaultfd -> 4357
    | LinuxSyscall.Membarrier -> 4358
    | LinuxSyscall.Mlock2 -> 4359
    | LinuxSyscall.CopyFileRange -> 4360
    | LinuxSyscall.Preadv2 -> 4361
    | LinuxSyscall.Pwritev2 -> 4362
    | LinuxSyscall.PkeyMprotect -> 4363
    | LinuxSyscall.PkeyAlloc -> 4364
    | LinuxSyscall.PkeyFree -> 4365
    | LinuxSyscall.Statx -> 4366
    | LinuxSyscall.Rseq -> 4367
    | LinuxSyscall.IoPgetevents -> 4368
    | LinuxSyscall.Semget -> 4393
    | LinuxSyscall.Semctl -> 4394
    | LinuxSyscall.Shmget -> 4395
    | LinuxSyscall.Shmctl -> 4396
    | LinuxSyscall.Shmat -> 4397
    | LinuxSyscall.Shmdt -> 4398
    | LinuxSyscall.Msgget -> 4399
    | LinuxSyscall.Msgsnd -> 4400
    | LinuxSyscall.Msgrcv -> 4401
    | LinuxSyscall.Msgctl -> 4402
    | LinuxSyscall.ClockGettime64 -> 4403
    | LinuxSyscall.ClockSettime64 -> 4404
    | LinuxSyscall.ClockAdjtime64 -> 4405
    | LinuxSyscall.ClockGetres64 -> 4406
    | LinuxSyscall.ClockNanosleep64 -> 4407
    | LinuxSyscall.TimerGettime64 -> 4408
    | LinuxSyscall.TimerSettime64 -> 4409
    | LinuxSyscall.TimerfdGettime64 -> 4410
    | LinuxSyscall.TimerfdSettime64 -> 4411
    | LinuxSyscall.Utimensat64 -> 4412
    | LinuxSyscall.Pselect6_64 -> 4413
    | LinuxSyscall.Ppoll64 -> 4414
    | LinuxSyscall.IoPgetevents64 -> 4416
    | LinuxSyscall.Recvmmsg64 -> 4417
    | LinuxSyscall.MqTimedsend64 -> 4418
    | LinuxSyscall.MqTimedreceive64 -> 4419
    | LinuxSyscall.Semtimedop64 -> 4420
    | LinuxSyscall.RtSigtimedwait64 -> 4421
    | LinuxSyscall.Futex64 -> 4422
    | LinuxSyscall.SchedRrGetInterval64 -> 4423
    | LinuxSyscall.PidfdSendSignal -> 4424
    | LinuxSyscall.IoUringSetup -> 4425
    | LinuxSyscall.IoUringEnter -> 4426
    | LinuxSyscall.IoUringRegister -> 4427
    | LinuxSyscall.OpenTree -> 4428
    | LinuxSyscall.MoveMount -> 4429
    | LinuxSyscall.Fsopen -> 4430
    | LinuxSyscall.Fsconfig -> 4431
    | LinuxSyscall.Fsmount -> 4432
    | LinuxSyscall.Fspick -> 4433
    | LinuxSyscall.PidfdOpen -> 4434
    | LinuxSyscall.Clone3 -> 4435
    | LinuxSyscall.Openat2 -> 4437
    | LinuxSyscall.PidfdGetfd -> 4438
    | _ -> raise UnhandledSyscallException

  let private getMIPSN64Number = function
    | LinuxSyscall.Read -> 5000
    | LinuxSyscall.Write -> 5001
    | LinuxSyscall.Open -> 5002
    | LinuxSyscall.Close -> 5003
    | LinuxSyscall.Stat -> 5004
    | LinuxSyscall.Fstat -> 5005
    | LinuxSyscall.Lstat -> 5006
    | LinuxSyscall.Poll -> 5007
    | LinuxSyscall.Lseek -> 5008
    | LinuxSyscall.Mmap -> 5009
    | LinuxSyscall.Mprotect -> 5010
    | LinuxSyscall.Munmap -> 5011
    | LinuxSyscall.Brk -> 5012
    | LinuxSyscall.RtSigaction -> 5013
    | LinuxSyscall.RtSigprocmask -> 5014
    | LinuxSyscall.Ioctl -> 5015
    | LinuxSyscall.Pread64 -> 5016
    | LinuxSyscall.Pwrite64 -> 5017
    | LinuxSyscall.Readv -> 5018
    | LinuxSyscall.Writev -> 5019
    | LinuxSyscall.Access -> 5020
    | LinuxSyscall.Pipe -> 5021
    | LinuxSyscall.NewSelect -> 5022
    | LinuxSyscall.SchedYield -> 5023
    | LinuxSyscall.Mremap -> 5024
    | LinuxSyscall.Msync -> 5025
    | LinuxSyscall.Mincore -> 5026
    | LinuxSyscall.Madvise -> 5027
    | LinuxSyscall.Shmget -> 5028
    | LinuxSyscall.Shmat -> 5029
    | LinuxSyscall.Shmctl -> 5030
    | LinuxSyscall.Dup -> 5031
    | LinuxSyscall.Dup2 -> 5032
    | LinuxSyscall.Pause -> 5033
    | LinuxSyscall.Nanosleep -> 5034
    | LinuxSyscall.Getitimer -> 5035
    | LinuxSyscall.Setitimer -> 5036
    | LinuxSyscall.Alarm -> 5037
    | LinuxSyscall.Getpid -> 5038
    | LinuxSyscall.Sendfile -> 5039
    | LinuxSyscall.Socket -> 5040
    | LinuxSyscall.Connect -> 5041
    | LinuxSyscall.Accept -> 5042
    | LinuxSyscall.Sendto -> 5043
    | LinuxSyscall.Recvfrom -> 5044
    | LinuxSyscall.Sendmsg -> 5045
    | LinuxSyscall.Recvmsg -> 5046
    | LinuxSyscall.Shutdown -> 5047
    | LinuxSyscall.Bind -> 5048
    | LinuxSyscall.Listen -> 5049
    | LinuxSyscall.Getsockname -> 5050
    | LinuxSyscall.Getpeername -> 5051
    | LinuxSyscall.Socketpair -> 5052
    | LinuxSyscall.Setsockopt -> 5053
    | LinuxSyscall.Getsockopt -> 5054
    | LinuxSyscall.Clone -> 5055
    | LinuxSyscall.Fork -> 5056
    | LinuxSyscall.Execve -> 5057
    | LinuxSyscall.Exit -> 5058
    | LinuxSyscall.Wait4 -> 5059
    | LinuxSyscall.Kill -> 5060
    | LinuxSyscall.Uname -> 5061
    | LinuxSyscall.Semget -> 5062
    | LinuxSyscall.Semop -> 5063
    | LinuxSyscall.Semctl -> 5064
    | LinuxSyscall.Shmdt -> 5065
    | LinuxSyscall.Msgget -> 5066
    | LinuxSyscall.Msgsnd -> 5067
    | LinuxSyscall.Msgrcv -> 5068
    | LinuxSyscall.Msgctl -> 5069
    | LinuxSyscall.Fcntl -> 5070
    | LinuxSyscall.Flock -> 5071
    | LinuxSyscall.Fsync -> 5072
    | LinuxSyscall.Fdatasync -> 5073
    | LinuxSyscall.Truncate -> 5074
    | LinuxSyscall.Ftruncate -> 5075
    | LinuxSyscall.Getdents -> 5076
    | LinuxSyscall.Getcwd -> 5077
    | LinuxSyscall.Chdir -> 5078
    | LinuxSyscall.Fchdir -> 5079
    | LinuxSyscall.Rename -> 5080
    | LinuxSyscall.Mkdir -> 5081
    | LinuxSyscall.Rmdir -> 5082
    | LinuxSyscall.Creat -> 5083
    | LinuxSyscall.Link -> 5084
    | LinuxSyscall.Unlink -> 5085
    | LinuxSyscall.Symlink -> 5086
    | LinuxSyscall.Readlink -> 5087
    | LinuxSyscall.Chmod -> 5088
    | LinuxSyscall.Fchmod -> 5089
    | LinuxSyscall.Chown -> 5090
    | LinuxSyscall.Fchown -> 5091
    | LinuxSyscall.Lchown -> 5092
    | LinuxSyscall.Umask -> 5093
    | LinuxSyscall.Gettimeofday -> 5094
    | LinuxSyscall.Getrlimit -> 5095
    | LinuxSyscall.Getrusage -> 5096
    | LinuxSyscall.Sysinfo -> 5097
    | LinuxSyscall.Times -> 5098
    | LinuxSyscall.Ptrace -> 5099
    | LinuxSyscall.Getuid -> 5100
    | LinuxSyscall.Syslog -> 5101
    | LinuxSyscall.Getgid -> 5102
    | LinuxSyscall.Setuid -> 5103
    | LinuxSyscall.Setgid -> 5104
    | LinuxSyscall.Geteuid -> 5105
    | LinuxSyscall.Getegid -> 5106
    | LinuxSyscall.Setpgid -> 5107
    | LinuxSyscall.Getppid -> 5108
    | LinuxSyscall.Getpgrp -> 5109
    | LinuxSyscall.Setsid -> 5110
    | LinuxSyscall.Setreuid -> 5111
    | LinuxSyscall.Setregid -> 5112
    | LinuxSyscall.Getgroups -> 5113
    | LinuxSyscall.Setgroups -> 5114
    | LinuxSyscall.Setresuid -> 5115
    | LinuxSyscall.Getresuid -> 5116
    | LinuxSyscall.Setresgid -> 5117
    | LinuxSyscall.Getresgid -> 5118
    | LinuxSyscall.Getpgid -> 5119
    | LinuxSyscall.Setfsuid -> 5120
    | LinuxSyscall.Setfsgid -> 5121
    | LinuxSyscall.Getsid -> 5122
    | LinuxSyscall.CapGet -> 5123
    | LinuxSyscall.CapSet -> 5124
    | LinuxSyscall.RtSigpending -> 5125
    | LinuxSyscall.RtSigtimedwait -> 5126
    | LinuxSyscall.RtSigqueueinfo -> 5127
    | LinuxSyscall.RtSigsuspend -> 5128
    | LinuxSyscall.Sigaltstack -> 5129
    | LinuxSyscall.Utime -> 5130
    | LinuxSyscall.Mknod -> 5131
    | LinuxSyscall.Personality -> 5132
    | LinuxSyscall.Ustat -> 5133
    | LinuxSyscall.Statfs -> 5134
    | LinuxSyscall.Fstatfs -> 5135
    | LinuxSyscall.Sysfs -> 5136
    | LinuxSyscall.Getpriority -> 5137
    | LinuxSyscall.Setpriority -> 5138
    | LinuxSyscall.SchedSetparam -> 5139
    | LinuxSyscall.SchedGetparam -> 5140
    | LinuxSyscall.SchedSetscheduler -> 5141
    | LinuxSyscall.SchedGetscheduler -> 5142
    | LinuxSyscall.SchedGetPriorityMax -> 5143
    | LinuxSyscall.SchedGetPriorityMin -> 5144
    | LinuxSyscall.SchedRrGetInterval -> 5145
    | LinuxSyscall.Mlock -> 5146
    | LinuxSyscall.Munlock -> 5147
    | LinuxSyscall.Mlockall -> 5148
    | LinuxSyscall.Munlockall -> 5149
    | LinuxSyscall.Vhangup -> 5150
    | LinuxSyscall.PivotRoot -> 5151
    | LinuxSyscall.Sysctl -> 5152
    | LinuxSyscall.Prctl -> 5153
    | LinuxSyscall.AdjTimex -> 5154
    | LinuxSyscall.Setrlimit -> 5155
    | LinuxSyscall.Chroot -> 5156
    | LinuxSyscall.Sync -> 5157
    | LinuxSyscall.Acct -> 5158
    | LinuxSyscall.Settimeofday -> 5159
    | LinuxSyscall.Mount -> 5160
    | LinuxSyscall.Umount2 -> 5161
    | LinuxSyscall.Swapon -> 5162
    | LinuxSyscall.Swapoff -> 5163
    | LinuxSyscall.Reboot -> 5164
    | LinuxSyscall.Sethostname -> 5165
    | LinuxSyscall.Setdomainname -> 5166
    | LinuxSyscall.CreateModule -> 5167
    | LinuxSyscall.InitModule -> 5168
    | LinuxSyscall.DeleteModule -> 5169
    | LinuxSyscall.GetKernelSyms -> 5170
    | LinuxSyscall.QueryModule -> 5171
    | LinuxSyscall.Quotactl -> 5172
    | LinuxSyscall.Nfsservctl -> 5173
    | LinuxSyscall.Gettid -> 5178
    | LinuxSyscall.Readahead -> 5179
    | LinuxSyscall.Setxattr -> 5180
    | LinuxSyscall.Lsetxattr -> 5181
    | LinuxSyscall.Fsetxattr -> 5182
    | LinuxSyscall.Getxattr -> 5183
    | LinuxSyscall.Lgetxattr -> 5184
    | LinuxSyscall.Fgetxattr -> 5185
    | LinuxSyscall.Listxattr -> 5186
    | LinuxSyscall.Llistxattr -> 5187
    | LinuxSyscall.Flistxattr -> 5188
    | LinuxSyscall.Removexattr -> 5189
    | LinuxSyscall.Lremovexattr -> 5190
    | LinuxSyscall.Fremovexattr -> 5191
    | LinuxSyscall.Tkill -> 5192
    | LinuxSyscall.Futex -> 5194
    | LinuxSyscall.SchedSetaffinity -> 5195
    | LinuxSyscall.SchedGetaffinity -> 5196
    | LinuxSyscall.CacheFlush -> 5197
    | LinuxSyscall.CacheCtl -> 5198
    | LinuxSyscall.Sysmips -> 5199
    | LinuxSyscall.IoSetup -> 5200
    | LinuxSyscall.IoDestroy -> 5201
    | LinuxSyscall.IoGetevents -> 5202
    | LinuxSyscall.IoSubmit -> 5203
    | LinuxSyscall.IoCancel -> 5204
    | LinuxSyscall.ExitGroup -> 5205
    | LinuxSyscall.LookupDcookie -> 5206
    | LinuxSyscall.EpollCreate -> 5207
    | LinuxSyscall.EpollCtl -> 5208
    | LinuxSyscall.EpollWait -> 5209
    | LinuxSyscall.RemapFilePages -> 5210
    | LinuxSyscall.RtSigreturn -> 5211
    | LinuxSyscall.SetTidAddress -> 5212
    | LinuxSyscall.RestartSyscall -> 5213
    | LinuxSyscall.Semtimedop -> 5214
    | LinuxSyscall.Fadvise64 -> 5215
    | LinuxSyscall.TimerCreate -> 5216
    | LinuxSyscall.TimerSettime -> 5217
    | LinuxSyscall.TimerGettime -> 5218
    | LinuxSyscall.TimerGetoverrun -> 5219
    | LinuxSyscall.TimerDelete -> 5220
    | LinuxSyscall.ClockSettime -> 5221
    | LinuxSyscall.ClockGettime -> 5222
    | LinuxSyscall.ClockGetres -> 5223
    | LinuxSyscall.ClockNanosleep -> 5224
    | LinuxSyscall.Tgkill -> 5225
    | LinuxSyscall.Utimes -> 5226
    | LinuxSyscall.Mbind -> 5227
    | LinuxSyscall.GetMempolicy -> 5228
    | LinuxSyscall.SetMempolicy -> 5229
    | LinuxSyscall.MqOpen -> 5230
    | LinuxSyscall.MqUnlink -> 5231
    | LinuxSyscall.MqTimedsend -> 5232
    | LinuxSyscall.MqTimedreceive -> 5233
    | LinuxSyscall.MqNotify -> 5234
    | LinuxSyscall.MqGetsetattr -> 5235
    | LinuxSyscall.Vserver -> 5236
    | LinuxSyscall.Waitid -> 5237
    | LinuxSyscall.AddKey -> 5239
    | LinuxSyscall.RequestKey -> 5240
    | LinuxSyscall.Keyctl -> 5241
    | LinuxSyscall.SetThreadArea -> 5242
    | LinuxSyscall.InotifyInit -> 5243
    | LinuxSyscall.InotifyAddWatch -> 5244
    | LinuxSyscall.InotifyRmWatch -> 5245
    | LinuxSyscall.MigratePages -> 5246
    | LinuxSyscall.Openat -> 5247
    | LinuxSyscall.Mkdirat -> 5248
    | LinuxSyscall.Mknodat -> 5249
    | LinuxSyscall.Fchownat -> 5250
    | LinuxSyscall.Futimesat -> 5251
    | LinuxSyscall.Newfstatat -> 5252
    | LinuxSyscall.Unlinkat -> 5253
    | LinuxSyscall.Renameat -> 5254
    | LinuxSyscall.Linkat -> 5255
    | LinuxSyscall.Symlinkat -> 5256
    | LinuxSyscall.Readlinkat -> 5257
    | LinuxSyscall.Fchmodat -> 5258
    | LinuxSyscall.Faccessat -> 5259
    | LinuxSyscall.Pselect6 -> 5260
    | LinuxSyscall.Ppoll -> 5261
    | LinuxSyscall.Unshare -> 5262
    | LinuxSyscall.Splice -> 5263
    | LinuxSyscall.SyncFileRange -> 5264
    | LinuxSyscall.Tee -> 5265
    | LinuxSyscall.Vmsplice -> 5266
    | LinuxSyscall.MovePages -> 5267
    | LinuxSyscall.SetRobustList -> 5268
    | LinuxSyscall.GetRobustList -> 5269
    | LinuxSyscall.KexecLoad -> 5270
    | LinuxSyscall.Getcpu -> 5271
    | LinuxSyscall.EpollPwait -> 5272
    | LinuxSyscall.IoprioSet -> 5273
    | LinuxSyscall.IoprioGet -> 5274
    | LinuxSyscall.Utimensat -> 5275
    | LinuxSyscall.Signalfd -> 5276
    | LinuxSyscall.Timerfd -> 5277
    | LinuxSyscall.Eventfd -> 5278
    | LinuxSyscall.Fallocate -> 5279
    | LinuxSyscall.TimerfdCreate -> 5280
    | LinuxSyscall.TimerfdGettime -> 5281
    | LinuxSyscall.TimerfdSettime -> 5282
    | LinuxSyscall.Signalfd4 -> 5283
    | LinuxSyscall.Eventfd2 -> 5284
    | LinuxSyscall.EpollCreate1 -> 5285
    | LinuxSyscall.Dup3 -> 5286
    | LinuxSyscall.Pipe2 -> 5287
    | LinuxSyscall.InotifyInit1 -> 5288
    | LinuxSyscall.Preadv -> 5289
    | LinuxSyscall.Pwritev -> 5290
    | LinuxSyscall.RtTgsigqueueinfo -> 5291
    | LinuxSyscall.PerfEventOpen -> 5292
    | LinuxSyscall.Accept4 -> 5293
    | LinuxSyscall.Recvmmsg -> 5294
    | LinuxSyscall.FanotifyInit -> 5295
    | LinuxSyscall.FanotifyMark -> 5296
    | LinuxSyscall.Prlimit64 -> 5297
    | LinuxSyscall.NameToHandleAt -> 5298
    | LinuxSyscall.OpenByHandleAt -> 5299
    | LinuxSyscall.ClockAdjtime -> 5300
    | LinuxSyscall.Syncfs -> 5301
    | LinuxSyscall.Sendmmsg -> 5302
    | LinuxSyscall.Setns -> 5303
    | LinuxSyscall.ProcessVmReadv -> 5304
    | LinuxSyscall.ProcessVmWritev -> 5305
    | LinuxSyscall.Kcmp -> 5306
    | LinuxSyscall.FinitModule -> 5307
    | LinuxSyscall.Getdents64 -> 5308
    | LinuxSyscall.SchedSetattr -> 5309
    | LinuxSyscall.SchedGetattr -> 5310
    | LinuxSyscall.Renameat2 -> 5311
    | LinuxSyscall.Seccomp -> 5312
    | LinuxSyscall.Getrandom -> 5313
    | LinuxSyscall.MemfdCreate -> 5314
    | LinuxSyscall.Bpf -> 5315
    | LinuxSyscall.Execveat -> 5316
    | LinuxSyscall.Userfaultfd -> 5317
    | LinuxSyscall.Membarrier -> 5318
    | LinuxSyscall.Mlock2 -> 5319
    | LinuxSyscall.CopyFileRange -> 5320
    | LinuxSyscall.Preadv2 -> 5321
    | LinuxSyscall.Pwritev2 -> 5322
    | LinuxSyscall.PkeyMprotect -> 5323
    | LinuxSyscall.PkeyAlloc -> 5324
    | LinuxSyscall.PkeyFree -> 5325
    | LinuxSyscall.Statx -> 5326
    | LinuxSyscall.Rseq -> 5327
    | LinuxSyscall.IoPgetevents -> 5328
    | LinuxSyscall.PidfdSendSignal -> 5424
    | LinuxSyscall.IoUringSetup -> 5425
    | LinuxSyscall.IoUringEnter -> 5426
    | LinuxSyscall.IoUringRegister -> 5427
    | LinuxSyscall.OpenTree -> 5428
    | LinuxSyscall.MoveMount -> 5429
    | LinuxSyscall.Fsopen -> 5430
    | LinuxSyscall.Fsconfig -> 5431
    | LinuxSyscall.Fsmount -> 5432
    | LinuxSyscall.Fspick -> 5433
    | LinuxSyscall.PidfdOpen -> 5434
    | LinuxSyscall.Clone3 -> 5435
    | LinuxSyscall.CloseRange -> 5436
    | LinuxSyscall.Openat2 -> 5437
    | LinuxSyscall.PidfdGetfd -> 5438
    | _ -> raise UnhandledSyscallException

  let private getPPC32Number = function
    | LinuxSyscall.RestartSyscall -> 0
    | LinuxSyscall.Exit -> 1
    | LinuxSyscall.Fork -> 2
    | LinuxSyscall.Read -> 3
    | LinuxSyscall.Write -> 4
    | LinuxSyscall.Open -> 5
    | LinuxSyscall.Close -> 6
    | LinuxSyscall.Waitpid -> 7
    | LinuxSyscall.Creat -> 8
    | LinuxSyscall.Link -> 9
    | LinuxSyscall.Unlink -> 10
    | LinuxSyscall.Execve -> 11
    | LinuxSyscall.Chdir -> 12
    | LinuxSyscall.Time -> 13
    | LinuxSyscall.Mknod -> 14
    | LinuxSyscall.Chmod -> 15
    | LinuxSyscall.Lchown -> 16
    | LinuxSyscall.Oldstat -> 18
    | LinuxSyscall.Lseek -> 19
    | LinuxSyscall.Getpid -> 20
    | LinuxSyscall.Mount -> 21
    | LinuxSyscall.Umount -> 22
    | LinuxSyscall.Setuid -> 23
    | LinuxSyscall.Getuid -> 24
    | LinuxSyscall.Stime -> 25
    | LinuxSyscall.Ptrace -> 26
    | LinuxSyscall.Alarm -> 27
    | LinuxSyscall.Oldfstat -> 28
    | LinuxSyscall.Pause -> 29
    | LinuxSyscall.Utime -> 30
    | LinuxSyscall.Access -> 33
    | LinuxSyscall.Nice -> 34
    | LinuxSyscall.Sync -> 36
    | LinuxSyscall.Kill -> 37
    | LinuxSyscall.Rename -> 38
    | LinuxSyscall.Mkdir -> 39
    | LinuxSyscall.Rmdir -> 40
    | LinuxSyscall.Dup -> 41
    | LinuxSyscall.Pipe -> 42
    | LinuxSyscall.Times -> 43
    | LinuxSyscall.Brk -> 45
    | LinuxSyscall.Setgid -> 46
    | LinuxSyscall.Getgid -> 47
    | LinuxSyscall.Signal -> 48
    | LinuxSyscall.Geteuid -> 49
    | LinuxSyscall.Getegid -> 50
    | LinuxSyscall.Acct -> 51
    | LinuxSyscall.Umount2 -> 52
    | LinuxSyscall.Ioctl -> 54
    | LinuxSyscall.Fcntl -> 55
    | LinuxSyscall.Setpgid -> 57
    | LinuxSyscall.Oldolduname -> 59
    | LinuxSyscall.Umask -> 60
    | LinuxSyscall.Chroot -> 61
    | LinuxSyscall.Ustat -> 62
    | LinuxSyscall.Dup2 -> 63
    | LinuxSyscall.Getppid -> 64
    | LinuxSyscall.Getpgrp -> 65
    | LinuxSyscall.Setsid -> 66
    | LinuxSyscall.Sigaction -> 67
    | LinuxSyscall.Sgetmask -> 68
    | LinuxSyscall.Ssetmask -> 69
    | LinuxSyscall.Setreuid -> 70
    | LinuxSyscall.Setregid -> 71
    | LinuxSyscall.Sigsuspend -> 72
    | LinuxSyscall.Sigpending -> 73
    | LinuxSyscall.Sethostname -> 74
    | LinuxSyscall.Setrlimit -> 75
    | LinuxSyscall.Getrlimit -> 76
    | LinuxSyscall.Getrusage -> 77
    | LinuxSyscall.Gettimeofday -> 78
    | LinuxSyscall.Settimeofday -> 79
    | LinuxSyscall.Getgroups -> 80
    | LinuxSyscall.Setgroups -> 81
    | LinuxSyscall.Select -> 82
    | LinuxSyscall.Symlink -> 83
    | LinuxSyscall.Oldlstat -> 84
    | LinuxSyscall.Readlink -> 85
    | LinuxSyscall.Uselib -> 86
    | LinuxSyscall.Swapon -> 87
    | LinuxSyscall.Reboot -> 88
    | LinuxSyscall.Readdir -> 89
    | LinuxSyscall.Mmap -> 90
    | LinuxSyscall.Munmap -> 91
    | LinuxSyscall.Truncate -> 92
    | LinuxSyscall.Ftruncate -> 93
    | LinuxSyscall.Fchmod -> 94
    | LinuxSyscall.Fchown -> 95
    | LinuxSyscall.Getpriority -> 96
    | LinuxSyscall.Setpriority -> 97
    | LinuxSyscall.Statfs -> 99
    | LinuxSyscall.Fstatfs -> 100
    | LinuxSyscall.Ioperm -> 101
    | LinuxSyscall.Socketcall -> 102
    | LinuxSyscall.Syslog -> 103
    | LinuxSyscall.Setitimer -> 104
    | LinuxSyscall.Getitimer -> 105
    | LinuxSyscall.Stat -> 106
    | LinuxSyscall.Lstat -> 107
    | LinuxSyscall.Fstat -> 108
    | LinuxSyscall.Olduname -> 109
    | LinuxSyscall.Iopl -> 110
    | LinuxSyscall.Vhangup -> 111
    | LinuxSyscall.Vm86 -> 113
    | LinuxSyscall.Wait4 -> 114
    | LinuxSyscall.Swapoff -> 115
    | LinuxSyscall.Sysinfo -> 116
    | LinuxSyscall.Ipc -> 117
    | LinuxSyscall.Fsync -> 118
    | LinuxSyscall.Sigreturn -> 119
    | LinuxSyscall.Clone -> 120
    | LinuxSyscall.Setdomainname -> 121
    | LinuxSyscall.Uname -> 122
    | LinuxSyscall.ModifyLdt -> 123
    | LinuxSyscall.AdjTimex -> 124
    | LinuxSyscall.Mprotect -> 125
    | LinuxSyscall.Sigprocmask -> 126
    | LinuxSyscall.CreateModule -> 127
    | LinuxSyscall.InitModule -> 128
    | LinuxSyscall.DeleteModule -> 129
    | LinuxSyscall.GetKernelSyms -> 130
    | LinuxSyscall.Quotactl -> 131
    | LinuxSyscall.Getpgid -> 132
    | LinuxSyscall.Fchdir -> 133
    | LinuxSyscall.Bdflush -> 134
    | LinuxSyscall.Sysfs -> 135
    | LinuxSyscall.Personality -> 136
    | LinuxSyscall.Setfsuid -> 138
    | LinuxSyscall.Setfsgid -> 139
    | LinuxSyscall.LLseek -> 140
    | LinuxSyscall.Getdents -> 141
    | LinuxSyscall.NewSelect -> 142
    | LinuxSyscall.Flock -> 143
    | LinuxSyscall.Msync -> 144
    | LinuxSyscall.Readv -> 145
    | LinuxSyscall.Writev -> 146
    | LinuxSyscall.Getsid -> 147
    | LinuxSyscall.Fdatasync -> 148
    | LinuxSyscall.Sysctl -> 149
    | LinuxSyscall.Mlock -> 150
    | LinuxSyscall.Munlock -> 151
    | LinuxSyscall.Mlockall -> 152
    | LinuxSyscall.Munlockall -> 153
    | LinuxSyscall.SchedSetparam -> 154
    | LinuxSyscall.SchedGetparam -> 155
    | LinuxSyscall.SchedSetscheduler -> 156
    | LinuxSyscall.SchedGetscheduler -> 157
    | LinuxSyscall.SchedYield -> 158
    | LinuxSyscall.SchedGetPriorityMax -> 159
    | LinuxSyscall.SchedGetPriorityMin -> 160
    | LinuxSyscall.SchedRrGetInterval -> 161
    | LinuxSyscall.Nanosleep -> 162
    | LinuxSyscall.Mremap -> 163
    | LinuxSyscall.Setresuid -> 164
    | LinuxSyscall.Getresuid -> 165
    | LinuxSyscall.QueryModule -> 166
    | LinuxSyscall.Poll -> 167
    | LinuxSyscall.Nfsservctl -> 168
    | LinuxSyscall.Setresgid -> 169
    | LinuxSyscall.Getresgid -> 170
    | LinuxSyscall.Prctl -> 171
    | LinuxSyscall.RtSigreturn -> 172
    | LinuxSyscall.RtSigaction -> 173
    | LinuxSyscall.RtSigprocmask -> 174
    | LinuxSyscall.RtSigpending -> 175
    | LinuxSyscall.RtSigtimedwait -> 176
    | LinuxSyscall.RtSigqueueinfo -> 177
    | LinuxSyscall.RtSigsuspend -> 178
    | LinuxSyscall.Pread64 -> 179
    | LinuxSyscall.Pwrite64 -> 180
    | LinuxSyscall.Chown -> 181
    | LinuxSyscall.Getcwd -> 182
    | LinuxSyscall.CapGet -> 183
    | LinuxSyscall.CapSet -> 184
    | LinuxSyscall.Sigaltstack -> 185
    | LinuxSyscall.Sendfile -> 186
    | LinuxSyscall.Vfork -> 189
    | LinuxSyscall.Ugetrlimit -> 190
    | LinuxSyscall.Readahead -> 191
    | LinuxSyscall.Mmap2 -> 192
    | LinuxSyscall.Truncate64 -> 193
    | LinuxSyscall.Ftruncate64 -> 194
    | LinuxSyscall.Stat64 -> 195
    | LinuxSyscall.Lstat64 -> 196
    | LinuxSyscall.Fstat64 -> 197
    | LinuxSyscall.PciconfigRead -> 198
    | LinuxSyscall.PciconfigWrite -> 199
    | LinuxSyscall.PciconfigIobase -> 200
    | LinuxSyscall.Getdents64 -> 202
    | LinuxSyscall.PivotRoot -> 203
    | LinuxSyscall.Fcntl64 -> 204
    | LinuxSyscall.Madvise -> 205
    | LinuxSyscall.Mincore -> 206
    | LinuxSyscall.Gettid -> 207
    | LinuxSyscall.Tkill -> 208
    | LinuxSyscall.Setxattr -> 209
    | LinuxSyscall.Lsetxattr -> 210
    | LinuxSyscall.Fsetxattr -> 211
    | LinuxSyscall.Getxattr -> 212
    | LinuxSyscall.Lgetxattr -> 213
    | LinuxSyscall.Fgetxattr -> 214
    | LinuxSyscall.Listxattr -> 215
    | LinuxSyscall.Llistxattr -> 216
    | LinuxSyscall.Flistxattr -> 217
    | LinuxSyscall.Removexattr -> 218
    | LinuxSyscall.Lremovexattr -> 219
    | LinuxSyscall.Fremovexattr -> 220
    | LinuxSyscall.Futex -> 221
    | LinuxSyscall.SchedSetaffinity -> 222
    | LinuxSyscall.SchedGetaffinity -> 223
    | LinuxSyscall.Sendfile64 -> 226
    | LinuxSyscall.IoSetup -> 227
    | LinuxSyscall.IoDestroy -> 228
    | LinuxSyscall.IoGetevents -> 229
    | LinuxSyscall.IoSubmit -> 230
    | LinuxSyscall.IoCancel -> 231
    | LinuxSyscall.SetTidAddress -> 232
    | LinuxSyscall.Fadvise64 -> 233
    | LinuxSyscall.ExitGroup -> 234
    | LinuxSyscall.LookupDcookie -> 235
    | LinuxSyscall.EpollCreate -> 236
    | LinuxSyscall.EpollCtl -> 237
    | LinuxSyscall.EpollWait -> 238
    | LinuxSyscall.RemapFilePages -> 239
    | LinuxSyscall.TimerCreate -> 240
    | LinuxSyscall.TimerSettime -> 241
    | LinuxSyscall.TimerGettime -> 242
    | LinuxSyscall.TimerGetoverrun -> 243
    | LinuxSyscall.TimerDelete -> 244
    | LinuxSyscall.ClockSettime -> 245
    | LinuxSyscall.ClockGettime -> 246
    | LinuxSyscall.ClockGetres -> 247
    | LinuxSyscall.ClockNanosleep -> 248
    | LinuxSyscall.Swapcontext -> 249
    | LinuxSyscall.Tgkill -> 250
    | LinuxSyscall.Utimes -> 251
    | LinuxSyscall.Statfs64 -> 252
    | LinuxSyscall.Fstatfs64 -> 253
    | LinuxSyscall.Fadvise64_64 -> 254
    | LinuxSyscall.Rtas -> 255
    | LinuxSyscall.SysDebugSetcontext -> 256
    | LinuxSyscall.MigratePages -> 258
    | LinuxSyscall.Mbind -> 259
    | LinuxSyscall.GetMempolicy -> 260
    | LinuxSyscall.SetMempolicy -> 261
    | LinuxSyscall.MqOpen -> 262
    | LinuxSyscall.MqUnlink -> 263
    | LinuxSyscall.MqTimedsend -> 264
    | LinuxSyscall.MqTimedreceive -> 265
    | LinuxSyscall.MqNotify -> 266
    | LinuxSyscall.MqGetsetattr -> 267
    | LinuxSyscall.KexecLoad -> 268
    | LinuxSyscall.AddKey -> 269
    | LinuxSyscall.RequestKey -> 270
    | LinuxSyscall.Keyctl -> 271
    | LinuxSyscall.Waitid -> 272
    | LinuxSyscall.IoprioSet -> 273
    | LinuxSyscall.IoprioGet -> 274
    | LinuxSyscall.InotifyInit -> 275
    | LinuxSyscall.InotifyAddWatch -> 276
    | LinuxSyscall.InotifyRmWatch -> 277
    | LinuxSyscall.SpuRun -> 278
    | LinuxSyscall.SpuCreate -> 279
    | LinuxSyscall.Pselect6 -> 280
    | LinuxSyscall.Ppoll -> 281
    | LinuxSyscall.Unshare -> 282
    | LinuxSyscall.Splice -> 283
    | LinuxSyscall.Tee -> 284
    | LinuxSyscall.Vmsplice -> 285
    | LinuxSyscall.Openat -> 286
    | LinuxSyscall.Mkdirat -> 287
    | LinuxSyscall.Mknodat -> 288
    | LinuxSyscall.Fchownat -> 289
    | LinuxSyscall.Futimesat -> 290
    | LinuxSyscall.Fstatat64 -> 291
    | LinuxSyscall.Unlinkat -> 292
    | LinuxSyscall.Renameat -> 293
    | LinuxSyscall.Linkat -> 294
    | LinuxSyscall.Symlinkat -> 295
    | LinuxSyscall.Readlinkat -> 296
    | LinuxSyscall.Fchmodat -> 297
    | LinuxSyscall.Faccessat -> 298
    | LinuxSyscall.GetRobustList -> 299
    | LinuxSyscall.SetRobustList -> 300
    | LinuxSyscall.MovePages -> 301
    | LinuxSyscall.Getcpu -> 302
    | LinuxSyscall.EpollPwait -> 303
    | LinuxSyscall.Utimensat -> 304
    | LinuxSyscall.Signalfd -> 305
    | LinuxSyscall.TimerfdCreate -> 306
    | LinuxSyscall.Eventfd -> 307
    | LinuxSyscall.SyncFileRange2 -> 308
    | LinuxSyscall.Fallocate -> 309
    | LinuxSyscall.SubpageProt -> 310
    | LinuxSyscall.TimerfdSettime -> 311
    | LinuxSyscall.TimerfdGettime -> 312
    | LinuxSyscall.Signalfd4 -> 313
    | LinuxSyscall.Eventfd2 -> 314
    | LinuxSyscall.EpollCreate1 -> 315
    | LinuxSyscall.Dup3 -> 316
    | LinuxSyscall.Pipe2 -> 317
    | LinuxSyscall.InotifyInit1 -> 318
    | LinuxSyscall.PerfEventOpen -> 319
    | LinuxSyscall.Preadv -> 320
    | LinuxSyscall.Pwritev -> 321
    | LinuxSyscall.RtTgsigqueueinfo -> 322
    | LinuxSyscall.FanotifyInit -> 323
    | LinuxSyscall.FanotifyMark -> 324
    | LinuxSyscall.Prlimit64 -> 325
    | LinuxSyscall.Socket -> 326
    | LinuxSyscall.Bind -> 327
    | LinuxSyscall.Connect -> 328
    | LinuxSyscall.Listen -> 329
    | LinuxSyscall.Accept -> 330
    | LinuxSyscall.Getsockname -> 331
    | LinuxSyscall.Getpeername -> 332
    | LinuxSyscall.Socketpair -> 333
    | LinuxSyscall.Send -> 334
    | LinuxSyscall.Sendto -> 335
    | LinuxSyscall.Recv -> 336
    | LinuxSyscall.Recvfrom -> 337
    | LinuxSyscall.Shutdown -> 338
    | LinuxSyscall.Setsockopt -> 339
    | LinuxSyscall.Getsockopt -> 340
    | LinuxSyscall.Sendmsg -> 341
    | LinuxSyscall.Recvmsg -> 342
    | LinuxSyscall.Recvmmsg -> 343
    | LinuxSyscall.Accept4 -> 344
    | LinuxSyscall.NameToHandleAt -> 345
    | LinuxSyscall.OpenByHandleAt -> 346
    | LinuxSyscall.ClockAdjtime -> 347
    | LinuxSyscall.Syncfs -> 348
    | LinuxSyscall.Sendmmsg -> 349
    | LinuxSyscall.Setns -> 350
    | LinuxSyscall.ProcessVmReadv -> 351
    | LinuxSyscall.ProcessVmWritev -> 352
    | LinuxSyscall.FinitModule -> 353
    | LinuxSyscall.Kcmp -> 354
    | LinuxSyscall.SchedSetattr -> 355
    | LinuxSyscall.SchedGetattr -> 356
    | LinuxSyscall.Renameat2 -> 357
    | LinuxSyscall.MemfdCreate -> 360
    | _ -> raise UnhandledSyscallException

  let private getRISCV64Number = function
    | LinuxSyscall.IoSetup -> 0
    | LinuxSyscall.IoDestroy -> 1
    | LinuxSyscall.IoSubmit -> 2
    | LinuxSyscall.IoCancel -> 3
    | LinuxSyscall.IoGetevents -> 4
    | LinuxSyscall.Setxattr -> 5
    | LinuxSyscall.Lsetxattr -> 6
    | LinuxSyscall.Fsetxattr -> 7
    | LinuxSyscall.Getxattr -> 8
    | LinuxSyscall.Lgetxattr -> 9
    | LinuxSyscall.Fgetxattr -> 10
    | LinuxSyscall.Listxattr -> 11
    | LinuxSyscall.Llistxattr -> 12
    | LinuxSyscall.Flistxattr -> 13
    | LinuxSyscall.Removexattr -> 14
    | LinuxSyscall.Lremovexattr -> 15
    | LinuxSyscall.Fremovexattr -> 16
    | LinuxSyscall.Getcwd -> 17
    | LinuxSyscall.LookupDcookie -> 18
    | LinuxSyscall.Eventfd2 -> 19
    | LinuxSyscall.EpollCreate1 -> 20
    | LinuxSyscall.EpollCtl -> 21
    | LinuxSyscall.EpollPwait -> 22
    | LinuxSyscall.Dup -> 23
    | LinuxSyscall.Dup3 -> 24
    | LinuxSyscall.Fcntl -> 25
    | LinuxSyscall.InotifyInit1 -> 26
    | LinuxSyscall.InotifyAddWatch -> 27
    | LinuxSyscall.InotifyRmWatch -> 28
    | LinuxSyscall.Ioctl -> 29
    | LinuxSyscall.IoprioSet -> 30
    | LinuxSyscall.IoprioGet -> 31
    | LinuxSyscall.Flock -> 32
    | LinuxSyscall.Mknodat -> 33
    | LinuxSyscall.Mkdirat -> 34
    | LinuxSyscall.Unlinkat -> 35
    | LinuxSyscall.Symlinkat -> 36
    | LinuxSyscall.Linkat -> 37
    | LinuxSyscall.Renameat -> 38
    | LinuxSyscall.Umount2 -> 39
    | LinuxSyscall.Mount -> 40
    | LinuxSyscall.PivotRoot -> 41
    | LinuxSyscall.Nfsservctl -> 42
    | LinuxSyscall.Statfs -> 43
    | LinuxSyscall.Fstatfs -> 44
    | LinuxSyscall.Truncate -> 45
    | LinuxSyscall.Ftruncate -> 46
    | LinuxSyscall.Fallocate -> 47
    | LinuxSyscall.Faccessat -> 48
    | LinuxSyscall.Chdir -> 49
    | LinuxSyscall.Fchdir -> 50
    | LinuxSyscall.Chroot -> 51
    | LinuxSyscall.Fchmod -> 52
    | LinuxSyscall.Fchmodat -> 53
    | LinuxSyscall.Fchownat -> 54
    | LinuxSyscall.Fchown -> 55
    | LinuxSyscall.Openat -> 56
    | LinuxSyscall.Close -> 57
    | LinuxSyscall.Vhangup -> 58
    | LinuxSyscall.Pipe2 -> 59
    | LinuxSyscall.Quotactl -> 60
    | LinuxSyscall.Getdents64 -> 61
    | LinuxSyscall.Lseek -> 62
    | LinuxSyscall.Read -> 63
    | LinuxSyscall.Write -> 64
    | LinuxSyscall.Readv -> 65
    | LinuxSyscall.Writev -> 66
    | LinuxSyscall.Pread64 -> 67
    | LinuxSyscall.Pwrite64 -> 68
    | LinuxSyscall.Preadv -> 69
    | LinuxSyscall.Pwritev -> 70
    | LinuxSyscall.Sendfile -> 71
    | LinuxSyscall.Pselect6 -> 72
    | LinuxSyscall.Ppoll -> 73
    | LinuxSyscall.Signalfd4 -> 74
    | LinuxSyscall.Vmsplice -> 75
    | LinuxSyscall.Splice -> 76
    | LinuxSyscall.Tee -> 77
    | LinuxSyscall.Readlinkat -> 78
    | LinuxSyscall.Fstatat64 -> 79
    | LinuxSyscall.Fstat -> 80
    | LinuxSyscall.Sync -> 81
    | LinuxSyscall.Fsync -> 82
    | LinuxSyscall.Fdatasync -> 83
    | LinuxSyscall.SyncFileRange -> 84
    | LinuxSyscall.TimerfdCreate -> 85
    | LinuxSyscall.TimerfdSettime -> 86
    | LinuxSyscall.TimerfdGettime -> 87
    | LinuxSyscall.Utimensat -> 88
    | LinuxSyscall.Acct -> 89
    | LinuxSyscall.CapGet -> 90
    | LinuxSyscall.CapSet -> 91
    | LinuxSyscall.Personality -> 92
    | LinuxSyscall.Exit -> 93
    | LinuxSyscall.ExitGroup -> 94
    | LinuxSyscall.Waitid -> 95
    | LinuxSyscall.SetTidAddress -> 96
    | LinuxSyscall.Unshare -> 97
    | LinuxSyscall.Futex -> 98
    | LinuxSyscall.SetRobustList -> 99
    | LinuxSyscall.GetRobustList -> 100
    | LinuxSyscall.Nanosleep -> 101
    | LinuxSyscall.Getitimer -> 102
    | LinuxSyscall.Setitimer -> 103
    | LinuxSyscall.KexecLoad -> 104
    | LinuxSyscall.InitModule -> 105
    | LinuxSyscall.DeleteModule -> 106
    | LinuxSyscall.TimerCreate -> 107
    | LinuxSyscall.TimerGettime -> 108
    | LinuxSyscall.TimerGetoverrun -> 109
    | LinuxSyscall.TimerSettime -> 110
    | LinuxSyscall.TimerDelete -> 111
    | LinuxSyscall.ClockSettime -> 112
    | LinuxSyscall.ClockGettime -> 113
    | LinuxSyscall.ClockGetres -> 114
    | LinuxSyscall.ClockNanosleep -> 115
    | LinuxSyscall.Syslog -> 116
    | LinuxSyscall.Ptrace -> 117
    | LinuxSyscall.SchedSetparam -> 118
    | LinuxSyscall.SchedSetscheduler -> 119
    | LinuxSyscall.SchedGetscheduler -> 120
    | LinuxSyscall.SchedGetparam -> 121
    | LinuxSyscall.SchedSetaffinity -> 122
    | LinuxSyscall.SchedGetaffinity -> 123
    | LinuxSyscall.SchedYield -> 124
    | LinuxSyscall.SchedGetPriorityMax -> 125
    | LinuxSyscall.SchedGetPriorityMin -> 126
    | LinuxSyscall.SchedRrGetInterval -> 127
    | LinuxSyscall.RestartSyscall -> 128
    | LinuxSyscall.Kill -> 129
    | LinuxSyscall.Tkill -> 130
    | LinuxSyscall.Tgkill -> 131
    | LinuxSyscall.Sigaltstack -> 132
    | LinuxSyscall.RtSigsuspend -> 133
    | LinuxSyscall.RtSigaction -> 134
    | LinuxSyscall.RtSigprocmask -> 135
    | LinuxSyscall.RtSigpending -> 136
    | LinuxSyscall.RtSigtimedwait -> 137
    | LinuxSyscall.RtSigqueueinfo -> 138
    | LinuxSyscall.RtSigreturn -> 139
    | LinuxSyscall.Setpriority -> 140
    | LinuxSyscall.Getpriority -> 141
    | LinuxSyscall.Reboot -> 142
    | LinuxSyscall.Setregid -> 143
    | LinuxSyscall.Setgid -> 144
    | LinuxSyscall.Setreuid -> 145
    | LinuxSyscall.Setuid -> 146
    | LinuxSyscall.Setresuid -> 147
    | LinuxSyscall.Getresuid -> 148
    | LinuxSyscall.Setresgid -> 149
    | LinuxSyscall.Getresgid -> 150
    | LinuxSyscall.Setfsuid -> 151
    | LinuxSyscall.Setfsgid -> 152
    | LinuxSyscall.Times -> 153
    | LinuxSyscall.Setpgid -> 154
    | LinuxSyscall.Getpgid -> 155
    | LinuxSyscall.Getsid -> 156
    | LinuxSyscall.Setsid -> 157
    | LinuxSyscall.Getgroups -> 158
    | LinuxSyscall.Setgroups -> 159
    | LinuxSyscall.Uname -> 160
    | LinuxSyscall.Sethostname -> 161
    | LinuxSyscall.Setdomainname -> 162
    | LinuxSyscall.Getrlimit -> 163
    | LinuxSyscall.Setrlimit -> 164
    | LinuxSyscall.Getrusage -> 165
    | LinuxSyscall.Umask -> 166
    | LinuxSyscall.Prctl -> 167
    | LinuxSyscall.Getcpu -> 168
    | LinuxSyscall.Gettimeofday -> 169
    | LinuxSyscall.Settimeofday -> 170
    | LinuxSyscall.AdjTimex -> 171
    | LinuxSyscall.Getpid -> 172
    | LinuxSyscall.Getppid -> 173
    | LinuxSyscall.Getuid -> 174
    | LinuxSyscall.Geteuid -> 175
    | LinuxSyscall.Getgid -> 176
    | LinuxSyscall.Getegid -> 177
    | LinuxSyscall.Gettid -> 178
    | LinuxSyscall.Sysinfo -> 179
    | LinuxSyscall.MqOpen -> 180
    | LinuxSyscall.MqUnlink -> 181
    | LinuxSyscall.MqTimedsend -> 182
    | LinuxSyscall.MqTimedreceive -> 183
    | LinuxSyscall.MqNotify -> 184
    | LinuxSyscall.MqGetsetattr -> 185
    | LinuxSyscall.Msgget -> 186
    | LinuxSyscall.Msgctl -> 187
    | LinuxSyscall.Msgrcv -> 188
    | LinuxSyscall.Msgsnd -> 189
    | LinuxSyscall.Semget -> 190
    | LinuxSyscall.Semctl -> 191
    | LinuxSyscall.Semtimedop -> 192
    | LinuxSyscall.Semop -> 193
    | LinuxSyscall.Shmget -> 194
    | LinuxSyscall.Shmctl -> 195
    | LinuxSyscall.Shmat -> 196
    | LinuxSyscall.Shmdt -> 197
    | LinuxSyscall.Socket -> 198
    | LinuxSyscall.Socketpair -> 199
    | LinuxSyscall.Bind -> 200
    | LinuxSyscall.Listen -> 201
    | LinuxSyscall.Accept -> 202
    | LinuxSyscall.Connect -> 203
    | LinuxSyscall.Getsockname -> 204
    | LinuxSyscall.Getpeername -> 205
    | LinuxSyscall.Sendto -> 206
    | LinuxSyscall.Recvfrom -> 207
    | LinuxSyscall.Setsockopt -> 208
    | LinuxSyscall.Getsockopt -> 209
    | LinuxSyscall.Shutdown -> 210
    | LinuxSyscall.Sendmsg -> 211
    | LinuxSyscall.Recvmsg -> 212
    | LinuxSyscall.Readahead -> 213
    | LinuxSyscall.Brk -> 214
    | LinuxSyscall.Munmap -> 215
    | LinuxSyscall.Mremap -> 216
    | LinuxSyscall.AddKey -> 217
    | LinuxSyscall.RequestKey -> 218
    | LinuxSyscall.Keyctl -> 219
    | LinuxSyscall.Clone -> 220
    | LinuxSyscall.Execve -> 221
    | LinuxSyscall.Mmap -> 222
    | LinuxSyscall.Fadvise64 -> 223
    | LinuxSyscall.Swapon -> 224
    | LinuxSyscall.Swapoff -> 225
    | LinuxSyscall.Mprotect -> 226
    | LinuxSyscall.Msync -> 227
    | LinuxSyscall.Mlock -> 228
    | LinuxSyscall.Munlock -> 229
    | LinuxSyscall.Mlockall -> 230
    | LinuxSyscall.Munlockall -> 231
    | LinuxSyscall.Mincore -> 232
    | LinuxSyscall.Madvise -> 233
    | LinuxSyscall.RemapFilePages -> 234
    | LinuxSyscall.Mbind -> 235
    | LinuxSyscall.GetMempolicy -> 236
    | LinuxSyscall.SetMempolicy -> 237
    | LinuxSyscall.MigratePages -> 238
    | LinuxSyscall.MovePages -> 239
    | LinuxSyscall.RtTgsigqueueinfo -> 240
    | LinuxSyscall.PerfEventOpen -> 241
    | LinuxSyscall.Accept4 -> 242
    | LinuxSyscall.Recvmmsg -> 243
    | LinuxSyscall.Wait4 -> 260
    | LinuxSyscall.Prlimit64 -> 261
    | LinuxSyscall.FanotifyInit -> 262
    | LinuxSyscall.FanotifyMark -> 263
    | LinuxSyscall.NameToHandleAt -> 264
    | LinuxSyscall.OpenByHandleAt -> 265
    | LinuxSyscall.ClockAdjtime -> 266
    | LinuxSyscall.Syncfs -> 267
    | LinuxSyscall.Setns -> 268
    | LinuxSyscall.Sendmmsg -> 269
    | LinuxSyscall.ProcessVmReadv -> 270
    | LinuxSyscall.ProcessVmWritev -> 271
    | LinuxSyscall.Kcmp -> 272
    | LinuxSyscall.FinitModule -> 273
    | LinuxSyscall.SchedSetattr -> 274
    | LinuxSyscall.SchedGetattr -> 275
    | LinuxSyscall.Renameat2 -> 276
    | LinuxSyscall.Seccomp -> 277
    | LinuxSyscall.Getrandom -> 278
    | LinuxSyscall.MemfdCreate -> 279
    | LinuxSyscall.Bpf -> 280
    | LinuxSyscall.Execveat -> 281
    | LinuxSyscall.Userfaultfd -> 282
    | LinuxSyscall.Membarrier -> 283
    | LinuxSyscall.Mlock2 -> 284
    | LinuxSyscall.CopyFileRange -> 285
    | LinuxSyscall.Preadv2 -> 286
    | LinuxSyscall.Pwritev2 -> 287
    | LinuxSyscall.PkeyMprotect -> 288
    | LinuxSyscall.PkeyAlloc -> 289
    | LinuxSyscall.PkeyFree -> 290
    | LinuxSyscall.Statx -> 291
    | LinuxSyscall.IoPgetevents -> 292
    | LinuxSyscall.Rseq -> 293
    | LinuxSyscall.KexecFileLoad -> 294
    | LinuxSyscall.ClockGettime64 -> 403
    | LinuxSyscall.ClockSettime64 -> 404
    | LinuxSyscall.ClockAdjtime64 -> 405
    | LinuxSyscall.ClockGetres64 -> 406
    | LinuxSyscall.ClockNanosleep64 -> 407
    | LinuxSyscall.TimerGettime64 -> 408
    | LinuxSyscall.TimerSettime64 -> 409
    | LinuxSyscall.TimerfdGettime64 -> 410
    | LinuxSyscall.TimerfdSettime64 -> 411
    | LinuxSyscall.Utimensat64 -> 412
    | LinuxSyscall.Pselect6_64 -> 413
    | LinuxSyscall.Ppoll64 -> 414
    | LinuxSyscall.IoPgetevents64 -> 416
    | LinuxSyscall.Recvmmsg64 -> 417
    | LinuxSyscall.MqTimedsend64 -> 418
    | LinuxSyscall.MqTimedreceive64 -> 419
    | LinuxSyscall.Semtimedop64 -> 420
    | LinuxSyscall.RtSigtimedwait64 -> 421
    | LinuxSyscall.Futex64 -> 422
    | LinuxSyscall.SchedRrGetInterval64 -> 423
    | LinuxSyscall.PidfdSendSignal -> 424
    | LinuxSyscall.IoUringSetup -> 425
    | LinuxSyscall.IoUringEnter -> 426
    | LinuxSyscall.IoUringRegister -> 427
    | LinuxSyscall.OpenTree -> 428
    | LinuxSyscall.MoveMount -> 429
    | LinuxSyscall.Fsopen -> 430
    | LinuxSyscall.Fsconfig -> 431
    | LinuxSyscall.Fsmount -> 432
    | LinuxSyscall.Fspick -> 433
    | LinuxSyscall.PidfdOpen -> 434
    | LinuxSyscall.Clone3 -> 435
    | LinuxSyscall.CloseRange -> 436
    | LinuxSyscall.Openat2 -> 437
    | LinuxSyscall.PidfdGetfd -> 438
    | LinuxSyscall.Faccessat2 -> 439
    | _ -> raise UnhandledSyscallException

  /// Gets the syscall number for the given syscall at the given architecture.
  [<CompiledName "ToNumber">]
  let toNumber arch syscall =
    match arch with
    | Architecture.IntelX86 -> getX86Number syscall
    | Architecture.IntelX64 -> getX64Number syscall
    | Architecture.ARMv7 | Architecture.AARCH32-> getARMEABINumber syscall
    | Architecture.AARCH64 -> getAARCH64Number syscall
    | Architecture.MIPS32 -> getMIPSO32Number syscall
    | Architecture.MIPS64 -> getMIPSN64Number syscall
    | Architecture.PPC32 -> getPPC32Number syscall
    | Architecture.RISCV64 -> getRISCV64Number syscall
    | _ -> raise UnhandledSyscallException

  let private getX86Syscall = function
    | 0 -> LinuxSyscall.RestartSyscall
    | 1 -> LinuxSyscall.Exit
    | 2 -> LinuxSyscall.Fork
    | 3 -> LinuxSyscall.Read
    | 4 -> LinuxSyscall.Write
    | 5 -> LinuxSyscall.Open
    | 6 -> LinuxSyscall.Close
    | 7 -> LinuxSyscall.Waitpid
    | 8 -> LinuxSyscall.Creat
    | 9 -> LinuxSyscall.Link
    | 10 -> LinuxSyscall.Unlink
    | 11 -> LinuxSyscall.Execve
    | 12 -> LinuxSyscall.Chdir
    | 13 -> LinuxSyscall.Time
    | 14 -> LinuxSyscall.Mknod
    | 15 -> LinuxSyscall.Chmod
    | 16 -> LinuxSyscall.Lchown
    | 18 -> LinuxSyscall.Oldstat
    | 19 -> LinuxSyscall.Lseek
    | 20 -> LinuxSyscall.Getpid
    | 21 -> LinuxSyscall.Mount
    | 22 -> LinuxSyscall.Umount
    | 23 -> LinuxSyscall.Setuid
    | 24 -> LinuxSyscall.Getuid
    | 25 -> LinuxSyscall.Stime
    | 26 -> LinuxSyscall.Ptrace
    | 27 -> LinuxSyscall.Alarm
    | 28 -> LinuxSyscall.Oldfstat
    | 29 -> LinuxSyscall.Pause
    | 30 -> LinuxSyscall.Utime
    | 33 -> LinuxSyscall.Access
    | 34 -> LinuxSyscall.Nice
    | 36 -> LinuxSyscall.Sync
    | 37 -> LinuxSyscall.Kill
    | 38 -> LinuxSyscall.Rename
    | 39 -> LinuxSyscall.Mkdir
    | 40 -> LinuxSyscall.Rmdir
    | 41 -> LinuxSyscall.Dup
    | 42 -> LinuxSyscall.Pipe
    | 43 -> LinuxSyscall.Times
    | 45 -> LinuxSyscall.Brk
    | 46 -> LinuxSyscall.Setgid
    | 47 -> LinuxSyscall.Getgid
    | 48 -> LinuxSyscall.Signal
    | 49 -> LinuxSyscall.Geteuid
    | 50 -> LinuxSyscall.Getegid
    | 51 -> LinuxSyscall.Acct
    | 52 -> LinuxSyscall.Umount2
    | 54 -> LinuxSyscall.Ioctl
    | 55 -> LinuxSyscall.Fcntl
    | 57 -> LinuxSyscall.Setpgid
    | 59 -> LinuxSyscall.Oldolduname
    | 60 -> LinuxSyscall.Umask
    | 61 -> LinuxSyscall.Chroot
    | 62 -> LinuxSyscall.Ustat
    | 63 -> LinuxSyscall.Dup2
    | 64 -> LinuxSyscall.Getppid
    | 65 -> LinuxSyscall.Getpgrp
    | 66 -> LinuxSyscall.Setsid
    | 67 -> LinuxSyscall.Sigaction
    | 68 -> LinuxSyscall.Sgetmask
    | 69 -> LinuxSyscall.Ssetmask
    | 70 -> LinuxSyscall.Setreuid
    | 71 -> LinuxSyscall.Setregid
    | 72 -> LinuxSyscall.Sigsuspend
    | 73 -> LinuxSyscall.Sigpending
    | 74 -> LinuxSyscall.Sethostname
    | 75 -> LinuxSyscall.Setrlimit
    | 76 -> LinuxSyscall.Getrlimit
    | 77 -> LinuxSyscall.Getrusage
    | 78 -> LinuxSyscall.Gettimeofday
    | 79 -> LinuxSyscall.Settimeofday
    | 80 -> LinuxSyscall.Getgroups
    | 81 -> LinuxSyscall.Setgroups
    | 82 -> LinuxSyscall.Select
    | 83 -> LinuxSyscall.Symlink
    | 84 -> LinuxSyscall.Oldlstat
    | 85 -> LinuxSyscall.Readlink
    | 86 -> LinuxSyscall.Uselib
    | 87 -> LinuxSyscall.Swapon
    | 88 -> LinuxSyscall.Reboot
    | 89 -> LinuxSyscall.Readdir
    | 90 -> LinuxSyscall.Mmap
    | 91 -> LinuxSyscall.Munmap
    | 92 -> LinuxSyscall.Truncate
    | 93 -> LinuxSyscall.Ftruncate
    | 94 -> LinuxSyscall.Fchmod
    | 95 -> LinuxSyscall.Fchown
    | 96 -> LinuxSyscall.Getpriority
    | 97 -> LinuxSyscall.Setpriority
    | 99 -> LinuxSyscall.Statfs
    | 100 -> LinuxSyscall.Fstatfs
    | 101 -> LinuxSyscall.Ioperm
    | 102 -> LinuxSyscall.Socketcall
    | 103 -> LinuxSyscall.Syslog
    | 104 -> LinuxSyscall.Setitimer
    | 105 -> LinuxSyscall.Getitimer
    | 106 -> LinuxSyscall.Stat
    | 107 -> LinuxSyscall.Lstat
    | 108 -> LinuxSyscall.Fstat
    | 109 -> LinuxSyscall.Olduname
    | 110 -> LinuxSyscall.Iopl
    | 111 -> LinuxSyscall.Vhangup
    | 113 -> LinuxSyscall.Vm86old
    | 114 -> LinuxSyscall.Wait4
    | 115 -> LinuxSyscall.Swapoff
    | 116 -> LinuxSyscall.Sysinfo
    | 117 -> LinuxSyscall.Ipc
    | 118 -> LinuxSyscall.Fsync
    | 119 -> LinuxSyscall.Sigreturn
    | 120 -> LinuxSyscall.Clone
    | 121 -> LinuxSyscall.Setdomainname
    | 122 -> LinuxSyscall.Uname
    | 123 -> LinuxSyscall.ModifyLdt
    | 124 -> LinuxSyscall.AdjTimex
    | 125 -> LinuxSyscall.Mprotect
    | 126 -> LinuxSyscall.Sigprocmask
    | 127 -> LinuxSyscall.CreateModule
    | 128 -> LinuxSyscall.InitModule
    | 129 -> LinuxSyscall.DeleteModule
    | 130 -> LinuxSyscall.GetKernelSyms
    | 131 -> LinuxSyscall.Quotactl
    | 132 -> LinuxSyscall.Getpgid
    | 133 -> LinuxSyscall.Fchdir
    | 134 -> LinuxSyscall.Bdflush
    | 135 -> LinuxSyscall.Sysfs
    | 136 -> LinuxSyscall.Personality
    | 138 -> LinuxSyscall.Setfsuid
    | 139 -> LinuxSyscall.Setfsgid
    | 140 -> LinuxSyscall.LLseek
    | 141 -> LinuxSyscall.Getdents
    | 142 -> LinuxSyscall.NewSelect
    | 143 -> LinuxSyscall.Flock
    | 144 -> LinuxSyscall.Msync
    | 145 -> LinuxSyscall.Readv
    | 146 -> LinuxSyscall.Writev
    | 147 -> LinuxSyscall.Getsid
    | 148 -> LinuxSyscall.Fdatasync
    | 149 -> LinuxSyscall.Sysctl
    | 150 -> LinuxSyscall.Mlock
    | 151 -> LinuxSyscall.Munlock
    | 152 -> LinuxSyscall.Mlockall
    | 153 -> LinuxSyscall.Munlockall
    | 154 -> LinuxSyscall.SchedSetparam
    | 155 -> LinuxSyscall.SchedGetparam
    | 156 -> LinuxSyscall.SchedSetscheduler
    | 157 -> LinuxSyscall.SchedGetscheduler
    | 158 -> LinuxSyscall.SchedYield
    | 159 -> LinuxSyscall.SchedGetPriorityMax
    | 160 -> LinuxSyscall.SchedGetPriorityMin
    | 161 -> LinuxSyscall.SchedRrGetInterval
    | 162 -> LinuxSyscall.Nanosleep
    | 163 -> LinuxSyscall.Mremap
    | 164 -> LinuxSyscall.Setresuid
    | 165 -> LinuxSyscall.Getresuid
    | 166 -> LinuxSyscall.Vm86
    | 167 -> LinuxSyscall.QueryModule
    | 168 -> LinuxSyscall.Poll
    | 169 -> LinuxSyscall.Nfsservctl
    | 170 -> LinuxSyscall.Setresgid
    | 171 -> LinuxSyscall.Getresgid
    | 172 -> LinuxSyscall.Prctl
    | 173 -> LinuxSyscall.RtSigreturn
    | 174 -> LinuxSyscall.RtSigaction
    | 175 -> LinuxSyscall.RtSigprocmask
    | 176 -> LinuxSyscall.RtSigpending
    | 177 -> LinuxSyscall.RtSigtimedwait
    | 178 -> LinuxSyscall.RtSigqueueinfo
    | 179 -> LinuxSyscall.RtSigsuspend
    | 180 -> LinuxSyscall.Pread64
    | 181 -> LinuxSyscall.Pwrite64
    | 182 -> LinuxSyscall.Chown
    | 183 -> LinuxSyscall.Getcwd
    | 184 -> LinuxSyscall.CapGet
    | 185 -> LinuxSyscall.CapSet
    | 186 -> LinuxSyscall.Sigaltstack
    | 187 -> LinuxSyscall.Sendfile
    | 190 -> LinuxSyscall.Vfork
    | 191 -> LinuxSyscall.Ugetrlimit
    | 192 -> LinuxSyscall.Mmap2
    | 193 -> LinuxSyscall.Truncate64
    | 194 -> LinuxSyscall.Ftruncate64
    | 195 -> LinuxSyscall.Stat64
    | 196 -> LinuxSyscall.Lstat64
    | 197 -> LinuxSyscall.Fstat64
    | 198 -> LinuxSyscall.Lchown32
    | 199 -> LinuxSyscall.Getuid32
    | 200 -> LinuxSyscall.Getgid32
    | 201 -> LinuxSyscall.Geteuid32
    | 202 -> LinuxSyscall.Getegid32
    | 203 -> LinuxSyscall.Setreuid32
    | 204 -> LinuxSyscall.Setregid32
    | 205 -> LinuxSyscall.Getgroups32
    | 206 -> LinuxSyscall.Setgroups32
    | 207 -> LinuxSyscall.Fchown32
    | 208 -> LinuxSyscall.Setresuid32
    | 209 -> LinuxSyscall.Getresuid32
    | 210 -> LinuxSyscall.Setresgid32
    | 211 -> LinuxSyscall.Getresgid32
    | 212 -> LinuxSyscall.Chown32
    | 213 -> LinuxSyscall.Setuid32
    | 214 -> LinuxSyscall.Setgid32
    | 215 -> LinuxSyscall.Setfsuid32
    | 216 -> LinuxSyscall.Setfsgid32
    | 217 -> LinuxSyscall.PivotRoot
    | 218 -> LinuxSyscall.Mincore
    | 219 -> LinuxSyscall.Madvise
    | 220 -> LinuxSyscall.Getdents64
    | 221 -> LinuxSyscall.Fcntl64
    | 224 -> LinuxSyscall.Gettid
    | 225 -> LinuxSyscall.Readahead
    | 226 -> LinuxSyscall.Setxattr
    | 227 -> LinuxSyscall.Lsetxattr
    | 228 -> LinuxSyscall.Fsetxattr
    | 229 -> LinuxSyscall.Getxattr
    | 230 -> LinuxSyscall.Lgetxattr
    | 231 -> LinuxSyscall.Fgetxattr
    | 232 -> LinuxSyscall.Listxattr
    | 233 -> LinuxSyscall.Llistxattr
    | 234 -> LinuxSyscall.Flistxattr
    | 235 -> LinuxSyscall.Removexattr
    | 236 -> LinuxSyscall.Lremovexattr
    | 237 -> LinuxSyscall.Fremovexattr
    | 238 -> LinuxSyscall.Tkill
    | 239 -> LinuxSyscall.Sendfile64
    | 240 -> LinuxSyscall.Futex
    | 241 -> LinuxSyscall.SchedSetaffinity
    | 242 -> LinuxSyscall.SchedGetaffinity
    | 243 -> LinuxSyscall.SetThreadArea
    | 244 -> LinuxSyscall.GetThreadArea
    | 245 -> LinuxSyscall.IoSetup
    | 246 -> LinuxSyscall.IoDestroy
    | 247 -> LinuxSyscall.IoGetevents
    | 248 -> LinuxSyscall.IoSubmit
    | 249 -> LinuxSyscall.IoCancel
    | 250 -> LinuxSyscall.Fadvise64
    | 252 -> LinuxSyscall.ExitGroup
    | 253 -> LinuxSyscall.LookupDcookie
    | 254 -> LinuxSyscall.EpollCreate
    | 255 -> LinuxSyscall.EpollCtl
    | 256 -> LinuxSyscall.EpollWait
    | 257 -> LinuxSyscall.RemapFilePages
    | 258 -> LinuxSyscall.SetTidAddress
    | 259 -> LinuxSyscall.TimerCreate
    | 260 -> LinuxSyscall.TimerSettime
    | 261 -> LinuxSyscall.TimerGettime
    | 262 -> LinuxSyscall.TimerGetoverrun
    | 263 -> LinuxSyscall.TimerDelete
    | 264 -> LinuxSyscall.ClockSettime
    | 265 -> LinuxSyscall.ClockGettime
    | 266 -> LinuxSyscall.ClockGetres
    | 267 -> LinuxSyscall.ClockNanosleep
    | 268 -> LinuxSyscall.Statfs64
    | 269 -> LinuxSyscall.Fstatfs64
    | 270 -> LinuxSyscall.Tgkill
    | 271 -> LinuxSyscall.Utimes
    | 272 -> LinuxSyscall.Fadvise64_64
    | 273 -> LinuxSyscall.Vserver
    | 274 -> LinuxSyscall.Mbind
    | 275 -> LinuxSyscall.GetMempolicy
    | 276 -> LinuxSyscall.SetMempolicy
    | 277 -> LinuxSyscall.MqOpen
    | 278 -> LinuxSyscall.MqUnlink
    | 279 -> LinuxSyscall.MqTimedsend
    | 280 -> LinuxSyscall.MqTimedreceive
    | 281 -> LinuxSyscall.MqNotify
    | 282 -> LinuxSyscall.MqGetsetattr
    | 283 -> LinuxSyscall.KexecLoad
    | 284 -> LinuxSyscall.Waitid
    | 286 -> LinuxSyscall.AddKey
    | 287 -> LinuxSyscall.RequestKey
    | 288 -> LinuxSyscall.Keyctl
    | 289 -> LinuxSyscall.IoprioSet
    | 290 -> LinuxSyscall.IoprioGet
    | 291 -> LinuxSyscall.InotifyInit
    | 292 -> LinuxSyscall.InotifyAddWatch
    | 293 -> LinuxSyscall.InotifyRmWatch
    | 294 -> LinuxSyscall.MigratePages
    | 295 -> LinuxSyscall.Openat
    | 296 -> LinuxSyscall.Mkdirat
    | 297 -> LinuxSyscall.Mknodat
    | 298 -> LinuxSyscall.Fchownat
    | 299 -> LinuxSyscall.Futimesat
    | 300 -> LinuxSyscall.Fstatat64
    | 301 -> LinuxSyscall.Unlinkat
    | 302 -> LinuxSyscall.Renameat
    | 303 -> LinuxSyscall.Linkat
    | 304 -> LinuxSyscall.Symlinkat
    | 305 -> LinuxSyscall.Readlinkat
    | 306 -> LinuxSyscall.Fchmodat
    | 307 -> LinuxSyscall.Faccessat
    | 308 -> LinuxSyscall.Pselect6
    | 309 -> LinuxSyscall.Ppoll
    | 310 -> LinuxSyscall.Unshare
    | 311 -> LinuxSyscall.SetRobustList
    | 312 -> LinuxSyscall.GetRobustList
    | 313 -> LinuxSyscall.Splice
    | 314 -> LinuxSyscall.SyncFileRange
    | 315 -> LinuxSyscall.Tee
    | 316 -> LinuxSyscall.Vmsplice
    | 317 -> LinuxSyscall.MovePages
    | 318 -> LinuxSyscall.Getcpu
    | 319 -> LinuxSyscall.EpollPwait
    | 320 -> LinuxSyscall.Utimensat
    | 321 -> LinuxSyscall.Signalfd
    | 322 -> LinuxSyscall.TimerfdCreate
    | 323 -> LinuxSyscall.Eventfd
    | 324 -> LinuxSyscall.Fallocate
    | 325 -> LinuxSyscall.TimerfdSettime
    | 326 -> LinuxSyscall.TimerfdGettime
    | 327 -> LinuxSyscall.Signalfd4
    | 328 -> LinuxSyscall.Eventfd2
    | 329 -> LinuxSyscall.EpollCreate1
    | 330 -> LinuxSyscall.Dup3
    | 331 -> LinuxSyscall.Pipe2
    | 332 -> LinuxSyscall.InotifyInit1
    | 333 -> LinuxSyscall.Preadv
    | 334 -> LinuxSyscall.Pwritev
    | 335 -> LinuxSyscall.RtTgsigqueueinfo
    | 336 -> LinuxSyscall.PerfEventOpen
    | 337 -> LinuxSyscall.Recvmmsg
    | 338 -> LinuxSyscall.FanotifyInit
    | 339 -> LinuxSyscall.FanotifyMark
    | 340 -> LinuxSyscall.Prlimit64
    | 341 -> LinuxSyscall.NameToHandleAt
    | 342 -> LinuxSyscall.OpenByHandleAt
    | 343 -> LinuxSyscall.ClockAdjtime
    | 344 -> LinuxSyscall.Syncfs
    | 345 -> LinuxSyscall.Sendmmsg
    | 346 -> LinuxSyscall.Setns
    | 347 -> LinuxSyscall.ProcessVmReadv
    | 348 -> LinuxSyscall.ProcessVmWritev
    | 349 -> LinuxSyscall.Kcmp
    | 350 -> LinuxSyscall.FinitModule
    | 351 -> LinuxSyscall.SchedSetattr
    | 352 -> LinuxSyscall.SchedGetattr
    | 353 -> LinuxSyscall.Renameat2
    | 354 -> LinuxSyscall.Seccomp
    | 355 -> LinuxSyscall.Getrandom
    | 356 -> LinuxSyscall.MemfdCreate
    | 357 -> LinuxSyscall.Bpf
    | 358 -> LinuxSyscall.Execveat
    | 359 -> LinuxSyscall.Socket
    | 360 -> LinuxSyscall.Socketpair
    | 361 -> LinuxSyscall.Bind
    | 362 -> LinuxSyscall.Connect
    | 363 -> LinuxSyscall.Listen
    | 364 -> LinuxSyscall.Accept4
    | 365 -> LinuxSyscall.Getsockopt
    | 366 -> LinuxSyscall.Setsockopt
    | 367 -> LinuxSyscall.Getsockname
    | 368 -> LinuxSyscall.Getpeername
    | 369 -> LinuxSyscall.Sendto
    | 370 -> LinuxSyscall.Sendmsg
    | 371 -> LinuxSyscall.Recvfrom
    | 372 -> LinuxSyscall.Recvmsg
    | 373 -> LinuxSyscall.Shutdown
    | 374 -> LinuxSyscall.Userfaultfd
    | 375 -> LinuxSyscall.Membarrier
    | 376 -> LinuxSyscall.Mlock2
    | 377 -> LinuxSyscall.CopyFileRange
    | 378 -> LinuxSyscall.Preadv2
    | 379 -> LinuxSyscall.Pwritev2
    | 380 -> LinuxSyscall.PkeyMprotect
    | 381 -> LinuxSyscall.PkeyAlloc
    | 382 -> LinuxSyscall.PkeyFree
    | 383 -> LinuxSyscall.Statx
    | 384 -> LinuxSyscall.ArchPrctl
    | 385 -> LinuxSyscall.IoPgetevents
    | 386 -> LinuxSyscall.Rseq
    | 393 -> LinuxSyscall.Semget
    | 394 -> LinuxSyscall.Semctl
    | 395 -> LinuxSyscall.Shmget
    | 396 -> LinuxSyscall.Shmctl
    | 397 -> LinuxSyscall.Shmat
    | 398 -> LinuxSyscall.Shmdt
    | 399 -> LinuxSyscall.Msgget
    | 400 -> LinuxSyscall.Msgsnd
    | 401 -> LinuxSyscall.Msgrcv
    | 402 -> LinuxSyscall.Msgctl
    | 403 -> LinuxSyscall.ClockGettime64
    | 404 -> LinuxSyscall.ClockSettime64
    | 405 -> LinuxSyscall.ClockAdjtime64
    | 406 -> LinuxSyscall.ClockGetres64
    | 407 -> LinuxSyscall.ClockNanosleep64
    | 408 -> LinuxSyscall.TimerGettime64
    | 409 -> LinuxSyscall.TimerSettime64
    | 410 -> LinuxSyscall.TimerfdGettime64
    | 411 -> LinuxSyscall.TimerfdSettime64
    | 412 -> LinuxSyscall.Utimensat64
    | 413 -> LinuxSyscall.Pselect6_64
    | 414 -> LinuxSyscall.Ppoll64
    | 416 -> LinuxSyscall.IoPgetevents64
    | 417 -> LinuxSyscall.Recvmmsg64
    | 418 -> LinuxSyscall.MqTimedsend64
    | 419 -> LinuxSyscall.MqTimedreceive64
    | 420 -> LinuxSyscall.Semtimedop64
    | 421 -> LinuxSyscall.RtSigtimedwait64
    | 422 -> LinuxSyscall.Futex64
    | 423 -> LinuxSyscall.SchedRrGetInterval64
    | 424 -> LinuxSyscall.PidfdSendSignal
    | 425 -> LinuxSyscall.IoUringSetup
    | 426 -> LinuxSyscall.IoUringEnter
    | 427 -> LinuxSyscall.IoUringRegister
    | 428 -> LinuxSyscall.OpenTree
    | 429 -> LinuxSyscall.MoveMount
    | 430 -> LinuxSyscall.Fsopen
    | 431 -> LinuxSyscall.Fsconfig
    | 432 -> LinuxSyscall.Fsmount
    | 433 -> LinuxSyscall.Fspick
    | 434 -> LinuxSyscall.PidfdOpen
    | 435 -> LinuxSyscall.Clone3
    | _ -> raise UnhandledSyscallException

  let private getX64Syscall = function
    | 0 -> LinuxSyscall.Read
    | 1 -> LinuxSyscall.Write
    | 2 -> LinuxSyscall.Open
    | 3 -> LinuxSyscall.Close
    | 4 -> LinuxSyscall.Stat
    | 5 -> LinuxSyscall.Fstat
    | 6 -> LinuxSyscall.Lstat
    | 7 -> LinuxSyscall.Poll
    | 8 -> LinuxSyscall.Lseek
    | 9 -> LinuxSyscall.Mmap
    | 10 -> LinuxSyscall.Mprotect
    | 11 -> LinuxSyscall.Munmap
    | 12 -> LinuxSyscall.Brk
    | 13 -> LinuxSyscall.RtSigaction
    | 14 -> LinuxSyscall.RtSigprocmask
    | 15 -> LinuxSyscall.RtSigreturn
    | 16 -> LinuxSyscall.Ioctl
    | 17 -> LinuxSyscall.Pread64
    | 18 -> LinuxSyscall.Pwrite64
    | 19 -> LinuxSyscall.Readv
    | 20 -> LinuxSyscall.Writev
    | 21 -> LinuxSyscall.Access
    | 22 -> LinuxSyscall.Pipe
    | 23 -> LinuxSyscall.Select
    | 24 -> LinuxSyscall.SchedYield
    | 25 -> LinuxSyscall.Mremap
    | 26 -> LinuxSyscall.Msync
    | 27 -> LinuxSyscall.Mincore
    | 28 -> LinuxSyscall.Madvise
    | 29 -> LinuxSyscall.Shmget
    | 30 -> LinuxSyscall.Shmat
    | 31 -> LinuxSyscall.Shmctl
    | 32 -> LinuxSyscall.Dup
    | 33 -> LinuxSyscall.Dup2
    | 34 -> LinuxSyscall.Pause
    | 35 -> LinuxSyscall.Nanosleep
    | 36 -> LinuxSyscall.Getitimer
    | 37 -> LinuxSyscall.Alarm
    | 38 -> LinuxSyscall.Setitimer
    | 39 -> LinuxSyscall.Getpid
    | 40 -> LinuxSyscall.Sendfile
    | 41 -> LinuxSyscall.Socket
    | 42 -> LinuxSyscall.Connect
    | 43 -> LinuxSyscall.Accept
    | 44 -> LinuxSyscall.Sendto
    | 45 -> LinuxSyscall.Recvfrom
    | 46 -> LinuxSyscall.Sendmsg
    | 47 -> LinuxSyscall.Recvmsg
    | 48 -> LinuxSyscall.Shutdown
    | 49 -> LinuxSyscall.Bind
    | 50 -> LinuxSyscall.Listen
    | 51 -> LinuxSyscall.Getsockname
    | 52 -> LinuxSyscall.Getpeername
    | 53 -> LinuxSyscall.Socketpair
    | 54 -> LinuxSyscall.Setsockopt
    | 55 -> LinuxSyscall.Getsockopt
    | 56 -> LinuxSyscall.Clone
    | 57 -> LinuxSyscall.Fork
    | 58 -> LinuxSyscall.Vfork
    | 59 -> LinuxSyscall.Execve
    | 60 -> LinuxSyscall.Exit
    | 61 -> LinuxSyscall.Wait4
    | 62 -> LinuxSyscall.Kill
    | 63 -> LinuxSyscall.Uname
    | 64 -> LinuxSyscall.Semget
    | 65 -> LinuxSyscall.Semop
    | 66 -> LinuxSyscall.Semctl
    | 67 -> LinuxSyscall.Shmdt
    | 68 -> LinuxSyscall.Msgget
    | 69 -> LinuxSyscall.Msgsnd
    | 70 -> LinuxSyscall.Msgrcv
    | 71 -> LinuxSyscall.Msgctl
    | 72 -> LinuxSyscall.Fcntl
    | 73 -> LinuxSyscall.Flock
    | 74 -> LinuxSyscall.Fsync
    | 75 -> LinuxSyscall.Fdatasync
    | 76 -> LinuxSyscall.Truncate
    | 77 -> LinuxSyscall.Ftruncate
    | 78 -> LinuxSyscall.Getdents
    | 79 -> LinuxSyscall.Getcwd
    | 80 -> LinuxSyscall.Chdir
    | 81 -> LinuxSyscall.Fchdir
    | 82 -> LinuxSyscall.Rename
    | 83 -> LinuxSyscall.Mkdir
    | 84 -> LinuxSyscall.Rmdir
    | 85 -> LinuxSyscall.Creat
    | 86 -> LinuxSyscall.Link
    | 87 -> LinuxSyscall.Unlink
    | 88 -> LinuxSyscall.Symlink
    | 89 -> LinuxSyscall.Readlink
    | 90 -> LinuxSyscall.Chmod
    | 91 -> LinuxSyscall.Fchmod
    | 92 -> LinuxSyscall.Chown
    | 93 -> LinuxSyscall.Fchown
    | 94 -> LinuxSyscall.Lchown
    | 95 -> LinuxSyscall.Umask
    | 96 -> LinuxSyscall.Gettimeofday
    | 97 -> LinuxSyscall.Getrlimit
    | 98 -> LinuxSyscall.Getrusage
    | 99 -> LinuxSyscall.Sysinfo
    | 100 -> LinuxSyscall.Times
    | 101 -> LinuxSyscall.Ptrace
    | 102 -> LinuxSyscall.Getuid
    | 103 -> LinuxSyscall.Syslog
    | 104 -> LinuxSyscall.Getgid
    | 105 -> LinuxSyscall.Setuid
    | 106 -> LinuxSyscall.Setgid
    | 107 -> LinuxSyscall.Geteuid
    | 108 -> LinuxSyscall.Getegid
    | 109 -> LinuxSyscall.Setpgid
    | 110 -> LinuxSyscall.Getppid
    | 111 -> LinuxSyscall.Getpgrp
    | 112 -> LinuxSyscall.Setsid
    | 113 -> LinuxSyscall.Setreuid
    | 114 -> LinuxSyscall.Setregid
    | 115 -> LinuxSyscall.Getgroups
    | 116 -> LinuxSyscall.Setgroups
    | 117 -> LinuxSyscall.Setresuid
    | 118 -> LinuxSyscall.Getresuid
    | 119 -> LinuxSyscall.Setresgid
    | 120 -> LinuxSyscall.Getresgid
    | 121 -> LinuxSyscall.Getpgid
    | 122 -> LinuxSyscall.Setfsuid
    | 123 -> LinuxSyscall.Setfsgid
    | 124 -> LinuxSyscall.Getsid
    | 125 -> LinuxSyscall.CapGet
    | 126 -> LinuxSyscall.CapSet
    | 127 -> LinuxSyscall.RtSigpending
    | 128 -> LinuxSyscall.RtSigtimedwait
    | 129 -> LinuxSyscall.RtSigqueueinfo
    | 130 -> LinuxSyscall.RtSigsuspend
    | 131 -> LinuxSyscall.Sigaltstack
    | 132 -> LinuxSyscall.Utime
    | 133 -> LinuxSyscall.Mknod
    | 134 -> LinuxSyscall.Uselib
    | 135 -> LinuxSyscall.Personality
    | 136 -> LinuxSyscall.Ustat
    | 137 -> LinuxSyscall.Statfs
    | 138 -> LinuxSyscall.Fstatfs
    | 139 -> LinuxSyscall.Sysfs
    | 140 -> LinuxSyscall.Getpriority
    | 141 -> LinuxSyscall.Setpriority
    | 142 -> LinuxSyscall.SchedSetparam
    | 143 -> LinuxSyscall.SchedGetparam
    | 144 -> LinuxSyscall.SchedSetscheduler
    | 145 -> LinuxSyscall.SchedGetscheduler
    | 146 -> LinuxSyscall.SchedGetPriorityMax
    | 147 -> LinuxSyscall.SchedGetPriorityMin
    | 148 -> LinuxSyscall.SchedRrGetInterval
    | 149 -> LinuxSyscall.Mlock
    | 150 -> LinuxSyscall.Munlock
    | 151 -> LinuxSyscall.Mlockall
    | 152 -> LinuxSyscall.Munlockall
    | 153 -> LinuxSyscall.Vhangup
    | 154 -> LinuxSyscall.ModifyLdt
    | 155 -> LinuxSyscall.PivotRoot
    | 156 -> LinuxSyscall.Sysctl
    | 157 -> LinuxSyscall.Prctl
    | 158 -> LinuxSyscall.ArchPrctl
    | 159 -> LinuxSyscall.AdjTimex
    | 160 -> LinuxSyscall.Setrlimit
    | 161 -> LinuxSyscall.Chroot
    | 162 -> LinuxSyscall.Sync
    | 163 -> LinuxSyscall.Acct
    | 164 -> LinuxSyscall.Settimeofday
    | 165 -> LinuxSyscall.Mount
    | 166 -> LinuxSyscall.Umount2
    | 167 -> LinuxSyscall.Swapon
    | 168 -> LinuxSyscall.Swapoff
    | 169 -> LinuxSyscall.Reboot
    | 170 -> LinuxSyscall.Sethostname
    | 171 -> LinuxSyscall.Setdomainname
    | 172 -> LinuxSyscall.Iopl
    | 173 -> LinuxSyscall.Ioperm
    | 174 -> LinuxSyscall.CreateModule
    | 175 -> LinuxSyscall.InitModule
    | 176 -> LinuxSyscall.DeleteModule
    | 177 -> LinuxSyscall.GetKernelSyms
    | 178 -> LinuxSyscall.QueryModule
    | 179 -> LinuxSyscall.Quotactl
    | 180 -> LinuxSyscall.Nfsservctl
    | 186 -> LinuxSyscall.Gettid
    | 187 -> LinuxSyscall.Readahead
    | 188 -> LinuxSyscall.Setxattr
    | 189 -> LinuxSyscall.Lsetxattr
    | 190 -> LinuxSyscall.Fsetxattr
    | 191 -> LinuxSyscall.Getxattr
    | 192 -> LinuxSyscall.Lgetxattr
    | 193 -> LinuxSyscall.Fgetxattr
    | 194 -> LinuxSyscall.Listxattr
    | 195 -> LinuxSyscall.Llistxattr
    | 196 -> LinuxSyscall.Flistxattr
    | 197 -> LinuxSyscall.Removexattr
    | 198 -> LinuxSyscall.Lremovexattr
    | 199 -> LinuxSyscall.Fremovexattr
    | 200 -> LinuxSyscall.Tkill
    | 201 -> LinuxSyscall.Time
    | 202 -> LinuxSyscall.Futex
    | 203 -> LinuxSyscall.SchedSetaffinity
    | 204 -> LinuxSyscall.SchedGetaffinity
    | 205 -> LinuxSyscall.SetThreadArea
    | 206 -> LinuxSyscall.IoSetup
    | 207 -> LinuxSyscall.IoDestroy
    | 208 -> LinuxSyscall.IoGetevents
    | 209 -> LinuxSyscall.IoSubmit
    | 210 -> LinuxSyscall.IoCancel
    | 211 -> LinuxSyscall.GetThreadArea
    | 212 -> LinuxSyscall.LookupDcookie
    | 213 -> LinuxSyscall.EpollCreate
    | 216 -> LinuxSyscall.RemapFilePages
    | 217 -> LinuxSyscall.Getdents64
    | 218 -> LinuxSyscall.SetTidAddress
    | 219 -> LinuxSyscall.RestartSyscall
    | 220 -> LinuxSyscall.Semtimedop
    | 221 -> LinuxSyscall.Fadvise64
    | 222 -> LinuxSyscall.TimerCreate
    | 223 -> LinuxSyscall.TimerSettime
    | 224 -> LinuxSyscall.TimerGettime
    | 225 -> LinuxSyscall.TimerGetoverrun
    | 226 -> LinuxSyscall.TimerDelete
    | 227 -> LinuxSyscall.ClockSettime
    | 228 -> LinuxSyscall.ClockGettime
    | 229 -> LinuxSyscall.ClockGetres
    | 230 -> LinuxSyscall.ClockNanosleep
    | 231 -> LinuxSyscall.ExitGroup
    | 232 -> LinuxSyscall.EpollWait
    | 233 -> LinuxSyscall.EpollCtl
    | 234 -> LinuxSyscall.Tgkill
    | 235 -> LinuxSyscall.Utimes
    | 237 -> LinuxSyscall.Mbind
    | 238 -> LinuxSyscall.SetMempolicy
    | 239 -> LinuxSyscall.GetMempolicy
    | 240 -> LinuxSyscall.MqOpen
    | 241 -> LinuxSyscall.MqUnlink
    | 242 -> LinuxSyscall.MqTimedsend
    | 243 -> LinuxSyscall.MqTimedreceive
    | 244 -> LinuxSyscall.MqNotify
    | 245 -> LinuxSyscall.MqGetsetattr
    | 246 -> LinuxSyscall.KexecLoad
    | 247 -> LinuxSyscall.Waitid
    | 248 -> LinuxSyscall.AddKey
    | 249 -> LinuxSyscall.RequestKey
    | 250 -> LinuxSyscall.Keyctl
    | 251 -> LinuxSyscall.IoprioSet
    | 252 -> LinuxSyscall.IoprioGet
    | 253 -> LinuxSyscall.InotifyInit
    | 254 -> LinuxSyscall.InotifyAddWatch
    | 255 -> LinuxSyscall.InotifyRmWatch
    | 256 -> LinuxSyscall.MigratePages
    | 257 -> LinuxSyscall.Openat
    | 258 -> LinuxSyscall.Mkdirat
    | 259 -> LinuxSyscall.Mknodat
    | 260 -> LinuxSyscall.Fchownat
    | 261 -> LinuxSyscall.Futimesat
    | 262 -> LinuxSyscall.Newfstatat
    | 263 -> LinuxSyscall.Unlinkat
    | 264 -> LinuxSyscall.Renameat
    | 265 -> LinuxSyscall.Linkat
    | 266 -> LinuxSyscall.Symlinkat
    | 267 -> LinuxSyscall.Readlinkat
    | 268 -> LinuxSyscall.Fchmodat
    | 269 -> LinuxSyscall.Faccessat
    | 270 -> LinuxSyscall.Pselect6
    | 271 -> LinuxSyscall.Ppoll
    | 272 -> LinuxSyscall.Unshare
    | 273 -> LinuxSyscall.SetRobustList
    | 274 -> LinuxSyscall.GetRobustList
    | 275 -> LinuxSyscall.Splice
    | 276 -> LinuxSyscall.Tee
    | 277 -> LinuxSyscall.SyncFileRange
    | 278 -> LinuxSyscall.Vmsplice
    | 279 -> LinuxSyscall.MovePages
    | 280 -> LinuxSyscall.Utimensat
    | 281 -> LinuxSyscall.EpollPwait
    | 282 -> LinuxSyscall.Signalfd
    | 283 -> LinuxSyscall.TimerfdCreate
    | 284 -> LinuxSyscall.Eventfd
    | 285 -> LinuxSyscall.Fallocate
    | 286 -> LinuxSyscall.TimerfdSettime
    | 287 -> LinuxSyscall.TimerfdGettime
    | 288 -> LinuxSyscall.Accept4
    | 289 -> LinuxSyscall.Signalfd4
    | 290 -> LinuxSyscall.Eventfd2
    | 291 -> LinuxSyscall.EpollCreate1
    | 292 -> LinuxSyscall.Dup3
    | 293 -> LinuxSyscall.Pipe2
    | 294 -> LinuxSyscall.InotifyInit1
    | 295 -> LinuxSyscall.Preadv
    | 296 -> LinuxSyscall.Pwritev
    | 297 -> LinuxSyscall.RtTgsigqueueinfo
    | 298 -> LinuxSyscall.PerfEventOpen
    | 299 -> LinuxSyscall.Recvmmsg
    | 300 -> LinuxSyscall.FanotifyInit
    | 301 -> LinuxSyscall.FanotifyMark
    | 302 -> LinuxSyscall.Prlimit64
    | 303 -> LinuxSyscall.NameToHandleAt
    | 304 -> LinuxSyscall.OpenByHandleAt
    | 305 -> LinuxSyscall.ClockAdjtime
    | 306 -> LinuxSyscall.Syncfs
    | 307 -> LinuxSyscall.Sendmmsg
    | 308 -> LinuxSyscall.Setns
    | 309 -> LinuxSyscall.Getcpu
    | 310 -> LinuxSyscall.ProcessVmReadv
    | 311 -> LinuxSyscall.ProcessVmWritev
    | 312 -> LinuxSyscall.Kcmp
    | 313 -> LinuxSyscall.FinitModule
    | 314 -> LinuxSyscall.SchedSetattr
    | 315 -> LinuxSyscall.SchedGetattr
    | 316 -> LinuxSyscall.Renameat2
    | 317 -> LinuxSyscall.Seccomp
    | 318 -> LinuxSyscall.Getrandom
    | 319 -> LinuxSyscall.MemfdCreate
    | 320 -> LinuxSyscall.KexecFileLoad
    | 321 -> LinuxSyscall.Bpf
    | 322 -> LinuxSyscall.Execveat
    | 323 -> LinuxSyscall.Userfaultfd
    | 324 -> LinuxSyscall.Membarrier
    | 325 -> LinuxSyscall.Mlock2
    | 326 -> LinuxSyscall.CopyFileRange
    | 327 -> LinuxSyscall.Preadv2
    | 328 -> LinuxSyscall.Pwritev2
    | 329 -> LinuxSyscall.PkeyMprotect
    | 330 -> LinuxSyscall.PkeyAlloc
    | 331 -> LinuxSyscall.PkeyFree
    | 332 -> LinuxSyscall.Statx
    | 333 -> LinuxSyscall.IoPgetevents
    | 334 -> LinuxSyscall.Rseq
    | _ -> raise UnhandledSyscallException

  let private getARMEABISyscall = function
    | 0 -> LinuxSyscall.RestartSyscall
    | 1 -> LinuxSyscall.Exit
    | 2 -> LinuxSyscall.Fork
    | 3 -> LinuxSyscall.Read
    | 4 -> LinuxSyscall.Write
    | 5 -> LinuxSyscall.Open
    | 6 -> LinuxSyscall.Close
    | 8 -> LinuxSyscall.Creat
    | 9 -> LinuxSyscall.Link
    | 10 -> LinuxSyscall.Unlink
    | 11 -> LinuxSyscall.Execve
    | 12 -> LinuxSyscall.Chdir
    | 14 -> LinuxSyscall.Mknod
    | 15 -> LinuxSyscall.Chmod
    | 16 -> LinuxSyscall.Lchown
    | 19 -> LinuxSyscall.Lseek
    | 20 -> LinuxSyscall.Getpid
    | 21 -> LinuxSyscall.Mount
    | 23 -> LinuxSyscall.Setuid
    | 24 -> LinuxSyscall.Getuid
    | 26 -> LinuxSyscall.Ptrace
    | 29 -> LinuxSyscall.Pause
    | 33 -> LinuxSyscall.Access
    | 34 -> LinuxSyscall.Nice
    | 36 -> LinuxSyscall.Sync
    | 37 -> LinuxSyscall.Kill
    | 38 -> LinuxSyscall.Rename
    | 39 -> LinuxSyscall.Mkdir
    | 40 -> LinuxSyscall.Rmdir
    | 41 -> LinuxSyscall.Dup
    | 42 -> LinuxSyscall.Pipe
    | 43 -> LinuxSyscall.Times
    | 45 -> LinuxSyscall.Brk
    | 46 -> LinuxSyscall.Setgid
    | 47 -> LinuxSyscall.Getgid
    | 49 -> LinuxSyscall.Geteuid
    | 50 -> LinuxSyscall.Getegid
    | 51 -> LinuxSyscall.Acct
    | 52 -> LinuxSyscall.Umount2
    | 54 -> LinuxSyscall.Ioctl
    | 55 -> LinuxSyscall.Fcntl
    | 57 -> LinuxSyscall.Setpgid
    | 60 -> LinuxSyscall.Umask
    | 61 -> LinuxSyscall.Chroot
    | 62 -> LinuxSyscall.Ustat
    | 63 -> LinuxSyscall.Dup2
    | 64 -> LinuxSyscall.Getppid
    | 65 -> LinuxSyscall.Getpgrp
    | 66 -> LinuxSyscall.Setsid
    | 67 -> LinuxSyscall.Sigaction
    | 70 -> LinuxSyscall.Setreuid
    | 71 -> LinuxSyscall.Setregid
    | 72 -> LinuxSyscall.Sigsuspend
    | 73 -> LinuxSyscall.Sigpending
    | 74 -> LinuxSyscall.Sethostname
    | 75 -> LinuxSyscall.Setrlimit
    | 77 -> LinuxSyscall.Getrusage
    | 78 -> LinuxSyscall.Gettimeofday
    | 79 -> LinuxSyscall.Settimeofday
    | 80 -> LinuxSyscall.Getgroups
    | 81 -> LinuxSyscall.Setgroups
    | 83 -> LinuxSyscall.Symlink
    | 85 -> LinuxSyscall.Readlink
    | 86 -> LinuxSyscall.Uselib
    | 87 -> LinuxSyscall.Swapon
    | 88 -> LinuxSyscall.Reboot
    | 91 -> LinuxSyscall.Munmap
    | 92 -> LinuxSyscall.Truncate
    | 93 -> LinuxSyscall.Ftruncate
    | 94 -> LinuxSyscall.Fchmod
    | 95 -> LinuxSyscall.Fchown
    | 96 -> LinuxSyscall.Getpriority
    | 97 -> LinuxSyscall.Setpriority
    | 99 -> LinuxSyscall.Statfs
    | 100 -> LinuxSyscall.Fstatfs
    | 103 -> LinuxSyscall.Syslog
    | 104 -> LinuxSyscall.Setitimer
    | 105 -> LinuxSyscall.Getitimer
    | 106 -> LinuxSyscall.Stat
    | 107 -> LinuxSyscall.Lstat
    | 108 -> LinuxSyscall.Fstat
    | 111 -> LinuxSyscall.Vhangup
    | 114 -> LinuxSyscall.Wait4
    | 115 -> LinuxSyscall.Swapoff
    | 116 -> LinuxSyscall.Sysinfo
    | 118 -> LinuxSyscall.Fsync
    | 119 -> LinuxSyscall.Sigreturn
    | 120 -> LinuxSyscall.Clone
    | 121 -> LinuxSyscall.Setdomainname
    | 122 -> LinuxSyscall.Uname
    | 124 -> LinuxSyscall.AdjTimex
    | 125 -> LinuxSyscall.Mprotect
    | 126 -> LinuxSyscall.Sigprocmask
    | 128 -> LinuxSyscall.InitModule
    | 129 -> LinuxSyscall.DeleteModule
    | 131 -> LinuxSyscall.Quotactl
    | 132 -> LinuxSyscall.Getpgid
    | 133 -> LinuxSyscall.Fchdir
    | 134 -> LinuxSyscall.Bdflush
    | 135 -> LinuxSyscall.Sysfs
    | 136 -> LinuxSyscall.Personality
    | 138 -> LinuxSyscall.Setfsuid
    | 139 -> LinuxSyscall.Setfsgid
    | 140 -> LinuxSyscall.LLseek
    | 141 -> LinuxSyscall.Getdents
    | 142 -> LinuxSyscall.NewSelect
    | 143 -> LinuxSyscall.Flock
    | 144 -> LinuxSyscall.Msync
    | 145 -> LinuxSyscall.Readv
    | 146 -> LinuxSyscall.Writev
    | 147 -> LinuxSyscall.Getsid
    | 148 -> LinuxSyscall.Fdatasync
    | 149 -> LinuxSyscall.Sysctl
    | 150 -> LinuxSyscall.Mlock
    | 151 -> LinuxSyscall.Munlock
    | 152 -> LinuxSyscall.Mlockall
    | 153 -> LinuxSyscall.Munlockall
    | 154 -> LinuxSyscall.SchedSetparam
    | 155 -> LinuxSyscall.SchedGetparam
    | 156 -> LinuxSyscall.SchedSetscheduler
    | 157 -> LinuxSyscall.SchedGetscheduler
    | 158 -> LinuxSyscall.SchedYield
    | 159 -> LinuxSyscall.SchedGetPriorityMax
    | 160 -> LinuxSyscall.SchedGetPriorityMin
    | 161 -> LinuxSyscall.SchedRrGetInterval
    | 162 -> LinuxSyscall.Nanosleep
    | 163 -> LinuxSyscall.Mremap
    | 164 -> LinuxSyscall.Setresuid
    | 165 -> LinuxSyscall.Getresuid
    | 168 -> LinuxSyscall.Poll
    | 169 -> LinuxSyscall.Nfsservctl
    | 170 -> LinuxSyscall.Setresgid
    | 171 -> LinuxSyscall.Getresgid
    | 172 -> LinuxSyscall.Prctl
    | 173 -> LinuxSyscall.RtSigreturn
    | 174 -> LinuxSyscall.RtSigaction
    | 175 -> LinuxSyscall.RtSigprocmask
    | 176 -> LinuxSyscall.RtSigpending
    | 177 -> LinuxSyscall.RtSigtimedwait
    | 178 -> LinuxSyscall.RtSigqueueinfo
    | 179 -> LinuxSyscall.RtSigsuspend
    | 180 -> LinuxSyscall.Pread64
    | 181 -> LinuxSyscall.Pwrite64
    | 182 -> LinuxSyscall.Chown
    | 183 -> LinuxSyscall.Getcwd
    | 184 -> LinuxSyscall.CapGet
    | 185 -> LinuxSyscall.CapSet
    | 186 -> LinuxSyscall.Sigaltstack
    | 187 -> LinuxSyscall.Sendfile
    | 190 -> LinuxSyscall.Vfork
    | 191 -> LinuxSyscall.Ugetrlimit
    | 192 -> LinuxSyscall.Mmap2
    | 193 -> LinuxSyscall.Truncate64
    | 194 -> LinuxSyscall.Ftruncate64
    | 195 -> LinuxSyscall.Stat64
    | 196 -> LinuxSyscall.Lstat64
    | 197 -> LinuxSyscall.Fstat64
    | 198 -> LinuxSyscall.Lchown32
    | 199 -> LinuxSyscall.Getuid32
    | 200 -> LinuxSyscall.Getgid32
    | 201 -> LinuxSyscall.Geteuid32
    | 202 -> LinuxSyscall.Getegid32
    | 203 -> LinuxSyscall.Setreuid32
    | 204 -> LinuxSyscall.Setregid32
    | 205 -> LinuxSyscall.Getgroups32
    | 206 -> LinuxSyscall.Setgroups32
    | 207 -> LinuxSyscall.Fchown32
    | 208 -> LinuxSyscall.Setresuid32
    | 209 -> LinuxSyscall.Getresuid32
    | 210 -> LinuxSyscall.Setresgid32
    | 211 -> LinuxSyscall.Getresgid32
    | 212 -> LinuxSyscall.Chown32
    | 213 -> LinuxSyscall.Setuid32
    | 214 -> LinuxSyscall.Setgid32
    | 215 -> LinuxSyscall.Setfsuid32
    | 216 -> LinuxSyscall.Setfsgid32
    | 217 -> LinuxSyscall.Getdents64
    | 218 -> LinuxSyscall.PivotRoot
    | 219 -> LinuxSyscall.Mincore
    | 220 -> LinuxSyscall.Madvise
    | 221 -> LinuxSyscall.Fcntl64
    | 224 -> LinuxSyscall.Gettid
    | 225 -> LinuxSyscall.Readahead
    | 226 -> LinuxSyscall.Setxattr
    | 227 -> LinuxSyscall.Lsetxattr
    | 228 -> LinuxSyscall.Fsetxattr
    | 229 -> LinuxSyscall.Getxattr
    | 230 -> LinuxSyscall.Lgetxattr
    | 231 -> LinuxSyscall.Fgetxattr
    | 232 -> LinuxSyscall.Listxattr
    | 233 -> LinuxSyscall.Llistxattr
    | 234 -> LinuxSyscall.Flistxattr
    | 235 -> LinuxSyscall.Removexattr
    | 236 -> LinuxSyscall.Lremovexattr
    | 237 -> LinuxSyscall.Fremovexattr
    | 238 -> LinuxSyscall.Tkill
    | 239 -> LinuxSyscall.Sendfile64
    | 240 -> LinuxSyscall.Futex
    | 241 -> LinuxSyscall.SchedSetaffinity
    | 242 -> LinuxSyscall.SchedGetaffinity
    | 243 -> LinuxSyscall.IoSetup
    | 244 -> LinuxSyscall.IoDestroy
    | 245 -> LinuxSyscall.IoGetevents
    | 246 -> LinuxSyscall.IoSubmit
    | 247 -> LinuxSyscall.IoCancel
    | 248 -> LinuxSyscall.ExitGroup
    | 249 -> LinuxSyscall.LookupDcookie
    | 250 -> LinuxSyscall.EpollCreate
    | 251 -> LinuxSyscall.EpollCtl
    | 252 -> LinuxSyscall.EpollWait
    | 253 -> LinuxSyscall.RemapFilePages
    | 256 -> LinuxSyscall.SetTidAddress
    | 257 -> LinuxSyscall.TimerCreate
    | 258 -> LinuxSyscall.TimerSettime
    | 259 -> LinuxSyscall.TimerGettime
    | 260 -> LinuxSyscall.TimerGetoverrun
    | 261 -> LinuxSyscall.TimerDelete
    | 262 -> LinuxSyscall.ClockSettime
    | 263 -> LinuxSyscall.ClockGettime
    | 264 -> LinuxSyscall.ClockGetres
    | 265 -> LinuxSyscall.ClockNanosleep
    | 266 -> LinuxSyscall.Statfs64
    | 267 -> LinuxSyscall.Fstatfs64
    | 268 -> LinuxSyscall.Tgkill
    | 269 -> LinuxSyscall.Utimes
    | 270 -> LinuxSyscall.ArmFadvise64
    | 271 -> LinuxSyscall.PciconfigIobase
    | 272 -> LinuxSyscall.PciconfigRead
    | 273 -> LinuxSyscall.PciconfigWrite
    | 274 -> LinuxSyscall.MqOpen
    | 275 -> LinuxSyscall.MqUnlink
    | 276 -> LinuxSyscall.MqTimedsend
    | 277 -> LinuxSyscall.MqTimedreceive
    | 278 -> LinuxSyscall.MqNotify
    | 279 -> LinuxSyscall.MqGetsetattr
    | 280 -> LinuxSyscall.Waitid
    | 281 -> LinuxSyscall.Socket
    | 282 -> LinuxSyscall.Bind
    | 283 -> LinuxSyscall.Connect
    | 284 -> LinuxSyscall.Listen
    | 285 -> LinuxSyscall.Accept
    | 286 -> LinuxSyscall.Getsockname
    | 287 -> LinuxSyscall.Getpeername
    | 288 -> LinuxSyscall.Socketpair
    | 289 -> LinuxSyscall.Send
    | 290 -> LinuxSyscall.Sendto
    | 291 -> LinuxSyscall.Recv
    | 292 -> LinuxSyscall.Recvfrom
    | 293 -> LinuxSyscall.Shutdown
    | 294 -> LinuxSyscall.Setsockopt
    | 295 -> LinuxSyscall.Getsockopt
    | 296 -> LinuxSyscall.Sendmsg
    | 297 -> LinuxSyscall.Recvmsg
    | 298 -> LinuxSyscall.Semop
    | 299 -> LinuxSyscall.Semget
    | 300 -> LinuxSyscall.Semctl
    | 301 -> LinuxSyscall.Msgsnd
    | 302 -> LinuxSyscall.Msgrcv
    | 303 -> LinuxSyscall.Msgget
    | 304 -> LinuxSyscall.Msgctl
    | 305 -> LinuxSyscall.Shmat
    | 306 -> LinuxSyscall.Shmdt
    | 307 -> LinuxSyscall.Shmget
    | 308 -> LinuxSyscall.Shmctl
    | 309 -> LinuxSyscall.AddKey
    | 310 -> LinuxSyscall.RequestKey
    | 311 -> LinuxSyscall.Keyctl
    | 312 -> LinuxSyscall.Semtimedop
    | 313 -> LinuxSyscall.Vserver
    | 314 -> LinuxSyscall.IoprioSet
    | 315 -> LinuxSyscall.IoprioGet
    | 316 -> LinuxSyscall.InotifyInit
    | 317 -> LinuxSyscall.InotifyAddWatch
    | 318 -> LinuxSyscall.InotifyRmWatch
    | 319 -> LinuxSyscall.Mbind
    | 320 -> LinuxSyscall.GetMempolicy
    | 321 -> LinuxSyscall.SetMempolicy
    | 322 -> LinuxSyscall.Openat
    | 323 -> LinuxSyscall.Mkdirat
    | 324 -> LinuxSyscall.Mknodat
    | 325 -> LinuxSyscall.Fchownat
    | 326 -> LinuxSyscall.Futimesat
    | 327 -> LinuxSyscall.Fstatat64
    | 328 -> LinuxSyscall.Unlinkat
    | 329 -> LinuxSyscall.Renameat
    | 330 -> LinuxSyscall.Linkat
    | 331 -> LinuxSyscall.Symlinkat
    | 332 -> LinuxSyscall.Readlinkat
    | 333 -> LinuxSyscall.Fchmodat
    | 334 -> LinuxSyscall.Faccessat
    | 335 -> LinuxSyscall.Pselect6
    | 336 -> LinuxSyscall.Ppoll
    | 337 -> LinuxSyscall.Unshare
    | 338 -> LinuxSyscall.SetRobustList
    | 339 -> LinuxSyscall.GetRobustList
    | 340 -> LinuxSyscall.Splice
    | 341 -> LinuxSyscall.ArmSyncFileRange
    | 342 -> LinuxSyscall.Tee
    | 343 -> LinuxSyscall.Vmsplice
    | 344 -> LinuxSyscall.MovePages
    | 345 -> LinuxSyscall.Getcpu
    | 346 -> LinuxSyscall.EpollPwait
    | 347 -> LinuxSyscall.KexecLoad
    | 348 -> LinuxSyscall.Utimensat
    | 349 -> LinuxSyscall.Signalfd
    | 350 -> LinuxSyscall.TimerfdCreate
    | 351 -> LinuxSyscall.Eventfd
    | 352 -> LinuxSyscall.Fallocate
    | 353 -> LinuxSyscall.TimerfdSettime
    | 354 -> LinuxSyscall.TimerfdGettime
    | 355 -> LinuxSyscall.Signalfd4
    | 356 -> LinuxSyscall.Eventfd2
    | 357 -> LinuxSyscall.EpollCreate1
    | 358 -> LinuxSyscall.Dup3
    | 359 -> LinuxSyscall.Pipe2
    | 360 -> LinuxSyscall.InotifyInit1
    | 361 -> LinuxSyscall.Preadv
    | 362 -> LinuxSyscall.Pwritev
    | 363 -> LinuxSyscall.RtTgsigqueueinfo
    | 364 -> LinuxSyscall.PerfEventOpen
    | 365 -> LinuxSyscall.Recvmmsg
    | 366 -> LinuxSyscall.Accept4
    | 367 -> LinuxSyscall.FanotifyInit
    | 368 -> LinuxSyscall.FanotifyMark
    | 369 -> LinuxSyscall.Prlimit64
    | 370 -> LinuxSyscall.NameToHandleAt
    | 371 -> LinuxSyscall.OpenByHandleAt
    | 372 -> LinuxSyscall.ClockAdjtime
    | 373 -> LinuxSyscall.Syncfs
    | 374 -> LinuxSyscall.Sendmmsg
    | 375 -> LinuxSyscall.Setns
    | 376 -> LinuxSyscall.ProcessVmReadv
    | 377 -> LinuxSyscall.ProcessVmWritev
    | 378 -> LinuxSyscall.Kcmp
    | 379 -> LinuxSyscall.FinitModule
    | 380 -> LinuxSyscall.SchedSetattr
    | 381 -> LinuxSyscall.SchedGetattr
    | 382 -> LinuxSyscall.Renameat2
    | 383 -> LinuxSyscall.Seccomp
    | 384 -> LinuxSyscall.Getrandom
    | 385 -> LinuxSyscall.MemfdCreate
    | 386 -> LinuxSyscall.Bpf
    | 387 -> LinuxSyscall.Execveat
    | 388 -> LinuxSyscall.Userfaultfd
    | 389 -> LinuxSyscall.Membarrier
    | 390 -> LinuxSyscall.Mlock2
    | 391 -> LinuxSyscall.CopyFileRange
    | 392 -> LinuxSyscall.Preadv2
    | 393 -> LinuxSyscall.Pwritev2
    | 394 -> LinuxSyscall.PkeyMprotect
    | 395 -> LinuxSyscall.PkeyAlloc
    | 396 -> LinuxSyscall.PkeyFree
    | 397 -> LinuxSyscall.Statx
    | 398 -> LinuxSyscall.Rseq
    | 399 -> LinuxSyscall.IoPgetevents
    | 400 -> LinuxSyscall.MigratePages
    | 401 -> LinuxSyscall.KexecFileLoad
    | 403 -> LinuxSyscall.ClockGettime64
    | 404 -> LinuxSyscall.ClockSettime64
    | 405 -> LinuxSyscall.ClockAdjtime64
    | 408 -> LinuxSyscall.TimerGettime64
    | 409 -> LinuxSyscall.TimerSettime64
    | 410 -> LinuxSyscall.TimerfdGettime64
    | 411 -> LinuxSyscall.TimerfdSettime64
    | 412 -> LinuxSyscall.Utimensat64
    | 413 -> LinuxSyscall.Pselect6_64
    | 414 -> LinuxSyscall.Ppoll64
    | 416 -> LinuxSyscall.IoPgetevents64
    | 417 -> LinuxSyscall.Recvmmsg64
    | 418 -> LinuxSyscall.MqTimedsend64
    | 419 -> LinuxSyscall.MqTimedreceive64
    | 420 -> LinuxSyscall.Semtimedop64
    | 421 -> LinuxSyscall.RtSigtimedwait64
    | 422 -> LinuxSyscall.Futex64
    | 423 -> LinuxSyscall.SchedRrGetInterval64
    | 424 -> LinuxSyscall.PidfdSendSignal
    | 425 -> LinuxSyscall.IoUringSetup
    | 426 -> LinuxSyscall.IoUringEnter
    | 427 -> LinuxSyscall.IoUringRegister
    | 428 -> LinuxSyscall.OpenTree
    | 429 -> LinuxSyscall.MoveMount
    | 430 -> LinuxSyscall.Fsopen
    | 431 -> LinuxSyscall.Fsconfig
    | 432 -> LinuxSyscall.Fsmount
    | 433 -> LinuxSyscall.Fspick
    | 434 -> LinuxSyscall.PidfdOpen
    | 435 -> LinuxSyscall.Clone3
    | 437 -> LinuxSyscall.Openat2
    | 438 -> LinuxSyscall.PidfdGetfd
    | 0x0f0001 -> LinuxSyscall.Breakpoint (* __ARM_NR_breakpoint *)
    | 0x0f0002 -> LinuxSyscall.CacheFlush (* __ARM_NR_cacheflush *)
    | 0x0f0003 -> LinuxSyscall.Usr26 (* __ARM_NR_usr26 *)
    | 0x0f0004 -> LinuxSyscall.Usr32 (* __ARM_NR_usr32 *)
    | 0x0f0005 -> LinuxSyscall.SetTLS (* __ARM_NR_set_tls *)
    | 0x0f0006 -> LinuxSyscall.GetTLS (* __ARM_NR_get_tls *)
    | _ -> raise UnhandledSyscallException

  let private getAARCH64Syscall = function
    | 0 -> LinuxSyscall.IoSetup
    | 1 -> LinuxSyscall.IoDestroy
    | 2 -> LinuxSyscall.IoSubmit
    | 3 -> LinuxSyscall.IoCancel
    | 4 -> LinuxSyscall.IoGetevents
    | 5 -> LinuxSyscall.Setxattr
    | 6 -> LinuxSyscall.Lsetxattr
    | 7 -> LinuxSyscall.Fsetxattr
    | 8 -> LinuxSyscall.Getxattr
    | 9 -> LinuxSyscall.Lgetxattr
    | 10 -> LinuxSyscall.Fgetxattr
    | 11 -> LinuxSyscall.Listxattr
    | 12 -> LinuxSyscall.Llistxattr
    | 13 -> LinuxSyscall.Flistxattr
    | 14 -> LinuxSyscall.Removexattr
    | 15 -> LinuxSyscall.Lremovexattr
    | 16 -> LinuxSyscall.Fremovexattr
    | 17 -> LinuxSyscall.Getcwd
    | 18 -> LinuxSyscall.LookupDcookie
    | 19 -> LinuxSyscall.Eventfd2
    | 20 -> LinuxSyscall.EpollCreate1
    | 21 -> LinuxSyscall.EpollCtl
    | 22 -> LinuxSyscall.EpollPwait
    | 23 -> LinuxSyscall.Dup
    | 24 -> LinuxSyscall.Dup3
    | 25 -> LinuxSyscall.Fcntl
    | 26 -> LinuxSyscall.InotifyInit1
    | 27 -> LinuxSyscall.InotifyAddWatch
    | 28 -> LinuxSyscall.InotifyRmWatch
    | 29 -> LinuxSyscall.Ioctl
    | 30 -> LinuxSyscall.IoprioSet
    | 31 -> LinuxSyscall.IoprioGet
    | 32 -> LinuxSyscall.Flock
    | 33 -> LinuxSyscall.Mknodat
    | 34 -> LinuxSyscall.Mkdirat
    | 35 -> LinuxSyscall.Unlinkat
    | 36 -> LinuxSyscall.Symlinkat
    | 37 -> LinuxSyscall.Linkat
    | 38 -> LinuxSyscall.Renameat
    | 39 -> LinuxSyscall.Umount2
    | 40 -> LinuxSyscall.Mount
    | 41 -> LinuxSyscall.PivotRoot
    | 42 -> LinuxSyscall.Nfsservctl
    | 43 -> LinuxSyscall.Statfs
    | 44 -> LinuxSyscall.Fstatfs
    | 45 -> LinuxSyscall.Truncate
    | 46 -> LinuxSyscall.Ftruncate
    | 47 -> LinuxSyscall.Fallocate
    | 48 -> LinuxSyscall.Faccessat
    | 49 -> LinuxSyscall.Chdir
    | 50 -> LinuxSyscall.Fchdir
    | 51 -> LinuxSyscall.Chroot
    | 52 -> LinuxSyscall.Fchmod
    | 53 -> LinuxSyscall.Fchmodat
    | 54 -> LinuxSyscall.Fchownat
    | 55 -> LinuxSyscall.Fchown
    | 56 -> LinuxSyscall.Openat
    | 57 -> LinuxSyscall.Close
    | 58 -> LinuxSyscall.Vhangup
    | 59 -> LinuxSyscall.Pipe2
    | 60 -> LinuxSyscall.Quotactl
    | 61 -> LinuxSyscall.Getdents64
    | 62 -> LinuxSyscall.Lseek
    | 63 -> LinuxSyscall.Read
    | 64 -> LinuxSyscall.Write
    | 65 -> LinuxSyscall.Readv
    | 66 -> LinuxSyscall.Writev
    | 67 -> LinuxSyscall.Pread64
    | 68 -> LinuxSyscall.Pwrite64
    | 69 -> LinuxSyscall.Preadv
    | 70 -> LinuxSyscall.Pwritev
    | 71 -> LinuxSyscall.Sendfile
    | 72 -> LinuxSyscall.Pselect6
    | 73 -> LinuxSyscall.Ppoll
    | 74 -> LinuxSyscall.Signalfd4
    | 75 -> LinuxSyscall.Vmsplice
    | 76 -> LinuxSyscall.Splice
    | 77 -> LinuxSyscall.Tee
    | 78 -> LinuxSyscall.Readlinkat
    | 79 -> LinuxSyscall.Newfstatat
    | 80 -> LinuxSyscall.Fstat
    | 81 -> LinuxSyscall.Sync
    | 82 -> LinuxSyscall.Fsync
    | 83 -> LinuxSyscall.Fdatasync
    | 84 -> LinuxSyscall.SyncFileRange
    | 85 -> LinuxSyscall.TimerfdCreate
    | 86 -> LinuxSyscall.TimerfdSettime
    | 87 -> LinuxSyscall.TimerfdGettime
    | 88 -> LinuxSyscall.Utimensat
    | 89 -> LinuxSyscall.Acct
    | 90 -> LinuxSyscall.CapGet
    | 91 -> LinuxSyscall.CapSet
    | 92 -> LinuxSyscall.Personality
    | 93 -> LinuxSyscall.Exit
    | 94 -> LinuxSyscall.ExitGroup
    | 95 -> LinuxSyscall.Waitid
    | 96 -> LinuxSyscall.SetTidAddress
    | 97 -> LinuxSyscall.Unshare
    | 98 -> LinuxSyscall.Futex
    | 99 -> LinuxSyscall.SetRobustList
    | 100 -> LinuxSyscall.GetRobustList
    | 101 -> LinuxSyscall.Nanosleep
    | 102 -> LinuxSyscall.Getitimer
    | 103 -> LinuxSyscall.Setitimer
    | 104 -> LinuxSyscall.KexecLoad
    | 105 -> LinuxSyscall.InitModule
    | 106 -> LinuxSyscall.DeleteModule
    | 107 -> LinuxSyscall.TimerCreate
    | 108 -> LinuxSyscall.TimerGettime
    | 109 -> LinuxSyscall.TimerGetoverrun
    | 110 -> LinuxSyscall.TimerSettime
    | 111 -> LinuxSyscall.TimerDelete
    | 112 -> LinuxSyscall.ClockSettime
    | 113 -> LinuxSyscall.ClockGettime
    | 114 -> LinuxSyscall.ClockGetres
    | 115 -> LinuxSyscall.ClockNanosleep
    | 116 -> LinuxSyscall.Syslog
    | 117 -> LinuxSyscall.Ptrace
    | 118 -> LinuxSyscall.SchedSetparam
    | 119 -> LinuxSyscall.SchedSetscheduler
    | 120 -> LinuxSyscall.SchedGetscheduler
    | 121 -> LinuxSyscall.SchedGetparam
    | 122 -> LinuxSyscall.SchedSetaffinity
    | 123 -> LinuxSyscall.SchedGetaffinity
    | 124 -> LinuxSyscall.SchedYield
    | 125 -> LinuxSyscall.SchedGetPriorityMax
    | 126 -> LinuxSyscall.SchedGetPriorityMin
    | 127 -> LinuxSyscall.SchedRrGetInterval
    | 128 -> LinuxSyscall.RestartSyscall
    | 129 -> LinuxSyscall.Kill
    | 130 -> LinuxSyscall.Tkill
    | 131 -> LinuxSyscall.Tgkill
    | 132 -> LinuxSyscall.Sigaltstack
    | 133 -> LinuxSyscall.RtSigsuspend
    | 134 -> LinuxSyscall.RtSigaction
    | 135 -> LinuxSyscall.RtSigprocmask
    | 136 -> LinuxSyscall.RtSigpending
    | 137 -> LinuxSyscall.RtSigtimedwait
    | 138 -> LinuxSyscall.RtSigqueueinfo
    | 139 -> LinuxSyscall.RtSigreturn
    | 140 -> LinuxSyscall.Setpriority
    | 141 -> LinuxSyscall.Getpriority
    | 142 -> LinuxSyscall.Reboot
    | 143 -> LinuxSyscall.Setregid
    | 144 -> LinuxSyscall.Setgid
    | 145 -> LinuxSyscall.Setreuid
    | 146 -> LinuxSyscall.Setuid
    | 147 -> LinuxSyscall.Setresuid
    | 148 -> LinuxSyscall.Getresuid
    | 149 -> LinuxSyscall.Setresgid
    | 150 -> LinuxSyscall.Getresgid
    | 151 -> LinuxSyscall.Setfsuid
    | 152 -> LinuxSyscall.Setfsgid
    | 153 -> LinuxSyscall.Times
    | 154 -> LinuxSyscall.Setpgid
    | 155 -> LinuxSyscall.Getpgid
    | 156 -> LinuxSyscall.Getsid
    | 157 -> LinuxSyscall.Setsid
    | 158 -> LinuxSyscall.Getgroups
    | 159 -> LinuxSyscall.Setgroups
    | 160 -> LinuxSyscall.Uname
    | 161 -> LinuxSyscall.Sethostname
    | 162 -> LinuxSyscall.Setdomainname
    | 163 -> LinuxSyscall.Getrlimit
    | 164 -> LinuxSyscall.Setrlimit
    | 165 -> LinuxSyscall.Getrusage
    | 166 -> LinuxSyscall.Umask
    | 167 -> LinuxSyscall.Prctl
    | 168 -> LinuxSyscall.Getcpu
    | 169 -> LinuxSyscall.Gettimeofday
    | 170 -> LinuxSyscall.Settimeofday
    | 171 -> LinuxSyscall.AdjTimex
    | 172 -> LinuxSyscall.Getpid
    | 173 -> LinuxSyscall.Getppid
    | 174 -> LinuxSyscall.Getuid
    | 175 -> LinuxSyscall.Geteuid
    | 176 -> LinuxSyscall.Getgid
    | 177 -> LinuxSyscall.Getegid
    | 178 -> LinuxSyscall.Gettid
    | 179 -> LinuxSyscall.Sysinfo
    | 180 -> LinuxSyscall.MqOpen
    | 181 -> LinuxSyscall.MqUnlink
    | 182 -> LinuxSyscall.MqTimedsend
    | 183 -> LinuxSyscall.MqTimedreceive
    | 184 -> LinuxSyscall.MqNotify
    | 185 -> LinuxSyscall.MqGetsetattr
    | 186 -> LinuxSyscall.Msgget
    | 187 -> LinuxSyscall.Msgctl
    | 188 -> LinuxSyscall.Msgrcv
    | 189 -> LinuxSyscall.Msgsnd
    | 190 -> LinuxSyscall.Semget
    | 191 -> LinuxSyscall.Semctl
    | 192 -> LinuxSyscall.Semtimedop
    | 193 -> LinuxSyscall.Semop
    | 194 -> LinuxSyscall.Shmget
    | 195 -> LinuxSyscall.Shmctl
    | 196 -> LinuxSyscall.Shmat
    | 197 -> LinuxSyscall.Shmdt
    | 198 -> LinuxSyscall.Socket
    | 199 -> LinuxSyscall.Socketpair
    | 200 -> LinuxSyscall.Bind
    | 201 -> LinuxSyscall.Listen
    | 202 -> LinuxSyscall.Accept
    | 203 -> LinuxSyscall.Connect
    | 204 -> LinuxSyscall.Getsockname
    | 205 -> LinuxSyscall.Getpeername
    | 206 -> LinuxSyscall.Sendto
    | 207 -> LinuxSyscall.Recvfrom
    | 208 -> LinuxSyscall.Setsockopt
    | 209 -> LinuxSyscall.Getsockopt
    | 210 -> LinuxSyscall.Shutdown
    | 211 -> LinuxSyscall.Sendmsg
    | 212 -> LinuxSyscall.Recvmsg
    | 213 -> LinuxSyscall.Readahead
    | 214 -> LinuxSyscall.Brk
    | 215 -> LinuxSyscall.Munmap
    | 216 -> LinuxSyscall.Mremap
    | 217 -> LinuxSyscall.AddKey
    | 218 -> LinuxSyscall.RequestKey
    | 219 -> LinuxSyscall.Keyctl
    | 220 -> LinuxSyscall.Clone
    | 221 -> LinuxSyscall.Execve
    | 222 -> LinuxSyscall.Mmap
    | 223 -> LinuxSyscall.Fadvise64
    | 224 -> LinuxSyscall.Swapon
    | 225 -> LinuxSyscall.Swapoff
    | 226 -> LinuxSyscall.Mprotect
    | 227 -> LinuxSyscall.Msync
    | 228 -> LinuxSyscall.Mlock
    | 229 -> LinuxSyscall.Munlock
    | 230 -> LinuxSyscall.Mlockall
    | 231 -> LinuxSyscall.Munlockall
    | 232 -> LinuxSyscall.Mincore
    | 233 -> LinuxSyscall.Madvise
    | 234 -> LinuxSyscall.RemapFilePages
    | 235 -> LinuxSyscall.Mbind
    | 236 -> LinuxSyscall.GetMempolicy
    | 237 -> LinuxSyscall.SetMempolicy
    | 238 -> LinuxSyscall.MigratePages
    | 239 -> LinuxSyscall.MovePages
    | 240 -> LinuxSyscall.RtTgsigqueueinfo
    | 241 -> LinuxSyscall.PerfEventOpen
    | 242 -> LinuxSyscall.Accept4
    | 243 -> LinuxSyscall.Recvmmsg
    | 260 -> LinuxSyscall.Wait4
    | 261 -> LinuxSyscall.Prlimit64
    | 262 -> LinuxSyscall.FanotifyInit
    | 263 -> LinuxSyscall.FanotifyMark
    | 264 -> LinuxSyscall.NameToHandleAt
    | 265 -> LinuxSyscall.OpenByHandleAt
    | 266 -> LinuxSyscall.ClockAdjtime
    | 267 -> LinuxSyscall.Syncfs
    | 268 -> LinuxSyscall.Setns
    | 269 -> LinuxSyscall.Sendmmsg
    | 270 -> LinuxSyscall.ProcessVmReadv
    | 271 -> LinuxSyscall.ProcessVmWritev
    | 272 -> LinuxSyscall.Kcmp
    | 273 -> LinuxSyscall.FinitModule
    | 274 -> LinuxSyscall.SchedSetattr
    | 275 -> LinuxSyscall.SchedGetattr
    | 276 -> LinuxSyscall.Renameat2
    | 277 -> LinuxSyscall.Seccomp
    | 278 -> LinuxSyscall.Getrandom
    | 279 -> LinuxSyscall.MemfdCreate
    | 280 -> LinuxSyscall.Bpf
    | 281 -> LinuxSyscall.Execveat
    | 282 -> LinuxSyscall.Userfaultfd
    | 283 -> LinuxSyscall.Membarrier
    | 284 -> LinuxSyscall.Mlock2
    | 285 -> LinuxSyscall.CopyFileRange
    | 286 -> LinuxSyscall.Preadv2
    | 287 -> LinuxSyscall.Pwritev2
    | 288 -> LinuxSyscall.PkeyMprotect
    | 289 -> LinuxSyscall.PkeyAlloc
    | 290 -> LinuxSyscall.PkeyFree
    | 291 -> LinuxSyscall.Statx
    | 292 -> LinuxSyscall.IoPgetevents
    | 293 -> LinuxSyscall.Rseq
    | 294 -> LinuxSyscall.KexecFileLoad
    | 403 -> LinuxSyscall.ClockGettime64
    | 404 -> LinuxSyscall.ClockSettime64
    | 405 -> LinuxSyscall.ClockAdjtime64
    | 406 -> LinuxSyscall.ClockGetres64
    | 407 -> LinuxSyscall.ClockNanosleep64
    | 408 -> LinuxSyscall.TimerGettime64
    | 409 -> LinuxSyscall.TimerSettime64
    | 410 -> LinuxSyscall.TimerfdGettime64
    | 411 -> LinuxSyscall.TimerfdSettime64
    | 412 -> LinuxSyscall.Utimensat64
    | 413 -> LinuxSyscall.Pselect6_64
    | 414 -> LinuxSyscall.Ppoll64
    | 416 -> LinuxSyscall.IoPgetevents64
    | 417 -> LinuxSyscall.Recvmmsg64
    | 418 -> LinuxSyscall.MqTimedsend64
    | 419 -> LinuxSyscall.MqTimedreceive64
    | 420 -> LinuxSyscall.Semtimedop64
    | 421 -> LinuxSyscall.RtSigtimedwait64
    | 422 -> LinuxSyscall.Futex64
    | 423 -> LinuxSyscall.SchedRrGetInterval64
    | 424 -> LinuxSyscall.PidfdSendSignal
    | 425 -> LinuxSyscall.IoUringSetup
    | 426 -> LinuxSyscall.IoUringEnter
    | 427 -> LinuxSyscall.IoUringRegister
    | 428 -> LinuxSyscall.OpenTree
    | 429 -> LinuxSyscall.MoveMount
    | 430 -> LinuxSyscall.Fsopen
    | 431 -> LinuxSyscall.Fsconfig
    | 432 -> LinuxSyscall.Fsmount
    | 433 -> LinuxSyscall.Fspick
    | 434 -> LinuxSyscall.PidfdOpen
    | 435 -> LinuxSyscall.Clone3
    | 437 -> LinuxSyscall.Openat2
    | 438 -> LinuxSyscall.PidfdGetfd
    | 439 -> LinuxSyscall.Faccessat
    | _ -> raise UnhandledSyscallException

  let private getMIPSO32Syscall = function
    | 4001 -> LinuxSyscall.Exit
    | 4002 -> LinuxSyscall.Fork
    | 4003 -> LinuxSyscall.Read
    | 4004 -> LinuxSyscall.Write
    | 4005 -> LinuxSyscall.Open
    | 4006 -> LinuxSyscall.Close
    | 4007 -> LinuxSyscall.Waitpid
    | 4008 -> LinuxSyscall.Creat
    | 4009 -> LinuxSyscall.Link
    | 4010 -> LinuxSyscall.Unlink
    | 4011 -> LinuxSyscall.Execve
    | 4012 -> LinuxSyscall.Chdir
    | 4013 -> LinuxSyscall.Time
    | 4014 -> LinuxSyscall.Mknod
    | 4015 -> LinuxSyscall.Chmod
    | 4016 -> LinuxSyscall.Lchown
    | 4017 -> LinuxSyscall.Breakpoint
    | 4019 -> LinuxSyscall.Lseek
    | 4020 -> LinuxSyscall.Getpid
    | 4021 -> LinuxSyscall.Mount
    | 4022 -> LinuxSyscall.Umount
    | 4023 -> LinuxSyscall.Setuid
    | 4024 -> LinuxSyscall.Getuid
    | 4025 -> LinuxSyscall.Stime
    | 4026 -> LinuxSyscall.Ptrace
    | 4027 -> LinuxSyscall.Alarm
    | 4029 -> LinuxSyscall.Pause
    | 4030 -> LinuxSyscall.Utime
    | 4033 -> LinuxSyscall.Access
    | 4034 -> LinuxSyscall.Nice
    | 4036 -> LinuxSyscall.Sync
    | 4037 -> LinuxSyscall.Kill
    | 4038 -> LinuxSyscall.Rename
    | 4039 -> LinuxSyscall.Mkdir
    | 4040 -> LinuxSyscall.Rmdir
    | 4041 -> LinuxSyscall.Dup
    | 4042 -> LinuxSyscall.Pipe
    | 4043 -> LinuxSyscall.Times
    | 4045 -> LinuxSyscall.Brk
    | 4046 -> LinuxSyscall.Setgid
    | 4047 -> LinuxSyscall.Getgid
    | 4048 -> LinuxSyscall.Signal
    | 4049 -> LinuxSyscall.Geteuid
    | 4050 -> LinuxSyscall.Getegid
    | 4051 -> LinuxSyscall.Acct
    | 4052 -> LinuxSyscall.Umount2
    | 4054 -> LinuxSyscall.Ioctl
    | 4055 -> LinuxSyscall.Fcntl
    | 4057 -> LinuxSyscall.Setpgid
    | 4060 -> LinuxSyscall.Umask
    | 4061 -> LinuxSyscall.Chroot
    | 4062 -> LinuxSyscall.Ustat
    | 4063 -> LinuxSyscall.Dup2
    | 4064 -> LinuxSyscall.Getppid
    | 4065 -> LinuxSyscall.Getpgrp
    | 4066 -> LinuxSyscall.Setsid
    | 4067 -> LinuxSyscall.Sigaction
    | 4068 -> LinuxSyscall.Sgetmask
    | 4069 -> LinuxSyscall.Ssetmask
    | 4070 -> LinuxSyscall.Setreuid
    | 4071 -> LinuxSyscall.Setregid
    | 4072 -> LinuxSyscall.Sigsuspend
    | 4073 -> LinuxSyscall.Sigpending
    | 4074 -> LinuxSyscall.Sethostname
    | 4075 -> LinuxSyscall.Setrlimit
    | 4076 -> LinuxSyscall.Getrlimit
    | 4077 -> LinuxSyscall.Getrusage
    | 4078 -> LinuxSyscall.Gettimeofday
    | 4079 -> LinuxSyscall.Settimeofday
    | 4080 -> LinuxSyscall.Getgroups
    | 4081 -> LinuxSyscall.Setgroups
    | 4083 -> LinuxSyscall.Symlink
    | 4085 -> LinuxSyscall.Readlink
    | 4086 -> LinuxSyscall.Uselib
    | 4087 -> LinuxSyscall.Swapon
    | 4088 -> LinuxSyscall.Reboot
    | 4089 -> LinuxSyscall.Readdir
    | 4090 -> LinuxSyscall.Mmap
    | 4091 -> LinuxSyscall.Munmap
    | 4092 -> LinuxSyscall.Truncate
    | 4093 -> LinuxSyscall.Ftruncate
    | 4094 -> LinuxSyscall.Fchmod
    | 4095 -> LinuxSyscall.Fchown
    | 4096 -> LinuxSyscall.Getpriority
    | 4097 -> LinuxSyscall.Setpriority
    | 4099 -> LinuxSyscall.Statfs
    | 4100 -> LinuxSyscall.Fstatfs
    | 4101 -> LinuxSyscall.Ioperm
    | 4102 -> LinuxSyscall.Socketcall
    | 4103 -> LinuxSyscall.Syslog
    | 4104 -> LinuxSyscall.Setitimer
    | 4105 -> LinuxSyscall.Getitimer
    | 4106 -> LinuxSyscall.Stat
    | 4107 -> LinuxSyscall.Lstat
    | 4108 -> LinuxSyscall.Fstat
    | 4110 -> LinuxSyscall.Iopl
    | 4111 -> LinuxSyscall.Vhangup
    | 4113 -> LinuxSyscall.Vm86
    | 4114 -> LinuxSyscall.Wait4
    | 4115 -> LinuxSyscall.Swapoff
    | 4116 -> LinuxSyscall.Sysinfo
    | 4117 -> LinuxSyscall.Ipc
    | 4118 -> LinuxSyscall.Fsync
    | 4119 -> LinuxSyscall.Sigreturn
    | 4120 -> LinuxSyscall.Clone
    | 4121 -> LinuxSyscall.Setdomainname
    | 4122 -> LinuxSyscall.Uname
    | 4123 -> LinuxSyscall.ModifyLdt
    | 4124 -> LinuxSyscall.OldAdjtimex
    | 4125 -> LinuxSyscall.Mprotect
    | 4126 -> LinuxSyscall.Sigprocmask
    | 4127 -> LinuxSyscall.CreateModule
    | 4128 -> LinuxSyscall.InitModule
    | 4129 -> LinuxSyscall.DeleteModule
    | 4130 -> LinuxSyscall.GetKernelSyms
    | 4131 -> LinuxSyscall.Quotactl
    | 4132 -> LinuxSyscall.Getpgid
    | 4133 -> LinuxSyscall.Fchdir
    | 4134 -> LinuxSyscall.Bdflush
    | 4135 -> LinuxSyscall.Sysfs
    | 4136 -> LinuxSyscall.Personality
    | 4138 -> LinuxSyscall.Setfsuid
    | 4139 -> LinuxSyscall.Setfsgid
    | 4140 -> LinuxSyscall.LLseek
    | 4141 -> LinuxSyscall.Getdents
    | 4142 -> LinuxSyscall.NewSelect
    | 4143 -> LinuxSyscall.Flock
    | 4144 -> LinuxSyscall.Msync
    | 4145 -> LinuxSyscall.Readv
    | 4146 -> LinuxSyscall.Writev
    | 4147 -> LinuxSyscall.CacheFlush
    | 4149 -> LinuxSyscall.Sysmips
    | 4151 -> LinuxSyscall.Getsid
    | 4152 -> LinuxSyscall.Fdatasync
    | 4154 -> LinuxSyscall.Mlock
    | 4155 -> LinuxSyscall.Munlock
    | 4156 -> LinuxSyscall.Mlockall
    | 4157 -> LinuxSyscall.Munlockall
    | 4158 -> LinuxSyscall.SchedSetparam
    | 4159 -> LinuxSyscall.SchedGetparam
    | 4160 -> LinuxSyscall.SchedSetscheduler
    | 4161 -> LinuxSyscall.SchedGetscheduler
    | 4162 -> LinuxSyscall.SchedYield
    | 4163 -> LinuxSyscall.SchedGetPriorityMax
    | 4164 -> LinuxSyscall.SchedGetPriorityMin
    | 4165 -> LinuxSyscall.SchedRrGetInterval
    | 4166 -> LinuxSyscall.Nanosleep
    | 4167 -> LinuxSyscall.Mremap
    | 4168 -> LinuxSyscall.Accept
    | 4169 -> LinuxSyscall.Bind
    | 4170 -> LinuxSyscall.Connect
    | 4171 -> LinuxSyscall.Getpeername
    | 4172 -> LinuxSyscall.Getsockname
    | 4173 -> LinuxSyscall.Getsockopt
    | 4174 -> LinuxSyscall.Listen
    | 4175 -> LinuxSyscall.Recv
    | 4176 -> LinuxSyscall.Recvfrom
    | 4177 -> LinuxSyscall.Recvmsg
    | 4178 -> LinuxSyscall.Send
    | 4179 -> LinuxSyscall.Sendmsg
    | 4180 -> LinuxSyscall.Sendto
    | 4181 -> LinuxSyscall.Setsockopt
    | 4182 -> LinuxSyscall.Shutdown
    | 4183 -> LinuxSyscall.Socket
    | 4184 -> LinuxSyscall.Socketpair
    | 4185 -> LinuxSyscall.Setresuid
    | 4186 -> LinuxSyscall.Getresuid
    | 4187 -> LinuxSyscall.QueryModule
    | 4188 -> LinuxSyscall.Poll
    | 4189 -> LinuxSyscall.Nfsservctl
    | 4190 -> LinuxSyscall.Setresgid
    | 4191 -> LinuxSyscall.Getresgid
    | 4192 -> LinuxSyscall.Prctl
    | 4193 -> LinuxSyscall.RtSigreturn
    | 4194 -> LinuxSyscall.RtSigaction
    | 4195 -> LinuxSyscall.RtSigprocmask
    | 4196 -> LinuxSyscall.RtSigpending
    | 4197 -> LinuxSyscall.RtSigtimedwait
    | 4198 -> LinuxSyscall.RtSigqueueinfo
    | 4199 -> LinuxSyscall.RtSigsuspend
    | 4200 -> LinuxSyscall.Pread64
    | 4201 -> LinuxSyscall.Pwrite64
    | 4202 -> LinuxSyscall.Chown
    | 4203 -> LinuxSyscall.Getcwd
    | 4204 -> LinuxSyscall.CapGet
    | 4205 -> LinuxSyscall.CapSet
    | 4206 -> LinuxSyscall.Sigaltstack
    | 4207 -> LinuxSyscall.Sendfile
    | 4210 -> LinuxSyscall.Mmap2
    | 4211 -> LinuxSyscall.Truncate64
    | 4212 -> LinuxSyscall.Ftruncate64
    | 4213 -> LinuxSyscall.Stat64
    | 4214 -> LinuxSyscall.Lstat64
    | 4215 -> LinuxSyscall.Fstat64
    | 4216 -> LinuxSyscall.PivotRoot
    | 4217 -> LinuxSyscall.Mincore
    | 4218 -> LinuxSyscall.Madvise
    | 4219 -> LinuxSyscall.Getdents64
    | 4220 -> LinuxSyscall.Fcntl64
    | 4222 -> LinuxSyscall.Gettid
    | 4223 -> LinuxSyscall.Readahead
    | 4224 -> LinuxSyscall.Setxattr
    | 4225 -> LinuxSyscall.Lsetxattr
    | 4226 -> LinuxSyscall.Fsetxattr
    | 4227 -> LinuxSyscall.Getxattr
    | 4228 -> LinuxSyscall.Lgetxattr
    | 4229 -> LinuxSyscall.Fgetxattr
    | 4230 -> LinuxSyscall.Listxattr
    | 4231 -> LinuxSyscall.Llistxattr
    | 4232 -> LinuxSyscall.Flistxattr
    | 4233 -> LinuxSyscall.Removexattr
    | 4234 -> LinuxSyscall.Lremovexattr
    | 4235 -> LinuxSyscall.Fremovexattr
    | 4236 -> LinuxSyscall.Tkill
    | 4237 -> LinuxSyscall.Sendfile64
    | 4238 -> LinuxSyscall.Futex
    | 4239 -> LinuxSyscall.SchedSetaffinity
    | 4240 -> LinuxSyscall.SchedGetaffinity
    | 4241 -> LinuxSyscall.IoSetup
    | 4242 -> LinuxSyscall.IoDestroy
    | 4243 -> LinuxSyscall.IoGetevents
    | 4244 -> LinuxSyscall.IoSubmit
    | 4245 -> LinuxSyscall.IoCancel
    | 4246 -> LinuxSyscall.ExitGroup
    | 4247 -> LinuxSyscall.LookupDcookie
    | 4248 -> LinuxSyscall.EpollCreate
    | 4249 -> LinuxSyscall.EpollCtl
    | 4250 -> LinuxSyscall.EpollWait
    | 4251 -> LinuxSyscall.RemapFilePages
    | 4252 -> LinuxSyscall.SetTidAddress
    | 4253 -> LinuxSyscall.RestartSyscall
    | 4254 -> LinuxSyscall.Fadvise64
    | 4255 -> LinuxSyscall.Statfs64
    | 4256 -> LinuxSyscall.Fstatfs64
    | 4257 -> LinuxSyscall.TimerCreate
    | 4258 -> LinuxSyscall.TimerSettime
    | 4259 -> LinuxSyscall.TimerGettime
    | 4260 -> LinuxSyscall.TimerGetoverrun
    | 4261 -> LinuxSyscall.TimerDelete
    | 4262 -> LinuxSyscall.ClockSettime
    | 4263 -> LinuxSyscall.ClockGettime
    | 4264 -> LinuxSyscall.ClockGetres
    | 4265 -> LinuxSyscall.ClockNanosleep
    | 4266 -> LinuxSyscall.Tgkill
    | 4267 -> LinuxSyscall.Utimes
    | 4268 -> LinuxSyscall.Mbind
    | 4269 -> LinuxSyscall.GetMempolicy
    | 4270 -> LinuxSyscall.SetMempolicy
    | 4271 -> LinuxSyscall.MqOpen
    | 4272 -> LinuxSyscall.MqUnlink
    | 4273 -> LinuxSyscall.MqTimedsend
    | 4274 -> LinuxSyscall.MqTimedreceive
    | 4275 -> LinuxSyscall.MqNotify
    | 4276 -> LinuxSyscall.MqGetsetattr
    | 4277 -> LinuxSyscall.Vserver
    | 4278 -> LinuxSyscall.Waitid
    | 4280 -> LinuxSyscall.AddKey
    | 4281 -> LinuxSyscall.RequestKey
    | 4282 -> LinuxSyscall.Keyctl
    | 4283 -> LinuxSyscall.SetThreadArea
    | 4284 -> LinuxSyscall.InotifyInit
    | 4285 -> LinuxSyscall.InotifyAddWatch
    | 4286 -> LinuxSyscall.InotifyRmWatch
    | 4287 -> LinuxSyscall.MigratePages
    | 4288 -> LinuxSyscall.Openat
    | 4289 -> LinuxSyscall.Mkdirat
    | 4290 -> LinuxSyscall.Mknodat
    | 4291 -> LinuxSyscall.Fchownat
    | 4292 -> LinuxSyscall.Futimesat
    | 4293 -> LinuxSyscall.Fstatat64
    | 4294 -> LinuxSyscall.Unlinkat
    | 4295 -> LinuxSyscall.Renameat
    | 4296 -> LinuxSyscall.Linkat
    | 4297 -> LinuxSyscall.Symlinkat
    | 4298 -> LinuxSyscall.Readlinkat
    | 4299 -> LinuxSyscall.Fchmodat
    | 4300 -> LinuxSyscall.Faccessat
    | 4301 -> LinuxSyscall.Pselect6
    | 4302 -> LinuxSyscall.Ppoll
    | 4303 -> LinuxSyscall.Unshare
    | 4304 -> LinuxSyscall.Splice
    | 4305 -> LinuxSyscall.SyncFileRange
    | 4306 -> LinuxSyscall.Tee
    | 4307 -> LinuxSyscall.Vmsplice
    | 4308 -> LinuxSyscall.MovePages
    | 4309 -> LinuxSyscall.SetRobustList
    | 4310 -> LinuxSyscall.GetRobustList
    | 4311 -> LinuxSyscall.KexecLoad
    | 4312 -> LinuxSyscall.Getcpu
    | 4313 -> LinuxSyscall.EpollPwait
    | 4314 -> LinuxSyscall.IoprioSet
    | 4315 -> LinuxSyscall.IoprioGet
    | 4316 -> LinuxSyscall.Utimensat
    | 4317 -> LinuxSyscall.Signalfd
    | 4319 -> LinuxSyscall.Eventfd
    | 4320 -> LinuxSyscall.Fallocate
    | 4321 -> LinuxSyscall.TimerfdCreate
    | 4322 -> LinuxSyscall.TimerfdGettime
    | 4323 -> LinuxSyscall.TimerfdSettime
    | 4324 -> LinuxSyscall.Signalfd4
    | 4325 -> LinuxSyscall.Eventfd2
    | 4326 -> LinuxSyscall.EpollCreate1
    | 4327 -> LinuxSyscall.Dup3
    | 4328 -> LinuxSyscall.Pipe2
    | 4329 -> LinuxSyscall.InotifyInit1
    | 4330 -> LinuxSyscall.Preadv
    | 4331 -> LinuxSyscall.Pwritev
    | 4332 -> LinuxSyscall.RtTgsigqueueinfo
    | 4333 -> LinuxSyscall.PerfEventOpen
    | 4334 -> LinuxSyscall.Accept4
    | 4335 -> LinuxSyscall.Recvmmsg
    | 4336 -> LinuxSyscall.FanotifyInit
    | 4337 -> LinuxSyscall.FanotifyMark
    | 4338 -> LinuxSyscall.Prlimit64
    | 4339 -> LinuxSyscall.NameToHandleAt
    | 4340 -> LinuxSyscall.OpenByHandleAt
    | 4341 -> LinuxSyscall.ClockAdjtime
    | 4342 -> LinuxSyscall.Syncfs
    | 4343 -> LinuxSyscall.Sendmmsg
    | 4344 -> LinuxSyscall.Setns
    | 4345 -> LinuxSyscall.ProcessVmReadv
    | 4346 -> LinuxSyscall.ProcessVmWritev
    | 4347 -> LinuxSyscall.Kcmp
    | 4348 -> LinuxSyscall.FinitModule
    | 4349 -> LinuxSyscall.SchedSetattr
    | 4350 -> LinuxSyscall.SchedGetattr
    | 4351 -> LinuxSyscall.Renameat2
    | 4352 -> LinuxSyscall.Seccomp
    | 4353 -> LinuxSyscall.Getrandom
    | 4354 -> LinuxSyscall.MemfdCreate
    | 4355 -> LinuxSyscall.Bpf
    | 4356 -> LinuxSyscall.Execveat
    | 4357 -> LinuxSyscall.Userfaultfd
    | 4358 -> LinuxSyscall.Membarrier
    | 4359 -> LinuxSyscall.Mlock2
    | 4360 -> LinuxSyscall.CopyFileRange
    | 4361 -> LinuxSyscall.Preadv2
    | 4362 -> LinuxSyscall.Pwritev2
    | 4363 -> LinuxSyscall.PkeyMprotect
    | 4364 -> LinuxSyscall.PkeyAlloc
    | 4365 -> LinuxSyscall.PkeyFree
    | 4366 -> LinuxSyscall.Statx
    | 4367 -> LinuxSyscall.Rseq
    | 4368 -> LinuxSyscall.IoPgetevents
    | 4393 -> LinuxSyscall.Semget
    | 4394 -> LinuxSyscall.Semctl
    | 4395 -> LinuxSyscall.Shmget
    | 4396 -> LinuxSyscall.Shmctl
    | 4397 -> LinuxSyscall.Shmat
    | 4398 -> LinuxSyscall.Shmdt
    | 4399 -> LinuxSyscall.Msgget
    | 4400 -> LinuxSyscall.Msgsnd
    | 4401 -> LinuxSyscall.Msgrcv
    | 4402 -> LinuxSyscall.Msgctl
    | 4403 -> LinuxSyscall.ClockGettime64
    | 4404 -> LinuxSyscall.ClockSettime64
    | 4405 -> LinuxSyscall.ClockAdjtime64
    | 4406 -> LinuxSyscall.ClockGetres64
    | 4407 -> LinuxSyscall.ClockNanosleep64
    | 4408 -> LinuxSyscall.TimerGettime64
    | 4409 -> LinuxSyscall.TimerSettime64
    | 4410 -> LinuxSyscall.TimerfdGettime64
    | 4411 -> LinuxSyscall.TimerfdSettime64
    | 4412 -> LinuxSyscall.Utimensat64
    | 4413 -> LinuxSyscall.Pselect6_64
    | 4414 -> LinuxSyscall.Ppoll64
    | 4416 -> LinuxSyscall.IoPgetevents64
    | 4417 -> LinuxSyscall.Recvmmsg64
    | 4418 -> LinuxSyscall.MqTimedsend64
    | 4419 -> LinuxSyscall.MqTimedreceive64
    | 4420 -> LinuxSyscall.Semtimedop64
    | 4421 -> LinuxSyscall.RtSigtimedwait64
    | 4422 -> LinuxSyscall.Futex64
    | 4423 -> LinuxSyscall.SchedRrGetInterval64
    | 4424 -> LinuxSyscall.PidfdSendSignal
    | 4425 -> LinuxSyscall.IoUringSetup
    | 4426 -> LinuxSyscall.IoUringEnter
    | 4427 -> LinuxSyscall.IoUringRegister
    | 4428 -> LinuxSyscall.OpenTree
    | 4429 -> LinuxSyscall.MoveMount
    | 4430 -> LinuxSyscall.Fsopen
    | 4431 -> LinuxSyscall.Fsconfig
    | 4432 -> LinuxSyscall.Fsmount
    | 4433 -> LinuxSyscall.Fspick
    | 4434 -> LinuxSyscall.PidfdOpen
    | 4435 -> LinuxSyscall.Clone3
    | 4437 -> LinuxSyscall.Openat2
    | 4438 -> LinuxSyscall.PidfdGetfd
    | _ -> raise UnhandledSyscallException

  let private getMIPSN64Syscall = function
    | 5000 -> LinuxSyscall.Read
    | 5001 -> LinuxSyscall.Write
    | 5002 -> LinuxSyscall.Open
    | 5003 -> LinuxSyscall.Close
    | 5004 -> LinuxSyscall.Stat
    | 5005 -> LinuxSyscall.Fstat
    | 5006 -> LinuxSyscall.Lstat
    | 5007 -> LinuxSyscall.Poll
    | 5008 -> LinuxSyscall.Lseek
    | 5009 -> LinuxSyscall.Mmap
    | 5010 -> LinuxSyscall.Mprotect
    | 5011 -> LinuxSyscall.Munmap
    | 5012 -> LinuxSyscall.Brk
    | 5013 -> LinuxSyscall.RtSigaction
    | 5014 -> LinuxSyscall.RtSigprocmask
    | 5015 -> LinuxSyscall.Ioctl
    | 5016 -> LinuxSyscall.Pread64
    | 5017 -> LinuxSyscall.Pwrite64
    | 5018 -> LinuxSyscall.Readv
    | 5019 -> LinuxSyscall.Writev
    | 5020 -> LinuxSyscall.Access
    | 5021 -> LinuxSyscall.Pipe
    | 5022 -> LinuxSyscall.NewSelect
    | 5023 -> LinuxSyscall.SchedYield
    | 5024 -> LinuxSyscall.Mremap
    | 5025 -> LinuxSyscall.Msync
    | 5026 -> LinuxSyscall.Mincore
    | 5027 -> LinuxSyscall.Madvise
    | 5028 -> LinuxSyscall.Shmget
    | 5029 -> LinuxSyscall.Shmat
    | 5030 -> LinuxSyscall.Shmctl
    | 5031 -> LinuxSyscall.Dup
    | 5032 -> LinuxSyscall.Dup2
    | 5033 -> LinuxSyscall.Pause
    | 5034 -> LinuxSyscall.Nanosleep
    | 5035 -> LinuxSyscall.Getitimer
    | 5036 -> LinuxSyscall.Setitimer
    | 5037 -> LinuxSyscall.Alarm
    | 5038 -> LinuxSyscall.Getpid
    | 5039 -> LinuxSyscall.Sendfile
    | 5040 -> LinuxSyscall.Socket
    | 5041 -> LinuxSyscall.Connect
    | 5042 -> LinuxSyscall.Accept
    | 5043 -> LinuxSyscall.Sendto
    | 5044 -> LinuxSyscall.Recvfrom
    | 5045 -> LinuxSyscall.Sendmsg
    | 5046 -> LinuxSyscall.Recvmsg
    | 5047 -> LinuxSyscall.Shutdown
    | 5048 -> LinuxSyscall.Bind
    | 5049 -> LinuxSyscall.Listen
    | 5050 -> LinuxSyscall.Getsockname
    | 5051 -> LinuxSyscall.Getpeername
    | 5052 -> LinuxSyscall.Socketpair
    | 5053 -> LinuxSyscall.Setsockopt
    | 5054 -> LinuxSyscall.Getsockopt
    | 5055 -> LinuxSyscall.Clone
    | 5056 -> LinuxSyscall.Fork
    | 5057 -> LinuxSyscall.Execve
    | 5058 -> LinuxSyscall.Exit
    | 5059 -> LinuxSyscall.Wait4
    | 5060 -> LinuxSyscall.Kill
    | 5061 -> LinuxSyscall.Uname
    | 5062 -> LinuxSyscall.Semget
    | 5063 -> LinuxSyscall.Semop
    | 5064 -> LinuxSyscall.Semctl
    | 5065 -> LinuxSyscall.Shmdt
    | 5066 -> LinuxSyscall.Msgget
    | 5067 -> LinuxSyscall.Msgsnd
    | 5068 -> LinuxSyscall.Msgrcv
    | 5069 -> LinuxSyscall.Msgctl
    | 5070 -> LinuxSyscall.Fcntl
    | 5071 -> LinuxSyscall.Flock
    | 5072 -> LinuxSyscall.Fsync
    | 5073 -> LinuxSyscall.Fdatasync
    | 5074 -> LinuxSyscall.Truncate
    | 5075 -> LinuxSyscall.Ftruncate
    | 5076 -> LinuxSyscall.Getdents
    | 5077 -> LinuxSyscall.Getcwd
    | 5078 -> LinuxSyscall.Chdir
    | 5079 -> LinuxSyscall.Fchdir
    | 5080 -> LinuxSyscall.Rename
    | 5081 -> LinuxSyscall.Mkdir
    | 5082 -> LinuxSyscall.Rmdir
    | 5083 -> LinuxSyscall.Creat
    | 5084 -> LinuxSyscall.Link
    | 5085 -> LinuxSyscall.Unlink
    | 5086 -> LinuxSyscall.Symlink
    | 5087 -> LinuxSyscall.Readlink
    | 5088 -> LinuxSyscall.Chmod
    | 5089 -> LinuxSyscall.Fchmod
    | 5090 -> LinuxSyscall.Chown
    | 5091 -> LinuxSyscall.Fchown
    | 5092 -> LinuxSyscall.Lchown
    | 5093 -> LinuxSyscall.Umask
    | 5094 -> LinuxSyscall.Gettimeofday
    | 5095 -> LinuxSyscall.Getrlimit
    | 5096 -> LinuxSyscall.Getrusage
    | 5097 -> LinuxSyscall.Sysinfo
    | 5098 -> LinuxSyscall.Times
    | 5099 -> LinuxSyscall.Ptrace
    | 5100 -> LinuxSyscall.Getuid
    | 5101 -> LinuxSyscall.Syslog
    | 5102 -> LinuxSyscall.Getgid
    | 5103 -> LinuxSyscall.Setuid
    | 5104 -> LinuxSyscall.Setgid
    | 5105 -> LinuxSyscall.Geteuid
    | 5106 -> LinuxSyscall.Getegid
    | 5107 -> LinuxSyscall.Setpgid
    | 5108 -> LinuxSyscall.Getppid
    | 5109 -> LinuxSyscall.Getpgrp
    | 5110 -> LinuxSyscall.Setsid
    | 5111 -> LinuxSyscall.Setreuid
    | 5112 -> LinuxSyscall.Setregid
    | 5113 -> LinuxSyscall.Getgroups
    | 5114 -> LinuxSyscall.Setgroups
    | 5115 -> LinuxSyscall.Setresuid
    | 5116 -> LinuxSyscall.Getresuid
    | 5117 -> LinuxSyscall.Setresgid
    | 5118 -> LinuxSyscall.Getresgid
    | 5119 -> LinuxSyscall.Getpgid
    | 5120 -> LinuxSyscall.Setfsuid
    | 5121 -> LinuxSyscall.Setfsgid
    | 5122 -> LinuxSyscall.Getsid
    | 5123 -> LinuxSyscall.CapGet
    | 5124 -> LinuxSyscall.CapSet
    | 5125 -> LinuxSyscall.RtSigpending
    | 5126 -> LinuxSyscall.RtSigtimedwait
    | 5127 -> LinuxSyscall.RtSigqueueinfo
    | 5128 -> LinuxSyscall.RtSigsuspend
    | 5129 -> LinuxSyscall.Sigaltstack
    | 5130 -> LinuxSyscall.Utime
    | 5131 -> LinuxSyscall.Mknod
    | 5132 -> LinuxSyscall.Personality
    | 5133 -> LinuxSyscall.Ustat
    | 5134 -> LinuxSyscall.Statfs
    | 5135 -> LinuxSyscall.Fstatfs
    | 5136 -> LinuxSyscall.Sysfs
    | 5137 -> LinuxSyscall.Getpriority
    | 5138 -> LinuxSyscall.Setpriority
    | 5139 -> LinuxSyscall.SchedSetparam
    | 5140 -> LinuxSyscall.SchedGetparam
    | 5141 -> LinuxSyscall.SchedSetscheduler
    | 5142 -> LinuxSyscall.SchedGetscheduler
    | 5143 -> LinuxSyscall.SchedGetPriorityMax
    | 5144 -> LinuxSyscall.SchedGetPriorityMin
    | 5145 -> LinuxSyscall.SchedRrGetInterval
    | 5146 -> LinuxSyscall.Mlock
    | 5147 -> LinuxSyscall.Munlock
    | 5148 -> LinuxSyscall.Mlockall
    | 5149 -> LinuxSyscall.Munlockall
    | 5150 -> LinuxSyscall.Vhangup
    | 5151 -> LinuxSyscall.PivotRoot
    | 5152 -> LinuxSyscall.Sysctl
    | 5153 -> LinuxSyscall.Prctl
    | 5154 -> LinuxSyscall.AdjTimex
    | 5155 -> LinuxSyscall.Setrlimit
    | 5156 -> LinuxSyscall.Chroot
    | 5157 -> LinuxSyscall.Sync
    | 5158 -> LinuxSyscall.Acct
    | 5159 -> LinuxSyscall.Settimeofday
    | 5160 -> LinuxSyscall.Mount
    | 5161 -> LinuxSyscall.Umount2
    | 5162 -> LinuxSyscall.Swapon
    | 5163 -> LinuxSyscall.Swapoff
    | 5164 -> LinuxSyscall.Reboot
    | 5165 -> LinuxSyscall.Sethostname
    | 5166 -> LinuxSyscall.Setdomainname
    | 5167 -> LinuxSyscall.CreateModule
    | 5168 -> LinuxSyscall.InitModule
    | 5169 -> LinuxSyscall.DeleteModule
    | 5170 -> LinuxSyscall.GetKernelSyms
    | 5171 -> LinuxSyscall.QueryModule
    | 5172 -> LinuxSyscall.Quotactl
    | 5173 -> LinuxSyscall.Nfsservctl
    | 5178 -> LinuxSyscall.Gettid
    | 5179 -> LinuxSyscall.Readahead
    | 5180 -> LinuxSyscall.Setxattr
    | 5181 -> LinuxSyscall.Lsetxattr
    | 5182 -> LinuxSyscall.Fsetxattr
    | 5183 -> LinuxSyscall.Getxattr
    | 5184 -> LinuxSyscall.Lgetxattr
    | 5185 -> LinuxSyscall.Fgetxattr
    | 5186 -> LinuxSyscall.Listxattr
    | 5187 -> LinuxSyscall.Llistxattr
    | 5188 -> LinuxSyscall.Flistxattr
    | 5189 -> LinuxSyscall.Removexattr
    | 5190 -> LinuxSyscall.Lremovexattr
    | 5191 -> LinuxSyscall.Fremovexattr
    | 5192 -> LinuxSyscall.Tkill
    | 5194 -> LinuxSyscall.Futex
    | 5195 -> LinuxSyscall.SchedSetaffinity
    | 5196 -> LinuxSyscall.SchedGetaffinity
    | 5197 -> LinuxSyscall.CacheFlush
    | 5198 -> LinuxSyscall.CacheCtl
    | 5199 -> LinuxSyscall.Sysmips
    | 5200 -> LinuxSyscall.IoSetup
    | 5201 -> LinuxSyscall.IoDestroy
    | 5202 -> LinuxSyscall.IoGetevents
    | 5203 -> LinuxSyscall.IoSubmit
    | 5204 -> LinuxSyscall.IoCancel
    | 5205 -> LinuxSyscall.ExitGroup
    | 5206 -> LinuxSyscall.LookupDcookie
    | 5207 -> LinuxSyscall.EpollCreate
    | 5208 -> LinuxSyscall.EpollCtl
    | 5209 -> LinuxSyscall.EpollWait
    | 5210 -> LinuxSyscall.RemapFilePages
    | 5211 -> LinuxSyscall.RtSigreturn
    | 5212 -> LinuxSyscall.SetTidAddress
    | 5213 -> LinuxSyscall.RestartSyscall
    | 5214 -> LinuxSyscall.Semtimedop
    | 5215 -> LinuxSyscall.Fadvise64
    | 5216 -> LinuxSyscall.TimerCreate
    | 5217 -> LinuxSyscall.TimerSettime
    | 5218 -> LinuxSyscall.TimerGettime
    | 5219 -> LinuxSyscall.TimerGetoverrun
    | 5220 -> LinuxSyscall.TimerDelete
    | 5221 -> LinuxSyscall.ClockSettime
    | 5222 -> LinuxSyscall.ClockGettime
    | 5223 -> LinuxSyscall.ClockGetres
    | 5224 -> LinuxSyscall.ClockNanosleep
    | 5225 -> LinuxSyscall.Tgkill
    | 5226 -> LinuxSyscall.Utimes
    | 5227 -> LinuxSyscall.Mbind
    | 5228 -> LinuxSyscall.GetMempolicy
    | 5229 -> LinuxSyscall.SetMempolicy
    | 5230 -> LinuxSyscall.MqOpen
    | 5231 -> LinuxSyscall.MqUnlink
    | 5232 -> LinuxSyscall.MqTimedsend
    | 5233 -> LinuxSyscall.MqTimedreceive
    | 5234 -> LinuxSyscall.MqNotify
    | 5235 -> LinuxSyscall.MqGetsetattr
    | 5236 -> LinuxSyscall.Vserver
    | 5237 -> LinuxSyscall.Waitid
    | 5239 -> LinuxSyscall.AddKey
    | 5240 -> LinuxSyscall.RequestKey
    | 5241 -> LinuxSyscall.Keyctl
    | 5242 -> LinuxSyscall.SetThreadArea
    | 5243 -> LinuxSyscall.InotifyInit
    | 5244 -> LinuxSyscall.InotifyAddWatch
    | 5245 -> LinuxSyscall.InotifyRmWatch
    | 5246 -> LinuxSyscall.MigratePages
    | 5247 -> LinuxSyscall.Openat
    | 5248 -> LinuxSyscall.Mkdirat
    | 5249 -> LinuxSyscall.Mknodat
    | 5250 -> LinuxSyscall.Fchownat
    | 5251 -> LinuxSyscall.Futimesat
    | 5252 -> LinuxSyscall.Newfstatat
    | 5253 -> LinuxSyscall.Unlinkat
    | 5254 -> LinuxSyscall.Renameat
    | 5255 -> LinuxSyscall.Linkat
    | 5256 -> LinuxSyscall.Symlinkat
    | 5257 -> LinuxSyscall.Readlinkat
    | 5258 -> LinuxSyscall.Fchmodat
    | 5259 -> LinuxSyscall.Faccessat
    | 5260 -> LinuxSyscall.Pselect6
    | 5261 -> LinuxSyscall.Ppoll
    | 5262 -> LinuxSyscall.Unshare
    | 5263 -> LinuxSyscall.Splice
    | 5264 -> LinuxSyscall.SyncFileRange
    | 5265 -> LinuxSyscall.Tee
    | 5266 -> LinuxSyscall.Vmsplice
    | 5267 -> LinuxSyscall.MovePages
    | 5268 -> LinuxSyscall.SetRobustList
    | 5269 -> LinuxSyscall.GetRobustList
    | 5270 -> LinuxSyscall.KexecLoad
    | 5271 -> LinuxSyscall.Getcpu
    | 5272 -> LinuxSyscall.EpollPwait
    | 5273 -> LinuxSyscall.IoprioSet
    | 5274 -> LinuxSyscall.IoprioGet
    | 5275 -> LinuxSyscall.Utimensat
    | 5276 -> LinuxSyscall.Signalfd
    | 5277 -> LinuxSyscall.Timerfd
    | 5278 -> LinuxSyscall.Eventfd
    | 5279 -> LinuxSyscall.Fallocate
    | 5280 -> LinuxSyscall.TimerfdCreate
    | 5281 -> LinuxSyscall.TimerfdGettime
    | 5282 -> LinuxSyscall.TimerfdSettime
    | 5283 -> LinuxSyscall.Signalfd4
    | 5284 -> LinuxSyscall.Eventfd2
    | 5285 -> LinuxSyscall.EpollCreate1
    | 5286 -> LinuxSyscall.Dup3
    | 5287 -> LinuxSyscall.Pipe2
    | 5288 -> LinuxSyscall.InotifyInit1
    | 5289 -> LinuxSyscall.Preadv
    | 5290 -> LinuxSyscall.Pwritev
    | 5291 -> LinuxSyscall.RtTgsigqueueinfo
    | 5292 -> LinuxSyscall.PerfEventOpen
    | 5293 -> LinuxSyscall.Accept4
    | 5294 -> LinuxSyscall.Recvmmsg
    | 5295 -> LinuxSyscall.FanotifyInit
    | 5296 -> LinuxSyscall.FanotifyMark
    | 5297 -> LinuxSyscall.Prlimit64
    | 5298 -> LinuxSyscall.NameToHandleAt
    | 5299 -> LinuxSyscall.OpenByHandleAt
    | 5300 -> LinuxSyscall.ClockAdjtime
    | 5301 -> LinuxSyscall.Syncfs
    | 5302 -> LinuxSyscall.Sendmmsg
    | 5303 -> LinuxSyscall.Setns
    | 5304 -> LinuxSyscall.ProcessVmReadv
    | 5305 -> LinuxSyscall.ProcessVmWritev
    | 5306 -> LinuxSyscall.Kcmp
    | 5307 -> LinuxSyscall.FinitModule
    | 5308 -> LinuxSyscall.Getdents64
    | 5309 -> LinuxSyscall.SchedSetattr
    | 5310 -> LinuxSyscall.SchedGetattr
    | 5311 -> LinuxSyscall.Renameat2
    | 5312 -> LinuxSyscall.Seccomp
    | 5313 -> LinuxSyscall.Getrandom
    | 5314 -> LinuxSyscall.MemfdCreate
    | 5315 -> LinuxSyscall.Bpf
    | 5316 -> LinuxSyscall.Execveat
    | 5317 -> LinuxSyscall.Userfaultfd
    | 5318 -> LinuxSyscall.Membarrier
    | 5319 -> LinuxSyscall.Mlock2
    | 5320 -> LinuxSyscall.CopyFileRange
    | 5321 -> LinuxSyscall.Preadv2
    | 5322 -> LinuxSyscall.Pwritev2
    | 5323 -> LinuxSyscall.PkeyMprotect
    | 5324 -> LinuxSyscall.PkeyAlloc
    | 5325 -> LinuxSyscall.PkeyFree
    | 5326 -> LinuxSyscall.Statx
    | 5327 -> LinuxSyscall.Rseq
    | 5328 -> LinuxSyscall.IoPgetevents
    | 5424 -> LinuxSyscall.PidfdSendSignal
    | 5425 -> LinuxSyscall.IoUringSetup
    | 5426 -> LinuxSyscall.IoUringEnter
    | 5427 -> LinuxSyscall.IoUringRegister
    | 5428 -> LinuxSyscall.OpenTree
    | 5429 -> LinuxSyscall.MoveMount
    | 5430 -> LinuxSyscall.Fsopen
    | 5431 -> LinuxSyscall.Fsconfig
    | 5432 -> LinuxSyscall.Fsmount
    | 5433 -> LinuxSyscall.Fspick
    | 5434 -> LinuxSyscall.PidfdOpen
    | 5435 -> LinuxSyscall.Clone3
    | 5436 -> LinuxSyscall.CloseRange
    | 5437 -> LinuxSyscall.Openat2
    | 5438 -> LinuxSyscall.PidfdGetfd
    | _ -> raise UnhandledSyscallException

  let private getPPC32Syscall = function
    | 0 -> LinuxSyscall.RestartSyscall
    | 1 -> LinuxSyscall.Exit
    | 2 -> LinuxSyscall.Fork
    | 3 -> LinuxSyscall.Read
    | 4 -> LinuxSyscall.Write
    | 5 -> LinuxSyscall.Open
    | 6 -> LinuxSyscall.Close
    | 7 -> LinuxSyscall.Waitpid
    | 8 -> LinuxSyscall.Creat
    | 9 -> LinuxSyscall.Link
    | 10 -> LinuxSyscall.Unlink
    | 11 -> LinuxSyscall.Execve
    | 12 -> LinuxSyscall.Chdir
    | 13 -> LinuxSyscall.Time
    | 14 -> LinuxSyscall.Mknod
    | 15 -> LinuxSyscall.Chmod
    | 16 -> LinuxSyscall.Lchown
    | 18 -> LinuxSyscall.Oldstat
    | 19 -> LinuxSyscall.Lseek
    | 20 -> LinuxSyscall.Getpid
    | 21 -> LinuxSyscall.Mount
    | 22 -> LinuxSyscall.Umount
    | 23 -> LinuxSyscall.Setuid
    | 24 -> LinuxSyscall.Getuid
    | 25 -> LinuxSyscall.Stime
    | 26 -> LinuxSyscall.Ptrace
    | 27 -> LinuxSyscall.Alarm
    | 28 -> LinuxSyscall.Oldfstat
    | 29 -> LinuxSyscall.Pause
    | 30 -> LinuxSyscall.Utime
    | 33 -> LinuxSyscall.Access
    | 34 -> LinuxSyscall.Nice
    | 36 -> LinuxSyscall.Sync
    | 37 -> LinuxSyscall.Kill
    | 38 -> LinuxSyscall.Rename
    | 39 -> LinuxSyscall.Mkdir
    | 40 -> LinuxSyscall.Rmdir
    | 41 -> LinuxSyscall.Dup
    | 42 -> LinuxSyscall.Pipe
    | 43 -> LinuxSyscall.Times
    | 45 -> LinuxSyscall.Brk
    | 46 -> LinuxSyscall.Setgid
    | 47 -> LinuxSyscall.Getgid
    | 48 -> LinuxSyscall.Signal
    | 49 -> LinuxSyscall.Geteuid
    | 50 -> LinuxSyscall.Getegid
    | 51 -> LinuxSyscall.Acct
    | 52 -> LinuxSyscall.Umount2
    | 54 -> LinuxSyscall.Ioctl
    | 55 -> LinuxSyscall.Fcntl
    | 57 -> LinuxSyscall.Setpgid
    | 59 -> LinuxSyscall.Oldolduname
    | 60 -> LinuxSyscall.Umask
    | 61 -> LinuxSyscall.Chroot
    | 62 -> LinuxSyscall.Ustat
    | 63 -> LinuxSyscall.Dup2
    | 64 -> LinuxSyscall.Getppid
    | 65 -> LinuxSyscall.Getpgrp
    | 66 -> LinuxSyscall.Setsid
    | 67 -> LinuxSyscall.Sigaction
    | 68 -> LinuxSyscall.Sgetmask
    | 69 -> LinuxSyscall.Ssetmask
    | 70 -> LinuxSyscall.Setreuid
    | 71 -> LinuxSyscall.Setregid
    | 72 -> LinuxSyscall.Sigsuspend
    | 73 -> LinuxSyscall.Sigpending
    | 74 -> LinuxSyscall.Sethostname
    | 75 -> LinuxSyscall.Setrlimit
    | 76 -> LinuxSyscall.Getrlimit
    | 77 -> LinuxSyscall.Getrusage
    | 78 -> LinuxSyscall.Gettimeofday
    | 79 -> LinuxSyscall.Settimeofday
    | 80 -> LinuxSyscall.Getgroups
    | 81 -> LinuxSyscall.Setgroups
    | 82 -> LinuxSyscall.Select
    | 83 -> LinuxSyscall.Symlink
    | 84 -> LinuxSyscall.Oldlstat
    | 85 -> LinuxSyscall.Readlink
    | 86 -> LinuxSyscall.Uselib
    | 87 -> LinuxSyscall.Swapon
    | 88 -> LinuxSyscall.Reboot
    | 89 -> LinuxSyscall.Readdir
    | 90 -> LinuxSyscall.Mmap
    | 91 -> LinuxSyscall.Munmap
    | 92 -> LinuxSyscall.Truncate
    | 93 -> LinuxSyscall.Ftruncate
    | 94 -> LinuxSyscall.Fchmod
    | 95 -> LinuxSyscall.Fchown
    | 96 -> LinuxSyscall.Getpriority
    | 97 -> LinuxSyscall.Setpriority
    | 99 -> LinuxSyscall.Statfs
    | 100 -> LinuxSyscall.Fstatfs
    | 101 -> LinuxSyscall.Ioperm
    | 102 -> LinuxSyscall.Socketcall
    | 103 -> LinuxSyscall.Syslog
    | 104 -> LinuxSyscall.Setitimer
    | 105 -> LinuxSyscall.Getitimer
    | 106 -> LinuxSyscall.Stat
    | 107 -> LinuxSyscall.Lstat
    | 108 -> LinuxSyscall.Fstat
    | 109 -> LinuxSyscall.Olduname
    | 110 -> LinuxSyscall.Iopl
    | 111 -> LinuxSyscall.Vhangup
    | 113 -> LinuxSyscall.Vm86
    | 114 -> LinuxSyscall.Wait4
    | 115 -> LinuxSyscall.Swapoff
    | 116 -> LinuxSyscall.Sysinfo
    | 117 -> LinuxSyscall.Ipc
    | 118 -> LinuxSyscall.Fsync
    | 119 -> LinuxSyscall.Sigreturn
    | 120 -> LinuxSyscall.Clone
    | 121 -> LinuxSyscall.Setdomainname
    | 122 -> LinuxSyscall.Uname
    | 123 -> LinuxSyscall.ModifyLdt
    | 124 -> LinuxSyscall.AdjTimex
    | 125 -> LinuxSyscall.Mprotect
    | 126 -> LinuxSyscall.Sigprocmask
    | 127 -> LinuxSyscall.CreateModule
    | 128 -> LinuxSyscall.InitModule
    | 129 -> LinuxSyscall.DeleteModule
    | 130 -> LinuxSyscall.GetKernelSyms
    | 131 -> LinuxSyscall.Quotactl
    | 132 -> LinuxSyscall.Getpgid
    | 133 -> LinuxSyscall.Fchdir
    | 134 -> LinuxSyscall.Bdflush
    | 135 -> LinuxSyscall.Sysfs
    | 136 -> LinuxSyscall.Personality
    | 138 -> LinuxSyscall.Setfsuid
    | 139 -> LinuxSyscall.Setfsgid
    | 140 -> LinuxSyscall.LLseek
    | 141 -> LinuxSyscall.Getdents
    | 142 -> LinuxSyscall.NewSelect
    | 143 -> LinuxSyscall.Flock
    | 144 -> LinuxSyscall.Msync
    | 145 -> LinuxSyscall.Readv
    | 146 -> LinuxSyscall.Writev
    | 147 -> LinuxSyscall.Getsid
    | 148 -> LinuxSyscall.Fdatasync
    | 149 -> LinuxSyscall.Sysctl
    | 150 -> LinuxSyscall.Mlock
    | 151 -> LinuxSyscall.Munlock
    | 152 -> LinuxSyscall.Mlockall
    | 153 -> LinuxSyscall.Munlockall
    | 154 -> LinuxSyscall.SchedSetparam
    | 155 -> LinuxSyscall.SchedGetparam
    | 156 -> LinuxSyscall.SchedSetscheduler
    | 157 -> LinuxSyscall.SchedGetscheduler
    | 158 -> LinuxSyscall.SchedYield
    | 159 -> LinuxSyscall.SchedGetPriorityMax
    | 160 -> LinuxSyscall.SchedGetPriorityMin
    | 161 -> LinuxSyscall.SchedRrGetInterval
    | 162 -> LinuxSyscall.Nanosleep
    | 163 -> LinuxSyscall.Mremap
    | 164 -> LinuxSyscall.Setresuid
    | 165 -> LinuxSyscall.Getresuid
    | 166 -> LinuxSyscall.QueryModule
    | 167 -> LinuxSyscall.Poll
    | 168 -> LinuxSyscall.Nfsservctl
    | 169 -> LinuxSyscall.Setresgid
    | 170 -> LinuxSyscall.Getresgid
    | 171 -> LinuxSyscall.Prctl
    | 172 -> LinuxSyscall.RtSigreturn
    | 173 -> LinuxSyscall.RtSigaction
    | 174 -> LinuxSyscall.RtSigprocmask
    | 175 -> LinuxSyscall.RtSigpending
    | 176 -> LinuxSyscall.RtSigtimedwait
    | 177 -> LinuxSyscall.RtSigqueueinfo
    | 178 -> LinuxSyscall.RtSigsuspend
    | 179 -> LinuxSyscall.Pread64
    | 180 -> LinuxSyscall.Pwrite64
    | 181 -> LinuxSyscall.Chown
    | 182 -> LinuxSyscall.Getcwd
    | 183 -> LinuxSyscall.CapGet
    | 184 -> LinuxSyscall.CapSet
    | 185 -> LinuxSyscall.Sigaltstack
    | 186 -> LinuxSyscall.Sendfile
    | 189 -> LinuxSyscall.Vfork
    | 190 -> LinuxSyscall.Ugetrlimit
    | 191 -> LinuxSyscall.Readahead
    | 192 -> LinuxSyscall.Mmap2
    | 193 -> LinuxSyscall.Truncate64
    | 194 -> LinuxSyscall.Ftruncate64
    | 195 -> LinuxSyscall.Stat64
    | 196 -> LinuxSyscall.Lstat64
    | 197 -> LinuxSyscall.Fstat64
    | 198 -> LinuxSyscall.PciconfigRead
    | 199 -> LinuxSyscall.PciconfigWrite
    | 200 -> LinuxSyscall.PciconfigIobase
    | 202 -> LinuxSyscall.Getdents64
    | 203 -> LinuxSyscall.PivotRoot
    | 204 -> LinuxSyscall.Fcntl64
    | 205 -> LinuxSyscall.Madvise
    | 206 -> LinuxSyscall.Mincore
    | 207 -> LinuxSyscall.Gettid
    | 208 -> LinuxSyscall.Tkill
    | 209 -> LinuxSyscall.Setxattr
    | 210 -> LinuxSyscall.Lsetxattr
    | 211 -> LinuxSyscall.Fsetxattr
    | 212 -> LinuxSyscall.Getxattr
    | 213 -> LinuxSyscall.Lgetxattr
    | 214 -> LinuxSyscall.Fgetxattr
    | 215 -> LinuxSyscall.Listxattr
    | 216 -> LinuxSyscall.Llistxattr
    | 217 -> LinuxSyscall.Flistxattr
    | 218 -> LinuxSyscall.Removexattr
    | 219 -> LinuxSyscall.Lremovexattr
    | 220 -> LinuxSyscall.Fremovexattr
    | 221 -> LinuxSyscall.Futex
    | 222 -> LinuxSyscall.SchedSetaffinity
    | 223 -> LinuxSyscall.SchedGetaffinity
    | 226 -> LinuxSyscall.Sendfile64
    | 227 -> LinuxSyscall.IoSetup
    | 228 -> LinuxSyscall.IoDestroy
    | 229 -> LinuxSyscall.IoGetevents
    | 230 -> LinuxSyscall.IoSubmit
    | 231 -> LinuxSyscall.IoCancel
    | 232 -> LinuxSyscall.SetTidAddress
    | 233 -> LinuxSyscall.Fadvise64
    | 234 -> LinuxSyscall.ExitGroup
    | 235 -> LinuxSyscall.LookupDcookie
    | 236 -> LinuxSyscall.EpollCreate
    | 237 -> LinuxSyscall.EpollCtl
    | 238 -> LinuxSyscall.EpollWait
    | 239 -> LinuxSyscall.RemapFilePages
    | 240 -> LinuxSyscall.TimerCreate
    | 241 -> LinuxSyscall.TimerSettime
    | 242 -> LinuxSyscall.TimerGettime
    | 243 -> LinuxSyscall.TimerGetoverrun
    | 244 -> LinuxSyscall.TimerDelete
    | 245 -> LinuxSyscall.ClockSettime
    | 246 -> LinuxSyscall.ClockGettime
    | 247 -> LinuxSyscall.ClockGetres
    | 248 -> LinuxSyscall.ClockNanosleep
    | 249 -> LinuxSyscall.Swapcontext
    | 250 -> LinuxSyscall.Tgkill
    | 251 -> LinuxSyscall.Utimes
    | 252 -> LinuxSyscall.Statfs64
    | 253 -> LinuxSyscall.Fstatfs64
    | 254 -> LinuxSyscall.Fadvise64_64
    | 255 -> LinuxSyscall.Rtas
    | 256 -> LinuxSyscall.SysDebugSetcontext
    | 258 -> LinuxSyscall.MigratePages
    | 259 -> LinuxSyscall.Mbind
    | 260 -> LinuxSyscall.GetMempolicy
    | 261 -> LinuxSyscall.SetMempolicy
    | 262 -> LinuxSyscall.MqOpen
    | 263 -> LinuxSyscall.MqUnlink
    | 264 -> LinuxSyscall.MqTimedsend
    | 265 -> LinuxSyscall.MqTimedreceive
    | 266 -> LinuxSyscall.MqNotify
    | 267 -> LinuxSyscall.MqGetsetattr
    | 268 -> LinuxSyscall.KexecLoad
    | 269 -> LinuxSyscall.AddKey
    | 270 -> LinuxSyscall.RequestKey
    | 271 -> LinuxSyscall.Keyctl
    | 272 -> LinuxSyscall.Waitid
    | 273 -> LinuxSyscall.IoprioSet
    | 274 -> LinuxSyscall.IoprioGet
    | 275 -> LinuxSyscall.InotifyInit
    | 276 -> LinuxSyscall.InotifyAddWatch
    | 277 -> LinuxSyscall.InotifyRmWatch
    | 278 -> LinuxSyscall.SpuRun
    | 279 -> LinuxSyscall.SpuCreate
    | 280 -> LinuxSyscall.Pselect6
    | 281 -> LinuxSyscall.Ppoll
    | 282 -> LinuxSyscall.Unshare
    | 283 -> LinuxSyscall.Splice
    | 284 -> LinuxSyscall.Tee
    | 285 -> LinuxSyscall.Vmsplice
    | 286 -> LinuxSyscall.Openat
    | 287 -> LinuxSyscall.Mkdirat
    | 288 -> LinuxSyscall.Mknodat
    | 289 -> LinuxSyscall.Fchownat
    | 290 -> LinuxSyscall.Futimesat
    | 291 -> LinuxSyscall.Fstatat64
    | 292 -> LinuxSyscall.Unlinkat
    | 293 -> LinuxSyscall.Renameat
    | 294 -> LinuxSyscall.Linkat
    | 295 -> LinuxSyscall.Symlinkat
    | 296 -> LinuxSyscall.Readlinkat
    | 297 -> LinuxSyscall.Fchmodat
    | 298 -> LinuxSyscall.Faccessat
    | 299 -> LinuxSyscall.GetRobustList
    | 300 -> LinuxSyscall.SetRobustList
    | 301 -> LinuxSyscall.MovePages
    | 302 -> LinuxSyscall.Getcpu
    | 303 -> LinuxSyscall.EpollPwait
    | 304 -> LinuxSyscall.Utimensat
    | 305 -> LinuxSyscall.Signalfd
    | 306 -> LinuxSyscall.TimerfdCreate
    | 307 -> LinuxSyscall.Eventfd
    | 308 -> LinuxSyscall.SyncFileRange2
    | 309 -> LinuxSyscall.Fallocate
    | 310 -> LinuxSyscall.SubpageProt
    | 311 -> LinuxSyscall.TimerfdSettime
    | 312 -> LinuxSyscall.TimerfdGettime
    | 313 -> LinuxSyscall.Signalfd4
    | 314 -> LinuxSyscall.Eventfd2
    | 315 -> LinuxSyscall.EpollCreate1
    | 316 -> LinuxSyscall.Dup3
    | 317 -> LinuxSyscall.Pipe2
    | 318 -> LinuxSyscall.InotifyInit1
    | 319 -> LinuxSyscall.PerfEventOpen
    | 320 -> LinuxSyscall.Preadv
    | 321 -> LinuxSyscall.Pwritev
    | 322 -> LinuxSyscall.RtTgsigqueueinfo
    | 323 -> LinuxSyscall.FanotifyInit
    | 324 -> LinuxSyscall.FanotifyMark
    | 325 -> LinuxSyscall.Prlimit64
    | 326 -> LinuxSyscall.Socket
    | 327 -> LinuxSyscall.Bind
    | 328 -> LinuxSyscall.Connect
    | 329 -> LinuxSyscall.Listen
    | 330 -> LinuxSyscall.Accept
    | 331 -> LinuxSyscall.Getsockname
    | 332 -> LinuxSyscall.Getpeername
    | 333 -> LinuxSyscall.Socketpair
    | 334 -> LinuxSyscall.Send
    | 335 -> LinuxSyscall.Sendto
    | 336 -> LinuxSyscall.Recv
    | 337 -> LinuxSyscall.Recvfrom
    | 338 -> LinuxSyscall.Shutdown
    | 339 -> LinuxSyscall.Setsockopt
    | 340 -> LinuxSyscall.Getsockopt
    | 341 -> LinuxSyscall.Sendmsg
    | 342 -> LinuxSyscall.Recvmsg
    | 343 -> LinuxSyscall.Recvmmsg
    | 344 -> LinuxSyscall.Accept4
    | 345 -> LinuxSyscall.NameToHandleAt
    | 346 -> LinuxSyscall.OpenByHandleAt
    | 347 -> LinuxSyscall.ClockAdjtime
    | 348 -> LinuxSyscall.Syncfs
    | 349 -> LinuxSyscall.Sendmmsg
    | 350 -> LinuxSyscall.Setns
    | 351 -> LinuxSyscall.ProcessVmReadv
    | 352 -> LinuxSyscall.ProcessVmWritev
    | 353 -> LinuxSyscall.FinitModule
    | 354 -> LinuxSyscall.Kcmp
    | 355 -> LinuxSyscall.SchedSetattr
    | 356 -> LinuxSyscall.SchedGetattr
    | 357 -> LinuxSyscall.Renameat2
    | 360 -> LinuxSyscall.MemfdCreate
    | _ -> raise UnhandledSyscallException

  let private getRISCV64Syscall = function
    | 0 -> LinuxSyscall.IoSetup
    | 1 -> LinuxSyscall.IoDestroy
    | 2 -> LinuxSyscall.IoSubmit
    | 3 -> LinuxSyscall.IoCancel
    | 4 -> LinuxSyscall.IoGetevents
    | 5 -> LinuxSyscall.Setxattr
    | 6 -> LinuxSyscall.Lsetxattr
    | 7 -> LinuxSyscall.Fsetxattr
    | 8 -> LinuxSyscall.Getxattr
    | 9 -> LinuxSyscall.Lgetxattr
    | 10 -> LinuxSyscall.Fgetxattr
    | 11 -> LinuxSyscall.Listxattr
    | 12 -> LinuxSyscall.Llistxattr
    | 13 -> LinuxSyscall.Flistxattr
    | 14 -> LinuxSyscall.Removexattr
    | 15 -> LinuxSyscall.Lremovexattr
    | 16 -> LinuxSyscall.Fremovexattr
    | 17 -> LinuxSyscall.Getcwd
    | 18 -> LinuxSyscall.LookupDcookie
    | 19 -> LinuxSyscall.Eventfd2
    | 20 -> LinuxSyscall.EpollCreate1
    | 21 -> LinuxSyscall.EpollCtl
    | 22 -> LinuxSyscall.EpollPwait
    | 23 -> LinuxSyscall.Dup
    | 24 -> LinuxSyscall.Dup3
    | 25 -> LinuxSyscall.Fcntl
    | 26 -> LinuxSyscall.InotifyInit1
    | 27 -> LinuxSyscall.InotifyAddWatch
    | 28 -> LinuxSyscall.InotifyRmWatch
    | 29 -> LinuxSyscall.Ioctl
    | 30 -> LinuxSyscall.IoprioSet
    | 31 -> LinuxSyscall.IoprioGet
    | 32 -> LinuxSyscall.Flock
    | 33 -> LinuxSyscall.Mknodat
    | 34 -> LinuxSyscall.Mkdirat
    | 35 -> LinuxSyscall.Unlinkat
    | 36 -> LinuxSyscall.Symlinkat
    | 37 -> LinuxSyscall.Linkat
    | 38 -> LinuxSyscall.Renameat
    | 39 -> LinuxSyscall.Umount2
    | 40 -> LinuxSyscall.Mount
    | 41 -> LinuxSyscall.PivotRoot
    | 42 -> LinuxSyscall.Nfsservctl
    | 43 -> LinuxSyscall.Statfs
    | 44 -> LinuxSyscall.Fstatfs
    | 45 -> LinuxSyscall.Truncate
    | 46 -> LinuxSyscall.Ftruncate
    | 47 -> LinuxSyscall.Fallocate
    | 48 -> LinuxSyscall.Faccessat
    | 49 -> LinuxSyscall.Chdir
    | 50 -> LinuxSyscall.Fchdir
    | 51 -> LinuxSyscall.Chroot
    | 52 -> LinuxSyscall.Fchmod
    | 53 -> LinuxSyscall.Fchmodat
    | 54 -> LinuxSyscall.Fchownat
    | 55 -> LinuxSyscall.Fchown
    | 56 -> LinuxSyscall.Openat
    | 57 -> LinuxSyscall.Close
    | 58 -> LinuxSyscall.Vhangup
    | 59 -> LinuxSyscall.Pipe2
    | 60 -> LinuxSyscall.Quotactl
    | 61 -> LinuxSyscall.Getdents64
    | 62 -> LinuxSyscall.Lseek
    | 63 -> LinuxSyscall.Read
    | 64 -> LinuxSyscall.Write
    | 65 -> LinuxSyscall.Readv
    | 66 -> LinuxSyscall.Writev
    | 67 -> LinuxSyscall.Pread64
    | 68 -> LinuxSyscall.Pwrite64
    | 69 -> LinuxSyscall.Preadv
    | 70 -> LinuxSyscall.Pwritev
    | 71 -> LinuxSyscall.Sendfile
    | 72 -> LinuxSyscall.Pselect6
    | 73 -> LinuxSyscall.Ppoll
    | 74 -> LinuxSyscall.Signalfd4
    | 75 -> LinuxSyscall.Vmsplice
    | 76 -> LinuxSyscall.Splice
    | 77 -> LinuxSyscall.Tee
    | 78 -> LinuxSyscall.Readlinkat
    | 79 -> LinuxSyscall.Fstatat64
    | 80 -> LinuxSyscall.Fstat
    | 81 -> LinuxSyscall.Sync
    | 82 -> LinuxSyscall.Fsync
    | 83 -> LinuxSyscall.Fdatasync
    | 84 -> LinuxSyscall.SyncFileRange
    | 85 -> LinuxSyscall.TimerfdCreate
    | 86 -> LinuxSyscall.TimerfdSettime
    | 87 -> LinuxSyscall.TimerfdGettime
    | 88 -> LinuxSyscall.Utimensat
    | 89 -> LinuxSyscall.Acct
    | 90 -> LinuxSyscall.CapGet
    | 91 -> LinuxSyscall.CapSet
    | 92 -> LinuxSyscall.Personality
    | 93 -> LinuxSyscall.Exit
    | 94 -> LinuxSyscall.ExitGroup
    | 95 -> LinuxSyscall.Waitid
    | 96 -> LinuxSyscall.SetTidAddress
    | 97 -> LinuxSyscall.Unshare
    | 98 -> LinuxSyscall.Futex
    | 99 -> LinuxSyscall.SetRobustList
    | 100 -> LinuxSyscall.GetRobustList
    | 101 -> LinuxSyscall.Nanosleep
    | 102 -> LinuxSyscall.Getitimer
    | 103 -> LinuxSyscall.Setitimer
    | 104 -> LinuxSyscall.KexecLoad
    | 105 -> LinuxSyscall.InitModule
    | 106 -> LinuxSyscall.DeleteModule
    | 107 -> LinuxSyscall.TimerCreate
    | 108 -> LinuxSyscall.TimerGettime
    | 109 -> LinuxSyscall.TimerGetoverrun
    | 110 -> LinuxSyscall.TimerSettime
    | 111 -> LinuxSyscall.TimerDelete
    | 112 -> LinuxSyscall.ClockSettime
    | 113 -> LinuxSyscall.ClockGettime
    | 114 -> LinuxSyscall.ClockGetres
    | 115 -> LinuxSyscall.ClockNanosleep
    | 116 -> LinuxSyscall.Syslog
    | 117 -> LinuxSyscall.Ptrace
    | 118 -> LinuxSyscall.SchedSetparam
    | 119 -> LinuxSyscall.SchedSetscheduler
    | 120 -> LinuxSyscall.SchedGetscheduler
    | 121 -> LinuxSyscall.SchedGetparam
    | 122 -> LinuxSyscall.SchedSetaffinity
    | 123 -> LinuxSyscall.SchedGetaffinity
    | 124 -> LinuxSyscall.SchedYield
    | 125 -> LinuxSyscall.SchedGetPriorityMax
    | 126 -> LinuxSyscall.SchedGetPriorityMin
    | 127 -> LinuxSyscall.SchedRrGetInterval
    | 128 -> LinuxSyscall.RestartSyscall
    | 129 -> LinuxSyscall.Kill
    | 130 -> LinuxSyscall.Tkill
    | 131 -> LinuxSyscall.Tgkill
    | 132 -> LinuxSyscall.Sigaltstack
    | 133 -> LinuxSyscall.RtSigsuspend
    | 134 -> LinuxSyscall.RtSigaction
    | 135 -> LinuxSyscall.RtSigprocmask
    | 136 -> LinuxSyscall.RtSigpending
    | 137 -> LinuxSyscall.RtSigtimedwait
    | 138 -> LinuxSyscall.RtSigqueueinfo
    | 139 -> LinuxSyscall.RtSigreturn
    | 140 -> LinuxSyscall.Setpriority
    | 141 -> LinuxSyscall.Getpriority
    | 142 -> LinuxSyscall.Reboot
    | 143 -> LinuxSyscall.Setregid
    | 144 -> LinuxSyscall.Setgid
    | 145 -> LinuxSyscall.Setreuid
    | 146 -> LinuxSyscall.Setuid
    | 147 -> LinuxSyscall.Setresuid
    | 148 -> LinuxSyscall.Getresuid
    | 149 -> LinuxSyscall.Setresgid
    | 150 -> LinuxSyscall.Getresgid
    | 151 -> LinuxSyscall.Setfsuid
    | 152 -> LinuxSyscall.Setfsgid
    | 153 -> LinuxSyscall.Times
    | 154 -> LinuxSyscall.Setpgid
    | 155 -> LinuxSyscall.Getpgid
    | 156 -> LinuxSyscall.Getsid
    | 157 -> LinuxSyscall.Setsid
    | 158 -> LinuxSyscall.Getgroups
    | 159 -> LinuxSyscall.Setgroups
    | 160 -> LinuxSyscall.Uname
    | 161 -> LinuxSyscall.Sethostname
    | 162 -> LinuxSyscall.Setdomainname
    | 163 -> LinuxSyscall.Getrlimit
    | 164 -> LinuxSyscall.Setrlimit
    | 165 -> LinuxSyscall.Getrusage
    | 166 -> LinuxSyscall.Umask
    | 167 -> LinuxSyscall.Prctl
    | 168 -> LinuxSyscall.Getcpu
    | 169 -> LinuxSyscall.Gettimeofday
    | 170 -> LinuxSyscall.Settimeofday
    | 171 -> LinuxSyscall.AdjTimex
    | 172 -> LinuxSyscall.Getpid
    | 173 -> LinuxSyscall.Getppid
    | 174 -> LinuxSyscall.Getuid
    | 175 -> LinuxSyscall.Geteuid
    | 176 -> LinuxSyscall.Getgid
    | 177 -> LinuxSyscall.Getegid
    | 178 -> LinuxSyscall.Gettid
    | 179 -> LinuxSyscall.Sysinfo
    | 180 -> LinuxSyscall.MqOpen
    | 181 -> LinuxSyscall.MqUnlink
    | 182 -> LinuxSyscall.MqTimedsend
    | 183 -> LinuxSyscall.MqTimedreceive
    | 184 -> LinuxSyscall.MqNotify
    | 185 -> LinuxSyscall.MqGetsetattr
    | 186 -> LinuxSyscall.Msgget
    | 187 -> LinuxSyscall.Msgctl
    | 188 -> LinuxSyscall.Msgrcv
    | 189 -> LinuxSyscall.Msgsnd
    | 190 -> LinuxSyscall.Semget
    | 191 -> LinuxSyscall.Semctl
    | 192 -> LinuxSyscall.Semtimedop
    | 193 -> LinuxSyscall.Semop
    | 194 -> LinuxSyscall.Shmget
    | 195 -> LinuxSyscall.Shmctl
    | 196 -> LinuxSyscall.Shmat
    | 197 -> LinuxSyscall.Shmdt
    | 198 -> LinuxSyscall.Socket
    | 199 -> LinuxSyscall.Socketpair
    | 200 -> LinuxSyscall.Bind
    | 201 -> LinuxSyscall.Listen
    | 202 -> LinuxSyscall.Accept
    | 203 -> LinuxSyscall.Connect
    | 204 -> LinuxSyscall.Getsockname
    | 205 -> LinuxSyscall.Getpeername
    | 206 -> LinuxSyscall.Sendto
    | 207 -> LinuxSyscall.Recvfrom
    | 208 -> LinuxSyscall.Setsockopt
    | 209 -> LinuxSyscall.Getsockopt
    | 210 -> LinuxSyscall.Shutdown
    | 211 -> LinuxSyscall.Sendmsg
    | 212 -> LinuxSyscall.Recvmsg
    | 213 -> LinuxSyscall.Readahead
    | 214 -> LinuxSyscall.Brk
    | 215 -> LinuxSyscall.Munmap
    | 216 -> LinuxSyscall.Mremap
    | 217 -> LinuxSyscall.AddKey
    | 218 -> LinuxSyscall.RequestKey
    | 219 -> LinuxSyscall.Keyctl
    | 220 -> LinuxSyscall.Clone
    | 221 -> LinuxSyscall.Execve
    | 222 -> LinuxSyscall.Mmap
    | 223 -> LinuxSyscall.Fadvise64
    | 224 -> LinuxSyscall.Swapon
    | 225 -> LinuxSyscall.Swapoff
    | 226 -> LinuxSyscall.Mprotect
    | 227 -> LinuxSyscall.Msync
    | 228 -> LinuxSyscall.Mlock
    | 229 -> LinuxSyscall.Munlock
    | 230 -> LinuxSyscall.Mlockall
    | 231 -> LinuxSyscall.Munlockall
    | 232 -> LinuxSyscall.Mincore
    | 233 -> LinuxSyscall.Madvise
    | 234 -> LinuxSyscall.RemapFilePages
    | 235 -> LinuxSyscall.Mbind
    | 236 -> LinuxSyscall.GetMempolicy
    | 237 -> LinuxSyscall.SetMempolicy
    | 238 -> LinuxSyscall.MigratePages
    | 239 -> LinuxSyscall.MovePages
    | 240 -> LinuxSyscall.RtTgsigqueueinfo
    | 241 -> LinuxSyscall.PerfEventOpen
    | 242 -> LinuxSyscall.Accept4
    | 243 -> LinuxSyscall.Recvmmsg
    | 260 -> LinuxSyscall.Wait4
    | 261 -> LinuxSyscall.Prlimit64
    | 262 -> LinuxSyscall.FanotifyInit
    | 263 -> LinuxSyscall.FanotifyMark
    | 264 -> LinuxSyscall.NameToHandleAt
    | 265 -> LinuxSyscall.OpenByHandleAt
    | 266 -> LinuxSyscall.ClockAdjtime
    | 267 -> LinuxSyscall.Syncfs
    | 268 -> LinuxSyscall.Setns
    | 269 -> LinuxSyscall.Sendmmsg
    | 270 -> LinuxSyscall.ProcessVmReadv
    | 271 -> LinuxSyscall.ProcessVmWritev
    | 272 -> LinuxSyscall.Kcmp
    | 273 -> LinuxSyscall.FinitModule
    | 274 -> LinuxSyscall.SchedSetattr
    | 275 -> LinuxSyscall.SchedGetattr
    | 276 -> LinuxSyscall.Renameat2
    | 277 -> LinuxSyscall.Seccomp
    | 278 -> LinuxSyscall.Getrandom
    | 279 -> LinuxSyscall.MemfdCreate
    | 280 -> LinuxSyscall.Bpf
    | 281 -> LinuxSyscall.Execveat
    | 282 -> LinuxSyscall.Userfaultfd
    | 283 -> LinuxSyscall.Membarrier
    | 284 -> LinuxSyscall.Mlock2
    | 285 -> LinuxSyscall.CopyFileRange
    | 286 -> LinuxSyscall.Preadv2
    | 287 -> LinuxSyscall.Pwritev2
    | 288 -> LinuxSyscall.PkeyMprotect
    | 289 -> LinuxSyscall.PkeyAlloc
    | 290 -> LinuxSyscall.PkeyFree
    | 291 -> LinuxSyscall.Statx
    | 292 -> LinuxSyscall.IoPgetevents
    | 293 -> LinuxSyscall.Rseq
    | 294 -> LinuxSyscall.KexecFileLoad
    | 403 -> LinuxSyscall.ClockGettime64
    | 404 -> LinuxSyscall.ClockSettime64
    | 405 -> LinuxSyscall.ClockAdjtime64
    | 406 -> LinuxSyscall.ClockGetres64
    | 407 -> LinuxSyscall.ClockNanosleep64
    | 408 -> LinuxSyscall.TimerGettime64
    | 409 -> LinuxSyscall.TimerSettime64
    | 410 -> LinuxSyscall.TimerfdGettime64
    | 411 -> LinuxSyscall.TimerfdSettime64
    | 412 -> LinuxSyscall.Utimensat64
    | 413 -> LinuxSyscall.Pselect6_64
    | 414 -> LinuxSyscall.Ppoll64
    | 416 -> LinuxSyscall.IoPgetevents64
    | 417 -> LinuxSyscall.Recvmmsg64
    | 418 -> LinuxSyscall.MqTimedsend64
    | 419 -> LinuxSyscall.MqTimedreceive64
    | 420 -> LinuxSyscall.Semtimedop64
    | 421 -> LinuxSyscall.RtSigtimedwait64
    | 422 -> LinuxSyscall.Futex64
    | 423 -> LinuxSyscall.SchedRrGetInterval64
    | 424 -> LinuxSyscall.PidfdSendSignal
    | 425 -> LinuxSyscall.IoUringSetup
    | 426 -> LinuxSyscall.IoUringEnter
    | 427 -> LinuxSyscall.IoUringRegister
    | 428 -> LinuxSyscall.OpenTree
    | 429 -> LinuxSyscall.MoveMount
    | 430 -> LinuxSyscall.Fsopen
    | 431 -> LinuxSyscall.Fsconfig
    | 432 -> LinuxSyscall.Fsmount
    | 433 -> LinuxSyscall.Fspick
    | 434 -> LinuxSyscall.PidfdOpen
    | 435 -> LinuxSyscall.Clone3
    | 436 -> LinuxSyscall.CloseRange
    | 437 -> LinuxSyscall.Openat2
    | 438 -> LinuxSyscall.PidfdGetfd
    | 439 -> LinuxSyscall.Faccessat2
    | 441 -> LinuxSyscall.EpollPwait
    | _ -> raise UnhandledSyscallException

  /// Return a LinuxSyscall from a given number and architecture.
  [<CompiledName "OfNumber">]
  let ofNumber arch num =
    match arch with
    | Architecture.IntelX86 -> getX86Syscall num
    | Architecture.IntelX64 -> getX64Syscall num
    | Architecture.ARMv7 | Architecture.AARCH32 -> getARMEABISyscall num
    | Architecture.AARCH64 -> getAARCH64Syscall num
    | Architecture.MIPS32 -> getMIPSO32Syscall num
    | Architecture.MIPS64 -> getMIPSN64Syscall num
    | Architecture.PPC32 -> getPPC32Syscall num
    | Architecture.RISCV64 -> getRISCV64Syscall num
    | _ -> raise UnhandledSyscallException

  /// Transform a LinuxSyscall to a string.
  [<CompiledName "ToString">]
  let toString = function
    | LinuxSyscall.Accept -> "accept"
    | LinuxSyscall.Accept4 -> "accept4"
    | LinuxSyscall.Access -> "access"
    | LinuxSyscall.Acct -> "acct"
    | LinuxSyscall.AddKey -> "add_key"
    | LinuxSyscall.AdjTimex -> "adjtimex"
    | LinuxSyscall.Alarm -> "alarm"
    | LinuxSyscall.AllocHugePages -> "alloc_hugepages"
    | LinuxSyscall.ArcGetTLS -> "arc_gettls"
    | LinuxSyscall.ArcSetTLS -> "arc_settls"
    | LinuxSyscall.ArcUsrCmpxchg -> "arc_usr_cmpxchg"
    | LinuxSyscall.ArchPrctl -> "arch_prctl"
    | LinuxSyscall.ArmFadvise64 -> "arm_fadvise64_64"
    | LinuxSyscall.ArmSyncFileRange -> "arm_sync_file_range"
    | LinuxSyscall.AtomicBarrier -> "atomic_barrier"
    | LinuxSyscall.AtomicCmpxchg32 -> "atomic_cmpxchg_32"
    | LinuxSyscall.Bdflush -> "bdflush"
    | LinuxSyscall.BfinSpinlock -> "bfin_spinlock"
    | LinuxSyscall.Bind -> "bind"
    | LinuxSyscall.Bpf -> "bpf"
    | LinuxSyscall.Brk -> "brk"
    | LinuxSyscall.Breakpoint -> "breakpoint"
    | LinuxSyscall.CacheCtl -> "cachectl"
    | LinuxSyscall.CacheFlush -> "cacheflush"
    | LinuxSyscall.CapGet -> "capget"
    | LinuxSyscall.CapSet -> "capset"
    | LinuxSyscall.Chdir -> "chdir"
    | LinuxSyscall.Chmod -> "chmod"
    | LinuxSyscall.Chown -> "chown"
    | LinuxSyscall.Chown32 -> "chown32"
    | LinuxSyscall.Chroot -> "chroot"
    | LinuxSyscall.ClockAdjtime -> "clock_adjtime"
    | LinuxSyscall.ClockAdjtime64 -> "clock_adjtime64"
    | LinuxSyscall.ClockGetres -> "clock_getres"
    | LinuxSyscall.ClockGetres64 -> "clock_getres64"
    | LinuxSyscall.ClockGettime -> "clock_gettime"
    | LinuxSyscall.ClockGettime64 -> "clock_gettime64"
    | LinuxSyscall.ClockNanosleep -> "clock_nanosleep"
    | LinuxSyscall.ClockSettime -> "clock_settime"
    | LinuxSyscall.ClockSettime64 -> "clock_settime64"
    | LinuxSyscall.ClockNanosleep64 -> "clock_nanosleep64"
    | LinuxSyscall.Clone2 -> "clone2"
    | LinuxSyscall.Clone -> "clone"
    | LinuxSyscall.Clone3 -> "clone3"
    | LinuxSyscall.Close -> "close"
    | LinuxSyscall.CloseRange -> "close_range"
    | LinuxSyscall.CmpxchgBadaddr -> "cmpxchg_badaddr"
    | LinuxSyscall.Connect -> "connect"
    | LinuxSyscall.CopyFileRange -> "copy_file_range"
    | LinuxSyscall.Creat -> "creat"
    | LinuxSyscall.CreateModule -> "create_module"
    | LinuxSyscall.DeleteModule -> "delete_module"
    | LinuxSyscall.DmaMemcpy -> "dma_memcpy"
    | LinuxSyscall.Dup -> "dup"
    | LinuxSyscall.Dup2 -> "dup2"
    | LinuxSyscall.Dup3 -> "dup3"
    | LinuxSyscall.EpollCreate -> "epoll_create"
    | LinuxSyscall.EpollCreate1 -> "epoll_create1"
    | LinuxSyscall.EpollCtl -> "epoll_ctl"
    | LinuxSyscall.EpollPwait -> "epoll_pwait"
    | LinuxSyscall.EpollWait -> "epoll_wait"
    | LinuxSyscall.Eventfd -> "eventfd"
    | LinuxSyscall.Eventfd2 -> "eventfd2"
    | LinuxSyscall.Execv -> "execv"
    | LinuxSyscall.Execve -> "execve"
    | LinuxSyscall.Execveat -> "execveat"
    | LinuxSyscall.Exit -> "exit"
    | LinuxSyscall.ExitGroup -> "exit_group"
    | LinuxSyscall.Faccessat -> "faccessat"
    | LinuxSyscall.Fadvise64 -> "fadvise64"
    | LinuxSyscall.Fadvise64_64 -> "fadvise64_64"
    | LinuxSyscall.Fallocate -> "fallocate"
    | LinuxSyscall.FanotifyInit -> "fanotify_init"
    | LinuxSyscall.FanotifyMark -> "fanotify_mark"
    | LinuxSyscall.Fchdir -> "fchdir"
    | LinuxSyscall.Fchmod -> "fchmod"
    | LinuxSyscall.Fchmodat -> "fchmodat"
    | LinuxSyscall.Fchown -> "fchown"
    | LinuxSyscall.Fchown32 -> "fchown32"
    | LinuxSyscall.Fchownat -> "fchownat"
    | LinuxSyscall.Fcntl -> "fcntl"
    | LinuxSyscall.Fcntl64 -> "fcntl64"
    | LinuxSyscall.Fdatasync -> "fdatasync"
    | LinuxSyscall.Fgetxattr -> "fgetxattr"
    | LinuxSyscall.FinitModule -> "finit_module"
    | LinuxSyscall.Flistxattr -> "flistxattr"
    | LinuxSyscall.Flock -> "flock"
    | LinuxSyscall.Fork -> "fork"
    | LinuxSyscall.FreeHugepages -> "free_hugepages"
    | LinuxSyscall.Fremovexattr -> "fremovexattr"
    | LinuxSyscall.Fsconfig -> "fsconfig"
    | LinuxSyscall.Fsetxattr -> "fsetxattr"
    | LinuxSyscall.Fsmount -> "fsmount"
    | LinuxSyscall.Fsopen -> "fsopen"
    | LinuxSyscall.Fspick -> "fspick"
    | LinuxSyscall.Fstat -> "fstat"
    | LinuxSyscall.Fstat64 -> "fstat64"
    | LinuxSyscall.Fstatat64 -> "fstatat64"
    | LinuxSyscall.Fstatfs -> "fstatfs"
    | LinuxSyscall.Fstatfs64 -> "fstatfs64"
    | LinuxSyscall.Fsync -> "fsync"
    | LinuxSyscall.Ftruncate -> "ftruncate"
    | LinuxSyscall.Ftruncate64 -> "ftruncate64"
    | LinuxSyscall.Futex -> "futex"
    | LinuxSyscall.Futex64 -> "futex64"
    | LinuxSyscall.Futimesat -> "futimesat"
    | LinuxSyscall.GetKernelSyms -> "get_kernel_syms"
    | LinuxSyscall.GetMempolicy -> "get_mempolicy"
    | LinuxSyscall.GetRobustList -> "get_robust_list"
    | LinuxSyscall.GetThreadArea -> "get_thread_area"
    | LinuxSyscall.GetTLS -> "get_tls"
    | LinuxSyscall.Getcpu -> "getcpu"
    | LinuxSyscall.Getcwd -> "getcwd"
    | LinuxSyscall.Getdents -> "getdents"
    | LinuxSyscall.Getdents64 -> "getdents64"
    | LinuxSyscall.Getdomainname -> "getdomainname"
    | LinuxSyscall.Getdtablesize -> "getdtablesize"
    | LinuxSyscall.Getegid -> "getegid"
    | LinuxSyscall.Getegid32 -> "getegid32"
    | LinuxSyscall.Geteuid -> "geteuid"
    | LinuxSyscall.Geteuid32 -> "geteuid32"
    | LinuxSyscall.Getgid -> "getgid"
    | LinuxSyscall.Getgid32 -> "getgid32"
    | LinuxSyscall.Getgroups -> "getgroups"
    | LinuxSyscall.Getgroups32 -> "getgroups32"
    | LinuxSyscall.Gethostname -> "gethostname"
    | LinuxSyscall.Getitimer -> "getitimer"
    | LinuxSyscall.Getpeername -> "getpeername"
    | LinuxSyscall.Getpagesize -> "getpagesize"
    | LinuxSyscall.Getpgid -> "getpgid"
    | LinuxSyscall.Getpgrp -> "getpgrp"
    | LinuxSyscall.Getpid -> "getpid"
    | LinuxSyscall.Getppid -> "getppid"
    | LinuxSyscall.Getpriority -> "getpriority"
    | LinuxSyscall.Getrandom -> "getrandom"
    | LinuxSyscall.Getresgid -> "getresgid"
    | LinuxSyscall.Getresgid32 -> "getresgid32"
    | LinuxSyscall.Getresuid -> "getresuid"
    | LinuxSyscall.Getresuid32 -> "getresuid32"
    | LinuxSyscall.Getrlimit -> "getrlimit"
    | LinuxSyscall.Getrusage -> "getrusage"
    | LinuxSyscall.Getsid -> "getsid"
    | LinuxSyscall.Getsockname -> "getsockname"
    | LinuxSyscall.Getsockopt -> "getsockopt"
    | LinuxSyscall.Gettid -> "gettid"
    | LinuxSyscall.Gettimeofday -> "gettimeofday"
    | LinuxSyscall.Getuid -> "getuid"
    | LinuxSyscall.Getuid32 -> "getuid32"
    | LinuxSyscall.Getunwind -> "getunwind"
    | LinuxSyscall.Getxattr -> "getxattr"
    | LinuxSyscall.Getxgid -> "getxgid"
    | LinuxSyscall.Getxpid -> "getxpid"
    | LinuxSyscall.Getxuid -> "getxuid"
    | LinuxSyscall.InitModule -> "init_module"
    | LinuxSyscall.InotifyAddWatch -> "inotify_add_watch"
    | LinuxSyscall.InotifyInit -> "inotify_init"
    | LinuxSyscall.InotifyInit1 -> "inotify_init1"
    | LinuxSyscall.InotifyRmWatch -> "inotify_rm_watch"
    | LinuxSyscall.IoCancel -> "io_cancel"
    | LinuxSyscall.IoDestroy -> "io_destroy"
    | LinuxSyscall.IoGetevents -> "io_getevents"
    | LinuxSyscall.IoPgetevents -> "io_pgetevents"
    | LinuxSyscall.IoPgetevents64 -> "io_pgetevents64"
    | LinuxSyscall.IoSetup -> "io_setup"
    | LinuxSyscall.IoSubmit -> "io_submit"
    | LinuxSyscall.IoUringEnter -> "io_uring_enter"
    | LinuxSyscall.IoUringRegister -> "io_uring_register"
    | LinuxSyscall.IoUringSetup -> "io_uring_setup"
    | LinuxSyscall.Ioctl -> "ioctl"
    | LinuxSyscall.Ioperm -> "ioperm"
    | LinuxSyscall.Iopl -> "iopl"
    | LinuxSyscall.IoprioGet -> "ioprio_get"
    | LinuxSyscall.IoprioSet -> "ioprio_set"
    | LinuxSyscall.Ipc -> "ipc"
    | LinuxSyscall.Kcmp -> "kcmp"
    | LinuxSyscall.KernFeatures -> "kern_features"
    | LinuxSyscall.KexecFileLoad -> "kexec_file_load"
    | LinuxSyscall.KexecLoad -> "kexec_load"
    | LinuxSyscall.Keyctl -> "keyctl"
    | LinuxSyscall.Kill -> "kill"
    | LinuxSyscall.Lchown -> "lchown"
    | LinuxSyscall.Lchown32 -> "lchown32"
    | LinuxSyscall.Lgetxattr -> "lgetxattr"
    | LinuxSyscall.Link -> "link"
    | LinuxSyscall.Linkat -> "linkat"
    | LinuxSyscall.Listen -> "listen"
    | LinuxSyscall.Listxattr -> "listxattr"
    | LinuxSyscall.Llistxattr -> "llistxattr"
    | LinuxSyscall.LookupDcookie -> "lookup_dcookie"
    | LinuxSyscall.Lremovexattr -> "lremovexattr"
    | LinuxSyscall.Lseek -> "lseek"
    | LinuxSyscall.LLseek -> "_llseek"
    | LinuxSyscall.Lsetxattr -> "lsetxattr"
    | LinuxSyscall.Lstat -> "lstat"
    | LinuxSyscall.Lstat64 -> "lstat64"
    | LinuxSyscall.Madvise -> "madvise"
    | LinuxSyscall.Mbind -> "mbind"
    | LinuxSyscall.MemoryOrdering -> "memory_ordering"
    | LinuxSyscall.MetagGetTLS -> "metag_get_tls"
    | LinuxSyscall.MetagSetFpuFlags -> "metag_set_fpu_flags"
    | LinuxSyscall.MetagSetTLS -> "metag_set_tls"
    | LinuxSyscall.MetagSetglobalbit -> "metag_setglobalbit"
    | LinuxSyscall.Membarrier -> "membarrier"
    | LinuxSyscall.MemfdCreate -> "memfd_create"
    | LinuxSyscall.MigratePages -> "migrate_pages"
    | LinuxSyscall.Mincore -> "mincore"
    | LinuxSyscall.Mkdir -> "mkdir"
    | LinuxSyscall.Mkdirat -> "mkdirat"
    | LinuxSyscall.Mknod -> "mknod"
    | LinuxSyscall.Mknodat -> "mknodat"
    | LinuxSyscall.Mlock -> "mlock"
    | LinuxSyscall.Mlock2 -> "mlock2"
    | LinuxSyscall.Mlockall -> "mlockall"
    | LinuxSyscall.Mmap -> "mmap"
    | LinuxSyscall.Mmap2 -> "mmap2"
    | LinuxSyscall.ModifyLdt -> "modify_ldt"
    | LinuxSyscall.Mount -> "mount"
    | LinuxSyscall.MoveMount -> "move_mount"
    | LinuxSyscall.MovePages -> "move_pages"
    | LinuxSyscall.Mprotect -> "mprotect"
    | LinuxSyscall.MqGetsetattr -> "mq_getsetattr"
    | LinuxSyscall.MqNotify -> "mq_notify"
    | LinuxSyscall.MqOpen -> "mq_open"
    | LinuxSyscall.MqTimedreceive -> "mq_timedreceive"
    | LinuxSyscall.MqTimedreceive64 -> "mq_timedreceive64"
    | LinuxSyscall.MqTimedsend -> "mq_timedsend"
    | LinuxSyscall.MqTimedsend64 -> "mq_timedsend64"
    | LinuxSyscall.MqUnlink -> "mq_unlink"
    | LinuxSyscall.Mremap -> "mremap"
    | LinuxSyscall.Msgctl -> "msgctl"
    | LinuxSyscall.Msgget -> "msgget"
    | LinuxSyscall.Msgrcv -> "msgrcv"
    | LinuxSyscall.Msgsnd -> "msgsnd"
    | LinuxSyscall.Msync -> "msync"
    | LinuxSyscall.Munlock -> "munlock"
    | LinuxSyscall.Munlockall -> "munlockall"
    | LinuxSyscall.Munmap -> "munmap"
    | LinuxSyscall.NameToHandleAt -> "name_to_handle_at"
    | LinuxSyscall.Nanosleep -> "nanosleep"
    | LinuxSyscall.Newfstatat -> "newfstatat"
    | LinuxSyscall.NewSelect -> "_newselect"
    | LinuxSyscall.Nfsservctl -> "nfsservctl"
    | LinuxSyscall.Nice -> "nice"
    | LinuxSyscall.OldAdjtimex -> "old_adjtimex"
    | LinuxSyscall.OldGetrlimit -> "old_getrlimit"
    | LinuxSyscall.Oldfstat -> "oldfstat"
    | LinuxSyscall.Oldlstat -> "oldlstat"
    | LinuxSyscall.Oldolduname -> "oldolduname"
    | LinuxSyscall.Oldstat -> "oldstat"
    | LinuxSyscall.Oldumount -> "oldumount"
    | LinuxSyscall.Olduname -> "olduname"
    | LinuxSyscall.Open -> "open"
    | LinuxSyscall.OpenByHandleAt -> "open_by_handle_at"
    | LinuxSyscall.OpenTree -> "open_tree"
    | LinuxSyscall.Openat -> "openat"
    | LinuxSyscall.Openat2 -> "openat2"
    | LinuxSyscall.Or1kAtomic -> "or1k_atomic"
    | LinuxSyscall.Pause -> "pause"
    | LinuxSyscall.PciconfigIobase -> "pciconfig_iobase"
    | LinuxSyscall.PciconfigRead -> "pciconfig_read"
    | LinuxSyscall.PciconfigWrite -> "pciconfig_write"
    | LinuxSyscall.PerfEventOpen -> "perf_event_open"
    | LinuxSyscall.Personality -> "personality"
    | LinuxSyscall.Perfctr -> "perfctr"
    | LinuxSyscall.Perfmonctl -> "perfmonctl"
    | LinuxSyscall.PidfdGetfd -> "pidfd_getfd"
    | LinuxSyscall.PidfdSendSignal -> "pidfd_send_signal"
    | LinuxSyscall.PidfdOpen -> "pidfd_open"
    | LinuxSyscall.Pipe -> "pipe"
    | LinuxSyscall.Pipe2 -> "pipe2"
    | LinuxSyscall.PivotRoot -> "pivot_root"
    | LinuxSyscall.PkeyAlloc -> "pkey_alloc"
    | LinuxSyscall.PkeyFree -> "pkey_free"
    | LinuxSyscall.PkeyMprotect -> "pkey_mprotect"
    | LinuxSyscall.Poll -> "poll"
    | LinuxSyscall.Ppoll -> "ppoll"
    | LinuxSyscall.Ppoll64 -> "ppoll64"
    | LinuxSyscall.Prctl -> "prctl"
    | LinuxSyscall.Pread -> "pread"
    | LinuxSyscall.Pread64 -> "pread64"
    | LinuxSyscall.Preadv -> "preadv"
    | LinuxSyscall.Preadv2 -> "preadv2"
    | LinuxSyscall.Prlimit64 -> "prlimit64"
    | LinuxSyscall.ProcessVmReadv -> "process_vm_readv"
    | LinuxSyscall.ProcessVmWritev -> "process_vm_writev"
    | LinuxSyscall.Pselect6 -> "pselect6"
    | LinuxSyscall.Pselect6_64 -> "pselect6_64"
    | LinuxSyscall.Ptrace -> "ptrace"
    | LinuxSyscall.Pwrite -> "pwrite"
    | LinuxSyscall.Pwrite64 -> "pwrite64"
    | LinuxSyscall.Pwritev -> "pwritev"
    | LinuxSyscall.Pwritev2 -> "pwritev2"
    | LinuxSyscall.QueryModule -> "query_module"
    | LinuxSyscall.Quotactl -> "quotactl"
    | LinuxSyscall.Read -> "read"
    | LinuxSyscall.Readahead -> "readahead"
    | LinuxSyscall.Readdir -> "readdir"
    | LinuxSyscall.Readlink -> "readlink"
    | LinuxSyscall.Readlinkat -> "readlinkat"
    | LinuxSyscall.Readv -> "readv"
    | LinuxSyscall.Reboot -> "reboot"
    | LinuxSyscall.Recv -> "recv"
    | LinuxSyscall.Recvfrom -> "recvfrom"
    | LinuxSyscall.Recvmsg -> "recvmsg"
    | LinuxSyscall.Recvmmsg -> "recvmmsg"
    | LinuxSyscall.Recvmmsg64 -> "recvmmsg64"
    | LinuxSyscall.RemapFilePages -> "remap_file_pages"
    | LinuxSyscall.Removexattr -> "removexattr"
    | LinuxSyscall.Rename -> "rename"
    | LinuxSyscall.Renameat -> "renameat"
    | LinuxSyscall.Renameat2 -> "renameat2"
    | LinuxSyscall.RequestKey -> "request_key"
    | LinuxSyscall.RestartSyscall -> "restart_syscall"
    | LinuxSyscall.RiscvFlushIcache -> "riscv_flush_icache"
    | LinuxSyscall.Rmdir -> "rmdir"
    | LinuxSyscall.Rseq -> "rseq"
    | LinuxSyscall.RtSigaction -> "rt_sigaction"
    | LinuxSyscall.RtSigpending -> "rt_sigpending"
    | LinuxSyscall.RtSigprocmask -> "rt_sigprocmask"
    | LinuxSyscall.RtSigqueueinfo -> "rt_sigqueueinfo"
    | LinuxSyscall.RtSigreturn -> "rt_sigreturn"
    | LinuxSyscall.RtSigsuspend -> "rt_sigsuspend"
    | LinuxSyscall.RtSigtimedwait -> "rt_sigtimedwait"
    | LinuxSyscall.RtSigtimedwait64 -> "rt_sigtimedwait64"
    | LinuxSyscall.RtTgsigqueueinfo -> "rt_tgsigqueueinfo"
    | LinuxSyscall.Rtas -> "rtas"
    | LinuxSyscall.S390RuntimeInstr -> "s390_runtime_instr"
    | LinuxSyscall.S390PciMmioRead -> "s390_pci_mmio_read"
    | LinuxSyscall.S390PciMmioWrite -> "s390_pci_mmio_write"
    | LinuxSyscall.S390Sthyi -> "s390_sthyi"
    | LinuxSyscall.S390GuardedStorage -> "s390_guarded_storage"
    | LinuxSyscall.SchedGetAffinity -> "sched_get_affinity"
    | LinuxSyscall.SchedGetPriorityMax -> "sched_get_priority_max"
    | LinuxSyscall.SchedGetPriorityMin -> "sched_get_priority_min"
    | LinuxSyscall.SchedGetaffinity -> "sched_getaffinity"
    | LinuxSyscall.SchedGetattr -> "sched_getattr"
    | LinuxSyscall.SchedGetparam -> "sched_getparam"
    | LinuxSyscall.SchedGetscheduler -> "sched_getscheduler"
    | LinuxSyscall.SchedRrGetInterval -> "sched_rr_get_interval"
    | LinuxSyscall.SchedRrGetInterval64 -> "sched_rr_get_interval64"
    | LinuxSyscall.SchedSetAffinity -> "sched_set_affinity"
    | LinuxSyscall.SchedSetaffinity -> "sched_setaffinity"
    | LinuxSyscall.SchedSetattr -> "sched_setattr"
    | LinuxSyscall.SchedSetparam -> "sched_setparam"
    | LinuxSyscall.SchedSetscheduler -> "sched_setscheduler"
    | LinuxSyscall.SchedYield -> "sched_yield"
    | LinuxSyscall.Seccomp -> "seccomp"
    | LinuxSyscall.Select -> "select"
    | LinuxSyscall.Semctl -> "semctl"
    | LinuxSyscall.Semget -> "semget"
    | LinuxSyscall.Semop -> "semop"
    | LinuxSyscall.Semtimedop -> "semtimedop"
    | LinuxSyscall.Semtimedop64 -> "semtimedop64"
    | LinuxSyscall.Send -> "send"
    | LinuxSyscall.Sendfile -> "sendfile"
    | LinuxSyscall.Sendfile64 -> "sendfile64"
    | LinuxSyscall.Sendmmsg -> "sendmmsg"
    | LinuxSyscall.Sendmsg -> "sendmsg"
    | LinuxSyscall.Sendto -> "sendto"
    | LinuxSyscall.SetMempolicy -> "set_mempolicy"
    | LinuxSyscall.SetRobustList -> "set_robust_list"
    | LinuxSyscall.SetThreadArea -> "set_thread_area"
    | LinuxSyscall.SetTidAddress -> "set_tid_address"
    | LinuxSyscall.SetTLS -> "set_tls"
    | LinuxSyscall.Setdomainname -> "setdomainname"
    | LinuxSyscall.Setfsgid -> "setfsgid"
    | LinuxSyscall.Setfsgid32 -> "setfsgid32"
    | LinuxSyscall.Setfsuid -> "setfsuid"
    | LinuxSyscall.Setfsuid32 -> "setfsuid32"
    | LinuxSyscall.Setgid -> "setgid"
    | LinuxSyscall.Setgid32 -> "setgid32"
    | LinuxSyscall.Setgroups -> "setgroups"
    | LinuxSyscall.Setgroups32 -> "setgroups32"
    | LinuxSyscall.Sethae -> "sethae"
    | LinuxSyscall.Sethostname -> "sethostname"
    | LinuxSyscall.Setitimer -> "setitimer"
    | LinuxSyscall.Setns -> "setns"
    | LinuxSyscall.Setpgid -> "setpgid"
    | LinuxSyscall.Setpgrp -> "setpgrp"
    | LinuxSyscall.Setpriority -> "setpriority"
    | LinuxSyscall.Setregid -> "setregid"
    | LinuxSyscall.Setregid32 -> "setregid32"
    | LinuxSyscall.Setresgid -> "setresgid"
    | LinuxSyscall.Setresgid32 -> "setresgid32"
    | LinuxSyscall.Setresuid -> "setresuid"
    | LinuxSyscall.Setresuid32 -> "setresuid32"
    | LinuxSyscall.Setreuid -> "setreuid"
    | LinuxSyscall.Setreuid32 -> "setreuid32"
    | LinuxSyscall.Setrlimit -> "setrlimit"
    | LinuxSyscall.Setsid -> "setsid"
    | LinuxSyscall.Setsockopt -> "setsockopt"
    | LinuxSyscall.Settimeofday -> "settimeofday"
    | LinuxSyscall.Setuid -> "setuid"
    | LinuxSyscall.Setuid32 -> "setuid32"
    | LinuxSyscall.Setup -> "setup"
    | LinuxSyscall.Setxattr -> "setxattr"
    | LinuxSyscall.Sgetmask -> "sgetmask"
    | LinuxSyscall.Shmat -> "shmat"
    | LinuxSyscall.Shmctl -> "shmctl"
    | LinuxSyscall.Shmdt -> "shmdt"
    | LinuxSyscall.Shmget -> "shmget"
    | LinuxSyscall.Shutdown -> "shutdown"
    | LinuxSyscall.Sigaction -> "sigaction"
    | LinuxSyscall.Sigaltstack -> "sigaltstack"
    | LinuxSyscall.Signal -> "signal"
    | LinuxSyscall.Signalfd -> "signalfd"
    | LinuxSyscall.Signalfd4 -> "signalfd4"
    | LinuxSyscall.Sigpending -> "sigpending"
    | LinuxSyscall.Sigprocmask -> "sigprocmask"
    | LinuxSyscall.Sigreturn -> "sigreturn"
    | LinuxSyscall.Sigsuspend -> "sigsuspend"
    | LinuxSyscall.Socket -> "socket"
    | LinuxSyscall.Socketcall -> "socketcall"
    | LinuxSyscall.Socketpair -> "socketpair"
    | LinuxSyscall.Spill -> "spill"
    | LinuxSyscall.Splice -> "splice"
    | LinuxSyscall.SpuCreate -> "spu_create"
    | LinuxSyscall.SpuRun -> "spu_run"
    | LinuxSyscall.SramAlloc -> "sram_alloc"
    | LinuxSyscall.SramFree -> "sram_free"
    | LinuxSyscall.Ssetmask -> "ssetmask"
    | LinuxSyscall.Stat -> "stat"
    | LinuxSyscall.Stat64 -> "stat64"
    | LinuxSyscall.Statfs -> "statfs"
    | LinuxSyscall.Statfs64 -> "statfs64"
    | LinuxSyscall.Statx -> "statx"
    | LinuxSyscall.Stime -> "stime"
    | LinuxSyscall.SubpageProt -> "subpage_prot"
    | LinuxSyscall.SwitchEndian -> "swapcontext"
    | LinuxSyscall.Swapcontext -> "switch_endian"
    | LinuxSyscall.Swapoff -> "swapoff"
    | LinuxSyscall.Swapon -> "swapon"
    | LinuxSyscall.Symlink -> "symlink"
    | LinuxSyscall.Symlinkat -> "symlinkat"
    | LinuxSyscall.Sync -> "sync"
    | LinuxSyscall.SyncFileRange -> "sync_file_range"
    | LinuxSyscall.SyncFileRange2 -> "sync_file_range2"
    | LinuxSyscall.Syncfs -> "syncfs"
    | LinuxSyscall.SysDebugSetcontext -> "sys_debug_setcontext"
    | LinuxSyscall.Syscall -> "syscall"
    | LinuxSyscall.Sysctl -> "_sysctl"
    | LinuxSyscall.Sysfs -> "sysfs"
    | LinuxSyscall.Sysinfo -> "sysinfo"
    | LinuxSyscall.Syslog -> "syslog"
    | LinuxSyscall.Sysmips -> "sysmips"
    | LinuxSyscall.Tee -> "tee"
    | LinuxSyscall.Tgkill -> "tgkill"
    | LinuxSyscall.Time -> "time"
    | LinuxSyscall.TimerCreate -> "timer_create"
    | LinuxSyscall.TimerDelete -> "timer_delete"
    | LinuxSyscall.TimerGetoverrun -> "timer_getoverrun"
    | LinuxSyscall.TimerGettime -> "timer_gettime"
    | LinuxSyscall.TimerGettime64 -> "timer_gettime64"
    | LinuxSyscall.TimerSettime -> "timer_settime"
    | LinuxSyscall.TimerSettime64 -> "timer_settime64"
    | LinuxSyscall.Timerfd -> "timerfd"
    | LinuxSyscall.TimerfdCreate -> "timerfd_create"
    | LinuxSyscall.TimerfdGettime -> "timerfd_gettime"
    | LinuxSyscall.TimerfdGettime64 -> "timerfd_gettime64"
    | LinuxSyscall.TimerfdSettime -> "timerfd_settime"
    | LinuxSyscall.TimerfdSettime64 -> "timerfd_settime64"
    | LinuxSyscall.Times -> "times"
    | LinuxSyscall.Tkill -> "tkill"
    | LinuxSyscall.Truncate -> "truncate"
    | LinuxSyscall.Truncate64 -> "truncate64"
    | LinuxSyscall.Ugetrlimit -> "ugetrlimit"
    | LinuxSyscall.Umask -> "umask"
    | LinuxSyscall.Umount -> "umount"
    | LinuxSyscall.Umount2 -> "umount2"
    | LinuxSyscall.Uname -> "uname"
    | LinuxSyscall.Unlink -> "unlink"
    | LinuxSyscall.Unlinkat -> "unlinkat"
    | LinuxSyscall.Unshare -> "unshare"
    | LinuxSyscall.Uselib -> "uselib"
    | LinuxSyscall.Ustat -> "ustat"
    | LinuxSyscall.Userfaultfd -> "userfaultfd"
    | LinuxSyscall.Usr26 -> "usr26"
    | LinuxSyscall.Usr32 -> "usr32"
    | LinuxSyscall.Utime -> "utime"
    | LinuxSyscall.Utimensat -> "utimensat"
    | LinuxSyscall.Utimensat64 -> "utimensat64"
    | LinuxSyscall.Utimes -> "utimes"
    | LinuxSyscall.UtrapInstall -> "utrap_install"
    | LinuxSyscall.Vfork -> "vfork"
    | LinuxSyscall.Vhangup -> "vhangup"
    | LinuxSyscall.Vm86old -> "vm86old"
    | LinuxSyscall.Vm86 -> "vm86"
    | LinuxSyscall.Vmsplice -> "vmsplice"
    | LinuxSyscall.Vserver -> "vserver"
    | LinuxSyscall.Wait4 -> "wait4"
    | LinuxSyscall.Waitid -> "waitid"
    | LinuxSyscall.Waitpid -> "waitpid"
    | LinuxSyscall.Write -> "write"
    | LinuxSyscall.Writev -> "writev"
    | LinuxSyscall.Xtensa -> "xtensa"
    | _ -> raise UnhandledSyscallException

  /// Convert a string to a LinuxSyscall.
  [<CompiledName "OfString">]
  let ofString = function
    | "accept" -> LinuxSyscall.Accept
    | "accept4" -> LinuxSyscall.Accept4
    | "access" -> LinuxSyscall.Access
    | "acct" -> LinuxSyscall.Acct
    | "add_key" -> LinuxSyscall.AddKey
    | "adjtimex" -> LinuxSyscall.AdjTimex
    | "alarm" -> LinuxSyscall.Alarm
    | "alloc_hugepages" -> LinuxSyscall.AllocHugePages
    | "arc_gettls" -> LinuxSyscall.ArcGetTLS
    | "arc_settls" -> LinuxSyscall.ArcSetTLS
    | "arc_usr_cmpxchg" -> LinuxSyscall.ArcUsrCmpxchg
    | "arch_prctl" -> LinuxSyscall.ArchPrctl
    | "arm_fadvise64_64" -> LinuxSyscall.ArmFadvise64
    | "arm_sync_file_range" -> LinuxSyscall.ArmSyncFileRange
    | "atomic_barrier" -> LinuxSyscall.AtomicBarrier
    | "atomic_cmpxchg_32" -> LinuxSyscall.AtomicCmpxchg32
    | "bdflush" -> LinuxSyscall.Bdflush
    | "bfin_spinlock" -> LinuxSyscall.BfinSpinlock
    | "bind" -> LinuxSyscall.Bind
    | "bpf" -> LinuxSyscall.Bpf
    | "brk" -> LinuxSyscall.Brk
    | "breakpoint" -> LinuxSyscall.Breakpoint
    | "cachectl" -> LinuxSyscall.CacheCtl
    | "cacheflush" -> LinuxSyscall.CacheFlush
    | "capget" -> LinuxSyscall.CapGet
    | "capset" -> LinuxSyscall.CapSet
    | "chdir" -> LinuxSyscall.Chdir
    | "chmod" -> LinuxSyscall.Chmod
    | "chown" -> LinuxSyscall.Chown
    | "chown32" -> LinuxSyscall.Chown32
    | "chroot" -> LinuxSyscall.Chroot
    | "clock_adjtime" -> LinuxSyscall.ClockAdjtime
    | "clock_adjtime64" -> LinuxSyscall.ClockAdjtime64
    | "clock_getres" -> LinuxSyscall.ClockGetres
    | "clock_getres64" -> LinuxSyscall.ClockGetres64
    | "clock_gettime" -> LinuxSyscall.ClockGettime
    | "clock_gettime64" -> LinuxSyscall.ClockGettime64
    | "clock_nanosleep" -> LinuxSyscall.ClockNanosleep
    | "clock_settime" -> LinuxSyscall.ClockSettime
    | "clock_settime64" -> LinuxSyscall.ClockSettime64
    | "clock_nanosleep64" -> LinuxSyscall.ClockNanosleep64
    | "clone2" -> LinuxSyscall.Clone2
    | "clone" -> LinuxSyscall.Clone
    | "clone3" -> LinuxSyscall.Clone3
    | "close" -> LinuxSyscall.Close
    | "close_range" -> LinuxSyscall.CloseRange
    | "cmpxchg_badaddr" -> LinuxSyscall.CmpxchgBadaddr
    | "connect" -> LinuxSyscall.Connect
    | "copy_file_range" -> LinuxSyscall.CopyFileRange
    | "creat" -> LinuxSyscall.Creat
    | "create_module" -> LinuxSyscall.CreateModule
    | "delete_module" -> LinuxSyscall.DeleteModule
    | "dma_memcpy" -> LinuxSyscall.DmaMemcpy
    | "dup" -> LinuxSyscall.Dup
    | "dup2" -> LinuxSyscall.Dup2
    | "dup3" -> LinuxSyscall.Dup3
    | "epoll_create" -> LinuxSyscall.EpollCreate
    | "epoll_create1" -> LinuxSyscall.EpollCreate1
    | "epoll_ctl" -> LinuxSyscall.EpollCtl
    | "epoll_pwait" -> LinuxSyscall.EpollPwait
    | "epoll_wait" -> LinuxSyscall.EpollWait
    | "eventfd" -> LinuxSyscall.Eventfd
    | "eventfd2" -> LinuxSyscall.Eventfd2
    | "execv" -> LinuxSyscall.Execv
    | "execve" -> LinuxSyscall.Execve
    | "execveat" -> LinuxSyscall.Execveat
    | "exit" -> LinuxSyscall.Exit
    | "exit_group" -> LinuxSyscall.ExitGroup
    | "faccessat" -> LinuxSyscall.Faccessat
    | "fadvise64" -> LinuxSyscall.Fadvise64
    | "fadvise64_64" -> LinuxSyscall.Fadvise64_64
    | "fallocate" -> LinuxSyscall.Fallocate
    | "fanotify_init" -> LinuxSyscall.FanotifyInit
    | "fanotify_mark" -> LinuxSyscall.FanotifyMark
    | "fchdir" -> LinuxSyscall.Fchdir
    | "fchmod" -> LinuxSyscall.Fchmod
    | "fchmodat" -> LinuxSyscall.Fchmodat
    | "fchown" -> LinuxSyscall.Fchown
    | "fchown32" -> LinuxSyscall.Fchown32
    | "fchownat" -> LinuxSyscall.Fchownat
    | "fcntl" -> LinuxSyscall.Fcntl
    | "fcntl64" -> LinuxSyscall.Fcntl64
    | "fdatasync" -> LinuxSyscall.Fdatasync
    | "fgetxattr" -> LinuxSyscall.Fgetxattr
    | "finit_module" -> LinuxSyscall.FinitModule
    | "flistxattr" -> LinuxSyscall.Flistxattr
    | "flock" -> LinuxSyscall.Flock
    | "fork" -> LinuxSyscall.Fork
    | "free_hugepages" -> LinuxSyscall.FreeHugepages
    | "fremovexattr" -> LinuxSyscall.Fremovexattr
    | "fsconfig" -> LinuxSyscall.Fsconfig
    | "fsetxattr" -> LinuxSyscall.Fsetxattr
    | "fsmount" -> LinuxSyscall.Fsmount
    | "fsopen" -> LinuxSyscall.Fsopen
    | "fspick" -> LinuxSyscall.Fspick
    | "fstat" -> LinuxSyscall.Fstat
    | "fstat64" -> LinuxSyscall.Fstat64
    | "fstatat64" -> LinuxSyscall.Fstatat64
    | "fstatfs" -> LinuxSyscall.Fstatfs
    | "fstatfs64" -> LinuxSyscall.Fstatfs64
    | "fsync" -> LinuxSyscall.Fsync
    | "ftruncate" -> LinuxSyscall.Ftruncate
    | "ftruncate64" -> LinuxSyscall.Ftruncate64
    | "futex" -> LinuxSyscall.Futex
    | "futex64" -> LinuxSyscall.Futex64
    | "futimesat" -> LinuxSyscall.Futimesat
    | "get_kernel_syms" -> LinuxSyscall.GetKernelSyms
    | "get_mempolicy" -> LinuxSyscall.GetMempolicy
    | "get_robust_list" -> LinuxSyscall.GetRobustList
    | "get_thread_area" -> LinuxSyscall.GetThreadArea
    | "get_tls" -> LinuxSyscall.GetTLS
    | "getcpu" -> LinuxSyscall.Getcpu
    | "getcwd" -> LinuxSyscall.Getcwd
    | "getdents" -> LinuxSyscall.Getdents
    | "getdents64" -> LinuxSyscall.Getdents64
    | "getdomainname" -> LinuxSyscall.Getdomainname
    | "getdtablesize" -> LinuxSyscall.Getdtablesize
    | "getegid" -> LinuxSyscall.Getegid
    | "getegid32" -> LinuxSyscall.Getegid32
    | "geteuid" -> LinuxSyscall.Geteuid
    | "geteuid32" -> LinuxSyscall.Geteuid32
    | "getgid" -> LinuxSyscall.Getgid
    | "getgid32" -> LinuxSyscall.Getgid32
    | "getgroups" -> LinuxSyscall.Getgroups
    | "getgroups32" -> LinuxSyscall.Getgroups32
    | "gethostname" -> LinuxSyscall.Gethostname
    | "getitimer" -> LinuxSyscall.Getitimer
    | "getpeername" -> LinuxSyscall.Getpeername
    | "getpagesize" -> LinuxSyscall.Getpagesize
    | "getpgid" -> LinuxSyscall.Getpgid
    | "getpgrp" -> LinuxSyscall.Getpgrp
    | "getpid" -> LinuxSyscall.Getpid
    | "getppid" -> LinuxSyscall.Getppid
    | "getpriority" -> LinuxSyscall.Getpriority
    | "getrandom" -> LinuxSyscall.Getrandom
    | "getresgid" -> LinuxSyscall.Getresgid
    | "getresgid32" -> LinuxSyscall.Getresgid32
    | "getresuid" -> LinuxSyscall.Getresuid
    | "getresuid32" -> LinuxSyscall.Getresuid32
    | "getrlimit" -> LinuxSyscall.Getrlimit
    | "getrusage" -> LinuxSyscall.Getrusage
    | "getsid" -> LinuxSyscall.Getsid
    | "getsockname" -> LinuxSyscall.Getsockname
    | "getsockopt" -> LinuxSyscall.Getsockopt
    | "gettid" -> LinuxSyscall.Gettid
    | "gettimeofday" -> LinuxSyscall.Gettimeofday
    | "getuid" -> LinuxSyscall.Getuid
    | "getuid32" -> LinuxSyscall.Getuid32
    | "getunwind" -> LinuxSyscall.Getunwind
    | "getxattr" -> LinuxSyscall.Getxattr
    | "getxgid" -> LinuxSyscall.Getxgid
    | "getxpid" -> LinuxSyscall.Getxpid
    | "getxuid" -> LinuxSyscall.Getxuid
    | "init_module" -> LinuxSyscall.InitModule
    | "inotify_add_watch" -> LinuxSyscall.InotifyAddWatch
    | "inotify_init" -> LinuxSyscall.InotifyInit
    | "inotify_init1" -> LinuxSyscall.InotifyInit1
    | "inotify_rm_watch" -> LinuxSyscall.InotifyRmWatch
    | "io_cancel" -> LinuxSyscall.IoCancel
    | "io_destroy" -> LinuxSyscall.IoDestroy
    | "io_getevents" -> LinuxSyscall.IoGetevents
    | "io_pgetevents" -> LinuxSyscall.IoPgetevents
    | "io_pgetevents64" -> LinuxSyscall.IoPgetevents64
    | "io_setup" -> LinuxSyscall.IoSetup
    | "io_submit" -> LinuxSyscall.IoSubmit
    | "io_uring_enter" -> LinuxSyscall.IoUringEnter
    | "io_uring_register" -> LinuxSyscall.IoUringRegister
    | "io_uring_setup" -> LinuxSyscall.IoUringSetup
    | "ioctl" -> LinuxSyscall.Ioctl
    | "ioperm" -> LinuxSyscall.Ioperm
    | "iopl" -> LinuxSyscall.Iopl
    | "ioprio_get" -> LinuxSyscall.IoprioGet
    | "ioprio_set" -> LinuxSyscall.IoprioSet
    | "ipc" -> LinuxSyscall.Ipc
    | "kcmp" -> LinuxSyscall.Kcmp
    | "kern_features" -> LinuxSyscall.KernFeatures
    | "kexec_file_load" -> LinuxSyscall.KexecFileLoad
    | "kexec_load" -> LinuxSyscall.KexecLoad
    | "keyctl" -> LinuxSyscall.Keyctl
    | "kill" -> LinuxSyscall.Kill
    | "lchown" -> LinuxSyscall.Lchown
    | "lchown32" -> LinuxSyscall.Lchown32
    | "lgetxattr" -> LinuxSyscall.Lgetxattr
    | "link" -> LinuxSyscall.Link
    | "linkat" -> LinuxSyscall.Linkat
    | "listen" -> LinuxSyscall.Listen
    | "listxattr" -> LinuxSyscall.Listxattr
    | "llistxattr" -> LinuxSyscall.Llistxattr
    | "lookup_dcookie" -> LinuxSyscall.LookupDcookie
    | "lremovexattr" -> LinuxSyscall.Lremovexattr
    | "lseek" -> LinuxSyscall.Lseek
    | "_llseek" -> LinuxSyscall.LLseek
    | "lsetxattr" -> LinuxSyscall.Lsetxattr
    | "lstat" -> LinuxSyscall.Lstat
    | "lstat64" -> LinuxSyscall.Lstat64
    | "madvise" -> LinuxSyscall.Madvise
    | "mbind" -> LinuxSyscall.Mbind
    | "memory_ordering" -> LinuxSyscall.MemoryOrdering
    | "metag_get_tls" -> LinuxSyscall.MetagGetTLS
    | "metag_set_fpu_flags" -> LinuxSyscall.MetagSetFpuFlags
    | "metag_set_tls" -> LinuxSyscall.MetagSetTLS
    | "metag_setglobalbit" -> LinuxSyscall.MetagSetglobalbit
    | "membarrier" -> LinuxSyscall.Membarrier
    | "memfd_create" -> LinuxSyscall.MemfdCreate
    | "migrate_pages" -> LinuxSyscall.MigratePages
    | "mincore" -> LinuxSyscall.Mincore
    | "mkdir" -> LinuxSyscall.Mkdir
    | "mkdirat" -> LinuxSyscall.Mkdirat
    | "mknod" -> LinuxSyscall.Mknod
    | "mknodat" -> LinuxSyscall.Mknodat
    | "mlock" -> LinuxSyscall.Mlock
    | "mlock2" -> LinuxSyscall.Mlock2
    | "mlockall" -> LinuxSyscall.Mlockall
    | "mmap" -> LinuxSyscall.Mmap
    | "mmap2" -> LinuxSyscall.Mmap2
    | "modify_ldt" -> LinuxSyscall.ModifyLdt
    | "mount" -> LinuxSyscall.Mount
    | "move_mount" -> LinuxSyscall.MoveMount
    | "move_pages" -> LinuxSyscall.MovePages
    | "mprotect" -> LinuxSyscall.Mprotect
    | "mq_getsetattr" -> LinuxSyscall.MqGetsetattr
    | "mq_notify" -> LinuxSyscall.MqNotify
    | "mq_open" -> LinuxSyscall.MqOpen
    | "mq_timedreceive" -> LinuxSyscall.MqTimedreceive
    | "mq_timedreceive64" -> LinuxSyscall.MqTimedreceive64
    | "mq_timedsend" -> LinuxSyscall.MqTimedsend
    | "mq_timedsend64" -> LinuxSyscall.MqTimedsend64
    | "mq_unlink" -> LinuxSyscall.MqUnlink
    | "mremap" -> LinuxSyscall.Mremap
    | "msgctl" -> LinuxSyscall.Msgctl
    | "msgget" -> LinuxSyscall.Msgget
    | "msgrcv" -> LinuxSyscall.Msgrcv
    | "msgsnd" -> LinuxSyscall.Msgsnd
    | "msync" -> LinuxSyscall.Msync
    | "munlock" -> LinuxSyscall.Munlock
    | "munlockall" -> LinuxSyscall.Munlockall
    | "munmap" -> LinuxSyscall.Munmap
    | "name_to_handle_at" -> LinuxSyscall.NameToHandleAt
    | "nanosleep" -> LinuxSyscall.Nanosleep
    | "newfstatat" -> LinuxSyscall.Newfstatat
    | "_newselect" -> LinuxSyscall.NewSelect
    | "nfsservctl" -> LinuxSyscall.Nfsservctl
    | "nice" -> LinuxSyscall.Nice
    | "old_adjtimex" -> LinuxSyscall.OldAdjtimex
    | "old_getrlimit" -> LinuxSyscall.OldGetrlimit
    | "oldfstat" -> LinuxSyscall.Oldfstat
    | "oldlstat" -> LinuxSyscall.Oldlstat
    | "oldolduname" -> LinuxSyscall.Oldolduname
    | "oldstat" -> LinuxSyscall.Oldstat
    | "oldumount" -> LinuxSyscall.Oldumount
    | "olduname" -> LinuxSyscall.Olduname
    | "open" -> LinuxSyscall.Open
    | "open_by_handle_at" -> LinuxSyscall.OpenByHandleAt
    | "open_tree" -> LinuxSyscall.OpenTree
    | "openat" -> LinuxSyscall.Openat
    | "openat2" -> LinuxSyscall.Openat2
    | "or1k_atomic" -> LinuxSyscall.Or1kAtomic
    | "pause" -> LinuxSyscall.Pause
    | "pciconfig_iobase" -> LinuxSyscall.PciconfigIobase
    | "pciconfig_read" -> LinuxSyscall.PciconfigRead
    | "pciconfig_write" -> LinuxSyscall.PciconfigWrite
    | "perf_event_open" -> LinuxSyscall.PerfEventOpen
    | "personality" -> LinuxSyscall.Personality
    | "perfctr" -> LinuxSyscall.Perfctr
    | "perfmonctl" -> LinuxSyscall.Perfmonctl
    | "pidfd_getfd" -> LinuxSyscall.PidfdGetfd
    | "pidfd_send_signal" -> LinuxSyscall.PidfdSendSignal
    | "pidfd_open" -> LinuxSyscall.PidfdOpen
    | "pipe" -> LinuxSyscall.Pipe
    | "pipe2" -> LinuxSyscall.Pipe2
    | "pivot_root" -> LinuxSyscall.PivotRoot
    | "pkey_alloc" -> LinuxSyscall.PkeyAlloc
    | "pkey_free" -> LinuxSyscall.PkeyFree
    | "pkey_mprotect" -> LinuxSyscall.PkeyMprotect
    | "poll" -> LinuxSyscall.Poll
    | "ppoll" -> LinuxSyscall.Ppoll
    | "ppoll64" -> LinuxSyscall.Ppoll64
    | "prctl" -> LinuxSyscall.Prctl
    | "pread" -> LinuxSyscall.Pread
    | "pread64" -> LinuxSyscall.Pread64
    | "preadv" -> LinuxSyscall.Preadv
    | "preadv2" -> LinuxSyscall.Preadv2
    | "prlimit64" -> LinuxSyscall.Prlimit64
    | "process_vm_readv" -> LinuxSyscall.ProcessVmReadv
    | "process_vm_writev" -> LinuxSyscall.ProcessVmWritev
    | "pselect6" -> LinuxSyscall.Pselect6
    | "pselect6_64" -> LinuxSyscall.Pselect6_64
    | "ptrace" -> LinuxSyscall.Ptrace
    | "pwrite" -> LinuxSyscall.Pwrite
    | "pwrite64" -> LinuxSyscall.Pwrite64
    | "pwritev" -> LinuxSyscall.Pwritev
    | "pwritev2" -> LinuxSyscall.Pwritev2
    | "query_module" -> LinuxSyscall.QueryModule
    | "quotactl" -> LinuxSyscall.Quotactl
    | "read" -> LinuxSyscall.Read
    | "readahead" -> LinuxSyscall.Readahead
    | "readdir" -> LinuxSyscall.Readdir
    | "readlink" -> LinuxSyscall.Readlink
    | "readlinkat" -> LinuxSyscall.Readlinkat
    | "readv" -> LinuxSyscall.Readv
    | "reboot" -> LinuxSyscall.Reboot
    | "recv" -> LinuxSyscall.Recv
    | "recvfrom" -> LinuxSyscall.Recvfrom
    | "recvmsg" -> LinuxSyscall.Recvmsg
    | "recvmmsg" -> LinuxSyscall.Recvmmsg
    | "recvmmsg64" -> LinuxSyscall.Recvmmsg64
    | "remap_file_pages" -> LinuxSyscall.RemapFilePages
    | "removexattr" -> LinuxSyscall.Removexattr
    | "rename" -> LinuxSyscall.Rename
    | "renameat" -> LinuxSyscall.Renameat
    | "renameat2" -> LinuxSyscall.Renameat2
    | "request_key" -> LinuxSyscall.RequestKey
    | "restart_syscall" -> LinuxSyscall.RestartSyscall
    | "riscv_flush_icache" -> LinuxSyscall.RiscvFlushIcache
    | "rmdir" -> LinuxSyscall.Rmdir
    | "rseq" -> LinuxSyscall.Rseq
    | "rt_sigaction" -> LinuxSyscall.RtSigaction
    | "rt_sigpending" -> LinuxSyscall.RtSigpending
    | "rt_sigprocmask" -> LinuxSyscall.RtSigprocmask
    | "rt_sigqueueinfo" -> LinuxSyscall.RtSigqueueinfo
    | "rt_sigreturn" -> LinuxSyscall.RtSigreturn
    | "rt_sigsuspend" -> LinuxSyscall.RtSigsuspend
    | "rt_sigtimedwait" -> LinuxSyscall.RtSigtimedwait
    | "rt_sigtimedwait64" -> LinuxSyscall.RtSigtimedwait64
    | "rt_tgsigqueueinfo" -> LinuxSyscall.RtTgsigqueueinfo
    | "rtas" -> LinuxSyscall.Rtas
    | "s390_runtime_instr" -> LinuxSyscall.S390RuntimeInstr
    | "s390_pci_mmio_read" -> LinuxSyscall.S390PciMmioRead
    | "s390_pci_mmio_write" -> LinuxSyscall.S390PciMmioWrite
    | "s390_sthyi" -> LinuxSyscall.S390Sthyi
    | "s390_guarded_storage" -> LinuxSyscall.S390GuardedStorage
    | "sched_get_affinity" -> LinuxSyscall.SchedGetAffinity
    | "sched_get_priority_max" -> LinuxSyscall.SchedGetPriorityMax
    | "sched_get_priority_min" -> LinuxSyscall.SchedGetPriorityMin
    | "sched_getaffinity" -> LinuxSyscall.SchedGetaffinity
    | "sched_getattr" -> LinuxSyscall.SchedGetattr
    | "sched_getparam" -> LinuxSyscall.SchedGetparam
    | "sched_getscheduler" -> LinuxSyscall.SchedGetscheduler
    | "sched_rr_get_interval" -> LinuxSyscall.SchedRrGetInterval
    | "sched_rr_get_interval64" -> LinuxSyscall.SchedRrGetInterval64
    | "sched_set_affinity" -> LinuxSyscall.SchedSetAffinity
    | "sched_setaffinity" -> LinuxSyscall.SchedSetaffinity
    | "sched_setattr" -> LinuxSyscall.SchedSetattr
    | "sched_setparam" -> LinuxSyscall.SchedSetparam
    | "sched_setscheduler" -> LinuxSyscall.SchedSetscheduler
    | "sched_yield" -> LinuxSyscall.SchedYield
    | "seccomp" -> LinuxSyscall.Seccomp
    | "select" -> LinuxSyscall.Select
    | "semctl" -> LinuxSyscall.Semctl
    | "semget" -> LinuxSyscall.Semget
    | "semop" -> LinuxSyscall.Semop
    | "semtimedop" -> LinuxSyscall.Semtimedop
    | "semtimedop64" -> LinuxSyscall.Semtimedop64
    | "send" -> LinuxSyscall.Send
    | "sendfile" -> LinuxSyscall.Sendfile
    | "sendfile64" -> LinuxSyscall.Sendfile64
    | "sendmmsg" -> LinuxSyscall.Sendmmsg
    | "sendmsg" -> LinuxSyscall.Sendmsg
    | "sendto" -> LinuxSyscall.Sendto
    | "set_mempolicy" -> LinuxSyscall.SetMempolicy
    | "set_robust_list" -> LinuxSyscall.SetRobustList
    | "set_thread_area" -> LinuxSyscall.SetThreadArea
    | "set_tid_address" -> LinuxSyscall.SetTidAddress
    | "set_tls" -> LinuxSyscall.SetTLS
    | "setdomainname" -> LinuxSyscall.Setdomainname
    | "setfsgid" -> LinuxSyscall.Setfsgid
    | "setfsgid32" -> LinuxSyscall.Setfsgid32
    | "setfsuid" -> LinuxSyscall.Setfsuid
    | "setfsuid32" -> LinuxSyscall.Setfsuid32
    | "setgid" -> LinuxSyscall.Setgid
    | "setgid32" -> LinuxSyscall.Setgid32
    | "setgroups" -> LinuxSyscall.Setgroups
    | "setgroups32" -> LinuxSyscall.Setgroups32
    | "sethae" -> LinuxSyscall.Sethae
    | "sethostname" -> LinuxSyscall.Sethostname
    | "setitimer" -> LinuxSyscall.Setitimer
    | "setns" -> LinuxSyscall.Setns
    | "setpgid" -> LinuxSyscall.Setpgid
    | "setpgrp" -> LinuxSyscall.Setpgrp
    | "setpriority" -> LinuxSyscall.Setpriority
    | "setregid" -> LinuxSyscall.Setregid
    | "setregid32" -> LinuxSyscall.Setregid32
    | "setresgid" -> LinuxSyscall.Setresgid
    | "setresgid32" -> LinuxSyscall.Setresgid32
    | "setresuid" -> LinuxSyscall.Setresuid
    | "setresuid32" -> LinuxSyscall.Setresuid32
    | "setreuid" -> LinuxSyscall.Setreuid
    | "setreuid32" -> LinuxSyscall.Setreuid32
    | "setrlimit" -> LinuxSyscall.Setrlimit
    | "setsid" -> LinuxSyscall.Setsid
    | "setsockopt" -> LinuxSyscall.Setsockopt
    | "settimeofday" -> LinuxSyscall.Settimeofday
    | "setuid" -> LinuxSyscall.Setuid
    | "setuid32" -> LinuxSyscall.Setuid32
    | "setup" -> LinuxSyscall.Setup
    | "setxattr" -> LinuxSyscall.Setxattr
    | "sgetmask" -> LinuxSyscall.Sgetmask
    | "shmat" -> LinuxSyscall.Shmat
    | "shmctl" -> LinuxSyscall.Shmctl
    | "shmdt" -> LinuxSyscall.Shmdt
    | "shmget" -> LinuxSyscall.Shmget
    | "shutdown" -> LinuxSyscall.Shutdown
    | "sigaction" -> LinuxSyscall.Sigaction
    | "sigaltstack" -> LinuxSyscall.Sigaltstack
    | "signal" -> LinuxSyscall.Signal
    | "signalfd" -> LinuxSyscall.Signalfd
    | "signalfd4" -> LinuxSyscall.Signalfd4
    | "sigpending" -> LinuxSyscall.Sigpending
    | "sigprocmask" -> LinuxSyscall.Sigprocmask
    | "sigreturn" -> LinuxSyscall.Sigreturn
    | "sigsuspend" -> LinuxSyscall.Sigsuspend
    | "socket" -> LinuxSyscall.Socket
    | "socketcall" -> LinuxSyscall.Socketcall
    | "socketpair" -> LinuxSyscall.Socketpair
    | "spill" -> LinuxSyscall.Spill
    | "splice" -> LinuxSyscall.Splice
    | "spu_create" -> LinuxSyscall.SpuCreate
    | "spu_run" -> LinuxSyscall.SpuRun
    | "sram_alloc" -> LinuxSyscall.SramAlloc
    | "sram_free" -> LinuxSyscall.SramFree
    | "ssetmask" -> LinuxSyscall.Ssetmask
    | "stat" -> LinuxSyscall.Stat
    | "stat64" -> LinuxSyscall.Stat64
    | "statfs" -> LinuxSyscall.Statfs
    | "statfs64" -> LinuxSyscall.Statfs64
    | "statx" -> LinuxSyscall.Statx
    | "stime" -> LinuxSyscall.Stime
    | "subpage_prot" -> LinuxSyscall.SubpageProt
    | "swapcontext" -> LinuxSyscall.SwitchEndian
    | "switch_endian" -> LinuxSyscall.Swapcontext
    | "swapoff" -> LinuxSyscall.Swapoff
    | "swapon" -> LinuxSyscall.Swapon
    | "symlink" -> LinuxSyscall.Symlink
    | "symlinkat" -> LinuxSyscall.Symlinkat
    | "sync" -> LinuxSyscall.Sync
    | "sync_file_range" -> LinuxSyscall.SyncFileRange
    | "sync_file_range2" -> LinuxSyscall.SyncFileRange2
    | "syncfs" -> LinuxSyscall.Syncfs
    | "sys_debug_setcontext" -> LinuxSyscall.SysDebugSetcontext
    | "syscall" -> LinuxSyscall.Syscall
    | "_sysctl" -> LinuxSyscall.Sysctl
    | "sysfs" -> LinuxSyscall.Sysfs
    | "sysinfo" -> LinuxSyscall.Sysinfo
    | "syslog" -> LinuxSyscall.Syslog
    | "sysmips" -> LinuxSyscall.Sysmips
    | "tee" -> LinuxSyscall.Tee
    | "tgkill" -> LinuxSyscall.Tgkill
    | "time" -> LinuxSyscall.Time
    | "timer_create" -> LinuxSyscall.TimerCreate
    | "timer_delete" -> LinuxSyscall.TimerDelete
    | "timer_getoverrun" -> LinuxSyscall.TimerGetoverrun
    | "timer_gettime" -> LinuxSyscall.TimerGettime
    | "timer_gettime64" -> LinuxSyscall.TimerGettime64
    | "timer_settime" -> LinuxSyscall.TimerSettime
    | "timer_settime64" -> LinuxSyscall.TimerSettime64
    | "timerfd" -> LinuxSyscall.Timerfd
    | "timerfd_create" -> LinuxSyscall.TimerfdCreate
    | "timerfd_gettime" -> LinuxSyscall.TimerfdGettime
    | "timerfd_gettime64" -> LinuxSyscall.TimerfdGettime64
    | "timerfd_settime" -> LinuxSyscall.TimerfdSettime
    | "timerfd_settime64" -> LinuxSyscall.TimerfdSettime64
    | "times" -> LinuxSyscall.Times
    | "tkill" -> LinuxSyscall.Tkill
    | "truncate" -> LinuxSyscall.Truncate
    | "truncate64" -> LinuxSyscall.Truncate64
    | "ugetrlimit" -> LinuxSyscall.Ugetrlimit
    | "umask" -> LinuxSyscall.Umask
    | "umount" -> LinuxSyscall.Umount
    | "umount2" -> LinuxSyscall.Umount2
    | "uname" -> LinuxSyscall.Uname
    | "unlink" -> LinuxSyscall.Unlink
    | "unlinkat" -> LinuxSyscall.Unlinkat
    | "unshare" -> LinuxSyscall.Unshare
    | "uselib" -> LinuxSyscall.Uselib
    | "ustat" -> LinuxSyscall.Ustat
    | "userfaultfd" -> LinuxSyscall.Userfaultfd
    | "usr26" -> LinuxSyscall.Usr26
    | "usr32" -> LinuxSyscall.Usr32
    | "utime" -> LinuxSyscall.Utime
    | "utimensat" -> LinuxSyscall.Utimensat
    | "utimensat64" -> LinuxSyscall.Utimensat64
    | "utimes" -> LinuxSyscall.Utimes
    | "utrap_install" -> LinuxSyscall.UtrapInstall
    | "vfork" -> LinuxSyscall.Vfork
    | "vhangup" -> LinuxSyscall.Vhangup
    | "vm86old" -> LinuxSyscall.Vm86old
    | "vm86" -> LinuxSyscall.Vm86
    | "vmsplice" -> LinuxSyscall.Vmsplice
    | "vserver" -> LinuxSyscall.Vserver
    | "wait4" -> LinuxSyscall.Wait4
    | "waitid" -> LinuxSyscall.Waitid
    | "waitpid" -> LinuxSyscall.Waitpid
    | "write" -> LinuxSyscall.Write
    | "writev" -> LinuxSyscall.Writev
    | "xtensa" -> LinuxSyscall.Xtensa
    | _ -> raise UnhandledSyscallException