//-----------------------------------------------------------------------
// <copyright file="NetDataContractOperationBehavior.cs" company="Marimer LLC">
//     Copyright (c) Marimer LLC. All rights reserved.
//     Website: http://www.lhotka.net/cslanet/
// </copyright>
// <summary>Override the DataContract serialization behavior to</summary>
//-----------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ServiceModel;
using System.Runtime.Serialization;
using System.Xml;
using System.ServiceModel.Description;

namespace Atk.DataPortal.Server.Hosts.WcfChannel
{
    /// <summary>
    /// ΪNetDataContractSerializerDataContractлΪ
    /// </summary>
    public class NetDataContractOperationBehavior : DataContractSerializerOperationBehavior
    {
        #region 

        /// <summary>
        /// 췽
        /// </summary>
        /// <param name="operation"></param>
        public NetDataContractOperationBehavior(OperationDescription operation)
            : base(operation)
        {
        }

        /// <summary>
        /// 췽
        /// </summary>
        /// <param name="operation"></param>
        /// <param name="dataContractFormatAttribute">ԼԶ</param>
        public NetDataContractOperationBehavior(OperationDescription operation, DataContractFormatAttribute dataContractFormatAttribute)
            : base(operation, dataContractFormatAttribute)
        {
        }

        #endregion

        #region ط

        ///// <summary>
        ///// ؽCreateSerializerXmlObjectSerializerṩɱҵ
        ///// </summary>
        /// <summary>
        /// һʵлͷл̵ XmlObjectSerializer м̳С
        /// ؽCreateSerializerXmlObjectSerializerṩɱҵ
        /// </summary>
        /// <param name="type">ҪΪ䴴л Type</param>
        /// <param name="name">͵</param>
        /// <param name="ns">͵ռ</param>
        /// <param name="knownTypes">֪͵ Type  IList</param>
        /// <returns>̳ XmlObjectSerializer һʵ</returns>
        public override XmlObjectSerializer CreateSerializer(Type type, string name, string ns,
            IList<Type> knownTypes)
        {
            return new NetDataContractSerializer(name, ns);
        }

        /// <summary>
        /// һʵлͷл
        ///  XmlDictionaryString ռ䣩 XmlObjectSerializer м̳С
        /// ؽCreateSerializerXmlObjectSerializerṩɱҵ
        /// </summary>
        /// <param name="type">Ҫлл</param>
        /// <param name="name">л͵</param>
        /// <param name="ns">л͵ռ XmlDictionaryString</param>
        /// <param name="knownTypes">֪͵ Type  IList</param>
        /// <returns>̳ XmlObjectSerializer һʵ</returns>
        public override XmlObjectSerializer CreateSerializer(Type type, XmlDictionaryString name,
            XmlDictionaryString ns, IList<Type> knownTypes)
        {
            return new NetDataContractSerializer(name, ns);
        }

        #endregion
    }
}