# Glosario de términos

- `AI`: Acrónimo de "_Artificial Intelligence_" (Inteligencia artificial), es la capacidad de las máquinas para realizar tareas que requieren inteligencia humana, utilizando tecnologías de aprendizaje automático, procesamiento de lenguaje natural y visión por computadora, entre otras.

- `API`: Acrónimo de _"Application Programming Interface"_ (Interfaz de programación de aplicaciones), es un conjunto de reglas y protocolos que especifican cómo diferentes aplicaciones de software pueden interactuar entre sí. Una API actúa como una capa intermedia entre dos programas, permitiendo que se comuniquen entre sí de manera estandarizada. Las APIs son una forma común de intercambiar datos y servicios entre aplicaciones y pueden ser utilizadas para integrar diferentes sistemas o para permitir que los desarrolladores creen nuevas aplicaciones a partir de servicios existentes.

- `Chatbot`: es un programa de computadora que utiliza tecnologías de procesamiento de lenguaje natural y aprendizaje automático para simular una conversación humana con los usuarios a través de mensajes de texto o voz.

- `ML`: Acrónimo de "_Machine Learning_" (Aprendizaje automático). Es una rama de la inteligencia artificial que utiliza algoritmos para aprender a partir de datos y hacer predicciones o tomar decisiones sin ser explícitamente programado para realizar una tarea específica. `ML` se utiliza en una amplia variedad de aplicaciones, desde la detección de fraudes hasta la recomendación de productos en línea.

- `DL`: Acrónimo de "_Deep learning_" (Aprendizje profundo). Es una técnica de `ML` que utiliza redes neuronales con múltiples capas para procesar y analizar datos. El aprendizaje profundo se utiliza comúnmente en tareas de procesamiento de lenguaje natural como la generación de texto, la clasificación de texto y el análisis de sentimiento.

- `LLM`: Acrónimo de "_Large Language Model_" (Modelo lingüístico de gran tamaño). Hace referencia a modelos de lenguaje como _ChatGPT_ que utilizan redes neuronales de gran tamaño y técnicas de `DL` para procesar y generar texto.

- `LaMDA`: Acrónimo de "_Language Model for Dialogue Applications_" (Modelo de lenguaje para aplicaciones de diálogo), es una familia de modelos de lenguaje neuronal conversacional desarrollado por Google.

- `RLFH`: Acrónimo de "_Reinforcement Learning from Human Feedback_" (Aprendizaje reforzado a partir del feedback humano), es un enfoque de aprendizaje automático que utiliza retroalimentación humana para mejorar el rendimiento del aprendizaje por refuerzo. Permite al modelo aprender a través de la interacción continua con humanos, en lugar de confiar en una función de recompensa predefinida. Se utiliza en robótica, juegos y tareas de toma de decisiones. 

- `NLP`: Acrónimo de "_Natural Language Processing_" (Procesamiento del lenguaje natural). Es una rama de la inteligencia artificial que se enfoca en la interacción entre los humanos y las computadoras mediante el lenguaje natural hablado o escrito. NLP se utiliza en una amplia variedad de aplicaciones, desde la traducción automática hasta la generación de texto y la comprensión de textos.

- `Red neuronal`: Una red neuronal (_Neural network_) es un algoritmo de `ML` inspirado en la estructura del cerebro humano que utiliza capas de neuronas interconectadas para procesar información y realizar predicciones.

- `Prompt`: Una cadena de texo que se utiliza como entrada para un modelo de lenguaje. En el caso de _ChatGPT_, el prompt se utiliza para iniciar la generación de texto.

- `Temperature`: Un parámetro utilizado en la generación de texto que controla la diversidad de las respuestas generadas por el modelo. Un valor alto de temperatura genera respuestas más diversas, mientras que un valor bajo de temperatura genera respuestas más conservadoras y predecibles.

- `Token`: Una unidad de texto que se utiliza como entrada para un modelo de lenguaje. En el caso de _ChatGPT_, los tokens suelen ser palabras o subpalabras.

---
[Volver al inicio](README.md)
