# Guía para Contribuciones

## Antes de Contribuir

Bienvenido a la comunidad [Ayuda en Python](https://www.facebook.com/groups/ayudaenpython/)! Antes de hacer un pull request, asegurate que has leído esta guía.

## Contribuyendo

### Contribuidor

Estamos encantados de que hayas considerado contribuir! Este repositorio tiene
como finalidad brindar ayuda a todo aquel que lo accese. Ser un contribuyente
implica que estas de acuerdo a lo siguiente:

- Tu contribución será distribuida bajo la [Licencia MIT](LICENSE.md).
- Tu contribución deberá estar ceñida al estándar [PEP8](https://www.python.org/dev/peps/pep-0008/).

### Contribución

Apreciamos cualquier tipo de contribución, desde ortografía (sobre todo en los
acentos) hasta la implementación de algoritmos complejos (la comunidad abarca
todos los niveles).

### Estilo de codificación

Queremos que toda solución sea legible para todos; por eso, te sugerimos y
alentamos a seguir las siguientes notas:

- De preferencia usa Python 3.7 o una versión superior.
- Usa nombres descriptivos, por ejemplo `usuarios = ['John', 'Jane']` en vez de `lista_usuarios = ['John', 'Jane']` (evita la redundancia).
- Remueve y evita comentarios redundantes.
- Se recomienda usar [f-strings](https://docs.python.org/es/3/tutorial/inputoutput.html#tut-f-strings) para mejorar la legibilidad.
- Las __listas de comprensión__ y __generadores__ son preferidos sobre `lambda`, `map`, `filter` y `reduce`.
- De ser posible incluye [docstrings](https://www.python.org/dev/peps/pep-0257/) y anotaciones ([typing](https://docs.python.org/es/3/library/typing.html)).
- De ser posible incluye [doctests](https://docs.python.org/3/library/doctest.html) para ilustrar y verificar la solución.


> **Nota**
Al momento de realizar tu primer pull request y empezar a contribuir,
asegurate de agregar tu informacion en la lista de contribuidores.


## Lista de Contribuidores

Apreciamos a todas las personas que de una u otra forma contribuyen
en este repositorio, gracias!

| N° | Nombre | Github |
| -: | ------ | ------ |
| 1 | Miguel Kanashiro Mansilla | [leugimkm](https://github.com/leugimkm) |
| 2 | <colaborador> | [<username>](https://github.com/<username>) |