## How to contribute to Luminol

#### **Find a bug?**

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/Astrabit-ST/Luminol/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/Astrabit-ST/Luminol/issues/new). Be sure to include a **title and clear description** and a **test case** demonstrating the expected behavior that is not occurring.

* If possible, use the relevant bug report templates to create the issue.
  * Try and provide a backtrace if possible.
  * You can do this by piping Luminol's output into a file and causing the crash.

#### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

#### **Did you fix whitespace, format code, or make a purely cosmetic patch?**

We do not generally accept these sorts of changes unless they substantially fix readability.

#### **Do you intend to add a new feature or change an existing one?**

* If you are adding a feature, check that it has not been suggested by searching on GitHub under [Issues](https://github.com/Astrabit-ST/Luminol/issues). If it hasn't, please open an issue for proper discussion.

* After there is a consensus on the new feature, you are free to make a pull request.

#### **Did you make a commit to the repository?**

As a general rule of thumb we use [conventional commits](https://www.conventionalcommits.org/en/v1.0.0/) for commit messages. It's okay if you miss it occasionally though!

You can use the [Conventional Commits](https://marketplace.visualstudio.com/items?itemName=vivaxy.vscode-conventional-commits) Visual Studio Code extension to automatically write conventional commit messages for you.

#### **Do you have questions about the source code?**

* Ask any question about code design in the [discord server](https://discord.gg/8jZKmesKJy).
