# Privacy Policy

Personizer GmbH & Co. KG (“Personizer” or “We”) would like to inform the visitors and users of our web pages and services about how we process their personal data and about the purpose, the nature and the scope of such processing. The entity responsible for data processing on our websites or in connection with our services within the meaning of the General Data Protection Regulation (GDPR) is Personizer GmbH & Co. KG, Schafjückenweg 2, 26180 Rastede, Germany.

## Our web pages and services

Since our web pages and services evolve constantly, this data protection information changes from time to time. In particular, this applies to the methods we use to analyse website usage and measure the effectiveness of advertising methods as well as to comparable services, especially services by third-party providers. For the current status, see the table below.

Regarding our use of service providers outside the European Union: We provide different services for users around the world. We generally prefer using service providers based in the EU for specific services if they can provide the same quality and similar pricing. Many services we use are either not currently available from EU-based providers or the existing providers do not offer acceptable alternatives. For this reason, we use a number of service providers based outside the European Union. We take care to ensure that everything is done to achieve an appropriate level of protection of data according to European and national privacy regulations.

### Use of personal data

We collect, process and use personal information to provide our services. This includes advertising our products and informing individuals who are interested in or already use our services about the features available. The scope of processing personal data primarily depends on whether a user simply visits one of our websites, uses them as a registered user or is just registering.

### Children’s privacy

Our websites are publicly accessible and not designed for children. We do not knowingly collect data from users who are considered minors under their national legislation.

## What information do we collect when you visit our website?

When you visit our website, your online behaviour may be evaluated statistically. This is primarily done using cookies and so-called web analytics. Your online behaviour is typically analysed anonymously; it will not be traced back to you. We process your data according to Art. 6 (1) (f) of the GDPR based on our legitimate interest in improving the stability and functionality of our website.

### Cookies

We use cookies on our web pages. Cookies are small text files that can be stored and read on your device. There are session cookies, which are deleted as soon as you close your web browser, and permanent cookies which remain stored even after the session is over. Cookies can contain data which allow a device to be recognised. In some cases, cookies only contain information on certain settings which are not connected with an individual.

On our websites, we use session cookies and permanent cookies. We process your data based on Art. 6 (1) S. 1 (f) of the GDPR in order to enable user guidance, improve the user experience and adapt how our website is displayed to you. You can configure your web browser to inform you about cookies when they are stored on your device. This makes the use of cookies transparent to you. In addition, you can delete cookies using the corresponding browser command and prevent new cookies from being stored on your system. Please note that our web pages may not display properly in this case and some features may be unavailable.

### User data and log files

When you visit our websites, so-called usage data records are temporarily stored on our web server for statistical purposes in order to improve the quality of our websites. These records consist of the following:

* the page from which you requested the file
* the name of the file
* the date and time of the request
* the amount of data transferred
* the access status (file transferred, file not found)
* the description of the type of web browser used
* the IP address of the requesting computer, which is truncated to ensure that it cannot be linked to a person

This log data is stored anonymously. We only store this information for no more than seven days for the purpose of detecting, narrowing down and eliminating attacks on our websites. After this period, we delete this information. The legal basis of this activity is Art. 6 (1) S. 1 (f) of the GDPR.

## Web analytics services

Based on our legitimate interest (i.e. interest in analysing, optimising and running our online offering within the meaning of Art. 6 (1) S. 1 (f) of the GDPR, we use the following web analytics tools:

### Google Analytics

To ensure the best possible user experience, we create anonymous usage profiles using Google Analytics. Google Analytics uses cookies which are stored on your device and which we can read. This allows us to recognise and count returning visitors anonymously. We process your data based on Art. 6 (1) S. 1 (f) of the GDPR or Section 15 (3) of the German telemedia act in order to determine how often different users access our web pages.

The information the cookie generates on your use of this website is usually sent to a Google server in the USA and saved there. However, because we have enabled IP anonymisation on this website, Google will first truncate your IP address in European Union Member States. Only in exceptional cases will the full IP address be sent to and shortened by Google servers in the USA. According to Art. 45 para. 1 of the GDPR, an appropriate level of data protection exists due to Google’s participation in the Privacy Shield. In addition, we have entered into an agreement with Google LLC (USA) regarding data processing on our behalf pursuant to Art. 28 of the GDPR. Under this agreement, Google will only use this information for evaluating how visitors use our website and compiling reports on website activities. You can object to this processing at any time by using one of the following methods:

You may prevent the installation of cookies by adjusting the settings of your browser; however, if you do so, you may be unable to use all features of this website. Additionally, you can prevent the transfer to Google of the data generated by the cookie and relating to your use of the website (including your IP address) and prevent Google from processing this data by downloading and installing the browser plugin available here. You will find the privacy statement, contact details and further information on Google Analytics in the list of our subcontractors below.

## Advertising (remarketing, conversion tracking)

Based on our legitimate interest, i.e. our interest in marketing our website optimally and analysing user behaviour in order to optimise our website as well as our advertising, and based on the express consent of the page visitor where required, we use the following online marketing services on our websites:

### Google Remarketing

We use Google’s cross-device remarketing technologies to allow other websites to show you targeted advertising based on your visit to our websites. We process your data based on Art. 6 (1) S. 1 (f) of the GDPR. The website operator has a legitimate interest in analysing user behaviour in order to optimise both their website and their advertising. When you visit our websites, it is possible for Google’s cross-device remarketing technologies to retrieve identifiers of the web browser you use (e.g. by creating a so-called browser fingerprint), evaluate your IP address or store identifiers (small text files, e.g. third-party cookies) on your device. Google may also link your visit to our websites to one or several of these identifiers as well as store this information to show you our advertisements on other websites.

The identifiers described above are designed as pseudonyms. We can ask Google to use its cross-device remarketing technologies to show you advertising on other websites based on the pages you visit on our websites. So if you visit a site that participates in Google’s display advertising network, Google can use the identifiers to determine if and what advertising should be displayed to you. For more information about how Google remarketing technologies work, see https://www.google.com/policies/technologies/ads/.

If you log in to Google services using your own login credentials or use one or more Google accounts of your own, Google may link the identifiers of different web browsers or devices with each other. So if Google has created separate identifiers for your laptop, desktop, smartphone or tablet PC, these identifiers can be associated with one another as soon as you access a Google service using your login credentials. This allows Google to target our advertising campaigns beyond individual devices. However, Google will only do this if you have given Google your consent to process your information in this way in the past.

You can adjust your settings to control advertising. You can object to this type of advertising at any time. To disable personalised advertising, visit https://support.google.com/ads/answer/2662922. Please note that these settings may not work for all devices or web browsers. For a privacy statement, contact details and further information on Google, see the list of our subcontractors below.

### Google Ads and Google Conversion Tracking

We use Google Ads. Google Ads is an online advertising program provided by Google LLC, 1600 Amphitheatre Parkway, Mountain View, CA 94043, United States (“Google”). As part of Google Ads, we use conversion tracking. When you click on an ad served by Google, a conversion tracking cookie will be set. Cookies are small text files that web browsers store on the user’s computer. These cookies expire after 30 days and are not used to identify users. When a user visits certain pages of this website while the cookie is still active, Google (and we) can see that the user has clicked on the ad and was forwarded to this page.

Each organisation using Google Ads receives a different cookie. The cookies cannot be tracked via the websites of these organisations. The information obtained by means of conversion cookies is used to create conversion statistics for Google Ads customers using conversion tracking. Customers are informed of the total number of users who have clicked on their ads and were forwarded to a page with a conversion tracking tag. However, they do not receive information which can be used to identify users personally. If you do not wish to participate in tracking, you can object to this use by disabling the conversion tracking cookie in the user settings of your web browser. You will then not be included in the conversion tracking statistics.

Conversion cookies are stored and this tracking tool is used under Art. 6 (1) (f) of the GDPR. The website operator has a legitimate interest in analysing user behaviour in order to optimise both their website and their advertising. For more information about Google Ads and Google Conversion Tracking, see the Google Privacy Policy. You can configure your browser so that it informs you when cookies are installed and only permits them individually, blocks cookies on a case-by-case basis or generally, or automatically deletes them when you close your web browser. The functionality of this website may be reduced if cookies are disabled. For a privacy statement, contact details and further information on Google Ads, see the list of our subcontractors below.

### Bing Universal Event Tracking (UET)

The Boden and Personizer websites use Bing Ads technology to collect and store data that is used to create usage profiles using pseudonyms. This service enables us to track user activity on our website when it has reached our website via advertisements from Bing Ads. If the page visitor reaches our website via such an ad, a cookie is set on their computer. On our website a Bing UET tag is integrated. This is a code used to store some non-personally identifiable information about the use of the website in connection with the cookie. This includes, among other things, the length of time spent on the website, which areas of the website were accessed, and which advertisements have reached the website. Information on the identity of the respective site visitor, as well as forms for entering personal data are not recorded.

The collected information is transmitted to Microsoft servers in the USA and stored there for a maximum of 180 days. The collection of the data generated by the cookie and related to the use of the website as well as the processing of this data can be prevented by deactivating the setting of cookies by the site visitor in their browser.

In addition, based on the user’s preferences Microsoft may be able to track usage behaviour across multiple electronic devices through cross-device tracking, enabling it to display personalised advertising on or in Microsoft websites and apps. This behaviour can be disabled by the site visitor at https://choice.microsoft.com/en-us/opt-out.

For more information on Bing analytics services, visit the Bing Ads website.

For more information about privacy at Microsoft and Bing, see the Microsoft Privacy Policy.

## Newsletter

Below, we describe the content of our newsletters as well as the procedure for opting in, the delivery process, the statistical evaluation process and your right to object. By subscribing to our newsletter, you agree to receive it and you accept the procedures described above.

### Content of the newsletter

We only dispatch newsletters, e-mails or other electronic notifications containing advertising (referenced as “newsletter” below) with the consent of the recipient or based on legal authorisation. If the user receives a specific description of the contents of the newsletter when subscribing, their consent applies to such contents. Otherwise, our newsletters contain information on our products, offers, promotions and our company.

### Double opt-in and logging

We use a double opt-in process when you subscribe to our newsletter. This means you receive an e-mail asking you to confirm your subscription. This confirmation is necessary to ensure no one subscribes with someone else’s e-mail address. Subscriptions to our newsletter are logged to allow us to provide evidence of subscriptions in accordance with regulations. This includes storing the time of registration and confirmation as well as the IP address. Changes to the information stored by our delivery service provider are also logged.

### Delivery Service Provider

Newsletters are mailed through CleverReach (CleverReach GmbH & Co. KG, Mühlenstr. 43, 26180 Rastede, Germany), our delivery service provider. For a privacy statement, contact details and further information on the delivery service provider, see the list of our subcontractors below.

The delivery service provider can also use data to improve its own services in anonymous form (i.e. without connecting the data to users), e.g. for technically improving its dispatch processes or how it displays the newsletters or for statistical purposes, e.g. for determining recipients’ countries. However, the delivery service provider does not use our newsletter recipients’ information to contact them itself or pass data on to third parties.

### Subscription information

To subscribe to our newsletter, your e-mail address is sufficient. Optionally, you can specify a name so we can address you personally in the newsletter.

### Statistical survey/analysis

Our newsletters include a so-called web beacon. This is a pixel-sized file which is retrieved by the delivery service provider when you open the newsletter. The beacon enables us to collect technical information, e.g. on your web browser and your system, as well as your IP address and the time of the beacon retrieval. This information is used to improve our services based on the technical information or the target groups and their viewing behaviour in connection with the places of retrieval (which can be determined using the IP address) or the times of access. The statistical information collected also includes whether the newsletters were opened, when they were opened and what links were clicked. While it is technically possible to associate this information with individual newsletter recipients, neither we nor our delivery service provider are interested in monitoring individual users. Instead, we use this information to understand the viewing habits of our users and adapt our content accordingly or to send different content according to our users’ interests.

Our use of a delivery service provider, our statistical evaluation/analysis and our logging of the registration process is based on our legitimate interests according to Art. 6 (1) (f) of the GDPR. We are interested in providing a user-friendly, secure newsletter system that serves our business interests while meeting users’ expectations.

### Termination/cancellation

You can unsubscribe from our newsletter at any time by revoking your consent. This simultaneously cancels your consent to its delivery via the delivery service provider and your consent to the statistical surveys. We regret that it is not possible to separately cancel the delivery by the delivery service provider and the statistical survey. You can find an Unsubscribe link at the bottom of each newsletter.

## Tools

We use a number of Google tools to enhance the functionality of our website.

### Google Tag Manager

We use Google Tag Manager. Google Tag Manager is a solution marketers use to manage website tags. Google Tag Manager itself (the tool that implements the tags) is a cookie-free domain that does not collect personal data. The tool triggers other tags which may collect data. Google Tag Manager does not access this data. For a privacy statement, contact details and further information on Google Tag Manager, see the list of our subcontractors below.

### Google reCAPTCHA

We use Google reCAPTCHA (referred to as “reCAPTCHA” below) on our websites. This service is offered by Google LLC, 1600 Amphitheatre Parkway, Mountain View, CA 94043, USA (“Google”). reCAPTCHA is designed to check whether data is entered on our websites by a human or by automated software, e.g. in a contact form. To determine this, reCAPTCHA analyses the website visitor’s behaviour using different characteristics. This analysis starts automatically as soon as the visitor opens the website. reCAPTCHA evaluates different information such as IP addresses, the time the visitor spends on the website, and mouse actions. The data collected is forwarded to Google.

reCAPTCHA evaluations run entirely in the background. Website visitors are not notified of the evaluation. We process your data based on Art. 6 (1) (f) of the GDPR. The website operator has a legitimate interest in protecting its web offerings from automated spying or spam. For a privacy statement, contact details and further information on Google reCAPTCHA, see the list of our subcontractors below.

### YouTube videos

Our website uses the YouTube embedding function to display and play videos provided by YouTube, which is part of Google.

When embedded YouTube videos are started, YouTube uses cookies to collect user behaviour information. According to information provided by YouTube, these cookies are used to collect video statistics, improve user friendliness and prevent abuse.

When the site visitor is logged in to Google, data generated when clicking on a video is directly associated with their account. Page visitors who do not want videos to be associated with their accounts need to log out before clicking on a button. Google stores page visitor information as usage profiles (even for users who are not logged in) and evaluates it. This evaluation occurs under Art. 6 (1) (f) of the GDPR based on Google’s legitimate interests in showing personalised advertising, carrying out market research and/or designing its website according to users’ requirements. Page visitors have a right to object against these user profiles. To exercise it, they must contact YouTube. For a privacy statement, contact details and further information on YouTube, see the list of our subcontractors below.

### Web hosting

We use Amazon Web Services (“AWS”), a service provided by Amazon Web Services Germany GmbH, Krausenstr. 38, 10117 Berlin, Germany for hosting our database and web content. This information is stored in a data centre in Frankfurt/Main, Germany, which is certified according to ISO 27001, 27017 and 2018 as well as PCI DSS Level 1. Of course, Personizer has only limited rights of access and the data is protected against access by third parties using the latest technology. You can find the privacy statement and contact information of Amazon AWS in the list of our subcontractors below.

## Sending transaction e-mails

We use Mailgun (Mailgun Technologies, Inc., 548 Market St. #43099, San Francisco, CA 94104, USA) for delivering order confirmations, notifications, invoice information, etc. We use Mailgun to ensure that our e-mail messages reach you reliably, securely and fast without being classified as spam. Mailgun is certified under the EU-US Privacy Shield which means the legal requirements for appropriate privacy levels according to Art. 45 of the GDPR are met. We have entered into an agreement with Mailgun regarding data processing on our behalf pursuant to Art. 28 of the GDPR. Under this agreement, Mailgun is obliged to protect our customers’ data and not pass it on to third parties. For a privacy statement, contact details and further information on Mailgun, see the list of our subcontractors below.

## What information do we collect for contract purposes when you open a customer account?

To use our services (whether free or chargeable), you must create a customer account. Below, we explain what information is stored or processed in connection with your customer account or with the execution of your contract.

### Creating a customer account for using our services

If you want to use our services you will need to create a customer account. When you create a customer account, we store your e-mail address and password in accordance with Art. 6 (1) S. 1 (b) of the GDPR. We will store your information until you object to our storing it and close your customer account by sending an e-mail to info@ashampoo-systems.com. Unless statutory retention periods require otherwise, we will delete your data within ten (10) days following your objection.

### Ordering a chargeable service

If you would like to use chargeable services, you will need to log in using your customer account. We only store and use the personal information you transmit to us during the ordering process in accordance with Art. 6 (1) S. 1 (b) of the GDPR for processing your orders. We will use your e-mail address for sending you notifications on the status of your order or related documents. We also offer you account reports as well as news & product information by e-mail.

As part of the ordering process, the information you provide us with regarding your order (name, address, account number, bank sort code, credit card number, invoice amount, currency and transaction number, if applicable) is passed on to payment service providers Stripe (Stripe Inc., 510 Townsend Street, San Francisco, CA 94103, USA, USA) and Taxamo (EVAT Solutions Ltd, trading as Taxamo, 1, Library Place, Iveragh Rd, Castleconway, Killorglin, Co. Kerry, Ireland) via an encrypted SSL or TLS connection. This information is only passed on where necessary for processing payment transactions. See the list of our subcontractors below for privacy statements and contact information of the payment service providers.

## What information do we collect when you communicate with us?

When you contact us, e.g. using our contact form, or when you participate in a survey, we may process personal data. Below, we explain what information this is and what purposes we process it for.

### Contact and support form

You can contact us using web forms. To use our contact form, you typically only need to disclose your e-mail address. You can enter additional information, but this is not required. By submitting the form, you agree that the data you have specified will be recorded and stored electronically for up to 6 years. The legal basis of processing under the contractual relationship is Art. 6 (1) S. 1 (b) of the GDPR; for all other purposes, Art. 6 (1) S. 1 (b) of the GDPR shall apply. The website operator has a legitimate interest in carrying out the exchange you initiated or processing your inquiry effectively. In this regard, we only use your data for processing your inquiry.

We use the Zendesk software solution offered by Zendesk Inc., 1019 Market St, San Francisco, CA 94103, USA to process your support or contact requests. Your data will be stored and processed on servers hosted by Zendesk in the EU. We have entered into an agreement with Zendesk regarding data processing on our behalf pursuant to Art. 28 of the GDPR. Under this agreement, Zendesk is obliged to protect our customers’ data and not pass it on to third parties. For a privacy statement, contact details and further information on Zendesk, see the list of our subcontractors below.

### Surveys

We use the services provided by SurveyMonkey Europe UC, 2nd Floor, 2 Shelbourne Buildings, Shelbourne Road, Dublin, Ireland for carrying out surveys on our website. If you participate in this optional survey, SurveyMonkey collects information on the device and the application you use for participating. This includes the IP address, the OS version, the device type as well as information on your system and its capabilities as well as the web browser type. If you use a mobile device for participating in the survey, SurveyMonkey will also store its UUID. SurveyMonkey also uses so-called tracking services by third-party providers which in turn use cookies and page tags (also known as web beacons) to collect usage data and user statistics. We have no control over the amount of data collected by SurveyMonkey. For more information on the cookies used by SurveyMonkey, on privacy and on retention periods, visit https://www.surveymonkey.com/mp/legal/privacy-policy/#pp-section-10.

We use SurveyMonkey to offer you surveys. This purpose is also the basis of our legitimate interest to process this data according to Art. 6 (1) (f) of the GDPR.

SurveyMonkey Europe UC is a subsidiary of SurveyMonkey Inc., based in the United States. We cannot exclude that your data collected by SurveyMonkey may also be transmitted to the United States. However, SurveyMonkey Inc. has agreed to abide by the Privacy Shield Agreement signed between the European Union and the United States and has obtained the appropriate certification. This means that SurveyMonkey is obliged to comply with the standards and regulations of European privacy legislation. For a privacy statement, contact details and further information on SurveyMonkey, see the list of our subcontractors below.

### Job applications, especially by e-mail

We process your personal data in accordance with the applicable privacy regulations based on Section 26 of the German data protection act. We only process the information you provide to us in your (online) application for selecting applicants. This data is not processed for any other purposes.

You determine the scope of the information you would like to transmit to us in your application. Applications are transmitted in encrypted form to our HR department, which will process them as quickly as possible. Normally applications are forwarded to the heads of the relevant departments. Your information will not be passed on to any other parties. Your information will be treated in confidence. If your application is not successful, your documents will be deleted after a period of 6 months.

If we may use your application for other or for future job openings, please make a note of this on your application. We will then process your data in accordance with Art. 6 (1) S. 1 (a) of the GDPR.

## Security measures

We take organisational, contractual and technical security measures according to the state of the art designed to ensure that privacy regulations are complied with and data we process are protected against accidental or deliberate manipulation, loss, destruction or access by unauthorised third parties.

### Connection security

Our websites use encryption. The data you enter will be transmitted from your computer to our server and vice versa via the internet using TLS encryption. You can tell this from the closed lock symbol in the status bar of your browser and the https:// in the address bar.

### Data security

Personizer user data is protected by technical and organizational security measures to minimise risks due to loss, abuse, unauthorised access and unauthorised disclosure or modification. Methods we use include firewalls, data encryption and physical restrictions of access to our data centres and data access authorisation checks.

### Administrative access

For purposes of customer service and to track errors, Personizer employees may access the administrative area of our websites from time to time. This means they can access all areas of a website, including password-protected areas. All of our employees are made aware of privacy issues and are obliged to comply with privacy and data protection regulations.

## Duration of storage of personal data

The data we process is deleted or processing is restricted in accordance with Articles 17 and 18 of the GDPR. Unless stated otherwise in this privacy statement, the data we store is deleted as soon as it is no longer required for its intended purpose and no statutory retention periods prevent it from being deleted and/or we have no legitimate interest in retaining it. If data is not deleted because it is required for other, legally permissible purposes, we restrict its processing, i.e. the data is blocked and cannot be processed for other purposes. For example, this applies to data which must be retained for commercial or for tax reasons.

According to legal requirements in Germany, retention periods are 6 years pursuant to Section 257 (1) of the German Commercial Code (trading books, inventories, opening balance sheets, annual accounts, trade letters, accounting documents, etc.) and 10 years in accordance with Section 147 Abs. 1 AO (books, records, management reports, accounting documents, commercial and business letters, documents relevant for taxation, etc.).

## Rights of the data subjects

Regarding the processing of your personal data, website visitors have certain rights under the GDPR:

### Right of access to information (Art. 15 GDPR)

You are entitled to a confirmation as to whether your personal data is processed. If this is the case, you have a right to be informed about the nature of this personal data and the information listed in Article 15 of the GDPR.

### Right to rectification and deletion (Articles 16 and 17 of the GDPR)

You have the right to request that incorrect personal data regarding you is corrected immediately or incomplete personal data is completed, as the case may be. In addition, you have the right to request that personal data regarding you is immediately deleted if one of the reasons stated in Art. 17 of the GDPR applies, e.g. if the data is no longer required for the purposes for which it was collected.

### Right to restriction of processing (Art. 18 of the GDPR)

You have the right to request that processing is restricted if one of the prerequisites stated in Art. 18 of the GDPR applies, e.g. if you objected to processing, for the duration of a possible examination.

### Right to data portability (Art. 20 of the GDPR)

In specific cases stated in Art. 20 of the GDPR, you have the right to obtain the personal data regarding you in a structured, common and machine-readable format or request that this data be transmitted to a third party.

### Right to object (Art. 21 GDPR)

If data is collected based on Article 6 (1) S. 1 (f) (processing is required for the purposes of legitimate interests), you have the right to object to the processing at any time for reasons arising from your particular situation. We will then no longer process your personal data unless there are demonstrably compelling reasons that outweigh the interests, rights and freedoms of the data subject, or the processing serves to assert, exercise or defend legal claims.

### Right to appeal to a supervisory authority

According to Art. 77 of the GDPR, you have the right to appeal to a supervisory authority if you consider the processing of personal data relating to you as a breach of data protection regulations. The right of appeal may be exercised in particular before a supervisory authority in the member state of your residence, your place of work or the place where the alleged infringement occurred.

## Changes to our privacy statement

We reserve the right to amend this privacy statement from time to time to ensure it meets current statutory requirements or to ensure it reflects changes to our services, including the introduction of new services. The latest version of our privacy statement shall always be applicable.

## Contact

Your trust is important to us. That is why we are always ready to answer your questions about the handling of your personal data. If, at any time, you have questions that this privacy policy could not answer or if you wish to receive more specific information about certain issues, please contact us or our data protection officer.

### Contact details of our data protection officer

Dr. Uwe Schläger  
datenschutz nord GmbH  
Konsul-Smidt-Straße 88  
28217 Bremen  
Web: www.datenschutz-nord-gruppe.de  
E-mail: office@datenschutz-nord.de  
Phone: +49-421-696632-0

## List of our subcontractors

We have entered into agreements with subcontractors carrying out data processing on our behalf pursuant to Art. 28 of the GDPR. Under these agreements, the subcontractors are obliged to protect our customers’ data and not pass it on to third parties.

### Amazon Web Services

* Purpose of processing: Providing infrastructure and technical services as well as storing, processing and transmitting data of various types.
* Categories of personal data: Inventory data, content data, traffic data
* Data subjects: Personizer users
* Legal basis: Execution of contract, Art. 6 (1) S. 1 (b) of the GDPR
* Provider: Amazon Web Services Germany GmbH, Krausenstr. 38, 10117 Berlin, Germany
* Privacy statement: https://aws.amazon.com/privacy/

### Stripe

* Purpose of processing: Payment processing
* Categories of personal data: Inventory data, payment data, contract data
* Data subjects: Personizer users
* Legal basis: Execution of contract, Art. 6 (1) S. 1 (b) of the GDPR
* Provider: Stripe Inc., 510 Townsend Street, San Francisco, CA 94103, USA
* Privacy statement: https://stripe.com/privacy

### Taxamo

* Purpose of processing: Processing of VAT regulations and billing
* Categories of personal data: Inventory data, payment data, contract data
* Data subjects: Personizer users
* Legal basis: Execution of contract, Art. 6 (1) (b) of the GDPR
* Provider: EVAT Solutions Ltd, trading as Taxamo, 1, Library Place, Iveragh Rd, Castleconway, Killorglin, Co. Kerry, Ireland
* Privacy statement: https://www.taxamo.com/privacy-policy/

### Google Analytics

* Purpose of processing: Statistical evaluation of the website of Personizer GmbH & Co. KG. The data is processed completely anonymously.
* Categories of personal data: Usage data
* Data subjects: Personizer users, individuals who are interested in our services or visitors of the Personizer website.
* Legal basis: Legitimate interest, Art. 6 (1) (f) of the GDPR
* Provider: Google LLC, 1600, Amphitheatre Parkway, Mountain View, CA 94043, USA
* Privacy statement: https://tools.google.com/dlpage/gaoptout?hl=en/

### Google Tag Manager

* Purpose of processing: Tag manager that triggers other tags that may collect data.
* Categories of personal data: none
* Data subjects: Personizer users, individuals who are interested in our services or visitors of the website
* Legal basis: Legitimate interest, Art. 6 (1) (f) of the GDPR
* Provider: Google LLC, 1600, Amphitheatre Parkway, Mountain View, CA 94043, USA
* Privacy statement: https://www.google.com/analytics/tag-manager/use-policy/

### CleverReach

* Purpose of processing: Sending the newsletter, notifications.
* Categories of personal data: Inventory data, e-mail address
* Data subjects: Personizer users, individuals who are interested in our services or visitors of our website
* Legal basis: Consent, Art. 6 (1) S. 1 (a) of the GDPR, Legitimate interest, Art. 6 (1) (f) of the GDPR
* Provider: CleverReach GmbH & Co. KG, Mühlenstr. 43, 26180 Rastede, Germany
* Privacy statement: https://www.cleverreach.com/en/privacy-policy/

### Mailgun

* Purpose of processing: Sending order confirmations, contract renewal notifications, billing information as well as notifications and newsletters
* Categories of personal data: Inventory data, contract data
* Data subjects: Personizer users, individuals who are interested in our services or visitors of our website
* Legal basis: Execution of contract, Art. 6 (1) S. 1 (b) of the GDPR
* Provider: Mailgun Technologies, Inc., 548 Market St. #43099, San Francisco, CA 94104, USA
Privacy statement: https://www.mailgun.com/privacy-policy

### Zendesk

* Purpose of processing: Providing customer support systems
* Categories of personal data: Content data, inventory data, usage data
* Data subjects: Personizer users, individuals who are interested in our services or visitors of the Personizer website
* Legal basis: Execution of contract, Art. 6 (1) S. 1 (b) of the GDPR / Legitimate interest, Art. 6 (1) (f) of the GDPR.
* Provider: Zendesk, Inc. Attn: Privacy Officer, 1019 Market Street, San Francisco, CA 94103, USA
* Privacy statement: https://www.zendesk.com/company/customers-partners/privacy-policy/

### YouTube

* Purpose of processing: YouTube embedding function to display and play videos provided by YouTube
* Categories of personal data: Inventory data
* Data subjects: Personizer users, individuals who are interested in our services or visitors of the Personizer website
* Legal basis: Legitimate interest according to Art. 6 (1) S. 1 (f) of the GDPR
* Provider: Google LLC, 1600 Amphitheatre Parkway, Mountain View, CA 94043, USA
* Privacy statement: https://policies.google.com/privacy

### SurveyMonkey

* Purpose of processing: We use SurveyMonkey’s services for carrying out surveys.
* Categories of personal data: Inventory data
* Data subjects: Personizer users, individuals who are interested in our services, newsletter subscribers
* Legal basis: Consent, Art. 6 (1) S. 1 (b) of the GDPR / Legitimate interest, Art. 6 (1) (f) of the GDPR
* Provider: SurveyMonkey Europe UC, 2nd Floor, 2 Shelbourne Buildings, Shelbourne Road, Dublin, Ireland
* Privacy statement: https://www.surveymonkey.com/mp/legal/privacy-policy/

Last revised: April 2019