# Setting up macOS for Android builds

## 1. Install Homebrew, Java, Python, and CMake

1. Install Homebrew:

		/usr/bin/ruby -e "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/master/install)"

2. Install Java 8:

		brew tap caskroom/versions
		brew cask install homebrew/cask-versions/adoptopenjdk8

4. Install Python and CMake:

		brew install python3 cmake ninja

## 2. Install Android Studio

### 2.1 Download Android Studio

1. Go to https://developer.android.com/studio.
1. Click “Download Android Studio".
1. Agree to the Terms and Conditions.

### 2.2 Complete the Installation

1. Once the download is completed, open the DMG.
1. Drag Android Studio.app and drop it on the Applications folder icon.
1. Open Android Studio using Finder or Spotlight.
1. Follow the steps in the setup wizard.
3. Stay on the "Welcome to Android" screen and complete the steps below to complete the installation.

!!! note
	It's sufficient to select the default setup type in the Android Studio Setup wizard. When asked, grant permission to the Intel HAXM installer to enable Android device emulation.

	If Intel's HAXM installation fails, please download the latest release from [https://github.com/intel/haxm/releases](https://github.com/intel/haxm/releases) and install it manually.



### 2.3 Install Android NDK

1. On the “Welcome to Android” screen, click “Configure” and select “SDK Manager".
1. Click on the “SDK Tools” tab.
1. Select “NDK” from the list and click OK.
1. A prompt appears asking you to confirm the change. Do so by clicking OK.
1. Accept the NDK license agreement.
1. The NDK component is being installed, grab another drink.
1. After the installation has finished, click Finish. The installation is now complete.

!!! note
	In order to run `boden`, the `studio` command-line tool must be installed. Please follow the instructions shown when calling `boden` for the first time after Android Studio has been installed: Open Android Studio, open a project, and then select Tools => Create Command-Line Launcher.

## Didn't work?

Please [let us know](../../../feedback). We're happy to help!

