# Your First Boden Application

To create your first Boden app, open up a terminal (or command prompt), change to your local `boden` directory, and execute the following commands:

	python boden.py new -n AwesomeApp
	cd AwesomeApp
	python ../boden.py open

This will create a new folder named `AwesomeApp` and generate source and project files for a simple Hello World cross-platform application. The last command will prepare and open an Xcode project on the Mac or an Android Studio project on Linux/Windows.

In Xcode, select the `AwesomeApp` target and then press <kbd>Cmd</kbd>+<kbd>R</kbd> to build and run the Hello World application.

In Android Studio, wait for Gradle to finish its sync and configuration processes and then select the `bodendemo` target and press <kbd>Cmd</kbd>+<kbd>R</kbd> to build and run the example application, then select the `AwesomeApp` target and then press <kbd>Ctrl</kbd>+<kbd>R</kbd> on Mac or <kbd>Shift</kbd>+<kbd>F10</kbd> on Linux/Windows to build an run the Hello World application.

!!! note
    On macOS and Linux you can also simply type `./boden` instead of calling `python boden.py` explicitly. If you want to build the Android version of the app on macOS, run `../boden open -p android`.

## Hello World

Here's a quick look at the source code generated by the `boden new` command:

```C++
// MainViewController.cpp
#include <bdn/ui.h>
#include <bdn/ui/yoga.h>

#include "MainViewController.h"

using namespace bdn;
using namespace bdn::ui;

MainViewController::MainViewController()
{
    _window = std::make_shared<Window>();
    _window->title = "AwesomeApp";
    _window->geometry = Rect{0, 0, 400, 300};
    _window->setLayout(std::make_shared<yoga::Layout>());

    auto button = std::make_shared<Button>();
    button->label = "Hello World";

    _window->contentView = button;

    _window->visible = true;
}
```

`MainViewController.cpp` is the most interesting part of the source generated for the Hello World application. The main view controller will be instantiated at application launch. It's responsible for setting up the application's user interface.

Here's what the code does in detail:

First, create a new `Window` and set its title to `AwesomeApp`:

```C++
_window = std::make_shared<Window>();
_window->title = "AwesomeApp";
```

To get an automatic layout, use a `yogalayout::Layout` and set a default window size:

```C++
_window->geometry = Rect{0, 0, 400, 300};
_window->setLayout(std::make_shared<yoga::Layout>());
```

Then, instantiate a new `Button` and set its label to "Hello World":

```C++
auto button = std::make_shared<Button>();
button->label = "Hello World";
```

As the button is the only control which will be displayed in this example, set it as the window's content view:

```C++
_window->contentView = button;
```

Finally, make the window visible:

```C++
_window->visible = true;
```

## TodoMVC Tutorial

Want to learn more? Check out our [TodoMVC Tutorial on Medium](https://medium.com/ashampoo-systems/getting-started-with-c-17-mobile-cross-platform-development-using-boden-b47cb0f9a9a1)!

## Found a Problem?

Please let us know. We're happy about your [feedback](../../feedback).