# Contributing

🎉 Thank you for taking the time to contribute to the Boden Framework! 🎉

## How can I Contribute?

There are many ways you can contribute to Boden. Here are some of them:

* Reporting Bugs
* Request an Enhancement
* Making your First Code Contribution
* Creating a Pull Request

## Reporting Bugs

Finding and reporting bugs in the Boden framework is an important contribution and we highly appreciate that you take the time to submit a meaningful bug report.

Here's how it works:

* **[Create a GitHub issue](https://github.com/AshampooSystems/boden/issues/new) to report a new bug.**
* **Provide a clear and descriptive title that identifies the problem.**
* **Let us know which version of Boden you used when you found the issue.** If you've downloaded a release, please specify the release version, e.g. "v0.3". If you've cloned the boden git repository, please provide your current HEAD commit hash. (You can retrieve the current HEAD commit hash by executing `git rev-parse HEAD` in your local working tree.)
* **Specify on which host and target operating system the problem occurred.** Please include the version of the operating system(s) in your bug report. You can help us even more by checking whether the bug also occurs on other host/target platforms.
* **Specify the IDE (Xcode/Android Studio) you used when you found the problem**.
* **Describe the exact steps that cause the problem.** This allows us and others to reproduce the issue.
* **Describe the behavior you observed after following the steps** and point out what exactly is the problem with that behavior.
* **Describe what behavior you expected to occur instead and why.**
* **If you are reporting a crash, please include a full stack trace.**

## Request an Enhancement

Have you been looking for a certain feature in Boden and didn't find it in the framework yet? Did you use a Boden feature that works, but could be enhanced?

In this case, please consider suggesting an enhancement. Feature and improvement requests help us a lot. They are one of the most important ways to help us determine whether we are on the right track with the framework. Even if you have only limited time, write us a line or two about what you think could be done to improve Boden.

Here's how you can submit an enhancement request:

* **[Create a GitHub issue](https://github.com/AshampooSystems/boden/issues/new)** for each enhancement suggestion.
* **Use a clear and descriptive title that identifes the suggestion**.
* **Explain why the enhancement would be useful** to most Boden users.
* **Describe the current behavior and explain which behavior you expected to see and why**.

## Making your First Code Contribution

You want to develop an enhancement or fix a bug on your own? Great! Thank you for contributing to the Boden Framework.

Here are some resources to get you started:

* **Setting up a local build environment** which you can use to work on Boden itself should be easy. Just follow the instructions on our [Getting Started](https://www.boden.io/getting-started/) page.
* **We are currently working on a code style guide**. Meanwhile, we may edit your PR to maintain consistency with the rest of the code.

## Creating a Pull Request

**Important**: Note that any code you submit to us is subject to our [Contribution License Agreement](CLA.md).

Here's how to create a pull request:

* Fork the `boden` repository.
* Make your changes and commit them to the forked repository.
* Create a pull request with base `AshampooSystems/boden` `master` (this should be the default).
* Please leave us a message describing what the PR is about.
* We'll review your PR as soon as possible and get back to you if needed.

🎉 Thanks for your contribution to Boden! 🎉
