/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Map;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.ServletRedirectResult;
import org.apache.struts2.interceptor.MessageStoreInterceptor;

class MessageStorePreResultListener
implements PreResultListener {
    private static final Logger LOG = LoggerFactory.getLogger(MessageStorePreResultListener.class);
    private MessageStoreInterceptor interceptor;

    public MessageStorePreResultListener(MessageStoreInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void beforeResult(ActionInvocation invocation, String resultCode) {
        boolean isInvalidated;
        boolean isCommitted = ServletActionContext.getResponse().isCommitted();
        if (isCommitted) {
            LOG.trace("Response was already committed, cannot store messages!", new String[0]);
            return;
        }
        boolean bl = isInvalidated = ServletActionContext.getRequest().getSession(false) == null;
        if (isInvalidated) {
            LOG.trace("Session was invalidated or never created, cannot store messages!", new String[0]);
            return;
        }
        Map session = invocation.getInvocationContext().getSession();
        if (session == null) {
            LOG.trace("Could not store action [#0] error/messages into session, because session hasn't been opened yet.", new Object[]{invocation.getAction()});
            return;
        }
        String reqOperationMode = this.interceptor.getRequestOperationMode(invocation);
        boolean isRedirect = false;
        try {
            ResultConfig resultConfig = (ResultConfig)invocation.getProxy().getConfig().getResults().get(resultCode);
            if (resultConfig != null) {
                isRedirect = ServletRedirectResult.class.isAssignableFrom(Class.forName(resultConfig.getClassName()));
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot read result!", (Throwable)e, new String[0]);
        }
        if ("STORE".equalsIgnoreCase(reqOperationMode) || "STORE".equalsIgnoreCase(this.interceptor.getOperationModel()) || "AUTOMATIC".equalsIgnoreCase(this.interceptor.getOperationModel()) && isRedirect) {
            Object action = invocation.getAction();
            if (action instanceof ValidationAware) {
                LOG.debug("Storing action [#0] error/messages into session ", new Object[]{action});
                ValidationAware validationAwareAction = (ValidationAware)action;
                session.put("__MessageStoreInterceptor_ActionErrors_SessionKey", validationAwareAction.getActionErrors());
                session.put("__MessageStoreInterceptor_ActionMessages_SessionKey", validationAwareAction.getActionMessages());
                session.put("__MessageStoreInterceptor_FieldErrors_SessionKey", validationAwareAction.getFieldErrors());
            } else {
                LOG.debug("Action [#0] is not ValidationAware, no message / error that are storeable", new Object[]{action});
            }
        }
    }
}

