import 'package:firebase_core/firebase_core.dart';
import 'package:flutter/material.dart';
import 'package:get/get_navigation/get_navigation.dart';
import 'package:plasmacovid_app/Service/ManageData.dart';
import 'package:plasmacovid_app/Service/Notifications.dart';
import 'package:plasmacovid_app/controllers/Userpreferances.dart';
import 'package:plasmacovid_app/views/SplashScreen.dart';
import 'package:provider/provider.dart';

void main() async {
  WidgetsFlutterBinding.ensureInitialized();
  await Firebase.initializeApp();
  await Userpreferances.init();
  runApp(MyApp());
}

class MyApp extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return MultiProvider(
      providers: [
        ChangeNotifierProvider.value(value: ManageData()),
        ChangeNotifierProvider(create: (_) => NotificationService())
      ],
      child: GetMaterialApp(
        debugShowCheckedModeBanner: false,
        home: SplashScreen(),
      ),
    );
  }
}
