# Contributing
Before I get started, thank you for contributing! :)

## Issues
For any typos, errors, or new feature suggestions feel free to open a new issue.

## Pull Requests
I'm not very picky about how you should contribute, but I ask that the following are met:
* Proper spelling and grammar.
* If it's a language or library feature that you can write code with, please provide an
example of its usage. An optimal submission would also include a short real-world use case for the feature.
* Keep additions/deletions of content consistent with the cheatsheet's goals (see below).

#### Instructions
* Make sure the feature is in the correct C++ version file (i.e. CPP11.md, etc.).
* Make sure you've added the feature to the table of contents.

## Goals
My goal for this cheatsheet is to prefer conciseness over absolute completeness. Examples of features should be minimal: if an example is overly complicated, large, or is more of an obscure usage of the feature then it will most likely be rejected in review. The reason for this goal is to teach users what the most popular uses of these features will be, and for a more thorough investigation, to learn about those from external C++ resources.
