# CONTRIBUTING

## Code Practices

Please help us follow the best practice to make it easy for the reviewer as well as the contributor. We want to focus on the code quality more than on managing pull request ethics.

- [People before code](http://hintjens.com/blog:95): If any of the following rules are violated, the pull-requests must not be rejected. This is to create an easy and joyful onboarding process for new programmers and first-time contributors.

- Commit messages should be meaningful, example: `Add <-issue-name-and-number->`.

-  Make commit messaged like a command not in past tense. For example `Add feature` not `Adding feature or Added feature`.

- Reference the issue numbers in the commit message or in the comments of the Pull Request, if it resolves an open issue. Example: `Fix #<issue number> <commit  message>`.

- Provide the link in the comment section of your pull request from your forked repository or relevant screenshots of the changes for easier review.

- Pull Request older than 4 days with no response from the contributor shall be marked closed.

- Avoid duplicate PRs, if need be comment on the older PR with the PR number of the follow-up (new PR) and close the obsolete PR yourself.

- If you are interested in solving an issue, comment on the issue so that it is assigned to you. If no response is there for more than 7 days, maintainers will mark the issue unassigned.

- Make sure you read docs once, Answers to most of your questions is already there. 

- In case of suggestions for new features or bugs make an issue. Make sure you give a proper title, description and relevant links.

Also, we have a team of maintainers to whom you can send a message to if your pull-request goes unnoticed. They may have time.
If you need any help solving an issue feel free to reach out to us.
