import React from 'react';

const TermsAndConditions = () => {
  return (
    <section className="py-16 bg-gray-900 text-white">
      <div className="container mx-auto px-6">
        <h2 className="text-3xl sm:text-4xl font-bold mb-6 text-center">
          Terms and Conditions
        </h2>

        <div className="prose max-w-full text-gray-300">
          <p>
            Welcome to Vintage Book Market, developed by Anil Kumar Nayak! By accessing or using our website, you agree to comply with and be bound by the following terms and conditions. If you do not agree with these terms, please refrain from using the site.
          </p>

          <h3 className="text-2xl font-semibold mt-6">1. Acceptance of Terms</h3>
          <p>
            By accessing and using Vintage Book Market, you agree to these terms of service, which may be updated periodically. We encourage you to review these terms regularly. Anil Kumar Nayak reserves the right to modify or update these terms at any time.
          </p>

          <h3 className="text-2xl font-semibold mt-6">2. User Responsibilities</h3>
          <p>
            As a user, you are responsible for ensuring that all content you upload to Vintage Book Market complies with applicable laws. You must not upload any illegal or offensive content, and you must not engage in any actions that would disrupt the functionality of the website.
          </p>

          <h3 className="text-2xl font-semibold mt-6">3. Intellectual Property</h3>
          <p>
            All content on Vintage Book Market, including but not limited to text, graphics, logos, images, and videos, is owned by or licensed to Anil Kumar Nayak. Unauthorized use, copying, or distribution of any content without proper permission is strictly prohibited.
          </p>

          <h3 className="text-2xl font-semibold mt-6">4. Termination of Service</h3>
          <p>
            Anil Kumar Nayak reserves the right to terminate or suspend your access to the website if you violate these terms, engage in unlawful activities, or disrupt the website's operations in any way.
          </p>

          <h3 className="text-2xl font-semibold mt-6">5. Limitation of Liability</h3>
          <p>
            Vintage Book Market, as developed by Anil Kumar Nayak, is not liable for any loss, damage, or inconvenience that may occur while using the platform. This includes, but is not limited to, loss of data, financial loss, or damage to reputation.
          </p>

          <h3 className="text-2xl font-semibold mt-6">6. Governing Law</h3>
          <p>
            These terms and conditions are governed by the laws of India (or your country of operation). Any disputes that arise will be subject to the jurisdiction of the courts in the location where Vintage Book Market is operated.
          </p>

          <h3 className="text-2xl font-semibold mt-6">7. Contact Information</h3>
          <p>
            If you have any questions or concerns regarding these terms and conditions, please contact the developer, Anil Kumar Nayak, at <strong>support@vintagebookmarket.com</strong>.
          </p>
        </div>
      </div>
    </section>
  );
};

export default TermsAndConditions;
