# Vintage Book Market

## Overview
**Vintage Book Market** is a web application where users can **buy and sell vintage books**, along with browsing and reviewing them. This application combines a marketplace platform with an eCommerce API for smooth transactions and a blogging feature for book enthusiasts. 

The project is developed using:
- **Django** and **Django Rest Framework (DRF)** for the backend
- **React** with **Redux** for state management on the frontend
- **Tailwind CSS** for responsive and modern styling

---

## Project Status
**Completed**

This project has been successfully developed with all planned features implemented. It includes both eCommerce and blog functionalities for a comprehensive user experience.

---

## Features
### Marketplace Features:
- **Buy and Sell Books**:
  - Users can list books for sale with detailed information such as title, author, price, condition, and images.
  - Browse books listed by other users and purchase them securely.
- **Shopping Cart & WishList**:
  - Add multiple books to a shopping cart & in WishList.
  - Review your cart and proceed to checkout for payment.
- **Search and Filtering**:
  - Advanced filtering options by genre, author, condition, and price range.
  - Search bar for quick discovery of books.

### User Account Management:
- **Profile Management**:
  - Users can securely sign up, log in, and log out.
  - Edit their profile details such as name, email, and profile picture.
- **Manage Listed Books**:
  - View, edit, or remove books listed for sale by the user.

### User Reviews:
- Leave reviews and rate books after purchase.
- View aggregate ratings and feedback for all books.

### Blogging Platform:
- Write and publish blogs related to books, authors, and literary genres.
- Comment on and like blogs written by other users.

### Responsive Design:
- Fully optimized for mobile, tablet, and desktop devices.

---

## Technologies Used
- **Backend**: Django, Django Rest Framework (DRF)
- **Frontend**: React, Redux, Tailwind CSS
- **Database**: SQLite3 (easily scalable to PostgreSQL for production)
- **API**: REST API for seamless communication between the backend and frontend

---

## Installation Instructions

### Prerequisites:
- **Python 3.x**
- **Node.js** and npm (or yarn)
- **Virtual environment tools** (like `venv` or `virtualenv`)

---

### Backend Setup (Django + DRF):
1. Clone the repository:
   ```bash
   git clone https://github.com/your-username/vintage-book-market.git
   cd vintage-book-market/backend
