import {BigDecimal} from '@angular-ru/cdk/big-decimal';

describe('[TEST]: BigDecimal - divide', () => {
    it('should be defined', () => {
        expect(BigDecimal.divide).toBeDefined();
    });

    it('test failing scenario', () => {
        expect(BigDecimal.divide('509365950.27576', '0.003802940215600348', 16)).toBe(
            '133940036234.6609666927392804',
        );
    });

    it('should do basic integer division', () => {
        expect(BigDecimal.divide(1234, 12, 2)).toBe('102.83');
    });

    it('should do basic floating point division - 1', () => {
        expect(BigDecimal.divide(12.34, 12, 2)).toBe('1.03');
    });

    it('should do basic floating point division - 2', () => {
        // eslint-disable-next-line @typescript-eslint/no-loss-of-precision
        expect(
            BigDecimal.divide(29629629362962961839.48344234, 12345678901234567890, 2),
        ).toBe('2.40');
    });

    it('should do basic floating point division - 3', () => {
        expect(
            BigDecimal.divide(
                '296296293629629614563475463462345345235412412341235436563456829629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683939296296293629629614563475463462345345235412412341235436563456829629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683939.48344234',
                '1000',
                10,
            ),
        ).toBe(
            '296296293629629614563475463462345345235412412341235436563456829629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683939296296293629629614563475463462345345235412412341235436563456829629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683929629629362962961456347546346234534523541241234123543656345683.9394834423',
        );
    });

    it('should do basic floating point division - 4', () => {
        expect(BigDecimal.divide(45, -4, 2)).toBe('-11.25');
    });

    it('should do basic floating point division', () => {
        expect(BigDecimal.divide(-45, -4, 2)).toBe('11.25');
    });

    it('1 / 25 = 0.04', () => {
        expect(BigDecimal.divide('1', '25', 2)).toBe('0.04');
    });

    it('-1 / 25 = -0.04', () => {
        expect(BigDecimal.divide('-1', '25', 2)).toBe('-0.04');
    });

    it('1 / -25 = -0.04', () => {
        expect(BigDecimal.divide('1', '-25', 2)).toBe('-0.04');
    });

    it('-1 / -25 = 0.04', () => {
        expect(BigDecimal.divide('-1', '-25', 2)).toBe('0.04');
    });

    it('-1 / -1 = 1', () => {
        expect(BigDecimal.divide('-1', '-1', 0)).toBe('1');
    });

    it('10.8 / 10 = 1.08', () => {
        expect(BigDecimal.divide('10.8', '10')).toBe('1.08000000');
    });

    it('10.8 / 100 = 0.108', () => {
        expect(BigDecimal.divide('10.8', '100')).toBe('0.10800000');
    });

    it('10.8 / 1000 = 0.0108', () => {
        expect(BigDecimal.divide('10.8', '1000')).toBe('0.01080000');
    });

    it('10.8 / 10000 = 0.00108', () => {
        expect(BigDecimal.divide('10.8', '10000')).toBe('0.00108000');
    });

    it('2.00 / 0.5 = 4.00', () => {
        expect(BigDecimal.divide('2.00', '0.5', 2)).toBe('4.00');
    });

    it('0.11005 / 0.1 = 1.1005', () => {
        expect(BigDecimal.divide('0.11005', '0.1', 4)).toBe('1.1005');
    });

    it('123456789.123456 / .0123456 = 10000063919.40902022', () => {
        expect(BigDecimal.divide('123456789.123456', '.0123456')).toBe(
            '10000063919.40902022',
        );
    });

    it('.102 / .0383292 = 2.66115651', () => {
        expect(BigDecimal.divide('.102', '.0383292', 8)).toBe('2.66115651');
    });
});
