﻿using AlphaCinemaData.Models;
using Microsoft.AspNetCore.Identity;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;

namespace AlphaCinemaData.Configurations
{
	public class UserConfiguration : IEntityTypeConfiguration<User>
	{
		public void Configure(EntityTypeBuilder<User> builder)
		{
			builder
				.HasKey(u => u.Id);

			builder
				.Property(u => u.Email)
				.HasMaxLength(50);

			builder
				.HasIndex(u => u.Email)
				.IsUnique(true);

			builder
				.Property(u => u.FirstName)
				.HasMaxLength(50);

			builder
				.Property(u => u.LastName)
				.HasMaxLength(50);

			builder
				.Property(u => u.Age);
		}
	}
}
