<div align="center">
 
 <img src=https://github.com/AlsoAStranger/YT-Section-Downloader/assets/137929175/4dd47c12-3521-4334-80e2-82bfd7c1d3c7 width="250" height="250">
</img>
 
# Youtube Section Downloader
</div>

Youtube Section Downloader is a small utility that provides a Graphical User Interface (GUI) to [yt-dlp](https://github.com/yt-dlp/yt-dlp) to help the user download specific portions of YouTube videos using timestamps.

All the user needs to do is provide the program with the link to the YouTube video, the beginning and ending timestamps of the desired clip, and a file name.

Lastly, users have the option to download just the audio of the clip instead of both audio and video.

<sub>*Note: The video will be downloaded at the highest possible quality in MP4 format. This means that if a YouTube video can be viewed in 4K, it will be downloaded in 4K. If the highest quality is 1080p, it will be downloaded in 1080p. The audio clip will be saved in MP3 format at its highest quality. The timestamps are accepted in the following formats: HH:MM:SS or MM:SS.*</sub>

## Source code
I've uploaded the Form and Form.Designer files, which you can find in the dedicated folder.
I decided to not upload the rest of the project files as those are automatically generated by Visual Studio when making a new project, rendering them unimportant compared to the actual code and UI elements.

[**Get the code here**](https://github.com/AlsoAStranger/YT-Section-Downloader/blob/main/VS%20Source%20Code%20and%20Form%20Designer/Form.vb)

Alternatively, you can download the [python edition](https://github.com/AlsoAStranger/YT-Section-Downloader/tree/python-edition)!  
[**Download it here**](https://github.com/AlsoAStranger/YT-Section-Downloader/releases/latest/download/Youtube.Section.Downloader.exe)

## Issues

#### **Issue #1: False Positive**
Due to inexperience in software development, the .EXE file of this utility is sometimes flagged as a false positive by antivirus software. Therefore, the .EXE file will not be released to the public. However, the source code is available for those interested in fixing, improving, repackaging and/or releasing the software (and even adding more features).

#### **Issue #2: Beginning/Ending Frames not Rendering Correctly**
Sometimes, the saved video may display a still frame for the first few seconds before rendering the frames correctly. This could also happen in the last few seconds, although less likely.

This issue seems to be related to yt-dlp and/or ffmpeg, which take some time to process the video correctly. To ensure that the necessary frames are rendered correctly, it is highly suggested to consider adding 5-10 seconds more to the desired clip.  
*(For example: instead of downloading a video from 2:00 to 5:00, it may be better to download it from 1:50 to 5:10)*

This means that further video editing is required if the objective is to simply share a clip without unnecessary context  
*(For example, if someone wanted to share a joke, having unrelated parts of the video would ruin the clip)*.

However, this issue should not affect audio-only clips, as the audio is processed correctly from the beginning to the end. It's worth noting that when downloading a clip with video, the original audio will play under the still frames.

##  General Info

#### **Why did you make this utility?**

Yt-dlp is a command-line program.
Though there's GUI versions of both [yt-dlp](https://github.com/yt-dlp/yt-dlp) and [yt-dl](https://github.com/ytdl-org/youtube-dl), I have not seen a simple, easy to use software to clip and download a specific portion of a video using timestamps.

#### **Why should I want to use this utility?**

I found it to be incredibly useful to quickly extract a snippet from long-form videos. Whether they'd be hour long podcasts, Stream VODs, or even to get 30 seconds from a 20 minute video.

Downloading the whole video results in a waste of space and time, and the command-line can get tiring since it requires to write and edit the command each time.

#### **Why Visual Basic? It's so old and there's better languages out there**
You are indeed correct, but Visual Basic is the language I am most familiar with. Not only that, but it's easy to read (I should know, I'm not an expert).  
*Also it was the only language I knew how to make a GUI with. Leave me alone*

If anything this allows more users to read and understand the source code, possibly allowing more people to see how it could be improved and rewritten in better coding languages.

#### **Your code is so unoptimized, it could be easily fixed if-**
Yeah I know, I can't be bothered tho ¯\\\_(ツ)\_/¯  
It works and that's what matters

#### **Can I re-write and publish a better version?**
Sure, go ahead :D  
I'd be glad to know that other people are in need of something like this and that this utility helps speed up the clipping process.

*I would appreciate being credited if this utility gets re-made :p*
## Missing Features

- Possibility to select **video quality manually**
- Possibility to select **video format**
- Possibility to select **audio quality manually**
- Possibility to select **audio format**
- Possibility to set **custom download location** *(the clip will be downloaded in the folder containing the .EXE file)*
- **Progress bar** *(progress can still be viewed in the console window that appears once a download is started)*
- **Thumbnail and Title preview** of the inputted link

## Requirements

 - [**yt-dlp**](https://github.com/yt-dlp/yt-dlp)
 - [**ffmpeg** and **ffprobe**](https://www.ffmpeg.org/)

 ***Important:** The code was made to work with yt-dlp and ffmpeg added to the [**PATH Environment Variable**](https://learn.microsoft.com/en-us/previous-versions/office/developer/sharepoint-2010/ee537574(v=office.14)).*
## Acknowledgements

 - [**3D Youtube Downloader**](https://yd.3dyd.com/home/), which inspired the GUI design.
 - [**ChatGPT**](https://openai.com/blog/chatgpt), which helped me troubleshoot and write the code.
 - [**Magnogen**](https://github.com/Magnogen), who assisted me in a few things. He has some cool stuff, go look.
 - [**Visual Studio**](https://visualstudio.microsoft.com/), because... because that's what I used to make this.

## Preview
![disabled](https://github.com/AlsoAStranger/YT-Section-Downloader/assets/137929175/430149b1-f36d-46b9-91cd-8862e7d0aa07)
![enabled](https://github.com/AlsoAStranger/YT-Section-Downloader/assets/137929175/c3c5826e-af1b-4c48-9237-009a37f99e7b)
