<img width="200" height="200" src="https://github.com/AliDehbansiahkarbon/OpenAPIClientWizard/assets/5601608/9eab0937-90e4-46ae-bce2-29a24c02bd9d" alt=""/> 

# OpenAPIClientWizard(beta- no production ready)

Welcome to **OpenAPIClientWizard** – the ultimate plugin for RAD Studio that revolutionizes the way Delphi developers implement REST API clients.

## Overview

As Delphi developers, we often face the challenge of implementing REST API clients. API documentation rarely includes Delphi code snippets, forcing us to read the documentation and implement each method - GET, POST, PUT, DELETE - manually. Even with Swagger or OpenAPI specifications, it's a time-consuming process. Without these specifications, we resort to tools like Delphi's REST Debugger or Postman, testing each method individually before coding them into our projects.

**OpenAPIClientWizard** changes all that. This powerful plugin reads Swagger, OpenAPI specifications, or Postman collection and generates a fully implemented client-side sample(VCL) project in Delphi, ready to compile, in just 2-3 seconds!

## IDE Version support
- **Supports from Delphi 10.1 Berlin to 12.x Athens**

## Features

- **Supports Swagger Specifications:** Handles JSON format effortlessly.
- **Supports OpenAPI Specifications:** Handles both JSON and YAML formats effortlessly.
- **Postman Collection Conversion:** Converts Postman collections into complete Delphi client projects.
- **Rapid Project Generation:** Generates fully implemented client-side projects in seconds, saving you a huge time(weeks of development).


## Benefits

- **Save Time:** Reduces weeks of work to mere seconds.
- **Increase Productivity:** Focus on building amazing applications instead of spending time on repetitive coding tasks.
- **Simplify Development:** Automate the creation of Delphi client-side projects from API specifications.

## Getting Started

1. **Download and Install:** Follow the installation instructions in the repository.
2. **Run OpenAPIClientWizard:** Open your RAD Studio IDE and run the plugin.
3. **Create a new project** in RAD Studio by following this path: File/New/Other:


![image](https://github.com/AliDehbansiahkarbon/OpenAPIClientWizard/assets/5601608/f0dfeae7-5d1a-49b6-b970-47e25d3b3944)

4. **Setup the project's preferences**


![image](https://github.com/user-attachments/assets/8b8d1c3b-a54b-4378-aaad-802852eb74b0)

   
6. **Generate Your Project:** Provide your Swagger or OpenAPI specification, or Postman collection, and let the plugin do the rest.

![image](https://github.com/AliDehbansiahkarbon/OpenAPIClientWizard/assets/5601608/49ba1e0d-8b4a-4f08-89a8-85db0bcff9bf)



## Remarks
**To download, you must provide the direct URL of the file; redirection is not supported.**
**You cannot use the first URL to download the JSON specification, but the second one is acceptable.**

1- https://github.com/adewg/ICAR/blob/ADE-1/url-schemes/reproductionURLScheme.json ❌

2- https://raw.githubusercontent.com/adewg/ICAR/ADE-1/url-schemes/reproductionURLScheme.json ✅


## Demo Video
**Watch a short video [here](https://youtu.be/7B7nSHIsV64):** to learn how to use the plug-in (or click on the below image👇👇)

<a href="https://youtu.be/7B7nSHIsV64" target="_blank"><img src="https://github.com/AliDehbansiahkarbon/OpenAPIClientWizard/assets/5601608/9015ca43-3d3a-4dfa-8436-1bbba7ac6fdd" width = "300" height = "300" /></a>

## Support

If you find OpenAPIClientWizard useful, please give it a **star**.

Your support is greatly appreciated!

You can also support my work by buying me a coffee. This helps me continue developing this plugin and other tools like [ChatGPTWizard](https://github.com/AliDehbansiahkarbon/ChatGPTWizard) and [EasyDBMigrator](https://github.com/AliDehbansiahkarbon/EasyDBMigrator).

<a href="https://www.buymeacoffee.com/adehbanr" target="_blank"><img src="https://cdn.buymeacoffee.com/buttons/default-orange.png" alt="Buy Me A Coffee" height="41" width="174"></a>

### Ask for direct support or specific implementation

OpenAPIClientWizard is provided as is. If you need any specific implementation contact me via [email](adehban@gmail.com), please.

## Contributing

Contributions are welcome! 
If you have suggestions for improvements or find any issues, please open an issue or submit a pull request.

## License
This project is licensed under the MIT License. 
See the LICENSE file for details.

## Dependencies
This plugin utilizes the Neslib library to parse Yaml format, which is included in the repository for convenience. 

No action is required on your part. 

However, you can find the latest source [here](https://github.com/neslib/Neslib.Json).

---

Transform the way you develop REST API clients in Delphi with **OpenAPIClientWizard**. 

Download it today and streamline your workflow!

<hr>
<p align="center">
<img src="https://i0.wp.com/blogs.embarcadero.com/wp-content/uploads/2022/11/dlogonew-5582740.png?resize=254%2C242&ssl=1" alt="Delphi">
</p>
<h5 align="center">
Made with :heart: on Delphi
</h5>
