/* tslint:disable */
/* eslint-disable */
/**
 * AivisSpeech Engine
 * AivisSpeech の音声合成エンジンです。
 *
 * The version of the OpenAPI document: latest
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { exists, mapValues } from '../runtime';
/**
 * プリセット情報
 * @export
 * @interface Preset
 */
export interface Preset {
    /**
     * 
     * @type {number}
     * @memberof Preset
     */
    id: number;
    /**
     * 
     * @type {string}
     * @memberof Preset
     */
    name: string;
    /**
     * 
     * @type {string}
     * @memberof Preset
     */
    speakerUuid: string;
    /**
     * 
     * @type {number}
     * @memberof Preset
     */
    styleId: number;
    /**
     * 全体の話速を 0.5 ~ 2.0 の範囲で指定する (デフォルト: 1.0) 。
     * 2.0 で 2 倍速、0.5 で 0.5 倍速になる。
     * @type {number}
     * @memberof Preset
     */
    speedScale: number;
    /**
     * 話者スタイルの声色の強弱を 0.0 ~ 2.0 の範囲で指定する (デフォルト: 1.0) 。
     * 値が大きいほどそのスタイルに近い抑揚がついた声になる。
     * 例えば話者スタイルが「うれしい」なら、値が大きいほどより嬉しそうな明るい話し方になる。
     * 一方、話者やスタイルによっては、数値を上げすぎると発声がおかしくなったり、棒読みで不自然な声になる場合もある。
     * ちゃんと発声できる「スタイルの強さ」の上限は話者やスタイルによって異なるため、適宜調整が必要。
     * 全スタイルの平均であるノーマルスタイルには指定できない (値にかかわらず無視される) 。
     * @type {number}
     * @memberof Preset
     */
    intonationScale: number;
    /**
     * 話す速さの緩急の強弱を 0.0 ~ 2.0 の範囲で指定する (デフォルト: 1.0) 。
     * 値が大きいほどより早口で生っぽい抑揚がついた声になる。
     * VOICEVOX ENGINE との互換性のため、未指定時はデフォルト値が適用される。
     * @type {number}
     * @memberof Preset
     */
    tempoDynamicsScale?: number;
    /**
     * 全体の音高を -0.15 ~ 0.15 の範囲で指定する (デフォルト: 0.0) 。
     * 値が大きいほど高い声になる。
     * VOICEVOX ENGINE と異なり、この値を 0.0 から変更すると音質が劣化するため注意が必要。
     * @type {number}
     * @memberof Preset
     */
    pitchScale: number;
    /**
     * 全体の音量を 0.0 ~ 2.0 の範囲で指定する (デフォルト: 1.0) 。
     * 値が大きいほど大きな声になる。
     * @type {number}
     * @memberof Preset
     */
    volumeScale: number;
    /**
     * 
     * @type {number}
     * @memberof Preset
     */
    prePhonemeLength: number;
    /**
     * 
     * @type {number}
     * @memberof Preset
     */
    postPhonemeLength: number;
    /**
     * 句読点などの無音時間。null のときは無視される。デフォルト値は null 。
     * @type {number}
     * @memberof Preset
     */
    pauseLength?: number;
    /**
     * 句読点などの無音時間（倍率）。デフォルト値は 1 。
     * @type {number}
     * @memberof Preset
     */
    pauseLengthScale?: number;
}

/**
 * Check if a given object implements the Preset interface.
 */
export function instanceOfPreset(value: object): boolean {
    let isInstance = true;
    isInstance = isInstance && "id" in value;
    isInstance = isInstance && "name" in value;
    isInstance = isInstance && "speakerUuid" in value;
    isInstance = isInstance && "styleId" in value;
    isInstance = isInstance && "speedScale" in value;
    isInstance = isInstance && "intonationScale" in value;
    isInstance = isInstance && "pitchScale" in value;
    isInstance = isInstance && "volumeScale" in value;
    isInstance = isInstance && "prePhonemeLength" in value;
    isInstance = isInstance && "postPhonemeLength" in value;

    return isInstance;
}

export function PresetFromJSON(json: any): Preset {
    return PresetFromJSONTyped(json, false);
}

export function PresetFromJSONTyped(json: any, ignoreDiscriminator: boolean): Preset {
    if ((json === undefined) || (json === null)) {
        return json;
    }
    return {
        
        'id': json['id'],
        'name': json['name'],
        'speakerUuid': json['speaker_uuid'],
        'styleId': json['style_id'],
        'speedScale': json['speedScale'],
        'intonationScale': json['intonationScale'],
        'tempoDynamicsScale': !exists(json, 'tempoDynamicsScale') ? undefined : json['tempoDynamicsScale'],
        'pitchScale': json['pitchScale'],
        'volumeScale': json['volumeScale'],
        'prePhonemeLength': json['prePhonemeLength'],
        'postPhonemeLength': json['postPhonemeLength'],
        'pauseLength': !exists(json, 'pauseLength') ? undefined : json['pauseLength'],
        'pauseLengthScale': !exists(json, 'pauseLengthScale') ? undefined : json['pauseLengthScale'],
    };
}

export function PresetToJSON(value?: Preset | null): any {
    if (value === undefined) {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    return {
        
        'id': value.id,
        'name': value.name,
        'speaker_uuid': value.speakerUuid,
        'style_id': value.styleId,
        'speedScale': value.speedScale,
        'intonationScale': value.intonationScale,
        'tempoDynamicsScale': value.tempoDynamicsScale,
        'pitchScale': value.pitchScale,
        'volumeScale': value.volumeScale,
        'prePhonemeLength': value.prePhonemeLength,
        'postPhonemeLength': value.postPhonemeLength,
        'pauseLength': value.pauseLength,
        'pauseLengthScale': value.pauseLengthScale,
    };
}

