/* tslint:disable */
/* eslint-disable */
/**
 * AivisSpeech Engine
 * AivisSpeech の音声合成エンジンです。
 *
 * The version of the OpenAPI document: latest
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { exists, mapValues } from '../runtime';
import type { AccentPhrase } from './AccentPhrase';
import {
    AccentPhraseFromJSON,
    AccentPhraseFromJSONTyped,
    AccentPhraseToJSON,
} from './AccentPhrase';

/**
 * 音声合成用のクエリ
 * @export
 * @interface AudioQuery
 */
export interface AudioQuery {
    /**
     * 
     * @type {Array<AccentPhrase>}
     * @memberof AudioQuery
     */
    accentPhrases: Array<AccentPhrase>;
    /**
     * 全体の話速を 0.5 ~ 2.0 の範囲で指定する (デフォルト: 1.0) 。
     * 2.0 で 2 倍速、0.5 で 0.5 倍速になる。
     * @type {number}
     * @memberof AudioQuery
     */
    speedScale: number;
    /**
     * 話者スタイルの声色の強弱を 0.0 ~ 2.0 の範囲で指定する (デフォルト: 1.0) 。
     * 値が大きいほどそのスタイルに近い抑揚がついた声になる。
     * 例えば話者スタイルが「うれしい」なら、値が大きいほどより嬉しそうな明るい話し方になる。
     * 一方、話者やスタイルによっては、数値を上げすぎると発声がおかしくなったり、棒読みで不自然な声になる場合もある。
     * ちゃんと発声できる「スタイルの強さ」の上限は話者やスタイルによって異なるため、適宜調整が必要。
     * 全スタイルの平均であるノーマルスタイルには指定できない (値にかかわらず無視される) 。
     * @type {number}
     * @memberof AudioQuery
     */
    intonationScale: number;
    /**
     * 話す速さの緩急の強弱を 0.0 ~ 2.0 の範囲で指定する (デフォルト: 1.0) 。
     * 値が大きいほどより早口で生っぽい抑揚がついた声になる。
     * VOICEVOX ENGINE との互換性のため、未指定時はデフォルト値が適用される。
     * @type {number}
     * @memberof AudioQuery
     */
    tempoDynamicsScale?: number;
    /**
     * 全体の音高を -0.15 ~ 0.15 の範囲で指定する (デフォルト: 0.0) 。
     * 値が大きいほど高い声になる。
     * VOICEVOX ENGINE と異なり、この値を 0.0 から変更すると音質が劣化するため注意が必要。
     * @type {number}
     * @memberof AudioQuery
     */
    pitchScale: number;
    /**
     * 全体の音量を 0.0 ~ 2.0 の範囲で指定する (デフォルト: 1.0) 。
     * 値が大きいほど大きな声になる。
     * @type {number}
     * @memberof AudioQuery
     */
    volumeScale: number;
    /**
     * 
     * @type {number}
     * @memberof AudioQuery
     */
    prePhonemeLength: number;
    /**
     * 
     * @type {number}
     * @memberof AudioQuery
     */
    postPhonemeLength: number;
    /**
     * 
     * @type {number}
     * @memberof AudioQuery
     */
    pauseLength?: number | null;
    /**
     * 句読点などの無音時間（倍率）。デフォルト値は 1 。
     * @type {number}
     * @memberof AudioQuery
     */
    pauseLengthScale?: number;
    /**
     * 
     * @type {number}
     * @memberof AudioQuery
     */
    outputSamplingRate: number;
    /**
     * 
     * @type {boolean}
     * @memberof AudioQuery
     */
    outputStereo: boolean;
    /**
     * 読み上げるテキストを指定する。
     * VOICEVOX ENGINE では AquesTalk 風記法テキストが入る読み取り専用フィールドだが (音声合成時には無視される) 、AivisSpeech Engine では音声合成時に漢字や記号が含まれた通常の読み上げテキストも必要なため、苦肉の策で読み上げテキスト指定用のフィールドとして転用した。
     * VOICEVOX ENGINE との互換性のため None や空文字列が指定された場合も動作するが、その場合はアクセント句から自動生成されたひらがな文字列が読み上げテキストになるため、不自然なイントネーションになってしまう。
     * 可能な限り kana に通常の読み上げテキストを指定した上で音声合成 API に渡すことを推奨する。
     * @type {string}
     * @memberof AudioQuery
     */
    kana?: string;
}

/**
 * Check if a given object implements the AudioQuery interface.
 */
export function instanceOfAudioQuery(value: object): boolean {
    let isInstance = true;
    isInstance = isInstance && "accentPhrases" in value;
    isInstance = isInstance && "speedScale" in value;
    isInstance = isInstance && "intonationScale" in value;
    isInstance = isInstance && "pitchScale" in value;
    isInstance = isInstance && "volumeScale" in value;
    isInstance = isInstance && "prePhonemeLength" in value;
    isInstance = isInstance && "postPhonemeLength" in value;
    isInstance = isInstance && "outputSamplingRate" in value;
    isInstance = isInstance && "outputStereo" in value;

    return isInstance;
}

export function AudioQueryFromJSON(json: any): AudioQuery {
    return AudioQueryFromJSONTyped(json, false);
}

export function AudioQueryFromJSONTyped(json: any, ignoreDiscriminator: boolean): AudioQuery {
    if ((json === undefined) || (json === null)) {
        return json;
    }
    return {
        
        'accentPhrases': ((json['accent_phrases'] as Array<any>).map(AccentPhraseFromJSON)),
        'speedScale': json['speedScale'],
        'intonationScale': json['intonationScale'],
        'tempoDynamicsScale': !exists(json, 'tempoDynamicsScale') ? undefined : json['tempoDynamicsScale'],
        'pitchScale': json['pitchScale'],
        'volumeScale': json['volumeScale'],
        'prePhonemeLength': json['prePhonemeLength'],
        'postPhonemeLength': json['postPhonemeLength'],
        'pauseLength': !exists(json, 'pauseLength') ? undefined : json['pauseLength'],
        'pauseLengthScale': !exists(json, 'pauseLengthScale') ? undefined : json['pauseLengthScale'],
        'outputSamplingRate': json['outputSamplingRate'],
        'outputStereo': json['outputStereo'],
        'kana': !exists(json, 'kana') ? undefined : json['kana'],
    };
}

export function AudioQueryToJSON(value?: AudioQuery | null): any {
    if (value === undefined) {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    return {
        
        'accent_phrases': ((value.accentPhrases as Array<any>).map(AccentPhraseToJSON)),
        'speedScale': value.speedScale,
        'intonationScale': value.intonationScale,
        'tempoDynamicsScale': value.tempoDynamicsScale,
        'pitchScale': value.pitchScale,
        'volumeScale': value.volumeScale,
        'prePhonemeLength': value.prePhonemeLength,
        'postPhonemeLength': value.postPhonemeLength,
        'pauseLength': value.pauseLength,
        'pauseLengthScale': value.pauseLengthScale,
        'outputSamplingRate': value.outputSamplingRate,
        'outputStereo': value.outputStereo,
        'kana': value.kana,
    };
}

