/* tslint:disable */
/* eslint-disable */
/**
 * AivisSpeech Engine
 * AivisSpeech の音声合成エンジンです。
 *
 * The version of the OpenAPI document: latest
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  AccentPhrase,
  AivmInfo,
  AudioQuery,
  BodySingFrameVolumeSingFrameVolumePost,
  CorsPolicyMode,
  EngineManifest,
  FrameAudioQuery,
  HTTPValidationError,
  MorphableTargetInfo,
  ParseKanaBadRequest,
  Preset,
  Score,
  Speaker,
  SpeakerInfo,
  SupportedDevicesInfo,
  UserDictWord,
  WordTypes,
} from '../models/index';
import {
    AccentPhraseFromJSON,
    AccentPhraseToJSON,
    AivmInfoFromJSON,
    AivmInfoToJSON,
    AudioQueryFromJSON,
    AudioQueryToJSON,
    BodySingFrameVolumeSingFrameVolumePostFromJSON,
    BodySingFrameVolumeSingFrameVolumePostToJSON,
    CorsPolicyModeFromJSON,
    CorsPolicyModeToJSON,
    EngineManifestFromJSON,
    EngineManifestToJSON,
    FrameAudioQueryFromJSON,
    FrameAudioQueryToJSON,
    HTTPValidationErrorFromJSON,
    HTTPValidationErrorToJSON,
    MorphableTargetInfoFromJSON,
    MorphableTargetInfoToJSON,
    ParseKanaBadRequestFromJSON,
    ParseKanaBadRequestToJSON,
    PresetFromJSON,
    PresetToJSON,
    ScoreFromJSON,
    ScoreToJSON,
    SpeakerFromJSON,
    SpeakerToJSON,
    SpeakerInfoFromJSON,
    SpeakerInfoToJSON,
    SupportedDevicesInfoFromJSON,
    SupportedDevicesInfoToJSON,
    UserDictWordFromJSON,
    UserDictWordToJSON,
    WordTypesFromJSON,
    WordTypesToJSON,
} from '../models/index';

export interface AccentPhrasesAccentPhrasesPostRequest {
    text: string;
    speaker: number;
    isKana?: boolean;
    coreVersion?: string;
}

export interface AddPresetAddPresetPostRequest {
    preset: Preset;
}

export interface AddUserDictWordUserDictWordPostRequest {
    surface: string;
    pronunciation: string;
    accentType: number;
    wordType?: WordTypes;
    priority?: number;
}

export interface AudioQueryAudioQueryPostRequest {
    text: string;
    speaker: number;
    coreVersion?: string;
}

export interface AudioQueryFromPresetAudioQueryFromPresetPostRequest {
    text: string;
    presetId: number;
    coreVersion?: string;
}

export interface CancellableSynthesisCancellableSynthesisPostRequest {
    speaker: number;
    audioQuery: AudioQuery;
    coreVersion?: string;
}

export interface ConnectWavesConnectWavesPostRequest {
    requestBody: Array<string>;
}

export interface DeletePresetDeletePresetPostRequest {
    id: number;
}

export interface DeleteUserDictWordUserDictWordWordUuidDeleteRequest {
    wordUuid: string;
}

export interface FrameSynthesisFrameSynthesisPostRequest {
    speaker: number;
    frameAudioQuery: FrameAudioQuery;
    coreVersion?: string;
}

export interface GetAivmInfoAivmModelsAivmUuidGetRequest {
    aivmUuid: string;
}

export interface ImportUserDictWordsImportUserDictPostRequest {
    override: boolean;
    requestBody: { [key: string]: UserDictWord; } | null;
}

export interface InitializeSpeakerInitializeSpeakerPostRequest {
    speaker: number;
    skipReinit?: boolean;
    coreVersion?: string;
}

export interface InstallAivmAivmModelsInstallPostRequest {
    file?: Blob | null;
    url?: string | null;
}

export interface IsInitializedSpeakerIsInitializedSpeakerGetRequest {
    speaker: number;
    coreVersion?: string;
}

export interface LoadAivmAivmModelsAivmUuidLoadPostRequest {
    aivmUuid: string;
}

export interface MoraDataMoraDataPostRequest {
    speaker: number;
    accentPhrase: Array<AccentPhrase>;
    coreVersion?: string;
}

export interface MoraLengthMoraLengthPostRequest {
    speaker: number;
    accentPhrase: Array<AccentPhrase>;
    coreVersion?: string;
}

export interface MoraPitchMoraPitchPostRequest {
    speaker: number;
    accentPhrase: Array<AccentPhrase>;
    coreVersion?: string;
}

export interface MorphableTargetsMorphableTargetsPostRequest {
    requestBody: Array<number>;
    coreVersion?: string;
}

export interface MultiSynthesisMultiSynthesisPostRequest {
    speaker: number;
    audioQuery: Array<AudioQuery>;
    coreVersion?: string;
}

export interface RewriteUserDictWordUserDictWordWordUuidPutRequest {
    wordUuid: string;
    surface: string;
    pronunciation: string;
    accentType: number;
    wordType?: WordTypes;
    priority?: number;
}

export interface SettingPostSettingPostRequest {
    corsPolicyMode: CorsPolicyMode;
    allowOrigin?: string;
}

export interface SingFrameAudioQuerySingFrameAudioQueryPostRequest {
    speaker: number;
    score: Score;
    coreVersion?: string;
}

export interface SingFrameVolumeSingFrameVolumePostRequest {
    speaker: number;
    bodySingFrameVolumeSingFrameVolumePost: BodySingFrameVolumeSingFrameVolumePost;
    coreVersion?: string;
}

export interface SingerInfoSingerInfoGetRequest {
    speakerUuid: string;
    resourceFormat?: SingerInfoSingerInfoGetResourceFormatEnum;
    coreVersion?: string;
}

export interface SingersSingersGetRequest {
    coreVersion?: string;
}

export interface SpeakerInfoSpeakerInfoGetRequest {
    speakerUuid: string;
    resourceFormat?: SpeakerInfoSpeakerInfoGetResourceFormatEnum;
    coreVersion?: string;
}

export interface SpeakersSpeakersGetRequest {
    coreVersion?: string;
}

export interface SupportedDevicesSupportedDevicesGetRequest {
    coreVersion?: string;
}

export interface SynthesisMorphingSynthesisMorphingPostRequest {
    baseSpeaker: number;
    targetSpeaker: number;
    morphRate: number;
    audioQuery: AudioQuery;
    coreVersion?: string;
}

export interface SynthesisSynthesisPostRequest {
    speaker: number;
    audioQuery: AudioQuery;
    enableInterrogativeUpspeak?: boolean;
    coreVersion?: string;
}

export interface UninstallAivmAivmModelsAivmUuidUninstallDeleteRequest {
    aivmUuid: string;
}

export interface UnloadAivmAivmModelsAivmUuidUnloadPostRequest {
    aivmUuid: string;
}

export interface UpdateAivmAivmModelsAivmUuidUpdatePostRequest {
    aivmUuid: string;
}

export interface UpdatePresetUpdatePresetPostRequest {
    preset: Preset;
}

export interface ValidateKanaValidateKanaPostRequest {
    text: string;
}

/**
 * DefaultApi - interface
 * 
 * @export
 * @interface DefaultApiInterface
 */
export interface DefaultApiInterface {
    /**
     * テキストからアクセント句を得ます。 is_kanaが`true`のとき、テキストは次の AquesTalk 風記法で解釈されます。デフォルトは`false`です。 * 全てのカナはカタカナで記述される * アクセント句は`/`または`、`で区切る。`、`で区切った場合に限り無音区間が挿入される。 * カナの手前に`_`を入れるとそのカナは無声化される * アクセント位置を`\'`で指定する。全てのアクセント句にはアクセント位置を1つ指定する必要がある。 * アクセント句末に`？`(全角)を入れることにより疑問文の発音ができる。
     * @summary テキストからアクセント句を得る
     * @param {string} text 
     * @param {number} speaker 
     * @param {boolean} [isKana] 
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    accentPhrasesAccentPhrasesPostRaw(requestParameters: AccentPhrasesAccentPhrasesPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<AccentPhrase>>>;

    /**
     * テキストからアクセント句を得ます。 is_kanaが`true`のとき、テキストは次の AquesTalk 風記法で解釈されます。デフォルトは`false`です。 * 全てのカナはカタカナで記述される * アクセント句は`/`または`、`で区切る。`、`で区切った場合に限り無音区間が挿入される。 * カナの手前に`_`を入れるとそのカナは無声化される * アクセント位置を`\'`で指定する。全てのアクセント句にはアクセント位置を1つ指定する必要がある。 * アクセント句末に`？`(全角)を入れることにより疑問文の発音ができる。
     * テキストからアクセント句を得る
     */
    accentPhrasesAccentPhrasesPost(requestParameters: AccentPhrasesAccentPhrasesPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<AccentPhrase>>;

    /**
     * 新しいプリセットを追加します。
     * @summary 新しいプリセットを追加する
     * @param {Preset} preset 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    addPresetAddPresetPostRaw(requestParameters: AddPresetAddPresetPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<number>>;

    /**
     * 新しいプリセットを追加します。
     * 新しいプリセットを追加する
     */
    addPresetAddPresetPost(requestParameters: AddPresetAddPresetPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<number>;

    /**
     * ユーザー辞書に言葉を追加します。
     * @summary ユーザー辞書に言葉を追加する
     * @param {string} surface 言葉の表層形
     * @param {string} pronunciation 言葉の発音（カタカナ）
     * @param {number} accentType アクセント型（音が下がる場所を指す）
     * @param {WordTypes} [wordType] PROPER_NOUN（固有名詞）、COMMON_NOUN（普通名詞）、VERB（動詞）、ADJECTIVE（形容詞）、SUFFIX（語尾）のいずれか
     * @param {number} [priority] 単語の優先度（0から10までの整数）。数字が大きいほど優先度が高くなる。1から9までの値を指定することを推奨
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    addUserDictWordUserDictWordPostRaw(requestParameters: AddUserDictWordUserDictWordPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<string>>;

    /**
     * ユーザー辞書に言葉を追加します。
     * ユーザー辞書に言葉を追加する
     */
    addUserDictWordUserDictWordPost(requestParameters: AddUserDictWordUserDictWordPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<string>;

    /**
     * 音声合成用のクエリの初期値を得ます。ここで得られたクエリはそのまま音声合成に利用できます。各値の意味は`Schemas`を参照してください。
     * @summary 音声合成用のクエリを作成する
     * @param {string} text 
     * @param {number} speaker 
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    audioQueryAudioQueryPostRaw(requestParameters: AudioQueryAudioQueryPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AudioQuery>>;

    /**
     * 音声合成用のクエリの初期値を得ます。ここで得られたクエリはそのまま音声合成に利用できます。各値の意味は`Schemas`を参照してください。
     * 音声合成用のクエリを作成する
     */
    audioQueryAudioQueryPost(requestParameters: AudioQueryAudioQueryPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AudioQuery>;

    /**
     * 音声合成用のクエリの初期値を得ます。ここで得られたクエリはそのまま音声合成に利用できます。各値の意味は`Schemas`を参照してください。
     * @summary 音声合成用のクエリをプリセットを用いて作成する
     * @param {string} text 
     * @param {number} presetId 
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    audioQueryFromPresetAudioQueryFromPresetPostRaw(requestParameters: AudioQueryFromPresetAudioQueryFromPresetPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AudioQuery>>;

    /**
     * 音声合成用のクエリの初期値を得ます。ここで得られたクエリはそのまま音声合成に利用できます。各値の意味は`Schemas`を参照してください。
     * 音声合成用のクエリをプリセットを用いて作成する
     */
    audioQueryFromPresetAudioQueryFromPresetPost(requestParameters: AudioQueryFromPresetAudioQueryFromPresetPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AudioQuery>;

    /**
     * 
     * @summary AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     * @param {number} speaker 
     * @param {AudioQuery} audioQuery 
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    cancellableSynthesisCancellableSynthesisPostRaw(requestParameters: CancellableSynthesisCancellableSynthesisPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Blob>>;

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    cancellableSynthesisCancellableSynthesisPost(requestParameters: CancellableSynthesisCancellableSynthesisPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Blob>;

    /**
     * Base64 エンコードされた WAV データを一つに結合し、WAV ファイルで返します。
     * @summary Base64 エンコードされた複数の WAV データを一つに結合する
     * @param {Array<string>} requestBody 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    connectWavesConnectWavesPostRaw(requestParameters: ConnectWavesConnectWavesPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Blob>>;

    /**
     * Base64 エンコードされた WAV データを一つに結合し、WAV ファイルで返します。
     * Base64 エンコードされた複数の WAV データを一つに結合する
     */
    connectWavesConnectWavesPost(requestParameters: ConnectWavesConnectWavesPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Blob>;

    /**
     * 利用可能なコアのバージョン一覧を取得します。
     * @summary Core Versions
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    coreVersionsCoreVersionsGetRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<string>>>;

    /**
     * 利用可能なコアのバージョン一覧を取得します。
     * Core Versions
     */
    coreVersionsCoreVersionsGet(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<string>>;

    /**
     * 既存のプリセットを削除します。
     * @summary 既存のプリセットを削除する
     * @param {number} id 削除するプリセットのプリセットID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    deletePresetDeletePresetPostRaw(requestParameters: DeletePresetDeletePresetPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * 既存のプリセットを削除します。
     * 既存のプリセットを削除する
     */
    deletePresetDeletePresetPost(requestParameters: DeletePresetDeletePresetPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * ユーザー辞書に登録されている言葉を削除します。
     * @summary ユーザー辞書に登録されている言葉を削除する
     * @param {string} wordUuid 削除する言葉のUUID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    deleteUserDictWordUserDictWordWordUuidDeleteRaw(requestParameters: DeleteUserDictWordUserDictWordWordUuidDeleteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * ユーザー辞書に登録されている言葉を削除します。
     * ユーザー辞書に登録されている言葉を削除する
     */
    deleteUserDictWordUserDictWordWordUuidDelete(requestParameters: DeleteUserDictWordUserDictWordWordUuidDeleteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * エンジンマニフェストを取得します。
     * @summary Engine Manifest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    engineManifestEngineManifestGetRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<EngineManifest>>;

    /**
     * エンジンマニフェストを取得します。
     * Engine Manifest
     */
    engineManifestEngineManifestGet(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<EngineManifest>;

    /**
     * 
     * @summary AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     * @param {number} speaker 
     * @param {FrameAudioQuery} frameAudioQuery 
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    frameSynthesisFrameSynthesisPostRaw(requestParameters: FrameSynthesisFrameSynthesisPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Blob>>;

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    frameSynthesisFrameSynthesisPost(requestParameters: FrameSynthesisFrameSynthesisPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Blob>;

    /**
     * 指定された音声合成モデルの情報を取得します。
     * @summary 指定された音声合成モデルの情報を取得する
     * @param {string} aivmUuid 音声合成モデルの UUID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    getAivmInfoAivmModelsAivmUuidGetRaw(requestParameters: GetAivmInfoAivmModelsAivmUuidGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AivmInfo>>;

    /**
     * 指定された音声合成モデルの情報を取得します。
     * 指定された音声合成モデルの情報を取得する
     */
    getAivmInfoAivmModelsAivmUuidGet(requestParameters: GetAivmInfoAivmModelsAivmUuidGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AivmInfo>;

    /**
     * インストール済みのすべての音声合成モデルの情報を返します。
     * @summary インストール済みのすべての音声合成モデルの情報を取得する
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    getInstalledAivmInfosAivmModelsGetRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<{ [key: string]: AivmInfo; }>>;

    /**
     * インストール済みのすべての音声合成モデルの情報を返します。
     * インストール済みのすべての音声合成モデルの情報を取得する
     */
    getInstalledAivmInfosAivmModelsGet(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<{ [key: string]: AivmInfo; }>;

    /**
     * ポータルページを返します。
     * @summary Get Portal Page
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    getPortalPageGetRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<string>>;

    /**
     * ポータルページを返します。
     * Get Portal Page
     */
    getPortalPageGet(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<string>;

    /**
     * エンジンが保持しているプリセットの設定を返します。
     * @summary エンジンが保持しているプリセットの設定を取得する
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    getPresetsPresetsGetRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<Preset>>>;

    /**
     * エンジンが保持しているプリセットの設定を返します。
     * エンジンが保持しているプリセットの設定を取得する
     */
    getPresetsPresetsGet(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<Preset>>;

    /**
     * ユーザー辞書に登録されている単語の一覧を返します。 単語の表層形 (surface) は正規化済みの物を返します。
     * @summary ユーザー辞書に登録されている単語の一覧を取得する
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    getUserDictWordsUserDictGetRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<{ [key: string]: UserDictWord; }>>;

    /**
     * ユーザー辞書に登録されている単語の一覧を返します。 単語の表層形 (surface) は正規化済みの物を返します。
     * ユーザー辞書に登録されている単語の一覧を取得する
     */
    getUserDictWordsUserDictGet(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<{ [key: string]: UserDictWord; }>;

    /**
     * 他のユーザー辞書をインポートします。
     * @summary 他のユーザー辞書をインポートする
     * @param {boolean} override 重複したエントリがあった場合、上書きするかどうか
     * @param {{ [key: string]: UserDictWord; }} requestBody 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    importUserDictWordsImportUserDictPostRaw(requestParameters: ImportUserDictWordsImportUserDictPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * 他のユーザー辞書をインポートします。
     * 他のユーザー辞書をインポートする
     */
    importUserDictWordsImportUserDictPost(requestParameters: ImportUserDictWordsImportUserDictPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * 指定されたスタイル ID に紐づく音声合成モデルをロードします。 実行しなくても他の API は利用できますが、音声合成の初回実行時に時間がかかることがあります。
     * @summary 指定されたスタイル ID に紐づく音声合成モデルをロードする
     * @param {number} speaker 
     * @param {boolean} [skipReinit] 既にロード済みの音声合成モデルの再ロードをスキップするかどうか
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    initializeSpeakerInitializeSpeakerPostRaw(requestParameters: InitializeSpeakerInitializeSpeakerPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * 指定されたスタイル ID に紐づく音声合成モデルをロードします。 実行しなくても他の API は利用できますが、音声合成の初回実行時に時間がかかることがあります。
     * 指定されたスタイル ID に紐づく音声合成モデルをロードする
     */
    initializeSpeakerInitializeSpeakerPost(requestParameters: InitializeSpeakerInitializeSpeakerPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * 音声合成モデルをインストールします。 ファイルからインストールする場合は `file` を指定してください。 URL からインストールする場合は `url` を指定してください。
     * @summary 音声合成モデルをインストールする
     * @param {Blob} [file] 
     * @param {string} [url] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    installAivmAivmModelsInstallPostRaw(requestParameters: InstallAivmAivmModelsInstallPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * 音声合成モデルをインストールします。 ファイルからインストールする場合は `file` を指定してください。 URL からインストールする場合は `url` を指定してください。
     * 音声合成モデルをインストールする
     */
    installAivmAivmModelsInstallPost(requestParameters: InstallAivmAivmModelsInstallPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * 指定されたスタイル ID に紐づく音声合成モデルがロードされているかどうかを返します。
     * @summary 指定されたスタイル ID に紐づく音声合成モデルがロードされているかを確認する
     * @param {number} speaker 
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    isInitializedSpeakerIsInitializedSpeakerGetRaw(requestParameters: IsInitializedSpeakerIsInitializedSpeakerGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<boolean>>;

    /**
     * 指定されたスタイル ID に紐づく音声合成モデルがロードされているかどうかを返します。
     * 指定されたスタイル ID に紐づく音声合成モデルがロードされているかを確認する
     */
    isInitializedSpeakerIsInitializedSpeakerGet(requestParameters: IsInitializedSpeakerIsInitializedSpeakerGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<boolean>;

    /**
     * 指定された音声合成モデルをロードします。すでにロード済みの場合は何も行われません。 実行しなくても他の API は利用できますが、音声合成の初回実行時に時間がかかることがあります。
     * @summary 指定された音声合成モデルをロードする
     * @param {string} aivmUuid 音声合成モデルの UUID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    loadAivmAivmModelsAivmUuidLoadPostRaw(requestParameters: LoadAivmAivmModelsAivmUuidLoadPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * 指定された音声合成モデルをロードします。すでにロード済みの場合は何も行われません。 実行しなくても他の API は利用できますが、音声合成の初回実行時に時間がかかることがあります。
     * 指定された音声合成モデルをロードする
     */
    loadAivmAivmModelsAivmUuidLoadPost(requestParameters: LoadAivmAivmModelsAivmUuidLoadPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * 
     * @summary アクセント句から音高・音素長を得る (AivisSpeech Engine では常にダミーの値が返されます)
     * @param {number} speaker 
     * @param {Array<AccentPhrase>} accentPhrase 
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    moraDataMoraDataPostRaw(requestParameters: MoraDataMoraDataPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<AccentPhrase>>>;

    /**
     * アクセント句から音高・音素長を得る (AivisSpeech Engine では常にダミーの値が返されます)
     */
    moraDataMoraDataPost(requestParameters: MoraDataMoraDataPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<AccentPhrase>>;

    /**
     * 
     * @summary アクセント句から音素長を得る (AivisSpeech Engine では常にダミーの値が返されます)
     * @param {number} speaker 
     * @param {Array<AccentPhrase>} accentPhrase 
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    moraLengthMoraLengthPostRaw(requestParameters: MoraLengthMoraLengthPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<AccentPhrase>>>;

    /**
     * アクセント句から音素長を得る (AivisSpeech Engine では常にダミーの値が返されます)
     */
    moraLengthMoraLengthPost(requestParameters: MoraLengthMoraLengthPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<AccentPhrase>>;

    /**
     * 
     * @summary アクセント句から音高を得る (AivisSpeech Engine では常にダミーの値が返されます)
     * @param {number} speaker 
     * @param {Array<AccentPhrase>} accentPhrase 
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    moraPitchMoraPitchPostRaw(requestParameters: MoraPitchMoraPitchPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<AccentPhrase>>>;

    /**
     * アクセント句から音高を得る (AivisSpeech Engine では常にダミーの値が返されます)
     */
    moraPitchMoraPitchPost(requestParameters: MoraPitchMoraPitchPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<AccentPhrase>>;

    /**
     * 指定されたベーススタイルに対してエンジン内の各キャラクターがモーフィング機能を利用可能か返します。<br> モーフィングの許可/禁止は `/speakers `の `speaker.supported_features.synthesis_morphing` に記載されています。<br> プロパティが存在しない場合は、モーフィングが許可されているとみなします。<br> 返り値のスタイル ID は string 型なので注意。<br> AivisSpeech Engine では話者ごとに発声タイミングが異なる関係で実装不可能なため (動作こそするが聴くに耐えない) 、 全ての話者でモーフィングが禁止されています。
     * @summary 指定したスタイルに対してエンジン内のキャラクターがモーフィングが可能か判定する
     * @param {Array<number>} requestBody 
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    morphableTargetsMorphableTargetsPostRaw(requestParameters: MorphableTargetsMorphableTargetsPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<{ [key: string]: MorphableTargetInfo; }>>>;

    /**
     * 指定されたベーススタイルに対してエンジン内の各キャラクターがモーフィング機能を利用可能か返します。<br> モーフィングの許可/禁止は `/speakers `の `speaker.supported_features.synthesis_morphing` に記載されています。<br> プロパティが存在しない場合は、モーフィングが許可されているとみなします。<br> 返り値のスタイル ID は string 型なので注意。<br> AivisSpeech Engine では話者ごとに発声タイミングが異なる関係で実装不可能なため (動作こそするが聴くに耐えない) 、 全ての話者でモーフィングが禁止されています。
     * 指定したスタイルに対してエンジン内のキャラクターがモーフィングが可能か判定する
     */
    morphableTargetsMorphableTargetsPost(requestParameters: MorphableTargetsMorphableTargetsPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<{ [key: string]: MorphableTargetInfo; }>>;

    /**
     * 
     * @summary 複数まとめて音声合成する
     * @param {number} speaker 
     * @param {Array<AudioQuery>} audioQuery 
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    multiSynthesisMultiSynthesisPostRaw(requestParameters: MultiSynthesisMultiSynthesisPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Blob>>;

    /**
     * 複数まとめて音声合成する
     */
    multiSynthesisMultiSynthesisPost(requestParameters: MultiSynthesisMultiSynthesisPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Blob>;

    /**
     * ユーザー辞書に登録されている言葉を更新します。
     * @summary ユーザー辞書に登録されている言葉を更新する
     * @param {string} wordUuid 更新する言葉の UUID
     * @param {string} surface 言葉の表層形
     * @param {string} pronunciation 言葉の発音（カタカナ）
     * @param {number} accentType アクセント型（音が下がる場所を指す）
     * @param {WordTypes} [wordType] PROPER_NOUN（固有名詞）、COMMON_NOUN（普通名詞）、VERB（動詞）、ADJECTIVE（形容詞）、SUFFIX（語尾）のいずれか
     * @param {number} [priority] 単語の優先度（0から10までの整数）。数字が大きいほど優先度が高くなる。1から9までの値を指定することを推奨。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    rewriteUserDictWordUserDictWordWordUuidPutRaw(requestParameters: RewriteUserDictWordUserDictWordWordUuidPutRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * ユーザー辞書に登録されている言葉を更新します。
     * ユーザー辞書に登録されている言葉を更新する
     */
    rewriteUserDictWordUserDictWordWordUuidPut(requestParameters: RewriteUserDictWordUserDictWordWordUuidPutRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * 設定ページを返します。
     * @summary Setting Get
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    settingGetSettingGetRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * 設定ページを返します。
     * Setting Get
     */
    settingGetSettingGet(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * 設定を更新します。
     * @summary Setting Post
     * @param {CorsPolicyMode} corsPolicyMode 
     * @param {string} [allowOrigin] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    settingPostSettingPostRaw(requestParameters: SettingPostSettingPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * 設定を更新します。
     * Setting Post
     */
    settingPostSettingPost(requestParameters: SettingPostSettingPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * 
     * @summary AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     * @param {number} speaker 
     * @param {Score} score 
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    singFrameAudioQuerySingFrameAudioQueryPostRaw(requestParameters: SingFrameAudioQuerySingFrameAudioQueryPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FrameAudioQuery>>;

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    singFrameAudioQuerySingFrameAudioQueryPost(requestParameters: SingFrameAudioQuerySingFrameAudioQueryPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FrameAudioQuery>;

    /**
     * 
     * @summary AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     * @param {number} speaker 
     * @param {BodySingFrameVolumeSingFrameVolumePost} bodySingFrameVolumeSingFrameVolumePost 
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    singFrameVolumeSingFrameVolumePostRaw(requestParameters: SingFrameVolumeSingFrameVolumePostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<number>>>;

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    singFrameVolumeSingFrameVolumePost(requestParameters: SingFrameVolumeSingFrameVolumePostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<number>>;

    /**
     * 
     * @summary AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     * @param {string} speakerUuid 
     * @param {'base64' | 'url'} [resourceFormat] 
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    singerInfoSingerInfoGetRaw(requestParameters: SingerInfoSingerInfoGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SpeakerInfo>>;

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    singerInfoSingerInfoGet(requestParameters: SingerInfoSingerInfoGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SpeakerInfo>;

    /**
     * 
     * @summary AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    singersSingersGetRaw(requestParameters: SingersSingersGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<Speaker>>>;

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    singersSingersGet(requestParameters: SingersSingersGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<Speaker>>;

    /**
     * UUID で指定された話者の情報を返します。 画像や音声は resource_format で指定した形式で返されます。
     * @summary UUID で指定された話者の情報を取得する
     * @param {string} speakerUuid 
     * @param {'base64' | 'url'} [resourceFormat] 
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    speakerInfoSpeakerInfoGetRaw(requestParameters: SpeakerInfoSpeakerInfoGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SpeakerInfo>>;

    /**
     * UUID で指定された話者の情報を返します。 画像や音声は resource_format で指定した形式で返されます。
     * UUID で指定された話者の情報を取得する
     */
    speakerInfoSpeakerInfoGet(requestParameters: SpeakerInfoSpeakerInfoGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SpeakerInfo>;

    /**
     * 話者情報の一覧を返します。
     * @summary 話者情報の一覧を取得する
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    speakersSpeakersGetRaw(requestParameters: SpeakersSpeakersGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<Speaker>>>;

    /**
     * 話者情報の一覧を返します。
     * 話者情報の一覧を取得する
     */
    speakersSpeakersGet(requestParameters: SpeakersSpeakersGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<Speaker>>;

    /**
     * このビルドでサポートされている、音声合成モデルの推論デバイスを返します。<br> 通常、下記の値が返されます。true であっても実際に推論デバイスが利用可能とは限りません。 - Windows: `{\"cpu\": true, \"cuda\": false, \"dml\": true}` - macOS: `{\"cpu\": true, \"cuda\": false, \"dml\": false}` - Linux: `{\"cpu\": true, \"cuda\": true, \"dml\": false}`
     * @summary このビルドでサポートされている、音声合成モデルの推論デバイスを取得する
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    supportedDevicesSupportedDevicesGetRaw(requestParameters: SupportedDevicesSupportedDevicesGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SupportedDevicesInfo>>;

    /**
     * このビルドでサポートされている、音声合成モデルの推論デバイスを返します。<br> 通常、下記の値が返されます。true であっても実際に推論デバイスが利用可能とは限りません。 - Windows: `{\"cpu\": true, \"cuda\": false, \"dml\": true}` - macOS: `{\"cpu\": true, \"cuda\": false, \"dml\": false}` - Linux: `{\"cpu\": true, \"cuda\": true, \"dml\": false}`
     * このビルドでサポートされている、音声合成モデルの推論デバイスを取得する
     */
    supportedDevicesSupportedDevicesGet(requestParameters: SupportedDevicesSupportedDevicesGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SupportedDevicesInfo>;

    /**
     * 指定された 2 種類のスタイルで音声を合成、指定した割合でモーフィングした音声を得ます。<br> モーフィングの割合は `morph_rate` で指定でき、0.0 でベースのスタイル、1.0 でターゲットのスタイルに近づきます。<br> AivisSpeech Engine では話者ごとに発声タイミングが異なる関係で実装不可能なため (動作こそするが聴くに耐えない) 、 常に 400 Bad Request を返します。
     * @summary 2種類のスタイルでモーフィングした音声を合成する
     * @param {number} baseSpeaker 
     * @param {number} targetSpeaker 
     * @param {number} morphRate 
     * @param {AudioQuery} audioQuery 
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    synthesisMorphingSynthesisMorphingPostRaw(requestParameters: SynthesisMorphingSynthesisMorphingPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Blob>>;

    /**
     * 指定された 2 種類のスタイルで音声を合成、指定した割合でモーフィングした音声を得ます。<br> モーフィングの割合は `morph_rate` で指定でき、0.0 でベースのスタイル、1.0 でターゲットのスタイルに近づきます。<br> AivisSpeech Engine では話者ごとに発声タイミングが異なる関係で実装不可能なため (動作こそするが聴くに耐えない) 、 常に 400 Bad Request を返します。
     * 2種類のスタイルでモーフィングした音声を合成する
     */
    synthesisMorphingSynthesisMorphingPost(requestParameters: SynthesisMorphingSynthesisMorphingPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Blob>;

    /**
     * 指定されたスタイル ID に紐づく音声合成モデルを用いて音声合成を行います。
     * @summary 音声合成する
     * @param {number} speaker 
     * @param {AudioQuery} audioQuery 
     * @param {boolean} [enableInterrogativeUpspeak] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {string} [coreVersion] AivisSpeech Engine ではサポートされていないパラメータです (常に無視されます) 。
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    synthesisSynthesisPostRaw(requestParameters: SynthesisSynthesisPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Blob>>;

    /**
     * 指定されたスタイル ID に紐づく音声合成モデルを用いて音声合成を行います。
     * 音声合成する
     */
    synthesisSynthesisPost(requestParameters: SynthesisSynthesisPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Blob>;

    /**
     * 指定された音声合成モデルをアンインストールします。
     * @summary 指定された音声合成モデルをアンインストールする
     * @param {string} aivmUuid 音声合成モデルの UUID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    uninstallAivmAivmModelsAivmUuidUninstallDeleteRaw(requestParameters: UninstallAivmAivmModelsAivmUuidUninstallDeleteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * 指定された音声合成モデルをアンインストールします。
     * 指定された音声合成モデルをアンインストールする
     */
    uninstallAivmAivmModelsAivmUuidUninstallDelete(requestParameters: UninstallAivmAivmModelsAivmUuidUninstallDeleteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * 指定された音声合成モデルをアンロードします。
     * @summary 指定された音声合成モデルをアンロードする
     * @param {string} aivmUuid 音声合成モデルの UUID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    unloadAivmAivmModelsAivmUuidUnloadPostRaw(requestParameters: UnloadAivmAivmModelsAivmUuidUnloadPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * 指定された音声合成モデルをアンロードします。
     * 指定された音声合成モデルをアンロードする
     */
    unloadAivmAivmModelsAivmUuidUnloadPost(requestParameters: UnloadAivmAivmModelsAivmUuidUnloadPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * AivisHub から指定された音声合成モデルの一番新しいバージョンをダウンロードし、 インストール済みの音声合成モデルへ上書き更新します。
     * @summary 指定された音声合成モデルを更新する
     * @param {string} aivmUuid 音声合成モデルの UUID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    updateAivmAivmModelsAivmUuidUpdatePostRaw(requestParameters: UpdateAivmAivmModelsAivmUuidUpdatePostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * AivisHub から指定された音声合成モデルの一番新しいバージョンをダウンロードし、 インストール済みの音声合成モデルへ上書き更新します。
     * 指定された音声合成モデルを更新する
     */
    updateAivmAivmModelsAivmUuidUpdatePost(requestParameters: UpdateAivmAivmModelsAivmUuidUpdatePostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * 既存のプリセットを更新します。
     * @summary 既存のプリセットを更新する
     * @param {Preset} preset 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    updatePresetUpdatePresetPostRaw(requestParameters: UpdatePresetUpdatePresetPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<number>>;

    /**
     * 既存のプリセットを更新します。
     * 既存のプリセットを更新する
     */
    updatePresetUpdatePresetPost(requestParameters: UpdatePresetUpdatePresetPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<number>;

    /**
     * テキストが AquesTalk 風記法に従っているかどうかを判定します。 従っていない場合はエラーが返ります。
     * @summary テキストが AquesTalk 風記法に従っているか判定する
     * @param {string} text 判定する対象の文字列
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    validateKanaValidateKanaPostRaw(requestParameters: ValidateKanaValidateKanaPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<boolean>>;

    /**
     * テキストが AquesTalk 風記法に従っているかどうかを判定します。 従っていない場合はエラーが返ります。
     * テキストが AquesTalk 風記法に従っているか判定する
     */
    validateKanaValidateKanaPost(requestParameters: ValidateKanaValidateKanaPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<boolean>;

    /**
     * エンジンのバージョンを取得します。
     * @summary Version
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    versionVersionGetRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<string>>;

    /**
     * エンジンのバージョンを取得します。
     * Version
     */
    versionVersionGet(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<string>;

}

/**
 * 
 */
export class DefaultApi extends runtime.BaseAPI implements DefaultApiInterface {

    /**
     * テキストからアクセント句を得ます。 is_kanaが`true`のとき、テキストは次の AquesTalk 風記法で解釈されます。デフォルトは`false`です。 * 全てのカナはカタカナで記述される * アクセント句は`/`または`、`で区切る。`、`で区切った場合に限り無音区間が挿入される。 * カナの手前に`_`を入れるとそのカナは無声化される * アクセント位置を`\'`で指定する。全てのアクセント句にはアクセント位置を1つ指定する必要がある。 * アクセント句末に`？`(全角)を入れることにより疑問文の発音ができる。
     * テキストからアクセント句を得る
     */
    async accentPhrasesAccentPhrasesPostRaw(requestParameters: AccentPhrasesAccentPhrasesPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<AccentPhrase>>> {
        if (requestParameters.text === null || requestParameters.text === undefined) {
            throw new runtime.RequiredError('text','Required parameter requestParameters.text was null or undefined when calling accentPhrasesAccentPhrasesPost.');
        }

        if (requestParameters.speaker === null || requestParameters.speaker === undefined) {
            throw new runtime.RequiredError('speaker','Required parameter requestParameters.speaker was null or undefined when calling accentPhrasesAccentPhrasesPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.text !== undefined) {
            queryParameters['text'] = requestParameters.text;
        }

        if (requestParameters.speaker !== undefined) {
            queryParameters['speaker'] = requestParameters.speaker;
        }

        if (requestParameters.isKana !== undefined) {
            queryParameters['is_kana'] = requestParameters.isKana;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/accent_phrases`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(AccentPhraseFromJSON));
    }

    /**
     * テキストからアクセント句を得ます。 is_kanaが`true`のとき、テキストは次の AquesTalk 風記法で解釈されます。デフォルトは`false`です。 * 全てのカナはカタカナで記述される * アクセント句は`/`または`、`で区切る。`、`で区切った場合に限り無音区間が挿入される。 * カナの手前に`_`を入れるとそのカナは無声化される * アクセント位置を`\'`で指定する。全てのアクセント句にはアクセント位置を1つ指定する必要がある。 * アクセント句末に`？`(全角)を入れることにより疑問文の発音ができる。
     * テキストからアクセント句を得る
     */
    async accentPhrasesAccentPhrasesPost(requestParameters: AccentPhrasesAccentPhrasesPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<AccentPhrase>> {
        const response = await this.accentPhrasesAccentPhrasesPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * 新しいプリセットを追加します。
     * 新しいプリセットを追加する
     */
    async addPresetAddPresetPostRaw(requestParameters: AddPresetAddPresetPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<number>> {
        if (requestParameters.preset === null || requestParameters.preset === undefined) {
            throw new runtime.RequiredError('preset','Required parameter requestParameters.preset was null or undefined when calling addPresetAddPresetPost.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/add_preset`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: PresetToJSON(requestParameters.preset),
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<number>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * 新しいプリセットを追加します。
     * 新しいプリセットを追加する
     */
    async addPresetAddPresetPost(requestParameters: AddPresetAddPresetPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<number> {
        const response = await this.addPresetAddPresetPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * ユーザー辞書に言葉を追加します。
     * ユーザー辞書に言葉を追加する
     */
    async addUserDictWordUserDictWordPostRaw(requestParameters: AddUserDictWordUserDictWordPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<string>> {
        if (requestParameters.surface === null || requestParameters.surface === undefined) {
            throw new runtime.RequiredError('surface','Required parameter requestParameters.surface was null or undefined when calling addUserDictWordUserDictWordPost.');
        }

        if (requestParameters.pronunciation === null || requestParameters.pronunciation === undefined) {
            throw new runtime.RequiredError('pronunciation','Required parameter requestParameters.pronunciation was null or undefined when calling addUserDictWordUserDictWordPost.');
        }

        if (requestParameters.accentType === null || requestParameters.accentType === undefined) {
            throw new runtime.RequiredError('accentType','Required parameter requestParameters.accentType was null or undefined when calling addUserDictWordUserDictWordPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.surface !== undefined) {
            queryParameters['surface'] = requestParameters.surface;
        }

        if (requestParameters.pronunciation !== undefined) {
            queryParameters['pronunciation'] = requestParameters.pronunciation;
        }

        if (requestParameters.accentType !== undefined) {
            queryParameters['accent_type'] = requestParameters.accentType;
        }

        if (requestParameters.wordType !== undefined) {
            queryParameters['word_type'] = requestParameters.wordType;
        }

        if (requestParameters.priority !== undefined) {
            queryParameters['priority'] = requestParameters.priority;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/user_dict_word`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<string>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * ユーザー辞書に言葉を追加します。
     * ユーザー辞書に言葉を追加する
     */
    async addUserDictWordUserDictWordPost(requestParameters: AddUserDictWordUserDictWordPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<string> {
        const response = await this.addUserDictWordUserDictWordPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * 音声合成用のクエリの初期値を得ます。ここで得られたクエリはそのまま音声合成に利用できます。各値の意味は`Schemas`を参照してください。
     * 音声合成用のクエリを作成する
     */
    async audioQueryAudioQueryPostRaw(requestParameters: AudioQueryAudioQueryPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AudioQuery>> {
        if (requestParameters.text === null || requestParameters.text === undefined) {
            throw new runtime.RequiredError('text','Required parameter requestParameters.text was null or undefined when calling audioQueryAudioQueryPost.');
        }

        if (requestParameters.speaker === null || requestParameters.speaker === undefined) {
            throw new runtime.RequiredError('speaker','Required parameter requestParameters.speaker was null or undefined when calling audioQueryAudioQueryPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.text !== undefined) {
            queryParameters['text'] = requestParameters.text;
        }

        if (requestParameters.speaker !== undefined) {
            queryParameters['speaker'] = requestParameters.speaker;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/audio_query`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => AudioQueryFromJSON(jsonValue));
    }

    /**
     * 音声合成用のクエリの初期値を得ます。ここで得られたクエリはそのまま音声合成に利用できます。各値の意味は`Schemas`を参照してください。
     * 音声合成用のクエリを作成する
     */
    async audioQueryAudioQueryPost(requestParameters: AudioQueryAudioQueryPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AudioQuery> {
        const response = await this.audioQueryAudioQueryPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * 音声合成用のクエリの初期値を得ます。ここで得られたクエリはそのまま音声合成に利用できます。各値の意味は`Schemas`を参照してください。
     * 音声合成用のクエリをプリセットを用いて作成する
     */
    async audioQueryFromPresetAudioQueryFromPresetPostRaw(requestParameters: AudioQueryFromPresetAudioQueryFromPresetPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AudioQuery>> {
        if (requestParameters.text === null || requestParameters.text === undefined) {
            throw new runtime.RequiredError('text','Required parameter requestParameters.text was null or undefined when calling audioQueryFromPresetAudioQueryFromPresetPost.');
        }

        if (requestParameters.presetId === null || requestParameters.presetId === undefined) {
            throw new runtime.RequiredError('presetId','Required parameter requestParameters.presetId was null or undefined when calling audioQueryFromPresetAudioQueryFromPresetPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.text !== undefined) {
            queryParameters['text'] = requestParameters.text;
        }

        if (requestParameters.presetId !== undefined) {
            queryParameters['preset_id'] = requestParameters.presetId;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/audio_query_from_preset`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => AudioQueryFromJSON(jsonValue));
    }

    /**
     * 音声合成用のクエリの初期値を得ます。ここで得られたクエリはそのまま音声合成に利用できます。各値の意味は`Schemas`を参照してください。
     * 音声合成用のクエリをプリセットを用いて作成する
     */
    async audioQueryFromPresetAudioQueryFromPresetPost(requestParameters: AudioQueryFromPresetAudioQueryFromPresetPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AudioQuery> {
        const response = await this.audioQueryFromPresetAudioQueryFromPresetPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    async cancellableSynthesisCancellableSynthesisPostRaw(requestParameters: CancellableSynthesisCancellableSynthesisPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Blob>> {
        if (requestParameters.speaker === null || requestParameters.speaker === undefined) {
            throw new runtime.RequiredError('speaker','Required parameter requestParameters.speaker was null or undefined when calling cancellableSynthesisCancellableSynthesisPost.');
        }

        if (requestParameters.audioQuery === null || requestParameters.audioQuery === undefined) {
            throw new runtime.RequiredError('audioQuery','Required parameter requestParameters.audioQuery was null or undefined when calling cancellableSynthesisCancellableSynthesisPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.speaker !== undefined) {
            queryParameters['speaker'] = requestParameters.speaker;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/cancellable_synthesis`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: AudioQueryToJSON(requestParameters.audioQuery),
        }, initOverrides);

        return new runtime.BlobApiResponse(response);
    }

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    async cancellableSynthesisCancellableSynthesisPost(requestParameters: CancellableSynthesisCancellableSynthesisPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Blob> {
        const response = await this.cancellableSynthesisCancellableSynthesisPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Base64 エンコードされた WAV データを一つに結合し、WAV ファイルで返します。
     * Base64 エンコードされた複数の WAV データを一つに結合する
     */
    async connectWavesConnectWavesPostRaw(requestParameters: ConnectWavesConnectWavesPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Blob>> {
        if (requestParameters.requestBody === null || requestParameters.requestBody === undefined) {
            throw new runtime.RequiredError('requestBody','Required parameter requestParameters.requestBody was null or undefined when calling connectWavesConnectWavesPost.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/connect_waves`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: requestParameters.requestBody,
        }, initOverrides);

        return new runtime.BlobApiResponse(response);
    }

    /**
     * Base64 エンコードされた WAV データを一つに結合し、WAV ファイルで返します。
     * Base64 エンコードされた複数の WAV データを一つに結合する
     */
    async connectWavesConnectWavesPost(requestParameters: ConnectWavesConnectWavesPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Blob> {
        const response = await this.connectWavesConnectWavesPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * 利用可能なコアのバージョン一覧を取得します。
     * Core Versions
     */
    async coreVersionsCoreVersionsGetRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<string>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/core_versions`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse<any>(response);
    }

    /**
     * 利用可能なコアのバージョン一覧を取得します。
     * Core Versions
     */
    async coreVersionsCoreVersionsGet(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<string>> {
        const response = await this.coreVersionsCoreVersionsGetRaw(initOverrides);
        return await response.value();
    }

    /**
     * 既存のプリセットを削除します。
     * 既存のプリセットを削除する
     */
    async deletePresetDeletePresetPostRaw(requestParameters: DeletePresetDeletePresetPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling deletePresetDeletePresetPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.id !== undefined) {
            queryParameters['id'] = requestParameters.id;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/delete_preset`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * 既存のプリセットを削除します。
     * 既存のプリセットを削除する
     */
    async deletePresetDeletePresetPost(requestParameters: DeletePresetDeletePresetPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.deletePresetDeletePresetPostRaw(requestParameters, initOverrides);
    }

    /**
     * ユーザー辞書に登録されている言葉を削除します。
     * ユーザー辞書に登録されている言葉を削除する
     */
    async deleteUserDictWordUserDictWordWordUuidDeleteRaw(requestParameters: DeleteUserDictWordUserDictWordWordUuidDeleteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.wordUuid === null || requestParameters.wordUuid === undefined) {
            throw new runtime.RequiredError('wordUuid','Required parameter requestParameters.wordUuid was null or undefined when calling deleteUserDictWordUserDictWordWordUuidDelete.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/user_dict_word/{word_uuid}`.replace(`{${"word_uuid"}}`, encodeURIComponent(String(requestParameters.wordUuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * ユーザー辞書に登録されている言葉を削除します。
     * ユーザー辞書に登録されている言葉を削除する
     */
    async deleteUserDictWordUserDictWordWordUuidDelete(requestParameters: DeleteUserDictWordUserDictWordWordUuidDeleteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.deleteUserDictWordUserDictWordWordUuidDeleteRaw(requestParameters, initOverrides);
    }

    /**
     * エンジンマニフェストを取得します。
     * Engine Manifest
     */
    async engineManifestEngineManifestGetRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<EngineManifest>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/engine_manifest`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => EngineManifestFromJSON(jsonValue));
    }

    /**
     * エンジンマニフェストを取得します。
     * Engine Manifest
     */
    async engineManifestEngineManifestGet(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<EngineManifest> {
        const response = await this.engineManifestEngineManifestGetRaw(initOverrides);
        return await response.value();
    }

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    async frameSynthesisFrameSynthesisPostRaw(requestParameters: FrameSynthesisFrameSynthesisPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Blob>> {
        if (requestParameters.speaker === null || requestParameters.speaker === undefined) {
            throw new runtime.RequiredError('speaker','Required parameter requestParameters.speaker was null or undefined when calling frameSynthesisFrameSynthesisPost.');
        }

        if (requestParameters.frameAudioQuery === null || requestParameters.frameAudioQuery === undefined) {
            throw new runtime.RequiredError('frameAudioQuery','Required parameter requestParameters.frameAudioQuery was null or undefined when calling frameSynthesisFrameSynthesisPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.speaker !== undefined) {
            queryParameters['speaker'] = requestParameters.speaker;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/frame_synthesis`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: FrameAudioQueryToJSON(requestParameters.frameAudioQuery),
        }, initOverrides);

        return new runtime.BlobApiResponse(response);
    }

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    async frameSynthesisFrameSynthesisPost(requestParameters: FrameSynthesisFrameSynthesisPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Blob> {
        const response = await this.frameSynthesisFrameSynthesisPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * 指定された音声合成モデルの情報を取得します。
     * 指定された音声合成モデルの情報を取得する
     */
    async getAivmInfoAivmModelsAivmUuidGetRaw(requestParameters: GetAivmInfoAivmModelsAivmUuidGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AivmInfo>> {
        if (requestParameters.aivmUuid === null || requestParameters.aivmUuid === undefined) {
            throw new runtime.RequiredError('aivmUuid','Required parameter requestParameters.aivmUuid was null or undefined when calling getAivmInfoAivmModelsAivmUuidGet.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/aivm_models/{aivm_uuid}`.replace(`{${"aivm_uuid"}}`, encodeURIComponent(String(requestParameters.aivmUuid))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => AivmInfoFromJSON(jsonValue));
    }

    /**
     * 指定された音声合成モデルの情報を取得します。
     * 指定された音声合成モデルの情報を取得する
     */
    async getAivmInfoAivmModelsAivmUuidGet(requestParameters: GetAivmInfoAivmModelsAivmUuidGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AivmInfo> {
        const response = await this.getAivmInfoAivmModelsAivmUuidGetRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * インストール済みのすべての音声合成モデルの情報を返します。
     * インストール済みのすべての音声合成モデルの情報を取得する
     */
    async getInstalledAivmInfosAivmModelsGetRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<{ [key: string]: AivmInfo; }>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/aivm_models`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => runtime.mapValues(jsonValue, AivmInfoFromJSON));
    }

    /**
     * インストール済みのすべての音声合成モデルの情報を返します。
     * インストール済みのすべての音声合成モデルの情報を取得する
     */
    async getInstalledAivmInfosAivmModelsGet(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<{ [key: string]: AivmInfo; }> {
        const response = await this.getInstalledAivmInfosAivmModelsGetRaw(initOverrides);
        return await response.value();
    }

    /**
     * ポータルページを返します。
     * Get Portal Page
     */
    async getPortalPageGetRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<string>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<string>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * ポータルページを返します。
     * Get Portal Page
     */
    async getPortalPageGet(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<string> {
        const response = await this.getPortalPageGetRaw(initOverrides);
        return await response.value();
    }

    /**
     * エンジンが保持しているプリセットの設定を返します。
     * エンジンが保持しているプリセットの設定を取得する
     */
    async getPresetsPresetsGetRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<Preset>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/presets`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(PresetFromJSON));
    }

    /**
     * エンジンが保持しているプリセットの設定を返します。
     * エンジンが保持しているプリセットの設定を取得する
     */
    async getPresetsPresetsGet(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<Preset>> {
        const response = await this.getPresetsPresetsGetRaw(initOverrides);
        return await response.value();
    }

    /**
     * ユーザー辞書に登録されている単語の一覧を返します。 単語の表層形 (surface) は正規化済みの物を返します。
     * ユーザー辞書に登録されている単語の一覧を取得する
     */
    async getUserDictWordsUserDictGetRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<{ [key: string]: UserDictWord; }>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/user_dict`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => runtime.mapValues(jsonValue, UserDictWordFromJSON));
    }

    /**
     * ユーザー辞書に登録されている単語の一覧を返します。 単語の表層形 (surface) は正規化済みの物を返します。
     * ユーザー辞書に登録されている単語の一覧を取得する
     */
    async getUserDictWordsUserDictGet(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<{ [key: string]: UserDictWord; }> {
        const response = await this.getUserDictWordsUserDictGetRaw(initOverrides);
        return await response.value();
    }

    /**
     * 他のユーザー辞書をインポートします。
     * 他のユーザー辞書をインポートする
     */
    async importUserDictWordsImportUserDictPostRaw(requestParameters: ImportUserDictWordsImportUserDictPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.override === null || requestParameters.override === undefined) {
            throw new runtime.RequiredError('override','Required parameter requestParameters.override was null or undefined when calling importUserDictWordsImportUserDictPost.');
        }

        if (requestParameters.requestBody === null || requestParameters.requestBody === undefined) {
            throw new runtime.RequiredError('requestBody','Required parameter requestParameters.requestBody was null or undefined when calling importUserDictWordsImportUserDictPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.override !== undefined) {
            queryParameters['override'] = requestParameters.override;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/import_user_dict`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: requestParameters.requestBody,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * 他のユーザー辞書をインポートします。
     * 他のユーザー辞書をインポートする
     */
    async importUserDictWordsImportUserDictPost(requestParameters: ImportUserDictWordsImportUserDictPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.importUserDictWordsImportUserDictPostRaw(requestParameters, initOverrides);
    }

    /**
     * 指定されたスタイル ID に紐づく音声合成モデルをロードします。 実行しなくても他の API は利用できますが、音声合成の初回実行時に時間がかかることがあります。
     * 指定されたスタイル ID に紐づく音声合成モデルをロードする
     */
    async initializeSpeakerInitializeSpeakerPostRaw(requestParameters: InitializeSpeakerInitializeSpeakerPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.speaker === null || requestParameters.speaker === undefined) {
            throw new runtime.RequiredError('speaker','Required parameter requestParameters.speaker was null or undefined when calling initializeSpeakerInitializeSpeakerPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.speaker !== undefined) {
            queryParameters['speaker'] = requestParameters.speaker;
        }

        if (requestParameters.skipReinit !== undefined) {
            queryParameters['skip_reinit'] = requestParameters.skipReinit;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/initialize_speaker`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * 指定されたスタイル ID に紐づく音声合成モデルをロードします。 実行しなくても他の API は利用できますが、音声合成の初回実行時に時間がかかることがあります。
     * 指定されたスタイル ID に紐づく音声合成モデルをロードする
     */
    async initializeSpeakerInitializeSpeakerPost(requestParameters: InitializeSpeakerInitializeSpeakerPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.initializeSpeakerInitializeSpeakerPostRaw(requestParameters, initOverrides);
    }

    /**
     * 音声合成モデルをインストールします。 ファイルからインストールする場合は `file` を指定してください。 URL からインストールする場合は `url` を指定してください。
     * 音声合成モデルをインストールする
     */
    async installAivmAivmModelsInstallPostRaw(requestParameters: InstallAivmAivmModelsInstallPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const consumes: runtime.Consume[] = [
            { contentType: 'multipart/form-data' },
        ];
        // @ts-ignore: canConsumeForm may be unused
        const canConsumeForm = runtime.canConsumeForm(consumes);

        let formParams: { append(param: string, value: any): any };
        let useForm = false;
        // use FormData to transmit files using content-type "multipart/form-data"
        useForm = canConsumeForm;
        if (useForm) {
            formParams = new FormData();
        } else {
            formParams = new URLSearchParams();
        }

        if (requestParameters.file !== undefined) {
            formParams.append('file', requestParameters.file as any);
        }

        if (requestParameters.url !== undefined) {
            formParams.append('url', requestParameters.url as any);
        }

        const response = await this.request({
            path: `/aivm_models/install`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: formParams,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * 音声合成モデルをインストールします。 ファイルからインストールする場合は `file` を指定してください。 URL からインストールする場合は `url` を指定してください。
     * 音声合成モデルをインストールする
     */
    async installAivmAivmModelsInstallPost(requestParameters: InstallAivmAivmModelsInstallPostRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.installAivmAivmModelsInstallPostRaw(requestParameters, initOverrides);
    }

    /**
     * 指定されたスタイル ID に紐づく音声合成モデルがロードされているかどうかを返します。
     * 指定されたスタイル ID に紐づく音声合成モデルがロードされているかを確認する
     */
    async isInitializedSpeakerIsInitializedSpeakerGetRaw(requestParameters: IsInitializedSpeakerIsInitializedSpeakerGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<boolean>> {
        if (requestParameters.speaker === null || requestParameters.speaker === undefined) {
            throw new runtime.RequiredError('speaker','Required parameter requestParameters.speaker was null or undefined when calling isInitializedSpeakerIsInitializedSpeakerGet.');
        }

        const queryParameters: any = {};

        if (requestParameters.speaker !== undefined) {
            queryParameters['speaker'] = requestParameters.speaker;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/is_initialized_speaker`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<boolean>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * 指定されたスタイル ID に紐づく音声合成モデルがロードされているかどうかを返します。
     * 指定されたスタイル ID に紐づく音声合成モデルがロードされているかを確認する
     */
    async isInitializedSpeakerIsInitializedSpeakerGet(requestParameters: IsInitializedSpeakerIsInitializedSpeakerGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<boolean> {
        const response = await this.isInitializedSpeakerIsInitializedSpeakerGetRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * 指定された音声合成モデルをロードします。すでにロード済みの場合は何も行われません。 実行しなくても他の API は利用できますが、音声合成の初回実行時に時間がかかることがあります。
     * 指定された音声合成モデルをロードする
     */
    async loadAivmAivmModelsAivmUuidLoadPostRaw(requestParameters: LoadAivmAivmModelsAivmUuidLoadPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.aivmUuid === null || requestParameters.aivmUuid === undefined) {
            throw new runtime.RequiredError('aivmUuid','Required parameter requestParameters.aivmUuid was null or undefined when calling loadAivmAivmModelsAivmUuidLoadPost.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/aivm_models/{aivm_uuid}/load`.replace(`{${"aivm_uuid"}}`, encodeURIComponent(String(requestParameters.aivmUuid))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * 指定された音声合成モデルをロードします。すでにロード済みの場合は何も行われません。 実行しなくても他の API は利用できますが、音声合成の初回実行時に時間がかかることがあります。
     * 指定された音声合成モデルをロードする
     */
    async loadAivmAivmModelsAivmUuidLoadPost(requestParameters: LoadAivmAivmModelsAivmUuidLoadPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.loadAivmAivmModelsAivmUuidLoadPostRaw(requestParameters, initOverrides);
    }

    /**
     * アクセント句から音高・音素長を得る (AivisSpeech Engine では常にダミーの値が返されます)
     */
    async moraDataMoraDataPostRaw(requestParameters: MoraDataMoraDataPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<AccentPhrase>>> {
        if (requestParameters.speaker === null || requestParameters.speaker === undefined) {
            throw new runtime.RequiredError('speaker','Required parameter requestParameters.speaker was null or undefined when calling moraDataMoraDataPost.');
        }

        if (requestParameters.accentPhrase === null || requestParameters.accentPhrase === undefined) {
            throw new runtime.RequiredError('accentPhrase','Required parameter requestParameters.accentPhrase was null or undefined when calling moraDataMoraDataPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.speaker !== undefined) {
            queryParameters['speaker'] = requestParameters.speaker;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/mora_data`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: requestParameters.accentPhrase.map(AccentPhraseToJSON),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(AccentPhraseFromJSON));
    }

    /**
     * アクセント句から音高・音素長を得る (AivisSpeech Engine では常にダミーの値が返されます)
     */
    async moraDataMoraDataPost(requestParameters: MoraDataMoraDataPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<AccentPhrase>> {
        const response = await this.moraDataMoraDataPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * アクセント句から音素長を得る (AivisSpeech Engine では常にダミーの値が返されます)
     */
    async moraLengthMoraLengthPostRaw(requestParameters: MoraLengthMoraLengthPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<AccentPhrase>>> {
        if (requestParameters.speaker === null || requestParameters.speaker === undefined) {
            throw new runtime.RequiredError('speaker','Required parameter requestParameters.speaker was null or undefined when calling moraLengthMoraLengthPost.');
        }

        if (requestParameters.accentPhrase === null || requestParameters.accentPhrase === undefined) {
            throw new runtime.RequiredError('accentPhrase','Required parameter requestParameters.accentPhrase was null or undefined when calling moraLengthMoraLengthPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.speaker !== undefined) {
            queryParameters['speaker'] = requestParameters.speaker;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/mora_length`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: requestParameters.accentPhrase.map(AccentPhraseToJSON),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(AccentPhraseFromJSON));
    }

    /**
     * アクセント句から音素長を得る (AivisSpeech Engine では常にダミーの値が返されます)
     */
    async moraLengthMoraLengthPost(requestParameters: MoraLengthMoraLengthPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<AccentPhrase>> {
        const response = await this.moraLengthMoraLengthPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * アクセント句から音高を得る (AivisSpeech Engine では常にダミーの値が返されます)
     */
    async moraPitchMoraPitchPostRaw(requestParameters: MoraPitchMoraPitchPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<AccentPhrase>>> {
        if (requestParameters.speaker === null || requestParameters.speaker === undefined) {
            throw new runtime.RequiredError('speaker','Required parameter requestParameters.speaker was null or undefined when calling moraPitchMoraPitchPost.');
        }

        if (requestParameters.accentPhrase === null || requestParameters.accentPhrase === undefined) {
            throw new runtime.RequiredError('accentPhrase','Required parameter requestParameters.accentPhrase was null or undefined when calling moraPitchMoraPitchPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.speaker !== undefined) {
            queryParameters['speaker'] = requestParameters.speaker;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/mora_pitch`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: requestParameters.accentPhrase.map(AccentPhraseToJSON),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(AccentPhraseFromJSON));
    }

    /**
     * アクセント句から音高を得る (AivisSpeech Engine では常にダミーの値が返されます)
     */
    async moraPitchMoraPitchPost(requestParameters: MoraPitchMoraPitchPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<AccentPhrase>> {
        const response = await this.moraPitchMoraPitchPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * 指定されたベーススタイルに対してエンジン内の各キャラクターがモーフィング機能を利用可能か返します。<br> モーフィングの許可/禁止は `/speakers `の `speaker.supported_features.synthesis_morphing` に記載されています。<br> プロパティが存在しない場合は、モーフィングが許可されているとみなします。<br> 返り値のスタイル ID は string 型なので注意。<br> AivisSpeech Engine では話者ごとに発声タイミングが異なる関係で実装不可能なため (動作こそするが聴くに耐えない) 、 全ての話者でモーフィングが禁止されています。
     * 指定したスタイルに対してエンジン内のキャラクターがモーフィングが可能か判定する
     */
    async morphableTargetsMorphableTargetsPostRaw(requestParameters: MorphableTargetsMorphableTargetsPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<{ [key: string]: MorphableTargetInfo; }>>> {
        if (requestParameters.requestBody === null || requestParameters.requestBody === undefined) {
            throw new runtime.RequiredError('requestBody','Required parameter requestParameters.requestBody was null or undefined when calling morphableTargetsMorphableTargetsPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/morphable_targets`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: requestParameters.requestBody,
        }, initOverrides);

        return new runtime.JSONApiResponse<any>(response);
    }

    /**
     * 指定されたベーススタイルに対してエンジン内の各キャラクターがモーフィング機能を利用可能か返します。<br> モーフィングの許可/禁止は `/speakers `の `speaker.supported_features.synthesis_morphing` に記載されています。<br> プロパティが存在しない場合は、モーフィングが許可されているとみなします。<br> 返り値のスタイル ID は string 型なので注意。<br> AivisSpeech Engine では話者ごとに発声タイミングが異なる関係で実装不可能なため (動作こそするが聴くに耐えない) 、 全ての話者でモーフィングが禁止されています。
     * 指定したスタイルに対してエンジン内のキャラクターがモーフィングが可能か判定する
     */
    async morphableTargetsMorphableTargetsPost(requestParameters: MorphableTargetsMorphableTargetsPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<{ [key: string]: MorphableTargetInfo; }>> {
        const response = await this.morphableTargetsMorphableTargetsPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * 複数まとめて音声合成する
     */
    async multiSynthesisMultiSynthesisPostRaw(requestParameters: MultiSynthesisMultiSynthesisPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Blob>> {
        if (requestParameters.speaker === null || requestParameters.speaker === undefined) {
            throw new runtime.RequiredError('speaker','Required parameter requestParameters.speaker was null or undefined when calling multiSynthesisMultiSynthesisPost.');
        }

        if (requestParameters.audioQuery === null || requestParameters.audioQuery === undefined) {
            throw new runtime.RequiredError('audioQuery','Required parameter requestParameters.audioQuery was null or undefined when calling multiSynthesisMultiSynthesisPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.speaker !== undefined) {
            queryParameters['speaker'] = requestParameters.speaker;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/multi_synthesis`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: requestParameters.audioQuery.map(AudioQueryToJSON),
        }, initOverrides);

        return new runtime.BlobApiResponse(response);
    }

    /**
     * 複数まとめて音声合成する
     */
    async multiSynthesisMultiSynthesisPost(requestParameters: MultiSynthesisMultiSynthesisPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Blob> {
        const response = await this.multiSynthesisMultiSynthesisPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * ユーザー辞書に登録されている言葉を更新します。
     * ユーザー辞書に登録されている言葉を更新する
     */
    async rewriteUserDictWordUserDictWordWordUuidPutRaw(requestParameters: RewriteUserDictWordUserDictWordWordUuidPutRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.wordUuid === null || requestParameters.wordUuid === undefined) {
            throw new runtime.RequiredError('wordUuid','Required parameter requestParameters.wordUuid was null or undefined when calling rewriteUserDictWordUserDictWordWordUuidPut.');
        }

        if (requestParameters.surface === null || requestParameters.surface === undefined) {
            throw new runtime.RequiredError('surface','Required parameter requestParameters.surface was null or undefined when calling rewriteUserDictWordUserDictWordWordUuidPut.');
        }

        if (requestParameters.pronunciation === null || requestParameters.pronunciation === undefined) {
            throw new runtime.RequiredError('pronunciation','Required parameter requestParameters.pronunciation was null or undefined when calling rewriteUserDictWordUserDictWordWordUuidPut.');
        }

        if (requestParameters.accentType === null || requestParameters.accentType === undefined) {
            throw new runtime.RequiredError('accentType','Required parameter requestParameters.accentType was null or undefined when calling rewriteUserDictWordUserDictWordWordUuidPut.');
        }

        const queryParameters: any = {};

        if (requestParameters.surface !== undefined) {
            queryParameters['surface'] = requestParameters.surface;
        }

        if (requestParameters.pronunciation !== undefined) {
            queryParameters['pronunciation'] = requestParameters.pronunciation;
        }

        if (requestParameters.accentType !== undefined) {
            queryParameters['accent_type'] = requestParameters.accentType;
        }

        if (requestParameters.wordType !== undefined) {
            queryParameters['word_type'] = requestParameters.wordType;
        }

        if (requestParameters.priority !== undefined) {
            queryParameters['priority'] = requestParameters.priority;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/user_dict_word/{word_uuid}`.replace(`{${"word_uuid"}}`, encodeURIComponent(String(requestParameters.wordUuid))),
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * ユーザー辞書に登録されている言葉を更新します。
     * ユーザー辞書に登録されている言葉を更新する
     */
    async rewriteUserDictWordUserDictWordWordUuidPut(requestParameters: RewriteUserDictWordUserDictWordWordUuidPutRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.rewriteUserDictWordUserDictWordWordUuidPutRaw(requestParameters, initOverrides);
    }

    /**
     * 設定ページを返します。
     * Setting Get
     */
    async settingGetSettingGetRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/setting`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * 設定ページを返します。
     * Setting Get
     */
    async settingGetSettingGet(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.settingGetSettingGetRaw(initOverrides);
    }

    /**
     * 設定を更新します。
     * Setting Post
     */
    async settingPostSettingPostRaw(requestParameters: SettingPostSettingPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.corsPolicyMode === null || requestParameters.corsPolicyMode === undefined) {
            throw new runtime.RequiredError('corsPolicyMode','Required parameter requestParameters.corsPolicyMode was null or undefined when calling settingPostSettingPost.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const consumes: runtime.Consume[] = [
            { contentType: 'application/x-www-form-urlencoded' },
        ];
        // @ts-ignore: canConsumeForm may be unused
        const canConsumeForm = runtime.canConsumeForm(consumes);

        let formParams: { append(param: string, value: any): any };
        let useForm = false;
        if (useForm) {
            formParams = new FormData();
        } else {
            formParams = new URLSearchParams();
        }

        if (requestParameters.corsPolicyMode !== undefined) {
            formParams.append('cors_policy_mode', new Blob([JSON.stringify(CorsPolicyModeToJSON(requestParameters.corsPolicyMode))], { type: "application/json", }));
                    }

        if (requestParameters.allowOrigin !== undefined) {
            formParams.append('allow_origin', requestParameters.allowOrigin as any);
        }

        const response = await this.request({
            path: `/setting`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: formParams,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * 設定を更新します。
     * Setting Post
     */
    async settingPostSettingPost(requestParameters: SettingPostSettingPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.settingPostSettingPostRaw(requestParameters, initOverrides);
    }

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    async singFrameAudioQuerySingFrameAudioQueryPostRaw(requestParameters: SingFrameAudioQuerySingFrameAudioQueryPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FrameAudioQuery>> {
        if (requestParameters.speaker === null || requestParameters.speaker === undefined) {
            throw new runtime.RequiredError('speaker','Required parameter requestParameters.speaker was null or undefined when calling singFrameAudioQuerySingFrameAudioQueryPost.');
        }

        if (requestParameters.score === null || requestParameters.score === undefined) {
            throw new runtime.RequiredError('score','Required parameter requestParameters.score was null or undefined when calling singFrameAudioQuerySingFrameAudioQueryPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.speaker !== undefined) {
            queryParameters['speaker'] = requestParameters.speaker;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/sing_frame_audio_query`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ScoreToJSON(requestParameters.score),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => FrameAudioQueryFromJSON(jsonValue));
    }

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    async singFrameAudioQuerySingFrameAudioQueryPost(requestParameters: SingFrameAudioQuerySingFrameAudioQueryPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FrameAudioQuery> {
        const response = await this.singFrameAudioQuerySingFrameAudioQueryPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    async singFrameVolumeSingFrameVolumePostRaw(requestParameters: SingFrameVolumeSingFrameVolumePostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<number>>> {
        if (requestParameters.speaker === null || requestParameters.speaker === undefined) {
            throw new runtime.RequiredError('speaker','Required parameter requestParameters.speaker was null or undefined when calling singFrameVolumeSingFrameVolumePost.');
        }

        if (requestParameters.bodySingFrameVolumeSingFrameVolumePost === null || requestParameters.bodySingFrameVolumeSingFrameVolumePost === undefined) {
            throw new runtime.RequiredError('bodySingFrameVolumeSingFrameVolumePost','Required parameter requestParameters.bodySingFrameVolumeSingFrameVolumePost was null or undefined when calling singFrameVolumeSingFrameVolumePost.');
        }

        const queryParameters: any = {};

        if (requestParameters.speaker !== undefined) {
            queryParameters['speaker'] = requestParameters.speaker;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/sing_frame_volume`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: BodySingFrameVolumeSingFrameVolumePostToJSON(requestParameters.bodySingFrameVolumeSingFrameVolumePost),
        }, initOverrides);

        return new runtime.JSONApiResponse<any>(response);
    }

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    async singFrameVolumeSingFrameVolumePost(requestParameters: SingFrameVolumeSingFrameVolumePostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<number>> {
        const response = await this.singFrameVolumeSingFrameVolumePostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    async singerInfoSingerInfoGetRaw(requestParameters: SingerInfoSingerInfoGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SpeakerInfo>> {
        if (requestParameters.speakerUuid === null || requestParameters.speakerUuid === undefined) {
            throw new runtime.RequiredError('speakerUuid','Required parameter requestParameters.speakerUuid was null or undefined when calling singerInfoSingerInfoGet.');
        }

        const queryParameters: any = {};

        if (requestParameters.speakerUuid !== undefined) {
            queryParameters['speaker_uuid'] = requestParameters.speakerUuid;
        }

        if (requestParameters.resourceFormat !== undefined) {
            queryParameters['resource_format'] = requestParameters.resourceFormat;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/singer_info`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SpeakerInfoFromJSON(jsonValue));
    }

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    async singerInfoSingerInfoGet(requestParameters: SingerInfoSingerInfoGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SpeakerInfo> {
        const response = await this.singerInfoSingerInfoGetRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    async singersSingersGetRaw(requestParameters: SingersSingersGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<Speaker>>> {
        const queryParameters: any = {};

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/singers`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(SpeakerFromJSON));
    }

    /**
     * AivisSpeech Engine ではサポートされていない API です (常に 501 Not Implemented を返します)
     */
    async singersSingersGet(requestParameters: SingersSingersGetRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<Speaker>> {
        const response = await this.singersSingersGetRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * UUID で指定された話者の情報を返します。 画像や音声は resource_format で指定した形式で返されます。
     * UUID で指定された話者の情報を取得する
     */
    async speakerInfoSpeakerInfoGetRaw(requestParameters: SpeakerInfoSpeakerInfoGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SpeakerInfo>> {
        if (requestParameters.speakerUuid === null || requestParameters.speakerUuid === undefined) {
            throw new runtime.RequiredError('speakerUuid','Required parameter requestParameters.speakerUuid was null or undefined when calling speakerInfoSpeakerInfoGet.');
        }

        const queryParameters: any = {};

        if (requestParameters.speakerUuid !== undefined) {
            queryParameters['speaker_uuid'] = requestParameters.speakerUuid;
        }

        if (requestParameters.resourceFormat !== undefined) {
            queryParameters['resource_format'] = requestParameters.resourceFormat;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/speaker_info`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SpeakerInfoFromJSON(jsonValue));
    }

    /**
     * UUID で指定された話者の情報を返します。 画像や音声は resource_format で指定した形式で返されます。
     * UUID で指定された話者の情報を取得する
     */
    async speakerInfoSpeakerInfoGet(requestParameters: SpeakerInfoSpeakerInfoGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SpeakerInfo> {
        const response = await this.speakerInfoSpeakerInfoGetRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * 話者情報の一覧を返します。
     * 話者情報の一覧を取得する
     */
    async speakersSpeakersGetRaw(requestParameters: SpeakersSpeakersGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<Speaker>>> {
        const queryParameters: any = {};

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/speakers`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(SpeakerFromJSON));
    }

    /**
     * 話者情報の一覧を返します。
     * 話者情報の一覧を取得する
     */
    async speakersSpeakersGet(requestParameters: SpeakersSpeakersGetRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<Speaker>> {
        const response = await this.speakersSpeakersGetRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * このビルドでサポートされている、音声合成モデルの推論デバイスを返します。<br> 通常、下記の値が返されます。true であっても実際に推論デバイスが利用可能とは限りません。 - Windows: `{\"cpu\": true, \"cuda\": false, \"dml\": true}` - macOS: `{\"cpu\": true, \"cuda\": false, \"dml\": false}` - Linux: `{\"cpu\": true, \"cuda\": true, \"dml\": false}`
     * このビルドでサポートされている、音声合成モデルの推論デバイスを取得する
     */
    async supportedDevicesSupportedDevicesGetRaw(requestParameters: SupportedDevicesSupportedDevicesGetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SupportedDevicesInfo>> {
        const queryParameters: any = {};

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/supported_devices`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SupportedDevicesInfoFromJSON(jsonValue));
    }

    /**
     * このビルドでサポートされている、音声合成モデルの推論デバイスを返します。<br> 通常、下記の値が返されます。true であっても実際に推論デバイスが利用可能とは限りません。 - Windows: `{\"cpu\": true, \"cuda\": false, \"dml\": true}` - macOS: `{\"cpu\": true, \"cuda\": false, \"dml\": false}` - Linux: `{\"cpu\": true, \"cuda\": true, \"dml\": false}`
     * このビルドでサポートされている、音声合成モデルの推論デバイスを取得する
     */
    async supportedDevicesSupportedDevicesGet(requestParameters: SupportedDevicesSupportedDevicesGetRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SupportedDevicesInfo> {
        const response = await this.supportedDevicesSupportedDevicesGetRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * 指定された 2 種類のスタイルで音声を合成、指定した割合でモーフィングした音声を得ます。<br> モーフィングの割合は `morph_rate` で指定でき、0.0 でベースのスタイル、1.0 でターゲットのスタイルに近づきます。<br> AivisSpeech Engine では話者ごとに発声タイミングが異なる関係で実装不可能なため (動作こそするが聴くに耐えない) 、 常に 400 Bad Request を返します。
     * 2種類のスタイルでモーフィングした音声を合成する
     */
    async synthesisMorphingSynthesisMorphingPostRaw(requestParameters: SynthesisMorphingSynthesisMorphingPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Blob>> {
        if (requestParameters.baseSpeaker === null || requestParameters.baseSpeaker === undefined) {
            throw new runtime.RequiredError('baseSpeaker','Required parameter requestParameters.baseSpeaker was null or undefined when calling synthesisMorphingSynthesisMorphingPost.');
        }

        if (requestParameters.targetSpeaker === null || requestParameters.targetSpeaker === undefined) {
            throw new runtime.RequiredError('targetSpeaker','Required parameter requestParameters.targetSpeaker was null or undefined when calling synthesisMorphingSynthesisMorphingPost.');
        }

        if (requestParameters.morphRate === null || requestParameters.morphRate === undefined) {
            throw new runtime.RequiredError('morphRate','Required parameter requestParameters.morphRate was null or undefined when calling synthesisMorphingSynthesisMorphingPost.');
        }

        if (requestParameters.audioQuery === null || requestParameters.audioQuery === undefined) {
            throw new runtime.RequiredError('audioQuery','Required parameter requestParameters.audioQuery was null or undefined when calling synthesisMorphingSynthesisMorphingPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.baseSpeaker !== undefined) {
            queryParameters['base_speaker'] = requestParameters.baseSpeaker;
        }

        if (requestParameters.targetSpeaker !== undefined) {
            queryParameters['target_speaker'] = requestParameters.targetSpeaker;
        }

        if (requestParameters.morphRate !== undefined) {
            queryParameters['morph_rate'] = requestParameters.morphRate;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/synthesis_morphing`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: AudioQueryToJSON(requestParameters.audioQuery),
        }, initOverrides);

        return new runtime.BlobApiResponse(response);
    }

    /**
     * 指定された 2 種類のスタイルで音声を合成、指定した割合でモーフィングした音声を得ます。<br> モーフィングの割合は `morph_rate` で指定でき、0.0 でベースのスタイル、1.0 でターゲットのスタイルに近づきます。<br> AivisSpeech Engine では話者ごとに発声タイミングが異なる関係で実装不可能なため (動作こそするが聴くに耐えない) 、 常に 400 Bad Request を返します。
     * 2種類のスタイルでモーフィングした音声を合成する
     */
    async synthesisMorphingSynthesisMorphingPost(requestParameters: SynthesisMorphingSynthesisMorphingPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Blob> {
        const response = await this.synthesisMorphingSynthesisMorphingPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * 指定されたスタイル ID に紐づく音声合成モデルを用いて音声合成を行います。
     * 音声合成する
     */
    async synthesisSynthesisPostRaw(requestParameters: SynthesisSynthesisPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Blob>> {
        if (requestParameters.speaker === null || requestParameters.speaker === undefined) {
            throw new runtime.RequiredError('speaker','Required parameter requestParameters.speaker was null or undefined when calling synthesisSynthesisPost.');
        }

        if (requestParameters.audioQuery === null || requestParameters.audioQuery === undefined) {
            throw new runtime.RequiredError('audioQuery','Required parameter requestParameters.audioQuery was null or undefined when calling synthesisSynthesisPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.speaker !== undefined) {
            queryParameters['speaker'] = requestParameters.speaker;
        }

        if (requestParameters.enableInterrogativeUpspeak !== undefined) {
            queryParameters['enable_interrogative_upspeak'] = requestParameters.enableInterrogativeUpspeak;
        }

        if (requestParameters.coreVersion !== undefined) {
            queryParameters['core_version'] = requestParameters.coreVersion;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/synthesis`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: AudioQueryToJSON(requestParameters.audioQuery),
        }, initOverrides);

        return new runtime.BlobApiResponse(response);
    }

    /**
     * 指定されたスタイル ID に紐づく音声合成モデルを用いて音声合成を行います。
     * 音声合成する
     */
    async synthesisSynthesisPost(requestParameters: SynthesisSynthesisPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Blob> {
        const response = await this.synthesisSynthesisPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * 指定された音声合成モデルをアンインストールします。
     * 指定された音声合成モデルをアンインストールする
     */
    async uninstallAivmAivmModelsAivmUuidUninstallDeleteRaw(requestParameters: UninstallAivmAivmModelsAivmUuidUninstallDeleteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.aivmUuid === null || requestParameters.aivmUuid === undefined) {
            throw new runtime.RequiredError('aivmUuid','Required parameter requestParameters.aivmUuid was null or undefined when calling uninstallAivmAivmModelsAivmUuidUninstallDelete.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/aivm_models/{aivm_uuid}/uninstall`.replace(`{${"aivm_uuid"}}`, encodeURIComponent(String(requestParameters.aivmUuid))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * 指定された音声合成モデルをアンインストールします。
     * 指定された音声合成モデルをアンインストールする
     */
    async uninstallAivmAivmModelsAivmUuidUninstallDelete(requestParameters: UninstallAivmAivmModelsAivmUuidUninstallDeleteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.uninstallAivmAivmModelsAivmUuidUninstallDeleteRaw(requestParameters, initOverrides);
    }

    /**
     * 指定された音声合成モデルをアンロードします。
     * 指定された音声合成モデルをアンロードする
     */
    async unloadAivmAivmModelsAivmUuidUnloadPostRaw(requestParameters: UnloadAivmAivmModelsAivmUuidUnloadPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.aivmUuid === null || requestParameters.aivmUuid === undefined) {
            throw new runtime.RequiredError('aivmUuid','Required parameter requestParameters.aivmUuid was null or undefined when calling unloadAivmAivmModelsAivmUuidUnloadPost.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/aivm_models/{aivm_uuid}/unload`.replace(`{${"aivm_uuid"}}`, encodeURIComponent(String(requestParameters.aivmUuid))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * 指定された音声合成モデルをアンロードします。
     * 指定された音声合成モデルをアンロードする
     */
    async unloadAivmAivmModelsAivmUuidUnloadPost(requestParameters: UnloadAivmAivmModelsAivmUuidUnloadPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.unloadAivmAivmModelsAivmUuidUnloadPostRaw(requestParameters, initOverrides);
    }

    /**
     * AivisHub から指定された音声合成モデルの一番新しいバージョンをダウンロードし、 インストール済みの音声合成モデルへ上書き更新します。
     * 指定された音声合成モデルを更新する
     */
    async updateAivmAivmModelsAivmUuidUpdatePostRaw(requestParameters: UpdateAivmAivmModelsAivmUuidUpdatePostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.aivmUuid === null || requestParameters.aivmUuid === undefined) {
            throw new runtime.RequiredError('aivmUuid','Required parameter requestParameters.aivmUuid was null or undefined when calling updateAivmAivmModelsAivmUuidUpdatePost.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/aivm_models/{aivm_uuid}/update`.replace(`{${"aivm_uuid"}}`, encodeURIComponent(String(requestParameters.aivmUuid))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * AivisHub から指定された音声合成モデルの一番新しいバージョンをダウンロードし、 インストール済みの音声合成モデルへ上書き更新します。
     * 指定された音声合成モデルを更新する
     */
    async updateAivmAivmModelsAivmUuidUpdatePost(requestParameters: UpdateAivmAivmModelsAivmUuidUpdatePostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.updateAivmAivmModelsAivmUuidUpdatePostRaw(requestParameters, initOverrides);
    }

    /**
     * 既存のプリセットを更新します。
     * 既存のプリセットを更新する
     */
    async updatePresetUpdatePresetPostRaw(requestParameters: UpdatePresetUpdatePresetPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<number>> {
        if (requestParameters.preset === null || requestParameters.preset === undefined) {
            throw new runtime.RequiredError('preset','Required parameter requestParameters.preset was null or undefined when calling updatePresetUpdatePresetPost.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/update_preset`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: PresetToJSON(requestParameters.preset),
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<number>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * 既存のプリセットを更新します。
     * 既存のプリセットを更新する
     */
    async updatePresetUpdatePresetPost(requestParameters: UpdatePresetUpdatePresetPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<number> {
        const response = await this.updatePresetUpdatePresetPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * テキストが AquesTalk 風記法に従っているかどうかを判定します。 従っていない場合はエラーが返ります。
     * テキストが AquesTalk 風記法に従っているか判定する
     */
    async validateKanaValidateKanaPostRaw(requestParameters: ValidateKanaValidateKanaPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<boolean>> {
        if (requestParameters.text === null || requestParameters.text === undefined) {
            throw new runtime.RequiredError('text','Required parameter requestParameters.text was null or undefined when calling validateKanaValidateKanaPost.');
        }

        const queryParameters: any = {};

        if (requestParameters.text !== undefined) {
            queryParameters['text'] = requestParameters.text;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/validate_kana`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<boolean>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * テキストが AquesTalk 風記法に従っているかどうかを判定します。 従っていない場合はエラーが返ります。
     * テキストが AquesTalk 風記法に従っているか判定する
     */
    async validateKanaValidateKanaPost(requestParameters: ValidateKanaValidateKanaPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<boolean> {
        const response = await this.validateKanaValidateKanaPostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * エンジンのバージョンを取得します。
     * Version
     */
    async versionVersionGetRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<string>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/version`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        if (this.isJsonMime(response.headers.get('content-type'))) {
            return new runtime.JSONApiResponse<string>(response);
        } else {
            return new runtime.TextApiResponse(response) as any;
        }
    }

    /**
     * エンジンのバージョンを取得します。
     * Version
     */
    async versionVersionGet(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<string> {
        const response = await this.versionVersionGetRaw(initOverrides);
        return await response.value();
    }

}

/**
 * @export
 */
export const SingerInfoSingerInfoGetResourceFormatEnum = {
    Base64: 'base64',
    Url: 'url'
} as const;
export type SingerInfoSingerInfoGetResourceFormatEnum = typeof SingerInfoSingerInfoGetResourceFormatEnum[keyof typeof SingerInfoSingerInfoGetResourceFormatEnum];
/**
 * @export
 */
export const SpeakerInfoSpeakerInfoGetResourceFormatEnum = {
    Base64: 'base64',
    Url: 'url'
} as const;
export type SpeakerInfoSpeakerInfoGetResourceFormatEnum = typeof SpeakerInfoSpeakerInfoGetResourceFormatEnum[keyof typeof SpeakerInfoSpeakerInfoGetResourceFormatEnum];
