# よくある質問 / Q&A

## 動作環境・仕様に関する質問

### Q. 動作環境を教えてください。

Windows・macOS 搭載の PC に対応しています。  
AivisSpeech を起動するには、PC に 1.5GB 以上の空きメモリ (RAM) が必要です。

- **Windows:** Windows 10 (22H2 以降)・Windows 11  
- **macOS:** macOS 13 Ventura 以降

> [!NOTE]
> Intel CPU 搭載 Mac での動作は積極的に検証していません。  
> Intel CPU 搭載 Mac はすでに製造が終了しており、検証環境やビルド環境の用意自体が難しくなってきています。なるべく Apple Silicon 搭載 Mac での利用をおすすめいたします。

> [!WARNING]
> Windows 10 では、バージョン 22H2 での動作確認のみ行っています。  
> **サポートが終了した Windows 10 の古いバージョンでは、AivisSpeech Engine がクラッシュし起動に失敗する事例が報告されています。**  
> セキュリティ上の観点からも、Windows 10 環境の方は、最低限バージョン 22H2 まで更新してからの利用を強くおすすめいたします。

## インストールに関する質問

### Q. インストーラーをダウンロードできません。

ブラウザのセキュリティ機能によって、ファイルをダウンロードして保存するときに、プログラムの安全性にかかる警告が表示されることがあります。以下の手順に従ってダウンロードを完了してください。

#### 「安全にダウンロードすることはできません」メッセージが表示された場合

1. 画面右上の「安全にダウンロードすることはできません」にマウスポインターを合わせます。
2. 「•••」→「保存」ボタンの順にクリックします。
3. Aivis Project 公式サイトからダウンロードしたインストーラーなど、安全性が確認できる場合は、「保持する」ボタンをクリックします。  
   Aivis Project 公式サイトからダウンロードするインストーラーなどでも「発行元」に「不明」と表示されることがあります。  
   「不明」と表示されても、安全性が確認できる場合は保存してください。

#### 「一般的にダウンロードされていません」または「お使いのデバイスに問題を起こす可能性があるため、ブロックされました」というメッセージが表示された場合

1. 画面右上の「一般的にダウンロードされていません」または「お使いのデバイスに問題を起こす可能性があるため、ブロックされました」にマウスポインターを合わせます。
2. 「•••」→「保存」ボタンの順にクリックします。
3. 「ダウンロードしているファイルまたはそのソースが信頼できることを確認してから、ファイルを開いてください。」と表示されます。「詳細表示」をクリックします。
4. Aivis Project 公式サイトからダウンロードしたインストーラーなど、安全性が確認できる場合は、「保持する」をクリックします。  
   Aivis Project 公式サイトからダウンロードするインストーラーなどでも「発行元」に「不明」と表示されることがあります。  
   「不明」と表示されても、安全性が確認できる場合は保存してください。

### Q. オフラインの PC でも利用できますか？

AivisSpeech をはじめて起動するときのみ、モデルデータのダウンロードのため、インターネットアクセスが必要になります。  
2回目以降の起動では、PC がオフラインでもお使いいただけます。

### Q. インストール時・起動時に「Windows によって PC が保護されました」「開発元が検証できないため開けません」「悪質なソフトウェアであるかどうかを Apple では確認できないため、このソフトウェアは開けません」と表示されます。

AivisSpeech は、いち早くユーザーのみなさんにお届けするため、現時点ではコード署名（プログラムの正当性を証明する電子署名）を行えていない状況です。  
そのため、インストーラーやソフトウェアの起動時に、上のような警告やエラーが表示されることがあります。  
特に [macOS Sequoia 以降ではセキュリティが強化された](https://applech2.com/archives/20240807-apple-gatekeeper-update-in-macos-15-sequoia.html) 関係で、従来の手順では起動できないことがあります。

AivisSpeech は安全なソフトウェアですので、以下の手順で起動を進めていただけますと幸いです。

- **Windows:** 「詳細情報」→「実行」をクリック
- **Mac:** 一度「キャンセル」or「OK」or「完了」をクリックしポップアップを閉じた後、「システム環境設定」→「セキュリティとプライバシー」→「このまま開く」をクリック
  - 「ダウンロードしたアプリケーションの実行許可」は「AppStoreと確認済みの開発元からのアプリケーションを許可」または「すべてのアプリを許可」に設定されている必要があります。

将来的にはコード署名を適用し、起動時の警告やエラーが表示されないよう対応を進めてまいります。  
詳しい手順は [こちら (外部リンク)](https://qiita.com/suzukidog/items/f0e71297ec5307b473fd) の記事をご覧ください。

### Q. 初めて起動したのですが、ずっと「音声合成エンジン起動中...」と表示されます。

AivisSpeech は初回起動時に必要なモデルデータをダウンロードするため、起動完了まで数分程度かかります。  
これは初回のみの動作ですので、そのままお待ちいただければ自動的に起動が完了します。  
起動に失敗してしまった場合は、一度ウインドウを閉じてから再度起動してみてください。多くの場合はこれで正常に起動できるようになります。

なお、インターネットに接続されていない場合や、社内ネットワークなどの特殊なネットワーク環境では、モデルデータのダウンロードができずに起動に失敗することがあります。  
その場合はインターネット接続を確認してから、もう一度起動をお試しください。  
HTTP プロキシを経由している場合もダウンロードに失敗することがあるようです。一度 HTTP プロキシを無効化してから再度お試しください。

### Q. インストール先のフォルダはどこですか？

デフォルトのインストール先は下記の場所です。

#### Windows 版のインストール先

`C:\Users\(ユーザー名)\AppData\Local\Programs\AivisSpeech` もしくは `C:\Program Files\AivisSpeech`

#### Mac 版のインストール先

`/Applications/AivisSpeech` もしくは `/Users/(ユーザー名)/Applications/AivisSpeech`

### Q. アップデート方法を教えてください。

ホームページから最新版を再インストールすることでアップデートできます。

### Q. 過去のバージョンに戻すことはできますか？

[こちら](https://github.com/Aivis-Project/AivisSpeech/releases) から過去のバージョンを入手できます。

## 使い方に関する質問

### Q. 「スタイルの強さ」の値を上げると発声がおかしくなります。

AivisSpeech で対応している、Style-Bert-VITS2 モデルアーキテクチャの現時点での仕様になります。  
話者やスタイルにもよりますが、「スタイルの強さ」を上げすぎると発声がおかしくなったり、棒読みで不自然な声になる場合もあります。  

ちゃんと発声できる「スタイルの強さ」の上限は、話者やスタイルによって異なります。最適な値に適宜調整してください。

### Q. 読み方が想定と異なります。

AivisSpeech ではなるべく一発で正しい読み・正しいアクセントになるよう処理を工夫していますが、どうしても間違った読み・アクセントになる場合もあります。  
あまり使われない固有名詞や人名（特にキラキラネーム）など、内蔵辞書に登録されていない単語は、正しい読みにならないことが多いです。  

こうした単語の読み方は辞書登録で変更できます。設定 → 読み方＆アクセント辞書 から単語を登録してみてください。  
なお、複合語や英単語に関しては、単語の優先度にかかわらず、辞書への登録内容が反映されないことがあります。これは現時点での仕様になります。

また、画面下部「アクセント」欄に表示されているカタカナをクリックすると、単語ごとに個別に読みを変更できます。  
辞書登録するほど頻出しないが、個別に読みを変更したい場合はこちらをお試しください。

### Q. 辞書をインポート／エクスポートしたいです。

起動中の音声合成エンジンの設定画面で行えます。

ソフトウェア起動中にブラウザから `http://127.0.0.1:[音声合成エンジンのポート番号]/setting` にアクセスすると音声合成エンジンの設定画面が開きます。  
AivisSpeech Engine のポート番号のデフォルトは `10101` です。

### Q. クレジット表記は必要ですか？

AivisSpeech は、利用用途を束縛されない、自由な AI 音声合成ソフトウェアを目指しています。  
（成果物で使った音声合成モデルのライセンス次第ではありますが）少なくともソフトウェア本体はクレジット表記不要で、個人・法人・商用・非商用を問わず、自由にお使いいただけます。

…とはいえ、より多くの方に AivisSpeech のことを知っていただきたい気持ちもあります。  
もしよければ、成果物のどこかに AivisSpeech のことをクレジットしていただけると嬉しいです。（クレジットの表記フォーマットはお任せします。）

## 不具合・エラーに関する質問

### Q. 不具合を見つけました。どこに報告すれば良いですか？

不具合を見つけられた方は、以下のいずれかの方法でご報告ください。

1. **GitHub Issue (推奨)**  
   GitHub アカウントをお持ちの方は、[GitHub の Issue](https://github.com/Aivis-Project/AivisSpeech/issues) からご報告いただけますと、早期の対応が可能です。

2. **Twitter (X)**  
   [Aivis Project 公式アカウント](https://x.com/aivis_project) へのリプライや DM、またはハッシュタグ [#AivisSpeech](https://x.com/search?q=%23AivisSpeech&src=typed_query) を付けたツイートでご報告いただけます。

3. **お問い合わせフォーム**  
   [Aivis Project お問い合わせフォーム](https://docs.google.com/forms/d/e/1FAIpQLSd1gi8lMW1mpdrkCHbM090pWmWhKgz4tR1Obc9G9hOuWpZPsA/viewform) からもご報告いただけます。

なるべく以下の情報を添えてご報告いただけますと、より迅速な対応が可能です。

- 不具合の内容
- 再現手順（動画や写真があれば添付してください）
- OS の種類・AivisSpeech のバージョン
- 解決のために試されたこと
- ウイルス対策ソフトなどの有無（関係がありそうであれば）
- 表示されたエラーメッセージ
- エラーログ

### Q. バージョンアップすると表示がおかしくなりました。

設定がなにか問題を起こしている可能性があります。ソフトウェアを終了して後述のパスにある設定ファイルを消去してもう一度起動してみてください。

#### Windows 版の設定ファイル

`C:\Users\(ユーザー名)\AppData\Roaming\AivisSpeech\config.json`

#### Mac 版の設定ファイル

`/Users/(ユーザー名)/Library/Application Support/AivisSpeech/config.json`

### Q. GPU モードに切り替えたのに音声生成が CPU モードよりも遅いです。

**CPU 内蔵の GPU (iGPU) のみの PC でも GPU モードは使えますが、ほとんどの場合 CPU モードよりかなり遅くなってしまうため、おすすめできません。**

これは、CPU 内蔵の GPU は独立した GPU (dGPU) に比べて性能が低く、AI 音声合成のような重い処理が苦手なためです。  
一方で、最近の CPU は性能が大幅に向上しており、CPU だけでも十分高速に音声を生成できます。  
そのため、dGPU 非搭載の PC では CPU モードの利用をおすすめします。

### Q. 音声生成時、Intel 第 12 世代以降の CPU でフル性能を発揮できない。

Intel の第 12 世代以降の CPU（P コア・E コアのハイブリッド構成）搭載 PC をお使いの場合、Windows の電源設定によって音声生成の性能が大きく変わることがあります。  
これは、デフォルトの「バランス」モードでは、音声生成タスクが省電力重視の E コアに割り当てられやすいためです。

以下の手順で設定を変更すると、P コアと E コアの両方を最大限活用し、音声生成をより高速に行えます。

1. Windows 11 の設定を開く
2. システム → 電源 と進む
3. 「電源モード」を「最適なパフォーマンス」に変更する

※ コントロールパネル内「電源プラン」にも「高パフォーマンス」設定がありますが、設定内容が異なります。  
Intel 第 12 世代以降の CPU では、Windows 11 の設定画面からの「電源モード」の変更をおすすめします。

### Q. 起動すると「音声合成エンジンの起動に失敗しました」というエラーが表示されます

AivisSpeech を起動するには、PC に 1.5GB 以上の空きメモリ (RAM) が必要です。  
PC の空きメモリが不足している環境では、音声合成エンジンの起動に失敗することがあります。

また、ウイルス対策ソフトが音声合成エンジン (run.exe) を不正なプログラムと誤って判断し、通常の保存場所から隔離したことが原因の可能性もあります。  
ウイルス対策ソフトの設定から、run.exe を許可リストに追加いただけますと幸いです。

このほか、以前起動した音声合成エンジンが正常に停止されずに残っているかもしれません。その場合は PC の再起動をお試しください。

それでも音声合成エンジンの起動に失敗する場合は、[お問い合わせフォーム](https://forms.gle/sTsZGfX7aR8ox8Rs7) からご連絡ください。  
お問い合わせいただく前に、一度 PC や OS が対応環境かをご確認いただけますと幸いです。

### Q. GPU モードで起動するとエラーが表示されます。

対応する GPU が搭載されていない PC で GPU モードとして起動すると、まれにエラーが発生する場合があります。  
設定 → 音声合成エンジンから CPU モードを選んでください。

### Q. 音声が再生されません。

音声の再生デバイスがいつもお使いのものが設定されていないかもしれません。  
設定 → 高度な設定 → 再生デバイス よりご確認ください。

音声合成エンジンの GPU モードで起動された場合は、設定 → 音声合成エンジンから CPU モードを選んで再度お試しください。

### Q. エラーログはどこで確認できますか？

ヘルプ → お問い合わせ → 「ログフォルダを開く」ボタンをクリックすると、ログの保存先フォルダが開きます。  
具体的には、以下のフォルダに保存されています。

#### Windows 版

`C:\Users\(ユーザー名)\AppData\Roaming\AivisSpeech\logs`

#### Mac 版

`/Users/(ユーザー名)/Library/Logs/AivisSpeech`

### Q. 音声合成エンジンのエラーログはどこで確認できますか？

ヘルプ → お問い合わせ → 「音声合成エンジンのログフォルダを開く」ボタンをクリックすると、音声合成エンジンのログの保存先フォルダが開きます。  
具体的には、以下のフォルダに保存されています。

#### Windows 版

`C:\Users\(ユーザー名)\AppData\Roaming\AivisSpeech-Engine\Logs`

#### Mac 版

`/Users/(ユーザー名)/Library/Application Support/AivisSpeech-Engine/Logs`

## その他

### Q. 問い合わせ先を教えてください。

ご感想・ご要望は、ぜひ Twitter (X) にてハッシュタグ `#AivisSpeech` を付けてツイートしてください。開発の励みになります。

うまく動かない場合や不具合を見つけられた方は、Twitter (X) にて不具合をハッシュタグ `#AivisSpeech` を付けてツイートしていただくか、Aivis Project 公式 ([@aivis_project](https://twitter.com/aivis_project)) までご報告ください。  
[Aivis Project お問い合わせフォーム](https://docs.google.com/forms/d/e/1FAIpQLSd1gi8lMW1mpdrkCHbM090pWmWhKgz4tR1Obc9G9hOuWpZPsA/viewform) からご報告いただくことも可能です。

その他、 Q&A に掲載されていないご質問があれば Aivis Project 公式 ([@aivis_project](https://twitter.com/aivis_project)) または上記のお問い合わせフォームからご連絡ください。
