# 使い方

## 起動方法

### Windows 版

起動しようとすると「Windows によって PC が保護されました」というダイアログが表示されるかもしれません。その際は「実行」をクリックしてください。

### Mac 版

初回起動時は Apple に登録されていないアプリケーションとして警告ダイアログが表示されるかもしれません。

その際は Finder で `Ctrl` キーを押しながら AivisSpeech アプリケーションアイコンをクリックし、ショートカットメニューから「開く」を選択してから、「開く」をクリックしてください。  
もしくは、「システム設定」→「プライバシーとセキュリティ」 から、ページの下にある「このまま開く」をクリックしてください。

macOS Sequoia 以降をお使いで「Mac に損害を与えたり、プライバシーを侵害する可能性のあるマルウェアが含まれていないことを確認できませんでした」と表示される方は、[こちらの記事](https://qiita.com/suzukidog/items/f0e71297ec5307b473fd) を参考に、アプリケーションの実行を許可してください。

#### Apple Silicon 搭載の Mac をお使いの場合

初めて AivisSpeech を起動する際に Rosetta のインストールを促される場合は、案内に従ってインストールしてください。

<img src="res/macos-big-sur-software-update-rosetta-alert.jpg" style="max-height: 12rem" alt="Rosettaのインストールを確認するダイアログ"/>

</details>

## 音声合成エンジンの起動

最初に音声合成エンジンが起動します。  
dGPU 搭載の PC をお持ちの方は、音声の生成がずっと速い GPU モードを快適にご利用いただけます。

<img src="res/image4.png" style="max-height: 6rem" alt="音声合成エンジンを起動している様子" />

## 音声の生成・再生

話者アイコンの右にある空白をクリックしてテキストを入力してみてください。

<img src="res/image19.png" style="max-height: 12rem" alt="話者アイコンの右にある空白" />

`Enter` キーを押して文章を確定すると、画面の下の方に読みとアクセントが表示されます。（１回目は反映まで数秒ほど時間がかかることがあります。）

<img src="res/image6.png" style="max-height: 16rem" alt="画面の下の方に読みとアクセントが表示された様子"/>

再生ボタンを押すと音声が生成され、音声が再生されます。

## 文章の追加・削除

右下の＋ボタンを押すとテキスト欄が増え、複数の文章を並べることができます。

<img src="res/image10.png" style="max-height: 12rem" alt="テキスト欄が増えた様子" />

テキスト欄にマウスカーソルを合わせると出てくるゴミ箱のボタンで、そのテキスト欄を削除できます。

## 話者の変更

テキスト入力欄の左にあるアイコンをクリックすると、テキストを読み上げてくれる話者を変更できます。

<img src="res/image7.png" style="max-height: 10rem" alt="左にあるアイコンをクリックしてほかの話者アイコンが表示されている様子"/>

話者の表示順序は「設定」→「話者リスト」→「話者の並び替え」から変更できます。

## テキスト欄の並び替え

テキスト欄周辺をドラッグすることで、テキスト欄の順番を並び替えられます。

## 単語の接続変更

意図しない箇所で単語が分離していた場合や、意図しない形で結合してしまっている場合は、アクセント項目で文字の間をクリックすることで修正できます。

例えば「ディープラーニング」がこのように分かれてしまった場合は、

<img src="res/image9.png" style="max-height: 12rem" alt="「ディープラーニング」が「ディープ」と「ラーニング」に分かれた様子"/>

２つの隙間をクリックすると

<img src="res/image3.png" style="max-height: 8rem" alt="「ディープ」と「ラーニング」の間にマウスカーソルを合わせている様子。マウスカーソルが当たっている部分が青色になります"/>

このように１語にまとめることができます。

<img src="res/image8.png" style="max-height: 7rem" alt="「ディープ」と「ラーニング」が「ディープラーニング」の１語にまとまった様子"/>

逆に切り離したい場合は、文字の間をクリックして切り離すことができます。

<img src="res/image13.png" style="max-height: 7rem" alt="「ディープ」と「ラーニング」の間にマウスカーソルを合わせている様子。マウスカーソルが当たっている部分が青色になります"/>

## アクセントの変更

アクセント箇所を変えるには、読みの上にあるバーを左右に動かします。  
例えば「ディープラーニング」を「↑ ディープラ ↓ アニング」と読んでほしい場合は、「ラ」の位置まで丸をスライドします。

<img src="res/image8.png" style="max-height: 7.5rem" alt="「ディープラーニング」" /> → <img src="res/image1.png" style="max-height: 8rem" alt="「↑ ディープラ ↓ アニング」" />

## パラメータの変更

画面の右の欄で、テキスト欄ごとに話速やスタイルの強さなどのパラメータを変更できます。

<img src="res/image24.png" style="max-height: 12rem" alt="右側にパラメータを調整する欄が表示されています。"/>

- 話速
  - 話す速さを調整できます。数値が大きいほど速くなります。
  - 2.00 で 2 倍速、0.50 で 0.5 倍速になります。
- スタイルの強さ
  - 話者スタイルの声色の強弱を調整できます。数値が大きいほどそのスタイルに近い抑揚がついた声になります。
    - 例えば話者スタイルが「うれしい」なら、数値を大きくするとより嬉しそうな明るい話し方になります。
    - 一方、話者やスタイルによっては、数値を上げすぎると発声がおかしくなったり、棒読みで不自然な声になる場合もあります。
      - 「ちゃんと発声できるスタイルの強さの上限」は、話者やスタイルによって異なります。適宜調整してください。
  - 全スタイルの平均であるノーマルスタイルには設定できません。
  - AivisSpeech Engine 以外の音声合成エンジン (VOICEVOX ENGINE など) 利用時は「抑揚」の調整パラメータになります。
- テンポの緩急
  - 話す速さの緩急の強弱を調整できます。数値が大きいほどより早口で生っぽい抑揚がついた声になります。
  - AivisSpeech Engine 以外の音声合成エンジン (VOICEVOX ENGINE など) には設定できません。
- 音高
  - 声の高さを調整できます（変更すると音質が劣化します）。数値が大きいほど声のトーンが高くなります。
  - 音声合成処理後に後付けで音高を変更しているため、0.00 から変更すると音質が劣化します。
    - AivisSpeech Engine 以外の音声合成エンジン (VOICEVOX ENGINE など) ではこの限りではありません（各音声合成エンジンの実装依存）。
- 音量
  - 声の大きさ（音量）を調整できます。数値が大きいほど声が大きくなります。
- 開始無音・終了無音
  - 音声先頭・末尾の無音時間の長さを秒単位で調整できます。数値が大きいほど無音時間が長くなります。

## 読みの修正

読みが思っているものと違う場合は、アクセント欄で読みをクリックすることで後から修正することもできます。  
テキスト欄と同様に、ひらがなや句読点、漢字も入力できます。

<img src="res/image20.png" style="max-height: 12rem" alt="アクセント欄で読みをクリックした様子。修正したいテキストが表示されたテキストボックスが表示されています。テキストボックスの内容を書き換えることで読みを修正できます。"/>

修正箇所以外の調整結果はそのままなので、調整結果を維持したままテキストを修正したいときにも便利です。

## スタイルの変更

話者によっては複数のスタイル（喋り方）を変えることができます。話者の変更と同様に、テキスト欄左のアイコンから選択できます。

<img src="res/image21.png" style="max-height: 12rem" alt="話者のアイコンをクリックすると別の話者アイコンが表示されている様子"/>

話者を選択したときに適用されるスタイルは、設定の「デフォルトスタイル」で変更できます。

## 音声を途中から再生

アクセント区間をクリックすることで、その区間から音声を再生できます。もう一度クリックすると解除できます。

<img src="res/image23.png" style="max-height: 7rem" alt="アクセント区間をクリックした様子。クリックされたアクセント区間が青色になっています。"/>

## 音声ファイルの書き出し

メニューにある「ファイル」の「音声書き出し」ボタンを押すと、全テキスト欄の音声が WAV ファイルとして書き出されます。

ファイル保存時、ファイル名は `[何行目]_[話者名]_[テキスト冒頭].wav` として保存されます。  
設定でテキストファイルも一緒に書き出すこともできます。ファイル名は設定の「書き出しファイル名パターン」で変更できます。

## テキストファイルの読み込み

読み込みボタンを押すと、テキストファイルを読み込めます。  
テキストは改行または半角コンマ（,）で区切ることで分割できます。  
また、話者名だけで区切ることで、その話者として読み込むことができます。

例えばこのようなテキストを読み込むと、

```txt
Anneli,おはようございます,こんにちは
JVNV-F1,こんばんは
Anneli​（上機嫌）,さようなら
```

このように読み込まれます。

<img src="res/image17.png" style="max-height: 10rem" alt="テキストが読み込まれた様子"/>

スタイル名が指定されていない場合は、デフォルトスタイルのスタイルが適用されます。

## テキストをつなげて書き出し

メニュー「ファイル」の「テキストをつなげて書き出し」ボタンで、すべてのテキストを書き出すことができます。  
テキストは話者名も一緒に保存され、上の「テキストファイルの読み込み」で読み込むこともできます。

## プロジェクトファイルの保存・読み込み

入力したテキストや話者、アクセント修正やイントネーションの調整結果は、プロジェクトファイルとして保存し、ソフトウェアを起動し直した後で読み込むことができます。  
プロジェクトファイルの拡張子は `.aisp` です。

## 話者リスト

「設定」の「話者リスト」から、AivisSpeech で利用できるすべての話者のリストを確認できます。
また、話者の表示順序を変更したり、サンプルボイスを試聴することもできます。

## デフォルトスタイル

「設定」の「デフォルトスタイル」で、話者ごとのデフォルトのスタイルを変更できます。

## 読み方＆アクセント辞書

難しい単語や新しい単語は正しい読みにならないことがありますが、辞書機能を使って読み方を登録しておくことができます。  
辞書機能は「設定」の「読み方＆アクセント辞書」で利用できます。

読み方＆アクセント辞書画面を開くと、左に登録した単語のリストが表示されます。  
「追加」ボタンで新規に単語を登録できます。

<img src="res/dict01.png" style="max-height: 17rem" alt="読み方＆アクセント辞書の単語リスト画面"/>

「単語」に登録したいテキストを、「読み」にそのテキストの読み方をひらがなかカタカナで入力してください。  
「アクセント調整」で自然になるアクセントを登録できます。  
もし登録した単語が反映されない場合は、「単語優先度」を上げてみてください。

<img src="res/dict02.png" style="max-height: 17rem" alt="単語と読みとアクセントの登録画面"/>

## ツールバーのカスタマイズ

ボタンをドラッグすることにより、画面上部にあるツールバーのボタンの種類や配置を変更できます。

<img src="res/toolbar-customize.png" style="max-height: 18rem" alt="ツールバーカスタマイズ画面"/>

## ショートカットキー

「設定」の「キー割り当て」でショートカットキーを表示・変更できます。  
（Mac 版をご利用の場合は Ctrl を Command に、Alt を Option に読み替えてください。）

- 上下キー
  - 上下のテキスト欄に移動
- `Space`
  - 音声を再生
- `Shift` + `Enter`
  - テキスト欄を追加
- `Shift` + `Delete`
  - テキスト欄を消去
- `Ctrl` + `S`
  - プロジェクトの保存
- `Ctrl` + `E`
  - 音声を書き出し
- `Ctrl` + `Z`
  - 元に戻す
- `Ctrl` + `Y`
  - やり直す
- `Ctrl` + `+`
  - 拡大
- `Ctrl` + `-`
  - 縮小
- `Esc`
  - テキスト欄からカーソルを外す
- スライダーの上でマウスホイール
  - スライダーの値を変更します（スライダー →<img src="res/image16.png" style="max-height: 1rem" alt="スライダー、緑色の棒"/>）
  - `Ctrl` キーを押しながらマウスホイールを使うと更に細かく調整できます
- `Ctrl` + 数字
  - 数字番目のキャラクターを選択

## オプション

「設定」の「オプション」でいろいろな設定を変更できます。

### 「音声合成エンジン」項目

音声合成エンジンの起動モードの起動モードを変更できます。

#### エンジンモード

- **Windows**: GPU モードの利用には dGPU 搭載の PC が必要です。
  - 推論処理には [DirectML](https://github.com/microsoft/DirectML) を利用しています。
  - **CPU 内蔵の GPU (iGPU) のみの PC でも GPU モードは使えますが、ほとんどの場合 CPU モードよりかなり遅くなってしまうため、おすすめできません。**
- **Mac**: GPU モードはサポートされていませんが、CPU モードでも十分高速に動作します。
- **Linux**: GPU モードの利用には CUDA がインストールされた、NVIDIA GPU 搭載の PC が必要です。

#### 音声のサンプリングレート

音声のサンプリングレートを変更して再生・保存します。  
サンプリングレートを高くしても音声の品質は上がりません。

### 「操作」項目

#### プリセット機能

話速やテンポの緩急などのパラメータをまとめて登録できるプリセット機能を利用できるようになります。ソフトウェアが終了しても設定したプリセットは残ります。  
プリセットを再登録する際、同じプリセットを割り当てているテキスト欄のパラメータを一括で変更することもできます。

スタイルごとに１つデフォルトプリセットが用意されています。

#### スタイル変更時にデフォルトプリセットを適用

プリセット機能をオンにしている場合、スタイルを変更したときにデフォルトプリセットを自動的に適用するようになります。

#### パラメータの引き継ぎ

テキスト欄を追加する際、話速やテンポの緩急といったパラメータを引き継ぐようになります。

#### 再生位置を追従

再生中の単語が画面内に収まるよう、自動的にスクロールして追従するようになります。

#### テキスト自動分割

テキストを貼り付ける時、句点や改行でテキストを分割するかの挙動を変更できます。

#### メモ機能

テキストを `[]` で囲むことで、テキスト中にメモを書けます。半角の `[]` と全角の `［］` のどちらにも対応しています。

#### ルビ機能

テキストに `{ルビ対象|よみかた}` と書くことでテキストの読み方を変えられるようになります。  
半角の `{|}` と全角の `｛｜｝` のどちらにも対応しています。書き出しテキストを変えずに読み方を変えたいときに便利です。

### 「保存」項目

#### 書き出し先を固定

音声ファイルを書き出すフォルダを固定し、毎回フォルダを選択しなくても同じフォルダに書き出し続けるようにします。

#### 書き出しファイル名パターン

音声やテキストファイルなどを書き出す際のファイル名をカスタマイズできます。

#### 上書き防止

同じファイル名のファイルがあった場合に連番として保存します。

#### 文字コード

読み込み・書き込み用の文字コードを選択できます。

#### txt ファイルを書き出し

テキスト内容を一緒に保存します。

#### lab ファイルを書き出し

リップシンクなどに便利な、音声の音素情報とそのタイミング情報が書かれたラベルファイルを一緒に保存します。

### 「外観」項目

#### 行番号の表示

テキスト欄の左に行番号を表示します。

#### テキスト追加ボタンの表示

テキスト追加ボタンを非表示にできます。ショートカットキー `Shift` + `Enter` でテキスト欄を追加できます。

### 「高度な設定」項目

#### マルチエンジン機能

VOICEVOX API 準拠音声合成エンジンを AivisSpeech 内で利用できるようになります。  
マルチエンジン機能をオンにしたあと、メニューにある「音声合成エンジン」の「音声合成エンジンの管理」に移動し、次のどちらかを実行すると利用できます。

- VOICEVOX API 準拠音声合成エンジンの VVPP ファイルをインストールする
- VOICEVOX 系ソフトウェア内の音声合成エンジンのパスを指定する

#### 音声をステレオ化

音声をモノラルからステレオに変換して再生・保存します。

#### 再生デバイス

音声を再生するデバイスを変更できます。

### 「実験的機能」項目

開発中の便利機能を利用できます。

#### 複数選択

複数のテキスト欄を選択できるようになります。  
`Shift` キーを押しながらクリックすることで、最後に選択したテキスト欄からクリックしたテキスト欄までのすべてのテキスト欄を選択できます。  
`Ctrl` キーを押しながらクリックすることで、複数のテキスト欄を個別に選択できます。

### 「データ収集」項目

#### ソフトウェア利用状況のデータ収集を許可する

各 UI の利用率などのデータを送信して AivisSpeech の改善に役立てます。  
入力されたテキストデータや音声データの情報は収集しておりませんのでご安心ください。

## その他

右上のピンボタンでウィンドウを最前面に固定できます。

## ヘルプ

ヘルプドキュメントやライセンスなどを確認できます。

## アンインストール方法

### Windows 版

インストールしたフォルダの中にある Uninstall AivisSpeech.exe を実行してください。

すべての設定データを削除するには、以下のフォルダを削除してください。

- `C:\Users\(ユーザー名)\AppData\Roaming\AivisSpeech`
- `C:\Users\(ユーザー名)\AppData\Roaming\AivisSpeech-Engine`

### Mac 版

「アプリケーション」フォルダにある AivisSpeech を「ゴミ箱」にドラッグ＆ドロップしてください。  

マルチエンジン機能で追加した音声合成エンジンを削除する場合は、Finder のメニューバーの「移動」をクリックし、「フォルダへ移動」をクリックして表示された画面に `~/Library/Application Support/AivisSpeech` と入力して `Enter` キーを押し、`vvpp-engines` フォルダを削除すれば完了です。

すべての設定データを削除するには、以下のフォルダを削除してください。

- `~/Library/Application Support/AivisSpeech`
- `~/Library/Application Support/AivisSpeech-Engine`
- `~/Library/Logs/AivisSpeech`

## ご感想・ご要望・バグ報告など

ご感想・ご要望は、ぜひ Twitter (X) にてハッシュタグ `#AivisSpeech` を付けてツイートしてください。開発の励みになります。

うまく動かない場合や不具合を見つけられた方は、Twitter (X) にて不具合をハッシュタグ `#AivisSpeech` を付けてツイートしていただくか、Aivis Project 公式 ([@aivis_project](https://twitter.com/aivis_project)) までご報告ください。  
[Aivis Project お問い合わせフォーム](https://docs.google.com/forms/d/e/1FAIpQLSd1gi8lMW1mpdrkCHbM090pWmWhKgz4tR1Obc9G9hOuWpZPsA/viewform) からご報告いただくことも可能です。

その他、 Q&A に掲載されていないご質問があれば Aivis Project 公式 ([@aivis_project](https://twitter.com/aivis_project)) または上記のお問い合わせフォームからご連絡ください。
