# 設計に関する詳細方針

## Vuex とダイアログ

ダイアログは外部 API とみなし、Vuex の Store の Action 内から呼ぶことを許容しています。  
これは、ダイアログの結果によってダイアログ前後の挙動を 1 つの Action に書けるという利便性を取ったためです。  
ダイアログの種類によっては View に直接作用してダイアログ UI を表示するものもありますが、これも許容することにしています。

## EngineId、SpeakerId、StyleId

EngineId はエンジンが持つ ID で、世界で唯一かつ不変です。
SpeakerId は話者が持つ ID で、世界で唯一かつ不変。エンジン間でも同じ ID を持ちます。
StyleId はスタイルごとの ID で、エンジンごとに唯一であれば良いです。

声を一意に決めるには、(EngineId, SpeakerId, StyleId)の３組が揃っている必要がある、という仕様を目指しています。
現状は、音声合成 API に SpeakerId 引数が無いため、(EngineId, StyleId)の２組で一意に声が決まっています。
現状は StyleId はエンジンごとに唯一である必要がありますが、話者ごとに唯一であれば良いという仕様を目指しています。

VOICEVOX は歴史的経緯により、 SpeakerId と StyleId が混同していることがあります。
特に型が整数値になっている SpeakerId は StyleId と混同している場合があります。
（エンジン API の SpeakerId 引数に StyleId を渡したりなど。）

StyleId は現在整数値型になっていますが、将来的には Uuid にしたいと考えています。

## シングルファイルコンポーネント（SFC、`.vue`ファイル）の template、script、style の順序

`<template>`、`<script>`、`<style>`の順序で記述してください。

## Zod のスキーマと型定義

Zod のスキーマ（`z.object`）の変数名は、`[camelCaseでの名前]Schema`、型定義（`z.infer`）の名前は、`[PascalCaseでの名前]Type`としてください。

```ts
export const hogeFugaSchema = z.object({
  hoge: z.string(),
  fuga: z.number(),
});

export type HogeFugaType = z.infer<typeof hogeFugaSchema>;
```

## マルチエンジン

エンジンの追加は VVPP ファイルをインストールする形と、エンジンディレクトリのパスを指定する形があります。

|                      | VVPP                                 | パス                                |
| -------------------- | ------------------------------------ | ----------------------------------- |
| `EngineInfo`の`type` | `"vvpp"`                             | `"path"`                            |
| 追加時の処理         | zipファイルを所定のフォルダに展開    | エンジンのパスを`config.json`に保存 |
| 読み込み時の処理     | 所定のフォルダ内にあるものを読む     | `config.json`に保存されたパスを読む |
| 削除時の処理         | 所定のフォルダ内のディレクトリを削除 | `config.json`からパスを削除         |

## デフォルトエンジンの更新情報

デフォルトエンジンの更新情報をjson形式で管理しています。
更新情報には最新のパッケージ（VVPP・VVPPPファイル）のURLやバージョンなどを記載しています。
パッケージの情報はOS・アーキテクチャ・デバイスごとに分けています。

ファイルフォーマットは以下の通りです。

```JSONC
{
  //[number] ファイル構造バージョン（仕様変更毎にインクリメントされる）
  "formatVersion": 1,

  // Windowsの情報
  "windows": {
    "x64": {
      "CPU": {
        //[string] バージョン
        "version": "x.x.x",

        // vvppやvvpppの情報
        "packages": [
          {
            //[string] ダウンロードURL
            "url": "https://example.com/example.vvpp",

            //[string] ファイル名
            "name": "example.vvpp",

            //[number] バイト数
            "size": 123456,

            //[string(Optional)] ハッシュ値
            "hash": "xxxxxxx",
          },
          //...
        ]
      },
      "GPU/CPU": { /* 同上 */ }
    }
  },

  "macos": {
    "x64": {
      "CPU": { /* 同上 */ }
    },
    "arm64": {
      "CPU": { /* 同上 */ }
    }
  },

  "linux": {
    "x64": {
      "CPU": { /* 同上 */ },
      "GPU/CPU": { /* 同上 */ }
    }
  }
}
```
