# フォントの作り方

VOICEVOX では改変したRounded M+ 1pを使用しています。  
具体的には、

- ヒント情報の削除
- ttfからwoff2への変換
を行っています。

## 手順

1. [自家製 Rounded M+ とは](http://jikasei.me/font/rounded-mplus/about.html)から
Rounded M+をダウンロードします。
2. [ttfautohint](https://freetype.org/ttfautohint/)をインストールします。[^longnote]:[ttfautohint-py](https://pypi.org/project/ttfautohint-py/)を使用しました。
3. [woff2](https://github.com/google/woff2)をビルドします。
4. `rounded-mplus-20150529.7z`から`rounded-mplus-1p-（ウェイト）.ttf`を全て`src/fonts`に解凍します。
5. ttfautohintを使用して、Rounded M+のヒント情報を削除します。名前は`Unhinted Rounded M+ 1p`とします。
6. woff2を使用して、ttfからwoff2へ変換します。

[#1103](https://github.com/VOICEVOX/voicevox/pull/1103)の作成には
以下のスクリプトを使用しました（PowerShell 7.3.1）

```pwsh
# cwd：src/fonts
foreach ($f in gci("./*.ttf")){
  py -m ttfautohint -dF " Unhinted" $f.name "unhinted-$($f.name)"
  woff2_compress.exe "unhinted-$($f.name)"
}
```
