# サードパーティ開発者の方へ

## サードパーティが利用するときの注意

### VOICEVOXの基本動作について

VOICEVOXアプリケーションは、大まかに分けるとユーザに見えるGUI（フロントエンド部分）と、音声合成を担当するエンジン（バックエンド部分）で構成されています。通常、VOICEVOXのGUIが起動されると、見えない形でエンジンが（マルチエンジンとして登録されている数だけ）順番に立ち上がる仕組みになっています。サードパーティが音声合成機能を使うためには、裏で立ち上がっているエンジンにアクセスする必要があります。

### VOICEVOXへのアクセスについて

VOICEVOXのエンジンを使用するためには、APIを用いる必要があります。特別な理由がない限り、API以外でのアクセスを避けるようにしてください。（例えば、ファイルを直接書き換えるなどの動作は不具合を引き起こす可能性が高くなるほか、VOICEVOXが事前テストで動作確認できてないような望まない動作を引き起こす可能性があります。）

基本的にVOICEVOXで音声を合成するために必要なAPIはすでに用意されていますが、もしAPIで実現できない機能/操作がある場合は、VOIEVOX の Issue ページにてAPIの実装提案を行う事をお勧めします。

### APIのアクセス先について

HTTP経由でAPIにアクセスできます。

* VOICEVOXエンジンがデフォルトで使用するポート番号は、内部で決まっています（例：50021/tcp）。
* 他のアプリケーションが同じポート番号を使用している場合、競合が発生するため別のポートを開きます。
* 最終的に開いたポート番号については、情報ファイルを参照して特定してください。
* 動的に番号が変更されるのは、VOICEVOX v0.16以降の機能です。

### ランタイム情報ファイル（以下情報ファイル）について

サードパーティが必要な情報を手に入れるために、「情報ファイル」というものが生成されるようになっています。サードパーティの製作者は、まずはこのファイルを参照してアクセス先を決定してください。

また、VOICEVOX内でエンジンが再起動した場合に、通信ポート番号が変わる可能性があります。サードパーティ側でAPI使用中に突如通信失敗が発生した場合は、このファイルが更新されているか確認するようにしてください。

（なお、古いVOICEVOXではこのファイル生成機能が実装されていません。また、動的にポート番号を決定しないバージョンもあります。下位互換性を保つためには、このファイルがない場合も想定してください）

## 情報ファイルについて

### ファイルの場所

ファイルは下記の場所にあります。

|OS              |ファイルパス                                                                 |
|----------------|-----------------------------------------------------------------------------|
|Windows         |C:\Users\（ユーザー名）\AppData\Roaming\voicevox\runtime-info.json           |
|MacOS           |/Users/（ユーザー名）/Library/Application Support/voicevox/runtime-info.json |

なお、Windows のプロファイル設定次第では、上記ファイルの配置が変更されることがあります。確実に場所を特定するためには、環境変数 ``APPDATA`` を用いて、Roamingフォルダの位置を特定してください。

### ファイルの中身と意味

ファイル自体はJSON形式になっています。構造としては下記のような形になります。

```JSONC
{
  //[string] VOICEVOXのバージョン番号
  "appVersion": "xxx.yyy.zzz",

  //[number] ファイル構造バージョン（仕様変更毎にインクリメントされる）
  "formatVersion": 1,

  //エンジンデータ(起動している数だけ)
  "engineInfos": [
    {
      //[string] エンジン通称
      "name": "engine1",
      
      //[string] APIエンドポイント
      "url": "http://127.0.0.1:50021",

      //[UUID] エンジン識別用のUUID
      "uuid": "00000000-0000-0000-0000-000000000001",
    },
    {
      "name": "engine2",
      "url": "http://127.0.0.1:50121",
      "uuid": "00000000-0000-0000-0000-000000000002",
    },
  ]
}
```

### 生成されるタイミング

* エンジンが起動（もしくは再起動）するタイミングでファイルが生成、更新されます。
* 何らかの理由でファイルの書き込み権が取得できなかった場合には更新されません。（更新のタイミングで他ツールがファイルを開いていた場合など）
* この生成タイミングはファイルバージョン１の実装であり、開発の過程で変更される可能性があります。
