# UI/UX デザイン方針

メモ程度ですが、VOICEVOX の UX や UI のデザインの設計方針を共有します。

## 基本方針

- 最も重視していることは、「ユーザーが作ろうとしたコンテンツが完成までたどり着くこと」です
- この思想から、以下のことを意識してデザインしています
  - 使いたくなるように感じること
  - 作業の流れがわかりやすくなっていること
  - 操作のために考える必要がないこと
- また、「より良いコンテンツを作ってもらうこと」も重視しています
- この思想から次のことも意識しています
  - 音声の品質を手軽に高められること
  - クリエイティブなソフトウェアであること

具体的にどういう実装に落とし込まれているかを紹介します。

- 使いたくなるように感じること
  - できる限り多くの人に届くようなソフトウェアにするために、無料で配布し、品質をなるべく高くしています
  - ダサいと感じられないようにするために、新しめの見た目デザインを目指しています
  - 未来のユーザーにネガティブな印象を持たれないようにするために、SNS でネガティブなお気持ちは控え、ユーザーのネガティブな疑問は積極的に解消します
- 作業の流れがわかりやすくなっていること
  - テキスト入力から音声の書き出しまでができるようなファーストビューを意識しています
  - あってもなくても良いような機能はなるべく目立たない UI にしています
- 操作のために考える必要がないこと
  - シンプルな UI を意識しています
  - 難しい単語を避け、シンプルな文面を意識しています
  - ショートカットキーを知らなくても良いような UI にしています
- 音声の品質を手軽に高められること
  - 音声を調声できることがわかるようなファーストビューにしています

### ミッションとソフトウェアの方針の対応

- [ミッション](./ミッション・バリュー・ビジョン.md#ミッション)達成には UGC（ユーザー生成コンテンツ）が最重要だと考えています
  - ユーザーが作ったコンテンツが界隈を広げるという考え方です
- この思想から、より良いコンテンツがより多く作られることをソフトウェアの方針としています

## デザインの意思決定のプロセス

まだ試行錯誤を重ねていますが、だいたいこのような流れで進めています。

1. デザインの外観を Issue などで提案する
   - 考慮抜け漏れを早期に見つけるためのステップです
   - テキストでも手書きの図でもサンプル実装でもなんでも OK です
2. 実際に実装してプルリクエストを作成
   - UI/UX デザインは触ってみないとわからない部分が多いので、実装をお願いする形になります
   - デザインの変更はコード量が少なくても内容がかさばるので、+-合計 80 程度の差分に収めておくとマージまでがスムーズです
3. 問題箇所を洗い出す
4. マージ
5. 全体のデザインを見て必要であればメンテナーが微調整

## 細かいデザインガイドライン

- キャンセルボタンは左
- ダイアログとトーストの使い分け
  - ユーザーの操作に起因し、かつエラーや頻度が低いフィードバックにはダイアログを表示（`SHOW_DIALOG_`系）
    - 例: ［エンジンの再起動が必要です］エンジンが停止しているため、音声を生成できません。エンジンを再起動しますか？［再起動しない/再起動する］
  - それ以外はトーストで通知（`SHOW_NOTIFY_`系）
    - 例: 音声を書き出しました。
    - 例: エンジンが異常終了しました。エンジンの再起動が必要です。
- ダイアログの warning と confirm の使い分け
  - 続行することが望まれそうな場合は confirm
  - キャンセルすることが望まれそうな場合は warning

## 文章など

### VOICEVOX 専用 UI の名称

🚷 のマークがついてるものはまだユーザー向けの名称ではないもの（案内で使わない）

具体的にどのファイルと対応しているかについては、[UI 名称と Vue ファイル名の対応早見表](UI名称とVueファイル名の対応早見表.md) もご参照ください。

- メニュー ･･･ 最上段のバー、ファイルや設定などの項目がある
  - ピンボタン 🚷 ･･･ 閉じるボタン辺りの横にある最前面固定機能
- ツールバー ･･･ メニューの下にあるバー、カスタマイズが可能
- キャラクター表示欄 🚷 ･･･ 画面左にあるパネル
- 台本欄 🚷 ･･･ テキスト欄などがあるパネル
  - レーン 🚷 ･･･ テキスト１行が含まれる区画、ユーザー向けにはこれを指して「テキスト欄」と呼ぶこともある
    - 行番号 ･･･ レーンの番号、レーンがユーザー向けになったら「レーン番号」へ
    - キャラクターアイコン ･･･ キャラクターやスタイルを変更できるボタン
    - テキスト欄 ･･･ 音声合成するためのテキストを入力する区画
  - テキスト追加ボタン ･･･ レーンを追加するボタン
- パラメータ調整欄 🚷 ･･･ 画面右にあるパラメータなどを調整できるパネル
- 詳細調整欄 🚷 ･･･ 画面下にあるイントネーションなどを調整できるパネル
  - 項目 ･･･ 詳細調整欄のイントネーションやアクセントなどの選択ボタン
  - 再生ボタン ･･･ 音声を再生できるボタン
  - アクセント区間 ･･･ １つのアクセント句を表示する区画（より良い名称を求む）
  - 文字ごとの区間 🚷 ･･･ アクセント区画の１文字の表示区画、ユーザー向けには「文字ごと」と呼ぶこともある
  - 読み ･･･ 読み仮名の表示区画

#### その他の UI パーツ

- 欄 ･･･ 視覚的に区切られている場所のこと
- パラメータの直接入力 🚷 ･･･ パラメータをクリックして直接入力できる区画、普通のテキスト表示と何ら変わらないので名称が無い
- スライダー ･･･ アクセントや話速などを調整できる
- 選択中のレーン・アクセント区間 🚷 ･･･ アクティブなレーン・アクセント区間のこと

### その他の概念の名称

- ユーザーに提示する場合は「ディレクトリ」ではなく「フォルダ」
- マルチエンジン周り
  - VOICEVOX API 準拠エンジンのことは「エンジン」
    - VOICEVOX のエンジンなのか準拠エンジンなのかわからない場合は「VOICEVOX 準拠エンジン」
  - VVPP ファイルはそのまま「VVPP ファイル」、説明が必要なら「VOICEVOX 準拠エンジンパッケージ」
- VOICEVOX エディターと同じ UI を用いたソフトウェアの総称は「VOICEVOX 系ソフトウェア」
  - 正式名称は「VOICEVOX 系統 UI ソフトウェア」、長いのでほぼ使わない

### 文体

- アルファベットは半角
- 括弧は全角
  - ただし、中身が全て半角文字の場合に限り、括弧も半角
- です/ます調
- 項目名は名詞で終わる（体言止め）
- button の中身は「～する」

### tooltip

- 文末には句点を付ける
- 文末に括弧を付ける場合、括弧の外に句点を出す
  - 例: このようにします（ただし注意が必要です）。
- radio は「選べます。」
- select は「変更できます。」
- button は「～できます。」
- checkbox
  - ○○ 機能は「○○ 機能を有効にします。～～になります。」
  - デフォルトが OFF なら「ON の場合、～～れます/ません。」
  - デフォルトが ON なら「OFF の場合、～～れません/ます。」
